/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.usages;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import javax.swing.SwingUtilities;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.Version;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.Preferences;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.usages.UsageData;
import oracle.ide.usages.UsagesTracker;
import oracle.ide.util.Assert;
import oracle.ide.webupdate.UniqueUserId;
import oracle.ide.xml.XMLUtil;
import oracle.ideimpl.usages.EditorUsageTracker;
import oracle.ideimpl.usages.FileSender;
import oracle.ideimpl.usages.OptInHandler;
import oracle.ideimpl.usages.UsageDataImpl;
import oracle.ideimpl.usages.UsagesPrefs;
import oracle.ideimpl.usages.UsagesPrefsChangeListener;
import oracle.ideimpl.usages.UserActivities;
import oracle.ideimpl.usages.UserSystemInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import org.openide.util.RequestProcessor;

public final class UsagesTrackerImpl
extends UsagesTracker {
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"/usages-tracking-data");
    private static final String ROOT_TAG = "usages";
    private static final String LOG_FILE_PREFIX = "jdev-usages-";
    private static final String LOG_FILE_EXTENSION = ".log";
    private static final String USAGES_TRACKING_ENABLED_PROPERTY = "usages.tracking.enabled";
    private static final String RETAIN_USAGES_TRACKING_LOGS_PROPERTY = "retain.usages.tracking.logs";
    private static final boolean DISABLE_DEFAULT_EDITOR_TRACKING = Boolean.getBoolean("disable.default.editor.tracking");
    private static final RequestProcessor REQUEST_PROCESSOR = new RequestProcessor(UsagesTrackerImpl.class);
    private HashStructure _hash;
    private URL _extensionDir;
    private String _baseLogFileName;
    private Long _startTime;
    private boolean _userHasOptedInOut;
    private ShutdownHook _shutDownHook;
    private EditorListener _editorListener;
    private static final UsageData NULL_USAGE = new NullUsageData();
    private static final LogFileFilter LOG_FILE_FILTER = new LogFileFilter();

    public void initTracker() {
        this._hash = HashStructure.newInstance();
        this._startTime = System.currentTimeMillis();
        this.initializeUserSystemProperties(this._hash, this._startTime);
        String property = System.getProperty(USAGES_TRACKING_ENABLED_PROPERTY);
        if (property != null) {
            this.setUserOption(Boolean.valueOf(property));
            return;
        }
        final UsagesPrefs usagesPrefs = UsagesPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
        this._userHasOptedInOut = usagesPrefs.containsKey("track-usages");
        if (!this._userHasOptedInOut) {
            if (Boolean.getBoolean("ide.debugbuild")) {
                usagesPrefs.setTrackUsages(false);
            } else {
                usagesPrefs.setTrackUsages(true);
                IdeArgs args = Ide.getIdeArgs();
                if (!args.hasArg("-nonag")) {
                    final OptInHandler optInHandler = new OptInHandler();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            optInHandler.showPrompt();
                            UsagesTrackerImpl.this.setUserOption(usagesPrefs.isTrackUsages());
                        }
                    });
                } else {
                    this.setUserOption(usagesPrefs.isTrackUsages());
                }
            }
        } else {
            this.setUserOption(usagesPrefs.isTrackUsages());
        }
        UsagesPrefsChangeListener prefsChangeListener = new UsagesPrefsChangeListener(this);
        usagesPrefs.addStructureChangeListener(prefsChangeListener);
    }

    public UsageData createUsageData() {
        if (!UsagesTrackerImpl.isOn()) {
            return NULL_USAGE;
        }
        return UsageDataImpl.newInstance(HashStructure.newInstance());
    }

    public void report(UsageData usageData) {
        if (!UsagesTrackerImpl.isOn()) {
            return;
        }
        Assert.check((usageData != null ? 1 : 0) != 0, (String)"UsageData should not be null.");
        UsageDataImpl dataImpl = (UsageDataImpl)usageData;
        dataImpl.setEventTimeStamp(System.currentTimeMillis());
        UserActivities activities = UserActivities.getInstance(this._hash);
        activities.addActivity(dataImpl.getHashStructure());
        if (activities.maxActivities()) {
            final HashStructure h = this._hash.copyTo(null);
            UserActivities.getInstance(this._hash).clearActivityList();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    UsagesTrackerImpl.this.logToFile(h);
                    boolean dayElapsed = UsagesTrackerImpl.this.hasDayElapsed();
                    if (dayElapsed) {
                        UsagesTrackerImpl.this.processUnsentLogs();
                    }
                }
            };
            REQUEST_PROCESSOR.execute(runnable);
        }
    }

    void setUserOption(boolean optIn) {
        _isOn = optIn;
        this.purgeAndProcessLogs();
        this.configureListeners();
    }

    private void logToFile(HashStructure hash) {
        HashStructureIO io = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        try {
            URL url = this.uniqueLogFileURL();
            io.save(url, (Object)hash);
            Assert.println((String)URLFileSystem.getPlatformPathName((URL)url));
            File file = new File(url.getPath());
            if (FileSender.getInstance().logToServer(file)) {
                this.deleteFile(file);
            }
        }
        catch (IOException e) {
            Assert.printStackTrace((Throwable)e);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private URL uniqueLogFileURL() {
        String fileName = this.baseLogFileName() + System.currentTimeMillis() + LOG_FILE_EXTENSION;
        URL url = URLFactory.newURL((URL)this.extensionDir(), (String)fileName);
        return URLFactory.newFileURL((File)new File(url.getPath()));
    }

    private String baseLogFileName() {
        if (this._baseLogFileName == null) {
            StringBuilder b = new StringBuilder();
            b.append(LOG_FILE_PREFIX);
            String userId = UserSystemInfo.getInstance(this._hash).getUserId();
            if (userId.length() > 1 && userId.endsWith(";")) {
                b.append(userId.substring(0, userId.length() - 1));
            } else {
                b.append(userId);
            }
            b.append('_');
            this._baseLogFileName = b.toString();
        }
        return this._baseLogFileName;
    }

    private URL extensionDir() {
        if (this._extensionDir == null) {
            this._extensionDir = ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.ide.usages-tracking");
        }
        return this._extensionDir;
    }

    private void processUnsentLogs() {
        boolean loggedSuccessfully;
        File[] logFiles = this.getPendingLogs();
        if (logFiles != null && logFiles.length > 0 && (loggedSuccessfully = FileSender.getInstance().logToServer(logFiles))) {
            for (File file : logFiles) {
                this.deleteFile(file);
            }
        }
    }

    private File[] getPendingLogs() {
        File tempDir = new File(this.extensionDir().getPath());
        return tempDir.listFiles(LOG_FILE_FILTER);
    }

    private void deleteFile(File file) {
        if (Boolean.getBoolean(RETAIN_USAGES_TRACKING_LOGS_PROPERTY)) {
            this.backupFile(file);
            return;
        }
        try {
            URI uri = file.toURI();
            URL url = uri.toURL();
            URLFileSystem.delete((URL)url);
        }
        catch (MalformedURLException e) {
            file.deleteOnExit();
        }
    }

    private void backupFile(File file) {
        try {
            URL logFileURL = file.toURI().toURL();
            URL folder = URLFactory.newDirURL((String)file.getParent());
            String newName = file.getName() + ".bak";
            URL bakFileURL = URLFactory.newURL((URL)folder, (String)newName);
            boolean success = URLFileSystem.renameTo((URL)logFileURL, (URL)bakFileURL);
            Assert.println((String)String.format("%s %s %s %s %s", "Rename", URLFileSystem.getPlatformPathName((URL)logFileURL), "to\n             ", URLFileSystem.getPlatformPathName((URL)bakFileURL), success ? "succeeded" : "failed"));
        }
        catch (MalformedURLException e) {
            Assert.println((String)("Failed to backup log file: " + file));
            Assert.printStackTrace((Throwable)e);
        }
    }

    private void purgeOldLogs() {
        File[] logs = this.getPendingLogs();
        if (logs != null && logs.length > 0) {
            for (File file : logs) {
                this.maybePurgeFile(file);
            }
        }
    }

    private void maybePurgeFile(File file) {
        long modifiedTime = file.lastModified();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        if (calendar.after(modifiedTime)) {
            this.deleteFile(file);
        }
    }

    private boolean hasDayElapsed() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return calendar.after(this._startTime);
    }

    private void purgeAndProcessLogs() {
        if (!UsagesTrackerImpl.isOn()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                UsagesTrackerImpl.this.purgeOldLogs();
                UsagesTrackerImpl.this.processUnsentLogs();
            }
        };
        REQUEST_PROCESSOR.execute(runnable);
    }

    private void configureListeners() {
        if (UsagesTrackerImpl.isOn()) {
            ExitCommand.addShutdownHook((ShutdownHook)this.getShutdownHook());
            if (!DISABLE_DEFAULT_EDITOR_TRACKING) {
                EditorManager.getEditorManager().addEditorListener(this.getEditorListener());
            }
        } else {
            if (this._shutDownHook != null) {
                ExitCommand.removeShutdownHook((ShutdownHook)this._shutDownHook);
            }
            if (!DISABLE_DEFAULT_EDITOR_TRACKING && this._editorListener != null) {
                EditorManager.getEditorManager().removeEditorListener(this._editorListener);
            }
        }
    }

    private ShutdownHook getShutdownHook() {
        if (this._shutDownHook == null) {
            this._shutDownHook = new ShutdownHandler();
        }
        return this._shutDownHook;
    }

    private EditorListener getEditorListener() {
        if (this._editorListener == null) {
            this._editorListener = new EditorUsageTracker();
        }
        return this._editorListener;
    }

    private String uniqueUserId() {
        return UniqueUserId.getOrCreateId((PropertyStorage)Preferences.getPreferences());
    }

    private void initializeUserSystemProperties(HashStructure hashStructure, Long currentTimeMillis) {
        UserSystemInfo userAndSystemInfo = UserSystemInfo.getInstance(hashStructure);
        userAndSystemInfo.setUserId(this.uniqueUserId());
        userAndSystemInfo.setSessionId(currentTimeMillis.toString());
        userAndSystemInfo.setSessionStarted(currentTimeMillis);
        userAndSystemInfo.setBuildLabel(Version.BUILD_LABEL);
        userAndSystemInfo.setDevBuild(System.getProperty("ide.devbuild"));
        userAndSystemInfo.setJdkVersion(System.getProperty("java.version"));
        userAndSystemInfo.setOS(System.getProperty("os.name"));
        userAndSystemInfo.setProductEdition(System.getProperty("ide.editions"));
        userAndSystemInfo.setProductName(Ide.getProgramName());
        userAndSystemInfo.setProductVersion(Version.VER_FULL);
        userAndSystemInfo.setRole(System.getProperty("ide.role"));
    }

    private static class LogFileFilter
    implements FilenameFilter {
        private LogFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name != null && name.startsWith(UsagesTrackerImpl.LOG_FILE_PREFIX) && name.endsWith(UsagesTrackerImpl.LOG_FILE_EXTENSION);
        }
    }

    private class ShutdownHandler
    implements ShutdownHook {
        private ShutdownHandler() {
        }

        public boolean canShutdown() {
            return true;
        }

        public void shutdown() {
            if (!UsagesTracker.isOn()) {
                return;
            }
            UserSystemInfo.getInstance(UsagesTrackerImpl.this._hash).setSessionEnded(System.currentTimeMillis());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    UsagesTrackerImpl.this.logToFile(UsagesTrackerImpl.this._hash);
                }
            };
            REQUEST_PROCESSOR.execute(runnable);
        }
    }

    private static class NullUsageData
    extends UsageDataImpl {
        public NullUsageData() {
            super(HashStructure.newInstance());
        }
    }
}

