/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.usages;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.util.Assert;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.usages.ServerLocation;
import oracle.ideimpl.usages.ServerLocations;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;

public final class FileSender {
    private static final FileSender _instance = new FileSender();
    private List<ServerLocation> _uploadServers;

    private FileSender() {
    }

    public static FileSender getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logToServer(File ... logFiles) {
        if (logFiles == null || logFiles.length == 0) {
            return false;
        }
        List<ServerLocation> servers = this.getUsageServers();
        if (servers.isEmpty()) {
            return false;
        }
        boolean success = false;
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            for (File file : logFiles) {
                FileBody body = new FileBody(file);
                builder.addPart(body.getFilename(), (ContentBody)body);
            }
            HttpEntity entity = builder.build();
            Iterator<ServerLocation> serverIterator = servers.iterator();
            while (!success && serverIterator.hasNext()) {
                ServerLocation server = serverIterator.next();
                HttpPost post = new HttpPost(server.getUrl());
                post.setEntity(entity);
                HttpClientBuilder clientBuilder = HttpClients.custom();
                clientBuilder.setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy()).setUserAgent("Usage Tracker");
                FileSender.maybeConfigureProxySettings(clientBuilder);
                client = clientBuilder.build();
                response = client.execute((ClassicHttpRequest)post);
                if (response.getCode() == 200) {
                    success = true;
                    continue;
                }
                serverIterator.remove();
                Assert.println((String)response.getReasonPhrase());
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (client != null) {
                    client.close();
                }
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
            }
        }
        return success;
    }

    private static void maybeConfigureProxySettings(HttpClientBuilder clientBuilder) {
        ProxyOptions options = ProxyOptions.getProxyOptions();
        RequestConfig config = null;
        BasicCredentialsProvider credentialsPovider = null;
        if (options.getUseProxy().booleanValue()) {
            String host = options.getProxyHost();
            int port = Integer.parseInt(options.getProxyPort());
            HttpHost proxy = new HttpHost(host, port);
            RequestConfig.Builder configBuilder = RequestConfig.custom();
            configBuilder.setProxy(proxy);
            config = configBuilder.build();
            clientBuilder.setDefaultRequestConfig(config);
            if (options.getUseProxyAuthentication().booleanValue()) {
                credentialsPovider = new BasicCredentialsProvider();
                AuthScope authScope = new AuthScope(host, port);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(options.getProxyUserName(), options.getProxyPassword());
                credentialsPovider.setCredentials(authScope, (Credentials)credentials);
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsPovider);
            }
        }
    }

    private List<ServerLocation> getUsageServers() {
        if (this._uploadServers == null || this._uploadServers.size() == 0) {
            this._uploadServers = new ArrayList<ServerLocation>(ServerLocations.getServers());
        }
        return this._uploadServers;
    }
}

