/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.em_cm;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.em_cm.CmAddin;
import oracle.dbtools.em_cm.CmAddinArb;
import oracle.dbtools.em_cm.CmPopupAction;
import oracle.dbtools.em_cm.CmUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItem;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItemInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlan;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanAccessException;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;

public class CmController
implements Controller,
ContextMenuListener,
ActionListener {
    private static CmController _instance;
    public static int DISCONNECT_ACTION;
    public static int ADD_PLAN_ACTION;
    public static int REMOVE_PLAN_ACTION;
    public static int REFRESH_PLAN_ACTION;
    public static int REMOVE_ITEM_ACTION;
    public static int REFRESH_ITEM_ACTION;
    public static int PRE_ACTION;
    public static int POST_ACTION;
    private static IdeAction cmDisconnect;
    private static IdeAction cmPlanAdd;
    private static IdeAction cmPlanRemove;
    private static IdeAction cmPlanRefresh;
    private static IdeAction cmItemRemove;
    private static IdeAction cmItemRefresh;
    private static IdeAction cmPre;
    private static IdeAction cmPost;
    private static JLabel lblPlan;
    private static JTextField tfdPlan;
    private static JEWTDialog actionDialog;
    private static Connection _conn;
    private static BasicEditorPane _sql;
    private static boolean createActions;

    private CmController() {
        this.createAction();
    }

    public static synchronized CmController getInstance() {
        if (_instance == null) {
            _instance = new CmController();
        }
        return _instance;
    }

    public Connection getConnection() {
        return _conn;
    }

    public IdeAction getPlanAddAction() {
        return cmPlanAdd;
    }

    public IdeAction getPlanRemAction() {
        return cmPlanRemove;
    }

    public IdeAction getPlanRefAction() {
        return cmPlanRefresh;
    }

    private void createAction() {
        if (!createActions) {
            return;
        }
        createActions = false;
        cmDisconnect = IdeAction.get((int)DISCONNECT_ACTION);
        cmPlanAdd = IdeAction.get((int)ADD_PLAN_ACTION);
        cmPlanRemove = IdeAction.get((int)REMOVE_PLAN_ACTION);
        cmPlanRefresh = IdeAction.get((int)REFRESH_PLAN_ACTION);
        cmItemRefresh = IdeAction.get((int)REFRESH_ITEM_ACTION);
        cmItemRemove = IdeAction.get((int)REMOVE_ITEM_ACTION);
        cmPre = IdeAction.get((int)PRE_ACTION);
        cmPost = IdeAction.get((int)POST_ACTION);
        this.toggleToolar(false);
    }

    public void installTableToolbar(Toolbar toolbar) {
        Action[] actionArray;
        boolean bl = true;
        for (Action action : actionArray = toolbar.getActions()) {
            if (action != cmItemRemove) continue;
            bl = false;
            break;
        }
        if (bl) {
            toolbar.add((ToggleAction)cmItemRemove);
            toolbar.add((ToggleAction)cmItemRefresh);
        }
    }

    public void installToolbar(Toolbar toolbar) {
        Action[] actionArray;
        boolean bl = true;
        for (Action action : actionArray = toolbar.getActions()) {
            if (action != cmDisconnect) continue;
            bl = false;
            break;
        }
        if (bl) {
            toolbar.add((ToggleAction)cmDisconnect);
            toolbar.addSeparator();
            toolbar.add((ToggleAction)cmPre);
            toolbar.add((ToggleAction)cmPost);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == DISCONNECT_ACTION) {
            this.Logout(true);
            return true;
        }
        if (ideAction.getCommandId() == ADD_PLAN_ACTION) {
            this.AddPlanDialog();
            return true;
        }
        if (ideAction.getCommandId() == PRE_ACTION) {
            try {
                String string = CmUtil.getPlan().getPreScript();
                _sql = EditorFactory.createIdeEditorPane();
                _sql.setDocument((Document)new BasicDocument("foo.plsql"));
                _sql.setPreferredSize(new Dimension(300, 200));
                _sql.setText(string);
                _sql.setEditable(true);
                JScrollPane jScrollPane = new JScrollPane((Component)_sql, 22, 32);
                jScrollPane.setPreferredSize(_sql.getPreferredSize());
                jScrollPane.setSize(jScrollPane.getPreferredSize());
                actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jScrollPane, null, (String)CmAddinArb.getString("PRE_SCRIPT"), (int)10);
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                            try {
                                CmUtil.getPlan().setPreScript(_sql.getText());
                            }
                            catch (Exception exception) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            }
                        }
                        actionDialog.setVisible(false);
                        actionDialog.dispose();
                    }
                };
                actionDialog.addActionListener(actionListener);
                actionDialog.setSize(_sql.getPreferredSize());
                actionDialog.setPreferredSize(_sql.getPreferredSize());
                IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)actionDialog);
                actionDialog.setVisible(true);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == POST_ACTION) {
            try {
                String string = CmUtil.getPlan().getPostScript();
                _sql = EditorFactory.createIdeEditorPane();
                _sql.setDocument((Document)new BasicDocument("foo.plsql"));
                _sql.setPreferredSize(new Dimension(300, 200));
                _sql.setText(string);
                _sql.setEditable(true);
                JScrollPane jScrollPane = new JScrollPane((Component)_sql, 22, 32);
                jScrollPane.setPreferredSize(_sql.getPreferredSize());
                jScrollPane.setSize(jScrollPane.getPreferredSize());
                actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jScrollPane, null, (String)CmAddinArb.getString("POST_SCRIPT"), (int)10);
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                            try {
                                CmUtil.getPlan().setPostScript(_sql.getText());
                            }
                            catch (Exception exception) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            }
                        }
                        actionDialog.setVisible(false);
                        actionDialog.dispose();
                    }
                };
                actionDialog.addActionListener(actionListener);
                actionDialog.setSize(_sql.getPreferredSize());
                actionDialog.setPreferredSize(_sql.getPreferredSize());
                IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)actionDialog);
                actionDialog.setVisible(true);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == REMOVE_PLAN_ACTION) {
            if (CmUtil.getPlanInfo() == null) {
                return true;
            }
            JLabel jLabel = new JLabel(CmAddinArb.getString("DELETE_PLAN") + CmUtil.getPlanInfo().getPlanName());
            actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jLabel, null, (String)CmAddinArb.getString("DELETE_PLAN_TITLE"), (int)10);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                        try {
                            ChangePlanInfo changePlanInfo = CmUtil.getPlanInfo();
                            CmAddin.getCpAccess().removeChangePlan(changePlanInfo.getPlanName(), changePlanInfo.getPlanOwner());
                            CmController.this.getConnection().commit();
                            CmUtil.getPanel().getPlanModel().setSelectedItem(null);
                            CmUtil.getPanel().getPlanModel().removeRow(changePlanInfo);
                            CmUtil.getPanel().getPlanModel().fireContentsChanged(this, 0, CmUtil.getPanel().getPlanModel().getSize());
                            CmUtil.getPanel().getTableModel().clear();
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                    actionDialog.setVisible(false);
                    actionDialog.dispose();
                }
            };
            actionDialog.addActionListener(actionListener);
            actionDialog.setSize(400, 100);
            actionDialog.setPreferredSize(400, 100);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)actionDialog);
            actionDialog.setVisible(true);
            return true;
        }
        if (ideAction.getCommandId() == REFRESH_PLAN_ACTION) {
            try {
                ChangePlanInfo changePlanInfo = CmUtil.getPlanInfo();
                ChangePlanInfo[] changePlanInfoArray = CmAddin.getCpAccess().getChangePlans();
                if (changePlanInfoArray != null && changePlanInfoArray.length > 0) {
                    CmUtil.getPanel().getPlanModel().addList(changePlanInfoArray);
                }
                if (changePlanInfo != null) {
                    CmUtil.getPanel().getPlanModel().setSelectedItem(changePlanInfo);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == REFRESH_ITEM_ACTION) {
            CmUtil.getPanel().loadItemTable(CmUtil.getPlanInfo());
            return true;
        }
        if (ideAction.getCommandId() == REMOVE_ITEM_ACTION) {
            try {
                ChangePlan changePlan = CmUtil.getPlan();
                int n = CmUtil.getPanel().getTable().getSelectedRow();
                if (n == -1) {
                    return true;
                }
                ChangeItemInfo changeItemInfo = CmUtil.getTableModel().getRow(n);
                changePlan.removeChangeItem(changeItemInfo);
                CmUtil.getTableModel().removeRow(changeItemInfo);
                this.getConnection().commit();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void AddPlanDialog() {
        String string = CmAddinArb.getString("ADD_PLAN_TITLE");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)lblPlan, (Component)tfdPlan, (String)CmAddinArb.getString("PLAN_LABEL"));
        jPanel.add((Component)lblPlan, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)tfdPlan, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_cmAddPlan_html");
        actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                    CmController.this.addPlan();
                }
                actionDialog.setVisible(false);
                actionDialog.dispose();
            }
        };
        actionDialog.addActionListener(actionListener);
        Dimension dimension = jPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 150;
        actionDialog.setSize(n2, n);
        actionDialog.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)actionDialog);
        actionDialog.setVisible(true);
    }

    private void addPlan() {
        try {
            ChangePlanInfo changePlanInfo = new ChangePlanInfo(tfdPlan.getText(), this.getConnection().getMetaData().getUserName());
            CmAddin.getCpAccess().createChangePlan(changePlanInfo);
            this.getConnection().commit();
            CmUtil.getPanel().getPlanModel().addRow(changePlanInfo);
            CmUtil.getPanel().getPlanModel().setSelectedItem(changePlanInfo);
            CmUtil.getPanel().loadItemTable(changePlanInfo);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private void toggleToolar(boolean bl) {
        cmDisconnect.setEnabled(bl);
        cmPlanAdd.setEnabled(bl);
        cmPlanRemove.setEnabled(bl);
        cmPlanRefresh.setEnabled(bl);
        cmPre.setEnabled(bl);
        cmPost.setEnabled(bl);
        cmItemRefresh.setEnabled(bl);
        cmItemRemove.setEnabled(bl);
    }

    public void Login(final Connection connection) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(CmAddinArb.getString("LOGIN_TASK_NAME"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    _conn = connection;
                    CmAddin.getCpAccess().login(_conn);
                    if (CmAddin.getCpAccess().isValidConnection()) {
                        final ChangePlanInfo[] changePlanInfoArray = CmAddin.getCpAccess().getChangePlans();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CmController.this.toggleToolar(true);
                                if (changePlanInfoArray != null && changePlanInfoArray.length > 0) {
                                    CmUtil.getPanel().getPlanModel().addList(changePlanInfoArray);
                                }
                            }
                        });
                    } else {
                        CmController.this.Logout(true);
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)CmAddinArb.getString("BAD_CONNECTION"), (String)CmAddinArb.getString("BAD_CONNECTION_TITLE"), null);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    this.setMessage(CmAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    protected void Logout(boolean bl) {
        block6: {
            try {
                try {
                    if (_conn != null) {
                        CmAddin.getCpAccess().logout();
                        Connections.getInstance().closeConnection(Connections.getInstance().getConnectionName(_conn));
                    }
                    _conn = null;
                }
                catch (ChangePlanAccessException changePlanAccessException) {
                    _conn = null;
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ boolean val$clear;
                        {
                            this.val$clear = bl;
                        }

                        @Override
                        public void run() {
                            CmController.this.toggleToolar(false);
                            CmUtil.getPanel().getPlanModel().clearList();
                            CmUtil.getPanel().getTableModel().clear();
                            if (this.val$clear) {
                                CmUtil.getPanel().clearConnection();
                            }
                        }
                    });
                    break block6;
                }
                catch (Throwable throwable) {
                    _conn = null;
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Action action;
        int n = -666;
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem && (action = ((JMenuItem)object).getAction()) instanceof CmPopupAction) {
            n = ((CmPopupAction)action).getId();
        }
        if (n == -95) {
            this.deleteItem((CmPopupAction)((JMenuItem)actionEvent.getSource()).getAction());
        } else if (n == 2) {
            this.updateItem((CmPopupAction)((JMenuItem)actionEvent.getSource()).getAction(), 2);
        } else if (n == 1) {
            this.updateItem((CmPopupAction)((JMenuItem)actionEvent.getSource()).getAction(), 1);
        } else if (n == 3) {
            this.updateItem((CmPopupAction)((JMenuItem)actionEvent.getSource()).getAction(), 3);
        } else if (n == 4) {
            this.updateItem((CmPopupAction)((JMenuItem)actionEvent.getSource()).getAction(), 4);
        } else if (n == -90) {
            this.showDDL((CmPopupAction)((JMenuItem)actionEvent.getSource()).getAction());
        } else if (n == -99) {
            this.syncItem((CmPopupAction)((JMenuItem)actionEvent.getSource()).getAction());
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, actionEvent.getActionCommand(), actionEvent);
        }
    }

    private void showDDL(CmPopupAction cmPopupAction) {
        String string;
        ChangeItem changeItem = (ChangeItem)cmPopupAction.getValue("ChangeItem");
        _sql = EditorFactory.createIdeEditorPane();
        _sql.setDocument((Document)new BasicDocument("foo.plsql"));
        _sql.setPreferredSize(new Dimension(600, 400));
        try {
            string = changeItem.getDDL((XMLAccessorClient)CmUtil.getAccessor());
        }
        catch (Exception exception) {
            string = exception.getLocalizedMessage();
        }
        _sql.setText(string);
        _sql.setEditable(true);
        JScrollPane jScrollPane = new JScrollPane((Component)_sql, 22, 32);
        jScrollPane.setPreferredSize(_sql.getPreferredSize());
        jScrollPane.setSize(jScrollPane.getPreferredSize());
        actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jScrollPane, null, (String)CmAddinArb.getString("SHOW_DDL_TITLE"), (int)16);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                actionDialog.setVisible(false);
                actionDialog.dispose();
            }
        };
        actionDialog.addActionListener(actionListener);
        actionDialog.setSize(_sql.getPreferredSize());
        actionDialog.setPreferredSize(_sql.getPreferredSize());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)actionDialog);
        actionDialog.setVisible(true);
    }

    private void updateItem(CmPopupAction cmPopupAction, int n) {
        try {
            ChangeItem changeItem = (ChangeItem)cmPopupAction.getValue("ChangeItem");
            CmUtil.updateItem(changeItem, n, null);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void syncItem(CmPopupAction cmPopupAction) {
        try {
            ChangeItem changeItem = (ChangeItem)cmPopupAction.getValue("ChangeItem");
            CmUtil.syncItem(changeItem, null);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void deleteItem(CmPopupAction cmPopupAction) {
        try {
            ChangeItemInfo changeItemInfo = (ChangeItemInfo)cmPopupAction.getValue("ChangeInfo");
            CmUtil.deleteItem(changeItemInfo);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    static {
        DISCONNECT_ACTION = Ide.findOrCreateCmdID((String)"cm_disconnect");
        ADD_PLAN_ACTION = Ide.findOrCreateCmdID((String)"cm_plan_add");
        REMOVE_PLAN_ACTION = Ide.findOrCreateCmdID((String)"cm_plan_remove");
        REFRESH_PLAN_ACTION = Ide.findOrCreateCmdID((String)"cm_plan_refresh");
        REMOVE_ITEM_ACTION = Ide.findOrCreateCmdID((String)"cm_item_remove");
        REFRESH_ITEM_ACTION = Ide.findOrCreateCmdID((String)"cm_item_refresh");
        PRE_ACTION = Ide.findOrCreateCmdID((String)"cm_pre");
        POST_ACTION = Ide.findOrCreateCmdID((String)"cm_post");
        lblPlan = new JLabel();
        tfdPlan = new JTextField(40);
        createActions = true;
    }
}

