/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.io.Serializable;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.spatial.rdf.server.BGPNodeInfo;
import oracle.spatial.rdf.server.BasicGraphPattern;
import oracle.spatial.rdf.server.DBDictionaryInfo;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.HintGenerator;
import oracle.spatial.rdf.server.HintZeroHintGenerator;
import oracle.spatial.rdf.server.OracleDatabaseVersion;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.RRTabRowInfo;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SPARQLTriplesBlock;
import oracle.spatial.rdf.server.SPMComponents;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SpatialFilterHandler;
import oracle.spatial.rdf.server.TPOmap;
import oracle.spatial.rdf.server.TriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.ASTBuiltInCall;
import oracle.spatial.rdf.server.parser.sparql.ASTComparisonOperator;
import oracle.spatial.rdf.server.parser.sparql.ASTIRIrefOrFunction;
import oracle.spatial.rdf.server.parser.sparql.ASTRelationalExpression;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ASTUnaryOperator;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.predVarMapping;

public class RelationalBGP
implements SPARQLBGP {
    public static final int VARCHAR2_SIZE_LIMIT = 4000;
    public static final String XSD_PREFIX = "http://www.w3.org/2001/XMLSchema#";
    public static final String XSD_STRING_NO_ENCLOSING = "http://www.w3.org/2001/XMLSchema#string";
    public static final String XSD_FLOAT_NO_ENCLOSING = "http://www.w3.org/2001/XMLSchema#float";
    public static final String XSD_DOUBLE_NO_ENCLOSING = "http://www.w3.org/2001/XMLSchema#double";
    public static final String XSD_DATE_NO_ENCLOSING = "http://www.w3.org/2001/XMLSchema#date";
    public static final String XSD_DATETIME_NO_ENCLOSING = "http://www.w3.org/2001/XMLSchema#dateTime";
    public static final String XSD_DECIMAL_NO_ENCLOSING = "http://www.w3.org/2001/XMLSchema#decimal";
    public static final String XSD_STRING = "<http://www.w3.org/2001/XMLSchema#string>";
    public static final String XSD_FLOAT = "<http://www.w3.org/2001/XMLSchema#float>";
    public static final String XSD_DOUBLE = "<http://www.w3.org/2001/XMLSchema#double>";
    public static final String XSD_DATE = "<http://www.w3.org/2001/XMLSchema#date>";
    public static final String XSD_DATETIME = "<http://www.w3.org/2001/XMLSchema#dateTime>";
    public static final String XSD_DECIMAL = "<http://www.w3.org/2001/XMLSchema#decimal>";
    private static final String FORMAT_TZ = "TZH:TZM";
    private static final String FORMAT_DATE = "SYYYY-MM-DD";
    private static final String FORMAT_DATE_TZ = "SYYYY-MM-DDTZH:TZM";
    private static final String FORMAT_TIMESTAMP = "SYYYY-MM-DD\"T\"HH24:MI:SS.FF9";
    private static final String FORMAT_TIMESTAMP_TZ = "SYYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM";
    private static final int VN_IDX = 0;
    private static final int VT_IDX = 1;
    private static final int LT_IDX = 2;
    private static final int LA_IDX = 3;
    private static final String LALIASKEY = "%LALIASKEY%";
    public static final String GENERIC_TYPE_FAMILY = "$__ORA_$_GEN_$_COL_$_TYPE__$";
    public static final String COND_CONNECTOR = " AND ";
    public static final String COND_FALSE = " AND 1=0 ";
    public static final String COND_TRUE = " AND 1=1 ";
    public static final String COND_NULL = " AND 1=0 ";
    public static final int MATCHABILITY_NO_TERMTYPE = -4;
    public static final int MATCHABILITY_NO_TYFAM = -3;
    public static final int MATCHABILITY_NO_COLTYPE = -2;
    public static final int MATCHABILITY_NO_MIN_PFX_SFX = -1;
    public static final int MATCHABILITY_UNKNOWN = 0;
    public static final int MATCHABILITY_NOT_RULED_OUT = 1;
    public static final int MATCHABILITY_YES_SIMILAR = 2;
    public static final int MATCHABILITY_YES_CONGRUENT = 3;
    public static final String LTC_TYPE_STRING = "STRING";
    public static final String LTC_TYPE_STRING_CLOB = "STRING_CLOB";
    public static final String LTC_TYPE_SDO_GEOMETRY = "SDO_GEOMETRY";
    public static final String LTC_TYPE_NUMBER = "NUMBER";
    public static final String LTC_TYPE_BFLOAT = "BFLOAT";
    public static final String LTC_TYPE_BDOUBLE = "BDOUBLE";
    public static final String LTC_TYPE_DATE = "DATE";
    public static final String LTC_TYPE_TIMESTAMP = "TIMESTAMP";
    public static final String LTC_TYPE_TIMESTAMP_TZ = "TIMESTAMP_TZ";
    public static final String LTC_TYPE_TIMESTAMP_LTZ = "TIMESTAMP_LTZ";
    public static final String TYPE_FAM_STRING = "STRING";
    public static final String TYPE_FAM_NUMERIC = "NUMERIC";
    public static final String TYPE_FAM_FLOAT = "FLOAT";
    public static final String TYPE_FAM_DOUBLE = "DOUBLE";
    public static final String TYPE_FAM_DATE = "DATE";
    public static final String TYPE_FAM_TIME = "TIME";
    public static final String TYPE_FAM_DATETIME = "DATETIME";
    public static final String TYPE_FAM_BOOLEAN = "BOOLEAN";
    public static final String TYPE_FAM_RAW = "RAW";
    public static final String TYPE_FAM_SDO_GEOMETRY = "SDO_GEOMETRY";
    public static final String TYPE_FAM_OTHER = "OTHER";
    public static final String TYPE_FAM_NUMFLTDBL = "NUMFLTDBL";
    public static final String SDO_RDF_VNAME_BEG = "sdo_rdf.vname(";
    public static final String SDO_RDF_VNAME_END = ")";
    public static final String SDO_CS_TRANSFORM_BEG = "sdo_cs.transform(";
    public static final String SDO_CS_TRANSFORM_END = ")";
    public static final String SDO_EQUAL_BEG = "sdo_equal(";
    public static final String SDO_EQUAL_END = ") = 'TRUE' ";
    public static final String DEFAULT_GEOMETRY_SRID_STR = "8307";
    public static final Long DEFAULT_GEOMETRY_SRID = Long.parseLong("8307");
    public static final String DEFAULT_GEOMETRY_DIMENSION = "sdo_dim_array(sdo_dim_element('LONGITUDE','-180','180','10'),sdo_dim_element('LATITUDE','-90','90','10'))";
    private static HashMap<String, List<String>> geo_functionArgsMap = new HashMap();
    private static Set<String> geo_funtionRequiringSridTransformationSet = new HashSet<String>();
    public static final String TZ_LOWER_VAL = "12";
    public static final String TZ_UPPER_VAL = "14";
    public static final String TZ_LOWER = "-12:00";
    public static final String TZ_UPPER = "+14:00";
    public static final String TZ_LOWER_INTERVAL = " - INTERVAL '12' HOUR";
    public static final String TZ_UPPER_INTERVAL = " + INTERVAL '14' HOUR";
    private long time_start;
    private BasicGraphPattern bgp;
    private Map<String, String> varset;
    private List<SPARQLTriplesBlock> myTrips;
    private Map<String, String> rdfTermSet;
    private List<Filter> filters;
    private HashSet<Filter> filterSet_for_BGP;
    private Map<String, Integer> hint0leadPosMap;
    private SQLGenContext ctx = null;
    private String userHint = "";
    private Set<String> projectVars;
    private Set<String> leftJoinVars;
    private Map<String, String> varAliases;
    private Map<String, String> withMap;
    private HashMap<String, DBDictionaryInfo> relPredSet;
    private HashMap<String, TPOmap> predMapSet;
    private HashSet<String> VarSet_for_BGP;
    private Map<String, String> DatatypeFam_for_var;
    private Map<String, Set<Long>> Geometry_VarSRID;
    private Map<String, String> Geometry_VarDimension;
    private HashMap<String, LtcTabRowInfo> LtcRowInfo_for_Tmap_plus_Col;
    private List<String> TFTglobalList;
    private List<String> noTFTglobalList;
    private ArrayList<TFTinfo> TFTinfoGlobalList;
    private int null_TFTidx;
    private Map<String, TmapInfo> TmapInfo_for_Tmap;
    private List<String> breakTpatCSRList = new ArrayList<String>();
    private Map<String, CSRinfo> CSRinfo_for_CSRkey;
    private Map<String, CSRinfo> CSRinfo_for_CSRAlias;
    private HashMap<String, RRTabRowInfo> RRrowInfo_for_MatchingRow;
    private HashMap<String, Set<String>> RRrowSet_for_BGPconst;
    private HashMap<String, Set<String>> RRrowSet_for_BGPvar;
    private HashMap<String, Set<String>> RRrowSet_for_TriplePattern;
    private HashMap<String, List<String>> OccPosList_for_Var;
    private HashMap<String, ArrayList<Filter>> FilterList_for_Var;
    private HashMap<String, List<String>> SimpleConstraintList_for_Var;
    private HashSet<RelExpr> RelExprFilterList_for_BGP;
    private HashSet<RelExpr> TwoVarRelExprFilterList_for_BGP;
    private HashSet<String> VarSet_filter2vCond_outer;
    private HashMap<String, Set<String>> TmapSet_for_svar;
    private HashSet<String> Tmaps_with_nonUnique_Smaps;
    private HashMap<String, Set<String>> PredConstSet_for_pvar;
    private HashMap<String, String> Subj_for_TpatCSRGroup;
    private HashMap<String, Set<String>> TmapSet_for_TpatCSRGroup;
    private HashMap<String, Set<String>> TpatSet_for_TpatCSRGroup;
    private HashMap<String, String> CSRAlias_for_TpatCSRGroup;
    private Map<String, MCSR> MCSR_for_MCSRkey;
    private Map<Integer, MCSR> MCSR_for_MCSRid;
    private List<Long> time_bSUM_List;
    private List<Long> time_bSTT_List;
    private HashMap<String, List<String>> predList_for_CSRAlias;
    private HashMap<String, List<String>> objeList_for_CSRAlias;
    private HashMap<String, List<String>> varsList_for_CSRAlias;
    private HashMap<String, List<List<String>>> TrueMatchingRRrowListList_for_CSRAliasPlusTmap;
    private List<String> RRrowList_All;
    private HashMap<String, String> FullOccInfo_for_VarPlusCSRAlias;
    private Map<String, Map<String, Set<String>>> occPosSet_for_CSRAlias_for_var;
    private HashMap<String, Set<String>> TypeInfoSet_for_VarPlusCSRAlias;
    private Map<String, String> mcc_for_var;
    private HashMap<String, List<String>> NativeVarList_for_CSRAlias;
    private HashSet<String> CLOBVarPlusMCSRAlias_Set_for_BGP;
    private HashMap<String, TriplesBlock> TpatInfo_for_TpatKey;
    private HashMap<String, String> LtabExpr_for_Tmap;
    private HashMap<String, String> SubjExpr_for_Tmap;
    private HashMap<String, Integer> sTFT_idx_for_Tmap;
    private HashMap<String, String> SubjRRrowid_for_Tmap;
    private HashMap<String, Integer> RRrowFlags_for_Tmap;
    private List<TriplesBlock> dummyTBList;
    private List<String> condForNullSkipping;
    private boolean running_in_cnf_mode = false;
    private String criri_network_storage_form_arg;
    private int use_varchar2_size_limit;
    private static final String NATIVE_SUFFIX = "$";
    private static final String FUNC_DECL;
    private String cond_strict_default_graph = "";
    private static final String RRrowSelList = ", Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr";
    private static final String LtcRowSelList = "Tmap, col_Name, col_type, col_type_name, col_max_len, col_precision, col_scale";
    private static final String rrIRI = "<http://www.w3.org/ns/r2rml#IRI>";
    private static final String rrBlankNode = "<http://www.w3.org/ns/r2rml#BlankNode>";
    private static final String rrLiteral = "<http://www.w3.org/ns/r2rml#Literal>";
    private static final String rrDefaultGraph = "<http://www.w3.org/ns/r2rml#defaultGraph>";
    private static final String BASE_PREFIX_COLNAME_SEP = " ";
    private static final String BASE_PREFIX_BEGMARK = " BASE=";
    private static final String ESC_SBYTE_OFF = " ESC_SBYTE_OPT=F ";
    private static final String URL_ESCAPE_BEG = "sdo_rdf.pencd(";
    private static final String URL_ESCAPE_END = ",1)";
    private static final String URL_ESCAPE_END_NETWORK_STORAGE_FORM_UNESC = ",1,p_network_storage_form=>'UNESC')";
    private static final String URL_ESCAPE_END_NETWORK_STORAGE_FORM_ESC = ",1,p_network_storage_form=>'ESC')";
    private static final String URL_UNESCAPE_BEG = "sys.utl_url.unescape(";
    private static final String URL_UNESCAPE_END = ")";
    private static final String URL_ESCAPE_END_SBOFF = ", options=>' ESC_SBYTE_OPT=F ')";
    private static final String TTL_ESCAPE_BEG = "sem_apis.escape_rdf_value(";
    private static final String TTL_ESCAPE_END = ")";
    private static final String TTL_ESCAPE_CLOB_BEG = "sdo_rdf.escape_clob_value(";
    private static final String TTL_ESCAPE_CLOB_END = ")";
    private static final String TTL_CONVERT_TO_WKT_BEG = "sdo_rdf.convert_to_wkt_literal(";
    private static final String TTL_CONVERT_TO_WKT_END = ",col_SRID=>NVL(%TABLE_NAME%.%COLUMN_NAME%.SDO_SRID, %DBCOLTYPE_SRID%),options=>' VNAME=T ',p_network_owner=>'%P_NETWORK_OWNER%',p_network_name=>'%P_NETWORK_NAME%')";
    private static final String TTL_COMPARE_CLOB_BEG = "dbms_lob.compare(";
    private static final String TTL_COMPARE_CLOB_END = ")";
    private static final String TTL_ESCAPE_UNI_ONLY_END = ")";
    private static final String TTL_ESCAPE_END_SBOFF = ", options=>' ESC_SBYTE_OPT=F ')";
    private static final String TTL_UNESCAPE_BEG = "sem_apis.unescape_rdf_value(";
    private static final String TTL_UNESCAPE_END = ")";
    private static final String TTL_UNESCAPE_CLOB_BEG = "sdo_rdf.unescape_clob_value(";
    private static final String TTL_UNESCAPE_CLOB_END = ")";
    private static final HashMap<String, String> sqlcompOper_clobCompare_map;
    final String GRAPH_CLAUSE_CONSTANT_MISMATCH = "0";
    private static final String NO_DB_COL_TYPE = "NO_DB_COL_TYPE";
    private static final String ALIAS_SEP = " AS ";
    private int graph_use_mode;
    private static final int FROM_CLAUSE = 1;
    private static final int FROM_NAMED_CLAUSE = 2;
    private static final int GRAPH_CLAUSE = 4;
    private boolean graphMatchUnnamed;
    private String bgp_graph;
    private boolean is_bgp_graph_const;
    private boolean is_bgp_graph_a_var;
    private int id;
    private boolean m_bLog = false;
    private HintGenerator hintG;
    private String sqlHint;
    private boolean rtyp_pred_only;
    private Integer alias;
    private int model_id;
    private String rr_tab_qname;
    private String Ltc_tab_qname;
    private String rr_tab_dummy_query;
    private int queryOptions = 0;
    private String defaultOwner;
    private String subjectCol = "START_NODE_ID";
    private String predicateCol = "P_VALUE_ID";
    private String canonObjCol = "CANON_END_NODE_ID";
    private String exactObjCol = "END_NODE_ID";
    private String vname_col = "VALUE_NAME";
    private String vid_col = "VALUE_ID";
    private String vtype_col = "VALUE_TYPE";
    private String prefix_col = "VNAME_PREFIX";
    private String suffix_col = "VNAME_SUFFIX";
    private String litType_col = "LITERAL_TYPE";
    private String langType_col = "LANGUAGE_TYPE";
    private String longLit_col = "LONG_VALUE";
    private String vid_alias = "$RDFVID";
    private String vtype_alias = "$RDFVTYP";
    private String prefix_alias = "$_PREFIX";
    private String suffix_alias = "$_SUFFIX";
    private String litType_alias = "$RDFLTYP";
    private String langType_alias = "$RDFLANG";
    private String longLit_alias = "$RDFCLOB";
    private boolean graphQuery = false;
    private ASTTripleAtom activeGraph = null;
    private String graphVar = null;
    private String rdftyp_pred = "834132227519661324";
    private String ini_delimiter = "{";
    private String fnl_delimiter = "}";
    private static final String delim = "\\";
    private static Set<String> spcl_chars;
    private Map<String, Long> time_delta_for_buildSQL_for_UArow_of_MCSR_for_mcsr_plus_UArowNum = new LinkedHashMap<String, Long>();
    private ElapsedTimeInfoHandler elapsedTimeInfoHandler;

    private static HashMap<String, String> create_map_of_strings(String[] stringArray, String[] stringArray2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        for (String string : stringArray) {
            hashMap.put(string, stringArray2[n++]);
        }
        return hashMap;
    }

    private void log(String string) {
        RelationalBGP.log_static(string, this.ctx.R2RFlags);
    }

    private void log(String string, long l) {
        RelationalBGP.log_static(string, this.ctx.R2RFlags, l);
    }

    private static void log_static(String string, long l) {
        long l2 = 1L;
        RelationalBGP.log_static(string, l, l2);
    }

    private static void log_static(String string, long l, long l2) {
        long l3 = l & 7L;
        if (l2 <= l3) {
            System.out.print(string + "\n");
        }
    }

    private String prettyPrintCond(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = string.indexOf(COND_CONNECTOR) + 1;
        int n2 = 0;
        while (true) {
            int n3 = string.indexOf(COND_CONNECTOR, n);
            n = n3 + 1;
            if (n3 == -1) break;
            stringBuffer.append(string.substring(n2, n3) + "\n");
            n2 = n3;
        }
        stringBuffer.append(string.substring(n2) + "\n");
        return stringBuffer.toString();
    }

    private static String get_base_prefix_from_RR_table(String string) {
        String string2 = null;
        int n = BASE_PREFIX_BEGMARK.length();
        if (string.indexOf(BASE_PREFIX_BEGMARK) == 0) {
            string2 = string.substring(n, string.indexOf(BASE_PREFIX_COLNAME_SEP, n));
        }
        return string2;
    }

    private static String get_col_name_from_RR_table(String string) {
        String string2 = string;
        int n = BASE_PREFIX_BEGMARK.length();
        if (string.indexOf(BASE_PREFIX_BEGMARK) == 0) {
            string2 = string.substring(string.indexOf(BASE_PREFIX_COLNAME_SEP, n) + 1, string.length());
        }
        return string2;
    }

    private static boolean isStringNumeric(String string) {
        try {
            double d = Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static String matchabilityPlusCond(String[] stringArray, TFTinfo tFTinfo, TFTinfo tFTinfo2, String string, int n, String string2, int n2, String string3, HashMap<String, RRTabRowInfo> hashMap, SQLGenContext sQLGenContext) throws RDFException, SQLException {
        RelationalBGP.log_static("Entered matchabilityPlusCond", sQLGenContext.R2RFlags);
        RelationalBGP.log_static("L_TFTinfo:\n" + tFTinfo.toString(), sQLGenContext.R2RFlags);
        RelationalBGP.log_static("R_TFTinfo:\n" + tFTinfo2.toString(), sQLGenContext.R2RFlags);
        boolean bl = false;
        int n3 = 0;
        String string4 = "";
        RRTabRowInfo rRTabRowInfo = hashMap.get(string);
        RRTabRowInfo rRTabRowInfo2 = hashMap.get(string2);
        List<String> list = rRTabRowInfo.colLists.get(n);
        List<String> list2 = rRTabRowInfo2.colLists.get(n2);
        if (!tFTinfo.termType.equals(tFTinfo2.termType)) {
            n3 = -4;
        } else if (tFTinfo.termType.equals(rrLiteral) && !bl && !tFTinfo.datatype_family.equals(tFTinfo2.datatype_family)) {
            n3 = -3;
        } else if (tFTinfo.termType.equals(rrLiteral) && bl && !tFTinfo.datatype.equals(tFTinfo2.datatype)) {
            n3 = -3;
        } else if (tFTinfo.exprType == RRTabRowInfo.MapExprType_TEMPLATE && tFTinfo2.exprType == RRTabRowInfo.MapExprType_TEMPLATE) {
            RelationalBGP.log_static("Case: Template-Template", sQLGenContext.R2RFlags);
            if (tFTinfo.termType.equals(rrIRI) && tFTinfo2.termType.equals(rrIRI)) {
                RelationalBGP.log_static("sub-case: Template-Template/IRI-IRI", sQLGenContext.R2RFlags);
                if (tFTinfo.TFTidx == tFTinfo2.TFTidx) {
                    RelationalBGP.log_static("leaf-case: Template-Template/IRI-IRI + congruent TFTs", sQLGenContext.R2RFlags);
                    n3 = 3;
                    RelationalBGP.log_static("leaf-case: Template-Template/IRI-IRI + congruent TFTs: matchability_status" + n3, sQLGenContext.R2RFlags);
                    if (string3 != null) {
                        if (tFTinfo.numIsolStrs > 0) {
                            for (int i = 0; i < tFTinfo.numCols; ++i) {
                                if (tFTinfo.strIsolList.get(i) == null || tFTinfo.strIsolList.get(i + 1) == null) continue;
                                string4 = string4 + COND_CONNECTOR + string3 + "." + list.get(i) + "=" + string3 + "." + list2.get(i);
                            }
                            stringArray[0] = string4;
                            stringArray[1] = tFTinfo.numIsolStrs == tFTinfo.numCols + 1 ? "REPLACE_NON_OPTIM_COND" : "APPEND_TO_NON_OPTIM_COND";
                        } else {
                            stringArray[1] = "NO_OPTIM_COND_POSSIBLE";
                        }
                    }
                } else if (tFTinfo.strList.equals(tFTinfo2.strList)) {
                    boolean bl2 = true;
                    n3 = 2;
                    for (int i = 0; i < tFTinfo.colTypeList.size(); ++i) {
                        String string5 = tFTinfo.colTypeList.get(i);
                        String string6 = tFTinfo2.colTypeList.get(i);
                        String string7 = "";
                        String string8 = "";
                        if (string5.equals(string6)) {
                            if (tFTinfo.strIsolList.get(i) != null && tFTinfo.strIsolList.get(i + 1) != null && tFTinfo2.strIsolList.get(i) != null && tFTinfo2.strIsolList.get(i + 1) != null) {
                                if (string3 == null) continue;
                                string4 = string4 + COND_CONNECTOR + string3 + "." + list.get(i) + "=" + string3 + "." + list2.get(i);
                                continue;
                            }
                            bl2 = false;
                            continue;
                        }
                        if (string5.equals("STRING")) {
                            if (tFTinfo.strIsolList.get(i) != null && tFTinfo.strIsolList.get(i + 1) != null || tFTinfo2.strIsolList.get(i) != null && tFTinfo2.strIsolList.get(i + 1) != null) {
                                if (string3 == null) continue;
                                string4 = string4 + COND_CONNECTOR + string3 + "." + list.get(i) + "=to_char(" + string3 + "." + list2.get(i) + ")";
                                continue;
                            }
                            bl2 = false;
                            continue;
                        }
                        if (string6.equals("STRING")) {
                            if (tFTinfo.strIsolList.get(i) != null && tFTinfo.strIsolList.get(i + 1) != null || tFTinfo2.strIsolList.get(i) != null && tFTinfo2.strIsolList.get(i + 1) != null) {
                                if (string3 == null) continue;
                                string4 = string4 + COND_CONNECTOR + "to_char(" + string3 + "." + list.get(i) + ")=" + string3 + "." + list2.get(i);
                                continue;
                            }
                            bl2 = false;
                            continue;
                        }
                        if ((string5.equals(LTC_TYPE_NUMBER) || string5.equals(LTC_TYPE_BFLOAT) || string5.equals(LTC_TYPE_BDOUBLE)) && (string6.equals(LTC_TYPE_NUMBER) || string6.equals(LTC_TYPE_BFLOAT) || string6.equals(LTC_TYPE_BDOUBLE))) {
                            if (tFTinfo.strIsolList.get(i) != null && tFTinfo.strIsolList.get(i + 1) != null && tFTinfo2.strIsolList.get(i) != null && tFTinfo2.strIsolList.get(i + 1) != null) {
                                if (string3 == null) continue;
                                string4 = string4 + COND_CONNECTOR + string3 + "." + list.get(i) + "=" + string3 + "." + list2.get(i);
                                continue;
                            }
                            bl2 = false;
                            continue;
                        }
                        n3 = -2;
                        break;
                    }
                    if (string3 != null && n3 == 2) {
                        stringArray[0] = string4;
                        stringArray[1] = bl2 ? "REPLACE_NON_OPTIM_COND" : (!string4.equals("") ? "APPEND_TO_NON_OPTIM_COND" : "NO_OPTIM_COND_POSSIBLE");
                    }
                } else {
                    String string9 = rRTabRowInfo.sExpr;
                    String string10 = rRTabRowInfo2.sExpr;
                    if (RelationalBGP.matchableSqlTemplatePair(string9, string10, sQLGenContext)) {
                        n3 = 1;
                        RelationalBGP.log_static("matchabilityPlusCond: general case: matchable templates: " + string9 + " and " + string10, sQLGenContext.R2RFlags);
                    } else {
                        n3 = -1;
                    }
                    RelationalBGP.log_static("leaf-case: Template-Template/IRI-IRI + general case: matchability_status" + n3, sQLGenContext.R2RFlags);
                }
            }
        } else {
            n3 = 0;
        }
        RelationalBGP.log_static("matchabilityPlusCond: matchability_status=" + n3, sQLGenContext.R2RFlags);
        if (n3 > 0) {
            return "MATCHABLE";
        }
        return "NOT-MATCHABLE";
    }

    private static String typeOfSqlTemplate(String string, SQLGenContext sQLGenContext) {
        if (string.charAt(0) == '<') {
            return "TURTLE_IRI";
        }
        if (string.indexOf("SQLexpr=") < 0) {
            return "TURTLE_NON_IRI";
        }
        return "SQL_TEMPLATE";
    }

    private static boolean matchableSqlTemplateAndConstant_genCondInfo(List<String> list, List<String> list2, List<String> list3, String string, List<String> list4, SQLGenContext sQLGenContext) {
        int n;
        RelationalBGP.log_static("matchableSqlTemplateAndConstant_genCondInfo: INPUT:\n strList=" + list + "\n constant=" + string + "\n colList=" + list2 + "\n colTypeList=" + list3, sQLGenContext.R2RFlags);
        int n2 = list.size() - 1;
        String string2 = list.get(0);
        if (n2 == 0) {
            return string2.equals(string);
        }
        String string3 = list.get(n2);
        int n3 = string.length();
        int n4 = string.indexOf(string2);
        if (n4 != 0) {
            RelationalBGP.log_static("filter NOT-MATCHABLE: first_str (" + string2 + ") leftmost match starts at pos=" + n4, sQLGenContext.R2RFlags);
            return false;
        }
        int n5 = string.lastIndexOf(string3);
        if (n5 + string3.length() != n3) {
            RelationalBGP.log_static("filter NOT-MATCHABLE: last_str (" + string3 + ") rightmost match starts at pos=" + n5, sQLGenContext.R2RFlags);
            return false;
        }
        RelationalBGP.log_static("starting forward scan ...", sQLGenContext.R2RFlags);
        int n6 = 0;
        int n7 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String object2 : list) {
            if (object2.length() == 0) {
                n = n6 == n2 ? n3 : n7;
                ++n6;
                arrayList.add(n);
                continue;
            }
            n = string.indexOf(object2, n7);
            RelationalBGP.log_static("idx=" + n6 + ",start_pos=" + n7 + "match_start_pos=" + n, sQLGenContext.R2RFlags);
            if (n < 0) {
                return false;
            }
            arrayList.add(n);
            n7 = n + object2.length();
            ++n6;
        }
        RelationalBGP.log_static("... forward scan DONE: forward_strMatchPosList=" + arrayList, sQLGenContext.R2RFlags);
        if ((Integer)arrayList.get(n2) + string3.length() != n3) {
            RelationalBGP.log_static("filter MATCHABLE-BUT-NOT-OPTIMIZABLE: forward scan last str match at pos=" + arrayList.get(n2), sQLGenContext.R2RFlags);
            return true;
        }
        RelationalBGP.log_static("starting reverse scan of RDFterm ...", sQLGenContext.R2RFlags);
        int n8 = string.length();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n6 = list.size() - 1; n6 >= 0; --n6) {
            String n9 = list.get(n6);
            if (n9.length() == 0) {
                n = n6 == 0 ? 0 : n8;
                arrayList2.add(n);
                continue;
            }
            n = string.substring(0, n8).lastIndexOf(n9);
            RelationalBGP.log_static("idx=" + n6 + ",end_pos=" + n8 + "match_start_pos=" + n, sQLGenContext.R2RFlags);
            arrayList2.add(n);
            n8 = n;
        }
        RelationalBGP.log_static("... reverse scan of RDFterm DONE: reverse_strMatchPosList=" + arrayList2, sQLGenContext.R2RFlags);
        for (n6 = 0; n6 <= n2; ++n6) {
            n = n2 - n6;
            if (arrayList.get(n6) == arrayList2.get(n)) continue;
            RelationalBGP.log_static("filter MATCHABLE-BUT-NOT-OPTIMIZABLE: match pos mismatch for str at idx=" + n6 + ": forward pos=" + arrayList.get(n6) + " reverse pos=" + arrayList2.get(n), sQLGenContext.R2RFlags);
            return true;
        }
        RelationalBGP.log_static("got UNIQUE MATCH: forward and reverse scan gave same match positions", sQLGenContext.R2RFlags);
        n = 1;
        int n9 = 0;
        for (n6 = 1; n6 <= n2; ++n6) {
            String string4;
            String string5 = list3.get(n6 - 1);
            if (!(string5.equals(LTC_TYPE_NUMBER) || string5.equals(LTC_TYPE_BFLOAT) || string5.equals(LTC_TYPE_BDOUBLE) || string5.equals("STRING"))) {
                RelationalBGP.log_static("matchable, but skip optim: non-numeric, non-string colType of col at idx=" + (n6 - 1) + ": " + string5, sQLGenContext.R2RFlags);
                return true;
            }
            int n10 = n9 + list.get(n6 - 1).length();
            int n11 = (Integer)arrayList.get(n6);
            String string6 = string.substring(n10, n11);
            if (string5.equals(LTC_TYPE_NUMBER) || string5.equals(LTC_TYPE_BFLOAT) || string5.equals(LTC_TYPE_BDOUBLE)) {
                try {
                    double numberFormatException = Double.parseDouble(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                    break;
                }
                string4 = string6;
            } else {
                string4 = string6;
            }
            list4.add(string4);
            n9 = n11;
        }
        RelationalBGP.log_static("matchableSqlTemplateAndConstant_genCondInfo returning true (matchable): OUTPUT: colValList=" + list4, sQLGenContext.R2RFlags);
        return n != 0;
    }

    private static boolean matchableSqlTemplateAndConstant(List<String> list, String string, SQLGenContext sQLGenContext) {
        RelationalBGP.log_static("matchableSqlTemplateAndConstant: strList=" + list, sQLGenContext.R2RFlags);
        RelationalBGP.log_static("matchableSqlTemplateAndConstant: constant=" + string, sQLGenContext.R2RFlags);
        if (list.size() == 1) {
            return list.get(0).equals(string);
        }
        int n = 0;
        int n2 = 0;
        for (String string2 : list) {
            if (string2.length() == 0) {
                ++n;
                continue;
            }
            int n3 = string.substring(n2).indexOf(string2);
            RelationalBGP.log_static("idx=" + n + ",start_pos=" + n2 + "match_start_pos=" + n3, sQLGenContext.R2RFlags);
            if (n3 < 0) {
                return false;
            }
            if (n == 0 && n3 != 0) {
                return false;
            }
            if (n == list.size() - 1 && string.substring(n2 + n3).length() > string2.length()) {
                return false;
            }
            n2 = n2 + n3 + string2.length();
            ++n;
        }
        return true;
    }

    private static boolean matchableSqlTemplatePair(String string, String string2, SQLGenContext sQLGenContext) throws RDFException, SQLException {
        return RelationalBGP.matchableSqlTemplatePair(string, string2, null, null, null, null, sQLGenContext);
    }

    private static boolean matchableSqlTemplatePair(String string, String string2, RRTabRowInfo rRTabRowInfo, RRTabRowInfo rRTabRowInfo2, String string3, String string4, SQLGenContext sQLGenContext) throws RDFException, SQLException {
        String string5;
        TFTinfo tFTinfo;
        int n;
        String string6;
        String string7 = string.substring(1, string.length() - 1);
        String string8 = string2.substring(1, string2.length() - 1);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (RelationalBGP.typeOfSqlTemplate(string, sQLGenContext).equals("SQL_TEMPLATE")) {
            string6 = RelationalBGP.sqlTempl2sqlExpr(string7, null, null, null, null, arrayList, null, null, sQLGenContext);
        } else {
            arrayList.add(string7);
        }
        if (RelationalBGP.typeOfSqlTemplate(string2, sQLGenContext).equals("SQL_TEMPLATE")) {
            string6 = RelationalBGP.sqlTempl2sqlExpr(string8, null, null, null, null, arrayList2, null, null, sQLGenContext);
        } else {
            arrayList2.add(string8);
        }
        if (arrayList.size() == 1) {
            return RelationalBGP.matchableSqlTemplateAndConstant(arrayList2, (String)arrayList.get(0), sQLGenContext);
        }
        if (arrayList2.size() == 1) {
            return RelationalBGP.matchableSqlTemplateAndConstant(arrayList, (String)arrayList2.get(0), sQLGenContext);
        }
        if (rRTabRowInfo == null || rRTabRowInfo2 == null || string3 == null || string4 == null) {
            String string9;
            String string10;
            String string11 = (String)arrayList.get(0);
            if (string11.indexOf(string10 = (String)arrayList2.get(0)) < 0 && string10.indexOf(string11) < 0) {
                RelationalBGP.log_static("min-pfx mismatch", sQLGenContext.R2RFlags);
                return false;
            }
            String string12 = (String)arrayList.get(arrayList.size() - 1);
            if (string12.indexOf(string9 = (String)arrayList2.get(arrayList2.size() - 1)) < 0 && string9.indexOf(string12) < 0) {
                RelationalBGP.log_static("min-sfx mismatch", sQLGenContext.R2RFlags);
                return false;
            }
            RelationalBGP.log_static("matchable: min-pfx and min-sfx", sQLGenContext.R2RFlags);
            return true;
        }
        String string13 = null;
        RRTabRowInfo rRTabRowInfo3 = null;
        int n2 = -1;
        RelationalBGP.log_static("Scrutinize further this min-pfx min-sfx matchability", sQLGenContext.R2RFlags);
        boolean bl = false;
        String string14 = (String)arrayList.get(0);
        String string15 = (String)arrayList2.get(0);
        int n3 = string14.length();
        int n4 = string15.length();
        if (string14.equals(string15)) {
            bl = true;
        } else if (n3 > n4) {
            if (string14.indexOf(string15) != 0) {
                RelationalBGP.log_static("min-pfx mismatch 1", sQLGenContext.R2RFlags);
                return false;
            }
            string13 = string14.substring(n4);
            rRTabRowInfo3 = rRTabRowInfo2;
            n2 = RelationalBGP.convert_comp_name_to_comp_idx(string4, null);
        } else if (n4 > n3) {
            if (string15.indexOf(string14) != 0) {
                RelationalBGP.log_static("min-pfx mismatch 2", sQLGenContext.R2RFlags);
                return false;
            }
            string13 = string15.substring(n3);
            rRTabRowInfo3 = rRTabRowInfo;
            n2 = RelationalBGP.convert_comp_name_to_comp_idx(string3, null);
        } else {
            RelationalBGP.log_static("min-pfx mismatch 2.5: equal-length BUT non-equal: lengths are " + n3 + ", " + n4, sQLGenContext.R2RFlags);
            return false;
        }
        if (!bl && rRTabRowInfo != null && rRTabRowInfo2 != null) {
            n = rRTabRowInfo3.TFT_idxs.get(n2);
            tFTinfo = sQLGenContext.TFTinfoGlobalList.get(n);
            string5 = tFTinfo.colTypeList.get(0);
            if (string5.equals(LTC_TYPE_NUMBER) || string5.equals(LTC_TYPE_NUMBER) || string5.equals(LTC_TYPE_NUMBER)) {
                if (!RelationalBGP.isStringNumeric(string13)) {
                    RelationalBGP.log_static("min-pfx mismatch 3", sQLGenContext.R2RFlags);
                    return false;
                }
            } else if (!string5.equals("STRING")) {
                RelationalBGP.log_static("min-pfx mismatch 4", sQLGenContext.R2RFlags);
                return false;
            }
        }
        boolean bl2 = false;
        String string16 = (String)arrayList.get(0);
        String string17 = (String)arrayList2.get(0);
        n3 = string16.length();
        n4 = string17.length();
        if (string16.equals(string17)) {
            bl2 = true;
        } else if (n3 > n4) {
            RelationalBGP.log_static("case: " + n3 + " > " + n4, sQLGenContext.R2RFlags);
            if (string16.indexOf(string17) != 0) {
                RelationalBGP.log_static("min-sfx mismatch 1", sQLGenContext.R2RFlags);
                return false;
            }
            string13 = string16.substring(n4);
            rRTabRowInfo3 = rRTabRowInfo2;
            n2 = RelationalBGP.convert_comp_name_to_comp_idx(string4, null);
        } else if (n4 > n3) {
            RelationalBGP.log_static("case: " + n4 + " > " + n3, sQLGenContext.R2RFlags);
            if (string17.indexOf(string16) != 0) {
                RelationalBGP.log_static("min-sfx mismatch 2", sQLGenContext.R2RFlags);
                return false;
            }
            string13 = string17.substring(n3);
            rRTabRowInfo3 = rRTabRowInfo;
            n2 = RelationalBGP.convert_comp_name_to_comp_idx(string3, null);
        } else {
            RelationalBGP.log_static("min-sfx mismatch 2.5: equal-length BUT non-equal: lengths are " + n3 + ", " + n4, sQLGenContext.R2RFlags);
            return false;
        }
        if (!bl2 && rRTabRowInfo != null && rRTabRowInfo2 != null) {
            n = rRTabRowInfo3.TFT_idxs.get(n2);
            tFTinfo = sQLGenContext.TFTinfoGlobalList.get(n);
            string5 = tFTinfo.colTypeList.get(0);
            if (string5.equals(LTC_TYPE_NUMBER) || string5.equals(LTC_TYPE_NUMBER) || string5.equals(LTC_TYPE_NUMBER)) {
                if (!RelationalBGP.isStringNumeric(string13)) {
                    RelationalBGP.log_static("min-sfx mismatch 3", sQLGenContext.R2RFlags);
                    return false;
                }
            } else if (!string5.equals("STRING")) {
                RelationalBGP.log_static("min-sfx mismatch 4", sQLGenContext.R2RFlags);
                return false;
            }
        }
        RelationalBGP.log_static("matchable: min-pfx and min-sfx", sQLGenContext.R2RFlags);
        return true;
    }

    private static boolean matchableSqlTemplate_in_list(String string, Collection<String> collection, SQLGenContext sQLGenContext) throws RDFException, SQLException {
        if (collection == null) {
            return false;
        }
        for (String string2 : collection) {
            if (!RelationalBGP.matchableSqlTemplatePair(string, string2, sQLGenContext)) continue;
            RelationalBGP.log_static("FOUND MATCHABLE: (min-sfx and min-sfx match) with following template in list\n" + string2, sQLGenContext.R2RFlags);
            return true;
        }
        RelationalBGP.log_static("NOT-FOUND any MATCHABLE template for: " + string, sQLGenContext.R2RFlags);
        return false;
    }

    private int findIndexOfMatchableRRrow(String string, List<String> list, List<String> list2, String string2, String string3, int n) throws RDFException, SQLException {
        int n2 = -1;
        RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(string);
        this.log("Need to compare the [pos=" + string2 + " of RRrowid=" + string + "] for matchabilty: \n" + rRTabRowInfo.toString());
        String string4 = null;
        String string5 = null;
        int n3 = -1;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        if (string2.equals("subject")) {
            string4 = rRTabRowInfo.sExpr;
            string5 = rRTabRowInfo.sTermType;
            if (string5 == null) {
                string5 = rrIRI;
            }
            n3 = rRTabRowInfo.sExprType;
        } else if (string2.equals("predicate")) {
            string4 = rRTabRowInfo.pExpr;
            string5 = rrIRI;
            n3 = rRTabRowInfo.pExprType;
        } else if (string2.equals("object") && rRTabRowInfo.paTmap == null) {
            string4 = rRTabRowInfo.oExpr;
            string5 = rRTabRowInfo.oTermType;
            if (string5 == null) {
                string5 = rrLiteral;
            }
            n3 = rRTabRowInfo.oExprType;
            string6 = rRTabRowInfo.oDataType;
            if (string6 != null) {
                string7 = this.TYPE_FAMILY(string6.substring(1, string6.length() - 1));
            }
            string8 = rRTabRowInfo.oLanguage;
        } else if (string2.equals("object") && rRTabRowInfo.paTmap != null) {
            string4 = rRTabRowInfo.psExpr;
            string5 = rRTabRowInfo.psTermType;
            if (string5 == null) {
                string5 = rrIRI;
            }
            n3 = rRTabRowInfo.psExprType;
        }
        for (int i = n; i < list.size(); ++i) {
            String string9 = list.get(i);
            String string10 = list2.get(i);
            if (string10.substring(0, 2).equals("XX")) {
                this.log("rejected b/c this candidate RRrowid is marked as NON-MATCHING: RRrowid=" + string9 + " MatchInfo: " + string10);
                continue;
            }
            RRTabRowInfo rRTabRowInfo2 = this.RRrowInfo_for_MatchingRow.get(string9);
            this.log("... [z(index)=" + i + "] for matchabilty with [pos=" + string3 + " of RRrowid=" + string9 + "]: \n" + rRTabRowInfo2.toString());
            String string11 = null;
            String string12 = null;
            int n4 = -1;
            String string13 = null;
            String string14 = null;
            String string15 = null;
            if (string3.equals("subject")) {
                string11 = rRTabRowInfo2.sExpr;
                string12 = rRTabRowInfo2.sTermType;
                if (string12 == null) {
                    string12 = rrIRI;
                }
                n4 = rRTabRowInfo2.sExprType;
            } else if (string3.equals("predicate")) {
                string11 = rRTabRowInfo2.pExpr;
                string12 = rrIRI;
                n4 = rRTabRowInfo2.pExprType;
            } else if (string3.equals("object") && rRTabRowInfo2.paTmap == null) {
                string11 = rRTabRowInfo2.oExpr;
                string12 = rRTabRowInfo2.oTermType;
                if (string12 == null) {
                    string12 = rrLiteral;
                }
                n4 = rRTabRowInfo2.oExprType;
                string13 = rRTabRowInfo2.oDataType;
                if (string13 != null) {
                    string14 = this.TYPE_FAMILY(string13.substring(1, string13.length() - 1));
                }
                string15 = rRTabRowInfo2.oLanguage;
            } else if (string3.equals("object") && rRTabRowInfo2.paTmap != null) {
                string11 = rRTabRowInfo2.psExpr;
                string12 = rRTabRowInfo2.psTermType;
                if (string12 == null) {
                    string12 = rrIRI;
                }
                n4 = rRTabRowInfo2.psExprType;
            }
            this.log("checking for easy rejects: ");
            if (!string5.equals(string12)) {
                this.log("rejected due to termType mismatch: target=" + string5 + " vs. candidate=" + string12);
                continue;
            }
            if (string6 == null && string13 != null || string6 != null && string13 == null || string6 != null && string13 != null && (!string7.equals(string14) || string7.equals(TYPE_FAM_OTHER) && !string6.equals(string13))) {
                this.log("rejected due to datatype (type_family) mismatch: target=" + string6 + " (type_family: " + string7 + ") vs. candidate=" + string13 + " (type_family: " + string14 + ")");
                continue;
            }
            if (string8 == null && string15 != null || string8 != null && string15 == null || string8 != null && string15 != null && !string8.equals(string15)) {
                this.log("rejected due to language mismatch: target=" + string8 + " vs. candidate=" + string15);
                continue;
            }
            this.log("checking for easy ACCEPTs: ");
            if (n3 == RRTabRowInfo.MapExprType_COLUMN || n4 == RRTabRowInfo.MapExprType_COLUMN) {
                n2 = i;
                this.log("--- GOT An E-Z MATCHABLE! --- setting m=" + n2);
                this.log("ACCEPTED due to one or both exprType being col-valued: target=" + n3 + " vs. candidate=" + n4);
                break;
            }
            if (string4.equals(string11)) {
                n2 = i;
                this.log("--- GOT An E-Z MATCHABLE! --- setting m=" + n2);
                this.log("ACCEPTED b/c the two expressions are equal: target=" + string4 + " vs. candidate=" + string11);
                break;
            }
            if (!RelationalBGP.matchableSqlTemplatePair(string11, string4, rRTabRowInfo2, rRTabRowInfo, string3, string2, this.ctx)) continue;
            n2 = i;
            this.log("--- GOT A MATCHABLE (including extra scruty if min-pfx min-sfx based matchability)! --- setting m=" + n2);
            break;
        }
        return n2;
    }

    private static String r2rmlNameToSqlName(String string, SQLGenContext sQLGenContext) {
        StringBuffer stringBuffer = new StringBuffer(BASE_PREFIX_COLNAME_SEP);
        int n = 0;
        RelationalBGP.log_static(string, sQLGenContext.R2RFlags);
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n = string.indexOf(delim, n3);
            if (n != -1) {
                RelationalBGP.log_static("delimiter found at position : " + n, sQLGenContext.R2RFlags);
                if (n > n3) {
                    stringBuffer.append(string.substring(n3, n - 1));
                }
                if (n + 1 < n2 && spcl_chars.contains(Character.valueOf(string.charAt(n + 1)))) {
                    stringBuffer.append(BASE_PREFIX_COLNAME_SEP);
                    n3 = n + 2;
                } else {
                    n3 = n + 1;
                }
            }
            stringBuffer.append(string.substring(n3, n2));
        }
        RelationalBGP.log_static("sqlName derived from r2rmlName is : " + stringBuffer.toString(), sQLGenContext.R2RFlags);
        return stringBuffer.toString();
    }

    private static String trimConcatOperAndSingleQuotes(String string) {
        int n = 0;
        if (string.indexOf(" || ") == 0) {
            n = " || ".length();
        }
        if (n == string.length()) {
            return "";
        }
        if (string.substring(n, n + 1).equals("'")) {
            ++n;
        }
        int n2 = string.length() - 1;
        if (string.lastIndexOf(" || ") == string.length() - " || ".length()) {
            n2 -= " || ".length();
        }
        if (string.substring(n2, n2 + 1).equals("'")) {
            --n2;
        }
        String string2 = string.substring(n, n2 + 1);
        return string2.replace("''", "'");
    }

    private static boolean isEscNeededForColDatatype(String string) {
        return !string.equals(LTC_TYPE_NUMBER) && !string.equals("DATE");
    }

    private static String sqlTempl2sqlExpr(String string, String string2, String string3, StringBuffer stringBuffer, List<String> list, List<String> list2, List<String> list3, Set<String> set, SQLGenContext sQLGenContext) throws SQLException {
        String string4 = string3;
        RelationalBGP.log_static("sqlTempl2sqlExpr: r2rmlTemplsql=" + string + " alias=" + string3 + " useAlias=" + string4 + "\n", sQLGenContext.R2RFlags);
        RelationalBGP.log_static("input => r2rmlTemplsql: " + string, sQLGenContext.R2RFlags);
        String string5 = URL_ESCAPE_BEG;
        String string6 = URL_ESCAPE_END;
        boolean bl = false;
        if ((sQLGenContext.R2RFlags & 0x100L) > 0L) {
            string5 = "";
            string6 = "";
            bl = true;
        } else if (sQLGenContext.networkStorageForm.equals("UNESC")) {
            string6 = URL_ESCAPE_END_NETWORK_STORAGE_FORM_UNESC;
        } else if (sQLGenContext.dbVersion.isCompatible(OracleDatabaseVersion.V_20c)) {
            string6 = URL_ESCAPE_END_NETWORK_STORAGE_FORM_ESC;
        }
        String string7 = TTL_ESCAPE_BEG;
        String string8 = ")";
        if ((sQLGenContext.R2RFlags & 0x200L) > 0L) {
            string7 = "";
            string8 = "";
        } else if ((sQLGenContext.R2RFlags & 0x20000L) > 0L) {
            string8 = ", options=>' ESC_SBYTE_OPT=F ')";
            if (sQLGenContext.noTC) {
                string8 = string8.substring(0, string8.length() - 2) + " NO_TC=T')";
            }
        }
        RelationalBGP.log_static("ctx.R2RFlags=" + sQLGenContext.R2RFlags + " url_escape:" + string5 + string6, sQLGenContext.R2RFlags);
        RelationalBGP.log_static("ctx.R2RFlags=" + sQLGenContext.R2RFlags + " ttl_escape:" + string7 + string8, sQLGenContext.R2RFlags);
        String string9 = string.substring(string.indexOf("SQLexpr=") + "SQLexpr=".length(), string.length());
        int n = 0;
        int n2 = string.indexOf(35);
        if (n2 == -1) {
            return null;
        }
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string.substring(0, n2));
        }
        catch (Exception exception) {
            return null;
        }
        StringBuffer stringBuffer2 = new StringBuffer("");
        int n4 = n2 + 1;
        int n5 = -1;
        for (int i = 0; i < n3; ++i) {
            n5 = string.indexOf(58, n4);
            int n6 = Integer.parseInt(string.substring(n4, n5)) - 1;
            n4 = n5 + 1;
            n5 = string.indexOf(44, n4);
            int n7 = Integer.parseInt(string.substring(n4, n5)) - 1;
            n4 = n5 + 1;
            String string10 = string9.substring(n, n6);
            stringBuffer2.append(string10);
            list2.add(RelationalBGP.trimConcatOperAndSingleQuotes(string10));
            if (string3 != null) {
                RelationalBGP.log_static("alias=" + string3 + " url_escape_beg=: " + string5 + " url_escape_end=" + string6, sQLGenContext.R2RFlags);
                if (string2.equals(rrIRI)) {
                    if (!bl && (list3 == null || RelationalBGP.isEscNeededForColDatatype(list3.get(i)))) {
                        stringBuffer2.append(string5);
                    }
                } else if (string2.equals(rrLiteral)) {
                    stringBuffer2.append(string7);
                }
                stringBuffer2.append(string3);
                String string11 = string9.substring(n6 + "\"___oRa$R2RML_Ltab___\".".length(), n7 + 1);
                RelationalBGP.log_static("colName=" + string11, sQLGenContext.R2RFlags);
                int n8 = string11.length();
                if (string11.charAt(0) != '\"' || string11.charAt(n8 - 1) != '\"') {
                    string11 = string11.toUpperCase();
                    RelationalBGP.log_static("NORMALIZED colName=" + string11, sQLGenContext.R2RFlags);
                }
                stringBuffer2.append(string11);
                if (string2.equals(rrIRI)) {
                    if (!bl && (list3 == null || RelationalBGP.isEscNeededForColDatatype(list3.get(i)))) {
                        stringBuffer2.append(string6);
                    }
                } else if (string2.equals(rrLiteral)) {
                    stringBuffer2.append(string8);
                }
                list.add(string11);
                String string12 = COND_CONNECTOR + string4 + string11 + " is NOT NULL";
                if (stringBuffer != null && stringBuffer.toString().indexOf(string12) < 0) {
                    stringBuffer.append(string12);
                }
                if (set != null) {
                    set.add(string4 + string11);
                }
            }
            n = n7 + 1;
        }
        if (n > string9.length()) {
            list2.add("");
        } else {
            String string13 = string9.substring(n, string9.length());
            stringBuffer2.append(string13);
            list2.add(RelationalBGP.trimConcatOperAndSingleQuotes(string13));
        }
        RelationalBGP.log_static("strList.size()=" + list2.size() + " : " + list2, sQLGenContext.R2RFlags);
        if (string3 != null) {
            RelationalBGP.log_static("colList.size()=" + list.size() + " : " + list, sQLGenContext.R2RFlags);
            if (stringBuffer != null) {
                RelationalBGP.log_static("notNullColCondExpr: " + stringBuffer.toString(), sQLGenContext.R2RFlags);
            }
            RelationalBGP.log_static("urifmt2sql: out_sqlExpr=\n" + stringBuffer2.toString() + "\n", sQLGenContext.R2RFlags);
            return stringBuffer2.toString();
        }
        return null;
    }

    private static String unesc_turtle_constant(String string, SQLGenContext sQLGenContext) {
        RelationalBGP.log_static("esc_val=" + string, sQLGenContext.R2RFlags);
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < string.length()) {
            char c;
            int n2 = string.indexOf(92, n);
            if (n2 < 0) {
                stringBuffer = stringBuffer.append(string.substring(n, string.length()));
                break;
            }
            if (n2 > n) {
                stringBuffer = stringBuffer.append(string.substring(n, n2));
            }
            stringBuffer = (c = string.charAt(n2 + 1)) == 'n' ? stringBuffer.append("\n") : (c == 't' ? stringBuffer.append("\t") : (c == 'r' ? stringBuffer.append("\r") : stringBuffer.append(c)));
            n = n2 + 2;
        }
        RelationalBGP.log_static("unesc_val=" + stringBuffer, sQLGenContext.R2RFlags);
        return stringBuffer.toString();
    }

    private static String vname(String string) {
        return "(CASE WHEN " + string + " is NULL THEN NULL WHEN (" + string + " LIKE '<%>') THEN substr(" + string + ",2,length(" + string + ")-2) WHEN (substr(" + string + ",1,2)='_:') THEN " + string + " WHEN (" + string + " LIKE '\"%\"') THEN substr(" + string + ",2,length(" + string + ")-2) WHEN (" + string + " LIKE '\"%\"^^<%>') THEN substr(" + string + ",2,instr(" + string + ",'\"^^<',-1)-2) WHEN (" + string + " LIKE '\"%\"@%') THEN substr(" + string + ",2,instr(" + string + ",'\"@',-1)-2) ELSE sdo_rdf.raise_parse_error('Invalid RDF term syntax', " + string + ") END)";
    }

    private static String vtype(String string) {
        return "(CASE WHEN " + string + " is NULL THEN NULL WHEN (" + string + " LIKE '<%>') THEN 'URI' WHEN (substr(" + string + ",1,2)='_:') THEN 'BLN' WHEN (" + string + " LIKE '\"%\"' OR " + string + " LIKE '\"%\"^^<%>' OR " + string + " LIKE '\"%\"@%') THEN 'LIT' ELSE sdo_rdf.raise_parse_error('Invalid RDF term syntax', " + string + ") END)";
    }

    private static String vnpfx(String string) {
        return "(CASE WHEN " + string + " is NULL THEN NULL WHEN (" + string + " LIKE '<%>') THEN NVL(substr(substr(" + string + ",2,length(" + string + ")-2),1,instr(translate(substr(" + string + ",2,length(" + string + ")-2),'/#','::'),':',-1)),substr(" + string + ",2,length(" + string + ")-2)) WHEN (substr(" + string + ",1,2)='_:') THEN " + string + " WHEN (" + string + " LIKE '\"%\"') THEN substr(" + string + ",2,length(" + string + ")-2) WHEN (" + string + " LIKE '\"%\"^^<%>') THEN substr(" + string + ",2,instr(" + string + ",'\"^^<',-1)-2) WHEN (" + string + " LIKE '\"%\"@%') THEN substr(" + string + ",2,instr(" + string + ",'\"@',-1)-2) ELSE sdo_rdf.raise_parse_error('Invalid RDF term syntax', " + string + ") END)";
    }

    private static String vnsfx(String string) {
        return "(CASE WHEN " + string + " is NULL THEN NULL WHEN (" + string + " LIKE '<%>') THEN substr(substr(" + string + ",2,length(" + string + ")-2),length(substr(substr(" + string + ",2,length(" + string + ")-2),1,instr(translate(substr(" + string + ",2,length(" + string + ")-2),'/#','::'),':',-1)))+1) ELSE NULL END)";
    }

    private static String ltype(String string) {
        return "(CASE WHEN " + string + " is NULL THEN NULL WHEN (" + string + " LIKE '\"%\"^^<%>') THEN substr(" + string + ",instr(" + string + ",'\"^^<',-1)+4,length(" + string + ")-instr(" + string + ",'\"^^<',-1)-4) ELSE NULL END)";
    }

    private static String latag(String string) {
        return "(CASE WHEN " + string + " is NULL THEN NULL WHEN (" + string + " LIKE '\"%\"@%' AND " + string + " NOT LIKE '\"%\"' AND " + string + " NOT LIKE '\"%>') THEN substr(" + string + ",instr(" + string + ",'\"@',-1)+2) ELSE NULL END)";
    }

    public RelationalBGP(int n, SQLGenContext sQLGenContext) {
        this.id = n;
        this.ctx = sQLGenContext;
        this.bgp = new BasicGraphPattern();
        this.varset = new HashMap<String, String>();
        this.myTrips = new ArrayList<SPARQLTriplesBlock>();
        this.rdfTermSet = new HashMap<String, String>();
        this.filters = new ArrayList<Filter>();
        this.filterSet_for_BGP = new HashSet();
        this.hint0leadPosMap = new HashMap<String, Integer>();
        this.projectVars = new HashSet<String>();
        this.leftJoinVars = new HashSet<String>();
        this.varAliases = new HashMap<String, String>();
        this.withMap = new HashMap<String, String>();
        this.relPredSet = new HashMap();
        this.predMapSet = new HashMap();
        this.LtcRowInfo_for_Tmap_plus_Col = null;
        this.TFTglobalList = new ArrayList<String>();
        this.noTFTglobalList = new ArrayList<String>();
        this.TFTinfoGlobalList = new ArrayList();
        sQLGenContext.TFTinfoGlobalList = this.TFTinfoGlobalList;
        this.null_TFTidx = -1;
        this.TmapInfo_for_Tmap = new HashMap<String, TmapInfo>();
        this.breakTpatCSRList = new ArrayList<String>();
        this.CSRinfo_for_CSRkey = new HashMap<String, CSRinfo>();
        this.CSRinfo_for_CSRAlias = new HashMap<String, CSRinfo>();
        this.RRrowInfo_for_MatchingRow = new HashMap();
        this.VarSet_for_BGP = null;
        this.DatatypeFam_for_var = new HashMap<String, String>();
        this.Geometry_VarSRID = new HashMap<String, Set<Long>>();
        this.Geometry_VarDimension = new HashMap<String, String>();
        this.RRrowSet_for_BGPconst = new HashMap();
        this.RRrowSet_for_BGPvar = new HashMap();
        this.RRrowSet_for_TriplePattern = new HashMap();
        this.OccPosList_for_Var = new HashMap();
        this.FilterList_for_Var = new HashMap();
        this.SimpleConstraintList_for_Var = new HashMap();
        this.RelExprFilterList_for_BGP = new HashSet();
        this.TwoVarRelExprFilterList_for_BGP = new HashSet();
        this.VarSet_filter2vCond_outer = new HashSet();
        this.TmapSet_for_svar = new HashMap();
        this.Tmaps_with_nonUnique_Smaps = new HashSet();
        this.PredConstSet_for_pvar = new HashMap();
        this.Subj_for_TpatCSRGroup = new HashMap();
        this.TmapSet_for_TpatCSRGroup = new HashMap();
        this.TpatSet_for_TpatCSRGroup = new HashMap();
        this.CSRAlias_for_TpatCSRGroup = new HashMap();
        this.MCSR_for_MCSRkey = new LinkedHashMap<String, MCSR>();
        this.MCSR_for_MCSRid = new LinkedHashMap<Integer, MCSR>();
        this.time_bSUM_List = new ArrayList<Long>();
        this.time_bSTT_List = new ArrayList<Long>();
        this.predList_for_CSRAlias = new HashMap();
        this.objeList_for_CSRAlias = new HashMap();
        this.varsList_for_CSRAlias = new HashMap();
        this.TrueMatchingRRrowListList_for_CSRAliasPlusTmap = new HashMap();
        this.RRrowList_All = new ArrayList<String>();
        this.FullOccInfo_for_VarPlusCSRAlias = new HashMap();
        this.occPosSet_for_CSRAlias_for_var = new HashMap<String, Map<String, Set<String>>>();
        this.TypeInfoSet_for_VarPlusCSRAlias = new HashMap();
        this.mcc_for_var = new HashMap<String, String>();
        this.NativeVarList_for_CSRAlias = new HashMap();
        this.CLOBVarPlusMCSRAlias_Set_for_BGP = new HashSet();
        this.TpatInfo_for_TpatKey = new HashMap();
        this.LtabExpr_for_Tmap = new HashMap();
        this.SubjExpr_for_Tmap = new HashMap();
        this.sTFT_idx_for_Tmap = new HashMap();
        this.SubjRRrowid_for_Tmap = new HashMap();
        this.RRrowFlags_for_Tmap = new HashMap();
        this.dummyTBList = new ArrayList<TriplesBlock>();
        this.condForNullSkipping = new ArrayList<String>();
        this.graph_use_mode = 0;
        this.graphMatchUnnamed = false;
        this.bgp_graph = null;
        this.is_bgp_graph_const = false;
        this.is_bgp_graph_a_var = false;
        this.queryOptions = 0;
        this.model_id = 0;
        this.rr_tab_qname = "";
        this.Ltc_tab_qname = "";
        this.rr_tab_dummy_query = "";
        this.alias = 0;
        this.defaultOwner = null;
        this.userHint = null;
        this.hintG = new HintZeroHintGenerator(sQLGenContext, false);
        this.sqlHint = "";
        this.rtyp_pred_only = false;
        this.graphQuery = false;
        this.activeGraph = null;
        spcl_chars = new HashSet<String>(Arrays.asList("t", "r", "n"));
        this.elapsedTimeInfoHandler = new ElapsedTimeInfoHandler();
    }

    @Override
    public SPARQLBGP shallowClone() throws RDFException {
        RelationalBGP relationalBGP = new RelationalBGP(this.id, this.ctx);
        for (SPARQLTriplesBlock sPARQLTriplesBlock : this.myTrips) {
            relationalBGP.addTriplesBlock(sPARQLTriplesBlock);
        }
        return relationalBGP;
    }

    @Override
    public void setIsGraphQuery(boolean bl) {
        this.graphQuery = bl;
    }

    @Override
    public boolean isGraphQuery() {
        return this.graphQuery;
    }

    @Override
    public void setActiveGraph(ASTTripleAtom aSTTripleAtom) {
        this.activeGraph = aSTTripleAtom;
        if (this.activeGraph.type == 0) {
            this.graphVar = this.activeGraph.name.toUpperCase();
        }
        this.log("setting: activeGraph=" + this.activeGraph + " graphVar=" + this.graphVar);
    }

    @Override
    public void addUserHint(String string) {
        this.userHint = string;
        this.hintG.setUserHint(string);
    }

    @Override
    public String getJoinHint(String string, String string2) {
        return "";
    }

    @Override
    public String getAntiJoinHint() {
        return "";
    }

    @Override
    public String getValueJoinHint(Collection<String> collection, String string) {
        String string2 = BASE_PREFIX_COLNAME_SEP;
        if ((this.ctx.R2RFlags & 0x2000L) == 0L) {
            string2 = " /*+ NO_MERGE(" + string + ") */ ";
        }
        return string2;
    }

    @Override
    public void addTriplesBlock(SPARQLTriplesBlock sPARQLTriplesBlock) throws RDFException {
        this.myTrips.add(sPARQLTriplesBlock);
        if (sPARQLTriplesBlock.containsPropertyPath()) {
            throw new RDFException("Property Path patterns currently not supported for RDFView models");
        }
        this.log("no property paths in this SPARQLTriplesBlock");
        this.bgp.addTriplesBlock(sPARQLTriplesBlock, this.ctx);
        this.populateFromTBs();
    }

    @Override
    public void addOptionalTriplesBlock(SPARQLTriplesBlock sPARQLTriplesBlock) throws RDFException {
        throw new RDFException("OPTIONAL inlining not supported for RDF Views");
    }

    @Override
    public List<SPARQLTriplesBlock> getTriplesBlocks() {
        return this.myTrips;
    }

    @Override
    public List<SPARQLTriplesBlock> getMandatoryTriplesBlocks() {
        return this.myTrips;
    }

    @Override
    public List<SPARQLTriplesBlock> getOptionalTriplesBlocks() {
        return Collections.emptyList();
    }

    @Override
    public int getNumTriples() {
        return this.bgp.numTriples();
    }

    @Override
    public boolean addFilter(Filter filter) {
        SimpleNode simpleNode;
        this.log("addFilter => " + filter.toString(BASE_PREFIX_COLNAME_SEP));
        this.filterSet_for_BGP.add(filter);
        if ((this.ctx.R2RFlags & 0x1000L) > 0L) {
            return false;
        }
        this.log("entered addFilter() RelExpr at start: " + this.RelExprFilterList_for_BGP.toString());
        this.log("entered addFilter() TwoVarRelExpr at start: " + this.TwoVarRelExprFilterList_for_BGP.toString());
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(88);
        arrayList.add(80);
        arrayList.add(90);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("ISURI");
        arrayList2.add("ISIRI");
        arrayList2.add("ISLITERAL");
        arrayList2.add("ISBLANK");
        arrayList2.add("SAMETERM");
        arrayList2.add("IN");
        arrayList2.add("NOT IN");
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("http://xmlns.oracle.com/rdf/textContains");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfEquals");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfContains");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfDisjoint");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfCrosses");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfIntersects");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfOverlaps");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfTouches");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfWithin");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/buffer");
        arrayList3.add("http://xmlns.oracle.com/rdf/geo/buffer");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/relate");
        arrayList3.add("http://xmlns.oracle.com/rdf/geo/relate");
        arrayList3.add("http://xmlns.oracle.com/rdf/geo/withinDistance");
        boolean bl = false;
        SimpleNode simpleNode2 = filter.getFilterTree();
        int n = simpleNode2.jjtGetNumChildren();
        int n2 = simpleNode2.id;
        boolean bl2 = false;
        String string = "";
        String string2 = "";
        boolean bl3 = false;
        String string3 = "";
        this.log("+++++ current nodeType=" + n2 + " numChildren=" + n);
        if (n == 0) {
            return bl;
        }
        this.log("[" + simpleNode2.children.length + "]" + simpleNode2.dumpToStr("==>"));
        boolean bl4 = false;
        int n3 = 0;
        while (n2 == 86 && simpleNode2.jjtGetNumChildren() == 2) {
            SimpleNode simpleNode3 = (SimpleNode)simpleNode2.jjtGetChild(0);
            if (!((ASTUnaryOperator)simpleNode3).name.equals("!")) continue;
            simpleNode2 = (SimpleNode)simpleNode2.jjtGetChild(1);
            n2 = simpleNode2.id;
            n = simpleNode2.jjtGetNumChildren();
            bl4 = !bl4;
            ++n3;
            this.log("+++++ new: current nodeType=" + n2 + " numChildren=" + n);
            if (n <= 0) continue;
            this.log("new: [" + simpleNode2.children.length + "]" + simpleNode2.dumpToStr("==>"));
        }
        if (bl4) {
            this.log("negation is ON");
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                simpleNode = (SimpleNode)simpleNode2.jjtGetChild(i);
                this.log("childFilterNode " + i + ": nodeType=" + simpleNode.id + " numChildren=" + simpleNode.jjtGetNumChildren());
            }
        }
        if (arrayList.contains(n2)) {
            if (n2 == 88) {
                string = ((ASTBuiltInCall)simpleNode2).name;
                this.log("funcName=" + string);
                if (arrayList2.contains(string)) {
                    if (n == 1) {
                        SimpleNode simpleNode4 = (SimpleNode)simpleNode2.jjtGetChild(0);
                        int n4 = simpleNode4.id;
                        this.log("childFilterNode: nodeType=" + n4 + " numChildren=" + simpleNode4.jjtGetNumChildren());
                        if (n4 == 73) {
                            int n5 = ((ASTTripleAtom)simpleNode4).type;
                            String string4 = ((ASTTripleAtom)simpleNode4).name;
                            if (n5 == 0) {
                                this.log("Native filter handling possible: " + string4);
                                String string5 = string4;
                                String string6 = "";
                                List<String> list = this.SimpleConstraintList_for_Var.get(string5);
                                if (list == null) {
                                    list = new ArrayList<String>();
                                    this.SimpleConstraintList_for_Var.put(string5, list);
                                }
                                if (bl4) {
                                    string6 = "!";
                                }
                                this.log("adding SimpleConstraint for var=" + string5 + " : " + string6 + string);
                                list.add(string6 + string);
                                ArrayList<Filter> arrayList4 = this.FilterList_for_Var.get(string5);
                                if (arrayList4 == null) {
                                    arrayList4 = new ArrayList();
                                    this.FilterList_for_Var.put(string5, arrayList4);
                                }
                                this.log("adding Filter for var=" + string5 + " : " + string6 + simpleNode2.dumpToStr("--->"));
                                arrayList4.add(filter);
                                bl = true;
                            }
                        }
                    } else if (n == 2 && string.equals("SAMETERM")) {
                        this.log("got sameTerm()");
                        SimpleNode simpleNode5 = (SimpleNode)simpleNode2.jjtGetChild(0);
                        simpleNode = (SimpleNode)simpleNode2.jjtGetChild(1);
                        int n6 = simpleNode5.id;
                        int n7 = simpleNode.id;
                        if (n6 == 73 && n7 == 73) {
                            ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode5;
                            String string7 = string;
                            if (bl4) {
                                this.log("orig compOper was: " + string7);
                                string7 = "DIFFTERM";
                                this.log("NEGATED compOper is: " + string7);
                            }
                            ASTTripleAtom aSTTripleAtom2 = (ASTTripleAtom)simpleNode;
                            if (aSTTripleAtom.type != 0 || aSTTripleAtom2.type != 0) {
                                RelExpr relExpr = new RelExpr(aSTTripleAtom, string7, new ASTTripleAtom[]{aSTTripleAtom2}, filter, 0L);
                                if (aSTTripleAtom2.type == 0) {
                                    relExpr.InvertRelExpr();
                                }
                                this.RelExprFilterList_for_BGP.add(relExpr);
                                bl = true;
                            } else {
                                this.log("addFilter: recording: sameTerm(<var>,<var>) -- NOT NATIVELY IMPLEMENTED YET");
                                RelExpr relExpr = new RelExpr(aSTTripleAtom, string7, new ASTTripleAtom[]{aSTTripleAtom2}, filter, 0L);
                                this.TwoVarRelExprFilterList_for_BGP.add(relExpr);
                            }
                        }
                    }
                }
            } else if (n2 == 80 && n >= 3) {
                this.log("got RelationalExpression");
                SimpleNode simpleNode6 = (SimpleNode)simpleNode2.jjtGetChild(0);
                simpleNode = (SimpleNode)simpleNode2.jjtGetChild(1);
                SimpleNode simpleNode7 = (SimpleNode)simpleNode2.jjtGetChild(2);
                int n8 = simpleNode6.id;
                int n9 = simpleNode.id;
                int n10 = simpleNode7.id;
                this.log("L_childFilterNodeType: " + n8);
                this.log("M_childFilterNodeType: " + n9);
                this.log("R_childFilterNodeType: " + n10);
                if (n9 == 81) {
                    ASTComparisonOperator aSTComparisonOperator = (ASTComparisonOperator)simpleNode;
                    String string8 = aSTComparisonOperator.name;
                    this.log("[RE] ASTComparisonOperator: " + string8);
                    List<String> list = Arrays.asList("=", "!=", ">", "<", ">=", "<=", "IN", "NOT IN");
                    List<String> list2 = Arrays.asList("!=", "=", "<=", ">=", "<", ">", "NOT IN", "IN");
                    int n11 = list.indexOf(string8);
                    if (n11 == -1) {
                        this.log("[RE] no native handling of orig compOper: " + string8);
                        bl = false;
                    } else {
                        if (bl4) {
                            this.log("orig compOper was: " + string8);
                            string8 = list2.get(n11);
                            this.log("NEGATED compOper is: " + string8);
                        }
                        if (n8 == 73 && n10 == 73) {
                            this.log("[RE] JJTTRIPLEATOM  JJTCOMPARISONOPERATOR JJTTRIPLEATOM ");
                            ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode6;
                            ASTTripleAtom aSTTripleAtom3 = (ASTTripleAtom)simpleNode7;
                            this.log("[RE] " + aSTTripleAtom.name + BASE_PREFIX_COLNAME_SEP + aSTComparisonOperator.name + BASE_PREFIX_COLNAME_SEP + aSTTripleAtom3.name);
                            ASTTripleAtom[] aSTTripleAtomArray = new ASTTripleAtom[n - 2];
                            aSTTripleAtomArray[0] = aSTTripleAtom3;
                            if (aSTTripleAtom.type != 0 || aSTTripleAtom3.type != 0) {
                                if (string8.equals("IN") || string8.equals("NOT IN")) {
                                    boolean bl5 = true;
                                    for (int i = 2; i < n; ++i) {
                                        ASTTripleAtom aSTTripleAtom4;
                                        SimpleNode simpleNode8 = (SimpleNode)simpleNode2.jjtGetChild(i);
                                        int n12 = simpleNode8.id;
                                        if (n12 == 73) {
                                            aSTTripleAtom4 = (ASTTripleAtom)simpleNode8;
                                            if (aSTTripleAtom4.type == 0) {
                                                bl5 = false;
                                                break;
                                            }
                                        } else {
                                            bl5 = false;
                                            break;
                                        }
                                        aSTTripleAtomArray[i - 2] = aSTTripleAtom4;
                                        this.log("added R_atoms[" + (i - 2) + "]: " + aSTTripleAtomArray[i - 2].toString());
                                    }
                                    if (!bl5) {
                                        bl = false;
                                        return bl;
                                    }
                                }
                                RelExpr relExpr = new RelExpr(aSTTripleAtom, string8, aSTTripleAtomArray, filter, 0L);
                                if (aSTTripleAtom3.type == 0) {
                                    relExpr.InvertRelExpr();
                                }
                                this.RelExprFilterList_for_BGP.add(relExpr);
                                this.log("added relExpr=" + relExpr);
                                this.log(this.RelExprFilterList_for_BGP.toString());
                                bl = true;
                            } else if (string8 != "IN" && string8 != "NOT IN") {
                                this.log("addFilter: recording: <var> " + string8 + " <var> NOT NATIVELY IMPLEMENTED YET");
                                RelExpr relExpr = new RelExpr(aSTTripleAtom, string8, aSTTripleAtomArray, filter, 0L);
                                this.TwoVarRelExprFilterList_for_BGP.add(relExpr);
                                this.log("added to TwoVarRelExprFilterList_for_BGP: relExpr=" + relExpr);
                                this.log(this.TwoVarRelExprFilterList_for_BGP.toString());
                                if ((this.ctx.R2RFlags & 0x8000L) > 0L) {
                                    this.log("addFilter: recording: <var> " + string8 + " <var> NOT NATIVELY IMPLEMENTED YET ... TRYING OUT b/c of RDB2RDF_SKIP_SPARQL_2V_FILTER=T flag");
                                    bl = true;
                                }
                            }
                        } else if (n8 == 90 && n10 == 73 || n8 == 73 && n10 == 90) {
                            SimpleNode simpleNode9 = null;
                            SimpleNode simpleNode10 = null;
                            Object var31_75 = null;
                            this.log("[RE] Instantiation of relational expression atoms: L_atom and R_atom:");
                            if (simpleNode6 instanceof ASTIRIrefOrFunction) {
                                this.log("[RE] JJTIRIREFORFUNCTION  JJTCOMPARISONOPERATOR JJTTRIPLEATOM ");
                                simpleNode9 = (ASTIRIrefOrFunction)simpleNode6;
                                simpleNode10 = (ASTTripleAtom)simpleNode7;
                            } else {
                                this.log("[RE] JJTTRIPLEATOM JJTCOMPARISONOPERATOR JJTIRIREFORFUNCTION ");
                                simpleNode9 = (ASTTripleAtom)simpleNode6;
                                simpleNode10 = (ASTIRIrefOrFunction)simpleNode7;
                            }
                            try {
                                this.log("[RE] " + simpleNode9.printSPARQLText());
                                this.log("[RE] " + aSTComparisonOperator.printSPARQLText());
                                this.log("[RE] " + simpleNode10.printSPARQLText());
                            }
                            catch (ParseException parseException) {
                                this.log(parseException.toString());
                            }
                            bl = false;
                            this.log("[RE] For the moment we are not handling natively regular expressions that involve JJTIRIREFORFUNCTION ");
                        } else {
                            this.log("[RE] unknown combination of operands/operand");
                        }
                    }
                } else {
                    this.log("[RE] unknown operand: " + simpleNode.toString());
                }
            } else if (n2 == 90 && n == 3) {
                this.log("got IRIrefOrFunction with numChildren=" + n);
                SimpleNode simpleNode11 = (SimpleNode)simpleNode2.jjtGetChild(0);
                simpleNode = (SimpleNode)simpleNode2.jjtGetChild(1);
                SimpleNode simpleNode12 = (SimpleNode)simpleNode2.jjtGetChild(2);
                int n13 = simpleNode11.id;
                int n14 = simpleNode.id;
                int n15 = simpleNode12.id;
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode11;
                this.log("[ML] L_atom.name: " + aSTTripleAtom.name);
                if (arrayList3.contains(aSTTripleAtom.name) && !aSTTripleAtom.name.equals("http://xmlns.oracle.com/rdf/textContains") || n13 == 73 && n14 == 73 && n15 == 73) {
                    if (aSTTripleAtom.type == 1 && arrayList3.contains(aSTTripleAtom.name)) {
                        this.log("We will try processing this filter condition");
                        if (aSTTripleAtom.name.equals("http://xmlns.oracle.com/rdf/textContains")) {
                            this.log("start processing filter: " + aSTTripleAtom.name);
                            ASTTripleAtom aSTTripleAtom5 = (ASTTripleAtom)simpleNode;
                            ASTTripleAtom aSTTripleAtom6 = (ASTTripleAtom)simpleNode12;
                            if (aSTTripleAtom5.type == 0 && aSTTripleAtom6.type == 3) {
                                String string9 = "LIKE";
                                if (bl4) {
                                    string9 = "NOT LIKE";
                                }
                                this.log("start processing filter as: " + aSTTripleAtom5.name + BASE_PREFIX_COLNAME_SEP + string9 + BASE_PREFIX_COLNAME_SEP + aSTTripleAtom6.name);
                                RelExpr relExpr = new RelExpr(aSTTripleAtom5, string9, new ASTTripleAtom[]{aSTTripleAtom6}, filter, 0L);
                                this.RelExprFilterList_for_BGP.add(relExpr);
                                relExpr.setNotNegatedFilterLevel(n3);
                                this.log("added relExpr=" + relExpr);
                                this.log(this.RelExprFilterList_for_BGP.toString());
                                bl = true;
                            } else {
                                this.log("cannot process: LIKE filter args types are diff than expected: " + aSTTripleAtom5.type + COND_CONNECTOR + aSTTripleAtom6.type);
                            }
                        } else if (arrayList3.contains(aSTTripleAtom.name)) {
                            this.log("start processing OGCF filter: " + aSTTripleAtom.name);
                            String string10 = aSTTripleAtom.name;
                            this.log("start processing OGCF filter M_atomName: " + string10);
                            RelExpr relExpr = new RelExpr(null, string10, null, filter, 2L);
                            this.RelExprFilterList_for_BGP.add(relExpr);
                            relExpr.setNotNegatedFilterLevel(n3);
                            bl = true;
                            this.log("added relExpr=" + relExpr);
                            this.log(this.RelExprFilterList_for_BGP.toString());
                        } else {
                            this.log("cannot process: IRIrefOrFunction=" + aSTTripleAtom.name);
                        }
                    } else {
                        this.log("cannot process: IRIrefOrFunction " + aSTTripleAtom.name + " NOT in the list " + arrayList3);
                    }
                } else {
                    this.log("cannot process: IRIrefOrFunction: childFilterNodeTypes are diff than expected: " + n13 + BASE_PREFIX_COLNAME_SEP + n14 + BASE_PREFIX_COLNAME_SEP + n15);
                }
            } else if (n2 == 90 && n >= 4) {
                this.log("got IRIrefOrFunction with numChildren=" + n);
                SimpleNode simpleNode13 = (SimpleNode)simpleNode2.jjtGetChild(0);
                simpleNode = (SimpleNode)simpleNode2.jjtGetChild(1);
                SimpleNode simpleNode14 = (SimpleNode)simpleNode2.jjtGetChild(2);
                SimpleNode simpleNode15 = (SimpleNode)simpleNode2.jjtGetChild(3);
                int n16 = simpleNode13.id;
                int n17 = simpleNode.id;
                int n18 = simpleNode14.id;
                int n19 = simpleNode15.id;
                if (n16 == 73) {
                    ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode13;
                    if (aSTTripleAtom.name.equals("http://www.opengis.net/def/function/geosparql/relate") && n19 != 73) {
                        this.log("Unsupported function: http://www.opengis.net/def/function/geosparql/relate -- expecting plain or xsd:string literal at position 3");
                        return bl;
                    }
                    ASTTripleAtom aSTTripleAtom7 = (ASTTripleAtom)simpleNode15;
                    if (aSTTripleAtom.type == 1 && arrayList3.contains(aSTTripleAtom.name)) {
                        this.log("We will try processing this filter condition: " + aSTTripleAtom.name);
                        if (aSTTripleAtom.name.equals("http://www.opengis.net/def/function/geosparql/relate") || aSTTripleAtom.name.equals("http://xmlns.oracle.com/rdf/geo/relate") || aSTTripleAtom.name.equals("http://xmlns.oracle.com/rdf/geo/withinDistance")) {
                            this.log("start processing OGCF filter: " + aSTTripleAtom.name);
                            String string11 = aSTTripleAtom.name;
                            this.log("FNAM_atomName : " + string11);
                            RelExpr relExpr = new RelExpr(null, string11, null, filter, 2L, aSTTripleAtom7);
                            relExpr.setNotNegatedFilterLevel(n3);
                            this.RelExprFilterList_for_BGP.add(relExpr);
                            this.log(relExpr.toString());
                            bl = true;
                        } else {
                            this.log("cannot process: IRIrefOrFunction=" + aSTTripleAtom.name + " mask=" + aSTTripleAtom7.name);
                        }
                    } else {
                        this.log("cannot process: IRIrefOrFunction " + aSTTripleAtom.name + " NOT in the list " + arrayList3);
                    }
                } else {
                    this.log("cannot process: IRIrefOrFunction: childFilterNodeTypes are diff than expected: " + n16 + BASE_PREFIX_COLNAME_SEP + n17 + BASE_PREFIX_COLNAME_SEP + n18 + BASE_PREFIX_COLNAME_SEP + simpleNode15);
                }
            }
            this.log("****");
            Set<String> set = filter.getVars();
            Set<String> set2 = this.getDefiniteBoundVars();
            if (!this.getDefiniteBoundVars().containsAll(set)) {
                bl = false;
                this.log("addFilter: no native handling involving potentially unbound variables");
                this.RelExprFilterList_for_BGP.remove(this.RelExprFilterList_for_BGP.size() - 1);
            } else if (bl) {
                this.log("addFilter: adding filter to list: " + filter.toString());
                this.filters.add(filter);
            }
        } else {
            this.log("nodeType=" + n2 + " not in the list: " + arrayList.toString());
        }
        this.log("addFilter: returning: " + bl);
        return bl;
    }

    @Override
    public Set<String> addProjectVars(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        Set<String> set2 = this.getDefiniteBoundVars();
        return hashSet;
    }

    @Override
    public boolean addProjectVar(String string) {
        boolean bl = true;
        return bl;
    }

    @Override
    public Set<String> getAllLexVars() {
        Set<String> set = this.getBGPVars();
        this.log("getAllLexVars: returning vSet=" + set);
        return set;
    }

    @Override
    public Set<String> getOptionalBGPVars() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getRequiredLexVars() {
        Set<String> set = this.getBGPVars();
        this.log("getRequiredLexVars: returning vSet=" + set);
        return set;
    }

    @Override
    public boolean addLexVar(String string) {
        return true;
    }

    @Override
    public Set<String> addLexVars(Set<String> set) {
        return new HashSet<String>();
    }

    @Override
    public void pushBGP(SPARQLBGP sPARQLBGP, String string) {
    }

    @Override
    public boolean needsParentBGPPushDown() {
        return false;
    }

    @Override
    public boolean verifyPushedBGP() {
        return true;
    }

    @Override
    public void addJoinVarsForHint(Set<String> set) {
    }

    @Override
    public Set<String> getJoinVarsForHint() {
        return new HashSet<String>();
    }

    @Override
    public Set<String> getBindVars() {
        return new HashSet<String>();
    }

    @Override
    public void popSPMAuxTabsInfo() {
    }

    @Override
    public Set<String> getSPMAuxValueVars() {
        Set<String> set = Collections.emptySet();
        return set;
    }

    @Override
    public void genOuterSelectComponents(Set<String> set, Set<String> set2, Map<String, List<String>> map, String[] stringArray, String[] stringArray2, Map<String, String> map2, Set<String> set3) throws SQLException {
        QueryUtils.genOuterSelectComponents(set, set2, map, stringArray, stringArray2, map2, this.ctx.clnPfxForRdfObjName + "RDF_VALUE$", set3, false, this.ctx.clnNetworkName);
    }

    @Override
    public String buildSubQForCLOB(String string, String string2, String string3) throws SQLException {
        return QueryUtils.buildSubQForCLOB(string, string2, string3, this.ctx.clnPfxForRdfObjName + "RDF_VALUE$", this.ctx.clnNetworkName);
    }

    @Override
    public String buildSubQForCLOB(String string, String string2, String string3, Set<String> set) throws SQLException {
        return this.buildSubQForCLOB(string, string2, string3);
    }

    @Override
    public String distinctGraphsQuery(String string, boolean bl) {
        if (string == null || string.equals("")) {
            return null;
        }
        this.log("distinctGraphsQuery: gVar=" + string + " isProjected=" + bl);
        this.log("RRrowSet_for_TriplePattern is : \n");
        RelationalBGP.printMapSet(this.RRrowSet_for_TriplePattern, this.ctx);
        return null;
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public Set<String> getBGPVars() {
        Set<String> set = this.getTriplePatternVars();
        if (this.graphQuery && this.activeGraph != null && (this.activeGraph.type == 0 || this.activeGraph.type == 9)) {
            set.add(this.activeGraph.name.toUpperCase());
        }
        this.log("getBGPVars: returning vSet: " + set);
        return set;
    }

    @Override
    public Set<String> getMandatoryBGPVars() {
        return this.getBGPVars();
    }

    @Override
    public Set<String> getBGPAndPushedVars() {
        Set<String> set = this.getBGPVars();
        return set;
    }

    @Override
    public Set<String> getDefiniteBoundVars() {
        Set<String> set = this.getTriplePatternVars();
        if (this.graphVar != null && (this.ctx.contextFlags & 4) == 0) {
            set.add(this.graphVar);
        }
        this.log("getDefiniteBoundVars: returning vSet: " + set);
        return set;
    }

    @Override
    public Set<String> getDefiniteBoundAndPushedVars() {
        Set<String> set = this.getDefiniteBoundVars();
        return set;
    }

    @Override
    public Set<String> getProjectVars() {
        return this.getAllLexVars();
    }

    @Override
    public Set<String> getHintVars() {
        return new HashSet<String>();
    }

    @Override
    public Set<String> getLobVars() {
        return this.getAllLexVars();
    }

    @Override
    public Set<String> getVcVars() {
        Set<String> set = Collections.emptySet();
        return set;
    }

    @Override
    public boolean refsNonExistingTerm() {
        return false;
    }

    @Override
    public void setLocalSelectivity() {
    }

    @Override
    public int getLocalSelectivity() {
        return 0;
    }

    @Override
    public void setGlobalSelectivity(int n) {
    }

    @Override
    public String toSQL() throws RDFException {
        this.time_start = System.currentTimeMillis();
        this.ctx.R2RFlags |= 8L;
        String string = new String();
        this.criri_network_storage_form_arg = this.ctx.dbVersion.isCompatible(OracleDatabaseVersion.V_20c) ? ", p_network_storage_form=>'" + this.ctx.networkStorageForm + "'" : "";
        this.use_varchar2_size_limit = this.ctx.networkStorageForm.equals("UNESC") ? this.ctx.networkMaxStringSize / 4 : this.ctx.networkMaxStringSize;
        this.log("toSQL(): entered RDB2RDF java translation code ctx.networkMaxStringSize=" + this.ctx.networkMaxStringSize);
        if (this.filters.size() > 0) {
            this.log("filters [" + this.filters.size() + "]: " + this.filters.toString());
            this.log(this.FilterList_for_Var.toString());
        }
        this.log("toSQL: RelExprFilterList_for_BGP=> " + this.RelExprFilterList_for_BGP.toString());
        this.log("toSQL(): activeGraph=" + this.activeGraph + " graphVar=" + this.graphVar + " ctx.allGraphsDefault=" + this.ctx.allGraphsDefault);
        if (this.ctx.defaultGraphList != null && this.ctx.defaultGraphList.size() > 0) {
            ++this.graph_use_mode;
            this.log("defaultGraphList: " + this.ctx.defaultGraphList);
        }
        if (this.ctx.namedGraphsList != null && this.ctx.namedGraphsList.size() > 0) {
            this.graph_use_mode += 2;
            this.log("namedGraphsList: " + this.ctx.namedGraphsList);
        }
        if (this.activeGraph != null) {
            this.graph_use_mode += 4;
            if (this.graphVar == null) {
                this.is_bgp_graph_const = true;
                this.bgp_graph = "<" + this.activeGraph.name + ">";
            } else {
                this.is_bgp_graph_a_var = true;
                this.bgp_graph = this.graphVar;
            }
            this.log("------------- bgp_graph=" + this.bgp_graph);
        }
        if ((this.ctx.contextFlags & 4) > 0) {
            this.graphMatchUnnamed = true;
        }
        if (this.bgp.TBList.size() == 0 && this.activeGraph != null) {
            if (this.dummyTBList.size() == 0) {
                this.dummyTBList.add(this.composeTripleBlock("dummyS", "dummyP", "dummyO"));
                this.log("dummyTBList populated: " + this.dummyTBList);
            } else {
                this.log("dummyTBList ALREADY populated: " + this.dummyTBList);
            }
        }
        if (this.activeGraph == null && !this.ctx.allGraphsDefault && (this.graph_use_mode & 2) == 0) {
            this.log("no graph-clause, no FROM clause, no FROM NAMED clause, STRICT_DEFAULT=T: MUST skip all RR rows that would produce a non-null or non-rr:defaultGraph graph IRI");
            this.cond_strict_default_graph = " AND ( (rr.POmapGraphConstant is NULL OR rr.POmapGraphConstant = '<http://www.w3.org/ns/r2rml#defaultGraph>') AND  (rr.POmapGraphTemplate is NULL OR rr.POmapGraphTemplate = '<http://www.w3.org/ns/r2rml#defaultGraph>') AND  (rr.Pomapgraphcol is NULL) )";
            this.log("cond_strict_default_graph: " + this.cond_strict_default_graph);
        } else {
            this.cond_strict_default_graph = "";
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        try {
            this.findModelId_for_RDFView();
            String string2 = Integer.toHexString(this.model_id).toUpperCase();
            this.rr_tab_qname = QueryUtils.enquoteNameSQLName(this.ctx.clnNetworkOwner) + "." + QueryUtils.simpleSQLName(QueryUtils.getNetworkNamePfx(this.ctx.clnNetworkName) + "RDF_RR$TAB" + string2, 128);
            this.Ltc_tab_qname = QueryUtils.enquoteNameSQLName(this.ctx.clnNetworkOwner) + "." + QueryUtils.simpleSQLName(QueryUtils.getNetworkNamePfx(this.ctx.clnNetworkName) + "RDF_RR$LTC" + string2, 128);
            this.rr_tab_dummy_query = "select null from " + this.rr_tab_qname;
            this.log("toSQL(): name of rr_tab : " + this.rr_tab_qname);
            boolean bl = true;
            if (this.graph_use_mode == 2) {
                this.log("NoRows case: 010: / - / FROM NAMED / - / : default graph is EMPTY");
            } else if (this.graph_use_mode == 5) {
                this.log("NoRows case: 101: / GRAPH / - / FROM / : list of named graphs is EMPTY");
            } else if ((this.graph_use_mode & 6) == 6 && this.graphVar == null && !RelationalBGP.matchableSqlTemplate_in_list("<" + this.activeGraph.name + ">", this.ctx.namedGraphsList, this.ctx)) {
                this.log("NoRows case: GRAPH constant [<" + this.activeGraph.name + ">] NOT IN named graphs list: " + this.ctx.namedGraphsList);
            } else {
                bl = false;
            }
            if (!bl) {
                this.log("toSQL(): invoking routines to find matching RRrowSets");
                l = System.currentTimeMillis();
                this.importLtcTabRowInfo();
                l2 = System.currentTimeMillis();
                this.log("time_delta time_aft_importLtcTabRowInfo: " + (l2 - l));
                l3 = System.currentTimeMillis();
                this.findMatchingRRrowSets_for_BGPconstants();
                this.log("RRrowSet_for_BGPconst: " + this.RRrowSet_for_BGPconst);
                l4 = System.currentTimeMillis();
                this.log("time_delta time_aft_BGPconstants: " + (l4 - l3));
                this.log("==>RRROWSET_FOR_BGPCONST=" + this.RRrowSet_for_BGPconst.toString());
                this.findMatchingRRrowSets_for_TriplePatterns(1);
                l5 = System.currentTimeMillis();
                this.log("time_delta time_aft_TriplePatterns: " + (l5 - l4));
                this.log("toSQL(): DONE invoking routines to find matching RRrowSets");
            }
            this.log("\n \n");
            this.log("RRrowSet_for_TriplePattern is : \n");
            RelationalBGP.printMapSet(this.RRrowSet_for_TriplePattern, this.ctx);
            this.log("\n\n");
            this.log("RRrowInfo_for_MatchingRows is :\n");
            for (String string3 : this.RRrowSet_for_TriplePattern.keySet()) {
                this.log(" \n \n RRTabRowInfo defined for Triple Pattern " + string3 + "\n");
                Set<String> set = this.RRrowSet_for_TriplePattern.get(string3);
                for (String string4 : set) {
                    this.log("\n rowid info for rowid " + string4 + " :\n " + this.RRrowInfo_for_MatchingRow.get(string4));
                }
                this.log("\n");
            }
            long l6 = System.currentTimeMillis();
            this.prepareForBuildSQL();
            long l7 = System.currentTimeMillis();
            this.log("time_delta time_aft_prepare: " + (l7 - l6));
            this.log("==>LTABEXPR_FOR_TMAP=" + this.LtabExpr_for_Tmap);
            this.log("==>SUBJEXPR_FOR_TMAP=" + this.SubjExpr_for_Tmap);
            this.log("==>STFT_IDX_FOR_TMAP=" + this.sTFT_idx_for_Tmap);
            this.log("==>SUBJRRROWID_FOR_TMAP=" + this.SubjRRrowid_for_Tmap);
            this.log("==>TMAPSET_FOR_TPATCSRGROUP=" + this.TmapSet_for_TpatCSRGroup);
            this.log("==>TPATSET_FOR_TPATCSRGROUP=" + this.TpatSet_for_TpatCSRGroup);
            this.log("==>SUBJ_FOR_TPATCSRGROUP=" + this.Subj_for_TpatCSRGroup);
            this.buildSQLNew();
            long l8 = System.currentTimeMillis();
            this.log("time_delta time_aft_analyze: " + (l8 - l7));
            this.log("==>CSRALIAS_FOR_TPATCSRGROUP=" + this.CSRAlias_for_TpatCSRGroup);
            this.log("==>PREDLIST_FOR_CSRALIAS=" + this.predList_for_CSRAlias);
            this.log("==>OBJELIST_FOR_CSRALIAS=" + this.objeList_for_CSRAlias);
            this.log("==>OCCPOSSET_FOR_CSRALIAS_FOR_VAR=" + this.occPosSet_for_CSRAlias_for_var);
            this.log("==>TYPEINFOSET_FOR_VARPLUSCSRALIAS=" + this.TypeInfoSet_for_VarPlusCSRAlias);
            this.log("==>TRUEMATCHINGRRROWLISTLIST_FOR_CSRALIASPLUSTMAP=" + this.TrueMatchingRRrowListList_for_CSRAliasPlusTmap);
            this.log("final TFTglobalList: " + this.TFTglobalList);
            this.log("final noTFTglobalList: " + this.noTFTglobalList);
            this.log("final TFTinfoGlobalList: " + this.TFTinfoGlobalList.toString());
            this.prepareForGenerateSQL();
            string = this.generateSQL();
            long l9 = System.currentTimeMillis();
            this.log("time_delta time_aft_generate: " + (l9 - l8));
            this.log("\n NEW Generated relational sql in bgpToSQLAgainstRelationa : " + string + " \n");
            long l10 = System.currentTimeMillis();
            this.log("time_delta time_aft_importLtcTabRowInfo: " + (l2 - l));
            this.log("time_delta time_aft_BGPconstants:   " + (l4 - l3));
            this.log("time_delta time_aft_TriplePatterns: " + (l5 - l4));
            this.log("time_delta time_aft_prepare:        " + (l7 - l6));
            this.log("time_delta time_aft_build:          " + (l8 - l7));
            this.log("time_delta time_aft_generate:       " + (l9 - l8));
            this.log("+-- time_delta buildSQL_for_UArow_of_MCSR:");
            for (String string3 : this.time_delta_for_buildSQL_for_UArow_of_MCSR_for_mcsr_plus_UArowNum.keySet()) {
                this.log(String.format("   +-- mcsr_plus_UArowNum=%10s          %10d\n", string3, this.time_delta_for_buildSQL_for_UArow_of_MCSR_for_mcsr_plus_UArowNum.get(string3)));
            }
            this.log("time_delta Total time taken for translation: " + (l10 - this.time_start));
            this.elapsedTimeInfoHandler.finishElapsedTime();
            this.log(this.elapsedTimeInfoHandler.toString());
        }
        catch (RDFException rDFException) {
            throw rDFException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RDFException("toSQL(): Error processing RDB2RDF query. See trace file for details.");
        }
        finally {
            this.ctx.R2RFlags &= 0xFFFFFFFFFFFFFFF7L;
        }
        return string;
    }

    private Set<String> getTriplePatternVars() {
        return new HashSet<String>(this.varset.keySet());
    }

    public String buildWithClause() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.withMap != null && !this.withMap.isEmpty()) {
            stringBuffer.append("WITH ");
            boolean bl = false;
            for (Map.Entry<String, String> entry : this.withMap.entrySet()) {
                if (bl) {
                    stringBuffer.append(",\n");
                }
                bl = true;
                stringBuffer.append(entry.getKey()).append(" AS (").append(entry.getValue()).append(")");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public int getId() {
        return this.id;
    }

    private void populateFromTBs() {
        this.varset = new HashMap<String, String>();
        this.rdfTermSet = new HashMap<String, String>();
        this.extractVariables();
        this.extractRDFTerms();
    }

    private void extractVariables() {
        boolean bl = false;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            int n = 0;
            for (TriplesBlock.Element element : new TriplesBlock.Element[]{triplesBlock.getSubject(), triplesBlock.getPredicate(), triplesBlock.getObject()}) {
                String string = element.getName();
                if (element.isVariable()) {
                    if (!this.varset.containsKey(string)) {
                        this.varset.put(string, this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string).append((String)",").append((int)n).toString()).position);
                    }
                } else if (n != 1) {
                    if (element.getType() == 1) {
                        string = "<" + string + ">";
                    }
                    if (!this.rdfTermSet.containsKey(string)) {
                        this.rdfTermSet.put(string, "object");
                    }
                }
                ++n;
            }
        }
    }

    private void extractRDFTerms() {
        for (String string : this.bgp.BGPelements.keySet()) {
            if (this.bgp.BGPelements.get((Object)string).type.equalsIgnoreCase("0") || this.bgp.BGPelements.get((Object)string).position.equalsIgnoreCase("object")) continue;
            String string2 = string.substring(0, string.lastIndexOf(44));
            this.rdfTermSet.put(string2, this.bgp.BGPelements.get((Object)string).position);
            this.log("extractRDFTerms: rdfTerm=" + string + " (used substr-till-last-comma) name=" + string2);
            this.log("extractRDFTerms: " + this.bgp.BGPelements.get(string).toString());
        }
    }

    private TriplesBlock composeTripleBlock(String string, String string2, String string3) {
        SimpleNode[] simpleNodeArray = new ASTTripleAtom[3];
        simpleNodeArray[0] = new ASTTripleAtom(73);
        simpleNodeArray[0].type = 0;
        simpleNodeArray[0].name = string;
        simpleNodeArray[1] = new ASTTripleAtom(73);
        simpleNodeArray[1].type = 0;
        simpleNodeArray[1].name = string2;
        simpleNodeArray[2] = new ASTTripleAtom(73);
        simpleNodeArray[2].type = 0;
        simpleNodeArray[2].name = string3;
        TriplesBlock triplesBlock = new TriplesBlock(simpleNodeArray, this.ctx);
        return triplesBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findModelId_for_RDFView() throws SQLException, RDFException {
        Connection connection = this.ctx.conn;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String[] stringArray = this.ctx.models;
        String string = QueryUtils.enquoteNameSQLName(this.ctx.clnNetworkOwner) + "." + QueryUtils.simpleSQLName(QueryUtils.getNetworkNamePfx(this.ctx.clnNetworkName) + "RDFM_" + stringArray[0].toUpperCase(), 128);
        String string2 = "SELECT model_id MOD_ID FROM " + string + " WHERE rownum < 2";
        this.log("query_find_model_id: " + string2);
        String string3 = "";
        int n = 0;
        boolean bl = false;
        try {
            preparedStatement = connection.prepareStatement(string2);
            this.log("query_find_model_id: " + string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                bl = true;
                this.model_id = resultSet.getInt("MOD_ID");
                this.log("model_name (given): " + stringArray[0].toUpperCase() + " found model_id=" + this.model_id);
            }
        }
        catch (SQLException sQLException) {
            n = sQLException.getErrorCode();
            this.log("ret_code=" + n);
            if (Math.abs(n) == 1403) {
                throw sQLException;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (!bl) {
            throw new RDFException("model is not associated with any relational data");
        }
    }

    private String findTerm_for_Element(TriplesBlock.Element element, String string, boolean bl) throws RDFException {
        int n = element.getType();
        String string2 = element.getName();
        String string3 = null;
        String string4 = element.getLitType();
        String string5 = element.getLitLang();
        this.log("findTerm_for_Element: [name=" + string2 + " type=" + n + " litType=" + string4 + " id=" + element.getCanonicalID() + "] elem.toString(): " + element.toString());
        if (element.isVariable()) {
            return element.getName();
        }
        if (string.equalsIgnoreCase("subject") || string.equalsIgnoreCase("predicate") || string.equalsIgnoreCase("graph")) {
            string3 = "<" + element.getName() + ">";
        } else if (string.equalsIgnoreCase("object")) {
            if (n == 1) {
                string3 = "<" + string2 + ">";
            } else if (n == 3) {
                string3 = "\"" + string2 + "\"";
            } else if (n == 2) {
                string3 = "\"" + string2 + "\"^^<" + string4 + ">";
            } else if (n == 4) {
                string3 = "\"" + string2 + "\"@" + string5;
            } else if (n == 5) {
                string3 = string4.equalsIgnoreCase(XSD_STRING_NO_ENCLOSING) ? "\"" + string2 + "\"" : "\"" + string2 + "\"^^<" + string4 + ">";
            } else {
                if (n == 6) {
                    throw new RDFException("Feature not supported: Typed-Literal with Language-Tag: elemType=" + n + " name=" + string2 + " litType=" + string4 + " litLang=" + string5);
                }
                throw new RDFException("Feature not supported: non-URI and non-PlainLiteral: elemType=" + n + " name=" + string2);
            }
            String string6 = this.getCanonVal(string3);
            if (string6 != null) {
                string3 = string6;
            }
        } else {
            throw new RDFException("INTERNAL ERROR: findTerm_for_Element: position=" + string);
        }
        this.log("returning elemTerm=" + string3);
        return string3;
    }

    private String findTerm_from_BGPNodeInfo(BGPNodeInfo bGPNodeInfo) throws SQLException, RDFException {
        Object object;
        String string;
        Connection connection = this.ctx.conn;
        String string2 = "";
        String string3 = bGPNodeInfo.name.substring(0, bGPNodeInfo.name.lastIndexOf(44));
        this.log("name=" + string3);
        if (string3.charAt(0) != '>' && string3.charAt(0) != '\"') {
            string = "SELECT /*+ index(v,C_PK_VID) */ sem_apis.compose_rdf_term(value_name,value_type,literal_type,language_type) rdfterm   FROM " + this.ctx.clnPfxForRdfObjName + "rdf_value$ v  WHERE v.value_id=:1";
            PreparedStatement preparedStatement = null;
            object = null;
            int n = 0;
            String string4 = "";
            try {
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setString(1, string3);
                object = preparedStatement.executeQuery();
                while (object.next()) {
                    string2 = object.getString("RDFTERM");
                    string4 = string4 + " [" + ++n + "]: " + string2;
                }
            }
            catch (Exception exception) {
                if (object != null) {
                    object.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                exception.printStackTrace();
                throw new RDFException("[see trace file for more details] Failed while trying to retrieve RDFTERM for value_id=" + string3);
            }
            finally {
                if (object != null) {
                    object.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            if (n == 1) {
                return string2;
            }
            if (n == 0) {
                throw new RDFException("No RDFTERM found for value_id=" + string3);
            }
            if (n > 1) {
                throw new RDFException("Multiple RDFTERMs found for value_id=" + string3 + string4);
            }
        }
        string = string3.substring(1, string3.length() - 1);
        int n = Integer.parseInt(bGPNodeInfo.type);
        this.log("type=" + n);
        object = bGPNodeInfo.litType;
        String string5 = bGPNodeInfo.litLang;
        if (n == 1) {
            string2 = "<" + string + ">";
        } else if (n == 3) {
            string2 = "\"" + string + "\"";
        } else if (n == 2) {
            string2 = "\"" + string + "\"^^<" + (String)object + ">";
        } else if (n == 4) {
            string2 = "\"" + string + "\"@" + string5;
        } else if (n == 5) {
            string2 = ((String)object).equalsIgnoreCase(XSD_STRING_NO_ENCLOSING) ? "\"" + string + "\"" : "\"" + string + "\"^^<" + (String)object + ">";
        } else {
            if (n == 6) {
                throw new RDFException("Feature not supported: Typed-Literal with Language-Tag: type=" + n + " name=" + string3 + " litType=" + (String)object + " litLang=" + string5);
            }
            throw new RDFException("Feature not supported: non-URI and non-PlainLiteral: type=" + n + " name=" + string3);
        }
        this.log("term=" + string2);
        return string2;
    }

    private String constructKey_for_TriplePattern(TriplesBlock.Element element, TriplesBlock.Element element2, TriplesBlock.Element element3) throws RDFException {
        String string;
        String string2 = string = this.findTerm_for_Element(element, "subject", true);
        string = this.findTerm_for_Element(element2, "predicate", true);
        string2 = string2 + "+" + string;
        string = this.findTerm_for_Element(element3, "object", true);
        string2 = string2 + "+" + string;
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processFetchedRRrow(ResultSet resultSet, Set<String> set, List<String> list, String string, String string2) throws SQLException, RDFException {
        TFTinfo tFTinfo;
        Object object;
        String[] stringArray = new String[2];
        String string3 = null;
        Integer n = 0;
        String string4 = null;
        Integer n2 = 0;
        String string5 = null;
        Integer n3 = 0;
        String string6 = null;
        Integer n4 = 0;
        String string7 = null;
        Integer n5 = 0;
        String[] stringArray2 = new String[2];
        String string8 = resultSet.getString("ROWID");
        String string9 = resultSet.getString("Tmap");
        String string10 = resultSet.getString("tabName");
        String string11 = resultSet.getString("qry");
        String string12 = resultSet.getString("sqlv");
        String string13 = resultSet.getString("subjTemplate");
        String string14 = resultSet.getString("subjCol");
        String string15 = resultSet.getString("subjConstant");
        String string16 = resultSet.getString("subjTermType");
        String string17 = resultSet.getString("subjUnique");
        boolean bl = true;
        if (string17.indexOf("false") != -1) {
            this.Tmaps_with_nonUnique_Smaps.add(string9);
            bl = false;
        }
        String string18 = resultSet.getString("POmapGraphTemplate");
        String string19 = resultSet.getString("POmapGraphCol");
        String string20 = resultSet.getString("POmapGraphConstant");
        String string21 = resultSet.getString("predTemplate");
        String string22 = resultSet.getString("predCol");
        String string23 = resultSet.getString("predConstant");
        String string24 = resultSet.getString("Omap");
        String string25 = resultSet.getString("objeTemplate");
        String string26 = resultSet.getString("objeCol");
        String string27 = resultSet.getString("objeConstant");
        String string28 = resultSet.getString("objeTermType");
        String string29 = resultSet.getString("objeDataType");
        boolean bl2 = false;
        Object object2 = resultSet.getString("objeLanguage");
        if (object2 != null) {
            object2 = ((String)object2).toLowerCase();
        }
        String string30 = resultSet.getString("parentTmap");
        int n6 = resultSet.getInt("flags");
        this.log("retrieved RRrowFlags=" + n6);
        this.RRrowFlags_for_Tmap.put(string9, n6);
        String string31 = resultSet.getString("RDFdatatype_DBColType");
        String string32 = resultSet.getString("paTabName");
        String string33 = resultSet.getString("paQry");
        String string34 = resultSet.getString("paSqlV");
        String string35 = resultSet.getString("paSubjTemplate");
        String string36 = resultSet.getString("paSubjCol");
        String string37 = resultSet.getString("paSubjConstant");
        String string38 = resultSet.getString("paSubjTermType");
        String string39 = resultSet.getString("refJoinStr");
        this.log("processFetchedRRrow: checking RRrowid=" + string8 + " CUMULATIVE time: " + (System.currentTimeMillis() - this.time_start), 4L);
        if (string != null) {
            object = null;
            if (string.equals("object") && string25 != null) {
                object = string25;
            } else if (string.equals("object") && string35 != null) {
                object = string35;
            } else if (string.equals("graph") && string18 != null) {
                object = string18;
            }
            if (object != null) {
                this.log("checking matchability of pos+bgpConstVal=" + string + "+" + string2 + " and template=" + (String)object);
                if (!RelationalBGP.matchableSqlTemplatePair(string2, (String)object, this.ctx)) {
                    this.log("SKIP RRrowid=" + string8 + ": NO matchability of pos+bgpConstVal=" + string + "+" + string2 + " and template=" + (String)object);
                    return;
                }
            }
        }
        if (set != null) {
            set.add(string8);
            this.log("ROWID=" + string8 + " added to RRrowSet: size=" + set.size());
        }
        if (list != null) {
            list.add(string8);
            this.log("ROWID=" + string8 + " added to RRrowList: size=" + list.size());
        }
        object = new ArrayList();
        List<String> list2 = null;
        List<String> list3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list4 = null;
        List<String> list5 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        List<String> list6 = null;
        List<String> list7 = null;
        ArrayList<String> arrayList3 = new ArrayList<String>();
        List<String> list8 = null;
        List<String> list9 = null;
        ArrayList<String> arrayList4 = new ArrayList<String>();
        List<String> list10 = null;
        List<String> list11 = null;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        if (string30 != null) {
            this.log("REF CONSTRAINT processing logic");
            this.log("\n Parent tmap " + string30 + " found for tmap and pexpr(pexprtype) " + string9 + "+" + string4 + "(" + n2 + ") and rowid = " + string8);
            if (string32 != null) {
                stringArray2 = this.resolveOwnTabNames(string32);
            }
            if (string35 != null) {
                string7 = string35;
                n5 = RRTabRowInfo.MapExprType_TEMPLATE;
            } else if (string37 != null) {
                string7 = string37.replace("'", "''");
                n5 = RRTabRowInfo.MapExprType_CONSTANT;
            } else {
                if (string36 == null) throw new RDFException("processFetchedRRrow: psExpr is null for parenttmap=" + string30 + " [tmap=" + string9 + "]");
                string7 = string36;
                n5 = RRTabRowInfo.MapExprType_COLUMN;
            }
            n10 = this.add_TFT(string30, string7, n5, string38, null, null, (List<String>)object);
            tFTinfo = this.TFTinfoGlobalList.get(n10);
            list2 = tFTinfo.strList;
            list3 = tFTinfo.colTypeList;
            this.log("psStrList=" + list2);
            this.log("psColTypeList=" + list3);
        }
        if (!this.RRrowInfo_for_MatchingRow.containsKey(string8)) {
            Object object3;
            if (string10 != null) {
                stringArray = this.resolveOwnTabNames(string10);
            }
            if (string13 != null) {
                string3 = string13;
                n = RRTabRowInfo.MapExprType_TEMPLATE;
            } else if (string15 != null) {
                string3 = string15.replace("'", "''");
                n = RRTabRowInfo.MapExprType_CONSTANT;
            } else {
                if (string14 == null) throw new RDFException("processFetchedRRrow: sexpr is null for tmap=" + string9);
                string3 = string14;
                n = RRTabRowInfo.MapExprType_COLUMN;
            }
            n7 = this.add_TFT(string9, string3, n, string16, null, null, arrayList);
            tFTinfo = this.TFTinfoGlobalList.get(n7);
            list4 = tFTinfo.strList;
            list5 = tFTinfo.colTypeList;
            this.log("sStrList=" + list4);
            this.log("sColTypeList=" + list5);
            if (string21 != null) {
                string4 = string21;
                n2 = RRTabRowInfo.MapExprType_TEMPLATE;
            } else if (string23 != null) {
                string4 = string23.replace("'", "''");
                n2 = RRTabRowInfo.MapExprType_CONSTANT;
            } else {
                if (string22 == null) throw new RDFException("processFetchedRRrow: pexpr is null for tmap=" + string9);
                string4 = string22;
                n2 = RRTabRowInfo.MapExprType_COLUMN;
            }
            n8 = this.add_TFT(string9, string4, n2, rrIRI, null, null, arrayList2);
            tFTinfo = this.TFTinfoGlobalList.get(n8);
            list6 = tFTinfo.strList;
            list7 = tFTinfo.colTypeList;
            this.log("pStrList=" + list6);
            this.log("pColTypeList=" + list7);
            if (string18 != null) {
                string5 = string18;
                n3 = RRTabRowInfo.MapExprType_TEMPLATE;
            } else if (string20 != null) {
                if (string20.equals(rrDefaultGraph)) {
                    string5 = null;
                    n3 = 0;
                } else {
                    string5 = string20.replace("'", "''");
                    n3 = RRTabRowInfo.MapExprType_CONSTANT;
                }
            } else if (string19 != null) {
                string5 = string19;
                n3 = RRTabRowInfo.MapExprType_COLUMN;
            }
            if (string5 != null || this.activeGraph != null && this.graphVar != null && this.graphMatchUnnamed) {
                n11 = this.add_TFT(string9, string5, n3, rrIRI, null, null, arrayList3);
                if (string5 == null) {
                    this.log("add a dummy TFT with NULL as the template: to account for match with NULL graph");
                }
                tFTinfo = this.TFTinfoGlobalList.get(n11);
                list8 = tFTinfo.strList;
                list9 = tFTinfo.colTypeList;
                this.log("pogStrList=" + list8);
                this.log("pogColTypeList=" + list9);
            }
            if (string25 != null) {
                string6 = string25;
                n4 = RRTabRowInfo.MapExprType_TEMPLATE;
                if (string29 != null || object2 != null) {
                    if (string28 == null) {
                        string28 = rrLiteral;
                    } else if (!string28.equals(rrLiteral)) {
                        throw new RDFException("Found incorrect otermtype=" + string28 + ": must be " + rrLiteral + " because: odatatype (" + string29 + ") or olanguage (" + (String)object2 + ") is non-null");
                    }
                } else if (string28 == null) {
                    string28 = rrIRI;
                }
                if (string28.equals(rrLiteral) && string29 == null && object2 == null) {
                    string29 = XSD_STRING;
                }
            } else if (string27 != null) {
                string6 = string27.replace("'", "''");
                n4 = RRTabRowInfo.MapExprType_CONSTANT;
                object3 = new String[4];
                this.findComponents_of_RDFterm_simple(string27, (String[])object3);
                if (object3[1].equals("UR")) {
                    string28 = rrIRI;
                } else if (object3[1].equals("BN")) {
                    string28 = rrBlankNode;
                } else {
                    if (!object3[1].equals("PL") && !object3[1].equals("TL") && !((String)object3[1]).equals("PL@")) throw new RDFException("Unknown Value_Type (" + (String)object3[1] + ") extracted from oconst=" + string27);
                    string28 = rrLiteral;
                    string29 = "<" + (String)object3[2] + ">";
                    if (((String)object3[1]).equals("PL")) {
                        bl2 = true;
                    }
                    object2 = object3[3];
                }
            } else if (string26 != null) {
                object3 = RelationalBGP.get_base_prefix_from_RR_table(string26);
                String string40 = object3 != null ? RelationalBGP.get_col_name_from_RR_table(string26) : string26;
                string6 = string26;
                n4 = RRTabRowInfo.MapExprType_COLUMN;
                if (string28 == null) {
                    string28 = rrLiteral;
                }
                if (string28.equals(rrLiteral) && string29 == null && object2 == null) {
                    this.log("odatatype=null: setting it to the appropriate non-null value (otermtype=" + string28 + ")");
                    String string41 = string40.charAt(0) == '\"' ? string40.substring(1, string40.length() - 1) : string40.toUpperCase();
                    LtcTabRowInfo ltcTabRowInfo = this.LtcRowInfo_for_Tmap_plus_Col.get(string9 + "+" + string41);
                    if (ltcTabRowInfo == null) {
                        this.log("LtcRowInfo == null [tmap=" + string9 + ", ocolName=" + string40 + ", ocol=" + string26 + "]");
                        throw new RDFException("LtcRowInfo == null [tmap=" + string9 + ", ocolName=" + string40 + ", ocol=" + string26 + "]");
                    }
                    if (ltcTabRowInfo.colTypeName.equals("STRING")) {
                        string29 = XSD_STRING;
                    } else if (ltcTabRowInfo.colTypeName.equals(LTC_TYPE_NUMBER)) {
                        string29 = XSD_DECIMAL;
                    } else if (ltcTabRowInfo.colTypeName.equals("DATE")) {
                        string29 = XSD_DATE;
                    } else if (ltcTabRowInfo.colTypeName.equals(LTC_TYPE_TIMESTAMP) || ltcTabRowInfo.colTypeName.equals(LTC_TYPE_TIMESTAMP_TZ) || ltcTabRowInfo.colTypeName.equals(LTC_TYPE_TIMESTAMP_LTZ)) {
                        string29 = XSD_DATETIME;
                    } else if (ltcTabRowInfo.colTypeName.equals(LTC_TYPE_BFLOAT)) {
                        string29 = XSD_FLOAT;
                    } else {
                        if (!ltcTabRowInfo.colTypeName.equals(LTC_TYPE_BDOUBLE)) throw new RDFException("Unsupported LtcRowInfo.colTypeName: " + ltcTabRowInfo.colTypeName);
                        string29 = XSD_DOUBLE;
                    }
                    this.log("odatatype changed from null to: " + string29 + ")");
                }
            }
            if (string6 != null) {
                n9 = this.add_TFT(string9, string6, n4, string28, string29, (String)object2, arrayList4);
                tFTinfo = this.TFTinfoGlobalList.get(n9);
                list10 = tFTinfo.strList;
                list11 = tFTinfo.colTypeList;
                this.log("oStrList=" + list10);
                this.log("oColTypeList=" + list11);
            }
            if (string6 == null && string7 == null) {
                throw new RDFException("processFetchedRRrow: oexpr is null AND psexpr is null for tmap=" + string9);
            }
            if (this.TmapInfo_for_Tmap.get(string9) == null) {
                object3 = new TmapInfo(string9, n6, string3, arrayList, n7);
                this.TmapInfo_for_Tmap.put(string9, (TmapInfo)object3);
                this.log("processFetchedRRrow: added new TmapInfo: for tmap=" + string9 + ": [" + ((TmapInfo)object3).toString() + "]");
            }
            object3 = new RRTabRowInfo(string8, string9, stringArray[0], stringArray[1], string11, string12, string3, n, string16, n7, arrayList, list4, list5, string5, n3, n11, arrayList3, list8, list9, string4, n2, n8, arrayList2, list6, list7, string24, string6, n4, string28, string29, bl2, (String)object2, n9, arrayList4, list10, list11, string30, stringArray2[0], stringArray2[1], string33, string34, string7, n5, string38, n10, (List<String>)object, list2, list3, string39, string31, bl, this.ctx);
            this.RRrowInfo_for_MatchingRow.put(string8, (RRTabRowInfo)object3);
            this.log("after insertion of row " + string8 + " into tabrowinfo set " + ((RRTabRowInfo)object3).toString() + " CUMULATIVE time: " + (System.currentTimeMillis() - this.time_start), 4L);
            return;
        } else {
            this.log("SKIPPED rowid: " + string8 + " CUMULATIVE time: " + (System.currentTimeMillis() - this.time_start), 4L);
        }
    }

    private void importLtcTabRowInfo() throws SQLException, RDFException {
        Connection connection = this.ctx.conn;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "SELECT Tmap, col_Name, col_type, col_type_name, col_max_len, col_precision, col_scale FROM " + this.Ltc_tab_qname + " ltc";
        try {
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            this.LtcRowInfo_for_Tmap_plus_Col = new HashMap();
            while (resultSet.next()) {
                String string2 = resultSet.getString("Tmap");
                String string3 = resultSet.getString("col_name");
                Integer n = resultSet.getInt("col_type");
                String string4 = resultSet.getString("col_type_name");
                Integer n2 = resultSet.getInt("col_max_len");
                Integer n3 = resultSet.getInt("col_precision");
                Integer n4 = resultSet.getInt("col_scale");
                LtcTabRowInfo ltcTabRowInfo = new LtcTabRowInfo(string2, string3, n, string4, n2, n3, n4);
                String string5 = string2 + "+" + string3;
                this.LtcRowInfo_for_Tmap_plus_Col.put(string5, ltcTabRowInfo);
                this.log("after insertion of LtcRow: key (Tmap+colName)=" + string5 + " type info:\n" + ltcTabRowInfo.toString());
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            this.log("ret_code=" + n);
            if (Math.abs(n) == 942) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                this.log("LTC table (" + this.Ltc_tab_qname + ") not present in the database");
            }
            sQLException.printStackTrace();
            throw new RDFException("LTC table (" + this.Ltc_tab_qname + ") for RDFView model (" + this.ctx.models[0].toUpperCase() + ") not present in the database.\nTo fix it, log in as the owner of this RDFView model and then use the following command:\nsem_apis.create_rdfview_model('" + this.ctx.models[0].toUpperCase() + "',null,null,options => ' COL_DEFS_ONLY=T ');");
        }
        catch (Exception exception) {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            exception.printStackTrace();
            throw new RDFException("[see trace file for more details] Failed while fetching rows from LTC table (" + this.Ltc_tab_qname + ")");
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    private void fetchGeometryColMetadata(LtcTabRowInfo ltcTabRowInfo, String string, String string2, String string3) throws SQLException, RDFException {
        block16: {
            String string4 = " GCM.SRID,\n DI.SDO_DIMNAME , DI.SDO_LB, DI.SDO_UB, DI.SDO_TOLERANCE";
            String string5 = "MDSYS.ALL_SDO_GEOM_METADATA";
            Connection connection = this.ctx.conn;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            String string6 = string.charAt(0) != '\"' ? string.toUpperCase() : string.substring(1, string.length() - 1);
            String string7 = string2.charAt(0) != '\"' ? string2.toUpperCase() : string2.substring(1, string2.length() - 1);
            String string8 = string3.charAt(0) != '\"' ? string3.toUpperCase() : string3.substring(1, string3.length() - 1);
            String string9 = "SELECT " + string4 + "\n  FROM " + string5 + " GCM, TABLE(GCM.DIMINFO) DI \n WHERE GCM.OWNER = :ownerName_in_db \n   AND GCM.TABLE_NAME = :tableName_in_db \n   AND GCM.COLUMN_NAME = :geoColName_in_db ";
            this.log("[ML] query_for_geometryColMetadata: \n" + string9 + "\n WITH\n ownerName_in_db=" + string6 + " tableName_in_db=" + string7 + " geoColName_in_db=" + string8);
            try {
                preparedStatement = connection.prepareStatement(string9);
                preparedStatement.setString(1, string6);
                preparedStatement.setString(2, string7);
                preparedStatement.setString(3, string8);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string10 = resultSet.getString("SRID");
                    String string11 = resultSet.getString("SDO_DIMNAME");
                    String string12 = resultSet.getString("SDO_LB");
                    String string13 = resultSet.getString("SDO_UB");
                    String string14 = resultSet.getString("SDO_TOLERANCE");
                    ltcTabRowInfo.setGeomMetadata(string10, string11, string12, string13, string14);
                    this.log("after gathering SDO_GEOMETRY metadata of LtcRow: key (Tmap+colName)=" + ltcTabRowInfo.Tmap + "+" + ltcTabRowInfo.colName + " type info:\n" + ltcTabRowInfo.toString());
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                int n = sQLException.getErrorCode();
                this.log("ret_code=" + n);
                if (Math.abs(n) == 942) {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    this.log("LTC table (" + this.Ltc_tab_qname + ") not present in the database");
                    break block16;
                }
                throw sQLException;
            }
            catch (Exception exception) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                exception.printStackTrace();
                throw new RDFException("[see trace file for more details] Failed while adding SDO_GEOMETRY metadata");
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    private String getCanonVal(String string) {
        this.log("getCanonVal: input=" + string);
        char c = string.charAt(0);
        char c2 = string.charAt(string.length() - 1);
        if (c == '<' && c2 == '>') {
            return string;
        }
        if (c == '\"' && c2 == '\"') {
            return string;
        }
        if (c == '\"' && c2 == '>') {
            int n = string.lastIndexOf("\"^^<");
            String string2 = string.substring(n + 4, string.length() - 1);
            String string3 = this.TYPE_FAMILY(string2);
            String string4 = string.substring(1, n);
            this.log("getCanonVal: TL: tyfam=" + string3 + " vname: " + string4 + " ltype: " + string2);
            if ("STRING".equals(string3)) {
                return "\"" + string4 + "\"";
            }
            List<String> list = Arrays.asList(TYPE_FAM_NUMERIC, TYPE_FAM_FLOAT, TYPE_FAM_DOUBLE, TYPE_FAM_RAW, "DATE", TYPE_FAM_DATETIME, TYPE_FAM_TIME);
            if (list.contains(string3) || string4.isEmpty()) {
                return null;
            }
            if (TYPE_FAM_BOOLEAN.equals(string3)) {
                return "\"" + (string4.toUpperCase().equals("TRUE") || string4.equals("1") ? "true" : "false") + "\"^^<" + "http://www.w3.org/2001/XMLSchema#boolean" + ">";
            }
            if ("SDO_GEOMETRY".equals(string3) || TYPE_FAM_OTHER.equals(string3)) {
                return string;
            }
        } else {
            if (c == '\"' && string.lastIndexOf("\"@") > 1) {
                String string5 = string.substring(string.lastIndexOf("\"@") + 2);
                if (string5.equals(string5.toLowerCase())) {
                    return string;
                }
                return string.substring(0, string.lastIndexOf("\"@") + 2) + string5.toLowerCase();
            }
            try {
                double d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void findMatchingRRrowSets_for_BGPconstants() throws RDFException, SQLException {
        Object object;
        Connection connection = this.ctx.conn;
        Statement statement = null;
        Statement statement2 = null;
        Statement statement3 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = this.rr_tab_qname;
        String string2 = "SELECT rr.rowid, Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr FROM " + string + " rr WHERE (rr.subjTemplate is NOT NULL     OR rr.subjCol is NOT NULL     OR rr.subjConstant=:1) " + this.cond_strict_default_graph;
        String string3 = "SELECT rr.rowid, Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr FROM " + string + " rr WHERE (rr.predTemplate is NOT NULL     OR rr.predCol is NOT NULL     OR rr.predConstant=:1) " + this.cond_strict_default_graph;
        String string4 = " SELECT rr.rowid, Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr FROM " + string + " rr  WHERE (((rr.objeCol is NOT NULL OR rr.objeTemplate is NOT NULL) AND rr.objeTermType=:1)      OR rr.objeConstant=sdo_rdf.get_canon_val(:2,' GCVN_ALLOW_VALUE_ID ')) " + this.cond_strict_default_graph + " UNION  SELECT rr.rowid" + RRrowSelList + " FROM " + string + " rr  WHERE (parentTmap is NOT NULL    and parentTmap in ( select distinct Tmap from " + string + " rr   where subjTemplate is NOT NULL or subjCol is NOT NULL or (subjConstant = :3))) " + this.cond_strict_default_graph;
        String string5 = "SELECT rr.rowid, Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr FROM " + string + " rr WHERE rr.POmapGraphTemplate is NOT NULL     OR rr.POmapGraphCol      is NOT NULL     OR rr.POmapGraphConstant=:1 ";
        try {
            String string6;
            Object object2;
            String string7;
            String string8;
            Object object3;
            Object object4;
            String string922;
            boolean bl;
            Set<String> set;
            String string10;
            Object object5;
            HashSet hashSet = new HashSet();
            HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
            preparedStatement = connection.prepareStatement(string5);
            this.log("DEBUG: findMatchingRRrowSets_for_BGPconstants: graph clause check: " + this.graph_use_mode + BASE_PREFIX_COLNAME_SEP + this.activeGraph + BASE_PREFIX_COLNAME_SEP + this.graphVar + BASE_PREFIX_COLNAME_SEP + this.ctx.allGraphsDefault);
            if (this.activeGraph != null && this.graphVar == null) {
                object5 = "<" + this.activeGraph.name + ">";
                string10 = "graph";
                preparedStatement.setString(1, (String)object5);
                resultSet = preparedStatement.executeQuery();
                set = this.RRrowSet_for_BGPconst.get(string10 + "+" + (String)object5);
                if (set == null) {
                    this.log("--------------- compute RRrowSet pos+bgpConstVal=" + string10 + "+" + (String)object5);
                    set = new HashSet<String>();
                    this.RRrowSet_for_BGPconst.put(string10 + "+" + (String)object5, set);
                    bl = true;
                } else {
                    this.log("SKIP: RRrowSet already exists for bgpConstPos+bgpConstVal=" + string10 + "+" + (String)object5 + " RRrowSet:" + set + " tmp_RRrowSet: " + hashSet);
                    bl = false;
                }
                while (resultSet.next()) {
                    this.processFetchedRRrow(resultSet, set, null, string10, (String)object5);
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            this.log("time_delta CUMULATIVE before Getting RRrowSet for subject, predicate, object component: " + (System.currentTimeMillis() - this.time_start), 4L);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<Object> arrayList4 = new ArrayList<Object>();
            for (String string922 : this.bgp.BGPelements.keySet()) {
                BGPNodeInfo bGPNodeInfo = this.bgp.BGPelements.get(string922);
                this.log("findMatchingRRrowSets_for_BGPconstants: rdfTerm=" + string922 + " : bgpNode=" + bGPNodeInfo.toString() + " time_delta CUMULATIVE: " + (System.currentTimeMillis() - this.time_start), 4L);
                if (bGPNodeInfo.type.equals("0")) continue;
                object5 = this.findTerm_from_BGPNodeInfo(bGPNodeInfo);
                string10 = bGPNodeInfo.position;
                char c = ((String)object5).charAt(0);
                object = c == '<' ? rrIRI : (c == '\"' ? rrLiteral : rrBlankNode);
                this.log("[bgpConstPos+bgpConstVal+bgpConstTermType]: " + string10 + "+" + (String)object5 + "+" + (String)object);
                if (string10.equalsIgnoreCase("predicate")) {
                    arrayList.add(object5);
                    continue;
                }
                if (string10.equalsIgnoreCase("subject")) {
                    arrayList2.add(object5);
                    continue;
                }
                if (string10.equalsIgnoreCase("object")) {
                    String string11 = this.getCanonVal((String)object5);
                    this.log("fmrrfbc: bgpConstVal=" + (String)object5 + " bgpConstCanonVal=" + string11);
                    if (string11 == null) {
                        if (statement3 == null) {
                            statement3 = connection.prepareStatement(string4);
                        }
                        statement3.setString(1, (String)object);
                        statement3.setString(2, (String)object5);
                        statement3.setString(3, (String)object5);
                        resultSet = statement3.executeQuery();
                    } else {
                        arrayList3.add(string11);
                        arrayList4.add(object);
                        continue;
                    }
                }
                if ((set = this.RRrowSet_for_BGPconst.get(string10 + "+" + (String)object5)) != null) {
                    this.log("SKIP: RRrowSet already exists for bgpConstPos+bgpConstVal=" + string10 + "+" + (String)object5 + " RRrowSet:" + set + " tmp_RRrowSet: " + hashSet);
                    bl = false;
                    continue;
                }
                this.log("--------------- compute RRrowSet pos+bgpConstVal=" + string10 + "+" + (String)object5);
                set = new HashSet<String>();
                this.RRrowSet_for_BGPconst.put(string10 + "+" + (String)object5, set);
                bl = true;
                this.log("findMatchingRRrowSets_for_BGPconstants: Ready to processFetchedRRrow: rdfTerm=" + string922 + " : bgpNode=" + bGPNodeInfo.toString() + " time_delta CUMULATIVE: " + (System.currentTimeMillis() - this.time_start), 4L);
                while (resultSet.next()) {
                    this.log(" time_delta CUMULATIVE: [=>" + (System.currentTimeMillis() - this.time_start) + "] doing 1 processFetchedRRrow: rdfTerm=" + string922, 4L);
                    this.processFetchedRRrow(resultSet, set, null, string10, (String)object5);
                    this.log(" time_delta CUMULATIVE: [" + (System.currentTimeMillis() - this.time_start) + "<=] DONE  1 processFetchedRRrow: rdfTerm=" + string922, 4L);
                }
                if (resultSet == null) continue;
                resultSet.close();
            }
            if (arrayList.size() > 0) {
                int n;
                this.log(Arrays.toString(arrayList.toArray()));
                string10 = "predicate";
                string3 = "SELECT rr.rowid, Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr FROM " + string + " rr WHERE (rr.predTemplate is NOT NULL     OR rr.predCol is NOT NULL     OR rr.predConstant IN ";
                object4 = "";
                string922 = "(";
                for (n = 1; n <= arrayList.size(); ++n) {
                    object4 = (String)object4 + string922 + ":" + n;
                    string922 = ",";
                }
                object4 = (String)object4 + ")";
                string3 = string3 + (String)object4 + ")" + this.cond_strict_default_graph;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                statement = connection.prepareStatement(string3);
                for (n = 1; n <= arrayList.size(); ++n) {
                    statement.setString(n, (String)arrayList.get(n - 1));
                }
                resultSet = statement.executeQuery();
                n = 0;
                while (resultSet.next()) {
                    ++n;
                    String string12 = resultSet.getString("ROWID");
                    int n2 = 0;
                    object3 = arrayList.iterator();
                    while (object3.hasNext()) {
                        string8 = (String)object3.next();
                        set = this.RRrowSet_for_BGPconst.get(string10 + "+" + string8);
                        if (set == null) {
                            this.log("--------------- compute RRrowSet pos+bgpConstVal=" + string10 + "+" + string8);
                            set = new HashSet<String>();
                            this.RRrowSet_for_BGPconst.put(string10 + "+" + string8, set);
                            bl = true;
                        } else {
                            this.log("SKIP: RRrowSet already exists for bgpConstPos+bgpPredConstVal=" + string10 + "+" + string8 + " RRrowSet:" + set + " tmp_RRrowSet: " + hashSet);
                            bl = false;
                        }
                        string7 = resultSet.getString("predCol");
                        object2 = resultSet.getString("predConstant");
                        string6 = resultSet.getString("predTemplate");
                        if (string7 != null || object2 != null && ((String)object2).equals(string8)) {
                            set.add(string12);
                            ++n2;
                            continue;
                        }
                        if (string6 == null) continue;
                        if (!RelationalBGP.matchableSqlTemplatePair(string8, string6, this.ctx)) {
                            this.log("SKIP rowid=" + string12 + ": NO matchability of pos+bgpConstVal=predicate+" + string8 + " and template=" + string6);
                            continue;
                        }
                        set.add(string12);
                        ++n2;
                    }
                    if (n2 <= 0 || (object3 = this.RRrowInfo_for_MatchingRow.get(string12)) != null) continue;
                    this.processFetchedRRrow(resultSet, null, null, "predicate", null);
                    object3 = this.RRrowInfo_for_MatchingRow.get(string12);
                }
                if (n == 0) {
                    for (String string13 : arrayList) {
                        if (this.RRrowSet_for_BGPconst.get(string10 + "+" + string13) != null) continue;
                        this.RRrowSet_for_BGPconst.put(string10 + "+" + string13, new HashSet());
                    }
                }
            }
            if (arrayList2.size() > 0) {
                int n;
                this.log("subjList [size=" + arrayList2.size() + "]: " + Arrays.toString(arrayList2.toArray()));
                string10 = "subject";
                string2 = "SELECT rr.rowid, Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr FROM " + string + " rr WHERE (rr.subjTemplate is NOT NULL     OR rr.subjCol is NOT NULL     OR rr.subjConstant IN ";
                object4 = "";
                string922 = "(";
                for (n = 1; n <= arrayList2.size(); ++n) {
                    object4 = (String)object4 + string922 + ":" + n;
                    string922 = ",";
                }
                object4 = (String)object4 + ")";
                string2 = string2 + (String)object4 + ")" + this.cond_strict_default_graph;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
                statement2 = connection.prepareStatement(string2);
                for (n = 1; n <= arrayList2.size(); ++n) {
                    statement2.setString(n, (String)arrayList2.get(n - 1));
                }
                resultSet = statement2.executeQuery();
                n = 0;
                while (resultSet.next()) {
                    ++n;
                    String string14 = resultSet.getString("ROWID");
                    int n3 = 0;
                    object3 = arrayList2.iterator();
                    while (object3.hasNext()) {
                        string8 = (String)object3.next();
                        set = this.RRrowSet_for_BGPconst.get(string10 + "+" + string8);
                        if (set == null) {
                            this.log("--------------- compute RRrowSet pos+bgpConstVal=" + string10 + "+" + string8);
                            set = new HashSet<String>();
                            this.RRrowSet_for_BGPconst.put(string10 + "+" + string8, set);
                            bl = true;
                        } else {
                            this.log("SKIP: RRrowSet already exists for bgpConstPos+bgpSubjConstVal=" + string10 + "+" + string8 + " RRrowSet:" + set + " tmp_RRrowSet: " + hashSet);
                            bl = false;
                        }
                        string7 = resultSet.getString("subjCol");
                        object2 = resultSet.getString("subjConstant");
                        string6 = resultSet.getString("subjTemplate");
                        if (string7 != null || object2 != null && ((String)object2).equals(string8)) {
                            set.add(string14);
                            ++n3;
                            continue;
                        }
                        if (string6 == null) continue;
                        if (!RelationalBGP.matchableSqlTemplatePair(string8, string6, this.ctx)) {
                            this.log("SKIP rowid=" + string14 + ": NO matchability of pos+bgpConstVal=subject+" + string8 + " and template=" + string6);
                            continue;
                        }
                        set.add(string14);
                        ++n3;
                    }
                    if (n3 <= 0 || (object3 = this.RRrowInfo_for_MatchingRow.get(string14)) != null) continue;
                    this.processFetchedRRrow(resultSet, null, null, "subject", null);
                    object3 = this.RRrowInfo_for_MatchingRow.get(string14);
                }
                if (n == 0) {
                    for (String string15 : arrayList2) {
                        if (this.RRrowSet_for_BGPconst.get(string10 + "+" + string15) != null) continue;
                        this.RRrowSet_for_BGPconst.put(string10 + "+" + string15, new HashSet());
                    }
                }
            }
            if (arrayList3.size() > 0) {
                void var28_40;
                int n;
                this.log("objeList [size=" + arrayList3.size() + "]: " + Arrays.toString(arrayList3.toArray()));
                string10 = "object";
                string4 = " SELECT rr.rowid, Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr FROM " + string + " rr  WHERE (((rr.objeCol is NOT NULL OR rr.objeTemplate is NOT NULL) AND rr.objeTermType IN " + ":::objectTermTypeListCSV:::" + ")      OR rr.objeConstant IN " + ":::objectCanonValListCSV_1:::" + ") " + this.cond_strict_default_graph + " UNION  SELECT rr.rowid" + RRrowSelList + " FROM " + string + " rr  WHERE (parentTmap is NOT NULL    and parentTmap in ( select distinct Tmap from " + string + " rr   where subjTemplate is NOT NULL or subjCol is NOT NULL or (subjConstant IN " + ":::objectCanonValListCSV_2:::" + "))) " + this.cond_strict_default_graph;
                String string16 = "";
                String string17 = "";
                object3 = "";
                string8 = "(";
                for (n = 1; n <= arrayList3.size(); ++n) {
                    string16 = string16 + string8 + ":" + n;
                    String string9 = (String)var28_40 + string8 + ":" + (1 * arrayList3.size() + n);
                    object3 = (String)object3 + string8 + ":" + (2 * arrayList3.size() + n);
                    string8 = ",";
                }
                string16 = string16 + ")";
                String string11 = (String)var28_40 + ")";
                object3 = object3 + ")";
                this.log(string16 + "\n" + string11 + "\n" + (String)object3);
                this.log(string4);
                string4 = string4.replaceAll(":::objectTermTypeListCSV:::", string16).replaceAll(":::objectCanonValListCSV_1:::", string11).replaceAll(":::objectCanonValListCSV_2:::", (String)object3);
                this.log(string4);
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement3 != null) {
                    statement3.close();
                }
                statement3 = connection.prepareStatement(string4);
                for (n = 1; n <= arrayList3.size(); ++n) {
                    statement3.setString(n, (String)arrayList4.get(n - 1));
                }
                for (n = 1; n <= arrayList3.size(); ++n) {
                    statement3.setString(1 * arrayList3.size() + n, (String)arrayList3.get(n - 1));
                }
                for (n = 1; n <= arrayList3.size(); ++n) {
                    statement3.setString(2 * arrayList3.size() + n, (String)arrayList3.get(n - 1));
                }
                resultSet = statement3.executeQuery();
                n = 0;
                while (resultSet.next()) {
                    ++n;
                    object2 = resultSet.getString("ROWID");
                    this.log("rowid=" + (String)object2 + " .getString: " + resultSet.getString("ROWID"));
                    int n2 = 0;
                    Object object6 = arrayList3.iterator();
                    while (object6.hasNext()) {
                        String string12 = (String)object6.next();
                        set = this.RRrowSet_for_BGPconst.get(string10 + "+" + string12);
                        if (set == null) {
                            this.log("--------------- compute RRrowSet pos+bgpConstVal=" + string10 + "+" + string12);
                            set = new HashSet<String>();
                            this.RRrowSet_for_BGPconst.put(string10 + "+" + string12, set);
                            bl = true;
                        } else {
                            this.log("SKIP: RRrowSet already exists for bgpConstPos+bgpObjeConstVal=" + string10 + "+" + string12 + " RRrowSet:" + set + " tmp_RRrowSet: " + hashSet);
                            bl = false;
                        }
                        String string13 = resultSet.getString("objeCol");
                        String string14 = resultSet.getString("objeConstant");
                        String string15 = resultSet.getString("objeTemplate");
                        String string18 = resultSet.getString("paSubjTemplate");
                        if (string13 != null || string14 != null && string14.equals(string12)) {
                            set.add((String)object2);
                            ++n2;
                        } else if (string15 != null) {
                            if (!RelationalBGP.matchableSqlTemplatePair(string12, string15, this.ctx)) {
                                this.log("SKIP rowid=" + (String)object2 + ": NO matchability of pos+bgpConstVal=object+" + string12 + " and template=" + string15);
                            } else {
                                set.add((String)object2);
                                ++n2;
                            }
                        } else if (string18 != null) {
                            if (!RelationalBGP.matchableSqlTemplatePair(string12, string18, this.ctx)) {
                                this.log("SKIP rowid=" + (String)object2 + ": NO matchability of pos+bgpConstVal=object+" + string12 + " and template=" + string18);
                            } else {
                                set.add((String)object2);
                                ++n2;
                            }
                        }
                        this.log("... matchCnt=" + n2 + ": RRrowSet: " + set);
                    }
                    this.log("FINAL matchCnt for this RRrowid: " + n2);
                    if (n2 <= 0 || (object6 = this.RRrowInfo_for_MatchingRow.get(object2)) != null) continue;
                    this.processFetchedRRrow(resultSet, null, null, "objectBatch", null);
                    object6 = this.RRrowInfo_for_MatchingRow.get(object2);
                }
                if (n == 0) {
                    for (String string19 : arrayList3) {
                        if (this.RRrowSet_for_BGPconst.get(string10 + "+" + string19) != null) continue;
                        this.RRrowSet_for_BGPconst.put(string10 + "+" + string19, new HashSet());
                    }
                }
            }
            this.log("time_delta CUMULATIVE AFTER Getting RRrowSet for subject, predicate, object component: " + (System.currentTimeMillis() - this.time_start), 4L);
            this.log("printing child table tmap and parent table tmap mappings");
            RelationalBGP.printMapSet(hashMap, this.ctx);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (statement3 != null) {
                statement3.close();
            }
            if (statement2 != null) {
                statement2.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        this.log("===>SUMMARY ");
        for (String string10 : this.RRrowSet_for_BGPconst.keySet()) {
            object = this.RRrowSet_for_BGPconst.get(string10);
            this.log("SUMMARY: [" + string10 + "] : RRrowSet.size()=" + object.size() + " : " + object);
        }
    }

    private void findMatchingRRrowSets_for_TriplePatterns(int n) throws SQLException, RDFException {
        String string;
        HashMap hashMap = new HashMap();
        List<TriplesBlock> list = this.bgp.TBList;
        if (this.dummyTBList.size() > 0) {
            if (this.bgp.TBList.size() != 0) {
                this.log("EXCEPTION: [expected size=0 b/c dummyTBList.size()=" + this.dummyTBList.size() + "] bgp.TBList.size()=" + this.bgp.TBList.size() + " : " + this.bgp.TBList);
            } else {
                list = this.dummyTBList;
            }
            this.log("findMatchingRRrowSets_for_TriplePatterns => TBList being used: " + list);
        }
        Set<String> set = null;
        if (this.activeGraph != null && this.graphVar == null) {
            string = "<" + this.activeGraph.name + ">";
            set = this.RRrowSet_for_BGPconst.get("graph+" + string);
            this.log("---->RRrowSet for graph=graph+" + string + ": " + set);
            this.putMcc_for_var(this.activeGraph.name, "graph");
        }
        for (TriplesBlock triplesBlock : list) {
            List<String> list2;
            String string2;
            HashSet<String> hashSet;
            Set<String> set2 = null;
            Set<String> set3 = null;
            Set<String> set4 = null;
            TriplesBlock.Element element = triplesBlock.getSubject();
            TriplesBlock.Element element2 = triplesBlock.getPredicate();
            TriplesBlock.Element element3 = triplesBlock.getObject();
            this.putMcc_for_var(element.getName(), "subject");
            this.putMcc_for_var(element2.getName(), "predicate");
            this.putMcc_for_var(element3.getName(), "object");
            String string3 = this.constructKey_for_TriplePattern(element, element2, element3);
            if (!element.isVariable()) {
                string = this.findTerm_for_Element(element, "subject", false);
                set2 = this.RRrowSet_for_BGPconst.get("subject+" + string);
                this.log("---->RRrowSet for sub=subject+" + string + ": " + set2);
            } else {
                hashSet = element.getName();
                string2 = (String)((Object)hashSet) + "+subject:" + string3;
                list2 = this.OccPosList_for_Var.get(hashSet);
                if (list2 == null) {
                    list2 = new ArrayList<String>();
                    this.OccPosList_for_Var.put((String)((Object)hashSet), list2);
                }
                this.log("adding subject OccPosInfo for var=" + (String)((Object)hashSet) + " : " + string2);
                list2.add(string2);
            }
            if (!element2.isVariable()) {
                string = this.findTerm_for_Element(element2, "predicate", false);
                set3 = this.RRrowSet_for_BGPconst.get("predicate+" + string);
                this.log("---->RRrowSet for pred=predicate+" + string + ": " + set3);
            } else {
                hashSet = element2.getName();
                string2 = (String)((Object)hashSet) + "+predicate:" + string3;
                list2 = this.OccPosList_for_Var.get(hashSet);
                if (list2 == null) {
                    list2 = new ArrayList<String>();
                    this.OccPosList_for_Var.put((String)((Object)hashSet), list2);
                }
                this.log("adding predicate OccPosInfo for var=" + (String)((Object)hashSet) + " : " + string2);
                list2.add(string2);
            }
            if (!element3.isVariable()) {
                string = this.findTerm_for_Element(element3, "object", false);
                set4 = this.RRrowSet_for_BGPconst.get("object+" + string);
                this.log("---->RRrowSet for obj=object+" + string + ": " + set4);
            } else {
                hashSet = element3.getName();
                string2 = (String)((Object)hashSet) + "+object:" + string3;
                list2 = this.OccPosList_for_Var.get(hashSet);
                if (list2 == null) {
                    list2 = new ArrayList<String>();
                    this.OccPosList_for_Var.put((String)((Object)hashSet), list2);
                }
                this.log("adding object OccPosInfo for var=" + (String)((Object)hashSet) + " : " + string2);
                list2.add(string2);
            }
            if (n == 1) {
                Set<Object> set5;
                Object object;
                HashSet<String> hashSet2;
                boolean bl = false;
                boolean bl2 = false;
                if (!element2.isVariable() || !element.isVariable() || !element3.isVariable() || this.activeGraph != null && this.graphVar == null) {
                    String string4;
                    String string5;
                    HashSet hashSet3;
                    list2 = new HashSet();
                    this.RRrowSet_for_TriplePattern.put(string3, (Set<String>)((Object)list2));
                    if (this.activeGraph != null && this.graphVar == null) {
                        list2.addAll(set);
                        bl = true;
                    }
                    this.log("====>[after using graph_RRrowSet] RRrowSet for tp_key=" + string3 + " is: " + list2);
                    if (!element2.isVariable()) {
                        if (bl) {
                            list2.retainAll(set3);
                        } else {
                            list2.addAll(set3);
                            bl = true;
                        }
                    }
                    this.log("====>[after using pred_RRrowSet] RRrowSet for tp_key=" + string3 + " is: " + list2);
                    if (!element.isVariable()) {
                        if (bl) {
                            list2.retainAll(set2);
                        } else {
                            list2.addAll(set2);
                            bl = true;
                        }
                    }
                    this.log("====>[after using  sub_RRrowSet] RRrowSet for tp_key=" + string3 + " is: " + list2);
                    if (!element3.isVariable()) {
                        if (bl) {
                            list2.retainAll(set4);
                        } else {
                            list2.addAll(set4);
                            bl = true;
                        }
                    }
                    this.log("====>[after using  obj_RRrowSet] RRrowSet for tp_key=" + string3 + " is: " + list2);
                    if (element.isVariable()) {
                        hashSet2 = new HashSet();
                        object = new HashSet();
                        for (String string6 : list2) {
                            this.log("rowid for this subElem variable: " + string6);
                            if (this.RRrowInfo_for_MatchingRow.get(string6) == null) {
                                this.log("going to crash b/c rowid DOES NOT EXIST in RRrowInfo_for_MatchingRow: " + this.RRrowInfo_for_MatchingRow);
                            }
                            hashSet2.add(this.RRrowInfo_for_MatchingRow.get((Object)string6).Tmap);
                            object.add(new predVarMapping(string6, this.RRrowInfo_for_MatchingRow.get((Object)string6).Tmap));
                        }
                        set5 = this.TmapSet_for_svar.get(element.getName());
                        if (set5 == null) {
                            set5 = new HashSet();
                            set5.addAll(hashSet2);
                        } else {
                            set5.retainAll(hashSet2);
                        }
                        hashSet3 = (HashSet)hashMap.get(element.getName());
                        if (hashSet3 == null) {
                            hashSet3 = new HashSet();
                            hashSet3.addAll(object);
                        } else {
                            hashSet3.addAll(object);
                            HashSet hashSet4 = new HashSet();
                            hashSet4.addAll(hashSet3);
                            for (predVarMapping predVarMapping2 : hashSet4) {
                                string5 = predVarMapping2.predName;
                                string4 = predVarMapping2.subjVarName;
                                if (set5.contains(string5)) continue;
                                hashSet3.remove(predVarMapping2);
                            }
                        }
                        hashMap.put(element.getName(), hashSet3);
                        this.TmapSet_for_svar.put(element.getName(), set5);
                    }
                    if (element2.isVariable()) {
                        hashSet2 = new HashSet<String>();
                        for (String string7 : list2) {
                            hashSet2.add(this.RRrowInfo_for_MatchingRow.get((Object)string7).pExpr);
                        }
                        set5 = this.PredConstSet_for_pvar.get(element.getName() + "+" + element2.getName());
                        if (set5 == null) {
                            set5 = new HashSet();
                            set5.addAll(hashSet2);
                        } else {
                            set5.retainAll(hashSet2);
                        }
                        this.PredConstSet_for_pvar.put(element.getName() + "+" + element2.getName(), set5);
                    }
                    if (element3.isVariable()) {
                        hashSet2 = new HashSet();
                        object = new HashSet();
                        for (String string8 : list2) {
                            String string9 = this.RRrowInfo_for_MatchingRow.get((Object)string8).paTmap;
                            if (string9 == null) continue;
                            hashSet2.add(string9);
                            object.add(new predVarMapping(string8, string9));
                        }
                        set5 = this.TmapSet_for_svar.get(element3.getName());
                        if (hashSet2.size() > 0 && hashSet2 != null) {
                            if (set5 == null) {
                                set5 = new HashSet();
                                set5.addAll(hashSet2);
                            } else {
                                set5.retainAll(hashSet2);
                            }
                            this.TmapSet_for_svar.put(element3.getName(), set5);
                        }
                        hashSet3 = (Set)hashMap.get(element3.getName());
                        if (object.size() > 0 && object != null) {
                            if (hashSet3 == null) {
                                hashSet3 = new HashSet();
                                hashSet3.addAll(object);
                            } else {
                                HashSet hashSet5 = new HashSet();
                                hashSet5.addAll(hashSet3);
                                for (predVarMapping predVarMapping2 : hashSet5) {
                                    string5 = predVarMapping2.predName;
                                    string4 = predVarMapping2.subjVarName;
                                    if (set5.contains(string5)) continue;
                                    hashSet3.remove(predVarMapping2);
                                }
                                hashSet3.addAll(object);
                            }
                            hashMap.put(element3.getName(), hashSet3);
                        }
                    }
                } else if (!bl2) {
                    list2 = null;
                    hashSet2 = null;
                    set5 = null;
                    try {
                        list2 = this.ctx.conn;
                        object = "SELECT rr.rowid, Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr FROM " + this.rr_tab_qname + " rr where (1=1) " + this.cond_strict_default_graph;
                        this.log("query_for_rr_tab_all_rows: " + (String)object);
                        hashSet2 = list2.prepareStatement((String)object);
                        set5 = hashSet2.executeQuery();
                        this.log("before adding all RR tab rows: " + this.RRrowInfo_for_MatchingRow.keySet().size() + " : \n" + this.RRrowInfo_for_MatchingRow.keySet());
                        while (set5.next()) {
                            this.processFetchedRRrow((ResultSet)((Object)set5), null, this.RRrowList_All, null, null);
                        }
                    }
                    catch (Exception exception) {
                        if (set5 != null) {
                            set5.close();
                        }
                        if (hashSet2 != null) {
                            hashSet2.close();
                        }
                        exception.printStackTrace();
                        throw new RDFException("[see trace file for more details] Failed while adding all RR tab rows");
                    }
                    finally {
                        if (set5 != null) {
                            set5.close();
                        }
                        if (hashSet2 != null) {
                            hashSet2.close();
                        }
                    }
                    this.log("AFTER  adding all RR tab rows: " + this.RRrowInfo_for_MatchingRow.keySet().size() + " : \n" + this.RRrowInfo_for_MatchingRow.keySet() + "\nRRrowList_All.size()=" + this.RRrowList_All.size() + " : \n" + this.RRrowList_All);
                    bl2 = true;
                }
            }
            if ((hashSet = this.RRrowSet_for_TriplePattern.get(string3)) != null) continue;
            hashSet = new HashSet<String>();
            hashSet.addAll(this.RRrowList_All);
            this.RRrowSet_for_TriplePattern.put(string3, hashSet);
        }
        this.log("RRrowSet_for_TriplePattern AFTER pass 1 BEFORE pass 2: " + this.RRrowSet_for_TriplePattern);
        this.log("--------------------------------------------------");
        this.findMatchingRRrowSets_for_MultiOccVars();
        this.log("**************************************************");
    }

    private boolean putMcc_for_var(String string, String string2) {
        boolean bl = false;
        String string3 = this.mcc_for_var.get(string);
        if (string3 == null) {
            this.mcc_for_var.put(string, string2);
            bl = true;
        } else if (string3.equals(string2)) {
            bl = false;
        } else {
            switch (string3) {
                case "subject": {
                    if (!string2.equals("predicate") && !string2.equals("graph")) break;
                    this.mcc_for_var.put(string, string2);
                    bl = true;
                    break;
                }
                case "predicate": 
                case "graph": {
                    if (!string2.equals("predicate") && !string2.equals("graph")) break;
                    this.mcc_for_var.put(string, string2);
                    bl = true;
                    break;
                }
                case "object": {
                    this.mcc_for_var.put(string, string2);
                    bl = true;
                }
            }
        }
        return bl;
    }

    private void dumpMatchabilityStructures(List<String> list, ArrayList<List<String>> arrayList, ArrayList<List<String>> arrayList2) {
        this.log("---------- dump of Matchability Structures ----------------------------");
        for (int i = 0; i < list.size(); ++i) {
            int n;
            this.log("===============> OccPosList.get(OccPos_idx=" + i + ")=" + list.get(i));
            String string = list.get(i);
            String string2 = string.substring(string.indexOf(":") + 1, string.length());
            Set<String> set = this.RRrowSet_for_TriplePattern.get(string2);
            List<String> list2 = arrayList.get(i);
            List<String> list3 = arrayList2.get(i);
            this.log("... RRrowSet=" + set);
            this.log("... RRrowList=" + list2);
            this.log("... MatchInfoList: " + list3);
            if (set != null) {
                this.log("Sizes: RRrowSet=" + set.size());
            }
            if (list2 == null) continue;
            this.log("Sizes: RRrowList=" + list2.size() + " MatchInfoList=" + list3.size());
            for (n = 0; n < list2.size(); ++n) {
                this.log("[idx=" + n + "] RRrowid=" + list2.get(n) + " MatchInfo: " + list3.get(n));
            }
            for (n = 0; n < list2.size(); ++n) {
                if (!list3.get(n).substring(0, 2).equals("MI")) continue;
                this.log("[idx=" + n + "] RRrowid=" + list2.get(n) + " MatchInfo: " + list3.get(n));
            }
            for (n = 0; n < list2.size(); ++n) {
                if (!list3.get(n).substring(0, 2).equals("MI")) continue;
                this.log(list2.get(n));
            }
        }
        this.log("---------- END: dump of Matchability Structures ----------------------------");
    }

    private void findMatchingRRrowSets_for_MultiOccVars() throws RDFException, SQLException {
        Object object;
        Object object2;
        this.log("Entered: findMatchingRRrowSets_for_MultiOccVars");
        this.log("RRrowSet_for_TriplePattern: " + this.RRrowSet_for_TriplePattern);
        this.log("initial OccPosList_for_Var: " + this.OccPosList_for_Var);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object3 : this.OccPosList_for_Var.keySet()) {
            List<String> list = this.OccPosList_for_Var.get(object3);
            if (list.size() <= 1) {
                arrayList.add(object3);
                this.log("SKIP var=" + object3 + " => NOT a multi-occurring var");
                continue;
            }
            object2 = null;
            boolean bl = false;
            for (String string : list) {
                this.log("processing var=" + object3 + ": OccPosInfo=" + string);
                String string2 = string.substring(string.indexOf(":") + 1, string.length());
                object = this.RRrowSet_for_TriplePattern.get(string2);
                if (object == null) {
                    this.log("this occurrence for var=" + object3 + " is associated triple-pattern has NULL RRrowSet: tp_key=" + string2);
                }
                this.log("for var=" + object3 + ": tp_key in OccPosInfo is: " + string2);
                if (!bl && object2 != null && !string.equals(object2)) {
                    bl = true;
                }
                if (object2 != null) continue;
                object2 = string;
            }
            if (bl) continue;
            arrayList.add(object3);
            this.log("SKIP var=" + object3 + " => NOT a multi-occurring var (after stringent check)");
        }
        for (String string : arrayList) {
            this.OccPosList_for_Var.remove(string);
        }
        this.log("post-filter OccPosList_for_Var: " + this.OccPosList_for_Var);
        int n = this.OccPosList_for_Var.size();
        if (n == 0) {
            return;
        }
        for (String string : this.OccPosList_for_Var.keySet()) {
            int n2;
            int n3;
            Object object3;
            int n4;
            int n5;
            int n6;
            List<String> list;
            Collection<Object> collection;
            List<String> list2;
            object2 = this.OccPosList_for_Var.get(string);
            this.log("OccPosList for var=" + string + " : " + object2);
            ArrayList<List<String>> arrayList2 = new ArrayList<List<String>>();
            ArrayList arrayList3 = new ArrayList();
            Iterator<String> iterator = object2.iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                object = string3.substring(string3.indexOf(":") + 1, string3.length());
                list2 = (List<String>)((Object)this.RRrowSet_for_TriplePattern.get(object));
                if (list2 == null) {
                    list2 = this.RRrowList_All;
                    this.log("NULL RRrowSet: Added using RRrowList_All");
                }
                this.log("alloc/init RRrowList and MatchInfoList for OccPosInfo: " + string3);
                collection = new ArrayList();
                list = new ArrayList<String>();
                arrayList2.add((List<String>)collection);
                arrayList3.add(list);
                n6 = 0;
                for (String string4 : list2) {
                    collection.add(string4);
                    list.add("MI=>" + string4 + "#" + n6 + ":");
                    ++n6;
                }
                this.log("Done alloc/init of RRrowList: " + collection);
                this.log("Done alloc/init of MatchInfoList: " + list);
            }
            do {
                n5 = 0;
                for (n4 = 0; n4 < object2.size(); ++n4) {
                    this.log("occurrence# i=" + n4);
                    object = (String)object2.get(n4);
                    this.log("OccPosInfo_i: i=" + n4 + " : " + (String)object);
                    list2 = arrayList2.get(n4);
                    collection = (List)arrayList3.get(n4);
                    this.log("RRrowList_i: i=" + n4 + " : " + list2);
                    this.log("MatchInfoList_i: i=" + n4 + " : " + collection);
                    if (list2 == null) continue;
                    list = ((String)object).substring(((String)object).indexOf("+") + 1, ((String)object).indexOf(":"));
                    this.log("OccPos_i=" + list);
                    for (n6 = 0; n6 < list2.size(); ++n6) {
                        String string4;
                        this.log("(in occurrence# i=" + n4 + "): RRrowid# x=" + n6);
                        if (((String)collection.get(n6)).substring(0, 2).equals("XX")) {
                            this.log("SKIP RRrowid=" + (String)list2.get(n6) + " has already been marked as NON-MATCHING: " + (String)collection.get(n6));
                            continue;
                        }
                        object3 = null;
                        string4 = null;
                        n3 = -1;
                        n2 = 0;
                        for (int i = 0; i < object2.size(); ++i) {
                            String string5;
                            int n7;
                            String string6;
                            String string7 = (String)collection.get(n6);
                            this.log("..checking list of RRrowids for occurrence# j=" + i + " (latest MatchInfoList_i_x=" + string7 + ")");
                            String string8 = (String)object2.get(i);
                            this.log("OccPosInfo_j: j=" + i + " : " + string8);
                            List<String> list3 = arrayList2.get(i);
                            List list4 = (List)arrayList3.get(i);
                            String string9 = BASE_PREFIX_COLNAME_SEP + i + "-";
                            if (i == n4 || list3 == null) {
                                string6 = string9 + "X$";
                                if (i == n4) {
                                    this.log("TRIVIAL MATCH b/c j==i");
                                } else {
                                    this.log("TRIVIAL MATCH b/c RRrowList_j=(" + list3 + ") is NULL (implying matchable with all RRrowids)");
                                }
                                if (string7.indexOf(string6) < 0) {
                                    this.log("... appending: " + string6 + " to MatchInfoList_i_x=" + string7);
                                    collection.set(n6, string7 + string6);
                                } else {
                                    this.log("no need to append: already present: " + string6 + " in MatchInfoList_i_x=" + string7);
                                }
                                this.log("MatchInfoList_i.get(" + n6 + ")=" + (String)collection.get(n6));
                                continue;
                            }
                            string6 = string8.substring(string8.indexOf("+") + 1, string8.indexOf(":"));
                            this.log("OccPos_j=" + string6);
                            int n8 = string7.lastIndexOf(string9);
                            if (n8 >= 0) {
                                n7 = string7.indexOf(36, n8);
                                string4 = string7.substring(n8, n7 + 1);
                                n3 = Integer.parseInt(string4.substring(string4.indexOf(45) + 1, string4.length() - 1));
                                this.log("....a matchable RRrowid already present (for occurrence# j=" + i + "): match_i_x_j_full=" + string4);
                                if (((String)list4.get(n3)).substring(0, 2).equals("XX")) {
                                    this.log("......BUT the RRrowid has since been discarded! MatchInfoList_j.get(" + n3 + ")=" + (String)list4.get(n3));
                                    String string10 = string7.substring(0, n8) + string7.substring(n7 + 1);
                                    this.log("shrinking MatchInfo to remove now-discarded match: " + string10);
                                    collection.set(n6, string10);
                                    string7 = (String)collection.get(n6);
                                    this.log("latest (shrunk) MatchInfoList_i_x=" + string7);
                                    n2 = 1;
                                }
                            }
                            n7 = 0;
                            if (n3 != -1 && n2 == 0) continue;
                            if (n3 != -1 && n2 != 0) {
                                n7 = n3 + 1;
                            }
                            int n9 = -1;
                            this.log("starting search for matchable RRrowid in RRrowList for occ# j=" + i + " at start_idx=" + n7);
                            if (n7 >= list3.size()) {
                                this.log("But NO RRrowids left to search in the list: RRrowList_j.size()=" + list3.size());
                            } else {
                                n9 = this.findIndexOfMatchableRRrow((String)list2.get(n6), list3, list4, (String)((Object)list), string6, n7);
                            }
                            if (n9 == -1) {
                                string5 = string9 + "Z$";
                                collection.set(n6, "XX" + string7.substring(2) + string5);
                                this.log("REMOVED: i=" + n4 + " x=" + n6 + " : " + (String)collection.get(n6));
                                ++n5;
                                break;
                            }
                            string5 = string9 + n9 + NATIVE_SUFFIX;
                            collection.set(n6, string7 + string5);
                            this.log("RECORD MATCHABLE: i=" + n4 + " x=" + n6 + " : " + (String)collection.get(n6));
                            String string11 = BASE_PREFIX_COLNAME_SEP + n4 + "-";
                            String string12 = string11 + n6 + NATIVE_SUFFIX;
                            int n10 = ((String)list4.get(n9)).lastIndexOf(string11);
                            if (n10 >= 0) {
                                this.log("....SKIP reverse_match_recording b/c a matchable RRrowid already present for j=" + i + " m=" + n9 + ": MatchInfoList_j.get(m)=" + (String)list4.get(n9));
                                continue;
                            }
                            list4.set(n9, (String)list4.get(n9) + string12);
                            this.log("(REVERSE) RECORD MATCHABLE: j=" + n4 + " m=" + n6 + " : " + (String)list4.get(n9));
                        }
                        this.log("MatchInfoList_i.get(x): i=" + n4 + " x=" + n6 + " : " + (String)collection.get(n6));
                    }
                }
                this.log("dump of Matchability structures for var=" + string + " (RRrowid_removal_cnt=" + n5 + ")");
                this.dumpMatchabilityStructures((List<String>)object2, arrayList2, arrayList3);
            } while (n5 > 0);
            for (n4 = 0; n4 < object2.size(); ++n4) {
                int n11;
                this.log("===============> OccPosList.get(OccPos_idx=" + n4 + ")=" + (String)object2.get(n4));
                object = (String)object2.get(n4);
                list2 = ((String)object).substring(((String)object).indexOf(":") + 1, ((String)object).length());
                collection = this.RRrowSet_for_TriplePattern.get(list2);
                this.log("before adjusting: RRrowSet for tp_key=" + (String)((Object)list2) + " : " + collection);
                list = arrayList2.get(n4);
                List list5 = (List)arrayList3.get(n4);
                this.log("before removal of XX: RRrowList=" + list);
                if (collection == null) {
                    this.log("NULL RRrowSet encountered during adjustment: RRrowSet=" + collection + " RRrowList=" + list);
                }
                object3 = new ArrayList();
                for (n11 = 0; n11 < list.size(); ++n11) {
                    if (!((String)list5.get(n11)).substring(0, 2).equals("XX")) continue;
                    ((ArrayList)object3).add(n11);
                }
                this.log("RRrowid_indexes_for_removal: " + object3);
                n11 = ((ArrayList)object3).size();
                for (n3 = 0; n3 < n11; ++n3) {
                    n2 = (Integer)((ArrayList)object3).get(n11 - n3 - 1);
                    this.log("removing RRrowid_idx=" + n2);
                    list.remove(n2);
                }
                this.log("AFTER  removal of XX: RRrowList=" + list);
                if (collection == null) {
                    collection = new HashSet();
                    collection.addAll(list);
                    this.RRrowSet_for_TriplePattern.put((String)((Object)list2), (Set<String>)collection);
                } else {
                    collection.retainAll(list);
                }
                this.log("AFTER  adjusting: RRrowSet for tp_key=" + (String)((Object)list2) + " : " + collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] resolveOwnTabNames(String string) throws SQLException {
        String string2 = ".";
        int n = 0;
        int n2 = string.indexOf(string2, n);
        String[] stringArray = new String[2];
        StringBuffer stringBuffer = new StringBuffer();
        ResultSet resultSet = null;
        Statement statement = null;
        String string3 = null;
        if (n2 > 0) {
            stringArray[0] = string.substring(n, n2);
            stringArray[1] = string.substring(n2 + 1, string.length());
        } else {
            if (this.defaultOwner == null) {
                this.log("     resolveOwnTabNames: time_delta CUMULATIVE: [=>" + (System.currentTimeMillis() - this.time_start) + "] tabname=" + string, 4L);
                try {
                    stringBuffer.append("SELECT user USR FROM SYS.DUAL");
                    Connection connection = this.ctx.conn;
                    statement = connection.prepareStatement(stringBuffer.toString());
                    resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        string3 = resultSet.getString("USR");
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                this.log("     resolveOwnTabNames: time_delta CUMULATIVE: [  " + (System.currentTimeMillis() - this.time_start) + "] owner=" + string3, 4L);
                stringArray[0] = this.defaultOwner = "\"" + string3 + "\"";
            } else {
                stringArray[0] = this.defaultOwner;
            }
            stringArray[1] = string.substring(n, string.length());
        }
        return stringArray;
    }

    private void populate_FirstOccPos_for_TpatCSRgroup(HashMap<String, String> hashMap, String string) {
        for (String string2 : this.FullOccInfo_for_VarPlusCSRAlias.keySet()) {
            int n;
            String string3 = string2.substring((n = string2.indexOf(43)) + 1);
            if (!string3.equals(string)) continue;
            String string4 = string2.substring(0, n);
            String string5 = this.FullOccInfo_for_VarPlusCSRAlias.get(string2);
            int n2 = string5.indexOf(43, 1);
            if (n2 < 0) {
                n2 = string5.length();
            }
            String string6 = string5.substring(1, n2);
            hashMap.put(string4, string6);
            this.log("populate_FirstOccPos_for_TpatCSRgroup: var=" + string4 + " firstOccPos=" + string6);
        }
    }

    private void add_to_FullOccInfo(String string, String string2, String string3, int n) {
        String string4 = string + "+" + string2;
        String string5 = string3 + ":" + n;
        String string6 = "+" + string5;
        String string7 = this.FullOccInfo_for_VarPlusCSRAlias.get(string4);
        if (string7 == null) {
            string7 = "";
        }
        String string8 = string7 + string6;
        this.FullOccInfo_for_VarPlusCSRAlias.put(string4, string8);
        if (this.TypeInfoSet_for_VarPlusCSRAlias.get(string4) == null) {
            this.TypeInfoSet_for_VarPlusCSRAlias.put(string4, new HashSet());
        }
        Map<String, Set<String>> map = this.occPosSet_for_CSRAlias_for_var.get(string);
        this.log("      var -> occPosSet_for_CSRAlias: " + string + " -> " + map);
        if (map == null) {
            map = new HashMap<String, Set<String>>();
            this.occPosSet_for_CSRAlias_for_var.put(string, map);
        }
        Set<String> set = map.get(string2);
        this.log("      CSRAlias -> occPosSet: " + string2 + " -> " + set);
        if (set == null) {
            set = new HashSet<String>();
            map.put(string2, set);
        }
        set.add(string5);
        this.log("      var -> occPosSet_for_CSRAlias: " + string + " -> " + map);
    }

    private void add_to_TypeInfoSet(String string, String string2, RRTabRowInfo rRTabRowInfo) {
        String string3 = string + "+" + string2;
        Set<String> set = this.TypeInfoSet_for_VarPlusCSRAlias.get(string3);
        if (set != null) {
            String string4 = null;
            string4 = rRTabRowInfo.RDFdatatype_DBColType != null ? rRTabRowInfo.oDataType + BASE_PREFIX_COLNAME_SEP + rRTabRowInfo.RDFdatatype_DBColType : NO_DB_COL_TYPE;
            this.log("TypeInfo: " + string4);
            if (!set.add(string4)) {
                this.log("TypeInfo already present in VarPlusCSRAlias=" + string3);
            } else {
                this.log("Extended TypeInfoSet content of VarPlusCSRAlias=" + string3 + " is: " + set);
            }
        }
    }

    private void refineCSRs(List<String> list) throws RDFException, SQLException {
        this.log("Entered refineCSRs:" + this.TpatSet_for_TpatCSRGroup.toString());
        block0: for (String string : this.TpatSet_for_TpatCSRGroup.keySet()) {
            this.log("SubjTmapSet_key=" + string);
            Set<String> set = this.TpatSet_for_TpatCSRGroup.get(string);
            if (set.size() == 1) continue;
            this.log("Check to see if breakup is needed for SubjTmapSet_key=" + string);
            Set<String> set2 = this.TmapSet_for_TpatCSRGroup.get(string);
            HashSet<String> hashSet = new HashSet<String>(this.Tmaps_with_nonUnique_Smaps);
            hashSet.retainAll(set2);
            if (hashSet.size() > 0) {
                list.add(string);
                this.log("This TpatCSRGroup is marked for breakup because it contains Tmap(s) with nonUnique Smap: " + ((Object)hashSet).toString());
                continue;
            }
            if (set2.size() == 1) continue;
            boolean bl = false;
            for (String string2 : set2) {
                int n = this.sTFT_idx_for_Tmap.get(string2);
                TFTinfo tFTinfo = this.TFTinfoGlobalList.get(n);
                String string3 = this.SubjRRrowid_for_Tmap.get(string2);
                for (String string4 : set2) {
                    if (string2.compareTo(string4) >= 0) continue;
                    int n2 = this.sTFT_idx_for_Tmap.get(string4);
                    TFTinfo tFTinfo2 = this.TFTinfoGlobalList.get(n2);
                    String string5 = this.SubjRRrowid_for_Tmap.get(string4);
                    this.log("Checking Smap-matchability of Tmaps: " + string2 + " and " + string4);
                    String[] stringArray = new String[2];
                    String string6 = RelationalBGP.matchabilityPlusCond(stringArray, tFTinfo, tFTinfo2, string3, 0, string5, 0, null, this.RRrowInfo_for_MatchingRow, this.ctx);
                    if (!string6.equals("MATCHABLE")) continue;
                    bl = true;
                    this.log("matchable Smaps found: Tmap1=" + string2 + ", Tmap2=" + string4);
                    break;
                }
                if (!bl) continue;
                list.add(string);
                continue block0;
            }
        }
        RelationalBGP.log_static("breakTpatCSRList: " + list, this.ctx.R2RFlags);
    }

    private void prepareForBuildSQL() throws RDFException, SQLException {
        Object object;
        String string;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.log("Entered: pfbs");
        this.log("Structures involved here are:");
        this.log("===============================================:");
        this.log("[Use] RRrowSet_for_TriplePattern:         Map => <tp_key, RRrowSet(actually, RRrowidSet)>");
        this.log("[Use] RRrowInfo_for_MatchingRow:          Map => <RRrowid, RRrowInfo(actually, RRTabRowInfo)>");
        this.log("-----");
        this.log("[Pop] TpatInfo_for_TpatKey:               Map => <tp_key, TriplesBlock>");
        this.log("[Pop] LtabExpr_for_Tmap:                  Map => <Tmap, rowsrc>");
        this.log("[Pop] SubjExpr_for_Tmap:                  Map => <Tmap, sTermType+RRrowInfo.sExprType+RRrowInfo.sExpr>");
        this.log("[Pop] Subj_for_TpatCSRGroup:              Map => <SubjTmapSet_key, Subj>");
        this.log("[Pop] TmapSet_for_TpatCSRGroup:           Map => <SubjTmapSet_key, TmapSet (set of Tmaps from matching RR rows)>");
        this.log("[Pop] TpatSet_for_TpatCSRGroup:           Map => <SubjTmapSet_key (CSR key), TpatSet (triple-patterns in this CSR>");
        this.log("===============================================:");
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        List<TriplesBlock> list = this.bgp.TBList;
        if (this.dummyTBList.size() > 0) {
            if (this.bgp.TBList.size() != 0) {
                this.log("EXCEPTION: [expected size=0 b/c dummyTBList.size()=" + this.dummyTBList.size() + "] bgp.TBList.size()=" + this.bgp.TBList.size() + " : " + this.bgp.TBList);
            } else {
                list = this.dummyTBList;
            }
            this.log("prepareForBuildSQL => TBList being used: " + list);
        }
        for (TriplesBlock object6 : list) {
            HashSet<String> hashSet2;
            object5 = object6.getSubject();
            object4 = object6.getPredicate();
            object3 = object6.getObject();
            String string3 = this.findTerm_for_Element((TriplesBlock.Element)object5, "subject", true);
            object2 = this.findTerm_for_Element((TriplesBlock.Element)object4, "predicate", true);
            string2 = this.findTerm_for_Element((TriplesBlock.Element)object3, "object", true);
            this.log("In pfbs : subject : " + string3);
            this.log("In pfbs : predicate : " + (String)object2);
            this.log("In pfbs : object : " + string2);
            string = this.constructKey_for_TriplePattern((TriplesBlock.Element)object5, (TriplesBlock.Element)object4, (TriplesBlock.Element)object3);
            this.log("In pfbs : tp_key : " + string);
            if (this.TpatInfo_for_TpatKey.get(string) == null) {
                this.TpatInfo_for_TpatKey.put(string, object6);
                this.log("added TpatInfo for tp_key=" + string);
            }
            object = string3;
            Set<String> set = this.RRrowSet_for_TriplePattern.get(string);
            if (this.RRrowSet_for_TriplePattern.get(string) == null) {
                this.log("In pfbs: RRrowSet for this triple-pattern is NULL => setting up to skip tp_key=" + string);
                set = hashSet;
            }
            this.log("RRrowSet: " + set.toString());
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            String string4 = "#";
            for (String string5 : set) {
                RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(string5);
                if (rRTabRowInfo != null) {
                    hashSet2 = rRTabRowInfo.Tmap;
                    this.log("Tmap: " + (String)((Object)hashSet2));
                    if (linkedHashSet.add((String)((Object)hashSet2))) {
                        arrayList.add((String)((Object)hashSet2));
                        String string6 = null;
                        if (rRTabRowInfo.tabName != null) {
                            string6 = rRTabRowInfo.tabOwner + "." + rRTabRowInfo.tabName;
                            if (this.ctx.asOfClause != null) {
                                string6 = string6 + this.ctx.asOfClause;
                            }
                        } else if (rRTabRowInfo.sqlQuery != null) {
                            string6 = "(" + rRTabRowInfo.sqlQuery.substring(1, rRTabRowInfo.sqlQuery.length() - 1).replaceAll("\\\\\"", "\"") + ")";
                        } else {
                            throw new RDFException("EXCEPTION: NULL rowsrc in RRrowid=" + string5 + ": RRrowInfo.tabName=" + rRTabRowInfo.tabName + " .sqlQuery=" + rRTabRowInfo.sqlQuery);
                        }
                        this.log("rowsrc=" + string6);
                        this.LtabExpr_for_Tmap.put((String)((Object)hashSet2), string6);
                        String string7 = rRTabRowInfo.sTermType;
                        this.log("sTermType=" + string7);
                        if (string7 == null || string7.equals(rrIRI)) {
                            string7 = "U";
                        } else if (string7.equals(rrBlankNode)) {
                            string7 = "B";
                        } else {
                            throw new RDFException("invalid TermType for subject: sTermType=" + string7);
                        }
                        this.log("RRrowInfo.sExpr=" + rRTabRowInfo.sExpr);
                        this.SubjExpr_for_Tmap.put((String)((Object)hashSet2), string7 + rRTabRowInfo.sExprType + rRTabRowInfo.sExpr);
                        this.sTFT_idx_for_Tmap.put((String)((Object)hashSet2), rRTabRowInfo.sTFT_idx);
                        this.SubjRRrowid_for_Tmap.put((String)((Object)hashSet2), rRTabRowInfo.rowid);
                    } else {
                        this.log("already in TmapSet: " + (String)((Object)hashSet2));
                    }
                    string4 = "+";
                    continue;
                }
                throw new RDFException("RRrowInfo is null for RRrowid=" + string5);
            }
            this.log("TmapSet: " + ((Object)linkedHashSet).toString());
            this.log("SubjTmapSet_key: " + (String)object);
            this.log("before sorting => TmapList: " + arrayList);
            Collections.sort(arrayList);
            this.log("AFTER  sorting => TmapList: " + arrayList);
            if (!bl) {
                for (String string8 : arrayList) {
                    object = (String)object + string4 + string8;
                    string4 = "+";
                }
                this.log("SubjTmapSet_key=" + (String)object);
            }
            this.log("LtabExpr_for_Tmap: " + this.LtabExpr_for_Tmap);
            this.log("SubjExpr_for_Tmap: " + this.SubjExpr_for_Tmap);
            String string9 = this.Subj_for_TpatCSRGroup.get(object);
            if (string9 != null) {
                this.log("pfbs: SKIP: oldSubj=" + string9 + " current Subj=" + string3);
            } else {
                this.Subj_for_TpatCSRGroup.put((String)object, string3);
            }
            Set<String> set2 = this.TmapSet_for_TpatCSRGroup.get(object);
            if (set2 != null) {
                this.log("pfbs: TmapSet (computed for this triple-pattern) size=" + linkedHashSet.size() + " : " + linkedHashSet);
                this.log("pfbs: INTERSECT WITH: oldTmapSet.size()=" + set2.size() + " : " + set2);
                linkedHashSet.retainAll(set2);
                this.log("pfbs: TmapSet (AFTER INTERSECT with oldTmapSet) size=" + linkedHashSet.size() + " : " + linkedHashSet);
                this.TmapSet_for_TpatCSRGroup.put((String)object, linkedHashSet);
            } else {
                this.TmapSet_for_TpatCSRGroup.put((String)object, linkedHashSet);
            }
            hashSet2 = this.TpatSet_for_TpatCSRGroup.get(object);
            if (hashSet2 != null) {
                this.log("pfbs: key already exists: " + (String)object + " : add " + string);
                hashSet2.add(string);
            } else {
                hashSet2 = new HashSet<String>();
                hashSet2.add(string);
                this.TpatSet_for_TpatCSRGroup.put((String)object, hashSet2);
            }
            this.log("TpatSet: " + ((Object)hashSet2).toString());
        }
        this.refineCSRs(this.breakTpatCSRList);
        this.log("pfbs: breakTpatCSRList: " + this.breakTpatCSRList);
        for (String string10 : this.breakTpatCSRList) {
            this.log("pfbs: breaking up CSR: SubjTmapSet_key=" + string10);
            object5 = this.Subj_for_TpatCSRGroup.get(string10);
            object3 = this.TmapSet_for_TpatCSRGroup.get(string10);
            object4 = this.TpatSet_for_TpatCSRGroup.get(string10);
            int n = 0;
            object2 = object4.iterator();
            while (object2.hasNext()) {
                string2 = (String)object2.next();
                this.log("Tpat-" + ++n + ": " + string2);
                string = n + "-" + string10;
                this.TmapSet_for_TpatCSRGroup.put(string, (Set<String>)object3);
                this.Subj_for_TpatCSRGroup.put(string, (String)object5);
                object = new HashSet();
                object.add(string2);
                this.TpatSet_for_TpatCSRGroup.put(string, (Set<String>)object);
            }
            this.TpatSet_for_TpatCSRGroup.put(string10, null);
            this.TpatSet_for_TpatCSRGroup.remove(string10);
            this.TmapSet_for_TpatCSRGroup.put(string10, null);
            this.TmapSet_for_TpatCSRGroup.remove(string10);
            this.Subj_for_TpatCSRGroup.put(string10, null);
            this.Subj_for_TpatCSRGroup.remove(string10);
            this.CSRAlias_for_TpatCSRGroup.put(string10, null);
            this.CSRAlias_for_TpatCSRGroup.remove(string10);
        }
    }

    private String TYPE_FAMILY(String string) {
        if (string.equals("")) {
            return "STRING";
        }
        String string2 = string;
        if (string.charAt(0) == '<' && string.charAt(string.length() - 1) == '>') {
            string2 = string.substring(1, string.length() - 1);
        }
        if (string2.length() <= XSD_PREFIX.length() || !string2.substring(0, XSD_PREFIX.length()).equals(XSD_PREFIX)) {
            if (string2.equals("http://www.opengis.net/ont/geosparql#wktLiteral") || string2.equals("http://www.opengis.net/ont/geosparql#gmlLiteral") || string2.equals("http://xmlns.oracle.com/rdf/geo/GML31Literal")) {
                return "SDO_GEOMETRY";
            }
            if (string2.equals(XSD_DECIMAL_NO_ENCLOSING)) {
                return TYPE_FAM_NUMERIC;
            }
            return TYPE_FAM_OTHER;
        }
        String string3 = string2.substring(XSD_PREFIX.length());
        this.log("xsd_suffix=" + string3);
        String string4 = string3.equals("string") || string3.equals("normalizedString") || string3.equals("token") || string3.equals("language") || string3.equals("Name") || string3.equals("NCName") || string3.equals("NMTOKEN") ? "STRING" : (string3.equals("double") ? TYPE_FAM_DOUBLE : (string3.equals("float") ? TYPE_FAM_FLOAT : (string3.equals("decimal") || string3.equals("integer") || string3.equals("nonPositiveInteger") || string3.equals("negativeInteger") || string3.equals("long") || string3.equals("int") || string3.equals("short") || string3.equals("byte") || string3.equals("nonNegativeInteger") || string3.equals("unsignedLong") || string3.equals("unsignedInt") || string3.equals("unsignedShort") || string3.equals("unsignedByte") || string3.equals("positiveInteger") ? TYPE_FAM_NUMERIC : (string3.equals("date") ? "DATE" : (string3.equals("time") ? TYPE_FAM_TIME : (string3.equals("dateTime") ? TYPE_FAM_DATETIME : (string3.equals("boolean") ? TYPE_FAM_BOOLEAN : (string3.equals("hexBinary") ? TYPE_FAM_RAW : TYPE_FAM_OTHER))))))));
        return string4;
    }

    private void findComponents_of_RDFterm(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, StringBuffer stringBuffer4) throws RDFException {
        int n = string.length();
        char c = string.charAt(0);
        char c2 = string.charAt(n - 1);
        int n2 = string.lastIndexOf("\"^^<");
        int n3 = string.lastIndexOf("\"@");
        if (c == '<' && c2 == '>') {
            stringBuffer.append(string.substring(1, n - 1));
            stringBuffer2.append("UR");
        } else if (c == '\"' && c2 == '\"') {
            stringBuffer.append(string.substring(1, n - 1));
            stringBuffer2.append("PL");
        } else if (c == '\"' && c2 == '>' && n2 > 0) {
            stringBuffer.append(string.substring(1, n2));
            stringBuffer2.append("TL");
            stringBuffer3.append(string.substring(n2 + 4, n - 1));
        } else if (c == '\"' && n3 > 0) {
            stringBuffer.append(string.substring(1, n3));
            stringBuffer2.append("PL@");
            stringBuffer4.append(string.substring(n3 + 2));
        } else {
            this.log("EXCEPTION: unrecognized syntax for RDFterm: " + string);
            throw new RDFException("EXCEPTION: unrecognized syntax for RDFterm: " + string);
        }
    }

    private void findComponents_of_RDFterm_simple(String string, String[] stringArray) throws RDFException {
        int n = string.length();
        char c = string.charAt(0);
        char c2 = string.charAt(n - 1);
        int n2 = string.lastIndexOf("\"^^<");
        int n3 = string.lastIndexOf("\"@");
        if (c == '<' && c2 == '>') {
            stringArray[0] = string.substring(1, n - 1);
            stringArray[1] = "UR";
        } else if (c == '\"' && c2 == '\"') {
            stringArray[0] = string.substring(1, n - 1);
            stringArray[1] = "PL";
            stringArray[2] = XSD_STRING_NO_ENCLOSING;
        } else if (c == '\"' && c2 == '>' && n2 > 0) {
            stringArray[0] = string.substring(1, n2);
            stringArray[1] = "TL";
            stringArray[2] = string.substring(n2 + 4, n - 1);
        } else if (c == '\"' && n3 > 0) {
            stringArray[0] = string.substring(1, n3);
            stringArray[1] = "PL@";
            stringArray[3] = string.substring(n3 + 2);
        } else if (c == '_' && string.charAt(1) == ':') {
            stringArray[0] = string;
            stringArray[1] = "BN";
        } else {
            this.log("EXCEPTION: unrecognized syntax for RDFterm: " + string);
            throw new RDFException("EXCEPTION: unrecognized syntax for RDFterm: " + string);
        }
    }

    private void multiplyUnionArrays(CSRinfo cSRinfo, int n, int n2, int n3, String string, boolean bl, NatVarOpt_Info natVarOpt_Info, int n4, List<UArowNatSelectInfo> list) {
        int n5;
        List<Object> list2;
        int n6;
        this.log("mUA: Entering: po_idx=" + n + " multiply_writePos=" + n3 + " UAstartPos=" + n4);
        List<String> list3 = cSRinfo.RRrLArray;
        List<String> list4 = cSRinfo.fromArray;
        List<String> list5 = cSRinfo.condArray;
        List<String> list6 = cSRinfo.sAliasArray;
        List<String> list7 = cSRinfo.gExprArray;
        List<Set<String>> list8 = cSRinfo.GeesArray;
        List<Map<String, String>> list9 = cSRinfo.TpGEArray;
        List<List<String>> list10 = cSRinfo.pExprArrays;
        List<List<String>> list11 = cSRinfo.oExprArrays;
        List<List<String>> list12 = cSRinfo.clobExprArrays;
        Map<String, List<Set<String>>> map = cSRinfo.native_oExprSetArray_for_Var;
        for (n6 = 0; n6 < n; ++n6) {
            List<String> object2 = list10.get(n6);
            list2 = list11.get(n6);
            List<String> list13 = list12.get(n6);
            if (object2.size() > 0) {
                this.log("  BEFORE COPY: prev_pExprArray.size()=" + object2.size() + " : \n  " + object2);
            }
            this.log("  BEFORE COPY: prev_oExprArray.size()=" + list2.size() + " : \n  " + list2);
            this.log("  BEFORE COPY: prev_clobExprArray.size()=" + list13.size() + " : \n  " + list13);
            for (int i = 0; i < n2; ++i) {
                if (object2.size() > 0) {
                    object2.add(object2.get(n4 + i));
                }
                list2.add(list2.get(n4 + i));
                list13.add(list13.get(n4 + i));
            }
            if (object2.size() > 0) {
                this.log("  AFTER  COPY: prev_pExprArray.size()=" + object2.size() + " : \n  " + object2);
            }
            this.log("  AFTER  COPY: prev_oExprArray.size()=" + list2.size() + " : \n  " + list2);
            this.log("  AFTER  COPY: prev_clobExprArray.size()=" + list13.size() + " : \n  " + list13);
            this.log("  prev_po_idx=" + n6 + ": copied first " + n2 + " rows, starting from UAstartPos=" + n4 + ", into pos starting from " + n4 + "+" + n3);
        }
        if (this.graph_use_mode > 0) {
            if (this.is_bgp_graph_a_var) {
                this.log("  BEFORE COPY: gExprArray.size()=" + list7.size() + " : \n  " + list7);
                for (n6 = 0; n6 < n2; ++n6) {
                    list7.add(list7.get(n4 + n6));
                }
                this.log("  AFTER  COPY: gExprArray.size()=" + list7.size() + " : \n  " + list7);
            }
            this.log("  BEFORE COPY: GeesArray.size()=" + list8.size() + " : \n  " + list8);
            for (n6 = 0; n6 < n2; ++n6) {
                HashSet hashSet = new HashSet(list8.get(n4 + n6));
                list8.add(hashSet);
            }
            this.log("  AFTER  COPY: GeesArray.size()=" + list8.size() + " : \n  " + list8);
            this.log("  BEFORE COPY: TpGEArray.size()=" + list9.size() + " : \n  " + list9);
            for (n6 = 0; n6 < n2; ++n6) {
                HashMap<String, String> hashMap = new HashMap<String, String>(list9.get(n4 + n6));
                list9.add(hashMap);
            }
            this.log("  AFTER  COPY: TpGEArray.size()=" + list9.size() + " : \n  " + list9);
        }
        for (String string2 : map.keySet()) {
            list2 = map.get(string2);
            this.log("  BEFORE COPY: [var=" + string2 + "] native_oExprSetArray.size()=" + list2.size() + " : \n  " + list2);
            for (int i = 0; i < n2; ++i) {
                HashSet hashSet = new HashSet((Collection)list2.get(n4 + i));
                list2.add(hashSet);
                this.log("UAstartPos=" + n4 + "[multiply_writePos+row_idx=" + n3 + "+" + i + "] [var=" + string2 + "] : added to native_oExprSetArray replicated content of native_oExprSet [" + n4 + "+" + i + "] [var=" + string2 + "] :" + hashSet);
            }
            this.log("  AFTER  COPY: [var=" + string2 + "] native_oExprSetArray.size()=" + list2.size() + " : \n  " + list2);
        }
        cSRinfo.multiplyVTaL(n4, n2);
        this.log("  BEFORE COPY: RRrLArray.size()=" + list3.size() + " : \n  " + list3);
        for (n5 = 0; n5 < n2; ++n5) {
            list3.add(list3.get(n4 + n5));
        }
        this.log("  AFTER  COPY: RRrLArray.size()=" + list3.size() + " : \n  " + list3);
        this.log("  rowBlock_size=" + n2 + " : UAstartPos=" + n4);
        this.log("  BEFORE COPY: UArowNatSelectInfoArray.size()=" + list.size() + " : \n  " + list);
        this.log("===> UArowNatSelectInfoArray=");
        for (n5 = 0; n5 < list.size(); ++n5) {
            this.log("[" + n5 + "]: " + list.get(n5));
        }
        for (n5 = 0; n5 < n2; ++n5) {
            UArowNatSelectInfo uArowNatSelectInfo = new UArowNatSelectInfo(list.get(n4 + n5));
            list.add(uArowNatSelectInfo);
        }
        this.log("  AFTER  COPY: UArowNatSelectInfoArray.size()=" + list.size() + " : \n  " + list);
        this.log("===> UArowNatSelectInfoArray=");
        for (n5 = 0; n5 < list.size(); ++n5) {
            this.log("[" + n5 + "]: " + list.get(n5));
        }
        this.log("  BEFORE COPY: fromArray.size()=" + list4.size() + " : \n  " + list4);
        for (n5 = 0; n5 < n2; ++n5) {
            list4.add(list4.get(n4 + n5));
        }
        this.log("  AFTER  COPY: fromArray.size()=" + list4.size() + " : \n  " + list4);
        this.log("  BEFORE COPY: condArray.size()=" + list5.size() + " : \n  " + list5);
        for (n5 = 0; n5 < n2; ++n5) {
            list5.add(list5.get(n4 + n5));
        }
        this.log("  AFTER  COPY: condArray.size()=" + list5.size() + " : \n  " + list5);
        this.log("  BEFORE COPY: sAliasArray.size()=" + list6.size() + " : \n  " + list6);
        for (n5 = 0; n5 < n2; ++n5) {
            list6.add(list6.get(n4 + n5));
        }
        this.log("  AFTER  COPY: sAliasArray.size()=" + list6.size() + " : \n  " + list6);
    }

    private String getExprFromArrays(String string, int n, String string2, List<List<String>> list, List<List<String>> list2, List<String> list3, List<Map<String, String>> list4) {
        String string3 = null;
        String string4 = string.substring(0, string.indexOf(58));
        int n2 = Integer.parseInt(string.substring(string.indexOf(58) + 1, string.length()));
        this.log("orig_pos_in_tp: " + string4 + " : orig_po_idx=" + n2);
        if (string4.equals("graph")) {
            if (list4 == null) {
                string3 = list3.get(n);
            } else {
                Map<String, String> map = list4.get(n);
                for (String string5 : map.keySet()) {
                    String string6 = map.get(string5);
                    if ((string6 + "+").indexOf("+" + n2 + "+") == -1) continue;
                    string3 = string5;
                    this.log("picked gExpr=" + string5 + " from TpGE: " + map);
                }
            }
        } else if (string4.equals("subject")) {
            string3 = string2;
        } else if (string4.equals("predicate")) {
            List<String> list5 = list.get(n2);
            this.log("orig_pExprArray.size()=" + list5.size() + " : " + list5);
            string3 = list5.get(n);
        } else if (string4.equals("object")) {
            List<String> list6 = list2.get(n2);
            this.log("orig_oExprArray.size()=" + list6.size() + " : " + list6);
            string3 = list6.get(n);
        } else {
            this.log("getExprFromArrays: Exception: unknown orig_pos_in_tp=" + string4);
        }
        this.log("getExprFromArrays: returning: " + string3);
        return string3;
    }

    private String genLikeFilterCond_new(RelExpr relExpr, String string, String string2, String string3, RRTabRowInfo rRTabRowInfo, int n, String string4, String string5) throws RDFException {
        int n2;
        String string6 = "";
        this.log("genLikeFilterCond_new: INPUT: pattern=" + string3 + " RRrowid=" + rRTabRowInfo.rowid + " | comp_idx=" + n + " | alias=" + string5 + " | sqlExpr=" + string4);
        String string7 = rRTabRowInfo.termTypes.get(n);
        Integer n3 = rRTabRowInfo.exprTypes.get(n);
        List<String> list = rRTabRowInfo.strLists.get(n);
        List<String> list2 = rRTabRowInfo.colLists.get(n);
        List<String> list3 = rRTabRowInfo.colTypeLists.get(n);
        this.log("genLikeFilterCond_new: map_exprType=" + n3 + " | map_termType=" + string7);
        int n4 = -1;
        boolean bl = true;
        if (string3.indexOf(95) == -1) {
            n2 = string3.indexOf(37);
            int n5 = -1;
            if (n2 != -1) {
                n5 = string3.indexOf(37, n2 + 1);
            }
            this.log("first_pct_pos=" + n2 + " second_pct_pos=" + n5 + " pattern.length()=" + string3.length());
            if (n2 == -1) {
                n4 = 0;
            } else if (n2 == 0 && n5 == -1) {
                n4 = 1;
            } else if (n2 == string3.length() - 1) {
                n4 = 2;
            } else if (n2 == 0 && n5 == string3.length() - 1) {
                n4 = 3;
            } else {
                bl = false;
                this.log("LIKE filter optimization: could not optimize b/c pattern has wildcard (%) not just at left and/or right ends");
            }
        } else {
            bl = false;
            this.log("LIKE filter optimization: could not optimize b/c pattern contains underscore (_)");
        }
        this.log("optimizable=" + bl + " pattern_type=" + n4);
        if (bl) {
            if (n3 == RRTabRowInfo.MapExprType_CONSTANT) {
                String string8;
                n2 = 0;
                String string9 = list.get(0);
                String string10 = null;
                if (string7.equals(rrIRI)) {
                    string10 = "<" + string9 + ">";
                } else if (string7.equals(rrBlankNode)) {
                    string10 = "_:" + string9;
                } else if (string7.equals(rrLiteral)) {
                    string10 = "\"" + string9 + "\"";
                    if (!rRTabRowInfo.oDataType.equals(XSD_STRING)) {
                        string10 = string10 + "^^" + rRTabRowInfo.oDataType;
                    }
                } else {
                    throw new RDFException("unknown map_termType=" + string7);
                }
                this.log("map_rdfterm=" + string10);
                String string11 = string10;
                if (n4 == 0) {
                    if (string11.equals(string3)) {
                        n2 = 1;
                    }
                } else if (n4 == 1) {
                    int n6 = string11.lastIndexOf(string3.substring(1));
                    if (n6 != -1 && n6 == string11.length() - (string3.length() - 1)) {
                        n2 = 1;
                    }
                } else if (n4 == 2) {
                    if (string11.indexOf(string3.substring(0, string3.length() - 1)) == 0) {
                        n2 = 1;
                    }
                } else if (n4 == 3) {
                    this.log("pattern is %str% case");
                    if (string11.indexOf(string3.substring(1, string3.length() - 1)) != -1) {
                        n2 = 1;
                    }
                } else {
                    throw new RDFException("constant-valued case: pattern_type=" + n4);
                }
                if ((string8 = this.gen_e_z_filter_cond(relExpr, n2 != 0, false)).length() > 0) {
                    string6 = string6 + string8;
                    this.log("optimized LIKE or NOT LIKE condition: [" + string6 + "]");
                    return string6;
                }
                throw new RDFException("We couldn't get an easy condition e_z_cond from gen_e_z_filter_cond for relExpr=" + relExpr + " and matchability=" + (n2 != 0));
            }
            if (n3 == RRTabRowInfo.MapExprType_TEMPLATE) {
                this.log("template map: optimization not implemented");
                bl = false;
            } else if (n3 == RRTabRowInfo.MapExprType_COLUMN) {
                this.log("column map: optimization not implemented");
                bl = false;
            } else {
                throw new RDFException("unknown map_exprType=" + n3);
            }
        }
        this.log("generating unoptimized LIKE condition");
        string6 = string6 + COND_CONNECTOR + string4 + BASE_PREFIX_COLNAME_SEP + string2 + " '" + string3 + "'";
        return string6;
    }

    private static String const_for_native_comparison(String string, boolean bl, boolean bl2) {
        String string2;
        String string3 = "'" + (string.indexOf("'") >= 0 ? string.replace("'", "''") : string) + "'";
        String string4 = string2 = bl && string.indexOf("%") >= 0 ? URL_UNESCAPE_BEG + string3 + ")" : string3;
        String string5 = string.indexOf(delim) >= 0 ? TTL_UNESCAPE_BEG + string2 + (!bl2 ? ")" : ", options=>'NO_TC=T')") : string2;
        return string5;
    }

    private String genFilterCond_new(RelExpr relExpr, RRTabRowInfo rRTabRowInfo, int n, String string, String string2) throws RDFException {
        boolean bl;
        this.log("genFilterCond_new: INPUT: RRrowid=" + rRTabRowInfo.rowid + " | comp_idx=" + n + " | alias=" + string2 + " | sqlExpr=" + string + "\nRelExpr: " + relExpr.toString());
        this.log("RRrowInfo for var-matching RRrow:" + rRTabRowInfo.toString());
        if (relExpr.RelExprFlags == 2L) {
            this.log("genFilterCond_new: GEOMETRY filters not processed here");
            return "";
        }
        String[] stringArray = new String[]{"=", "SAMETERM", "IN", "!=", "DIFFTERM", "NOT IN"};
        String[] stringArray2 = new String[]{"=", "SAMETERM", "IN"};
        String[] stringArray3 = new String[]{"!=", "DIFFTERM", "NOT IN"};
        String[] stringArray4 = new String[]{"=", "IN", "!=", "NOT IN"};
        String[] stringArray5 = new String[]{"IN", "NOT IN"};
        String[] stringArray6 = new String[]{"SAMETERM", "DIFFTERM"};
        String[] stringArray7 = new String[]{"<", "<=", ">", ">="};
        String[] stringArray8 = new String[]{"<=", ">="};
        String[] stringArray9 = new String[]{"<", ">"};
        String string3 = rRTabRowInfo.termTypes.get(n);
        Integer n2 = rRTabRowInfo.exprTypes.get(n);
        List<String> list = rRTabRowInfo.strLists.get(n);
        List<String> list2 = rRTabRowInfo.colLists.get(n);
        List<String> list3 = rRTabRowInfo.colTypeLists.get(n);
        this.log("genFilterCond_new: map_exprType=" + n2 + " | map_termType=" + string3);
        String string4 = "";
        String string5 = relExpr.compOperator;
        String string6 = relExpr.compOperator;
        if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("IN")) {
            string6 = "=";
        } else if (relExpr.compOperator.equals("DIFFTERM") || relExpr.compOperator.equals("NOT IN")) {
            string6 = "!=";
        }
        int n3 = relExpr.L_atom.type;
        int n4 = relExpr.R_atom.type;
        ASTTripleAtom aSTTripleAtom = null;
        ASTTripleAtom aSTTripleAtom2 = null;
        if (n3 == 0 && n4 != 0) {
            aSTTripleAtom = relExpr.L_atom;
            aSTTripleAtom2 = relExpr.R_atom;
        } else if (n4 == 0 && n3 != 0) {
            relExpr.InvertRelExpr();
            aSTTripleAtom = relExpr.L_atom;
            aSTTripleAtom2 = relExpr.R_atom;
        } else {
            this.log("skipping FILTER opt for this relExpr b/c it is NOT of the form: v <compOp> rdfterm, or vice-versa");
            return string4;
        }
        if (relExpr.compOperator.equals("LIKE") || relExpr.compOperator.equals("NOT LIKE")) {
            string4 = string4 + this.genLikeFilterCond_new(relExpr, aSTTripleAtom.name, relExpr.compOperator, aSTTripleAtom2.name, rRTabRowInfo, n, string, string2);
            this.log("genFilterCond [LIKE filter]: " + string4);
            return string4;
        }
        ASTTripleAtom[] aSTTripleAtomArray = relExpr.R_atoms;
        boolean[] blArray = new boolean[aSTTripleAtomArray.length];
        int n5 = 0;
        boolean bl2 = false;
        this.log("genFilterCond_new: R_atoms.length=" + aSTTripleAtomArray.length);
        for (int i = 0; i < aSTTripleAtomArray.length; ++i) {
            ASTTripleAtom aSTTripleAtom3 = i == 0 ? aSTTripleAtom2 : aSTTripleAtomArray[i];
            this.log("checking for termType mismatch: R_atom: " + aSTTripleAtom3);
            if (string3.equals(rrIRI) && aSTTripleAtom3.type != 1 || string3.equals(rrBlankNode) && aSTTripleAtom3.type != 11 || string3.equals(rrLiteral) && !aSTTripleAtom3.literalHasType() && aSTTripleAtom3.type != 3) {
                this.log("termType mismatch in single-var filter: i=" + i + " map_termType=" + string3 + " R_atom: " + aSTTripleAtom3);
                blArray[i] = false;
                ++n5;
                continue;
            }
            blArray[i] = true;
            if (bl2) continue;
            bl2 = true;
            if (i <= 0) continue;
            aSTTripleAtom2 = aSTTripleAtom3;
        }
        if (n5 >= aSTTripleAtomArray.length) {
            this.log("termType mismatch in single-var filter: count=" + n5);
            if (string5.equals("!=") || string5.equals("DIFFTERM") || string5.equals("NOT IN")) {
                this.log("termType mismatch: compOperator=" + string5 + ": returning COND_TRUE ");
                return COND_TRUE;
            }
            this.log("termType mismatch: compOperator=" + string5 + ": returning COND_FALSE ");
            return " AND 1=0 ";
        }
        String string7 = "";
        if (string5.equals("=") || string5.equals("SAMETERM") || string5.equals("IN")) {
            bl = false;
        } else {
            bl = true;
            string7 = "NOT ";
        }
        this.log("term_atom.type=" + aSTTripleAtom2.type);
        if (aSTTripleAtom2.type == 1) {
            if (!(string5.equals("=") || string5.equals("SAMETERM") || string5.equals("!=") || string5.equals("DIFFTERM") || string5.equals("IN") || string5.equals("NOT IN"))) {
                throw new RDFException("Comparison of incompatible types in SPARQL filter expression: IRIs can only be checked for =, sameTerm, != : compOperator=" + string5);
            }
            if (n2 == RRTabRowInfo.MapExprType_CONSTANT) {
                this.log("CASE: URI-[URI+Constant]");
                if (string5.equals("IN") || string5.equals("NOT IN")) {
                    this.log("URI from map: " + list.get(0));
                    String string8 = string5.equals("IN") ? " AND 1=0 " : COND_TRUE;
                    for (int i = 0; i < aSTTripleAtomArray.length; ++i) {
                        if (!blArray[i]) continue;
                        ASTTripleAtom aSTTripleAtom4 = aSTTripleAtomArray[i];
                        this.log("IN-List[" + i + "]: " + aSTTripleAtom4.name);
                        if (!list.get(0).equals(aSTTripleAtom4.name)) continue;
                        string8 = string5.equals("IN") ? COND_TRUE : " AND 1=0 ";
                        break;
                    }
                    string4 = string4 + string8;
                } else {
                    string4 = list.get(0).equals(aSTTripleAtom2.name) ? (string5.equals("=") || string5.equals("SAMETERM") ? string4 + COND_TRUE : string4 + " AND 1=0 ") : (string5.equals("=") || string5.equals("SAMETERM") ? string4 + " AND 1=0 " : string4 + COND_TRUE);
                }
                return string4;
            }
            if (n2 == RRTabRowInfo.MapExprType_COLUMN) {
                this.log("CASE: URI-[URI+Column]");
                if (list3.get(0).equals("STRING")) {
                    String string9 = "";
                    boolean bl3 = false;
                    if (string5.equals("IN") || string5.equals("NOT IN")) {
                        this.log("Handling " + string5 + " Filter: COLUMN from map: " + list2.get(0));
                        String string10 = "(";
                        for (int i = 0; i < aSTTripleAtomArray.length; ++i) {
                            if (!blArray[i]) continue;
                            ASTTripleAtom aSTTripleAtom5 = aSTTripleAtomArray[i];
                            this.log("IN-List[" + i + "]: " + aSTTripleAtom5.name);
                            string10 = string10 + "'" + aSTTripleAtom5.name.replace("'", "''") + "',";
                        }
                        string10 = string10.substring(0, string10.length() - 1) + ")";
                        this.log("val_list: " + string10);
                        string4 = COND_CONNECTOR + string4 + string2 + "." + list2.get(0) + BASE_PREFIX_COLNAME_SEP + string5 + BASE_PREFIX_COLNAME_SEP + string10;
                        bl3 = true;
                        this.log("filterCondExpr: " + string4);
                    } else {
                        string9 = string5.equals("=") || string5.equals("SAMETERM") ? "=" : "!=";
                    }
                    if (!bl3) {
                        string4 = COND_CONNECTOR + string4 + string2 + "." + list2.get(0) + BASE_PREFIX_COLNAME_SEP + string9 + " '" + aSTTripleAtom2.name.replace("'", "''") + "' ";
                    }
                } else {
                    string4 = string5.equals("=") || string5.equals("SAMETERM") ? string4 + " AND 1=0 " : string4 + COND_TRUE;
                }
                return string4;
            }
            if (n2 == RRTabRowInfo.MapExprType_TEMPLATE) {
                this.log("CASE: URI-[URI+Template]");
                this.log("Handling " + string5 + " Filter: template strList from map: " + list);
                int n6 = 0;
                string4 = COND_CONNECTOR;
                if (aSTTripleAtomArray.length > 1) {
                    string4 = string4 + "(";
                }
                String string11 = "";
                for (int i = 0; i < aSTTripleAtomArray.length; ++i) {
                    ArrayList<String> arrayList;
                    boolean bl4;
                    if (!blArray[i]) continue;
                    if (i > 0) {
                        aSTTripleAtom2 = aSTTripleAtomArray[i];
                        if (n6 == 1) {
                            String string12 = string11 = bl ? COND_CONNECTOR : " OR ";
                        }
                    }
                    if (bl4 = RelationalBGP.matchableSqlTemplateAndConstant_genCondInfo(list, list2, list3, aSTTripleAtom2.name, arrayList = new ArrayList<String>(), this.ctx)) {
                        if (arrayList.size() == list2.size()) {
                            String string13 = "";
                            for (int j = 0; j < list2.size(); ++j) {
                                String string14 = "";
                                String string15 = "";
                                if (!list3.get(j).equals("STRING") && !list3.get(j).equals(LTC_TYPE_NUMBER)) {
                                    string14 = "to_char(";
                                    string15 = ")";
                                } else if (list3.get(j).equals(LTC_TYPE_NUMBER)) {
                                    String string16 = (String)arrayList.get(j);
                                    String string17 = null;
                                    if (string16.indexOf(46) != -1) {
                                        double d = Double.parseDouble(string16);
                                        string17 = String.valueOf(d);
                                        if (Math.ceil(d) == Math.floor(d)) {
                                            string17 = string17.substring(0, string17.indexOf(46));
                                        }
                                    } else {
                                        long l = Long.parseLong(string16);
                                        string17 = String.valueOf(l);
                                    }
                                    this.log("canon_num_str=" + string17);
                                    if (!string17.equals(string16)) {
                                        string14 = "to_char(";
                                        string15 = ")";
                                    }
                                }
                                string13 = string13 + COND_CONNECTOR + string14 + string2 + "." + list2.get(j) + string15 + " = " + RelationalBGP.const_for_native_comparison((String)arrayList.get(j), true, this.ctx.noTC);
                            }
                            string13 = string11 + string7 + "( " + string13.substring(COND_CONNECTOR.length()) + " )";
                            string4 = string4 + string13;
                        } else {
                            string4 = string4 + string11 + "( " + string + BASE_PREFIX_COLNAME_SEP + string6 + " '<" + aSTTripleAtom2.name.replace("'", "''") + ">' )";
                        }
                        ++n6;
                        continue;
                    }
                    this.log("NOT matchable with: " + aSTTripleAtom2.name);
                }
                this.log("After for loop: matchable_count=" + n6 + " (at this point) filterCondExpr: " + string4);
                if (aSTTripleAtomArray.length > 1) {
                    string4 = string4 + ")";
                }
                if (n6 == 0) {
                    string4 = string5.equals("=") || string5.equals("SAMETERM") || string5.equals("IN") ? " AND 1=0 " : COND_TRUE;
                }
                return string4;
            }
        }
        if (!aSTTripleAtom2.literalHasType() && aSTTripleAtom2.type != 3) {
            this.log("skipping FILTER opt for this relExpr b/c it is NOT of the form: v <compOp> <numeric/plain/typed literal>, or vice-versa");
            return string4;
        }
        if (n != 2) {
            this.log("skipping FILTER opt for this relExpr b/c comp_idx is NOT in the object position");
            return string4;
        }
        if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_TEMPLATE) {
            String string18;
            this.log("CASE: Literal-[Literal+Template]");
            this.log("Handling " + string5 + " Filter: template strList from map: " + list);
            int n7 = 0;
            int n8 = 0;
            if (Arrays.asList(stringArray2).indexOf(string5) >= 0) {
                string18 = "=";
                bl = false;
                string7 = "";
            } else if (Arrays.asList(stringArray3).indexOf(string5) >= 0) {
                string18 = "=";
                bl = true;
                string7 = "NOT ";
            } else {
                string18 = relExpr.compOperator;
                bl = false;
                string7 = "";
            }
            String string19 = rRTabRowInfo.oDataType.substring(1, rRTabRowInfo.oDataType.length() - 1);
            String string20 = this.TYPE_FAMILY(rRTabRowInfo.oDataType.substring(1, rRTabRowInfo.oDataType.length() - 1));
            this.log("objType=" + string19 + " objTypeFam=" + string20);
            string4 = COND_CONNECTOR;
            if (aSTTripleAtomArray.length > 1) {
                string4 = string4 + "(";
            }
            String string21 = "";
            String string22 = "";
            for (int i = 0; i < aSTTripleAtomArray.length; ++i) {
                if (!blArray[i]) continue;
                if (i > 0) {
                    aSTTripleAtom2 = aSTTripleAtomArray[i];
                    if (n7 == 1) {
                        string22 = bl ? COND_CONNECTOR : " OR ";
                    }
                }
                String string23 = aSTTripleAtom2.name;
                String string24 = aSTTripleAtom2.litType;
                String string25 = aSTTripleAtom2.type == 3 ? "STRING" : this.TYPE_FAMILY(string24);
                this.log("Comparing term: IN-List[" + i + "]: " + aSTTripleAtom2.name);
                this.log("TERM_ATOM.TYPE (value_type)=" + aSTTripleAtom2.type);
                this.log("litType=" + string24 + " | litTypeFam=" + string25 + " | oDataType=" + rRTabRowInfo.oDataType);
                this.log("litTypeFam=" + string25 + " | objTypeFam=" + string20);
                if (!string25.equals(string20) || string25.equals(TYPE_FAM_OTHER) && !string24.equals(string19)) {
                    this.log("CASE: different type families: litTypeFam=" + string25 + " objTypeFam=" + string20 + " compOp=" + string5);
                    if (string25.equals(TYPE_FAM_OTHER) || string20.equals(TYPE_FAM_OTHER)) {
                        this.log("at least one of the types is unknown (OTHER): false_notEqual_count=" + ++n8);
                        continue;
                    }
                    if (Arrays.asList(stringArray3).indexOf(string5) >= 0) {
                        this.log("CASE: !=, !sameTerm : 1=1");
                        continue;
                    }
                    this.log("genFilterCond: " + string4);
                    continue;
                }
                if (string24 != null && string24.equals(XSD_STRING_NO_ENCLOSING) && (string5.equals("SAMETERM") || string5.equals("DIFFTERM"))) continue;
                if (string25.equals(TYPE_FAM_OTHER) && Arrays.asList(stringArray2).indexOf(string5) == -1) {
                    this.log("identical, but unknown (OTHER) datatypes: false_notEqual_count=" + ++n8);
                    continue;
                }
                if (Arrays.asList(stringArray).indexOf(string5) == -1) {
                    this.log("ieq case: compOperator: " + string5);
                    ++n7;
                    string21 = string21 + string22 + string7 + "(" + SDO_RDF_VNAME_BEG + string + ")" + BASE_PREFIX_COLNAME_SEP + string6 + BASE_PREFIX_COLNAME_SEP + SDO_RDF_VNAME_BEG + "'\"" + aSTTripleAtom2.name + "\"" + (string25.equals(TYPE_FAM_OTHER) ? "^^<" + string24 + ">" : "") + "'" + ")" + ")";
                    continue;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl5 = RelationalBGP.matchableSqlTemplateAndConstant_genCondInfo(list, list2, list3, aSTTripleAtom2.name, arrayList, this.ctx);
                if (!bl5) continue;
                ++n7;
                if (arrayList.size() == list2.size() && Arrays.asList(stringArray4).indexOf(string5) >= 0) {
                    for (int j = 0; j < list2.size(); ++j) {
                        String string26 = "";
                        String string27 = "";
                        if (!list3.get(j).equals("STRING") && !list3.get(j).equals(LTC_TYPE_NUMBER)) {
                            string26 = "to_char(";
                            string27 = ")";
                        } else if (list3.get(j).equals(LTC_TYPE_NUMBER)) {
                            String string28 = (String)arrayList.get(j);
                            String string29 = null;
                            if (string28.indexOf(46) != -1) {
                                double d = Double.parseDouble(string28);
                                string29 = String.valueOf(d);
                                if (Math.ceil(d) == Math.floor(d)) {
                                    string29 = string29.substring(0, string29.indexOf(46));
                                }
                            } else {
                                long l = Long.parseLong(string28);
                                string29 = String.valueOf(l);
                            }
                            this.log("canon_num_str=" + string29);
                            if (!string29.equals(string28)) {
                                string26 = "to_char(";
                                string27 = ")";
                            }
                        }
                        string21 = string21 + string22 + string7 + "(" + string26 + string2 + "." + list2.get(j) + string27 + " = '" + (String)arrayList.get(j) + "')";
                    }
                    continue;
                }
                string21 = string21 + string22 + string7 + "(" + SDO_RDF_VNAME_BEG + string + ")" + BASE_PREFIX_COLNAME_SEP + string18 + BASE_PREFIX_COLNAME_SEP + SDO_RDF_VNAME_BEG + "'\"" + aSTTripleAtom2.name + "\"" + (string25.equals(TYPE_FAM_OTHER) ? "^^<" + string24 + ">" : "") + "'" + ")" + ")";
            }
            this.log("FINAL matchable_count=" + n7 + " BEFORE SETTING filterCondExpr: " + string4);
            if (n7 == 0) {
                string4 = " AND 1=0 ";
                if (string5.equals("DIFFTERM") || n8 == 0 && (string5.equals("!=") || string5.equals("NOT IN"))) {
                    string4 = COND_TRUE;
                }
            } else {
                string4 = " AND (" + string21 + ")";
            }
            this.log("genFilterCond: END-OF-CASE: Literal-[Literal+Template] returning: " + string4);
            return string4;
        }
        if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_COLUMN) {
            String string30;
            this.log("CASE: Literal-[Literal+Column] initial filterCondExpr: " + string4);
            if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("IN")) {
                string30 = "=";
                bl = false;
                string7 = "";
            } else if (relExpr.compOperator.equals("DIFFTERM") || relExpr.compOperator.equals("NOT IN")) {
                string30 = "=";
                bl = true;
                string7 = "NOT ";
            } else {
                string30 = relExpr.compOperator;
                bl = false;
                string7 = "";
            }
            String string31 = rRTabRowInfo.oExpr;
            String string32 = string31.charAt(0) == '\"' ? string31.substring(1, string31.length() - 1) : string31;
            this.log("LtcRow: key=" + rRTabRowInfo.Tmap + "+" + string32);
            String string33 = this.LtcRowInfo_for_Tmap_plus_Col.get((Object)new StringBuilder().append((String)rRTabRowInfo.Tmap).append((String)"+").append((String)string32).toString()).colTypeName;
            String string34 = rRTabRowInfo.oDataType.substring(1, rRTabRowInfo.oDataType.length() - 1);
            String string35 = this.TYPE_FAMILY(rRTabRowInfo.oDataType.substring(1, rRTabRowInfo.oDataType.length() - 1));
            this.log("objType=" + string34 + " objTypeFam=" + string35);
            String string36 = "";
            int n9 = 0;
            int n10 = 0;
            for (int i = 0; i < aSTTripleAtomArray.length; ++i) {
                if (!blArray[i]) continue;
                if (i > 0) {
                    aSTTripleAtom2 = aSTTripleAtomArray[i];
                    this.log("i=[" + i + "] TERM_ATOM: " + aSTTripleAtom2);
                    if (n9 == 1) {
                        string36 = bl ? COND_CONNECTOR : " OR ";
                    }
                }
                String string37 = aSTTripleAtom2.name.replace("'", "''");
                String string38 = aSTTripleAtom2.litType;
                String string39 = "";
                String string40 = "";
                if (string37.indexOf(92) >= 0) {
                    string39 = TTL_UNESCAPE_BEG;
                    string40 = !this.ctx.noTC ? ")" : ", options=>'NO_TC=T')";
                }
                this.log("TERM_ATOM.TYPE (value_type)=" + aSTTripleAtom2.type);
                String string41 = aSTTripleAtom2.type == 3 ? "STRING" : this.TYPE_FAMILY(string38);
                String string42 = "";
                this.log("litType=" + string38 + " | litTypeFam=" + string41 + " | colTypeName=" + string33 + " | oDataType=" + rRTabRowInfo.oDataType);
                this.log("litTypeFam=" + string41 + " | colTypeName=" + string33 + " | objTypeFam=" + string35);
                if (string41.equals("STRING") && string41.equals(string35) && string33.equals("STRING")) {
                    this.log("CASE: equal type families, STRING-STRING");
                    if (aSTTripleAtom2.type == 3) {
                        ++n9;
                        string42 = string42 + string36 + string7 + "( " + string2 + "." + string31 + BASE_PREFIX_COLNAME_SEP + string30 + BASE_PREFIX_COLNAME_SEP + string39 + "'" + string37 + "'" + string40 + " )";
                    } else if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                        this.log("CASE: term (not value) comparison: " + relExpr.compOperator);
                    } else {
                        ++n9;
                        string42 = string42 + string36 + string7 + "( " + string2 + "." + string31 + BASE_PREFIX_COLNAME_SEP + string30 + BASE_PREFIX_COLNAME_SEP + string39 + "'" + string37 + "'" + string40 + " )";
                    }
                    this.log("matchable_count=" + n9 + " condExpr: " + string42);
                } else if (string41.equals("STRING") && string41.equals(string35) && string33.equals(LTC_TYPE_STRING_CLOB)) {
                    this.log("CASE: equal type families, STRING_CLOB(var)-STRING(literal)");
                    if (aSTTripleAtom2.type == 3 || !relExpr.compOperator.equals("SAMETERM") && !relExpr.compOperator.equals("DIFFTERM")) {
                        ++n9;
                        string42 = string42 + string36 + string7 + "( " + TTL_COMPARE_CLOB_BEG + string2 + "." + string31 + ", " + string39 + "'" + string37 + "'" + string40 + ")" + sqlcompOper_clobCompare_map.get(string30) + " )";
                    } else {
                        this.log("CASE: term (not value) comparison: " + relExpr.compOperator);
                    }
                    this.log("matchable_count=" + n9 + " condExpr: " + string42);
                } else if ((string41.equals(TYPE_FAM_NUMERIC) || string41.equals(TYPE_FAM_FLOAT) || string41.equals(TYPE_FAM_DOUBLE)) && (string35.equals(TYPE_FAM_NUMERIC) || string35.equals(TYPE_FAM_FLOAT) || string35.equals(TYPE_FAM_DOUBLE)) && (string33.equals(LTC_TYPE_NUMBER) || string33.equals(LTC_TYPE_BFLOAT) || string33.equals(LTC_TYPE_BDOUBLE))) {
                    this.log("CASE: equal-or-compatible type families, NUMERIC/FLOAT/DOUBLE(NFD)-NUMBER/BFLOAT/BDOUBLE(NbFbD)");
                    if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                        if (!string38.equals(string34)) {
                            this.log("CASE: : mismatch=> !litType.equals(objType): litType=" + string38 + " objType=" + string34);
                        } else {
                            String string43 = string2 + "." + string31;
                            if (!string33.equals(LTC_TYPE_NUMBER) || !string35.equals(TYPE_FAM_NUMERIC)) {
                                string43 = "to_number(" + string43 + ")";
                            }
                            ++n9;
                            string42 = string42 + string36 + string7 + "( " + SDO_RDF_VNAME_BEG + "sdo_rdf.get_canon_val('\"' || " + string43 + " || '\"^^<" + string34 + ">')" + ")" + BASE_PREFIX_COLNAME_SEP + string30 + SDO_RDF_VNAME_BEG + " '\"" + string37 + "\"^^<" + string38 + ">'" + ")" + " )";
                        }
                    } else if (string33.equals(LTC_TYPE_NUMBER) && string35.equals(TYPE_FAM_NUMERIC)) {
                        String string44 = !string41.equals(TYPE_FAM_NUMERIC) ? "to_number(" + string37 + ")" : string37;
                        ++n9;
                        string42 = string42 + string36 + string7 + "( " + string2 + "." + string31 + BASE_PREFIX_COLNAME_SEP + string30 + BASE_PREFIX_COLNAME_SEP + string44 + " )";
                    } else {
                        String string45 = null;
                        String string46 = string37;
                        if (string35.equals(TYPE_FAM_NUMERIC)) {
                            string45 = "to_char(" + string2 + "." + string31 + ")";
                        } else if (string35.equals(TYPE_FAM_FLOAT)) {
                            string45 = !string33.equals(LTC_TYPE_BFLOAT) ? "to_binary_float(to_char(" + string2 + "." + string31 + "))" : string2 + "." + string31;
                        } else if (string35.equals(TYPE_FAM_DOUBLE)) {
                            string45 = !string33.equals(LTC_TYPE_BDOUBLE) ? "to_binary_double(to_char(" + string2 + "." + string31 + "))" : string2 + "." + string31;
                        }
                        ++n9;
                        string42 = string42 + string36 + string7 + "( to_number(" + string45 + ") " + string30 + " to_number(" + string46 + ") )";
                    }
                    this.log("matchable_count=" + n9 + " condExpr: " + string42);
                } else if (string41.equals("DATE") && string35.equals("DATE") && string33.equals("DATE")) {
                    this.log("CASE: equal type families, DATE-DATE");
                    boolean bl6 = false;
                    if (RelationalBGP.tzone(string37) != null) {
                        bl6 = true;
                    }
                    if (bl6) {
                        String string47 = "to_timestamp_tz(ltrim(to_char(" + string2 + "." + string31 + ",'" + FORMAT_DATE + "')) || 'Z','" + FORMAT_DATE_TZ + "')";
                        String string48 = "to_timestamp_tz('" + string37 + "','" + FORMAT_DATE_TZ + "')";
                        ++n9;
                        string42 = string42 + string36 + string7 + "( (" + string47 + " - INTERVAL '14' HOUR " + string30 + BASE_PREFIX_COLNAME_SEP + string48 + COND_CONNECTOR + string47 + " + INTERVAL '14' HOUR " + string30 + BASE_PREFIX_COLNAME_SEP + string48 + ") )";
                    } else {
                        ++n9;
                        string42 = string42 + string36 + string7 + "( " + string2 + "." + string31 + BASE_PREFIX_COLNAME_SEP + string30 + " to_date('" + string37 + "','" + FORMAT_DATE + "') )";
                    }
                    this.log("matchable_count=" + n9 + " condExpr: " + string42);
                } else if (string41.equals(TYPE_FAM_DATETIME) && string35.equals(TYPE_FAM_DATETIME) && string33.indexOf(LTC_TYPE_TIMESTAMP) == 0) {
                    this.log("CASE: equal type families, DATETIME-TIMESTAMP");
                    boolean bl7 = false;
                    boolean bl8 = false;
                    if (RelationalBGP.tzone(string37) != null) {
                        bl7 = true;
                    }
                    if (string33.equals(LTC_TYPE_TIMESTAMP_TZ) || string33.equals(LTC_TYPE_TIMESTAMP_LTZ)) {
                        bl8 = true;
                    }
                    if (bl7) {
                        ++n9;
                        if (bl8) {
                            string42 = string42 + string36 + string7 + "( " + string2 + "." + string31 + BASE_PREFIX_COLNAME_SEP + string30 + " to_timestamp_tz('" + string37 + "','" + FORMAT_TIMESTAMP_TZ + "') )";
                        } else {
                            this.log("term_has_timezone=" + bl7 + " col_has_timezone=" + bl8);
                            string42 = string42 + string36 + string7 + "( (to_timestamp_tz(to_char(" + string2 + "." + string31 + ",'" + FORMAT_TIMESTAMP + "') || '" + TZ_LOWER + "','" + FORMAT_TIMESTAMP_TZ + "') " + string30 + " to_timestamp_tz('" + string37 + "','" + FORMAT_TIMESTAMP_TZ + "') AND to_timestamp_tz(to_char(" + string2 + "." + string31 + ",'" + FORMAT_TIMESTAMP + "') || '" + TZ_UPPER + "','" + FORMAT_TIMESTAMP_TZ + "') " + string30 + " to_timestamp_tz('" + string37 + "','" + FORMAT_TIMESTAMP_TZ + "')) )";
                        }
                        this.log("term has time zone: condExpr=" + string42);
                    } else {
                        ++n9;
                        if (bl8) {
                            this.log("term_has_timezone=" + bl7 + " col_has_timezone=" + bl8);
                            string42 = string42 + string36 + string7 + "( (" + string2 + "." + string31 + BASE_PREFIX_COLNAME_SEP + string30 + " to_timestamp_tz('" + string37 + TZ_LOWER + "','" + FORMAT_TIMESTAMP_TZ + "') AND " + string2 + "." + string31 + BASE_PREFIX_COLNAME_SEP + string30 + " to_timestamp_tz('" + string37 + TZ_UPPER + "','" + FORMAT_TIMESTAMP_TZ + "')) )";
                        } else {
                            string42 = string42 + string36 + string7 + "( " + string2 + "." + string31 + BASE_PREFIX_COLNAME_SEP + string30 + " to_timestamp('" + string37 + "','" + FORMAT_TIMESTAMP + "') )";
                        }
                        this.log("term does NOT have time zone: condExpr=" + string42);
                    }
                    this.log("matchable_count=" + n9 + " condExpr: " + string42);
                } else if (string33.equals(LTC_TYPE_STRING_CLOB)) {
                    this.log("CASE: non-STRING CLOB case (only OTHER types allowed): colTypeName=" + string33 + " objTypeFam=" + string35 + " litType=" + string38 + " litTypeFam=" + string41);
                    if (string41.equals(TYPE_FAM_OTHER) || string35.equals(TYPE_FAM_OTHER)) {
                        if (string38.equals(string34)) {
                            this.log("-: non-STRING CLOB case: objType=" + string35 + " litType=" + string38);
                            ++n9;
                            string42 = string42 + string36 + string7 + "( " + TTL_COMPARE_CLOB_BEG + string2 + "." + string31 + ", " + string39 + "'" + string37 + "'" + string40 + ")" + sqlcompOper_clobCompare_map.get(string30) + " )";
                        } else {
                            this.log("CASE: CLOB: mismatched types with TYPE_FAM_OTHER (return COND_FALSE): litType=" + string38 + " | objType=" + string34);
                        }
                    }
                    this.log("matchable_count=" + n9 + " condExpr: " + string42);
                } else if (string41.equals(string35)) {
                    this.log("CASE: Equal lit/obj TypeFam: but not one of the ones above: colTypeName=" + string33 + " objTypeFam=" + string35 + " litType=" + string38 + " litTypeFam=" + string41);
                    if (string5.equals("=") || string5.equals("SAMETERM") || string5.equals("!=") || string5.equals("DIFFTERM")) {
                        this.log("CASE: =, !=");
                        String string49 = "\"" + string37 + "\"";
                        if (string38 != null && string38.length() > 0) {
                            string49 = string49 + "^^<" + string38 + ">";
                        }
                        ++n9;
                        string42 = string42 + string36 + string7 + "( " + SDO_RDF_VNAME_BEG + string + ")" + BASE_PREFIX_COLNAME_SEP + string30 + BASE_PREFIX_COLNAME_SEP + SDO_RDF_VNAME_BEG + "sdo_rdf.get_canon_val('" + string49 + "')" + ")" + " )";
                    } else {
                        this.log("CASE: >=, <=, <, >");
                    }
                    this.log("matchable_count=" + n9 + " condExpr: " + string42);
                } else {
                    this.log("CASE: different type families: litTypeFam=" + string41 + " objTypeFam=" + string35 + " compOp=" + string5);
                    if (string41.equals(TYPE_FAM_OTHER) || string35.equals(TYPE_FAM_OTHER)) {
                        ++n10;
                        this.log("at least one of the types is unknown (OTHER): " + string42);
                    } else if (string5.equals("!=") || string5.equals("DIFFTERM")) {
                        this.log("CASE: !=, !sameTerm : 1=1");
                    } else {
                        this.log("genFilterCond.1: " + string42);
                    }
                    this.log("matchable_count=" + n9 + " condExpr: " + string42);
                }
                if (string42.length() <= 0) continue;
                string4 = string4 + string42;
                this.log("after processing term i=" + i + ": matchable_count=" + n9 + " filterCondExpr: " + string4);
            }
            this.log("FINAL matchable_count=" + n9 + " BEFORE SETTING filterCondExpr: " + string4);
            if (n9 == 0) {
                string4 = " AND 1=0 ";
                if (string5.equals("DIFFTERM") || n10 == 0 && (string5.equals("!=") || string5.equals("NOT IN"))) {
                    string4 = COND_TRUE;
                }
            } else {
                string4 = " AND (" + string4 + ")";
            }
            this.log("genFilterCond: END-OF-CASE: Literal-[Literal+Column] returning: " + string4);
            return string4;
        }
        if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_CONSTANT) {
            this.log("CASE: Literal-[Literal+Constant]");
            this.log("Literal constant from map: " + list.get(0));
            String string50 = rRTabRowInfo.oDataType.substring(1, rRTabRowInfo.oDataType.length() - 1);
            String string51 = this.TYPE_FAMILY(string50);
            if (string5.equals("IN") || string5.equals("NOT IN")) {
                String string52;
                if (relExpr.compOperator.equals("IN")) {
                    string52 = "=";
                    bl = false;
                    string7 = "";
                } else {
                    string52 = "=";
                    bl = true;
                    string7 = "NOT ";
                }
                String string53 = "";
                int n11 = 0;
                int n12 = 0;
                String string54 = "";
                String string55 = null;
                for (int i = 0; i < aSTTripleAtomArray.length; ++i) {
                    if (!blArray[i]) continue;
                    if (i > 0) {
                        aSTTripleAtom2 = aSTTripleAtomArray[i];
                        if (n11 == 1) {
                            string53 = bl ? COND_CONNECTOR : " OR ";
                        }
                    }
                    String string56 = aSTTripleAtom2.name;
                    String string57 = aSTTripleAtom2.litType;
                    String string58 = aSTTripleAtom2.type == 3 ? "STRING" : this.TYPE_FAMILY(string57);
                    this.log("Comparing term: IN-List[" + i + "]: " + aSTTripleAtom2.name);
                    if ((string51.equals(string58) || (string51.equals(TYPE_FAM_FLOAT) || string51.equals(TYPE_FAM_DOUBLE) || string51.equals(TYPE_FAM_NUMERIC)) && (string58.equals(TYPE_FAM_FLOAT) || string58.equals(TYPE_FAM_DOUBLE) || string58.equals(TYPE_FAM_NUMERIC))) && (!string51.equals(TYPE_FAM_OTHER) || string57.equals(string50))) {
                        if (string51.equals("STRING")) {
                            this.log("CASE: string comparisons");
                            this.log("      " + list.get(0) + " and " + aSTTripleAtom2.name);
                            this.log("CASE: equal type families (and neither is OTHER *or* two identical datatypes)");
                            if (!list.get(0).equals(aSTTripleAtom2.name)) continue;
                            this.log("CASE: equal strings");
                            string55 = string5.equals("IN") ? COND_TRUE : " AND 1=0 ";
                            break;
                        }
                        if (string51.equals(TYPE_FAM_DOUBLE) || string51.equals(TYPE_FAM_FLOAT) || string51.equals(TYPE_FAM_NUMERIC)) {
                            this.log("CASE: numeric comparisons");
                            double d = Double.valueOf(list.get(0));
                            double d2 = Double.valueOf(aSTTripleAtom2.name);
                            if (d == d2 && string51.equals(string58)) {
                                this.log("CASE: equal numbers: mapping=" + d + " term=" + d2);
                                string55 = string5.equals("IN") ? COND_TRUE : " AND 1=0 ";
                                break;
                            }
                            this.log("CASE: Skip term b/c NON-equal numbers or type families: mapping=" + d + ", " + string51 + "vs. term=" + d2 + ", " + string58);
                            continue;
                        }
                        if (string51.equals("DATE")) {
                            this.log("CASE: date comparisons - generate the native (db-col based) optimized condition");
                            if (!list.get(0).equals(string56)) continue;
                            this.log("CASE: equal dates");
                            string55 = string5.equals("IN") ? COND_TRUE : " AND 1=0 ";
                            break;
                        }
                        if (string51.equals(TYPE_FAM_DATETIME)) {
                            this.log("CASE: dateTime comparisons - generate the time-zone aware condition");
                            ++n11;
                            string54 = string54 + string53 + string7 + "( to_timestamp_tz('" + list.get(0) + "','" + FORMAT_TIMESTAMP_TZ + "') " + string52 + " to_timestamp_tz('" + string56 + "','" + FORMAT_TIMESTAMP_TZ + "') )";
                            continue;
                        }
                        this.log("CASE: get the literal (full rdfterm) constant");
                        ++n11;
                        String string59 = "\"" + string56 + "\"";
                        if (string57 != null && string57.length() > 0) {
                            string59 = string59 + "^^<" + string57 + ">";
                        }
                        string54 = string54 + string53 + string7 + "( " + SDO_RDF_VNAME_BEG + string + ")" + BASE_PREFIX_COLNAME_SEP + string52 + BASE_PREFIX_COLNAME_SEP + SDO_RDF_VNAME_BEG + "sdo_rdf.get_canon_val('" + string59 + "')" + ")" + " )";
                        continue;
                    }
                    this.log("CASE: different type families: litTypeFam=" + string58 + " objTypeFam=" + string51 + " compOp=" + string5);
                    if (string58.equals(TYPE_FAM_OTHER) || string51.equals(TYPE_FAM_OTHER)) {
                        ++n12;
                        this.log("at least one of the types is unknown (OTHER): considered no match for IN as well as NOT IN");
                        continue;
                    }
                    this.log("CASE: IN or NOT IN: did not match this term");
                }
                string4 = string55 != null ? string55 : (n11 > 0 ? " AND (" + string54 + ")" : (n12 == 0 && string5.equals("NOT IN") ? COND_TRUE : " AND 1=0 "));
                return string4;
            }
            String string60 = aSTTripleAtom2.name;
            String string61 = aSTTripleAtom2.litType;
            String string62 = aSTTripleAtom2.type == 3 ? "STRING" : this.TYPE_FAMILY(string61);
            this.log("litType=" + string61 + " (litTypeFam=" + string62 + ") objDataType=" + string50 + " (objTypeFam=" + string51 + ")");
            String string63 = null;
            if ((string51.equals(string62) || (string51.equals(TYPE_FAM_FLOAT) || string51.equals(TYPE_FAM_DOUBLE) || string51.equals(TYPE_FAM_NUMERIC)) && (string62.equals(TYPE_FAM_FLOAT) || string62.equals(TYPE_FAM_DOUBLE) || string62.equals(TYPE_FAM_NUMERIC))) && (!string51.equals(TYPE_FAM_OTHER) || string61.equals(string50))) {
                this.log("CASE: equal type families (and neither is OTHER *or* two identical datatypes)");
                if (string51.equals("STRING")) {
                    this.log("CASE: string comparisons");
                    this.log("      " + list.get(0) + "=" + aSTTripleAtom2.name);
                    if (list.get(0).equals(aSTTripleAtom2.name)) {
                        this.log("CASE: equal strings");
                        if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                            this.log("CASE: term (not value) comparison: " + relExpr.compOperator);
                            this.log("term_atom.type=" + aSTTripleAtom2.type + " RRrowInfo.oValueTypePL=" + rRTabRowInfo.oValueTypePL);
                            string4 = aSTTripleAtom2.type == 3 && rRTabRowInfo.oValueTypePL || aSTTripleAtom2.type != 3 && !rRTabRowInfo.oValueTypePL ? string4 + (relExpr.compOperator.equals("SAMETERM") ? COND_TRUE : " AND 1=0 ") : string4 + (relExpr.compOperator.equals("SAMETERM") ? " AND 1=0 " : COND_TRUE);
                        } else if (string5.equals("=") || string5.equals("<=") || string5.equals(">=")) {
                            this.log("CASE: =, <=, >= cond: 1=1");
                            string4 = string4 + COND_TRUE;
                        } else {
                            this.log("CASE: !=, <, > cond: 1=0");
                            string4 = string4 + " AND 1=0 ";
                        }
                    } else {
                        this.log("CASE: different strings");
                        if (string5.equals("=") || string5.equals("SAMETERM")) {
                            this.log("CASE: =, SAMETERM, 1=0");
                            string4 = string4 + " AND 1=0 ";
                        } else if (string5.equals("!=") || string5.equals("DIFFTERM") || (string5.equals("<") || string5.equals("<=")) && list.get(0).compareTo(aSTTripleAtom2.name) < 0 || (string5.equals(">") || string5.equals(">=")) && list.get(0).compareTo(aSTTripleAtom2.name) > 0) {
                            this.log("CASE: !=, !SAMETERM, <, >, <=, >=, 1=1");
                            string4 = string4 + COND_TRUE;
                        } else {
                            this.log("CASE: others, 1=0");
                            string4 = string4 + " AND 1=0 ";
                        }
                    }
                    this.log("FILTERCONDEXPR=" + string4);
                    return string4;
                }
                if (string51.equals(TYPE_FAM_DOUBLE) || string51.equals(TYPE_FAM_FLOAT) || string51.equals(TYPE_FAM_NUMERIC)) {
                    this.log("CASE: numeric comparisons");
                    double d = Double.valueOf(list.get(0));
                    double d3 = Double.valueOf(aSTTripleAtom2.name);
                    if (d == d3) {
                        this.log("CASE: equal numbers");
                        if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                            this.log("CASE: term (not value) comparison: " + relExpr.compOperator);
                            string4 = string61.equals(string50) && list.get(0).equals(aSTTripleAtom2.name) ? string4 + (relExpr.compOperator.equals("SAMETERM") ? COND_TRUE : " AND 1=0 ") : string4 + (relExpr.compOperator.equals("SAMETERM") ? " AND 1=0 " : COND_TRUE);
                        } else if (string5.equals("=") || string5.equals("<=") || string5.equals(">=")) {
                            this.log("CASE: =, <=, >= cond: 1=1");
                            string4 = string4 + COND_TRUE;
                        } else {
                            this.log("CASE: !=, <, > cond: 1=0");
                            string4 = string4 + " AND 1=0 ";
                        }
                    } else {
                        this.log("CASE: different numbers");
                        if (string5.equals("=") || string5.equals("SAMETERM")) {
                            this.log("CASE: =, SAMETERM, 1=0");
                            string4 = string4 + " AND 1=0 ";
                        } else if (string5.equals("!=") || string5.equals("DIFFTERM") || (string5.equals("<") || string5.equals("<=")) && d < d3 || (string5.equals(">") || string5.equals(">=")) && d > d3) {
                            this.log("CASE: !=, !SAMETERM, <, >, <=, >=, 1=1");
                            string4 = string4 + COND_TRUE;
                        } else {
                            this.log("CASE: others, 1=0");
                            string4 = string4 + " AND 1=0 ";
                        }
                    }
                    this.log("FILTERCONDEXPR=" + string4);
                    return string4;
                }
                if (string51.equals("DATE")) {
                    this.log("CASE: date comparisons - generate the native (db-col based) optimized condition");
                    if (list.get(0).equals(string60)) {
                        if (string5.equals("=") || string5.equals(">=") || string5.equals("<=")) {
                            string4 = string4 + COND_TRUE;
                        } else if (string5.equals("!=") || string5.equals(">") || string5.equals("<")) {
                            string4 = string4 + " AND 1=0 ";
                        } else if (string5.equals("SAMETERM")) {
                            string4 = string4 + COND_TRUE;
                        } else if (string5.equals("DIFFTERM")) {
                            string4 = string4 + " AND 1=0 ";
                        } else {
                            throw new RDFException("genFilterCond_new: unknown compOperator:[" + string5 + "]");
                        }
                        this.log("FILTERCONDEXPR=" + string4);
                        return string4;
                    }
                    if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                        string4 = string4 + (relExpr.compOperator.equals("SAMETERM") ? " AND 1=0 " : COND_TRUE);
                        this.log("FILTERCONDEXPR=" + string4);
                        return string4;
                    }
                    String string64 = list.get(0);
                    boolean bl9 = false;
                    boolean bl10 = false;
                    if (RelationalBGP.tzone(string64) != null) {
                        bl9 = true;
                    }
                    if (RelationalBGP.tzone(string60) != null) {
                        bl10 = true;
                    }
                    if (bl9 != bl10) {
                        this.log("time zone present in one but not the other: map_tzone_present=" + bl9 + " lit_tzone_present=" + bl10);
                        string63 = "(to_timestamp_tz('" + string64 + (bl9 ? "" : TZ_LOWER) + "','" + FORMAT_DATE_TZ + "') " + string6 + " to_timestamp_tz('" + string60 + (bl10 ? "" : TZ_LOWER) + "','" + FORMAT_DATE_TZ + "') AND to_timestamp_tz('" + string64 + (bl9 ? "" : TZ_UPPER) + "','" + FORMAT_DATE_TZ + "') " + string6 + " to_timestamp_tz('" + string60 + (bl10 ? "" : TZ_UPPER) + "','" + FORMAT_DATE_TZ + "'))";
                        this.log("time zone present-absent: condExpr=" + string63);
                    } else {
                        string63 = bl9 ? "to_timestamp_tz('" + string64 + "','" + FORMAT_DATE_TZ + "') " + string6 + " to_timestamp_tz('" + string60 + "','" + FORMAT_DATE_TZ + "')" : "to_timestamp('" + string64 + "','" + FORMAT_DATE + "') " + string6 + " to_timestamp('" + string60 + "','" + FORMAT_DATE + "')";
                    }
                } else if (string51.equals(TYPE_FAM_DATETIME)) {
                    this.log("CASE: dateTime comparisons - generate the native (db-col based) optimized condition");
                    if (list.get(0).equals(string60)) {
                        if (string5.equals("=") || string5.equals(">=") || string5.equals("<=")) {
                            string4 = string4 + COND_TRUE;
                        } else if (string5.equals("!=") || string5.equals(">") || string5.equals("<")) {
                            string4 = string4 + " AND 1=0 ";
                        } else if (string5.equals("SAMETERM")) {
                            string4 = string4 + COND_TRUE;
                        } else if (string5.equals("DIFFTERM")) {
                            string4 = string4 + " AND 1=0 ";
                        } else {
                            throw new RDFException("genFilterCond_new: unknown compOperator:[" + string5 + "]");
                        }
                        this.log("FILTERCONDEXPR=" + string4);
                        return string4;
                    }
                    if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                        string4 = string4 + (relExpr.compOperator.equals("SAMETERM") ? " AND 1=0 " : COND_TRUE);
                        this.log("FILTERCONDEXPR=" + string4);
                        return string4;
                    }
                    String string65 = list.get(0);
                    boolean bl11 = false;
                    boolean bl12 = false;
                    if (RelationalBGP.tzone(string65) != null) {
                        bl11 = true;
                    }
                    if (RelationalBGP.tzone(string60) != null) {
                        bl12 = true;
                    }
                    if (bl11 != bl12) {
                        this.log("time zone present in one but not the other: map_tzone_present=" + bl11 + " lit_tzone_present=" + bl12);
                        string63 = "(to_timestamp_tz('" + string65 + (bl11 ? "" : TZ_LOWER) + "','" + FORMAT_TIMESTAMP_TZ + "') " + string6 + " to_timestamp_tz('" + string60 + (bl12 ? "" : TZ_LOWER) + "','" + FORMAT_TIMESTAMP_TZ + "') AND to_timestamp_tz('" + string65 + (bl11 ? "" : TZ_UPPER) + "','" + FORMAT_TIMESTAMP_TZ + "') " + string6 + " to_timestamp_tz('" + string60 + (bl12 ? "" : TZ_UPPER) + "','" + FORMAT_TIMESTAMP_TZ + "'))";
                        this.log("time zone present-absent: condExpr=" + string63);
                    } else {
                        string63 = bl11 ? "to_timestamp_tz('" + string65 + "','" + FORMAT_TIMESTAMP_TZ + "') " + string6 + " to_timestamp_tz('" + string60 + "','" + FORMAT_TIMESTAMP_TZ + "')" : "to_timestamp('" + string65 + "','" + FORMAT_TIMESTAMP + "') " + string6 + " to_timestamp('" + string60 + "','" + FORMAT_TIMESTAMP + "')";
                    }
                } else {
                    this.log("CASE: get the literal (full rdfterm) constant");
                    String string66 = "\"" + string60 + "\"";
                    if (string61 != null && string61.length() > 0) {
                        string66 = string66 + "^^<" + string61 + ">";
                    }
                    string63 = SDO_RDF_VNAME_BEG + string + ")" + BASE_PREFIX_COLNAME_SEP + string6 + BASE_PREFIX_COLNAME_SEP + SDO_RDF_VNAME_BEG + "sdo_rdf.get_canon_val('" + string66 + "')" + ")";
                }
                string4 = string4 + COND_CONNECTOR + string63;
                this.log("genFilterCond: " + string4);
                return string4;
            }
            this.log("CASE: different type families: litTypeFam=" + string62 + " objTypeFam=" + string51 + " compOp=" + string5);
            if (string62.equals(TYPE_FAM_OTHER) || string51.equals(TYPE_FAM_OTHER)) {
                string4 = relExpr.compOperator.equals("DIFFTERM") ? string4 + COND_TRUE : string4 + " AND 1=0 ";
                this.log("at least one of the types is unknown (OTHER): " + string4);
            } else if (string5.equals("!=") || string5.equals("DIFFTERM")) {
                this.log("CASE: !=, 1=1");
                string4 = string4 + COND_TRUE;
            } else {
                string4 = string4 + " AND 1=0 ";
                this.log("genFilterCond: " + string4);
            }
        } else {
            this.log("skipping FILTER opt for this relExpr b/c it is NOT of the form: v <compOp> <numeric/plain/typed literal>, or vice-versa");
            return string4;
        }
        return string4;
    }

    private Integer getComponentInfo_from_RRrow(String string, RRTabRowInfo rRTabRowInfo, String[] stringArray) {
        String string2 = "";
        int n = 0;
        String string3 = null;
        String string4 = null;
        if (string.equals("subject") && rRTabRowInfo.sExpr != null) {
            string2 = rRTabRowInfo.sExpr;
            n = rRTabRowInfo.sExprType;
            string3 = rRTabRowInfo.sTermType;
        } else if (string.equals("predicate") && rRTabRowInfo.pExpr != null) {
            string2 = rRTabRowInfo.pExpr;
            n = rRTabRowInfo.pExprType;
            string3 = rrIRI;
        } else if (string.equals("object") && rRTabRowInfo.oExpr != null) {
            string2 = rRTabRowInfo.oExpr;
            n = rRTabRowInfo.oExprType;
            string3 = rRTabRowInfo.oTermType;
            if (string3 == null) {
                string3 = rrIRI;
            }
            string4 = rRTabRowInfo.oDataType;
        } else if (string.equals("object") && rRTabRowInfo.psExpr != null) {
            string2 = rRTabRowInfo.psExpr;
            n = rRTabRowInfo.psExprType;
            string3 = rRTabRowInfo.psTermType;
        } else if (string.equals("graph") && rRTabRowInfo.pogExpr != null) {
            string2 = rRTabRowInfo.pogExpr;
            n = rRTabRowInfo.pogExprType;
            string3 = rrIRI;
        }
        stringArray[0] = string2;
        stringArray[1] = string3;
        if (string3.equals(rrLiteral) && string4 == null) {
            string4 = XSD_STRING_NO_ENCLOSING;
        }
        stringArray[2] = string4;
        return n;
    }

    private String isVarOccMatchable_in_UArow(String string, String string2, int n, int n2, String string3, String string4, String string5) throws RDFException, SQLException {
        boolean bl = true;
        this.log("entered: isVarOccMatchable_in_UArow: var=" + string + " pos_in_tp=" + string2 + " currRRrowid=" + string3 + " fullOccInfo=" + string4 + " UA rowNum=" + n2 + " po_idx=" + n + " RRrL=" + string5);
        String[] stringArray = string5.substring(1, string5.length()).split(":");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        this.log(((Object)arrayList).toString());
        RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(string3);
        String[] stringArray2 = new String[3];
        Integer n3 = this.getComponentInfo_from_RRrow(string2, rRTabRowInfo, stringArray2);
        String string6 = stringArray2[0];
        String string7 = stringArray2[1];
        String string8 = stringArray2[2];
        String string9 = null;
        if (string8 != null) {
            string9 = this.TYPE_FAMILY(string8.substring(1, string8.length() - 1));
        }
        String string10 = null;
        String string11 = null;
        if (n3 == RRTabRowInfo.MapExprType_COLUMN) {
            string10 = RelationalBGP.get_base_prefix_from_RR_table(string6);
            string11 = RelationalBGP.get_col_name_from_RR_table(string6);
            if (string10 == null) {
                this.log("... MATCHABLE (b/c it is column-valued mapping and no base prefix): returned: EMPTY-STRING");
                return "";
            }
        } else {
            string11 = string6;
        }
        this.log("\ncurrExprType: " + n3);
        this.log("\ncurrTemplate: " + string6);
        this.log("\ncurrTermType: " + string7);
        this.log("\ncurrDatatype: " + string8 + " [" + string9 + "]");
        int n4 = string4.length() - string4.replace("+", "").length();
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6 = n5;
            int n7 = string4.indexOf(58, n6);
            n5 = (string4 + "+").indexOf(43, n7);
            String string12 = string4.substring(n6 + 1, n7);
            int n8 = Integer.parseInt(string4.substring(n7 + 1, n5));
            this.log("occ_pos_in_tp=" + string12 + " occ_po_idx=" + n8);
            if (n < n8 || n == n8 && (string2.equals(string12) || string2.equals("graph") && (string12.equals("predicate") || string12.equals("object")) || string2.equals("predicate") && string12.equals("object"))) {
                this.log("skip checking with itself or with yet-to-be-processed occ: +" + string12 + ":" + n8);
                continue;
            }
            String string13 = (String)arrayList.get(n8);
            this.log("compare currRRrowid=" + string3 + " with occRRrowid=" + string13);
            RRTabRowInfo rRTabRowInfo2 = this.RRrowInfo_for_MatchingRow.get(string13);
            String[] stringArray3 = new String[3];
            Integer n9 = this.getComponentInfo_from_RRrow(string12, rRTabRowInfo2, stringArray3);
            String string14 = stringArray3[0];
            String string15 = stringArray3[1];
            String string16 = stringArray3[2];
            this.log("\noccExprType: " + n9);
            this.log("\noccTemplate: " + string14);
            this.log("\noccTermType: " + string15);
            this.log("\noccDatatype: " + string16);
            String string17 = null;
            String string18 = null;
            if (n9 == RRTabRowInfo.MapExprType_COLUMN) {
                string17 = RelationalBGP.get_base_prefix_from_RR_table(string14);
                string18 = RelationalBGP.get_col_name_from_RR_table(string14);
                if (string17 == null) {
                    this.log("... MATCHABLE (b/c it is column-valued mapping): continue");
                    continue;
                }
            } else {
                string18 = string14;
            }
            if (!string15.equals(string7)) {
                bl = false;
            } else if (string7.equals(rrLiteral) && !string8.equals(string16)) {
                String string19 = this.TYPE_FAMILY(string16.substring(1, string16.length() - 1));
                if (!string19.equals(string9) || string19.equals(TYPE_FAM_OTHER)) {
                    bl = false;
                }
            } else if (string10 == null && string17 == null && !RelationalBGP.matchableSqlTemplatePair(string6, string14, this.ctx)) {
                bl = false;
            }
            if (!bl) break;
        }
        this.log("isVarOccMatchable_in_UArow: ... DONE");
        if (!bl) {
            this.log("... NOT-MATCHABLE: returned:  AND 1=0 ");
            return " AND 1=0 ";
        }
        this.log("... MATCHABLE: returned: EMPTY-STRING");
        return "";
    }

    private String multiOccurrenceOfVar(String string, String string2, int n, int n2, String string3, HashMap<String, String> hashMap, List<List<String>> list, List<List<String>> list2, String string4, List<String> list3, NatVarOpt_Info natVarOpt_Info, List<String> list4, String string5) throws RDFException, SQLException {
        this.log("multiOcc: starting ... UnionArray rowNum=" + n2);
        String string6 = "";
        String string7 = hashMap.get(string);
        String string8 = string2 + ":" + n;
        String string9 = string7.substring(0, string7.indexOf(58));
        int n3 = Integer.parseInt(string7.substring(string7.indexOf(58) + 1, string7.length()));
        String string10 = null;
        if (!string8.equals(string7)) {
            this.log("multi-occurrence of var (now in " + string2 + ":" + n + " pos): " + string + " : FirstOccPos=" + string7);
            string10 = this.getExprFromArrays(string7, n2, string4, list, list2, list3, null);
            if (!string10.equals(string3)) {
                CharSequence charSequence;
                String string11 = null;
                Integer n4 = new Integer(n2);
                HashSet<String> hashSet = natVarOpt_Info.get_occInfoSet_inUArow(string, n4);
                this.log("-> origExpr=" + string10 + " : currExpr= NOT-IDENTICAL\noccInfoSet : " + hashSet);
                String string12 = list4.get(n2);
                ArrayList<String> arrayList = new ArrayList<String>();
                String string13 = "";
                int n5 = -1;
                boolean bl = true;
                boolean bl2 = true;
                while (bl) {
                    bl = false;
                    n5 = string12.indexOf(58);
                    if (n5 >= 0) {
                        string13 = string12.substring(0, n5);
                        string12 = string12.substring(n5 + 1, string12.length());
                        if (!bl2) {
                            arrayList.add(string13);
                        }
                        bl = true;
                    }
                    bl2 = false;
                }
                if (string12.length() > 0) {
                    arrayList.add(string12);
                }
                RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(arrayList.get(n3));
                RRTabRowInfo rRTabRowInfo2 = this.RRrowInfo_for_MatchingRow.get(arrayList.get(n));
                String string14 = "";
                Integer n6 = null;
                if (string9.equals("subject") && rRTabRowInfo.sExpr != null) {
                    string14 = rRTabRowInfo.sExpr;
                    n6 = rRTabRowInfo.sExprType;
                } else if (string9.equals("predicate") && rRTabRowInfo.pExpr != null) {
                    string14 = rRTabRowInfo.pExpr;
                    n6 = rRTabRowInfo.pExprType;
                } else if (string9.equals("object") && rRTabRowInfo.oExpr != null) {
                    string14 = rRTabRowInfo.oExpr;
                    n6 = rRTabRowInfo.oExprType;
                } else if (string9.equals("object") && rRTabRowInfo.psExpr != null) {
                    string14 = rRTabRowInfo.psExpr;
                    n6 = rRTabRowInfo.psExprType;
                } else if (string9.equals("graph") && rRTabRowInfo.pogExpr != null) {
                    string14 = rRTabRowInfo.pogExpr;
                    n6 = rRTabRowInfo.pogExprType;
                }
                String string15 = "";
                Integer n7 = null;
                if (string2.equals("subject") && rRTabRowInfo2.sExpr != null) {
                    string15 = rRTabRowInfo2.sExpr;
                    n7 = rRTabRowInfo2.sExprType;
                } else if (string2.equals("predicate") && rRTabRowInfo2.pExpr != null) {
                    string15 = rRTabRowInfo2.pExpr;
                    n7 = rRTabRowInfo2.pExprType;
                } else if (string2.equals("object") && rRTabRowInfo2.oExpr != null) {
                    string15 = rRTabRowInfo2.oExpr;
                    n7 = rRTabRowInfo2.oExprType;
                } else if (string2.equals("object") && rRTabRowInfo2.psExpr != null) {
                    string15 = rRTabRowInfo2.psExpr;
                    n7 = rRTabRowInfo2.psExprType;
                } else if (string2.equals("graph") && rRTabRowInfo2.pogExpr != null) {
                    string15 = rRTabRowInfo2.pogExpr;
                    n7 = rRTabRowInfo2.pogExprType;
                }
                if (hashSet != null && hashSet.size() != 1) {
                    StringBuffer stringBuffer = new StringBuffer("");
                    charSequence = new StringBuffer("");
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    ArrayList<String> arrayList4 = new ArrayList<String>();
                    ArrayList<String> arrayList5 = new ArrayList<String>();
                    string14 = string14.substring(1, string14.length() - 1);
                    string15 = string15.substring(1, string15.length() - 1);
                    String string16 = RelationalBGP.sqlTempl2sqlExpr(string14, rrIRI, string5 + ".", stringBuffer, arrayList2, arrayList3, null, null, this.ctx);
                    string16 = RelationalBGP.sqlTempl2sqlExpr(string15, rrIRI, string5 + ".", charSequence, arrayList4, arrayList5, null, null, this.ctx);
                    string11 = "";
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        string11 = string11 + COND_CONNECTOR + string5 + "." + (String)arrayList2.get(i) + " = " + string5 + "." + (String)arrayList4.get(i);
                    }
                    this.log("OPTNATVARCOND=" + string11);
                }
                int n8 = 2;
                string6 = n7 == n8 && n7 == n8 ? " AND 1=0 " : (string11 == null ? COND_CONNECTOR + string10 + "=" + string3 : string11);
                charSequence = COND_CONNECTOR + string10 + "=" + string3;
                this.log("-> origExpr=" + string10 + " : currExpr=" + string3);
                this.log("-> condExpr_delta=" + (String)charSequence + " : optimizedCondExpr_delta=" + string6);
            } else {
                this.log("-> origExpr=" + string10 + " : currExpr= IDENTICAL");
            }
        }
        this.log("multiOcc: ... DONE");
        return string6;
    }

    private void store_noVa_related_Info(int n, String string, List<String> list, List<String> list2, String string2, String string3, String string4, String string5, int n2, int n3, int n4, NatVarOpt_Info natVarOpt_Info, UArowNatSelectInfo uArowNatSelectInfo) throws RDFException {
        this.log(" STARTING store_noVa_related_Info for TFTidx: " + n + " var: " + string2 + " TMap: " + string + " CSRAlias: " + string4);
        this.log("                                      UAstartPos: " + n2 + " writePos: " + n3 + " rowBlock_size: " + n4);
        String string6 = this.TFTglobalList.get(n).substring(0, 2);
        Integer n5 = new Integer(-1);
        if (string6.substring(1, 2).equals("1")) {
            n5 = RRTabRowInfo.MapExprType_TEMPLATE;
        } else if (string6.substring(1, 2).equals("2")) {
            n5 = RRTabRowInfo.MapExprType_CONSTANT;
        } else if (string6.substring(1, 2).equals("3")) {
            n5 = RRTabRowInfo.MapExprType_COLUMN;
        } else if (string6.substring(1, 2).equals("0")) {
            n5 = 0;
        } else {
            this.log("ERROR: ExprType is NOT correct. TERMTYPE_EXPRTYPE=" + string6);
        }
        if (n5.intValue() != RRTabRowInfo.MapExprType_CONSTANT.intValue() && n5 != 0) {
            natVarOpt_Info.set(string2, n, string3, string4, list.size());
        } else {
            natVarOpt_Info.set(string2, n, string3, string4, 0);
        }
        this.log("var=" + string2 + ": GOING to adding occInfo: occInfo=" + string3 + " rowBlock_size=" + n4);
        for (int i = 0; i < n4; ++i) {
            this.log("var=" + string2 + ": adding occInfo: occInfo=" + string3);
            natVarOpt_Info.set(string2, new Integer(n2 + n3 + i), n, string3);
        }
        if (n5.intValue() != RRTabRowInfo.MapExprType_CONSTANT.intValue() && n5 != 0) {
            String string7 = string4;
            if (string5 != null) {
                string7 = string5;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                String string8 = list.get(i);
                String string9 = string7 + "." + string8;
                String string10 = this.TFTinfoGlobalList.get((int)n).colTypeList.get(i);
                this.log("colName: " + string8);
                this.log("colType: " + string10);
                if ("SDO_GEOMETRY".equals(string10)) {
                    String string11 = string + "+" + string8.replaceAll("\"", "");
                    this.log("[store_noVa_related_Info]  SDO_GEOMETRY retrieving metadata for var " + string2 + " associated to the column name " + string8 + " from LtcRowInfo_for_Tmap_plus_Col with key " + string11);
                    LtcTabRowInfo ltcTabRowInfo = this.LtcRowInfo_for_Tmap_plus_Col.get(string11);
                    this.log("[store_noVa_related_Info]  LtcRowInfo.toString(): " + ltcTabRowInfo.toString());
                    this.log("[store_noVa_related_Info]  LtcRowInfo.getDimArrayConstructor(): " + ltcTabRowInfo.getDimArrayConstructor());
                    this.log("[store_noVa_related_Info] Starting multi-SRID handling for var " + string2 + " mapped to colName " + string8 + " at the column expression level");
                    Long l = null;
                    if (ltcTabRowInfo.getSRID() == null) {
                        l = DEFAULT_GEOMETRY_SRID;
                        this.log("[store_noVa_related_Info]   Using the SRID by default " + DEFAULT_GEOMETRY_SRID);
                    } else {
                        l = Long.valueOf(ltcTabRowInfo.getSRID());
                    }
                    this.log("[store_noVa_related_Info] [SRID] SDO_GEOMETRY SRID: " + l + " for column " + string8);
                    Set<Object> set = null;
                    if (!this.Geometry_VarSRID.containsKey(string2)) {
                        set = new LinkedHashSet();
                        this.Geometry_VarSRID.put(string2, set);
                    } else {
                        set = this.Geometry_VarSRID.get(string2);
                    }
                    if (!set.contains(l)) {
                        this.log("[store_noVa_related_Info] [SRID] adding to Geometry_VarSRID: obje var=" + string2 + " col_srid=" + l);
                        this.log("[store_noVa_related_Info] [SRID] BEFORE count SRIDs: " + set.size());
                        this.log("[store_noVa_related_Info] [SRID] BEFORE SRIDs: " + set);
                        set.add(l);
                        this.log("[store_noVa_related_Info] [SRID] AFTER count SRIDs: " + set.size());
                        this.log("[store_noVa_related_Info] [SRID] AFTER SRIDs: " + set);
                        this.log("[store_noVa_related_Info] [SRID] Geometry_VarSRID: " + this.Geometry_VarSRID);
                        this.log("[store_noVa_related_Info] [SRID] NOTE: we may have to UNDO this addition to Geometry_VarSRID later if filter validation requires this type to be non-geometry");
                    }
                    this.log("[store_noVa_related_Info] Finishing multi-SRID handling for var " + string2 + " mapped to colName " + string8 + " at store_noVa_related_Info method");
                    String string12 = ltcTabRowInfo.getDimArrayConstructor(DEFAULT_GEOMETRY_DIMENSION);
                    this.log("[store_noVa_related_Info] retrieved geoDimesion for current mapping (MUST be single column for geometry vars): " + string12);
                    this.Geometry_VarDimension.put(string4 + "." + string2, string12);
                }
                arrayList.add(string9);
            }
            uArowNatSelectInfo.add_ColList_for_var(string2, arrayList);
            this.log("[store_noVa_related_Info] var=" + string2 + ": added to UArowNatSelectInfo_tmp: colList_tmp=" + arrayList);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            uArowNatSelectInfo.add_ColList_for_var(string2, arrayList);
            this.log("[store_noVa_related_Info] var=" + string2 + ": added to UArowNatSelectInfo_tmp: dummy_colList=" + arrayList);
        }
        this.log("[store_noVa_related_Info] EXIT");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void populateUnionArrays(MCSR mCSR, CSRinfo cSRinfo, String string, int n, int n2, RRTabRowInfo rRTabRowInfo, int n3, boolean bl, boolean bl2, String string2, boolean bl3, boolean bl4, int n4, NatVarOpt_Info natVarOpt_Info, int n5, UArowNatSelectInfo uArowNatSelectInfo) throws RDFException, SQLException {
        void var68_88;
        String string3;
        Object object;
        Map<Object, Object> map;
        String string4;
        String string5;
        String string6;
        Object object2;
        Object object3;
        CharSequence charSequence;
        CharSequence charSequence2;
        Object object4;
        Object object5;
        String string7;
        String string8;
        Object object6;
        UArowNatSelectInfo uArowNatSelectInfo2;
        String string9;
        String string10;
        String string11;
        String string12;
        String string13;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        boolean bl9;
        List<String> list;
        List<String> list2;
        List<String> list3;
        boolean bl10;
        String string14;
        String string15;
        Map<String, List<Set<String>>> map2;
        List<UArowNatSelectInfo> list4;
        String string16;
        List<Map<String, String>> list5;
        List<Set<String>> list6;
        List<String> list7;
        String string17;
        String string18;
        List<String> list8;
        List<String> list9;
        List<String> list10;
        List<String> list11;
        block262: {
            HashSet<String> hashSet;
            block246: {
                block265: {
                    block264: {
                        Object object7;
                        Object object8;
                        block263: {
                            String string19;
                            String string20;
                            block252: {
                                block258: {
                                    block260: {
                                        Object object9;
                                        Object object10;
                                        block261: {
                                            String string21;
                                            block259: {
                                                block256: {
                                                    int n6;
                                                    Object object11;
                                                    block257: {
                                                        block250: {
                                                            block243: {
                                                                String string22;
                                                                block254: {
                                                                    String string23;
                                                                    block255: {
                                                                        block253: {
                                                                            block251: {
                                                                                block247: {
                                                                                    block249: {
                                                                                        ArrayList<String> arrayList;
                                                                                        ArrayList<String> arrayList2;
                                                                                        block248: {
                                                                                            list11 = cSRinfo.RRrLArray;
                                                                                            list10 = cSRinfo.fromArray;
                                                                                            list9 = cSRinfo.condArray;
                                                                                            list8 = cSRinfo.sAliasArray;
                                                                                            String string24 = cSRinfo.get_iUriExpr(string);
                                                                                            string18 = (String)cSRinfo.CSR_predList.get(n);
                                                                                            string17 = (String)cSRinfo.CSR_objeList.get(n);
                                                                                            list7 = cSRinfo.gExprArray;
                                                                                            list6 = cSRinfo.GeesArray;
                                                                                            list5 = cSRinfo.TpGEArray;
                                                                                            string16 = LALIASKEY;
                                                                                            Map<String, String> map3 = cSRinfo.get_FirstOccPos_for_tuple();
                                                                                            list4 = cSRinfo.UArowNatSelectInfoArray;
                                                                                            map2 = cSRinfo.native_oExprSetArray_for_Var;
                                                                                            int n7 = n + cSRinfo.po_idx_base;
                                                                                            string15 = "P" + n7;
                                                                                            string14 = "%PALIASKEY%" + n7;
                                                                                            bl10 = true;
                                                                                            list3 = cSRinfo.pExprArrays.get(n);
                                                                                            list2 = cSRinfo.oExprArrays.get(n);
                                                                                            list = cSRinfo.clobExprArrays.get(n);
                                                                                            this.log("entered populateUnionArrays: --------------------------------------------------------------------------");
                                                                                            this.log("pUA: ENTERING: po_idx=" + n + " writePos=" + n2 + " rowBlock_size=" + n3 + " alias=" + string16 + " UAstartPos=" + n5);
                                                                                            if (bl10) {
                                                                                                this.log("pUA: initially : pExprArray.size()=" + list3.size());
                                                                                            }
                                                                                            this.log("pUA: initially : oExprArray.size()=" + list2.size());
                                                                                            this.log("pUA: initially : clobExprArray.size()=" + list.size());
                                                                                            if (this.graph_use_mode > 0) {
                                                                                                if (this.is_bgp_graph_a_var) {
                                                                                                    this.log("pUA: initially : gExprArray.size()=" + list7.size());
                                                                                                }
                                                                                                this.log("pUA: initially : GeesArray.size()=" + list6.size());
                                                                                                this.log("pUA: initially : TpGEArray.size()=" + list5.size());
                                                                                            }
                                                                                            this.log("pUA: initially : fromArray.size()=" + list10.size());
                                                                                            this.log("pUA: initially : condArray.size()=" + list9.size());
                                                                                            this.log("pUA: initially : sAliasArray.size()=" + list8.size());
                                                                                            this.log("pUA: initially : native_oExprSetArray_for_Var.size()=" + map2.size() + " : " + map2);
                                                                                            this.log("pUA: upon entering: UArowNatSelectInfo_for_Copy: " + uArowNatSelectInfo);
                                                                                            bl9 = false;
                                                                                            bl8 = false;
                                                                                            bl7 = false;
                                                                                            bl6 = false;
                                                                                            bl5 = false;
                                                                                            string13 = null;
                                                                                            string12 = null;
                                                                                            string11 = "NULL";
                                                                                            string10 = null;
                                                                                            string9 = "";
                                                                                            string20 = null;
                                                                                            this.log("===> writePos=" + n2);
                                                                                            this.log("===> UArowNatSelectInfoArray.size()=" + list4.size());
                                                                                            if (n5 + n2 < list4.size()) {
                                                                                                uArowNatSelectInfo2 = new UArowNatSelectInfo();
                                                                                                this.log("There is already the UArowNatSelectInfo object");
                                                                                            } else {
                                                                                                uArowNatSelectInfo2 = new UArowNatSelectInfo(uArowNatSelectInfo);
                                                                                                this.log("There is already the UArowNatSelectInfo object");
                                                                                            }
                                                                                            this.log("UArowNatSelectInfo_for_Copy=" + uArowNatSelectInfo);
                                                                                            this.log("UArowNatSelectInfo_tmp=" + uArowNatSelectInfo2);
                                                                                            StringBuffer stringBuffer = new StringBuffer("");
                                                                                            HashSet<String> hashSet2 = new HashSet<String>();
                                                                                            Object var53_52 = null;
                                                                                            arrayList2 = new ArrayList<String>();
                                                                                            arrayList = new ArrayList<String>();
                                                                                            if (!bl10) break block247;
                                                                                            object6 = "";
                                                                                            object11 = null;
                                                                                            if (rRTabRowInfo.pExprType != RRTabRowInfo.MapExprType_TEMPLATE) break block248;
                                                                                            string19 = rrIRI;
                                                                                            string13 = RelationalBGP.sqlTempl2sqlExpr(rRTabRowInfo.pExpr.substring(1, rRTabRowInfo.pExpr.length() - 1), string19, "%LALIASKEY%.", stringBuffer, arrayList2, arrayList, rRTabRowInfo.pColTypeList, hashSet2, this.ctx);
                                                                                            string13 = "'<'||" + string13 + "||'>'";
                                                                                            this.log("pExpr=" + string13 + " pNotNullColCondExpr=" + stringBuffer + " pNotNullCond_colSet: " + hashSet2);
                                                                                            if (stringBuffer.length() > 0) {
                                                                                                string9 = string9 + stringBuffer.toString();
                                                                                                this.log("[pExpr: added notNullColCondExpr] condExpr: " + string9);
                                                                                            }
                                                                                            if (!bl) {
                                                                                                this.store_noVa_related_Info(rRTabRowInfo.pTFT_idx, rRTabRowInfo.Tmap, arrayList2, arrayList, string18, "predicate:" + n, cSRinfo.getCSRAlias(), null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                                                            }
                                                                                            if (bl) {
                                                                                                object6 = "'" + string18.replace("'", "''") + "'=" + string13;
                                                                                                object11 = this.find_optimized_CondExpr(string18, arrayList2, arrayList, string16, rRTabRowInfo.Tmap, null);
                                                                                                this.log("[pred in triple-pattern is constant] pCondExpr: " + (String)object6 + " optimized_pCondExpr: " + (String)object11);
                                                                                                if (object11 != null) {
                                                                                                    object6 = object11;
                                                                                                }
                                                                                            }
                                                                                            break block249;
                                                                                        }
                                                                                        if (rRTabRowInfo.pExprType == RRTabRowInfo.MapExprType_CONSTANT) {
                                                                                            string13 = "'" + rRTabRowInfo.pExpr + "'";
                                                                                            this.log("[PredicateMap is constant] pExpr: " + string13 + " is matchable with pred in triple-pattern: pred=" + string18);
                                                                                            if (!bl) {
                                                                                                this.store_noVa_related_Info(rRTabRowInfo.pTFT_idx, rRTabRowInfo.Tmap, null, null, string18, "predicate:" + n, cSRinfo.getCSRAlias(), null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                                                            }
                                                                                        } else if (rRTabRowInfo.pExprType == RRTabRowInfo.MapExprType_COLUMN) {
                                                                                            string19 = TTL_ESCAPE_BEG;
                                                                                            string8 = ")";
                                                                                            if ((this.ctx.R2RFlags & 0x200L) > 0L) {
                                                                                                string19 = "";
                                                                                                string8 = "";
                                                                                            } else if ((this.ctx.R2RFlags & 0x20000L) > 0L) {
                                                                                                string8 = ", options=>' ESC_SBYTE_OPT=F ')";
                                                                                                if (this.ctx.noTC) {
                                                                                                    string8 = string8.substring(0, string8.length() - 2) + " NO_TC=T')";
                                                                                                }
                                                                                            }
                                                                                            object10 = RelationalBGP.get_base_prefix_from_RR_table(rRTabRowInfo.pExpr);
                                                                                            if (object10 != null) {
                                                                                                object9 = RelationalBGP.get_col_name_from_RR_table(rRTabRowInfo.pExpr);
                                                                                                string7 = string16 + "." + (String)object9;
                                                                                                string13 = "sdo_rdf.criri('" + (String)object10 + "'," + string19 + string7 + string8 + this.criri_network_storage_form_arg + ")";
                                                                                                arrayList2.add((String)object9);
                                                                                                arrayList.add((String)object10);
                                                                                            } else {
                                                                                                string7 = string16 + "." + rRTabRowInfo.pExpr;
                                                                                                string13 = "sdo_rdf.criri(NULL," + string19 + string7 + string8 + this.criri_network_storage_form_arg + ")";
                                                                                                arrayList2.add(rRTabRowInfo.pExpr);
                                                                                                arrayList.add("");
                                                                                            }
                                                                                            if (!bl) {
                                                                                                this.store_noVa_related_Info(rRTabRowInfo.pTFT_idx, rRTabRowInfo.Tmap, arrayList2, arrayList, string18, "predicate:" + n, cSRinfo.getCSRAlias(), null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                                                            }
                                                                                            if (bl) {
                                                                                                object6 = "'" + string18.replace("'", "''") + "'=" + string19 + string13 + string8;
                                                                                                this.log("col-valued PredicateMap: ADD condition: " + (String)object6);
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    if (((String)object6).length() > 0) {
                                                                                        this.log("[pExpr: before adding notNullColCondExpr] condExpr: " + string9);
                                                                                        string9 = string9.length() == 0 ? COND_CONNECTOR + (String)object6 : string9 + COND_CONNECTOR + (String)object6;
                                                                                        this.log("[pExpr: after adding notNullColCondExpr] condExpr: " + string9);
                                                                                    }
                                                                                }
                                                                                object6 = new StringBuffer("");
                                                                                object11 = new HashSet<String>();
                                                                                string19 = null;
                                                                                string8 = null;
                                                                                string7 = null;
                                                                                object10 = new ArrayList();
                                                                                object9 = new ArrayList();
                                                                                if (rRTabRowInfo.oExpr == null) break block250;
                                                                                if (rRTabRowInfo.oExprType != RRTabRowInfo.MapExprType_TEMPLATE) break block251;
                                                                                String string25 = null;
                                                                                this.log("RRrowInfo.oTermType=" + rRTabRowInfo.oTermType + "[oExpr=" + rRTabRowInfo.oExpr + "]");
                                                                                object8 = rRTabRowInfo.oTermType == null ? rrIRI : rRTabRowInfo.oTermType;
                                                                                this.log("ottyp=" + (String)object8 + " : rrIRI=" + rrIRI);
                                                                                string12 = RelationalBGP.sqlTempl2sqlExpr(rRTabRowInfo.oExpr.substring(1, rRTabRowInfo.oExpr.length() - 1), (String)object8, "%LALIASKEY%.", (StringBuffer)object6, (List<String>)object10, (List<String>)object9, rRTabRowInfo.oColTypeList, object11, this.ctx);
                                                                                if (((String)object8).equals(rrIRI)) {
                                                                                    string25 = "U";
                                                                                    this.log("=IRI");
                                                                                    string12 = "'<'||" + string12 + "||'>'";
                                                                                } else if (((String)object8).equals(rrBlankNode)) {
                                                                                    string25 = "B";
                                                                                    this.log("=BLANK_NODE");
                                                                                    string12 = "'_:' || sdo_rdf.cbnod(" + string12 + ")";
                                                                                } else {
                                                                                    if (!((String)object8).equals(rrLiteral)) {
                                                                                        this.log("=ERROR");
                                                                                        this.log("pUA: EXCEPTION: Unknown termType for template-valued Omap: oTermType=" + rRTabRowInfo.oTermType + " rowid=" + rRTabRowInfo.rowid);
                                                                                        throw new RDFException("Unknown termType for template-valued Omap: oTermType=" + rRTabRowInfo.oTermType + " RR_TAB rowid=" + rRTabRowInfo.rowid);
                                                                                    }
                                                                                    this.log("=LITERAL");
                                                                                    string25 = "L";
                                                                                    string12 = "'\"' || " + string12 + " || '\"'";
                                                                                    if (rRTabRowInfo.oLanguage != null) {
                                                                                        this.log("processing language-tagged literal: " + rRTabRowInfo.oLanguage);
                                                                                        string12 = string12 + " || '@" + rRTabRowInfo.oLanguage.substring(1, rRTabRowInfo.oLanguage.length() - 1).toLowerCase() + "'";
                                                                                        this.log("canonicalized (using langTag.toLowerCase()) oExpr for PL@ lexval: " + string12);
                                                                                    } else if (rRTabRowInfo.oDataType != null && !rRTabRowInfo.oDataType.equals(XSD_STRING)) {
                                                                                        this.log("processing typed-literal: " + rRTabRowInfo.oDataType);
                                                                                        string12 = string12 + " || '^^" + rRTabRowInfo.oDataType + "'";
                                                                                        string12 = "sdo_rdf.get_canon_val(" + string12 + ")";
                                                                                        this.log("canonicalization-aware oExpr for typed-literal lexval: " + string12);
                                                                                    } else {
                                                                                        this.log("[no-canonicalization] oExpr for PL-or-string lexval: " + string12);
                                                                                    }
                                                                                }
                                                                                if (!bl2) {
                                                                                    this.store_noVa_related_Info(rRTabRowInfo.oTFT_idx, rRTabRowInfo.Tmap, (List<String>)object10, (List<String>)object9, string17, "object:" + n, cSRinfo.getCSRAlias(), null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                                                }
                                                                                break block252;
                                                                            }
                                                                            if (rRTabRowInfo.oExprType != RRTabRowInfo.MapExprType_CONSTANT) break block253;
                                                                            string12 = "'" + rRTabRowInfo.oExpr + "'";
                                                                            if (!bl2) {
                                                                                this.store_noVa_related_Info(rRTabRowInfo.oTFT_idx, rRTabRowInfo.Tmap, null, null, string17, "object:" + n, cSRinfo.getCSRAlias(), null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                                            }
                                                                            break block252;
                                                                        }
                                                                        if (rRTabRowInfo.oExprType != RRTabRowInfo.MapExprType_COLUMN) {
                                                                            this.log("pUA: EXCEPTION: unknown oExprType=" + rRTabRowInfo.oExprType);
                                                                            throw new RDFException("unknown oExprType=" + rRTabRowInfo.oExprType + " RR_TAB rowid=" + rRTabRowInfo.rowid);
                                                                        }
                                                                        string22 = "%LALIASKEY%." + rRTabRowInfo.oExpr;
                                                                        object8 = "";
                                                                        object7 = RelationalBGP.get_base_prefix_from_RR_table(rRTabRowInfo.oExpr);
                                                                        object5 = RelationalBGP.get_col_name_from_RR_table(rRTabRowInfo.oExpr);
                                                                        if (object7 != null) {
                                                                            string22 = "%LALIASKEY%." + (String)object5;
                                                                            object10.add(object5);
                                                                            object9.add(object7);
                                                                        } else {
                                                                            object10.add(rRTabRowInfo.oExpr);
                                                                            object9.add("");
                                                                        }
                                                                        if (!bl2) {
                                                                            string7 = string22;
                                                                        }
                                                                        string21 = null;
                                                                        Object var68_75 = null;
                                                                        Object var69_90 = null;
                                                                        Object var70_111 = null;
                                                                        string23 = null;
                                                                        object4 = COND_CONNECTOR + string22 + " is NOT NULL";
                                                                        if (((StringBuffer)object6).toString().indexOf((String)object4) < 0) {
                                                                            ((StringBuffer)object6).append((String)object4);
                                                                        } else {
                                                                            this.log("SKIPPED adding (already-present) additional notNullCol condition: " + (String)object4);
                                                                        }
                                                                        this.log("column-mapping case: oNotNullColCondExpr: " + object6 + " oNotNullCond_colSet: " + object11);
                                                                        if (bl2) {
                                                                            charSequence2 = new StringBuffer("");
                                                                            StringBuffer stringBuffer = new StringBuffer("");
                                                                            charSequence = new StringBuffer("");
                                                                            object3 = new StringBuffer("");
                                                                            this.findComponents_of_RDFterm(string17, (StringBuffer)charSequence2, stringBuffer, (StringBuffer)charSequence, (StringBuffer)object3);
                                                                            string21 = ((StringBuffer)charSequence2).toString();
                                                                            String string26 = stringBuffer.toString();
                                                                            String string27 = ((StringBuffer)charSequence).toString();
                                                                            String string28 = ((StringBuffer)object3).toString();
                                                                            string23 = this.TYPE_FAMILY(string27);
                                                                            this.log("obje: vn=" + string21 + " vt=" + string26 + " lt=" + string27 + " la=" + string28 + " tyfam=" + string23);
                                                                        }
                                                                        charSequence2 = null;
                                                                        if (rRTabRowInfo.oTermType != null && !rRTabRowInfo.oTermType.equals(rrLiteral)) break block254;
                                                                        charSequence2 = "L";
                                                                        String string29 = ((String)object5).replaceAll("\"", "");
                                                                        charSequence = rRTabRowInfo.Tmap + "+" + string29;
                                                                        object3 = this.LtcRowInfo_for_Tmap_plus_Col.get(charSequence);
                                                                        object2 = TTL_ESCAPE_BEG;
                                                                        String string30 = ")";
                                                                        string6 = "";
                                                                        string5 = "";
                                                                        if ((this.ctx.R2RFlags & 0x200L) > 0L) {
                                                                            object2 = "";
                                                                            string30 = "";
                                                                        } else if ((this.ctx.R2RFlags & 0x20000L) > 0L) {
                                                                            string30 = ", options=>' ESC_SBYTE_OPT=F ')";
                                                                            if (this.ctx.noTC) {
                                                                                string30 = string30.substring(0, string30.length() - 2) + " NO_TC=T')";
                                                                            }
                                                                        } else if (rRTabRowInfo.RDFdatatype_DBColType.contains("DB_TYPE=STRING_CLOB")) {
                                                                            object2 = TTL_ESCAPE_CLOB_BEG;
                                                                            string30 = ")";
                                                                        }
                                                                        if (rRTabRowInfo.RDFdatatype_DBColType.contains("DB_TYPE=SDO_GEOMETRY")) {
                                                                            if (rRTabRowInfo.sqlQuery == null && ((LtcTabRowInfo)object3).getDimArrayConstructor() == null) {
                                                                                this.fetchGeometryColMetadata((LtcTabRowInfo)object3, rRTabRowInfo.tabOwner, rRTabRowInfo.tabName, (String)object5);
                                                                            }
                                                                            if (rRTabRowInfo.sqlQuery == null) {
                                                                                if (((LtcTabRowInfo)object3).getDimArrayConstructor() == null) {
                                                                                    this.log("fetchGeometryColMetadata failed: tabOwner=" + rRTabRowInfo.tabOwner + " tabName=" + rRTabRowInfo.tabName + " geoColName=" + (String)object5);
                                                                                }
                                                                            } else {
                                                                                this.log("fetchGeometryColMetadata not possible as LTable is a query: sqlQuery=" + rRTabRowInfo.sqlQuery);
                                                                            }
                                                                            if ((object8 = ((LtcTabRowInfo)object3).getSRID()) == null || ((String)object8).equals("")) {
                                                                                int n8 = rRTabRowInfo.RDFdatatype_DBColType.lastIndexOf("(") + 1;
                                                                                int n9 = rRTabRowInfo.RDFdatatype_DBColType.lastIndexOf(")");
                                                                                object8 = rRTabRowInfo.RDFdatatype_DBColType.substring(n8, n9);
                                                                            }
                                                                            if (object8 == null || ((String)object8).equals("")) {
                                                                                object8 = DEFAULT_GEOMETRY_SRID_STR;
                                                                            }
                                                                            string6 = TTL_CONVERT_TO_WKT_BEG;
                                                                            string5 = TTL_CONVERT_TO_WKT_END.replaceFirst("%TABLE_NAME%.%COLUMN_NAME%", string22).replaceFirst("%DBCOLTYPE_SRID%", (String)object8).replaceFirst("%P_NETWORK_OWNER%", this.ctx.clnNetworkOwner).replaceFirst("%P_NETWORK_NAME%", this.ctx.clnNetworkName);
                                                                            object2 = "";
                                                                            string30 = "";
                                                                        }
                                                                        string4 = (String)object2 + string6 + string22 + string5 + string30;
                                                                        string12 = "'\"' || " + string4 + " || '\"'";
                                                                        this.log("rr:Literal case: initial: oExpr=" + string12);
                                                                        if (rRTabRowInfo.oLanguage == null) break block255;
                                                                        String string31 = "@" + rRTabRowInfo.oLanguage.substring(1, rRTabRowInfo.oLanguage.length() - 1);
                                                                        this.log("processing language-tagged literal: " + rRTabRowInfo.oLanguage + " atLanguage: " + string31);
                                                                        if (((LtcTabRowInfo)object3).colTypeName.equals(LTC_TYPE_STRING_CLOB)) {
                                                                            string11 = string4;
                                                                            int n10 = this.use_varchar2_size_limit - (2 + string31.length());
                                                                            string12 = "'\"' || dbms_lob.substr(" + string4 + ", " + n10 + ") || '\"" + string31 + "'";
                                                                            break block243;
                                                                        } else {
                                                                            string12 = string12 + " || '" + string31 + "'";
                                                                        }
                                                                        break block243;
                                                                    }
                                                                    if (rRTabRowInfo.oDataType != null) {
                                                                        String string32;
                                                                        this.log("processing typed-literal: " + rRTabRowInfo.oDataType + " debug: lang=" + rRTabRowInfo.oLanguage);
                                                                        String string33 = this.TYPE_FAMILY(rRTabRowInfo.oDataType.substring(1, rRTabRowInfo.oDataType.length() - 1));
                                                                        this.log("omap_tyfam=" + string33 + " (RRrowInfo.oDataType=" + rRTabRowInfo.oDataType + ")");
                                                                        this.log("RRrowInfo.RDFdatatype_DBColType=" + rRTabRowInfo.RDFdatatype_DBColType);
                                                                        int n11 = rRTabRowInfo.RDFdatatype_DBColType.indexOf(" DB_TYPE=");
                                                                        map = rRTabRowInfo.RDFdatatype_DBColType.substring(0, n11);
                                                                        object = rRTabRowInfo.RDFdatatype_DBColType.substring(n11 + " DB_TYPE=".length());
                                                                        Object object12 = ((String)object).charAt(((String)object).length() - 1) == ')' ? ((String)object).substring(0, ((String)object).indexOf(40)) : object;
                                                                        this.log("RDFdatatype=" + (String)((Object)map) + "*DBColType=" + (String)object + "$ DBColType_name=" + (String)object12);
                                                                        if (bl2 && string33.equals(string23)) {
                                                                            String string34 = null;
                                                                            string32 = "";
                                                                            if (string33.equals("STRING")) {
                                                                                string34 = RelationalBGP.const_for_native_comparison(string21, false, this.ctx.noTC);
                                                                            } else if (string33.equals(TYPE_FAM_NUMERIC)) {
                                                                                string34 = string21;
                                                                            } else if (string33.equals(TYPE_FAM_DATETIME)) {
                                                                                if (((String)object12).equals(LTC_TYPE_TIMESTAMP_TZ)) {
                                                                                    string34 = "to_TIMESTAMP_TZ('" + string21 + "','" + FORMAT_TIMESTAMP_TZ + "')";
                                                                                } else if (((String)object12).equals(LTC_TYPE_TIMESTAMP)) {
                                                                                    string34 = "to_TIMESTAMP('" + string21 + "','" + FORMAT_TIMESTAMP + "')";
                                                                                } else if (((String)object12).equals(LTC_TYPE_TIMESTAMP_LTZ)) {
                                                                                    this.log((String)object12 + ": OPTIMIZATION NOT IMPLEMENTED");
                                                                                } else {
                                                                                    this.log((String)object12 + ": UNKNOWN DBColType_name: Skipping optimization");
                                                                                }
                                                                                this.log("rhs_expr : " + string34);
                                                                            } else if (string33.equals("DATE")) {
                                                                                if (((String)object12).equals("DATE")) {
                                                                                    string34 = "to_DATE('" + string21 + "','" + FORMAT_DATE + "')";
                                                                                } else {
                                                                                    this.log((String)object12 + ": UNKNOWN DBColType_name: Skipping optimization");
                                                                                }
                                                                            } else if (string33.equals(TYPE_FAM_FLOAT)) {
                                                                                string34 = "to_BINARY_FLOAT('" + string21 + "')";
                                                                            } else if (string33.equals(TYPE_FAM_DOUBLE)) {
                                                                                string34 = "to_BINARY_DOUBLE('" + string21 + "')";
                                                                            } else if (rRTabRowInfo.RDFdatatype_DBColType.contains("DB_TYPE=SDO_GEOMETRY")) {
                                                                                void var69_92;
                                                                                string34 = "sdo_rdf.getV$GeometryVal('" + string17 + "'," + (String)object8 + ")";
                                                                                String string35 = null;
                                                                                if (!var69_92.equals("http://www.opengis.net/ont/geosparql#wktLiteral")) {
                                                                                    if (!string17.substring(1, 6).equals("<gml:")) {
                                                                                        this.log("srid eq check skipped for obje_ltype=" + (String)var69_92 + " with unrecognized pattern: obje=" + string17);
                                                                                        this.log("obje[1-5]: " + string17.substring(1, 6));
                                                                                    } else {
                                                                                        int n12 = string17.indexOf(" srsName=") + " srsName=".length();
                                                                                        int n13 = string17.indexOf("\"", n12 = string17.indexOf(":", n12) + 1);
                                                                                        if (string17.charAt(n13 - 1) == '\\') {
                                                                                            --n13;
                                                                                        }
                                                                                        this.log("GML literal case: start_pos=" + n12 + " endPlus1_pos=" + n13 + "\nobje: " + string17);
                                                                                        string35 = string17.substring(n12, n13);
                                                                                        this.log("GML literal case: start_pos=" + n12 + " endPlus1_pos=" + n13 + " got constant: " + string35);
                                                                                    }
                                                                                } else if (string17.charAt(1) != '<') {
                                                                                    string35 = DEFAULT_GEOMETRY_SRID_STR;
                                                                                    this.log("srid_from_lit: got default constant: " + string35);
                                                                                } else {
                                                                                    String string36 = string17.substring(2, string17.indexOf(BASE_PREFIX_COLNAME_SEP) - 1);
                                                                                    if (string36.equals("http://www.opengis.net/def/crs/OGC/1.3/CRS84")) {
                                                                                        string35 = DEFAULT_GEOMETRY_SRID_STR;
                                                                                        this.log("srid_from_lit: got constant by explicit check for crs84 (avoids runtime check for this common case): " + string35);
                                                                                    } else if (string36.indexOf("http://xmlns.oracle.com/rdf/geo/srid/") == 0) {
                                                                                        string35 = string36.substring("http://xmlns.oracle.com/rdf/geo/srid/".length(), string36.length());
                                                                                        this.log("srid_from_lit: got constant from orageo: " + string35);
                                                                                    } else {
                                                                                        string35 = "(SELECT SRID FROM MDSYS.RDF_CRS_URI$ WHERE CRS_URI='" + string36 + "')";
                                                                                        this.log("srid_from_lit: will get from table: " + string35);
                                                                                    }
                                                                                }
                                                                                string32 = string35 == null ? "" : (string35.charAt(0) == '(' ? COND_CONNECTOR + (String)object8 + " = " + string35 : (string35.equals(object8) ? COND_TRUE : " AND 1=0 "));
                                                                                this.log("srid_eq_cond: " + string32);
                                                                            } else {
                                                                                this.log(string33 + ": UNKNOWN omap_tyfam: Skipping optimization");
                                                                            }
                                                                            if (string34 != null) {
                                                                                string20 = rRTabRowInfo.RDFdatatype_DBColType.contains("DB_TYPE=SDO_GEOMETRY") ? " AND sdo_equal(" + string22 + "," + string34 + SDO_EQUAL_END + string32 : COND_CONNECTOR + string22 + "=" + string34;
                                                                            }
                                                                        }
                                                                        boolean bl11 = true;
                                                                        if (!(((String)object12).equals("STRING") || ((String)object12).equals(LTC_TYPE_STRING_CLOB) || ((String)object12).equals("SDO_GEOMETRY"))) {
                                                                            string12 = "'\"' || " + string22 + " || '\"'";
                                                                        }
                                                                        if (string20 != null) {
                                                                            this.log("using optimized valuedCond=" + string20);
                                                                        } else if (rRTabRowInfo.oDataType.equals(XSD_DATETIME)) {
                                                                            if (((String)object12).equals(LTC_TYPE_TIMESTAMP_TZ)) {
                                                                                string12 = "'\"' || ltrim(to_char(" + string22 + ",'" + FORMAT_TIMESTAMP_TZ + "')) || '\"'";
                                                                            } else if (((String)object12).equals(LTC_TYPE_TIMESTAMP)) {
                                                                                string12 = "'\"' || ltrim(to_char(" + string22 + ",'" + FORMAT_TIMESTAMP + "')) || '\"'";
                                                                            } else if (((String)object12).equals(LTC_TYPE_TIMESTAMP_LTZ)) {
                                                                                this.log((String)object12 + ": OPTIMIZATION NOT IMPLEMENTED");
                                                                            }
                                                                            string12 = string12 + " || '^^" + rRTabRowInfo.oDataType + "'";
                                                                            string12 = "sdo_rdf.get_canon_val(" + string12 + ")";
                                                                            this.log("oExpr for DateTime : " + string12);
                                                                        } else if (rRTabRowInfo.oDataType.equals(XSD_DATE)) {
                                                                            if (((String)object12).equals("DATE")) {
                                                                                string12 = "'\"' || ltrim(to_char(" + string22 + ",'" + FORMAT_DATE + "')) || '\"'";
                                                                                this.log("[omap_tyfam=" + string33 + " DBColType_name=" + (String)object12 + "] => no need to do canonicalization");
                                                                                bl11 = false;
                                                                            }
                                                                            string12 = string12 + " || '^^" + rRTabRowInfo.oDataType + "'";
                                                                            if (bl11) {
                                                                                string12 = "sdo_rdf.get_canon_val(" + string12 + ")";
                                                                            }
                                                                            this.log("oExpr for Date : " + string12);
                                                                        } else if (!rRTabRowInfo.oDataType.equals(XSD_STRING)) {
                                                                            if ((rRTabRowInfo.oDataType.equals(XSD_FLOAT) || rRTabRowInfo.oDataType.equals(XSD_DOUBLE)) && ((this.ctx.R2RFlags & 0x10L) == 16L || (this.ctx.R2RFlags & 0x20L) == 32L)) {
                                                                                string12 = "'\"' || sdo_rdf.bdouble2LexDouble(" + string22 + ") || '\"'";
                                                                                string12 = string12 + " || '^^" + XSD_DOUBLE + "'";
                                                                            } else if (string33.equals(TYPE_FAM_NUMERIC) && ((String)object12).equals(LTC_TYPE_NUMBER)) {
                                                                                this.log("[omap_tyfam=" + string33 + " DBColType_name=" + (String)object12 + "] => no need to do canonicalization");
                                                                                bl11 = false;
                                                                                string12 = string12 + " || '^^" + XSD_DECIMAL + "'";
                                                                            } else if (string33.equals(TYPE_FAM_NUMERIC) && (((String)object12).equals(LTC_TYPE_BFLOAT) || ((String)object12).equals(LTC_TYPE_BDOUBLE))) {
                                                                                this.log("[omap_tyfam=" + string33 + " DBColType_name=" + (String)object12 + "] => use to_number(), but no need to do canonicalization");
                                                                                bl11 = false;
                                                                                string12 = "'\"' || to_number(" + string22 + ") || '\"' || '^^" + XSD_DECIMAL + "'";
                                                                            } else if (((String)object12).equals(LTC_TYPE_STRING_CLOB)) {
                                                                                this.log("[omap_tyfam=" + string33 + " DBColType_name=" + (String)object12 + "] => do not do canonicalization");
                                                                                bl11 = false;
                                                                                string11 = string4;
                                                                                string12 = "'\"' || dbms_lob.substr(" + string4 + ", " + this.use_varchar2_size_limit + " - ( 2 + " + ("^^" + rRTabRowInfo.oDataType).length() + ")) || '\"^^" + rRTabRowInfo.oDataType + "'";
                                                                            } else if (((String)object12).equals("SDO_GEOMETRY")) {
                                                                                this.log("[omap_tyfam=" + string33 + " DBColType_name=" + (String)object12 + "] => do not do canonicalization");
                                                                                bl11 = false;
                                                                                string11 = "(case when length(" + string4 + ") + " + ("http://www.opengis.net/ont/geosparql#wktLiteral".length() + "\"\"^^<>".length()) + " <= " + this.ctx.networkMaxStringSize + " then null else " + string4 + " end)";
                                                                                string12 = "'\"' || dbms_lob.substr(" + string4 + ", " + this.ctx.networkMaxStringSize + " - ( 2 + " + ("^^" + rRTabRowInfo.oDataType).length() + ")) || '\"^^" + rRTabRowInfo.oDataType + "'";
                                                                                string32 = "sdo_rdf.clobTerm2vcCanon(to_clob('\"' || " + string4 + ") || '\"^^" + rRTabRowInfo.oDataType + "', max_string_size=>" + this.ctx.networkMaxStringSize + ")";
                                                                                string12 = "(case when length(" + string4 + ") + " + ("http://www.opengis.net/ont/geosparql#wktLiteral".length() + "\"\"^^<>".length()) + " > " + this.ctx.networkMaxStringSize + " then " + string32 + " else " + string12 + " end)";
                                                                            } else {
                                                                                string12 = string12 + " || '^^" + rRTabRowInfo.oDataType + "'";
                                                                            }
                                                                            if (bl11) {
                                                                                string12 = "sdo_rdf.get_canon_val(" + string12 + ")";
                                                                            }
                                                                        } else if (((String)object12).equals(LTC_TYPE_STRING_CLOB)) {
                                                                            this.log("[omap_tyfam=" + string33 + " DBColType_name=" + (String)object12 + "] ");
                                                                            string11 = string4;
                                                                            string12 = "'\"' || dbms_lob.substr(" + string4 + " ," + this.use_varchar2_size_limit + " - 2) || '\"'";
                                                                        } else if (((String)object12).equals("SDO_GEOMETRY")) {
                                                                            this.log("[omap_tyfam=" + string33 + " DBColType_name=" + (String)object12 + "] ");
                                                                            string11 = string4;
                                                                            string12 = "dbms_lob.substr(" + string4 + " ," + this.ctx.networkMaxStringSize + " - 2) ";
                                                                        }
                                                                        this.log("   oExpr for DBColType_name " + (String)object12 + " and RRrowInfo.oDataType " + rRTabRowInfo.oDataType + " : " + string12);
                                                                        this.log("clobExpr for DBColType_name " + (String)object12 + " and RRrowInfo.oDataType " + rRTabRowInfo.oDataType + " : " + string11);
                                                                    }
                                                                    break block243;
                                                                }
                                                                if (rRTabRowInfo.oTermType.equals(rrIRI)) {
                                                                    void var74_133;
                                                                    charSequence2 = "U";
                                                                    String string37 = TTL_ESCAPE_BEG;
                                                                    charSequence = ")";
                                                                    if ((this.ctx.R2RFlags & 0x200L) > 0L) {
                                                                        String string38 = "";
                                                                        charSequence = "";
                                                                    } else if ((this.ctx.R2RFlags & 0x20000L) > 0L) {
                                                                        charSequence = ", options=>' ESC_SBYTE_OPT=F ')";
                                                                        if (this.ctx.noTC) {
                                                                            charSequence = ((String)charSequence).substring(0, ((String)charSequence).length() - 2) + " NO_TC=T')";
                                                                        }
                                                                    }
                                                                    object3 = (String)var74_133 + string22 + (String)charSequence;
                                                                    string12 = object7 != null ? "sdo_rdf.criri('" + (String)object7 + "'," + (String)object3 + this.criri_network_storage_form_arg + ")" : "sdo_rdf.criri(NULL," + (String)object3 + this.criri_network_storage_form_arg + ")";
                                                                } else {
                                                                    if (!rRTabRowInfo.oTermType.equals(rrBlankNode)) {
                                                                        this.log("pUA: EXCEPTION: unsupported oExpr for column-valued Omap: oTermType=" + rRTabRowInfo.oTermType + " oDataType=" + rRTabRowInfo.oDataType + " oLanguage=" + rRTabRowInfo.oLanguage);
                                                                        throw new RDFException("unsupported oExpr for column-valued Omap: oTermType=" + rRTabRowInfo.oTermType + " RR_TAB rowid=" + rRTabRowInfo.rowid);
                                                                    }
                                                                    charSequence2 = "B";
                                                                    string12 = "'_:' || sdo_rdf.cbnod(" + string22 + ")";
                                                                }
                                                            }
                                                            if (!bl2) {
                                                                this.log("[pUA] CALLING store_noVa_related_Info: for obje=" + string17);
                                                                this.store_noVa_related_Info(rRTabRowInfo.oTFT_idx, rRTabRowInfo.Tmap, (List<String>)object10, (List<String>)object9, string17, "object:" + n, cSRinfo.getCSRAlias(), null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                            }
                                                            break block252;
                                                        }
                                                        if (rRTabRowInfo.psExpr == null) break block252;
                                                        this.log("debug: [refprop] RRrowInfo: (RRrowFlags=" + n4 + ")\n" + rRTabRowInfo.toString());
                                                        this.log("[psExpr before processing: before adding notNullColCondExpr] condExpr: " + string9);
                                                        n6 = 0;
                                                        if (this.RRrowFlags_for_Tmap.containsKey(rRTabRowInfo.paTmap)) {
                                                            n6 = this.RRrowFlags_for_Tmap.get(rRTabRowInfo.paTmap);
                                                        }
                                                        this.log("paRRrowFlags=" + n6);
                                                        object8 = rRTabRowInfo.psTermType;
                                                        if (object8 == null) {
                                                            object8 = rrIRI;
                                                        }
                                                        if (rRTabRowInfo.psExprType != RRTabRowInfo.MapExprType_TEMPLATE) break block256;
                                                        string12 = RelationalBGP.sqlTempl2sqlExpr(rRTabRowInfo.psExpr.substring(1, rRTabRowInfo.psExpr.length() - 1), (String)object8, string14 + ".", (StringBuffer)object6, (List<String>)object10, (List<String>)object9, rRTabRowInfo.psColTypeList, (Set<String>)object11, this.ctx);
                                                        this.log("oExpr: " + string12);
                                                        if (!((String)object8).equals(rrIRI)) break block257;
                                                        string12 = "'<'||" + string12 + "||'>'";
                                                        if (!bl2) {
                                                            this.store_noVa_related_Info(rRTabRowInfo.psTFT_idx, rRTabRowInfo.Tmap, (List<String>)object10, (List<String>)object9, string17, "object:" + n, cSRinfo.getCSRAlias(), string14, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                            break block258;
                                                        } else {
                                                            object7 = this.find_optimized_CondExpr(string17, (List<String>)object10, (List<String>)object9, string14, rRTabRowInfo.paTmap, null);
                                                            this.log("[obje in triple-pattern is constant] psCondExpr: " + string19 + " optimized_psCondExpr: " + (String)object7);
                                                            if (object7 != null) {
                                                                string19 = COND_CONNECTOR + (String)object7;
                                                            }
                                                        }
                                                        break block258;
                                                    }
                                                    if (!rRTabRowInfo.psTermType.equals(rrBlankNode)) {
                                                        this.log("pUA: EXCEPTION: invalid psTermType=" + (String)object8 + " (RRrowInfo.psTermType=" + rRTabRowInfo.psTermType + ")");
                                                        throw new RDFException("invalid psTermType=" + (String)object8 + " RR_TAB rowid=" + rRTabRowInfo.rowid);
                                                    }
                                                    if ((n6 & 1) == 1) {
                                                        string12 = "'_:' || 'BlankNode' || to_char(sys_op_combined_hash(" + string12 + "), 'FMXXXXXXXXXXXXXXXX', " + "'NLS_Numeric_Characters=''.,'''" + ")";
                                                        this.log("oNotNullColCondExpr for null-col check in ref subject is being cleared: " + object6);
                                                        ((StringBuffer)object6).setLength(0);
                                                        object11.clear();
                                                    } else {
                                                        string12 = "'_:' || sdo_rdf.cbnod(" + string12 + ")";
                                                    }
                                                    if (!bl2) {
                                                        this.store_noVa_related_Info(rRTabRowInfo.psTFT_idx, rRTabRowInfo.Tmap, (List<String>)object10, (List<String>)object9, string17, "object:" + n, cSRinfo.getCSRAlias(), string14, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                    }
                                                    break block258;
                                                }
                                                if (rRTabRowInfo.psExprType != RRTabRowInfo.MapExprType_CONSTANT) break block259;
                                                string12 = "'" + rRTabRowInfo.psExpr + "'";
                                                if (!bl2) {
                                                    this.store_noVa_related_Info(rRTabRowInfo.psTFT_idx, rRTabRowInfo.Tmap, null, null, string17, "object:" + n, cSRinfo.getCSRAlias(), null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                }
                                                break block258;
                                            }
                                            if (rRTabRowInfo.psExprType != RRTabRowInfo.MapExprType_COLUMN) break block260;
                                            if (!((String)object8).equals(rrIRI)) break block261;
                                            object7 = TTL_ESCAPE_BEG;
                                            object5 = ")";
                                            if ((this.ctx.R2RFlags & 0x200L) > 0L) {
                                                object7 = "";
                                                object5 = "";
                                            } else if ((this.ctx.R2RFlags & 0x20000L) > 0L) {
                                                object5 = ", options=>' ESC_SBYTE_OPT=F ')";
                                                if (this.ctx.noTC) {
                                                    object5 = ((String)object5).substring(0, ((String)object5).length() - 2) + " NO_TC=T')";
                                                }
                                            }
                                            string21 = rRTabRowInfo.psExpr;
                                            String string39 = RelationalBGP.get_base_prefix_from_RR_table(string21);
                                            if (string39 != null) {
                                                String string40 = RelationalBGP.get_col_name_from_RR_table(string21);
                                                string12 = "sdo_rdf.criri('" + string39 + "'," + (String)object7 + string14 + "." + string40 + (String)object5 + this.criri_network_storage_form_arg + ")";
                                                object10.add(string40);
                                                object9.add(string39);
                                            } else {
                                                string12 = "sdo_rdf.criri(NULL," + (String)object7 + string14 + "." + string21 + (String)object5 + this.criri_network_storage_form_arg + ")";
                                                object10.add(rRTabRowInfo.psExpr);
                                                object9.add("");
                                            }
                                            if (!bl2) {
                                                this.store_noVa_related_Info(rRTabRowInfo.psTFT_idx, rRTabRowInfo.Tmap, (List<String>)object10, (List<String>)object9, string17, "object:" + n, cSRinfo.getCSRAlias(), string14, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                            }
                                            break block258;
                                        }
                                        if (rRTabRowInfo.psTermType.equals(rrBlankNode)) {
                                            string12 = "'_:' ||" + string14 + "." + rRTabRowInfo.psExpr;
                                            object10.add(rRTabRowInfo.psExpr);
                                            object9.add("");
                                            if (!bl2) {
                                                this.store_noVa_related_Info(rRTabRowInfo.psTFT_idx, rRTabRowInfo.Tmap, (List<String>)object10, (List<String>)object9, string17, "object:" + n, cSRinfo.getCSRAlias(), string14, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                            }
                                            break block258;
                                        } else {
                                            this.log("pUA: EXCEPTION: invalid psTermType=" + (String)object8 + " (RRrowInfo.psTermType=" + rRTabRowInfo.psTermType + ")");
                                        }
                                        break block258;
                                    }
                                    this.log("pUA: EXCEPTION: unsupported psExprType=" + rRTabRowInfo.psExprType);
                                }
                                object7 = this.LtabExpr_for_Tmap.get(rRTabRowInfo.paTmap);
                                if (object7 == null) {
                                    if (rRTabRowInfo.ptabName != null) {
                                        object7 = rRTabRowInfo.ptabOwner + "." + rRTabRowInfo.ptabName;
                                    } else if (rRTabRowInfo.pSqlQuery != null) {
                                        object7 = "(" + rRTabRowInfo.pSqlQuery.substring(1, rRTabRowInfo.pSqlQuery.length() - 1).replaceAll("\\\\\"", "\"") + ")";
                                    } else {
                                        this.log("EXCEPTION: NULL prowsrc: RRrowInfo.tabName=" + rRTabRowInfo.ptabName + " .sqlQuery=" + rRTabRowInfo.pSqlQuery);
                                    }
                                    this.log("prowsrc=" + (String)object7);
                                    this.LtabExpr_for_Tmap.put(rRTabRowInfo.paTmap, (String)object7);
                                }
                                string10 = ", " + (String)object7 + BASE_PREFIX_COLNAME_SEP + string15;
                                this.log("fromPaLtabPlusAlias: " + string10);
                                if (rRTabRowInfo.refJoinStr != null) {
                                    string8 = COND_CONNECTOR + rRTabRowInfo.refJoinStr;
                                }
                            }
                            if (bl2) {
                                if (string19 != null) {
                                    string9 = string9 + string19;
                                } else if (!string12.equals("'" + string17 + "'")) {
                                    String string41 = string20 == null ? (string17.charAt(0) == '<' ? COND_CONNECTOR + string12 + "='" + string17.replace("'", "''") + "'" : COND_CONNECTOR + string12 + "=sdo_rdf.get_canon_val('" + string17.replace("'", "''") + "')") : string20;
                                    string9 = string9 + string41;
                                } else {
                                    this.log("skipped TRIVIALLY TRUE value_cond with IDENTICAL lhs and rhs: oExpr=" + string12 + " (enquoted)obje='" + string17 + "'");
                                }
                            }
                            string3 = null;
                            object8 = new ArrayList();
                            object7 = new ArrayList();
                            if (this.activeGraph == null && !this.ctx.allGraphsDefault && (this.graph_use_mode & 2) == 0) {
                                this.log("pUA: no graph-clause, no FROM clause, no FROM NAMED clause, STRICT_DEFAULT=T: MUST skip all RR rows that would produce a non-null or non-rr:defaultGraph graph IRI: colList: ");
                                if (rRTabRowInfo.pogExprType == RRTabRowInfo.MapExprType_TEMPLATE) {
                                    void var69_96;
                                    object5 = DriverManager.getConnection("jdbc:oracle:kprb:");
                                    int n14 = RelationalBGP.convert_comp_name_to_comp_idx("graph", null);
                                    List<String> list12 = rRTabRowInfo.colLists.get(n14);
                                    String string42 = " AND (1=0";
                                    String string43 = QueryUtils.enquoteNameSQLName(string16);
                                    for (int i = 0; i < list12.size(); ++i) {
                                        String string44 = (String)var69_96 + " or " + string43 + "." + QueryUtils.enquoteNameSQLName(list12.get(i)) + " is NULL";
                                    }
                                    String string45 = (String)var69_96 + ") ";
                                    this.log("pUA: cond_strict_default_RRrow: " + string45);
                                    string9 = string9 + string45;
                                }
                            }
                            if (this.graph_use_mode <= 0) break block262;
                            this.log("RRrowInfo.pogExpr [Type=" + rRTabRowInfo.pogExprType + "] : " + rRTabRowInfo.pogExpr);
                            object5 = new StringBuffer("");
                            hashSet = new HashSet<String>();
                            if (rRTabRowInfo.pogExpr != null && (rRTabRowInfo.pogExprType != RRTabRowInfo.MapExprType_CONSTANT || !rRTabRowInfo.pogExpr.equals(rrDefaultGraph))) break block263;
                            if (!bl4 || string2 == null && (this.graph_use_mode & 1) == 1) {
                                this.log("rr:graphMap is ABSENT or uses rr:defaultGraph");
                                break block246;
                            } else {
                                string3 = "NULL";
                                this.log("graphMatchUnnamed is TRUE: gExpr=" + string3 + " (rr:graphMap is ABSENT or uses rr:defaultGraph)");
                                this.store_noVa_related_Info(this.null_TFTidx, rRTabRowInfo.Tmap, null, null, string2, "graph:" + n, cSRinfo.getCSRAlias(), null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                            }
                            break block246;
                        }
                        if (rRTabRowInfo.pogExprType != RRTabRowInfo.MapExprType_TEMPLATE) break block264;
                        string3 = RelationalBGP.sqlTempl2sqlExpr(rRTabRowInfo.pogExpr.substring(1, rRTabRowInfo.pogExpr.length() - 1), rrIRI, "%LALIASKEY%.", (StringBuffer)object5, (List<String>)object8, (List<String>)object7, rRTabRowInfo.pogColTypeList, hashSet, this.ctx);
                        string3 = "'<'||" + string3 + "||'>'";
                        if (this.is_bgp_graph_a_var) {
                            this.store_noVa_related_Info(rRTabRowInfo.pogTFT_idx, rRTabRowInfo.Tmap, (List<String>)object8, (List<String>)object7, string2, "graph:" + n, cSRinfo.getCSRAlias(), null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                            break block246;
                        } else {
                            this.log("Not an error: but for debugging: [graph_use_mode=" + this.graph_use_mode + ": GRAPH clause absent and FROM/FROM NAMED present]:");
                            this.log("-->GraphMap is TEMPLATE: gExpr=" + string3 + " graph_use_mode=" + this.graph_use_mode + " bgp_graph=" + string2);
                        }
                        break block246;
                    }
                    if (rRTabRowInfo.pogExprType != RRTabRowInfo.MapExprType_CONSTANT) break block265;
                    if (bl3) {
                        if (rRTabRowInfo.pogExpr.equals(string2)) {
                            string3 = "'" + rRTabRowInfo.pogExpr + "'";
                            this.log("found exact match of GRAPH clause and rr:graph constants");
                            break block246;
                        } else {
                            string3 = "'0'";
                            this.log("found MISMATCH of GRAPH clause and rr:graph constants: ");
                        }
                        break block246;
                    } else if (this.is_bgp_graph_a_var) {
                        string3 = "'" + rRTabRowInfo.pogExpr + "'";
                        this.store_noVa_related_Info(rRTabRowInfo.pogTFT_idx, rRTabRowInfo.Tmap, null, null, string2, "graph:" + n, cSRinfo.getCSRAlias(), null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                        break block246;
                    } else {
                        this.log("Not an error: but for debugging: [graph_use_mode=" + this.graph_use_mode + ": GRAPH clause absent and FROM/FROM NAMED present]:");
                        this.log("-->GraphMap is CONSTANT: gExpr=" + string3 + " graph_use_mode=" + this.graph_use_mode + " bgp_graph=" + string2);
                    }
                    break block246;
                }
                if (rRTabRowInfo.pogExprType == RRTabRowInfo.MapExprType_COLUMN) {
                    throw new RDFException("Feature not supported: column-valued rr:GraphMap : " + rRTabRowInfo.pogExpr);
                }
            }
            if (((StringBuffer)object5).length() > 0) {
                string9 = string9 + ((StringBuffer)object5).toString();
                this.log("[gExpr: added notNullColCondExpr] condExpr: " + string9);
            }
            this.log("computed gExpr=" + string3 + " gNotNullColCondExpr=" + object5 + " gNotNullCond_colSet: " + hashSet);
        }
        this.log("[STARTING] predicate-var Filter Condition");
        object5 = "";
        if (!bl) {
            this.log("variable in predicate-position: generating condition (if any) based on FILTER: " + string18);
            for (RelExpr relExpr : this.RelExprFilterList_for_BGP) {
                this.log(relExpr.toString());
                if (relExpr.RelExprFlags == 2L) {
                    this.log("skipping GEOMETRY filter");
                    continue;
                }
                if ((relExpr.L_atom.type != 0 || !relExpr.L_atom.name.equals(string18) || relExpr.R_atom.type == 0) && (relExpr.R_atom.type != 0 || !relExpr.R_atom.name.equals(string18) || relExpr.L_atom.type == 0)) continue;
                object5 = (String)object5 + this.genFilterCond_new(relExpr, rRTabRowInfo, 1, string13, string16);
                this.log("condExpr_pred_filter_delta: " + (String)object5);
            }
        }
        this.log("condExpr_pred_filter_delta[AFTER]: " + (String)object5);
        this.log("[STARTING] object-variable Filter Condition");
        String string46 = "";
        if (!bl2) {
            this.log("variable in object-position: generating condition (if any) based on FILTER: " + string17);
            this.log("Relexprfilterlist_For_Bgp.size()=" + this.RelExprFilterList_for_BGP.size());
            for (RelExpr relExpr : this.RelExprFilterList_for_BGP) {
                this.log(relExpr.toString());
            }
            for (RelExpr relExpr : this.RelExprFilterList_for_BGP) {
                int n15;
                this.log(relExpr.toString());
                if (relExpr.RelExprFlags != 2L && (relExpr.L_atom.type != 0 || !relExpr.L_atom.name.equals(string17) || relExpr.R_atom.type == 0) && (relExpr.R_atom.type != 0 || !relExpr.R_atom.name.equals(string17) || relExpr.L_atom.type == 0)) continue;
                int n16 = 2;
                String string47 = string16;
                if (rRTabRowInfo.psExpr != null) {
                    n15 = 4;
                    string47 = string14;
                }
                string46 = string46 + this.genFilterCond_new(relExpr, rRTabRowInfo, n15, string12, string47);
                this.log("condExpr_obje_filter_delta: " + string46);
            }
        }
        this.log("condExpr_obje_filter_delta[AFTER]: " + string46);
        this.log("[STARTING] bgp_graph-var Filter Condition");
        String string48 = "";
        if (this.is_bgp_graph_a_var) {
            this.log("variable in bgp_graph-position: generating condition (if any) based on FILTER: " + string2);
            for (RelExpr relExpr : this.RelExprFilterList_for_BGP) {
                this.log(relExpr.toString());
                if (relExpr.RelExprFlags == 2L) {
                    this.log("skipping GEOMETRY filter");
                    continue;
                }
                if ((relExpr.L_atom.type != 0 || !relExpr.L_atom.name.equals(string2) || relExpr.R_atom.type == 0) && (relExpr.R_atom.type != 0 || !relExpr.R_atom.name.equals(string2) || relExpr.L_atom.type == 0)) continue;
                String string49 = (String)var68_88 + this.genFilterCond_new(relExpr, rRTabRowInfo, 3, string3, string16);
                this.log("condExpr_bgp_graph_filter_delta: " + string49);
            }
        }
        this.log("condExpr_bgp_graph_filter_delta[AFTER]: " + (String)var68_88);
        if (n == 0) {
            bl9 = true;
            bl8 = true;
            bl7 = true;
            bl6 = true;
            bl5 = false;
        } else {
            bl9 = false;
            bl8 = false;
            bl7 = false;
            bl6 = false;
            bl5 = false;
        }
        this.log("UArowNatSelectInfo_tmp=" + uArowNatSelectInfo2);
        this.log("going to process GEOMETRY filters");
        String string50 = "";
        for (RelExpr relExpr : this.RelExprFilterList_for_BGP) {
            void var69_107;
            this.log("checking relExpr for GEOMETRY filter: " + relExpr.toString());
            if (relExpr.RelExprFlags != 2L) {
                this.log("pUA: skipping non-GEOMETRY filter");
                continue;
            }
            object4 = new HashSet();
            if (!bl) {
                object4.add(string18);
            }
            if (!bl2) {
                object4.add(string17);
            }
            if (this.is_bgp_graph_a_var) {
                object4.add(string2);
            }
            charSequence2 = this.genFilter_v3(mCSR, "TPAT_LEVEL", string16, -1, rRTabRowInfo, null, null, relExpr, (Set<String>)object4, null, null);
            this.log("condExpr_geo :" + (String)charSequence2);
            if (((String)charSequence2).equals(" AND 1=0 ")) {
                String string51 = " AND 1=0 ";
                break;
            }
            if (((String)charSequence2).equals("")) continue;
            this.log("processed this filter at TPAT level: relExpr.procAtLevel=" + relExpr.procAtLevel);
            String string52 = (String)var69_107 + COND_CONNECTOR + (String)charSequence2;
        }
        String string53 = rRTabRowInfo.rowid;
        for (int i = 0; i < n3; ++i) {
            void var69_110;
            void var84_172;
            void var74_138;
            UArowNatSelectInfo uArowNatSelectInfo3;
            int n17 = n5 + n2 + i;
            charSequence2 = string9;
            String string54 = string10;
            charSequence = string8;
            object3 = list8.get(n5 + n2 + i);
            this.log("pUA [populating] ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            this.log("pUA [populating] UArowIdx: " + n17 + " sAlias: " + (String)object3);
            object2 = "UNDEFINED_VALUE_FOR_use_pAlias";
            boolean bl12 = false;
            if (rRTabRowInfo.psExpr != null && rRTabRowInfo.psExprType != RRTabRowInfo.MapExprType_CONSTANT) {
                this.log("pUA [MCSR handling]  target_UArowNum: " + n17);
                this.log("pUA [MCSR handling]             obje: " + string17);
                this.log("pUA [MCSR handling] RRrowInfo.paTmap: " + rRTabRowInfo.paTmap);
                string6 = mCSR.getTableAliasForVarTmap(cSRinfo.CSR_key, n17, string17, rRTabRowInfo.paTmap);
                if (string6 == null) {
                    this.log("pUA [MCSR handling] table alias NOT found for var: " + string17 + " parent Tmap: " + rRTabRowInfo.paTmap);
                    this.log("RRrowInfo.fkSubsumesPk():" + rRTabRowInfo.fkSubsumesPk());
                    if (rRTabRowInfo.fkSubsumesPk()) {
                        this.log("pUA [MCSR handling] FK subsumes PK ... re-using sAlias: " + (String)object3);
                        object2 = object3;
                        bl12 = true;
                    } else {
                        object2 = string15;
                    }
                    this.log("pUA [MCSR handling] adding table alias: " + (String)object2 + " for var: " + string17 + " parent Tmap: " + rRTabRowInfo.paTmap);
                    mCSR.addTableAliasForVarTmap(cSRinfo.CSR_key, n17, string17, rRTabRowInfo.paTmap, (String)object2);
                } else {
                    if (string6.equals(string15)) {
                        throw new RDFException("pUA [MCSR handling] Same table alias " + string15 + " seen before for var: " + string17 + " parent Tmap: " + rRTabRowInfo.paTmap);
                    }
                    this.log("pUA [MCSR handling] Different table aliases for var: " + string17 + " parent Tmap: " + rRTabRowInfo.paTmap);
                    this.log("pUA [MCSR handling]                          before: " + string6 + " now: " + string15);
                    this.log("pUA [MCSR handling]          using the previous one: " + string6);
                    object2 = string6;
                    bl12 = true;
                }
                this.log("pUA [MCSR handling]       use_pAlias: " + (String)object2);
            }
            boolean bl13 = false;
            string5 = "";
            if (bl5) {
                this.log("pUA loop: adding Table alias " + (String)object3 + " for CSR_subj: " + cSRinfo.CSR_subj + " + Tmap" + string);
                mCSR.addTableAliasForVarTmap(cSRinfo.CSR_key, n17, cSRinfo.CSR_subj, string, (String)object3);
            }
            charSequence2 = ((String)charSequence2).replaceAll(string14, (String)object2).replaceAll(LALIASKEY, (String)object3);
            string4 = ":" + string53;
            if (bl9) {
                this.log("pUA loop: adding element [" + list11.size() + "] : RRrLContent=" + string4);
                list11.add(string4);
            } else {
                this.log("pUA loop: extending RRrLArray element " + n5 + "+" + n2 + "+" + i + " appending: RRrLContent=" + string4);
                String string55 = null;
                string55 = list11.get(n17) + string4;
                list11.set(n17, string55);
            }
            this.log("==> writePos=" + n2 + " : idx=" + i + " : UArowNatSelectInfoArray.size()=" + list4.size());
            if (n5 + n2 + i < list4.size()) {
                uArowNatSelectInfo3 = list4.get(n17);
                uArowNatSelectInfo3.addVarInfoFrom(uArowNatSelectInfo2, LALIASKEY, (String)object3, string14, (String)object2);
            } else {
                uArowNatSelectInfo3 = new UArowNatSelectInfo(uArowNatSelectInfo2, LALIASKEY, (String)object3, string14, (String)object2);
                list4.add(uArowNatSelectInfo3);
            }
            if (bl10) {
                this.log("pUA loop: adding element [" + list3.size() + "] : pExpr=" + string13);
                list3.add(string13.replaceAll(LALIASKEY, (String)object3));
                if (!bl) {
                    string5 = this.isVarOccMatchable_in_UArow(string18, "predicate", n, n17, string53, this.FullOccInfo_for_VarPlusCSRAlias.get(string18 + "+" + cSRinfo.getCSRAlias()), list11.get(n17));
                }
            }
            if (rRTabRowInfo.psExpr != null && rRTabRowInfo.psExprType != RRTabRowInfo.MapExprType_CONSTANT) {
                if (bl12) {
                    String string56 = null;
                    this.log("RESET to null: UArow_fromPaLtabPlusAlias: " + string56);
                } else if (((StringBuffer)object6).length() > 0) {
                    this.log("[UArow_condExpr: before adding notNullColCondExpr]: " + (String)charSequence2);
                    this.log("                              oNotNullColCondExpr= " + object6);
                    this.log("           replacing pAliasKey " + string14 + " -> use_pAlias " + (String)object2);
                    String string57 = ((StringBuffer)object6).toString().replaceAll(string14, (String)object2);
                    charSequence2 = (String)charSequence2 + string57;
                    this.log("[UArow_condExpr: after adding oNotNullColCondExpr]: " + (String)charSequence2);
                }
                if (charSequence != null && !rRTabRowInfo.fkSubsumesPk()) {
                    this.log("[UArow_condExpr: before adding UArow_refJoinStrInst]: " + (String)charSequence2);
                    this.log("                               UArow_refJoinStrInst= " + (String)charSequence);
                    this.log("           replacing ctab   -> sAlias " + (String)object3);
                    charSequence = ((String)charSequence).replaceAll("\\(ctab.", "\\(" + (String)object3 + ".");
                    this.log("           replacing ptab   -> use_pAlias " + (String)object2);
                    charSequence = ((String)charSequence).replaceAll(" = ptab.", " = " + (String)object2 + ".");
                    charSequence = ((String)charSequence).replaceAll(" and ptab.", " and " + (String)object2 + ".");
                    charSequence2 = (String)charSequence2 + (String)charSequence;
                    this.log("[UArow_condExpr: after adding UArow_refJoinStrInst]: " + (String)charSequence2);
                    mCSR.setPairOfCSRsAlreadyJoined((String)object2, (String)object3);
                }
            } else if (((StringBuffer)object6).length() > 0) {
                this.log("[UArow_condExpr: before adding notNullColCondExpr]: " + (String)charSequence2);
                this.log("                              oNotNullColCondExpr=  " + object6);
                String string58 = ((StringBuffer)object6).toString().replaceAll(LALIASKEY, (String)object3);
                charSequence2 = (String)charSequence2 + string58;
                this.log("[UArow_condExpr: after adding oNotNullColCondExpr]: " + (String)charSequence2);
            }
            this.log("AFTER addTableAliasForVarTmap call: UArow_condExpr: " + (String)charSequence2);
            this.log("[oExpr: before adding oExpr]: " + string12);
            this.log("        replacing %LALIASKEY% with sAlias=" + (String)object3 + " and (if relevant) pAliasKey " + string14 + " --> use_pAlias " + (String)object2);
            this.log("pUA loop: adding element [" + list2.size() + "] : oExpr-after-replacements=" + string12.replaceAll(string14, (String)object2).replaceAll(LALIASKEY, (String)object3));
            list2.add(string12.replaceAll(string14, (String)object2).replaceAll(LALIASKEY, (String)object3));
            this.log("pUA loop: adding element [" + list.size() + "] : clobExpr-after-replacements=" + string11.replaceAll(string14, (String)object2).replaceAll(LALIASKEY, (String)object3));
            list.add(string11.replaceAll(string14, (String)object2).replaceAll(LALIASKEY, (String)object3));
            if (n == 0) {
                for (String string59 : map2.keySet()) {
                    map = map2.get(string59);
                    object = new HashSet();
                    this.log("pUA loop: adding element [" + map.size() + "] : (for var=" + string59 + " : native_oExprSet=EMPTY-SET");
                    map.add(object);
                    this.log("UAstartPos=" + n5 + "[writePos+idx=" + n2 + "+" + i + "] [var=" + string59 + "] : Created an empty native_oExprSet and added to native_oExprSetArray");
                }
                this.log("pUA: EXTENDED native_oExprSetArray for each native-optimizable var : Content :" + map2);
            }
            if (!bl2) {
                this.log("native_oExpr=" + string7 + " :  native_oExprSetArray_for_Var.get(" + string17 + ") :" + map2.get(string17));
            }
            if (string7 != null && map2.get(string17) != null) {
                Set<String> set = map2.get(string17).get(n17);
                this.log("before adding to set: native_oExprSet_for_var_and_row=" + set);
                set.add(string7.replaceAll(LALIASKEY, (String)object3));
                this.log("AFTER  adding to set: native_oExprSet_for_var_and_row=" + set);
                bl13 = true;
            }
            String string60 = "";
            if (this.graph_use_mode > 0) {
                void var84_165;
                if (this.is_bgp_graph_a_var && n == 0) {
                    this.log("po_idx=" + n + " : adding (as row: " + list7.size() + ") : gExpr-after-replacement=" + string3.replaceAll(LALIASKEY, (String)object3));
                    list7.add(string3.replaceAll(LALIASKEY, (String)object3));
                }
                Object var84_162 = null;
                if (n == 0) {
                    HashSet hashSet = new HashSet();
                    this.log("created new Gees to add to GeesArray at row number: " + list6.size());
                    list6.add(hashSet);
                } else {
                    Set<String> set = list6.get(n17);
                    this.log("retrieved Gees from GeesArray row number " + n17 + " : Gees (before adding)=" + set);
                }
                var84_165.add(string3.replaceAll(LALIASKEY, (String)object3));
                this.log("po_idx=" + n + " : after adding gExpr to set : Gees=" + var84_165);
                map = null;
                if (n == 0) {
                    map = new HashMap();
                    this.log("created new TpGE HashMap to add to TpGEArray at row number: " + list5.size());
                    list5.add(map);
                } else {
                    map = list5.get(n17);
                    this.log("retrieved TpGE from TpGEArray row number " + n17 + " : TpGE (before adding)=" + map);
                }
                object = "";
                if (map.containsKey(string3)) {
                    object = (String)map.get(string3);
                }
                map.put(string3.replaceAll(LALIASKEY, (String)object3), (String)object + "+" + n);
                this.log("po_idx=" + n + " : after adding gExpr to HashMap : TpGE=" + map);
            }
            if (bl8) {
                void var84_168;
                String string61 = "";
                map = "";
                this.log("UArow_fromPaLtabPlusAlias: " + (String)var74_138);
                if (var74_138 != null) {
                    void var84_167 = var74_138;
                    map = "+" + n + ":0";
                }
                this.log("pUA loop: adding element [" + list10.size() + "] : fromContent=" + (String)var84_168);
                list10.add((String)var84_168);
            } else if (var74_138 != null) {
                String string62 = list10.get(n17);
                map = string62 + (String)var74_138;
                this.log("pUA loop: updating element [UAstartPos=" + n5 + "+" + n2 + "+" + i + "] : fromOrigContent=" + string62 + " -> " + (String)((Object)map));
                list10.set(n17, (String)((Object)map));
            }
            String string63 = "";
            if (!bl12) {
                if (!bl2 && !bl13) {
                    String string64 = this.isVarOccMatchable_in_UArow(string17, "object", n, n17, string53, this.FullOccInfo_for_VarPlusCSRAlias.get(string17 + "+" + cSRinfo.getCSRAlias()), list11.get(n17));
                } else if (!bl2) {
                    this.log("multiOccurrenceOfVar() call skipped because native_oExprSet_added");
                }
            }
            this.log("condExpr_obje_filter_delta[START_OF_ADD_TO_CONDARRAY]: " + string46);
            if (bl7) {
                map = "";
                this.log(" condConnector : " + (String)((Object)map));
                this.log(" condExpr : " + string9);
                this.log(" UArow_condExpr : " + (String)charSequence2);
                this.log(" condExpr_pred_filter_delta : " + (String)object5);
                this.log(" condExpr_obje_filter_delta : " + string46);
                this.log(" condExpr_bgp_graph_filter_delta : " + (String)var68_88);
                this.log(" condExpr_graph_multiOcc_delta : " + string60);
                this.log(" condExpr_pred_multiOcc_delta : " + string5);
                this.log(" condExpr_obje_multiOcc_delta : " + (String)var84_172);
                this.log(" condExpr_geometry_filter: " + (String)var69_110);
                object = map + string9 + (String)charSequence2 + (String)object5 + string46 + (String)var68_88 + string60 + string5 + (String)var84_172 + (String)var69_110;
                this.log("[COND] 5 " + (String)object);
                this.log("pUA loop: adding element [" + list9.size() + "] : condContent=" + (String)object);
                list9.add(((String)object).replaceAll(string14, (String)object2).replaceAll(LALIASKEY, (String)object3));
                continue;
            }
            if (!list9.get(n17).equals(" AND 1=0 ")) {
                map = list9.get(n17);
                this.log(" [                condOrigContent ] " + (String)((Object)map));
                this.log(" [                       condExpr ] " + string9);
                this.log(" [                 UArow_condExpr ] " + (String)charSequence2);
                this.log(" [     condExpr_pred_filter_delta ] " + (String)object5);
                this.log(" [     condExpr_obje_filter_delta ] " + string46);
                this.log(" [condExpr_bgp_graph_filter_delta ] " + (String)var68_88);
                this.log(" [   condExpr_pred_multiOcc_delta ] " + string5);
                this.log(" [   condExpr_obje_multiOcc_delta ] " + (String)var84_172);
                this.log(" [       condExpr_geometry_filter ] " + (String)var69_110);
                if (string5.equals(" AND 1=0 ") || var84_172.equals(" AND 1=0 ")) {
                    object = " AND 1=0 ";
                } else {
                    object = map + (String)object5 + string46 + (String)var68_88 + string5 + (String)var84_172;
                    if (((String)((Object)map)).indexOf((String)var69_110) == -1) {
                        object = (String)object + (String)var69_110;
                    }
                    if (((String)((Object)map)).indexOf((String)charSequence2) < 0) {
                        object = (String)object + (String)charSequence2;
                        this.log("[condNewContent: after adding UArow_condExpr]: " + (String)object);
                    } else {
                        this.log("[condNewContent: skipping adding UArow_condExpr]: " + (String)charSequence2);
                    }
                }
                this.log("pUA loop: updating element [UAstartPos=" + n5 + "+" + n2 + "+" + i + "] : condOrigContent=" + map + " -> " + (String)object);
                list9.set(n17, ((String)object).replaceAll(string14, (String)object2).replaceAll(LALIASKEY, (String)object3));
                continue;
            }
            this.log("pUA loop: SKIPPED updating element because it is already  AND 1=0 ");
        }
        if (!bl) {
            this.log("pUA: FINALLY : pExprArray.size()=" + list3.size());
        }
        this.log("pUA: FINALLY : oExprArray.size()=" + list2.size());
        this.log("pUA: FINALLY : clobExprArray.size()=" + list.size());
        if (this.graph_use_mode > 0) {
            if (this.is_bgp_graph_a_var) {
                this.log("pUA: FINALLY : gExprArray.size()=" + list7.size());
            }
            this.log("pUA: FINALLY : GeesArray.size()=" + list6.size());
            this.log("pUA: FINALLY : TpGEArray.size()=" + list5.size());
        }
        this.log("pUA: FINALLY : fromArray.size()=" + list10.size());
        this.log("pUA: FINALLY : condArray.size()=" + list9.size());
        this.log("pUA: FINALLY : sAliasArray.size()=" + list8.size());
        this.log("pUA: FINALLY : native_oExprSetArray_for_Var.size()=" + map2.size() + " : " + map2);
        this.log("EXIT populateUnionArrays: --------------------------------------------------------------------------");
    }

    String get_subStringAtIndex(String string, int n, String string2) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i <= n; ++i) {
            n3 = string.indexOf(string2, n2 + 1);
            if (n3 == -1) {
                n3 = string.length();
            }
            if (i >= n) continue;
            n2 = n3;
        }
        return string.substring(n2 + 1, n3);
    }

    String gen_e_z_filter_cond(RelExpr relExpr, boolean bl, boolean bl2) {
        String string = "";
        if (bl2 && (relExpr.compOperator.equals("<=") || relExpr.compOperator.equals(">=") || relExpr.compOperator.equals("<=") || relExpr.compOperator.equals(">="))) {
            string = " AND 1=0 ";
            this.log("gen_e_z_filter_cond (case 1): setting cond: " + string);
        } else if (relExpr.compOperator.equals("=") || relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("<=") || relExpr.compOperator.equals(">=") || relExpr.compOperator.equalsIgnoreCase("LIKE")) {
            this.log("gen_e_z_filter_cond (case 2): ");
            if (!bl) {
                if (relExpr.compOperator.equals("=") || relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("LIKE")) {
                    string = " AND 1=0 ";
                    this.log("  setting cond as COND_FALSE: " + string);
                } else {
                    this.log("  Just because matchable=" + bl + ", does NOT guarantee COND_FALSE for  relExpr.compOperator: " + relExpr.compOperator);
                }
            } else {
                string = COND_TRUE;
                this.log("  setting cond as COND_TRUE: " + string);
            }
        } else {
            this.log("gen_e_z_filter_cond (case 3): ");
            if (!bl) {
                if (relExpr.compOperator.equals("!=") || relExpr.compOperator.equals("DIFFTERM") || relExpr.compOperator.equals("NOT LIKE")) {
                    string = COND_TRUE;
                    this.log("  setting cond as COND_TRUE: " + string);
                } else {
                    this.log("  Just because matchable=" + bl + ", does NOT guarantee COND_TRUE for  relExpr.compOperator: " + relExpr.compOperator);
                }
            } else {
                string = " AND 1=0 ";
                this.log("  setting cond as COND_FALSE: " + string);
            }
        }
        this.log("gen_e_z_filter_cond: returning cond: " + string);
        return string;
    }

    private boolean isNumFltDbl(String string) {
        return string.equals(TYPE_FAM_NUMERIC) || string.equals(TYPE_FAM_FLOAT) || string.equals(TYPE_FAM_DOUBLE);
    }

    String gen_e_z_termType_based_cond(RelExpr relExpr, boolean bl) throws RDFException {
        String string = null;
        if (!bl) {
            return string;
        }
        if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("=") || relExpr.compOperator.equals("<") || relExpr.compOperator.equals("<=") || relExpr.compOperator.equals(">") || relExpr.compOperator.equals(">=") || relExpr.compOperator.equalsIgnoreCase("LIKE")) {
            string = " AND 1=0 ";
        } else if (relExpr.compOperator.equals("DIFFTERM") || relExpr.compOperator.equals("!=") || relExpr.compOperator.equals("NOT LIKE")) {
            string = COND_TRUE;
        }
        return string;
    }

    String gen_e_z_datatype_based_cond(RelExpr relExpr, boolean bl, boolean bl2, boolean bl3) throws RDFException {
        String string = null;
        if (!bl) {
            return string;
        }
        if (relExpr.compOperator.equals("SAMETERM")) {
            string = " AND 1=0 ";
        } else if (relExpr.compOperator.equals("DIFFTERM")) {
            string = COND_TRUE;
        }
        if (string != null) {
            return string;
        }
        if (bl3 && (relExpr.compOperator.equals("=") || relExpr.compOperator.equals("!=") || relExpr.compOperator.equals("<") || relExpr.compOperator.equals("<=") || relExpr.compOperator.equals(">") || relExpr.compOperator.equals(">="))) {
            string = " AND 1=0 ";
        }
        return string;
    }

    private static String tzone(String string) {
        if (string.charAt(string.length() - 1) == 'Z') {
            return "Z";
        }
        if (string.length() >= 11 && (string.charAt(string.length() - 6) == '+' || string.charAt(string.length() - 6) == '-')) {
            return string.substring(string.length() - 6);
        }
        return null;
    }

    private static int convert_comp_name_to_comp_idx(String string, String string2) throws RDFException {
        int n;
        if (string.equals("subject")) {
            n = 0;
        } else if (string.equals("predicate")) {
            n = 1;
        } else if (string.equals("object") && string2 == null) {
            n = 2;
        } else if (string.equals("graph")) {
            n = 3;
        } else if (string.equals("object") && string2 != null) {
            n = 4;
        } else {
            throw new RDFException("convert_comp_name_to_comp_idx: Internal error: Unknown comp_name=" + string);
        }
        return n;
    }

    private String compose_filter2v_opt_condExpr_for_UArow_from_occPos_pairs(int n, RelExpr relExpr, int n2, int n3, String string, String string2, RRTabRowInfo rRTabRowInfo, RRTabRowInfo rRTabRowInfo2, CSRinfo cSRinfo, CSRinfo cSRinfo2) throws RDFException {
        this.log("Entering: compose_filter2v_opt_condExpr_for_UArow_from_occPos_pairs");
        String string3 = relExpr.compOperator;
        if (relExpr.eqBasedComp) {
            string3 = "=";
        }
        String string4 = string.substring(0, string.indexOf(58));
        int n4 = Integer.parseInt(string.substring(string.indexOf(58) + 1, string.length()));
        int n5 = RelationalBGP.convert_comp_name_to_comp_idx(string4, rRTabRowInfo.paTmap);
        List<String> list = rRTabRowInfo.colLists.get(n5);
        int n6 = n % cSRinfo.getUArowsCount();
        String string5 = cSRinfo.sAliasArray.get(n6);
        if (n5 == 4) {
            int n7 = n4 + cSRinfo.po_idx_base;
            string5 = "P" + n7;
        }
        this.log("L_pos_in_tp: " + string4 + " : L_po_idx=" + n4 + " : L_alias=" + string5 + " : L_colList=" + list);
        String string6 = string2.substring(0, string2.indexOf(58));
        int n8 = Integer.parseInt(string2.substring(string2.indexOf(58) + 1, string2.length()));
        int n9 = RelationalBGP.convert_comp_name_to_comp_idx(string6, rRTabRowInfo2.paTmap);
        List<String> list2 = rRTabRowInfo2.colLists.get(n9);
        int n10 = n % cSRinfo2.getUArowsCount();
        String string7 = cSRinfo2.sAliasArray.get(n10);
        if (n9 == 4) {
            int n11 = n8 + cSRinfo2.po_idx_base;
            string7 = "P" + n11;
        }
        this.log("R_pos_in_tp: " + string6 + " : R_po_idx=" + n8 + " : R_alias=" + string7 + " : R_colList=" + list2);
        TFTinfo tFTinfo = this.TFTinfoGlobalList.get(n2);
        List<String> list3 = tFTinfo.colTypeList;
        TFTinfo tFTinfo2 = this.TFTinfoGlobalList.get(n3);
        List<String> list4 = tFTinfo2.colTypeList;
        String string8 = "";
        this.log("L_TFTobj: " + tFTinfo.toString());
        this.log("R_TFTobj: " + tFTinfo2.toString());
        this.log("L_RRrowInfo: " + rRTabRowInfo.toString());
        this.log("R_RRrowInfo: " + rRTabRowInfo2.toString());
        this.log("loop thru each col in L_colList: " + list + " ...");
        for (int i = 0; i < list.size(); ++i) {
            String string9 = null;
            String string10 = null;
            if (tFTinfo.exprType == RRTabRowInfo.MapExprType_COLUMN) {
                string9 = tFTinfo.colTypeList.get(0);
            }
            this.log("L_DBColType_name: " + string9);
            if (tFTinfo2.exprType == RRTabRowInfo.MapExprType_COLUMN) {
                string10 = tFTinfo2.colTypeList.get(0);
            }
            this.log("R_DBColType_name: " + string10);
            String string11 = string5 + "." + list.get(i);
            String string12 = string7 + "." + list2.get(i);
            this.log("L_colExpr: " + string11 + " R_colExpr: " + string12);
            if (n2 != n3) {
                String string13 = tFTinfo.datatype_family;
                String string14 = tFTinfo2.datatype_family;
                if (tFTinfo.exprType == RRTabRowInfo.MapExprType_COLUMN && tFTinfo2.exprType == RRTabRowInfo.MapExprType_COLUMN && string13 != null && string14 != null && (string13.equals(TYPE_FAM_NUMERIC) || string13.equals(TYPE_FAM_FLOAT) || string13.equals(TYPE_FAM_DOUBLE)) && (string14.equals(TYPE_FAM_NUMERIC) || string14.equals(TYPE_FAM_FLOAT) || string14.equals(TYPE_FAM_DOUBLE))) {
                    String string15 = tFTinfo.colTypeList.get(i);
                    String string16 = tFTinfo2.colTypeList.get(i);
                    this.log("mapping-pair: column-column | colType-pair=" + string15 + "-" + string16 + " | datatye_families: " + string13 + "-" + string14);
                    if (string13.equals(TYPE_FAM_FLOAT) && !string15.equals(LTC_TYPE_BFLOAT)) {
                        string11 = "to_binary_float(to_char(" + string11 + "))";
                    } else if (string13.equals(TYPE_FAM_DOUBLE) && !string15.equals(LTC_TYPE_BDOUBLE)) {
                        string11 = "to_binary_double(to_char(" + string11 + "))";
                    } else if (string13.equals(TYPE_FAM_NUMERIC) && !string15.equals(LTC_TYPE_NUMBER)) {
                        string11 = "to_number(" + string11 + ")";
                    } else {
                        this.log("L_colType matches L_datatype_family: L_colExpr=" + string11);
                    }
                    if (string14.equals(TYPE_FAM_FLOAT) && !string16.equals(LTC_TYPE_BFLOAT)) {
                        string12 = "to_binary_float(to_char(" + string12 + "))";
                    } else if (string14.equals(TYPE_FAM_DOUBLE) && !string16.equals(LTC_TYPE_BDOUBLE)) {
                        string12 = "to_binary_double(to_char(" + string12 + "))";
                    } else if (string14.equals(TYPE_FAM_NUMERIC) && !string16.equals(LTC_TYPE_NUMBER)) {
                        string12 = "to_number(" + string12 + ")";
                    } else {
                        this.log("R_colType matches R_datatype_family: R_colExpr=" + string12);
                    }
                    if (!string13.equals(string14)) {
                        if (string13.equals(TYPE_FAM_NUMERIC)) {
                            string12 = "to_number(" + string12 + ")";
                        } else if (string14.equals(TYPE_FAM_NUMERIC)) {
                            string11 = "to_number(" + string11 + ")";
                        } else {
                            string11 = "to_number(" + string11 + ")";
                            string12 = "to_number(" + string12 + ")";
                        }
                        this.log("L_colExpr=" + string11 + " | R_colExpr=" + string12);
                    }
                } else {
                    if (!list3.get(i).equals("STRING") && !LTC_TYPE_STRING_CLOB.equals(string9)) {
                        string11 = "to_char(" + string11 + ")";
                    }
                    if (!list4.get(i).equals("STRING") && !LTC_TYPE_STRING_CLOB.equals(string10)) {
                        string12 = "to_char(" + string12 + ")";
                    }
                    this.log("L_colExpr=" + string11 + " | R_colExpr=" + string12);
                }
            }
            if (string11.equals(string12)) {
                string8 = string3.equals("!=") || string3.equals(">") || string3.equals("<") || string3.equals("DIFFTERM") ? string8 + " AND 1=0 " : string8 + COND_TRUE;
                this.log("compose_filter2v_opt_condExpr_for_UArow_from_occPos_pairs: identical left and right colExpr: compOper_str: " + string3 + " THEREFORE opt_simcongTFT_filter2v_cond_delta: " + string8);
                continue;
            }
            if (LTC_TYPE_STRING_CLOB.equals(string9) || LTC_TYPE_STRING_CLOB.equals(string10)) {
                this.log("Filter contains a CLOB");
                string8 = string8 + " AND dbms_lob.compare(" + string11 + ", " + string12 + ")" + sqlcompOper_clobCompare_map.get(string3);
                continue;
            }
            string8 = string8 + COND_CONNECTOR + string11 + BASE_PREFIX_COLNAME_SEP + string3 + BASE_PREFIX_COLNAME_SEP + string12;
        }
        if (string8.equals("")) {
            string8 = this.gen_e_z_filter_cond(relExpr, true, false);
        } else if (relExpr.compOperator.equals("!=") || relExpr.compOperator.equals("DIFFTERM")) {
            string8 = string8.equals(COND_TRUE) ? " AND 1=0 " : (string8.equals(" AND 1=0 ") ? COND_TRUE : " AND NOT (" + string8.substring(COND_CONNECTOR.length()) + ")");
        }
        this.log("genFilter2vCond_new: returning opt_simcongTFT_filter2v_cond_delta:" + string8);
        return string8;
    }

    private String compose_filter2v_nonOpt_condExpr_for_UArow_from_occPos_pairs(int n, RelExpr relExpr, String string, String string2, CSRinfo cSRinfo, CSRinfo cSRinfo2) throws RDFException {
        String string3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.log("[compose_filter2v_nonOpt_condExpr_for_UArow_from_occPos_pairs] Entered: relExpr=" + relExpr.getRelExprString() + " L_occInfo=" + string + " R_occInfo=" + string2 + " L_CSRelem.getCSRAlias()=" + cSRinfo.getCSRAlias() + " R_CSRelem.getCSRAlias()=" + cSRinfo2.getCSRAlias());
        int n2 = n % cSRinfo.getUArowsCount();
        String string4 = cSRinfo.sAliasArray.get(n2);
        String string5 = string.split(":")[0];
        int n3 = Integer.valueOf(string.split(":")[1]);
        RRTabRowInfo rRTabRowInfo = cSRinfo.getRRrowInfo(n2, n3);
        MCSR mCSR = cSRinfo.mcsrElem;
        String string6 = null;
        if (string5.equals("subject") && (string6 = ((ACRinfo)(object4 = mCSR.getACRinfo_for_AliasComponentRRrowid(string4, string5, (String)(object3 = this.SubjRRrowid_for_Tmap.get(rRTabRowInfo.Tmap))))).get_ACRexpr()) == null) {
            throw new RDFException("No expr AliasComponentRRrowid: L_sAlias=" + string4 + " L_component=" + string5 + " L_sRRrowid=" + (String)object3 + " L_RRrowInfo.rowid=" + rRTabRowInfo.rowid + " L_po_idx=" + n3 + " L_UArowNum_for_CSR=" + n2);
        }
        this.log("LH: L_sAlias=" + string4 + " L_component=" + string5 + " L_po_idx=" + n3 + " L_UArowNum_for_CSR=" + n2);
        this.log("    L_RRrowInfo.rowid=" + rRTabRowInfo.rowid + " L_mcsr.getMCSRAlias()=" + mCSR.getMCSRAlias() + " L_iUriExpr=" + string6);
        object3 = cSRinfo.pExprArrays;
        object4 = cSRinfo.oExprArrays;
        List<List<String>> list = cSRinfo.clobExprArrays;
        List<String> list2 = cSRinfo.gExprArray;
        int n4 = n % cSRinfo2.getUArowsCount();
        String string7 = cSRinfo2.sAliasArray.get(n4);
        String string8 = string2.split(":")[0];
        int n5 = Integer.valueOf(string2.split(":")[1]);
        RRTabRowInfo rRTabRowInfo2 = cSRinfo2.getRRrowInfo(n4, n5);
        MCSR mCSR2 = cSRinfo2.mcsrElem;
        String string9 = null;
        if (string8.equals("subject") && (string9 = ((ACRinfo)(object2 = mCSR2.getACRinfo_for_AliasComponentRRrowid(string7, string8, (String)(object = this.SubjRRrowid_for_Tmap.get(rRTabRowInfo2.Tmap))))).get_ACRexpr()) == null) {
            throw new RDFException("No expr AliasComponentRRrowid: R_sAlias=" + string7 + " R_component=" + string8 + " R_sRRrowid=" + (String)object + " R_RRrowInfo.rowid=" + rRTabRowInfo2.rowid + " R_po_idx=" + n5 + " R_UArowNum_for_CSR=" + n4);
        }
        this.log("RH: R_sAlias=" + string7 + " R_component=" + string8 + " R_po_idx=" + n5 + " R_UArowNum_for_CSR=" + n4);
        this.log("    R_RRrowInfo.rowid=" + rRTabRowInfo2.rowid + " R_mcsr.getMCSRAlias()=" + mCSR2.getMCSRAlias() + " R_iUriExpr=" + string9);
        object = cSRinfo2.pExprArrays;
        object2 = cSRinfo2.oExprArrays;
        List<List<String>> list3 = cSRinfo2.clobExprArrays;
        List<String> list4 = cSRinfo2.gExprArray;
        String string10 = "";
        String string11 = this.getExprFromArrays(string, n2, string6, (List<List<String>>)object3, (List<List<String>>)object4, list2, null);
        String string12 = this.getExprFromArrays(string2, n4, string9, (List<List<String>>)object, (List<List<String>>)object2, list4, null);
        String string13 = relExpr.compOperator;
        if (string13.equals("SAMETERM")) {
            string13 = "=";
        } else if (string13.equals("DIFFTERM")) {
            string13 = "!=";
        }
        boolean bl = false;
        boolean bl2 = false;
        if (string.startsWith("object:") && !(string3 = list.get(n3).get(n2)).equals("NULL")) {
            bl = true;
            string11 = string3;
            this.log("non_opt_filter2v_cond_delta: found L_clobExpr: " + string3);
        }
        if (string2.startsWith("object:") && !(string3 = list3.get(n5).get(n4)).equals("NULL")) {
            bl2 = true;
            string12 = string3;
            this.log("non_opt_filter2v_cond_delta: found R_clobExpr: " + string3);
        }
        if (string11.equals(string12)) {
            string10 = string13.equals("=") || string13.equals(">=") || string13.equals("<=") || string13.equals("SAMETERM") ? COND_TRUE : " AND 1=0 ";
            this.log("compose_filter2v_nonOpt_condExpr_for_UArow_from_occPos_pairs: identical: L_sqlExpr = R_sqlExpr and compOper_str=" + string13 + " THEREFORE returning non_opt_filter2v_cond_delta=" + string10);
            return string10;
        }
        if (!string13.equals("=") && !string13.equals("!=")) {
            if (string11.indexOf("sem_apis.escape_rdf_value") != -1) {
                string11 = !this.ctx.noTC ? TTL_UNESCAPE_BEG + string11 + ")" : TTL_UNESCAPE_BEG + string11 + ", options=>'NO_TC=T'" + ")";
            } else if (string11.indexOf("sdo_rdf.escape_clob_value") != -1) {
                string11 = TTL_UNESCAPE_CLOB_BEG + string11 + ")";
            }
            if (string12.indexOf("sem_apis.escape_rdf_value") != -1) {
                string12 = !this.ctx.noTC ? TTL_UNESCAPE_BEG + string12 + ")" : TTL_UNESCAPE_BEG + string12 + ", options=>'NO_TC=T'" + ")";
            } else if (string12.indexOf("sdo_rdf.escape_clob_value") != -1) {
                string12 = TTL_UNESCAPE_CLOB_BEG + string12 + ")";
            }
        }
        if (bl || bl2) {
            if (!bl) {
                string11 = "substr(" + string11 + ",2,length(" + string11 + ")-2)";
            } else if (!bl2) {
                string12 = "substr(" + string12 + ",2,length(" + string12 + ")-2)";
            }
            string10 = " AND dbms_lob.compare(" + string11 + ", " + string12 + ")" + sqlcompOper_clobCompare_map.get(string13);
        } else {
            string10 = " AND sdo_rdf.vname(" + string11 + ")" + BASE_PREFIX_COLNAME_SEP + string13 + BASE_PREFIX_COLNAME_SEP + SDO_RDF_VNAME_BEG + string12 + ")";
        }
        this.log("genFilter2vCond_new: returning non_opt_filter2v_cond_delta=" + string10);
        return string10;
    }

    private HashMap<Integer, HashSet<String>> add_subj_to_TFTidx_occInfoSet_pairs(String string, String string2, int n, HashMap<Integer, HashSet<String>> hashMap) {
        HashMap<Integer, HashSet<String>> hashMap2 = hashMap;
        if (string2.equals(string)) {
            this.log("need to add subject occinfo for var=" + string);
            hashMap2 = new HashMap();
            boolean bl = false;
            if (hashMap != null) {
                for (Integer n2 : hashMap.keySet()) {
                    HashSet<String> hashSet = new HashSet<String>();
                    hashMap2.put(n2, hashSet);
                    if (n2 == n) {
                        hashSet.add("subject:0");
                        bl = true;
                    }
                    for (String string3 : hashMap.get(n2)) {
                        hashSet.add(string3);
                    }
                }
            }
            if (!bl) {
                HashSet hashSet = new HashSet();
                hashMap2.put(n, hashSet);
                hashSet.add("subject:0");
                bl = true;
            }
        }
        return hashMap2;
    }

    private MCSR get_MCSR_for_CSRAlias(String string) throws RDFException {
        CSRinfo cSRinfo = this.CSRinfo_for_CSRAlias.get(string);
        MCSR mCSR = cSRinfo.mcsrElem;
        if (mCSR == null) {
            throw new RDFException("internal error: MCSR not found for CSRAlias: " + string);
        }
        return mCSR;
    }

    private String get_MCSRAlias_for_CSRAlias(String string) throws RDFException {
        MCSR mCSR = this.get_MCSR_for_CSRAlias(string);
        return mCSR.getMCSRAlias();
    }

    private Set<MCSR> get_MCSRset_for_CSRAliasSet(Set<String> set) throws RDFException {
        HashSet<MCSR> hashSet = new HashSet<MCSR>();
        for (String string : set) {
            MCSR mCSR = this.get_MCSR_for_CSRAlias(string);
            hashSet.add(mCSR);
        }
        return hashSet;
    }

    private Set<String> get_MCSRAliasSet_for_CSRAliasSet(Set<String> set) throws RDFException {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            String string2 = this.get_MCSRAlias_for_CSRAlias(string);
            hashSet.add(string2);
        }
        return hashSet;
    }

    private Set<String> get_commonCSRAliasSet_for_2vars(String string, String string2) throws RDFException {
        this.log("[get_commonCSRAliasSet_for_2vars] var1= " + string + " var2=" + string2);
        Set<String> set = this.occPosSet_for_CSRAlias_for_var.get(string).keySet();
        Set<String> set2 = this.occPosSet_for_CSRAlias_for_var.get(string2).keySet();
        this.log("[get_commonCSRAliasSet_for_2vars] CSRAliasSet1: " + set + " CSRAliasSet2:" + set2);
        HashSet<String> hashSet = new HashSet<String>(set);
        hashSet.retainAll(set2);
        this.log("[get_commonCSRAliasSet_for_2vars] RETURNING intersection: " + hashSet);
        return hashSet;
    }

    private Set<String> get_commonMCSRAliasSet_for_2vars(String string, String string2) throws RDFException {
        this.log("[get_commonMCSRAliasSet_for_2vars] var1= " + string + " var2=" + string2);
        Set<String> set = this.occPosSet_for_CSRAlias_for_var.get(string).keySet();
        Set<String> set2 = this.occPosSet_for_CSRAlias_for_var.get(string2).keySet();
        this.log("[get_commonMCSRAliasSet_for_2vars] CSRAliasSet1: " + set + " CSRAliasSet2:" + set2);
        Set<String> set3 = this.get_MCSRAliasSet_for_CSRAliasSet(set);
        Set<String> set4 = this.get_MCSRAliasSet_for_CSRAliasSet(set2);
        this.log("[get_commonMCSRAliasSet_for_2vars] MCSRAliasSet1: " + set3 + " MCSRAliasSet2:" + set4);
        HashSet<String> hashSet = new HashSet<String>(set3);
        hashSet.retainAll(set4);
        this.log("[get_commonMCSRAliasSet_for_2vars] RETURNING intersection: " + hashSet);
        return hashSet;
    }

    private List<String> get_BGPvarsList() throws RDFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.varsList_for_CSRAlias.keySet()) {
            for (String string2 : this.varsList_for_CSRAlias.get(string)) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private String genFilter2vCond_new_v2(MCSR mCSR, int n, RelExpr relExpr) throws RDFException {
        Object object;
        Object object2;
        String string;
        Object object3;
        String string2;
        TFTinfo tFTinfo;
        String string32;
        String[] stringArray;
        Object object4;
        String[] stringArray2;
        String string42;
        this.log("Entered: genFilter2vCond_new_v2: UArowNum_for_MCSR=" + n);
        String string5 = null;
        String string6 = relExpr.compOperator;
        String string7 = relExpr.compOperator;
        if (relExpr.compOperator.equals("SAMETERM")) {
            string7 = "=";
        } else if (relExpr.compOperator.equals("DIFFTERM")) {
            string7 = "!=";
        }
        String string8 = relExpr.L_atom.name;
        String string9 = relExpr.R_atom.name;
        this.log("Lvar=" + string8 + " Rvar=" + string9);
        Set<String> set = mCSR.getCSRAliasSet_for_var(string8);
        Set<String> set2 = mCSR.getCSRAliasSet_for_var(string9);
        CSRinfo cSRinfo = null;
        CSRinfo cSRinfo2 = null;
        CSRinfo cSRinfo3 = null;
        CSRinfo cSRinfo4 = null;
        CSRinfo cSRinfo5 = null;
        CSRinfo cSRinfo6 = null;
        CSRinfo cSRinfo7 = null;
        CSRinfo cSRinfo8 = null;
        int n2 = -1;
        int n3 = -1;
        Set<String> set3 = null;
        Set<String> set4 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        int n4 = -1;
        int n5 = -1;
        RRTabRowInfo rRTabRowInfo = null;
        RRTabRowInfo rRTabRowInfo2 = null;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        boolean bl = false;
        int n13 = 9999;
        int n14 = 9999;
        for (String string42 : set) {
            this.log("[genFilter2vCond_new_v2]       lCSRAlias=" + string42);
            cSRinfo = this.CSRinfo_for_CSRAlias.get(string42);
            n2 = n % cSRinfo.getUArowsCount();
            set3 = this.occPosSet_for_CSRAlias_for_var.get(string8).get(string42);
            this.log("lOccPosSet for Lvar=" + string8 + ": " + set3);
            string10 = set3.iterator().next();
            stringArray2 = string10.split(":");
            string12 = stringArray2[0];
            n4 = Integer.valueOf(stringArray2[1]);
            rRTabRowInfo = cSRinfo.getRRrowInfo(n2, n4);
            this.log("[genFilter2vCond_new_v2]       lrowid=" + rRTabRowInfo.rowid);
            n6 = rRTabRowInfo.getTFTidx(string12);
            object4 = this.TFTinfoGlobalList.get(n6);
            this.log("[genFilter2vCond_new_v2]       lTFTidx=" + n6);
            if (((TFTinfo)object4).numCols == 0) {
                n8 = n6;
                cSRinfo3 = cSRinfo;
            }
            stringArray = this.noTFTglobalList.get(n6);
            for (String string32 : set2) {
                this.log("[genFilter2vCond_new_v2]       ---   rCSRAlias=" + string32);
                cSRinfo2 = this.CSRinfo_for_CSRAlias.get(string32);
                n3 = n % cSRinfo2.getUArowsCount();
                set4 = this.occPosSet_for_CSRAlias_for_var.get(string9).get(string32);
                this.log("rOccPosSet for Rvar=" + string9 + ": " + set4);
                string11 = set4.iterator().next();
                String[] stringArray3 = string11.split(":");
                string13 = stringArray3[0];
                n5 = Integer.valueOf(stringArray3[1]);
                rRTabRowInfo2 = cSRinfo2.getRRrowInfo(n3, n5);
                this.log("[genFilter2vCond_new_v2]       ---   rrowid=" + rRTabRowInfo2.rowid);
                n7 = rRTabRowInfo2.getTFTidx(string13);
                tFTinfo = this.TFTinfoGlobalList.get(n7);
                this.log("[genFilter2vCond_new_v2]       ---   rTFTidx=" + n7);
                if (((TFTinfo)object4).exprType == RRTabRowInfo.MapExprType_CONSTANT && tFTinfo.exprType == RRTabRowInfo.MapExprType_CONSTANT) {
                    this.log("Two constant-valued mappings => matchable? " + (n6 == n7));
                    if ((relExpr.eqBasedComp || n6 == n7 && ((TFTinfo)object4).termType.equals(rrLiteral)) && (string2 = this.gen_e_z_filter_cond(relExpr, n6 == n7, false)).length() > 0) {
                        return string2;
                    }
                }
                if (tFTinfo.numCols == 0) {
                    n9 = n7;
                    cSRinfo4 = cSRinfo2;
                }
                if (n6 == n7 && ((TFTinfo)object4).numCols < n14) {
                    n10 = n6;
                    cSRinfo5 = cSRinfo;
                    cSRinfo6 = cSRinfo2;
                }
                if (!stringArray.equals(string2 = this.noTFTglobalList.get(n7))) continue;
                List<String> list = ((TFTinfo)object4).colTypeList;
                object3 = tFTinfo.colTypeList;
                int n15 = list.size();
                int n16 = 0;
                for (int i = 0; i < n15; ++i) {
                    string = list.get(i);
                    if (string.equals(object2 = object3.get(i))) continue;
                    ++n16;
                    if (string.equals("STRING") || ((String)object2).equals("STRING") || (string.equals(LTC_TYPE_NUMBER) || string.equals(LTC_TYPE_BFLOAT) || string.equals(LTC_TYPE_BDOUBLE)) && (((String)object2).equals(LTC_TYPE_NUMBER) || ((String)object2).equals(LTC_TYPE_BFLOAT) || ((String)object2).equals(LTC_TYPE_BDOUBLE))) continue;
                    this.log("NOT-MATCHABLE: both NON-STRING and not-NFD-NFD: (" + string + "," + (String)object2 + ")");
                    object = this.gen_e_z_filter_cond(relExpr, false, false);
                    if (((String)object).length() <= 0) continue;
                    return object;
                }
                if (n15 + n16 >= n13) continue;
                n11 = n6;
                n12 = n7;
                cSRinfo7 = cSRinfo;
                cSRinfo8 = cSRinfo2;
                n13 = n15 + n16;
            }
        }
        Object object5 = null;
        this.log("Chosing the best pair of TFTs:");
        if (n8 >= 0 || n9 >= 0) {
            this.log("   One of the TFTs is a constant");
            object5 = "CONSTANT_TFT";
            if (n8 >= 0) {
                this.log("      the left TFT=" + n8 + "is a constant");
                n6 = n8;
                cSRinfo = cSRinfo3;
            }
            if (n9 >= 0) {
                this.log("      the right TFT=" + n9 + "is a constant");
                n7 = n9;
                cSRinfo2 = cSRinfo4;
            }
        } else if (n10 >= 0) {
            this.log("   The TFTs are the same");
            object5 = "SAME_TFT";
            n6 = n10;
            cSRinfo = cSRinfo5;
            n7 = n10;
            cSRinfo2 = cSRinfo6;
        } else if (n11 >= 0 && n12 >= 0) {
            this.log("   The TFTs are similar");
            object5 = "SIMILAR_TFT";
            n6 = n11;
            cSRinfo = cSRinfo7;
            n7 = n12;
            cSRinfo2 = cSRinfo8;
        }
        this.log("Chosing criteria: " + (String)object5);
        this.log("Chosen TFTs: lTFTidx=" + n6 + "\t rTFTidx=" + n7);
        string42 = cSRinfo.getCSRAlias();
        n2 = n % cSRinfo.getUArowsCount();
        set3 = this.occPosSet_for_CSRAlias_for_var.get(string8).get(string42);
        string10 = set3.iterator().next();
        stringArray2 = string10.split(":");
        string12 = stringArray2[0];
        n4 = Integer.valueOf(stringArray2[1]);
        rRTabRowInfo = cSRinfo.getRRrowInfo(n2, n4);
        object4 = cSRinfo2.getCSRAlias();
        n3 = n % cSRinfo2.getUArowsCount();
        this.log("occPosSet_for_CSRAlias_for_var:" + this.occPosSet_for_CSRAlias_for_var);
        this.log("Rvar:" + string9);
        this.log("rCSRAlias:" + (String)object4);
        set4 = this.occPosSet_for_CSRAlias_for_var.get(string9).get(object4);
        this.log("rOccPosSet:" + set4);
        string11 = set4.iterator().next();
        stringArray = string11.split(":");
        string13 = stringArray[0];
        n5 = Integer.valueOf(stringArray[1]);
        rRTabRowInfo2 = cSRinfo2.getRRrowInfo(n3, n5);
        this.log("Chosen CSR, occPos & TFT: ");
        this.log(" lCSRAlias= " + string42 + "\t rCSRAlias=" + (String)object4);
        this.log("   lOccPos= " + string10 + "\t rOccPos=" + string11);
        this.log("   lTFTidx= " + n6 + "\t rTFTidx=" + n7);
        this.log(" lCSRelem.getCSRAlias()" + cSRinfo.getCSRAlias() + " rCSRelem.getCSRAlias()=" + cSRinfo2.getCSRAlias());
        TFTinfo tFTinfo2 = this.TFTinfoGlobalList.get(n6);
        string32 = this.TFTglobalList.get(n6);
        char c = string32.charAt(0);
        tFTinfo = this.TFTinfoGlobalList.get(n7);
        string2 = this.TFTglobalList.get(n7);
        char c2 = string2.charAt(0);
        this.log("comparing:\nL_TFTinfo=" + tFTinfo2.toString() + "\nR_TFTinfo=" + tFTinfo.toString());
        if (!tFTinfo2.termType.equals(tFTinfo.termType)) {
            this.log("termType mismatch in two-var filter");
            if (string6.equals("!=") || string6.equals("DIFFTERM")) {
                this.log("termType mismatch: compOperator=" + string6 + ": returning COND_TRUE ");
                return COND_TRUE;
            }
            this.log("termType mismatch: compOperator=" + string6 + ": returning COND_FALSE ");
            return " AND 1=0 ";
        }
        if (tFTinfo2.termType.equals(rrIRI)) {
            this.log("termType mismatch in two-var filter");
            if (string6.equals("=") || string6.equals("SAMETERM") || string6.equals("!=") || string6.equals("DIFFTERM")) {
                this.log("both termTypes are URIs: compOperator= \"" + string6 + "\": is allowed ");
            } else {
                this.log("both termTypes are URIs: compOperator= \"" + string6 + "\": CANNOT BE MATCHED: returning COND_FALSE ");
                return " AND 1=0 ";
            }
        }
        object3 = null;
        TFTinfo tFTinfo3 = null;
        CSRinfo cSRinfo9 = null;
        Set<String> set5 = null;
        string = null;
        object2 = null;
        object = null;
        int n17 = -1;
        Object object6 = null;
        CSRinfo cSRinfo10 = null;
        RRTabRowInfo rRTabRowInfo3 = null;
        String string14 = null;
        int n18 = -1;
        int n19 = -1;
        boolean bl2 = false;
        if (tFTinfo.numCols == 0) {
            if (tFTinfo2.numCols == 0) {
                this.log("found the both-constant mapping case for L and R variables");
                string5 = string6.equals("!=") || string6.equals("DIFFTERM") ? (tFTinfo2.strList.get(0).equals(tFTinfo.strList.get(0)) ? " AND 1=0 " : COND_TRUE) : (string6.equals("=") || string6.equals("SAMETERM") ? (tFTinfo2.strList.get(0).equals(tFTinfo.strList.get(0)) ? COND_TRUE : " AND 1=0 ") : " AND sdo_rdf.tuesc('" + tFTinfo2.strList.get(0) + "') " + string7 + " sdo_rdf.tuesc('" + tFTinfo.strList.get(0) + "') ");
                this.log("both-constant mapping case: returning condExpr: " + string5);
                return string5;
            }
            object6 = tFTinfo;
            cSRinfo10 = cSRinfo2;
            rRTabRowInfo3 = rRTabRowInfo2;
            string14 = string11;
            n18 = n5;
            n19 = n3;
            object3 = relExpr.L_atom;
            tFTinfo3 = tFTinfo2;
            cSRinfo9 = cSRinfo;
            set5 = this.occPosSet_for_CSRAlias_for_var.get(string8).get(cSRinfo.getCSRAlias());
            string = string10;
            object2 = rRTabRowInfo;
            n17 = n2;
            object = cSRinfo.getRRrowInfo(n2, n4);
        } else if (tFTinfo2.numCols == 0) {
            bl2 = true;
            object6 = tFTinfo2;
            cSRinfo10 = cSRinfo;
            rRTabRowInfo3 = rRTabRowInfo;
            string14 = string10;
            n18 = n4;
            n19 = n2;
            object3 = relExpr.R_atom;
            tFTinfo3 = tFTinfo;
            cSRinfo9 = cSRinfo2;
            set5 = this.occPosSet_for_CSRAlias_for_var.get(string9).get(cSRinfo2.getCSRAlias());
            string = string11;
            object2 = rRTabRowInfo2;
            n17 = n3;
            object = cSRinfo2.getRRrowInfo(n3, n5);
        }
        if (string != null) {
            String string15;
            String string16 = string.substring(0, string.indexOf(58));
            int n20 = Integer.parseInt(string.substring(string.indexOf(58) + 1, string.length()));
            int n21 = -1;
            if (string16.equals("subject")) {
                string15 = object2;
                n21 = 0;
            } else {
                string15 = object2;
                if (string16.equals("predicate")) {
                    n21 = 1;
                } else if (string16.equals("object")) {
                    n21 = ((RRTabRowInfo)((Object)string15)).paTmap != null ? 4 : 2;
                } else if (string16.equals("graph")) {
                    n21 = 3;
                }
            }
            ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
            aSTTripleAtom.name = ((TFTinfo)object6).strList.get(0);
            if (((TFTinfo)object6).termType.equals(rrIRI)) {
                aSTTripleAtom.type = 1;
            } else if (((TFTinfo)object6).termType.equals(rrBlankNode)) {
                aSTTripleAtom.type = 11;
            } else if (((TFTinfo)object6).termType.equals(rrLiteral)) {
                if (((TFTinfo)object6).datatype_family.equals("STRING")) {
                    if (((TFTinfo)object6).language == null) {
                        aSTTripleAtom.type = 3;
                    } else {
                        aSTTripleAtom.litLang = ((TFTinfo)object6).language;
                        aSTTripleAtom.type = 4;
                    }
                } else if (((TFTinfo)object6).datatype_family.equals(TYPE_FAM_NUMERIC) || ((TFTinfo)object6).datatype_family.equals(TYPE_FAM_FLOAT) || ((TFTinfo)object6).datatype_family.equals(TYPE_FAM_DOUBLE)) {
                    aSTTripleAtom.litType = ((TFTinfo)object6).datatype.substring(1, ((TFTinfo)object6).datatype.length() - 1);
                    aSTTripleAtom.type = 2;
                } else {
                    aSTTripleAtom.litType = ((TFTinfo)object6).datatype.substring(1, ((TFTinfo)object6).datatype.length() - 1);
                    aSTTripleAtom.type = 5;
                }
            }
            this.log("constructed term_atom: " + aSTTripleAtom.toString());
            RelExpr relExpr2 = null;
            if (bl2) {
                relExpr2 = new RelExpr(aSTTripleAtom, relExpr.compOperator, new ASTTripleAtom[]{object3}, relExpr.filterExprTree, 1L);
                relExpr2.InvertRelExpr();
            } else {
                relExpr2 = new RelExpr((ASTTripleAtom)object3, relExpr.compOperator, new ASTTripleAtom[]{aSTTripleAtom}, relExpr.filterExprTree, 1L);
            }
            String string17 = this.getExprFromArrays(string, n19, cSRinfo10.CSR_subj, cSRinfo10.pExprArrays, cSRinfo10.oExprArrays, cSRinfo10.gExprArray, null);
            this.log("sqlExpr: " + string17);
            string5 = this.genFilterCond_new(relExpr2, (RRTabRowInfo)((Object)string15), n21, string17, cSRinfo9.sAliasArray.get(n17));
            this.log("condExpr=" + string5);
            return string5;
        }
        string5 = this.genFilter2vCond_new(mCSR, n, relExpr, n6, n7, string10, string11, cSRinfo, cSRinfo2, rRTabRowInfo, rRTabRowInfo2, (String)object5);
        return string5;
    }

    private String genFilter2vCond_new(MCSR mCSR, int n, RelExpr relExpr, int n2, int n3, String string, String string2, CSRinfo cSRinfo, CSRinfo cSRinfo2, RRTabRowInfo rRTabRowInfo, RRTabRowInfo rRTabRowInfo2, String string3) throws RDFException {
        String string4;
        this.log("Entered: genFilter2vCond_new: UArowNum=" + n + " TFTidxPair_Choice_Type=" + string3);
        this.log("                            : relExpr.getRelExprString()=" + relExpr.getRelExprString());
        this.log("                            :                   L_TFTidx=" + n2 + "   R_TFTidx=" + n3 + "   TFTidxPair_Choice_Type=" + string3);
        this.log("                            :           chosen_L_occInfo=" + string + " chosen_R_occInfo=" + string2);
        boolean bl = true;
        boolean bl2 = false;
        String string5 = "";
        String string6 = "";
        this.log("TFTglobalList=" + this.TFTglobalList);
        String string7 = this.TFTglobalList.get(n2);
        TFTinfo tFTinfo = this.TFTinfoGlobalList.get(n2);
        char c = string7.charAt(0);
        String string8 = this.TFTglobalList.get(n3);
        TFTinfo tFTinfo2 = this.TFTinfoGlobalList.get(n3);
        char c2 = string8.charAt(0);
        this.log("comparing: L_TFT=" + string7 + " R_TFT=" + string8);
        this.log("comparing:\n L_TFTinfo=" + tFTinfo.toString() + "\n R_TFTinfo=" + tFTinfo2.toString());
        this.log("relExpr.eqBasedComp=" + relExpr.eqBasedComp);
        if (!relExpr.eqBasedComp) {
            this.log("// *CASE: compOperator is in {>, >=, <, <=}");
            if (c != c2 || c == 'U' && c2 == 'U') {
                this.log("  not-comparable: because of distinct termType letters or both are URIs: " + c + " vs. " + c2);
                bl = false;
                bl2 = true;
                return this.gen_e_z_termType_based_cond(relExpr, true);
            }
            string4 = tFTinfo.termType;
            if (string4.equals(rrLiteral)) {
                if (!(tFTinfo.datatype_family == null || tFTinfo2.datatype_family == null || tFTinfo.datatype_family.equals(tFTinfo2.datatype_family) || this.isNumFltDbl(tFTinfo.datatype_family) && this.isNumFltDbl(tFTinfo2.datatype_family))) {
                    this.log("  not-comparable: because of distinct non-compatible datatype_family");
                    bl = false;
                    bl2 = true;
                    return this.gen_e_z_datatype_based_cond(relExpr, true, true, true);
                }
                if (tFTinfo.language != null && tFTinfo2.language != null && !tFTinfo.language.equals(tFTinfo2.language)) {
                    this.log("  not-comparable: because of distinct non-compatible language tags: " + tFTinfo.language + " and " + tFTinfo2.language);
                    bl = false;
                    bl2 = true;
                    return this.gen_e_z_termType_based_cond(relExpr, true);
                }
            }
        } else {
            this.log("// *CASE: compOperator is in {=,!=, SAMETERM, !SAMETERM}: " + relExpr.compOperator);
            if (string7.charAt(0) == 'L') {
                if (tFTinfo.datatype_family != null && tFTinfo2.datatype_family != null && !tFTinfo.datatype_family.equals(tFTinfo2.datatype_family)) {
                    this.log("L_TFTinfo.datatype_family=" + tFTinfo.datatype_family + " R_TFTinfo.datatype_family=" + tFTinfo2.datatype_family);
                    if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                        String string9 = relExpr.compOperator.equals("SAMETERM") ? " AND 1=0 " : COND_TRUE;
                        return string9;
                    }
                    if ((relExpr.compOperator.equals("=") || relExpr.compOperator.equals("!=")) && (tFTinfo.datatype_family.equals(TYPE_FAM_NUMERIC) || tFTinfo.datatype_family.equals(TYPE_FAM_FLOAT) || tFTinfo.datatype_family.equals(TYPE_FAM_DOUBLE)) && (tFTinfo2.datatype_family.equals(TYPE_FAM_NUMERIC) || tFTinfo2.datatype_family.equals(TYPE_FAM_FLOAT) || tFTinfo2.datatype_family.equals(TYPE_FAM_DOUBLE))) {
                        bl = true;
                        bl2 = false;
                    } else {
                        bl = false;
                        if (!relExpr.eqBasedComp) {
                            bl2 = true;
                        }
                    }
                } else if (tFTinfo.language != null && tFTinfo2.language != null && !tFTinfo.language.equals(tFTinfo2.language)) {
                    this.log("L_TFTinfo.language=" + tFTinfo.language + " R_TFTinfo.language=" + tFTinfo2.language);
                    String string10 = relExpr.compOperator.equals("=") || relExpr.compOperator.equals("SAMETERM") ? " AND 1=0 " : COND_TRUE;
                    this.log("language mismatch: relExpr.compOperator=" + relExpr.compOperator + " RETURN condExpr=" + string10);
                    return string10;
                }
            }
        }
        if (!bl) {
            this.log("NOT-MATCHABLE: possible notComparable? " + bl2);
            string4 = this.gen_e_z_filter_cond(relExpr, bl, bl2);
            if (string4.length() > 0) {
                return string4;
            }
        }
        string4 = "NON_DEFINED_FILTER2VCOND";
        if ("SAME_TFT".equals(string3)) {
            this.log("SAME_TFT case: L_TFTidx=" + n2 + " R_TFTidx=" + n3);
            int n4 = n2;
            this.log("COMMON-TFT case: chosen_L_occInfo=" + string + " chosen_R_occInfo=" + string2);
            this.log("TFTinfoGlobalList.get(chosen_TFTidx)=" + this.TFTinfoGlobalList.get(n4));
            this.log("TFTinfoGlobalList.get(chosen_TFTidx).ieq_optimizable=" + this.TFTinfoGlobalList.get((int)n4).ieq_optimizable);
            this.log("relExpr.compOperator: " + relExpr.compOperator);
            if (!relExpr.eqBasedComp && !this.TFTinfoGlobalList.get((int)n4).ieq_optimizable || relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                String string11 = this.compose_filter2v_nonOpt_condExpr_for_UArow_from_occPos_pairs(n, relExpr, string, string2, cSRinfo, cSRinfo2);
                this.log("COMMON-TFT case: nonOpt cond: " + string11);
                return string11;
            }
            String string12 = this.compose_filter2v_opt_condExpr_for_UArow_from_occPos_pairs(n, relExpr, n4, n4, string, string2, rRTabRowInfo, rRTabRowInfo2, cSRinfo, cSRinfo2);
            this.log("COMMON-TFT case: opt cond: " + string12);
            return string12;
        }
        if ("SIMILAR_TFT".equals(string3)) {
            int n5 = n2;
            int n6 = n3;
            this.log("SIMILAR-TFT case: chosen_L_occInfo=" + string + " chosen_R_occInfo=" + string2);
            TFTinfo tFTinfo3 = this.TFTinfoGlobalList.get(n5);
            TFTinfo tFTinfo4 = this.TFTinfoGlobalList.get(n6);
            if (!(relExpr.eqBasedComp || this.noTFTglobalList.get(n5).equals(this.noTFTglobalList.get(n6)) && tFTinfo3.ieq_optimizable && tFTinfo4.ieq_optimizable)) {
                String string13 = this.compose_filter2v_nonOpt_condExpr_for_UArow_from_occPos_pairs(n, relExpr, string, string2, cSRinfo, cSRinfo2);
                this.log("SIMILAR-TFT case: nonOpt cond: " + string13);
                return string13;
            }
            this.log("optimized similar TFTs case");
            String string14 = this.compose_filter2v_opt_condExpr_for_UArow_from_occPos_pairs(n, relExpr, n5, n6, string, string2, rRTabRowInfo, rRTabRowInfo2, cSRinfo, cSRinfo2);
            this.log("SIMILAR-TFT case: opt cond: " + string14);
            return string14;
        }
        if ("CONSTANT_TFT".equals(string3)) {
            string4 = "CONSTANT_TFT";
            throw new RDFException("genFilter2vCond_new: This condition should have been hanlded in genFilter2vCond_new_v2 \nL_RRrowInfo.rowid=" + rRTabRowInfo.rowid + " R_RRrowInfo.rowid=" + rRTabRowInfo2.rowid + "\nrelExpr.getRelExprString()=" + relExpr.getRelExprString() + "\nL_TFTidx=" + n2 + "   R_TFTidx=" + n3 + "\nchosen_L_occInfo=" + string + " chosen_R_occInfo=" + string2);
        }
        int n7 = n2;
        int n8 = n3;
        this.log("Non-similar TFTs: chosen_L_TFTidx=" + n7 + " chosen_R_TFTidx=" + n8);
        this.log("Non-similar TFTs: chosen_L_occInfo=" + string + " chosen_R_occInfo=" + string2);
        this.log("                : L_CSRelem.getCSRAlias()=" + cSRinfo.getCSRAlias() + " R_CSRelem.getCSRAlias()=" + cSRinfo2.getCSRAlias());
        String string15 = this.compose_filter2v_nonOpt_condExpr_for_UArow_from_occPos_pairs(n, relExpr, string, string2, cSRinfo, cSRinfo2);
        this.log("genFilter2vCond_new: returning non_opt_filter2v_cond_delta=" + string15);
        string4 = string15;
        return string4;
    }

    private String genFilter_v3(MCSR mCSR, String string, String string2, int n, RRTabRowInfo rRTabRowInfo, String string3, NatVarOpt_Info natVarOpt_Info, RelExpr relExpr, Set<String> set, List<List<String>> list, List<List<String>> list2) throws RDFException {
        this.log("[GFV3 genFilter_v3] procAtLevel=" + string + "  CSRAlias=" + string2 + "  abs_rowNum=" + n);
        Filter filter = relExpr.filterExprTree;
        this.log("[GFV3 genFilter_v3] " + filter.getFilterTree());
        HashSet<String> hashSet = new HashSet<String>(filter.getVars());
        int n2 = hashSet.size();
        this.log("[GFV3]     genFilter_v3 filterVars: " + hashSet);
        String string4 = "FULL_PROCESSING";
        if (!string.equals("OUTER_LEVEL")) {
            this.log("[GFV3]              varsSetInScope: " + set);
            hashSet.removeAll(set);
            this.log("[GFV3] after difference filterVars.size(): " + hashSet.size());
            if (hashSet.size() > 0) {
                if (hashSet.size() == n2) {
                    this.log("Skip cond generation at this level because there are variables out of this scope - extra vars are: " + hashSet);
                    return "";
                }
                string4 = "VALIDATION_ONLY";
                this.log("Downgrade mode to " + string4 + ": validate mapping for filter vars present in this scope (still Skip cond generation at this level because there are variables out of this scope - extra vars are: " + hashSet + ")");
            } else {
                relExpr.procAtLevel = string;
            }
        }
        Stack<Node> stack = new Stack<Node>();
        Node node = filter.getFilterTree();
        int n3 = 0;
        n3 = relExpr.isNegated() ? relExpr.getNotNegatedFilterLevel() - 1 : relExpr.getNotNegatedFilterLevel();
        this.log("[GFV3] relExpr " + relExpr.toString());
        this.log("[GFV3] Negation is " + (relExpr.isNegated() ? "ON" : "OFF") + " ... " + (n3 - 1) + " levels to skip");
        while (n3 > 0) {
            --n3;
            this.log("[GFV3]  ... Skipping negation level: " + ((SimpleNode)node).toString());
            node = node.jjtGetChild(1);
        }
        this.log("[GFV3] Innermost negated level: " + ((SimpleNode)node).toString());
        SpatialFilterHandler spatialFilterHandler = new SpatialFilterHandler(this.ctx, this.ctx.strictOGC);
        SimpleNode simpleNode = null;
        String string5 = null;
        if (relExpr.isNegated()) {
            simpleNode = (ASTUnaryOperator)node.jjtGetChild(0);
            string5 = ((ASTUnaryOperator)simpleNode).name;
            this.log("[GFV3] Unary operator name : " + string5);
        } else {
            simpleNode = (ASTTripleAtom)node.jjtGetChild(0);
            string5 = ((ASTTripleAtom)simpleNode).name;
            this.log("[GFV3] Geo function name : " + string5);
        }
        String string6 = null;
        if (geo_functionArgsMap.containsKey(string5)) {
            string6 = geo_functionArgsMap.get(string5).get(0);
            if (string6 == null) {
                this.log("[GFV3] Undefined function type: " + string5);
                throw new RDFException("Undefined function expected type");
            }
        } else {
            this.log("[GFV3] Undefined function signature: " + string5);
            throw new RDFException("Undefined function signature: " + string5);
        }
        this.log("[GFV3] Top level function : " + simpleNode.toString() + ": " + string6);
        String string7 = "";
        try {
            R2R2MatSPARQLFilterMap r2R2MatSPARQLFilterMap = this.genFilter_v3_expWalker(mCSR, string4, string, node, string6, stack, spatialFilterHandler, string2, n, rRTabRowInfo, string3, set, natVarOpt_Info, list, list2);
            if (r2R2MatSPARQLFilterMap != null) {
                string7 = r2R2MatSPARQLFilterMap.getNodeFilterSQL();
                this.log("[GFV3] sqlFilterExpression: " + string7);
            } else {
                this.log("[GFV3] validation successful for the this filter");
            }
        }
        catch (SpatialArgTypeException spatialArgTypeException) {
            this.log("[GFV3] SpatialArgTypeException: " + spatialArgTypeException.getMessage());
            string7 = " AND 1=0 ";
        }
        catch (RDFException rDFException) {
            this.log("[GFV3] RDFException: " + rDFException.getMessage());
            rDFException.printStackTrace();
            throw new RDFException(rDFException.getMessage());
        }
        return string7;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private R2R2MatSPARQLFilterMap genFilter_v3_expWalker(MCSR var1_1, String var2_2, String var3_3, Node var4_4, String var5_5, Stack<Node> var6_6, SpatialFilterHandler var7_7, String var8_8, int var9_9, RRTabRowInfo var10_10, String var11_11, Set<String> var12_12, NatVarOpt_Info var13_13, List<List<String>> var14_14, List<List<String>> var15_15) throws RDFException, SpatialArgTypeException {
        block61: {
            block65: {
                block60: {
                    this.log("========> genFilter_v3_expWalker called: callStackLevel=" + var6_6.size());
                    var6_6.push(var4_4);
                    var16_16 = "";
                    var17_17 = this.TYPE_FAMILY(var5_5);
                    var18_18 = "";
                    for (var19_19 = 0; var19_19 < var6_6.size(); ++var19_19) {
                        var18_18 = var18_18 + "  ";
                    }
                    this.log("[GFV3W] " + var18_18 + " genFilter_v3_expWalker for node:" + var4_4.toString());
                    this.log("[GFV3W] " + var18_18 + "     numchildren: " + var4_4.jjtGetNumChildren());
                    this.log("[GFV3W] " + var18_18 + "    expectedType: " + var5_5);
                    this.log("[GFV3W] " + var18_18 + " expectedTypeFam: " + var17_17);
                    this.log("[GFV3W] " + var18_18 + "        CSRAlias: " + var8_8);
                    var19_20 = null;
                    var20_21 = null;
                    var21_22 = null;
                    var22_23 = "'EMPTY'";
                    var23_24 = "'EMPTY'";
                    var24_25 = var22_23 + " || " + var23_24;
                    if (var4_4.jjtGetNumChildren() != 0) break block60;
                    var25_26 = (ASTTripleAtom)var4_4;
                    this.log("[GFV3W] " + var18_18 + "            LEAF: " + ((SimpleNode)var4_4).dumpToStr(""));
                    this.log("[GFV3W] " + var18_18 + "           CLASS: " + var4_4.getClass());
                    this.log("[GFV3W]");
                    var21_22 = var25_26.litType != null ? this.TYPE_FAMILY(var25_26.litType) : null;
                    var26_28 = "MAPPING_COL_NAME_EXCEPTION";
                    var27_30 = "MAPPING_COL_TYPE_EXCEPTION";
                    var28_32 = -1;
                    var29_34 = -1;
                    var30_36 = -1;
                    var20_21 = null;
                    var31_38 = null;
                    if (var2_2.equals("VALIDATION_ONLY") && var25_26.type != 0) {
                        this.log("Validation skipped for non-var atom: " + var25_26.name);
                        return null;
                    }
                    switch (var25_26.type) {
                        case 0: {
                            var32_40 = "''";
                            var33_44 = null;
                            var34_47 = "";
                            this.log("[GFV3W] " + var18_18 + " VAR-ATOM: ASTTripleAtom.ATOM_TYPE_VAR: " + 0);
                            if (!var3_3.equals("OUTER_LEVEL")) {
                                this.log("[GFV3W] " + var18_18 + " running TPAT or UAROW condition handling");
                                if (var2_2.equals("VALIDATION_ONLY") && var12_12 != null && !var12_12.contains(var25_26.name)) {
                                    this.log("[GFV3W] " + var18_18 + " This variable (" + var25_26.name + ") is NOT present in current scope (" + var3_3 + "): SKIP VALIDATION for this var");
                                    return null;
                                }
                                var35_49 = null;
                                var36_52 = null;
                                var37_55 = null;
                                this.log("[GFV3W] " + var18_18 + " Looking for the CSR that holds the variable " + var25_26.name);
                                for (String var39_62 : var1_1.getCSRKeyList()) {
                                    var37_55 = this.CSRinfo_for_CSRkey.get(var39_62);
                                    this.log("  [GFV3W] " + var18_18 + " at CSRAlias=" + var37_55.getCSRAlias());
                                    var35_49 = this.FullOccInfo_for_VarPlusCSRAlias.get(var25_26.name + "+" + var37_55.getCSRAlias());
                                    if (var35_49 == null) continue;
                                    this.log("    [GFV3W] " + var18_18 + " FOUND at CSRAlias=" + var37_55.getCSRAlias());
                                    break;
                                }
                                if (var37_55 == null) {
                                    throw new RDFException("No CSR holding var " + var25_26.name);
                                }
                                var36_52 = var35_49.substring(1).split("\\+")[0];
                                if (!"TPAT_LEVEL".equals(var3_3)) {
                                    var38_59 = var9_9 % var37_55.getUArowsCount();
                                    var8_8 = var37_55.sAliasArray.get(var38_59);
                                    this.log("[GFV3W] " + var18_18 + " CSRAlias from sAliasArray: " + var8_8);
                                    var11_11 = var37_55.RRrLArray.get(var38_59);
                                    this.log("[GFV3W] " + var18_18 + "         RRrL from CSRelem: " + var11_11);
                                }
                                this.log("[GFV3W] " + var18_18 + " occInfo for atom.name=" + var25_26.name + " is: " + var36_52);
                                var38_58 = var36_52.split(":")[0];
                                var39_63 = Integer.parseInt(var36_52.split(":")[1]);
                                var40_65 = null;
                                if (var10_10 != null) {
                                    var40_65 = var10_10;
                                } else {
                                    var41_67 /* !! */  = var11_11.substring(1, var11_11.length()).split(":");
                                    var42_68 = new ArrayList<String>(Arrays.asList(var41_67 /* !! */ ));
                                    var40_65 = this.RRrowInfo_for_MatchingRow.get(var42_68.get(var39_63));
                                }
                                this.log("[GFV3W] " + var18_18 + " RRrowInfo for occInfo=" + var36_52 + " is: ");
                                this.log("[GFV3W] " + var18_18 + " [RRrowInfo] " + var40_65.toString().toString().replaceAll("\n", "\n[GFV3W] [RRrowInfo] " + var18_18 + " "));
                                var28_32 = RelationalBGP.convert_comp_name_to_comp_idx(var38_58, var40_65.paTmap);
                                this.log("[GFV3W] " + var18_18 + " position in triple pattern: " + (String)var38_58 + " comp_idx: " + var28_32);
                                if (var28_32 != 2) {
                                    throw new RDFException("Not handled yet: Variable used in GeoSparql filter appears in position other than object: " + (String)var38_58);
                                }
                                var41_67 /* !! */  = var40_65.exprTypes.get(var28_32);
                                this.log("[GFV3W] " + var18_18 + " expression type: " + var41_67 /* !! */ );
                                if (var41_67 /* !! */  != RRTabRowInfo.MapExprType_COLUMN) {
                                    throw new SpatialArgTypeException(" (for NOW) returning COND_FALSE: Variable (" + var25_26.name + ") used in GeoSparql filter has non-COLUMN mapping: " + var41_67 /* !! */ );
                                }
                                var42_68 = var40_65.termTypes.get(var28_32);
                                var43_69 = var40_65.strLists.get(var28_32);
                                var44_70 = var40_65.colLists.get(var28_32);
                                var45_71 = var40_65.colTypeLists.get(var28_32);
                                var46_72 = var40_65.oDataType;
                                var29_34 = 0;
                                var27_30 = var45_71.get(var29_34);
                                var26_28 = var44_70.get(var29_34);
                                this.log("[GFV3W] " + var18_18 + " colName: " + var26_28);
                                this.log("[GFV3W] " + var18_18 + " colType: " + var27_30);
                                this.log("[GFV3W] " + var18_18 + " expectedTypeFam: " + var17_17);
                                if (var17_17.equals("SDO_GEOMETRY") != false && "SDO_GEOMETRY".equals(var27_30) != false || var17_17.equals("BOOLEAN") != false && "BOOLEAN".equals(var27_30) != false || var17_17.equals("STRING") != false && "STRING".equals(var27_30) != false || var17_17.equals("NUMERIC") && "NUMBER".equals(var27_30)) {
                                    var20_21 = var5_5;
                                    if (!this.DatatypeFam_for_var.containsKey(var25_26.name)) {
                                        this.DatatypeFam_for_var.put(var25_26.name, var17_17);
                                        this.log("added to DatatypeFam_for_var: " + this.DatatypeFam_for_var);
                                    } else if (!var17_17.equals(this.DatatypeFam_for_var.get(var25_26.name))) {
                                        this.log("var " + var25_26.name + " is already categorized as type " + this.DatatypeFam_for_var.get(var25_26.name) + ": It cannot also have another type: column type=" + var27_30 + " expectedTypeFam=" + var17_17);
                                        throw new SpatialArgTypeException("var " + var25_26.name + " is already categorized as type " + this.DatatypeFam_for_var.get(var25_26.name) + ": It cannot also have another type: column type=" + var27_30);
                                    }
                                } else {
                                    if (!var17_17.equals("SDO_GEOMETRY") && this.Geometry_VarSRID.containsKey(var25_26.name)) {
                                        this.Geometry_VarSRID.remove(var25_26.name);
                                        this.log("removed from Geometry_VarSRID (filter expects diff datatype family=" + var17_17 + "): var=" + var25_26.name);
                                    }
                                    throw new SpatialArgTypeException("Inappropriate column type " + var27_30 + " ... Expecting a type compatible with " + var5_5);
                                }
                                if (var17_17.equals("SDO_GEOMETRY")) {
                                    var47_73 = var40_65.Tmap + "+" + var26_28.replaceAll("\"", "");
                                    this.log("[GFV3W] " + var18_18 + " Starting multi-SRID handling for var " + var25_26.name + " at " + var3_3 + " filter handling level");
                                    this.log("[GFV3W] [SRID] " + var18_18 + " SDO_GEOMETRY retrieving metadata for var " + var25_26.name + " associated to the column name " + var26_28 + " from LtcRowInfo_for_Tmap_plus_Col with key " + var47_73);
                                    var48_74 = this.LtcRowInfo_for_Tmap_plus_Col.get(var47_73);
                                    this.log("[GFV3W] [SRID] " + var18_18 + " LtcRowInfo.toString(): " + var48_74.toString());
                                    this.log("[GFV3W] [SRID] " + var18_18 + " LtcRowInfo.getDimArrayConstructor(): " + var48_74.getDimArrayConstructor());
                                    var34_47 = var48_74.getDimArrayConstructor("sdo_dim_array(sdo_dim_element('LONGITUDE','-180','180','10'),sdo_dim_element('LATITUDE','-90','90','10'))");
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " geoDimension [DimArrayConstructor] : " + var34_47);
                                    if (var48_74.getSRID() == null) {
                                        var33_44 = RelationalBGP.DEFAULT_GEOMETRY_SRID;
                                        this.log("[GFV3W] " + var18_18 + " Using the SRID by default " + RelationalBGP.DEFAULT_GEOMETRY_SRID);
                                    } else {
                                        var33_44 = Long.valueOf(var48_74.getSRID());
                                    }
                                    this.log("[GFV3W] " + var18_18 + " Finishing multi-SRID handling for var " + var25_26.name + " at " + var3_3 + " filter handling level");
                                }
                                if (var2_2.equals("VALIDATION_ONLY")) {
                                    this.log("Validation successful for var: " + var25_26.name);
                                    return null;
                                }
                                var16_16 = var8_8 + "." + var26_28;
                                var31_38 = new R2R2MatSPARQLFilterMap(var20_21, var16_16, var33_44);
                                this.log("[GFV3W] finally, col_srid (for var " + var25_26.name + "): " + var33_44);
                            } else {
                                this.log("[GFV3W] " + var18_18 + " running OUTER condition handling");
                                this.log("[GFV3W] " + var18_18 + " natVarOptInfo: " + var13_13.toString());
                                this.log("[GFV3W] " + var18_18 + " atom.name: " + var25_26.name);
                                var20_21 = var5_5;
                                var35_50 = var13_13.get_NatVarOpt_Structure(var25_26.name);
                                this.log("[GFV3W] " + var18_18 + " natVarOpt: " + var35_50);
                                var36_53 = var35_50.getCSRAlias();
                                if (var17_17.equals("SDO_GEOMETRY")) {
                                    var37_56 = var35_50.getColCount_for_SDO_GEOMETRY(var36_53);
                                    if (var37_56 != 1) {
                                        this.log("SDO_GEOMETRY type handles ONLY COLUMN mapping - so colCount (" + var37_56 + ") is NOT handled");
                                        throw new RDFException("Geometry value being constructed with a non-COLUMN mapping (multiple cols in TFT): colCount=" + var37_56);
                                    }
                                    var16_16 = var36_53 + "." + var25_26.name + "$" + (var37_56 - 1);
                                    this.log("[GFV3W] " + var18_18 + " Starting multi-SRID handling for var " + var25_26.name + " at " + var3_3 + " filter handling level");
                                    this.log("[GFV3W]  [SRID]" + var18_18 + " Geometry_VarSRID for var " + var25_26.name + ": " + this.Geometry_VarSRID.get(var25_26.name).toString());
                                    var38_60 = null;
                                    if (this.Geometry_VarSRID.containsKey(var25_26.name)) {
                                        var38_60 = this.Geometry_VarSRID.get(var25_26.name).iterator().next();
                                        this.log("[GFV3W]  [SRID]" + var18_18 + " SDO_GEOMETRY metadata for key var " + var25_26.name + " : " + var38_60 + " during OUTER condition handling");
                                    } else {
                                        this.log("[GFV3W]  [SRID]" + var18_18 + " UNEXPECTED ERROR!!! SDO_GEOMETRY SRID for key var " + var25_26.name + " NOTFOUND at OUTER condition processing in Geometry_VarSRID");
                                    }
                                    this.log("[GFV3W]  [SRID]" + var18_18 + " Finishing multi-SRID handling for var " + var25_26.name + " at " + var3_3 + " filter handling level");
                                    var31_38 = new R2R2MatSPARQLFilterMap(var20_21, var16_16, var38_60);
                                    var31_38.setGeoDimension(this.Geometry_VarDimension.get(var36_53 + "." + var25_26.name));
                                } else {
                                    var16_16 = "sdo_rdf.vname(" + var36_53 + "." + var25_26.name + ")";
                                    var32_40 = "sdo_rdf.ltype(" + var36_53 + "." + var25_26.name + ")";
                                    var31_38 = new R2R2MatSPARQLFilterMap(var20_21, var16_16);
                                }
                            }
                            var22_23 = var16_16;
                            var23_24 = "''";
                            var24_25 = var22_23;
                            var31_38.setValue_name_0(var24_25);
                            var31_38.setValue_type_1("'LIT'");
                            var31_38.setVname_prefix_2(var22_23);
                            var31_38.setVname_suffix_3(var23_24);
                            var31_38.setLiteral_type_4(var32_40);
                            var31_38.setLanguage_type_5("''");
                            var31_38.setLong_value_6("TO_CLOB(NULL)");
                            var31_38.setArgument_type_7(String.valueOf(4));
                            var31_38.setVarName(var25_26.name);
                            if (!"SDO_GEOMETRY".equals(var27_30)) break;
                            var31_38.setArg_8("LOCAL_VAR");
                            var31_38.setGeoDimension(var34_47);
                            break;
                        }
                        case 5: {
                            this.log("[GFV3W] " + var18_18 + " TERM-ATOM: ASTTripleAtom.ATOM_TYPE_LITERAL_TEXT_TYPED: " + 5);
                            this.log("[GFV3W] " + var18_18 + "            type: " + var25_26.type);
                            this.log("[GFV3W] " + var18_18 + "         litType: " + var25_26.litType);
                            this.log("[GFV3W] " + var18_18 + "      litTypeFam: " + var21_22);
                            if (!var17_17.equals(var21_22)) {
                                throw new RDFException("Inappropriate literal argument " + var25_26.litType + " ... Expecting a type compatible with " + var5_5);
                            }
                            var20_21 = var5_5;
                            var16_16 = "'" + var25_26.name + "'";
                            var31_38 = new R2R2MatSPARQLFilterMap(var20_21, var16_16);
                            var22_23 = var16_16;
                            var23_24 = "''";
                            var24_25 = var22_23 + " || " + var23_24;
                            var31_38.setValue_name_0(var22_23);
                            var31_38.setValue_type_1("'LIT'");
                            var31_38.setVname_prefix_2(var22_23);
                            var31_38.setVname_suffix_3(var23_24);
                            var31_38.setLiteral_type_4("'" + var25_26.litType + "'");
                            var31_38.setLanguage_type_5("''");
                            var31_38.setLong_value_6("TO_CLOB(NULL)");
                            var31_38.setArgument_type_7(String.valueOf(var31_38.getNodeFilterType()));
                            var31_38.setArg_8("CONSTANT");
                            if (!"SDO_GEOMETRY".equals(var17_17)) break;
                            this.log("Note: for this SDO_GEOMETRY literal, geoDimension is NOT populated yet: caller will do it using function_geoDimension");
                            break;
                        }
                        case 3: {
                            this.log("[GFV3W] " + var18_18 + " TERM-ATOM: ASTTripleAtom.ATOM_TYPE_LITERAL_TEXT_PLAIN: " + 3);
                            this.log("[GFV3W] " + var18_18 + "            type: " + var25_26.type);
                            this.log("[GFV3W] " + var18_18 + "         litType: " + var25_26.litType);
                            this.log("[GFV3W] " + var18_18 + "      litTypeFam: " + var21_22);
                            if (!var17_17.equals("STRING")) {
                                throw new RDFException("Inappropriate literal text plain ... Expecting a type compatible with " + var5_5);
                            }
                            var20_21 = var5_5;
                            var16_16 = "'" + var25_26.name + "'";
                            var31_38 = new R2R2MatSPARQLFilterMap(var20_21, var16_16);
                            var22_23 = var16_16;
                            var23_24 = "''";
                            var24_25 = var22_23 + " || " + var23_24;
                            var31_38.setValue_name_0(var24_25);
                            var31_38.setValue_type_1("'LIT'");
                            var31_38.setVname_prefix_2(var22_23);
                            var31_38.setVname_suffix_3(var23_24);
                            var31_38.setLiteral_type_4("''");
                            var31_38.setLanguage_type_5("''");
                            var31_38.setLong_value_6("TO_CLOB(NULL)");
                            var31_38.setArgument_type_7(String.valueOf(var31_38.getNodeFilterType()));
                            var31_38.setArg_8("CONSTANT");
                            break;
                        }
                        case 2: {
                            this.log("[GFV3W] " + var18_18 + " TERM-ATOM: ASTTripleAtom.ATOM_TYPE_LITERAL_NUMERIC: " + 2);
                            this.log("[GFV3W] " + var18_18 + "            type: " + var25_26.type);
                            this.log("[GFV3W] " + var18_18 + "         litType: " + var25_26.litType);
                            this.log("[GFV3W] " + var18_18 + "      litTypeFam: " + var21_22);
                            if (!var17_17.equals("NUMERIC")) {
                                throw new SpatialArgTypeException("Inappropriate literal numeric ... Expecting a type compatible with " + var5_5);
                            }
                            var20_21 = var5_5;
                            var16_16 = var25_26.name;
                            var31_38 = new R2R2MatSPARQLFilterMap(var20_21, var16_16);
                            var22_23 = var16_16;
                            var23_24 = "''";
                            var24_25 = var22_23;
                            var31_38.setValue_name_0(var24_25);
                            var31_38.setValue_type_1("'LIT'");
                            var31_38.setVname_prefix_2(var22_23);
                            var31_38.setVname_suffix_3(var23_24);
                            var31_38.setLiteral_type_4("''");
                            var31_38.setLanguage_type_5("''");
                            var31_38.setLong_value_6("TO_CLOB(NULL)");
                            var31_38.setArgument_type_7(String.valueOf(var31_38.getNodeFilterType()));
                            var31_38.setArg_8("CONSTANT");
                            break;
                        }
                        case 1: {
                            this.log("[GFV3W] " + var18_18 + " TERM-ATOM: ASTTripleAtom.ATOM_TYPE_URI: " + 1);
                            this.log("[GFV3W] " + var18_18 + "            type: " + var25_26.type);
                            this.log("[GFV3W] " + var18_18 + "         litType: " + var25_26.litType);
                            this.log("[GFV3W] " + var18_18 + "      litTypeFam: " + var21_22);
                            if (!var17_17.equals("STRING")) {
                                throw new SpatialArgTypeException("Inappropriate literal type ... Expecting a type compatible with " + var5_5);
                            }
                            var20_21 = "URI";
                            var16_16 = "'" + var25_26.name + "'";
                            var31_38 = new R2R2MatSPARQLFilterMap(var20_21, var16_16);
                            var22_23 = var16_16;
                            var23_24 = "''";
                            var24_25 = var22_23;
                            var31_38.setValue_name_0(var24_25);
                            var31_38.setValue_type_1("'LIT'");
                            var31_38.setVname_prefix_2(var22_23);
                            var31_38.setVname_suffix_3(var23_24);
                            var31_38.setLiteral_type_4("''");
                            var31_38.setLanguage_type_5("''");
                            var31_38.setLong_value_6("TO_CLOB(NULL)");
                            var31_38.setArgument_type_7(String.valueOf(var31_38.getNodeFilterType()));
                            var31_38.setArg_8("CONSTANT");
                            break;
                        }
                        default: {
                            throw new RDFException("Unhandled atom type: " + var25_26.type);
                        }
                    }
                    var19_20 = var31_38;
                    break block61;
                }
                var25_27 = null;
                var26_29 = (SimpleNode)var4_4.jjtGetChild(0);
                if (var26_29 instanceof ASTUnaryOperator) {
                    var27_31 = (ASTUnaryOperator)var26_29;
                    var25_27 = var27_31.name.trim();
                } else if (var26_29 instanceof ASTTripleAtom) {
                    var27_31 = (ASTTripleAtom)var26_29;
                    var25_27 = var27_31.name.trim();
                }
                this.log("[GFV3W] " + var18_18 + "        FUNCTION: " + var26_29.dumpToStr(""));
                this.log("[GFV3W] " + var18_18 + "           CLASS: " + var26_29.getClass());
                this.log("[GFV3W] " + var18_18 + "        funcName: " + var25_27);
                if (!RelationalBGP.geo_functionArgsMap.containsKey(var25_27)) {
                    this.log("[GFV3W] " + var18_18 + " Unsupported function: " + var25_27);
                    throw new RDFException("Unsupported function: " + var25_27);
                }
                var27_31 = RelationalBGP.geo_functionArgsMap.get(var25_27).get(0);
                var21_22 = this.TYPE_FAMILY((String)var27_31);
                this.log("[GFV3W] " + var18_18 + "        funcType: " + (String)var27_31);
                this.log("[GFV3W] " + var18_18 + "      litTypeFam: " + var21_22);
                this.log("[GFV3W]");
                if (!var5_5.equals(var27_31)) {
                    throw new SpatialArgTypeException("Inappropriate type argument " + (String)var27_31 + " ... Expecting a compatible type with " + var5_5);
                }
                var28_33 = null;
                var29_35 = new ArrayList<String[]>();
                var30_37 = null;
                var31_39 = null;
                for (var32_41 = 1; var32_41 < var4_4.jjtGetNumChildren(); ++var32_41) {
                    block62: {
                        block64: {
                            block63: {
                                this.log("[GFV3W] " + var18_18 + " --> #child: " + var32_41 + " function_srid so far =" + var30_37);
                                var33_45 = (SimpleNode)var4_4.jjtGetChild(var32_41);
                                var34_48 = RelationalBGP.geo_functionArgsMap.get(var25_27).get(var32_41);
                                if (var34_48 == null) {
                                    throw new SpatialArgTypeException("There is no expected type mapping for the function " + var25_27 + " at the argument " + var32_41);
                                }
                                var35_51 = this.genFilter_v3_expWalker(var1_1, var2_2, var3_3, var33_45, var34_48, var6_6, var7_7, var8_8, var9_9, var10_10, var11_11, var12_12, var13_13, var14_14, var15_15);
                                this.log("[GFV3W] " + var18_18 + " back after processing of #child: " + var32_41 + " callStackLevel=" + var6_6.size());
                                if (var2_2.equals("VALIDATION_ONLY") && var35_51 == null) {
                                    this.log("[GFV3W] " + var18_18 + " VALIDATION_ONLY mode --> got to the next child");
                                    continue;
                                }
                                if (!"SDO_GEOMETRY".equals(this.TYPE_FAMILY(var35_51.getR2r_type()))) break block62;
                                this.log("[GFV3W] " + var18_18 + " dealing with family " + "SDO_GEOMETRY" + " of concrete type " + var35_51.getR2r_type());
                                if (!RelationalBGP.geo_funtionRequiringSridTransformationSet.contains(var25_27) || var35_51.getArg_8().equals("CONSTANT")) break block63;
                                this.log("[GFV3W] " + var18_18 + " The function " + var25_27 + " requires SRID transformation at the OUTER filter handling");
                                var36_54 = var35_51.getValue_name_0();
                                this.log("[GFV3W] " + var18_18 + " Starting multi-SRID handling for function " + var25_27 + " for argument " + (String)var36_54 + " at " + var3_3 + " filter handling level");
                                var37_57 = null;
                                var38_61 = var35_51.getVarName();
                                this.log("[GFV3W]  [SRID] " + var18_18 + " geom_obj_var " + var38_61);
                                if (var38_61 == null) ** GOTO lbl335
                                if (this.Geometry_VarSRID.containsKey(var38_61)) {
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " value_name " + (String)var36_54 + " matches the variable identifier pattern: " + var38_61);
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " AND we have its SRIDs");
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " geom_obj_var: " + var38_61 + " SRIDs: " + this.Geometry_VarSRID.get(var38_61));
                                    var37_57 = this.Geometry_VarSRID.get(var38_61).iterator().next();
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " very first SRID for geom_obj_var " + var38_61 + ": " + var37_57);
                                } else {
                                    throw new SpatialArgTypeException("There is no SRID associated to the var " + var38_61);
lbl335:
                                    // 1 sources

                                    this.log("[GFV3W]  [SRID] " + var18_18 + " Using SRID of " + (String)var36_54);
                                    var37_57 = var35_51.getSrid();
                                }
                                if (var30_37 == null) {
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " Function SRID has not been defined");
                                    var30_37 = var37_57;
                                    var31_39 = var35_51.getGeoDimension();
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " Defining function SRID: " + var30_37 + " and function geoDimension: " + var31_39);
                                }
                                this.log("[GFV3W]  [SRID] " + var18_18 + " Deciding if it's worth to do the SRID transformation for " + var35_51.getValue_name_0() + " ...");
                                var39_64 = false;
                                if (var3_3.equals("OUTER_LEVEL") && var38_61 != null) {
                                    this.log("[GFV3W] " + var18_18 + " At the OUTER level it is required a transformation if a vriable " + var38_61 + " has multiple mappings with different SRIDs");
                                    var40_66 = this.Geometry_VarSRID.get(var38_61);
                                    if (var40_66.size() > 1) {
                                        this.log("[GFV3W]  [SRID] " + var18_18 + " ... the var " + var38_61 + " has more than one SRIDs: " + var40_66.toString());
                                        this.log("[GFV3W]  [SRID] " + var18_18 + " ... SRID transformation is required");
                                        var39_64 = true;
                                    }
                                }
                                if (!var30_37.equals(var35_51.getSrid())) {
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " The function_srid " + var30_37 + " is different from the child's SRID " + var35_51.getSrid());
                                    var39_64 = true;
                                }
                                if (var39_64) {
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " Transforming geometry in " + var35_51.getValue_name_0() + " to " + var30_37 + " --> ");
                                    var40_66 = "sdo_cs.transform( /* FUNC SRID */ " + var35_51.getValue_name_0() + ", " + var30_37 + ")";
                                    var35_51.setVname_prefix_2((String)var40_66);
                                    var35_51.setValue_name_0(var35_51.getVname_prefix_2());
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " " + var35_51.getValue_name_0());
                                }
                                break block64;
                            }
                            if (var30_37 == null) {
                                var30_37 = var35_51.getSrid();
                                var31_39 = var35_51.getGeoDimension();
                                this.log("[GFV3W]  [SRID] " + var18_18 + " Defining function SRID: " + var30_37 + " and function geoDimension: " + var31_39);
                            }
                        }
                        this.log("[GFV3W] " + var18_18 + " Finishing multi-SRID handling for function " + var25_27 + " at " + var3_3 + " filter handling level");
                        if (var35_51.getGeoDimension() == null) {
                            this.log("replacing null geoDimension in just-processed-child with function_geoDimension: " + var31_39);
                            var35_51.setGeoDimension(var31_39);
                        }
                    }
                    var36_54 = new String[]{var35_51.getValue_name_0(), var35_51.getValue_type_1(), var35_51.getVname_prefix_2(), var35_51.getVname_suffix_3(), var35_51.getLiteral_type_4(), var35_51.getLanguage_type_5(), var35_51.getLong_value_6(), var35_51.getArgument_type_7(), var35_51.getArg_8(), var35_51.getGeoDimension()};
                    var29_35.add(var36_54);
                    this.log("[GFV3W] " + var18_18 + " <-- END #child: " + var32_41);
                }
                if (var2_2.equals("VALIDATION_ONLY")) break block65;
                this.log("[GFV3W] " + var18_18 + " funcName: " + var25_27);
                this.log("[GFV3W] " + var18_18 + " CLASS: " + var26_29.getClass());
                if (!(var26_29 instanceof ASTUnaryOperator)) ** GOTO lbl388
                if (var25_27.equals("!")) {
                    var32_42 = ((String[])var29_35.get(0))[2];
                    this.log("[GFV3W] " + var18_18 + " Negating the filter expression: " + var32_42);
                    var16_16 = "NOT " + var32_42;
                } else {
                    this.log("[GFV3W] " + var18_18 + " Unsupported Unary Operator: " + var25_27);
                    throw new RDFException("Unsupported Unary Operator: " + var25_27);
lbl388:
                    // 1 sources

                    var32_43 = "''";
                    var33_46 = this.ctx.srid;
                    v0 = this.ctx.srid = var30_37 != null ? var30_37 : 0L;
                    if ("http://www.opengis.net/def/function/geosparql/sfDisjoint".equals(var25_27)) {
                        this.log("[GFV3W] " + var18_18 + " Special case for handling " + "http://www.opengis.net/def/function/geosparql/sfDisjoint" + "...");
                        this.log("[GFV3W] " + var18_18 + " ... We use " + "http://www.opengis.net/def/function/geosparql/sfDisjointR2R" + " to induce the use of the index-based SDO_RELATE");
                        var25_27 = "http://www.opengis.net/def/function/geosparql/sfDisjointR2R";
                    }
                    var16_16 = var7_7.genSQL(var29_35, var25_27, var32_43);
                    this.ctx.srid = var33_46;
                }
                var28_33 = new R2R2MatSPARQLFilterMap(var5_5, var16_16, var30_37);
                var22_23 = var16_16;
                var23_24 = "''";
                var24_25 = "";
                var28_33.setValue_name_0(var24_25);
                var28_33.setValue_type_1("'LIT'");
                var28_33.setVname_prefix_2(var22_23);
                var28_33.setVname_suffix_3(var23_24);
                var28_33.setLiteral_type_4("''");
                var28_33.setLanguage_type_5("''");
                var28_33.setLong_value_6("TO_CLOB(NULL)");
                if (var5_5.equals("http://www.opengis.net/ont/geosparql#wktLiteral")) {
                    var28_33.setArgument_type_7(String.valueOf(25));
                    var28_33.setArg_8(var28_33.getVname_prefix_2());
                    this.log("Note: function call returns a geometry value: it gets its geoDimension from function_geoDimension=" + var31_39);
                    var28_33.setGeoDimension(var31_39);
                } else {
                    var28_33.setArgument_type_7(String.valueOf(var28_33.getNodeFilterType()));
                    var28_33.setArg_8("LOCAL_VAR");
                }
                var19_20 = var28_33;
                break block61;
            }
            return null;
        }
        var6_6.pop();
        this.log("[GFV3W] " + var18_18 + " genFilter_v3_expWalker result:\n" + var18_18 + " " + var19_20.toString());
        return var19_20;
    }

    private RelExpr buildUnindexedEqualityGeomExpression(String string, String string2) {
        ASTRelationalExpression aSTRelationalExpression = new ASTRelationalExpression(90);
        aSTRelationalExpression.jjtSetInitCapacity(4);
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
        aSTTripleAtom.type = 1;
        aSTTripleAtom.name = "http://www.opengis.net/def/function/geosparql/relate";
        aSTTripleAtom.jjtSetParent(aSTRelationalExpression);
        aSTRelationalExpression.jjtAddChild(aSTTripleAtom, 0);
        ASTTripleAtom aSTTripleAtom2 = new ASTTripleAtom(73);
        aSTTripleAtom2.type = 0;
        aSTTripleAtom2.name = string;
        aSTTripleAtom2.jjtSetParent(aSTRelationalExpression);
        aSTRelationalExpression.jjtAddChild(aSTTripleAtom2, 1);
        ASTTripleAtom aSTTripleAtom3 = new ASTTripleAtom(73);
        aSTTripleAtom3.type = 0;
        aSTTripleAtom3.name = string2;
        aSTTripleAtom3.jjtSetParent(aSTRelationalExpression);
        aSTRelationalExpression.jjtAddChild(aSTTripleAtom3, 2);
        ASTTripleAtom aSTTripleAtom4 = new ASTTripleAtom(73);
        aSTTripleAtom4.name = "TFFFTFFFT";
        aSTTripleAtom4.type = 3;
        aSTTripleAtom4.jjtSetParent(aSTRelationalExpression);
        aSTRelationalExpression.jjtAddChild(aSTTripleAtom4, 3);
        Filter filter = new Filter(aSTRelationalExpression, this.ctx);
        this.log("filter: " + filter.toString());
        RelExpr relExpr = new RelExpr(aSTTripleAtom2, "=", new ASTTripleAtom[]{aSTTripleAtom3}, filter, 2L);
        return relExpr;
    }

    private String genFilter2vCond_intraMCSR(MCSR mCSR, int n) throws RDFException {
        this.log("[genFilter2vCond_intraMCSR] ENTERING mcsrAlias=" + mCSR.getMCSRAlias() + "  UArowNum_for_MCSR=" + n);
        String string = "";
        for (RelExpr relExpr : this.TwoVarRelExprFilterList_for_BGP) {
            String string2;
            int n2;
            Object object;
            Object object2;
            this.log("[genFilter2vCond_intraMCSR] Two-var filter condition: " + relExpr.toString());
            if (relExpr.L_atom.type != 0 || relExpr.R_atom.type != 0) {
                throw new RDFException("[genFilter2vCond_intraMCSR] Internal error: not a two-var filter: " + relExpr.toString());
            }
            String string3 = relExpr.L_atom.name;
            String string4 = relExpr.R_atom.name;
            Set<String> set = this.occPosSet_for_CSRAlias_for_var.get(string3).keySet();
            Set<String> set2 = this.occPosSet_for_CSRAlias_for_var.get(string4).keySet();
            this.log("[genFilter2vCond_intraMCSR] Lvar=" + string3 + " CSRAliasSet: " + set);
            this.log("[genFilter2vCond_intraMCSR] Rvar=" + string4 + " CSRAliasSet: " + set2);
            HashSet<String> hashSet = new HashSet<String>(set);
            hashSet.retainAll(set2);
            Set<String> set3 = this.get_commonMCSRAliasSet_for_2vars(string3, string4);
            this.log("[genFilter2vCond_intraMCSR]  CSRsSetIntersection=" + hashSet);
            this.log("[genFilter2vCond_intraMCSR] MCSRsSetIntersection=" + set3);
            if (!hashSet.isEmpty() || !set3.contains(mCSR.getMCSRAlias())) {
                this.log("[genFilter2vCond_intraMCSR] skipping 2 var filter processing for vars Lvar=" + string3 + " Rvar=" + string4 + "...");
                this.log("[genFilter2vCond_intraMCSR] ...    they both APPEAR in at least 1 CSR: " + hashSet);
                this.log("[genFilter2vCond_intraMCSR] ... or they both DO NOT belong to the curremt MCSRAlias=" + mCSR.getMCSRAlias());
                continue;
            }
            this.log("[genFilter2vCond_intraMCSR] this two-var filter needs processing: the two vars never occur in the same CSR but they do occur in the same MCSRAlias=" + mCSR.getMCSRAlias());
            Set<Integer> set4 = mCSR.getFirstTFTIdxSet(n, string3);
            this.log("[genFilter2vCond_intraMCSR] LTFTIdxSet: " + set4);
            Set<Integer> set5 = mCSR.getFirstTFTIdxSet(n, string4);
            this.log("[genFilter2vCond_intraMCSR] RTFTIdxSet: " + set5);
            String string5 = "";
            if (set4.size() > 1 || set5.size() > 1) {
                this.log("[genFilter2vCond_intraMCSR] native processing SKIPPED because of more than one TFTs for Lvar and/or Rvar (will be handled in SPARQL)");
                continue;
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            String string6 = "";
            String string7 = "";
            Object object3 = set4.iterator();
            while (object3.hasNext()) {
                int n3 = object3.next();
                object2 = this.TFTinfoGlobalList.get(n3);
                string6 = ((TFTinfo)object2).termType;
                string7 = ((TFTinfo)object2).datatype;
                this.log("[genFilter2vCond_intraMCSR] Lvar_TermType=" + string6 + " Lvar_datatype=" + string7);
                this.log("[genFilter2vCond_intraMCSR] Lvar_TFTinfo=" + object2);
                this.log("[genFilter2vCond_intraMCSR] Lvar_TFTidx=" + n3);
                object = set5.iterator();
                while (object.hasNext()) {
                    n2 = (Integer)object.next();
                    this.log("[genFilter2vCond_intraMCSR]   Rvar_TFTidx=" + n2);
                    if (n3 == n2) continue;
                    TFTinfo tFTinfo = this.TFTinfoGlobalList.get(n2);
                    this.log("[genFilter2vCond_intraMCSR] Rvar_TFTinfo=" + tFTinfo);
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                    bl4 = false;
                    if (!((TFTinfo)object2).termType.equals(tFTinfo.termType)) {
                        this.log("[genFilter2vCond_intraMCSR] termType mismatch: Lvar_TFTinfo.termType=" + ((TFTinfo)object2).termType + " Rvar_TFTinfo.termType=" + tFTinfo.termType);
                        bl = true;
                        string5 = this.gen_e_z_termType_based_cond(relExpr, bl);
                    } else if (((TFTinfo)object2).termType.equals(rrLiteral)) {
                        if (!((TFTinfo)object2).datatype.equals(tFTinfo.datatype)) {
                            bl2 = true;
                            if (!((TFTinfo)object2).datatype_family.equals(tFTinfo.datatype_family)) {
                                bl3 = true;
                                if (!this.isNumFltDbl(((TFTinfo)object2).datatype_family) || !this.isNumFltDbl(tFTinfo.datatype_family)) {
                                    bl4 = true;
                                }
                            }
                        }
                        if (bl2) {
                            this.log("[genFilter2vCond_intraMCSR] non-identical datatype: datatype_mismatch=" + bl2 + " | datatype_family_mismatch=" + bl3 + " | datatype_family_incompatible=" + bl4);
                            string2 = this.gen_e_z_datatype_based_cond(relExpr, bl2, bl3, bl4);
                            if (string2 != null) {
                                string5 = string2;
                            }
                        }
                    }
                    if (string5.length() <= 0) continue;
                    break;
                }
                if (string5.length() <= 0) continue;
                break;
            }
            if (string5.length() == 0) {
                int n4;
                String string8;
                this.log("[genFilter2vCond_intraMCSR] no condition could be generated for current relExpr (termTypes match and datatypes compatible): fall back to SPARQL-generated condition");
                object3 = this.occPosSet_for_CSRAlias_for_var.get(string3).keySet().iterator().next();
                String string9 = this.occPosSet_for_CSRAlias_for_var.get(string4).keySet().iterator().next();
                object2 = this.CSRinfo_for_CSRAlias.get(object3);
                object = this.CSRinfo_for_CSRAlias.get(string9);
                n2 = n % ((CSRinfo)object2).getUArowsCount();
                int n5 = n % ((CSRinfo)object).getUArowsCount();
                string2 = ((CSRinfo)object2).sAliasArray.get(n2);
                String string10 = ((CSRinfo)object).sAliasArray.get(n5);
                this.log("[genFilter2vCond_intraMCSR] Lvar_CSRAliasSet=" + set + " chosen=" + string2);
                this.log("[genFilter2vCond_intraMCSR] Rvar_CSRAliasSet=" + set2 + " chosen=" + string10);
                int n6 = set4.iterator().next();
                int n7 = set5.iterator().next();
                String string11 = ((CSRinfo)object2).getFirstOccPos(string3);
                String string12 = ((CSRinfo)object).getFirstOccPos(string4);
                String string13 = string11.split(":")[0];
                String string14 = string12.split(":")[0];
                int n8 = Integer.valueOf(string11.split(":")[1]);
                int n9 = Integer.valueOf(string12.split(":")[1]);
                RRTabRowInfo rRTabRowInfo = ((CSRinfo)object2).getRRrowInfo(n2, n8);
                RRTabRowInfo rRTabRowInfo2 = ((CSRinfo)object).getRRrowInfo(n5, n9);
                List<String> list = null;
                List<String> list2 = null;
                if (string13.equals("subject") && rRTabRowInfo.sExpr != null) {
                    list = rRTabRowInfo.colLists.get(0);
                } else if (string13.equals("predicate") && rRTabRowInfo.pExpr != null) {
                    list = rRTabRowInfo.colLists.get(1);
                } else if (string13.equals("object") && rRTabRowInfo.oExpr != null) {
                    list = rRTabRowInfo.colLists.get(2);
                } else if (string13.equals("object") && rRTabRowInfo.psExpr != null) {
                    list = rRTabRowInfo.colLists.get(4);
                } else if (string13.equals("graph") && rRTabRowInfo.pogExpr != null) {
                    list = rRTabRowInfo.colLists.get(3);
                }
                if (string14.equals("subject") && rRTabRowInfo2.sExpr != null) {
                    list2 = rRTabRowInfo2.colLists.get(0);
                } else if (string14.equals("predicate") && rRTabRowInfo2.pExpr != null) {
                    list2 = rRTabRowInfo2.colLists.get(1);
                } else if (string14.equals("object") && rRTabRowInfo2.oExpr != null) {
                    list2 = rRTabRowInfo2.colLists.get(2);
                } else if (string14.equals("object") && rRTabRowInfo2.psExpr != null) {
                    list2 = rRTabRowInfo2.colLists.get(4);
                } else if (string14.equals("graph") && rRTabRowInfo2.pogExpr != null) {
                    list2 = rRTabRowInfo2.colLists.get(3);
                }
                this.log("[genFilter2vCond_intraMCSR]  LcolList:" + list);
                this.log("[genFilter2vCond_intraMCSR]  RcolList:" + list2);
                String string15 = relExpr.compOperator.equals("SAMETERM") ? "=" : (relExpr.compOperator.equals("DIFFTERM") ? "!=" : relExpr.compOperator);
                this.log("[genFilter2vCond_intraMCSR] sql_compOperator=" + string15);
                if (string6.equals(rrIRI) || string6.equals(rrBlankNode)) {
                    this.log("[genFilter2vCond_intraMCSR] [IRIorBN]");
                    if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM") || relExpr.compOperator.equals("=") || relExpr.compOperator.equals("!=") || list.size() == 1 && list2.size() == 1) {
                        if (!this.isCompatibleTFTpair(n6, n7)) {
                            this.log("[genFilter2vCond_intraMCSR] The TFTs " + n6 + " and " + n7 + " are not compatible");
                            string = " AND 1=0 ";
                        }
                        string8 = "";
                        for (n4 = 0; n4 < list.size(); ++n4) {
                            string8 = string8 + " AND (" + string2 + "." + list.get(n4) + BASE_PREFIX_COLNAME_SEP + string15 + BASE_PREFIX_COLNAME_SEP + string10 + "." + list2.get(n4) + ")";
                        }
                        if (!string8.equals("")) {
                            this.log("[genFilter2vCond_intraMCSR] CASE: =, !=, SAMETERM, DIFFTERM [FILTER_OPTIMIZED]");
                            string = string8;
                            this.VarSet_filter2vCond_outer.add(string3);
                            this.VarSet_filter2vCond_outer.add(string4);
                            this.log("[genFilter2vCond_intraMCSR] VarSet_filter2vCond_outer: " + this.VarSet_filter2vCond_outer);
                        } else {
                            this.log("[genFilter2vCond_intraMCSR] //CASE: =, !=, SAMETERM, DIFFTERM [NOT_FILTER_OPTIMIZED]");
                            string = string + COND_CONNECTOR + string2 + "." + string3 + BASE_PREFIX_COLNAME_SEP + string15 + BASE_PREFIX_COLNAME_SEP + string10 + "." + string4;
                        }
                        this.log("[genFilter2vCond_intraMCSR] filter2vdco_condExpr_intraMCSR=" + string);
                        continue;
                    }
                    this.log("[genFilter2vCond_intraMCSR] //CASE: <, >, <=, >=");
                    string = " AND 1=0 ";
                    continue;
                }
                if (!string6.equals(rrLiteral)) continue;
                this.log("[genFilter2vCond_intraMCSR] [Literal] datatype=" + string7);
                string8 = "";
                if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM") || relExpr.compOperator.equals("=") || relExpr.compOperator.equals("!=") || list.size() == 1 && list2.size() == 1) {
                    if (!this.isCompatibleTFTpair(n6, n7)) {
                        this.log("[genFilter2vCond_intraMCSR] The TFTs " + n6 + " and " + n7 + " are not compatible");
                        string = " AND 1=0 ";
                    }
                    for (n4 = 0; n4 < list.size(); ++n4) {
                        string8 = string8 + " AND (" + string2 + "." + list.get(n4) + BASE_PREFIX_COLNAME_SEP + string15 + BASE_PREFIX_COLNAME_SEP + string10 + "." + list2.get(n4) + ")";
                    }
                    if (!string8.equals("")) {
                        string = string8;
                        this.VarSet_filter2vCond_outer.add(string3);
                        this.VarSet_filter2vCond_outer.add(string4);
                        this.log("[genFilter2vCond_intraMCSR] VarSet_filter2vCond_outer: " + this.VarSet_filter2vCond_outer);
                    }
                }
                if (string8.equals("")) {
                    String string16 = "";
                    String string17 = "";
                    this.log(this.TYPE_FAMILY(string7));
                    if (this.isNumFltDbl(this.TYPE_FAMILY(string7))) {
                        this.log(this.TYPE_FAMILY(string7));
                        string16 = "to_number(";
                        string17 = ")";
                    }
                    string = string + COND_CONNECTOR + string16 + SDO_RDF_VNAME_BEG + string2 + "." + string3 + ")" + string17 + BASE_PREFIX_COLNAME_SEP + string15 + BASE_PREFIX_COLNAME_SEP + string16 + SDO_RDF_VNAME_BEG + string10 + "." + string4 + ")" + string17;
                }
                this.log("[genFilter2vCond_intraMCSR] filter2vdco_condExpr_intraMCSR=" + string);
                continue;
            }
            if (string5.equals(" AND 1=0 ")) {
                this.log("[genFilter2vCond_intraMCSR] COND_FALSE generated by relExpr: set global COND_FALSE and exit");
                string = " AND 1=0 ";
                break;
            }
            string = string + string5;
        }
        this.log("[genFilter2vCond_intraMCSR] RETURNING filter2vdco_condExpr_intraMCSR: " + string);
        return string;
    }

    private String genFilter2vCond_outer(NatVarOpt_Info natVarOpt_Info) throws RDFException {
        this.log("[genFilter2vCond_outer] ENTERING");
        Set<Object> set = new HashSet();
        Object object = "";
        for (RelExpr relExpr : this.TwoVarRelExprFilterList_for_BGP) {
            Object object2;
            Object object3;
            Object object4;
            this.log("Two-var filter condition: " + relExpr.toString());
            if (relExpr.L_atom.type != 0 || relExpr.R_atom.type != 0) {
                throw new RDFException("Internal error: not a two-var filter: " + relExpr.toString());
            }
            String string = relExpr.L_atom.name;
            String string2 = relExpr.R_atom.name;
            Set<String> set2 = this.occPosSet_for_CSRAlias_for_var.get(string).keySet();
            Set<String> set3 = this.occPosSet_for_CSRAlias_for_var.get(string2).keySet();
            this.log("Lvar=" + string + " CSRAliasSet: " + set2);
            this.log("Rvar=" + string2 + " CSRAliasSet: " + set3);
            set = this.get_commonMCSRAliasSet_for_2vars(string, string2);
            this.log("intersection=" + set);
            if (!set.isEmpty()) {
                set.clear();
                continue;
            }
            this.log("this two-var filter needs processing: the two vars never occur in the same CSR");
            String string3 = "";
            NatVarOpt_Structure natVarOpt_Structure = natVarOpt_Info.get_NatVarOpt_Structure(string);
            NatVarOpt_Structure natVarOpt_Structure2 = natVarOpt_Info.get_NatVarOpt_Structure(string2);
            this.log("for Lvar=" + string + ":\n" + natVarOpt_Structure.toString());
            this.log("for Rvar=" + string2 + ":\n" + natVarOpt_Structure2.toString());
            if (natVarOpt_Structure.natVarCountForAlias_for_TFTidx.keySet().size() > 1 || natVarOpt_Structure2.natVarCountForAlias_for_TFTidx.keySet().size() > 1) {
                this.log("filter2vdco native processing SKIPPED because of more than one TFTs for Lvar and/or Rvar (will be handled in SPARQL)");
                continue;
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            String string4 = "";
            String string5 = "";
            Object object5 = natVarOpt_Structure.natVarCountForAlias_for_TFTidx.keySet().iterator();
            while (object5.hasNext()) {
                int n = (Integer)object5.next();
                object4 = this.TFTinfoGlobalList.get(n);
                string4 = ((TFTinfo)object4).termType;
                string5 = ((TFTinfo)object4).datatype;
                this.log("Lvar_TermType=" + string4 + " Lvar_datatype=" + string5);
                this.log("Lvar_TFTinfo=" + object4);
                this.log("Lvar_TFTidx=" + n);
                object3 = natVarOpt_Structure2.natVarCountForAlias_for_TFTidx.keySet().iterator();
                while (object3.hasNext()) {
                    int n2 = (Integer)object3.next();
                    this.log("  Rvar_TFTidx=" + n2);
                    if (n == n2) continue;
                    object2 = this.TFTinfoGlobalList.get(n2);
                    this.log("Rvar_TFTinfo=" + object2);
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                    bl4 = false;
                    if (!((TFTinfo)object4).termType.equals(((TFTinfo)object2).termType)) {
                        this.log("termType mismatch: Lvar_TFTinfo.termType=" + ((TFTinfo)object4).termType + " Rvar_TFTinfo.termType=" + ((TFTinfo)object2).termType);
                        bl = true;
                        string3 = this.gen_e_z_termType_based_cond(relExpr, bl);
                    } else if (((TFTinfo)object4).termType.equals(rrLiteral)) {
                        if (!((TFTinfo)object4).datatype.equals(((TFTinfo)object2).datatype)) {
                            bl2 = true;
                            if (!((TFTinfo)object4).datatype_family.equals(((TFTinfo)object2).datatype_family)) {
                                bl3 = true;
                                if (!this.isNumFltDbl(((TFTinfo)object4).datatype_family) || !this.isNumFltDbl(((TFTinfo)object2).datatype_family)) {
                                    bl4 = true;
                                }
                            }
                        }
                        if (bl2) {
                            this.log("non-identical datatype: datatype_mismatch=" + bl2 + " | datatype_family_mismatch=" + bl3 + " | datatype_family_incompatible=" + bl4);
                            String string6 = this.gen_e_z_datatype_based_cond(relExpr, bl2, bl3, bl4);
                            if (string6 != null) {
                                string3 = string6;
                            }
                        }
                    }
                    if (string3.length() <= 0) continue;
                    break;
                }
                if (string3.length() <= 0) continue;
                break;
            }
            if (string3.length() == 0) {
                this.log("no condition could be generated for current relExpr (termTypes match and datatypes compatible): fall back to SPARQL-generated condition");
                object5 = null;
                String string7 = null;
                object4 = set2.iterator();
                if (object4.hasNext()) {
                    object5 = object3 = (String)object4.next();
                }
                if ((object4 = set3.iterator()).hasNext()) {
                    object3 = object4.next();
                    string7 = object3;
                }
                this.log("Lvar_CSRAliasSet=" + set2 + " chosen=" + (String)object5);
                this.log("Rvar_CSRAliasSet=" + set3 + " chosen=" + string7);
                object4 = relExpr.compOperator.equals("SAMETERM") ? "=" : (relExpr.compOperator.equals("DIFFTERM") ? "!=" : relExpr.compOperator);
                this.log("sql_compOperator=" + (String)object4);
                if (string4.equals(rrIRI) || string4.equals(rrBlankNode)) {
                    this.log("[IRIorBN]");
                    if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM") || relExpr.compOperator.equals("=") || relExpr.compOperator.equals("!=")) {
                        object3 = natVarOpt_Info.get_optOutNatCond_For_Filter2v(string, string2, (String)object4);
                        if (!((String)object3).equals("")) {
                            this.log("CASE: =, !=, SAMETERM, DIFFTERM [FILTER_OPTIMIZED]");
                            object = object3;
                            this.VarSet_filter2vCond_outer.add(string);
                            this.VarSet_filter2vCond_outer.add(string2);
                            this.log("VarSet_filter2vCond_outer: " + this.VarSet_filter2vCond_outer);
                        } else {
                            this.log("//CASE: =, !=, SAMETERM, DIFFTERM [NOT_FILTER_OPTIMIZED]");
                            object = (String)object + COND_CONNECTOR + (String)object5 + "." + string + BASE_PREFIX_COLNAME_SEP + (String)object4 + BASE_PREFIX_COLNAME_SEP + string7 + "." + string2;
                        }
                        this.log("filter2vdco_condExpr=" + (String)object);
                        continue;
                    }
                    this.log("//CASE: <, >, <=, >=");
                    object = (String)object + " AND 1=0 ";
                    continue;
                }
                if (!string4.equals(rrLiteral)) continue;
                this.log("[Literal] datatype=" + string5);
                object3 = "";
                if ((relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM") || relExpr.compOperator.equals("=") || relExpr.compOperator.equals("!=")) && !((String)(object3 = natVarOpt_Info.get_optOutNatCond_For_Filter2v(string, string2, (String)object4))).equals("")) {
                    object = object3;
                    this.VarSet_filter2vCond_outer.add(string);
                    this.VarSet_filter2vCond_outer.add(string2);
                    this.log("VarSet_filter2vCond_outer: " + this.VarSet_filter2vCond_outer);
                }
                if (((String)object3).equals("")) {
                    String string8 = "";
                    object2 = "";
                    this.log(this.TYPE_FAMILY(string5));
                    if (this.isNumFltDbl(this.TYPE_FAMILY(string5))) {
                        this.log(this.TYPE_FAMILY(string5));
                        string8 = "to_number(";
                        object2 = ")";
                    }
                    object = (String)object + COND_CONNECTOR + string8 + SDO_RDF_VNAME_BEG + (String)object5 + "." + string + ")" + (String)object2 + BASE_PREFIX_COLNAME_SEP + (String)object4 + BASE_PREFIX_COLNAME_SEP + string8 + SDO_RDF_VNAME_BEG + string7 + "." + string2 + ")" + (String)object2;
                }
                this.log("filter2vdco_condExpr=" + (String)object);
                continue;
            }
            if (string3.equals(" AND 1=0 ")) {
                this.log("COND_FALSE generated by relExpr: set global COND_FALSE and exit");
                object = " AND 1=0 ";
                break;
            }
            object = (String)object + string3;
        }
        this.log("genFilter2vCond_outer: filter2vdco_condExpr: " + (String)object);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    String getGraphCondition_for_UnionOperand(int n, String string, boolean bl, int n2, List<Map<String, String>> list, List<String> list2, String string2) throws RDFException, SQLException {
        String string3;
        Object object;
        String string4;
        String string5 = "";
        String string6 = " AND 1=0";
        String string7 = "";
        String string8 = "";
        Map<String, String> map = list.get(n2);
        String string9 = list2.get(n2);
        this.log("... entered getGraphCondition_for_UnionOperand: graph_use_mode=" + n + " bgp_graph=" + string + " rowNum=" + n2);
        if (n == 0) {
            return string5;
        }
        if (string != null) {
            if (n == 5) {
                return string6;
            }
            this.log("===>[size=" + list.size() + "] TpGEArray: " + list);
            this.log("===>[size=" + list2.size() + "] RRrLArray: " + list2);
            string4 = null;
            if (bl) {
                string4 = "'" + string.replace("'", "''") + "'";
                this.log("[const bgp_graph] chosen_gExpr=" + string4);
            }
            this.log("TpGE [for rowNum=" + n2 + "]:" + map);
            object = map.keySet().iterator();
        } else {
            if (n == 2) {
                return string6;
            }
            if ((n & 1) != 1) {
                throw new RDFException("EXCEPTION: Internal Error: graph_use_mode=" + n);
            }
            String string10 = "";
            String string11 = "";
            for (String string12 : this.ctx.defaultGraphList) {
                string11 = string11 + string10 + "'" + string12.replace("'", "''") + "'";
                if (string10.length() != 0) continue;
                string10 = ", ";
            }
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string12;
                string12 = iterator.next();
                string7 = string7 + COND_CONNECTOR + string12 + " IN (" + string11 + ")";
            }
            return string7;
        }
        while (object.hasNext()) {
            string3 = object.next();
            String string13 = map.get(string3);
            if (string4 == null) {
                string4 = string3;
                this.log("chosen_gExpr=" + string4);
                continue;
            }
            Object object2 = COND_CONNECTOR + string4 + " = " + string3;
            if (bl) {
                int n3 = Integer.parseInt(this.get_subStringAtIndex(string13, 0, "+"));
                String string14 = this.get_subStringAtIndex(string9, n3, ":");
                RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(string14);
                String string15 = rRTabRowInfo.pogExpr;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                StringBuffer stringBuffer = new StringBuffer("");
                String string16 = RelationalBGP.sqlTempl2sqlExpr(string15.substring(1, string15.length() - 1), rrIRI, string2 + ".", stringBuffer, arrayList, arrayList2, null, null, this.ctx);
                String string17 = null;
                string17 = arrayList.size() == 0 ? "1=1" : this.find_optimized_CondExpr(string, arrayList, arrayList2, string2, rRTabRowInfo.Tmap, null);
                this.log("[bgp_graph is constant] gCondExpr: " + (String)object2 + " optimized_gCondExpr: " + string17);
                if (string17 != null) {
                    object2 = COND_CONNECTOR + string17;
                }
            }
            string7 = string7 + (String)object2;
            this.log("===>COND (after considering TpGE gExpr=" + string3 + ": " + string7);
        }
        if ((n & 2) != 2) return string8 + string7;
        object = "";
        string3 = "";
        boolean bl2 = false;
        for (String string18 : this.ctx.namedGraphsList) {
            string3 = string3 + (String)object + "'" + string18.replace("'", "''") + "'";
            if (bl && string.equals(string18)) {
                bl2 = true;
                break;
            }
            if (((String)object).length() != 0) continue;
            object = ", ";
        }
        if (bl) {
            if (!bl2) {
                this.log("NO-MATCH for GRAPH clause constant (" + string + ") in FROM NAMED list (" + string3 + ")");
                return string6;
            }
            this.log("found GRAPH clause constant (" + string + ") in (partial) FROM NAMED list (" + string3 + ")");
            string8 = "";
            return string8 + string7;
        } else {
            if (!this.is_bgp_graph_a_var) throw new RDFException("INTERNAL ERROR: SHOULD NEVER REACH THIS CODE: graph_use_mode=" + n + " bgp_graph=" + string + " is_bgp_graph_const=" + bl + " is_bgp_graph_a_var=" + this.is_bgp_graph_a_var);
            string8 = COND_CONNECTOR + string4 + " IN (" + string3 + ")";
        }
        return string8 + string7;
    }

    String get_po_CondExpr(int n, String string, String string2) {
        int n2;
        String string3 = "+" + n + ":";
        if (n == -1) {
            string3 = "S:";
        }
        if ((n2 = string.indexOf(string3)) == -1) {
            return "";
        }
        int n3 = string.indexOf("L", n2);
        this.log("str=" + string3 + " pos1=" + n2 + " pos2=" + n3);
        int n4 = Integer.parseInt(string.substring(n2 + string3.length(), n3));
        int n5 = string.indexOf(NATIVE_SUFFIX, n3);
        int n6 = Integer.parseInt(string.substring(n3 + 1, n5));
        String string4 = string2.substring(n4, n4 + n6);
        return string4;
    }

    String buildSQL_NoRows_for_TpatCSRgroup_Tmap(Map<String, String> map, List<String> list) {
        StringBuffer stringBuffer = new StringBuffer("");
        this.log("FirstOccPos_for_tuple=" + map);
        stringBuffer.append("\nSELECT ");
        boolean bl = true;
        for (String string : map.keySet()) {
            this.log("var=" + string);
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append("null AS " + string);
        }
        if (bl) {
            stringBuffer.append("null");
        } else {
            this.log("native_var_list=" + list);
            if (list != null) {
                for (String string : list) {
                    this.log("native_var=" + string);
                    stringBuffer.append(", null AS " + string + NATIVE_SUFFIX);
                }
            }
        }
        stringBuffer.append("\n  FROM SYS.DUAL");
        stringBuffer.append("\n WHERE 1=0");
        return stringBuffer.toString();
    }

    String buildSQL_NoRows_for_BGP() throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\nSELECT ");
        boolean bl = true;
        List<String> list = this.get_BGPvarsList();
        if (list.size() > 0) {
            for (String string : list) {
                this.log("var=" + string);
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append("null AS " + string);
            }
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append("\n  FROM SYS.DUAL");
        stringBuffer.append("\n WHERE 1=0");
        return stringBuffer.toString();
    }

    boolean buildSQL_for_UArow_of_MCSR(MCSR mCSR, int n, NatVarOpt_Info natVarOpt_Info, Set<String> set) throws RDFException, SQLException {
        int n2;
        String string;
        Object object2;
        String string222;
        this.log("ENTERING: buildSQL_for_UArow_of_MCSR ");
        this.log("       mcsr: " + mCSR.getMCSRKey());
        this.log("  mcsrAlias: " + mCSR.getMCSRAlias());
        this.log("   UArowNum_for_MCSR: " + n);
        UArowNatSelectInfo uArowNatSelectInfo = mCSR.getUArowNatSelectInfoArray().get(n);
        StringBuffer stringBuffer = new StringBuffer(uArowNatSelectInfo.sqlSubq_SELECT_str);
        StringBuffer stringBuffer2 = new StringBuffer(uArowNatSelectInfo.sqlSubq_FROM_str);
        StringBuffer stringBuffer3 = new StringBuffer(uArowNatSelectInfo.sqlSubq_WHERE_str);
        StringBuffer stringBuffer4 = new StringBuffer("");
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (String string222 : mCSR.CSRKeyList) {
            String string2;
            String string3;
            String string4;
            Object object;
            object2 = this.CSRinfo_for_CSRkey.get(string222);
            int n22 = n % ((CSRinfo)object2).getUArowsCount();
            String object4 = ((CSRinfo)object2).get_Tmap_for_UArowNum(n22);
            this.log("bSUM CSRKey loop: CSRkey: " + string222 + " UArowNum_for_CSR=" + n22 + " Tmap: " + object4);
            string = ((CSRinfo)object2).sAliasArray.get(n22);
            String string5 = this.LtabExpr_for_Tmap.get(object4) + BASE_PREFIX_COLNAME_SEP + string;
            String string6 = this.SubjRRrowid_for_Tmap.get(object4);
            String string7 = this.SubjExpr_for_Tmap.get(object4);
            RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(this.SubjRRrowid_for_Tmap.get(object4));
            String string8 = string7.substring(0, 2);
            int n3 = Integer.valueOf(string7.substring(1, 2));
            ACRinfo aCRinfo = mCSR.getACRinfo_for_AliasComponentRRrowid(string, "subject", string6);
            this.log("  bSUM: BEFORE code block for compute_sExpr_and_sCond call:");
            this.log("      : CSRelem.UArowNatSelectInfoArray.get(" + n22 + "): " + ((CSRinfo)object2).UArowNatSelectInfoArray.get(n22));
            if (aCRinfo == null) {
                object = ((CSRinfo)object2).UArowNatSelectInfoArray.get(n22);
                string4 = this.compute_sExpr_and_sCond((CSRinfo)object2, object4, n22, string, string6, natVarOpt_Info, (UArowNatSelectInfo)object);
                aCRinfo = mCSR.getACRinfo_for_AliasComponentRRrowid(string, "subject", string6);
            } else if (!((CSRinfo)object2).CSR_is_subj_const) {
                object = ((CSRinfo)object2).UArowNatSelectInfoArray.get(n22);
                ((UArowNatSelectInfo)object).add_ColList_for_var(((CSRinfo)object2).CSR_subj, aCRinfo.get_ACRcolList());
            }
            object = aCRinfo.get_ACRexpr();
            string4 = aCRinfo.get_ACRcondExpr();
            if (string4 != null && string4.length() > 0 && !(string3 = ((CSRinfo)object2).condArray.get(n22)).contains(string4)) {
                ((CSRinfo)object2).condArray.set(n22, string4 + string3);
            }
            this.log("  bSUM: AFTER code block for compute_sExpr_and_sCond call:");
            this.log("      : iUriExpr: " + (String)object);
            this.log("      : sCondExpr: " + string4);
            this.log("      : CSRelem.UArowNatSelectInfoArray.get(" + n22 + "): " + ((CSRinfo)object2).UArowNatSelectInfoArray.get(n22));
            int n4 = this.buildSQL_for_TpatCSRgroup_Tmap((CSRinfo)object2, object4, string, 0, n, 1, (String)object, n3, string5, this.bgp_graph, this.is_bgp_graph_const, natVarOpt_Info, set);
            this.log("returned from buildSQL_for_TpatCSRgroup_Tmap: UAnumTrueRows=" + n4 + ": CSRelem.UArowNatSelectInfoArray.size()=" + ((CSRinfo)object2).UArowNatSelectInfoArray.size());
            if (n4 == 0) {
                this.log("Invalidating UArowNum_for_MCSR=" + n + " query for MCSR (" + mCSR.getMCSRAlias() + ") " + mCSR.getMCSRKey() + "...");
                this.log("... ZERO true rows for CSRelem (" + ((CSRinfo)object2).getCSRAlias() + ")  Tmap=" + object4);
                uArowNatSelectInfo.selListEndpos = -1;
                this.log("RETURNING: false ");
                return false;
            }
            UArowNatSelectInfo uArowNatSelectInfo2 = ((CSRinfo)object2).UArowNatSelectInfoArray.get(n22);
            this.log("READY TO APPEND the following (if a non-EMPTY string) to MCSR sqlSubq[SELECT|FROM|WHERE]_str: UArowNum_for_MCSR=" + n);
            this.log(uArowNatSelectInfo2.toString());
            if (!uArowNatSelectInfo2.sqlSubq_SELECT_str.equals("")) {
                stringBuffer.append(", " + uArowNatSelectInfo2.sqlSubq_SELECT_str);
                this.log("AFTER APPENDing [UArowNum_for_MCSR=" + n + "] sbSqlSubq_SELECT_for_MCSR: |" + stringBuffer + "$$$");
            }
            if (!uArowNatSelectInfo2.sqlSubq_FROM_str.equals("")) {
                string2 = uArowNatSelectInfo2.sqlSubq_FROM_str.charAt(0) == ',' ? "" : ", ";
                stringBuffer2.append(string2 + uArowNatSelectInfo2.sqlSubq_FROM_str);
                this.log("AFTER APPENDing [UArowNum_for_MCSR=" + n + "] [listElem_sep: " + string2 + "] sbSqlSubq_FROM_for_MCSR: |" + stringBuffer2 + "$$$");
            }
            if (!uArowNatSelectInfo2.sqlSubq_WHERE_str.equals("")) {
                stringBuffer3.append(COND_CONNECTOR + uArowNatSelectInfo2.sqlSubq_WHERE_str);
                this.log("AFTER APPENDing [UArowNum_for_MCSR=" + n + "] sbSqlSubq_WHERE_for_MCSR: |" + stringBuffer3 + "$$$");
            }
            this.log("multi-occ handling for MCSR " + mCSR.getMCSRKey());
            this.log(natVarOpt_Info.toString());
            string2 = "";
            String string9 = "";
            for (String string10 : this.varsList_for_CSRAlias.get(((CSRinfo)object2).getCSRAlias())) {
                if (!hashMap.containsKey(string10)) {
                    hashMap.put(string10, uArowNatSelectInfo2.colList_for_var.get(string10));
                } else {
                    this.log("IGNORING: Another colList for var=" + string10 + " colList: " + uArowNatSelectInfo2.colList_for_var.get(string10));
                }
                String string11 = this.FullOccInfo_for_VarPlusCSRAlias.get(string10 + "+" + ((CSRinfo)object2).getCSRAlias());
                int n5 = string11.length() - string11.replace("+", "").length();
                this.log("processing var=" + string10 + " [occCount=" + n5 + "]: FullOccInfo=> " + string11);
                if (n5 == 1) continue;
                string2 = natVarOpt_Info.noVa_compose_multiOccVar_joinCond_for_UArow(string10, ((CSRinfo)object2).getCSRAlias(), n, (String)object, n3, ((CSRinfo)object2).pExprArrays, ((CSRinfo)object2).oExprArrays, ((CSRinfo)object2).gExprArray, ((CSRinfo)object2).RRrLArray, this.ctx);
                this.log("NATLOCALOPTCOND=" + string2);
                if (string2.indexOf(" AND 1=0 ") >= 0) {
                    string9 = " AND 1=0 ";
                    break;
                }
                string9 = string9 + string2;
            }
            this.log("ALLNATLOCALOPTCOND=" + string9);
            stringBuffer4.append(string9);
        }
        this.log("*  sbMultiOccJoinCond_for_MCSR=" + stringBuffer4.toString());
        String string13 = natVarOpt_Info.noVa_compose_multiOccVar_joinCond_for_UArow_across_CSRs(mCSR, n, this.ctx);
        this.log("*  multiOccVar_joinCond=" + (String)string13);
        if (string13.indexOf(" AND 1=0 ") >= 0) {
            this.log("Invalidating UArowNum_for_MCSR=" + n + " query for MCSR (" + mCSR.getMCSRAlias() + ") " + mCSR.getMCSRKey());
            this.log("... COND_FALSE  AND 1=0  found computing mult-occ join conditions accross CSRs");
            uArowNatSelectInfo.selListEndpos = -1;
            this.log("RETURNING: false ");
            return false;
        }
        string222 = "";
        for (RelExpr relExpr : this.TwoVarRelExprFilterList_for_BGP) {
            if (relExpr.L_atom.type != 0 || relExpr.R_atom.type != 0) continue;
            this.log("Two-var filter condition: " + relExpr.toString());
            if (!mCSR.getVarSet().contains(relExpr.L_atom.name) || !mCSR.getVarSet().contains(relExpr.R_atom.name)) continue;
            this.log("Two-var filter condition: BOTH vars appear in MCSR=" + mCSR.getMCSRAlias());
            String string12 = this.genFilter2vCond_new_v2(mCSR, n, relExpr);
            this.log("*  delta_v2_for_mcsr=" + string12);
            if (string222.contains(string12)) continue;
            string222 = string222 + string12;
        }
        this.log("*  filter2vdco_condExpr_intraMCSR=" + string222);
        if (string222.indexOf(" AND 1=0 ") >= 0) {
            this.log("Invalidating UArowNum_for_MCSR=" + n + " query for MCSR (" + mCSR.getMCSRAlias() + ") " + mCSR.getMCSRKey());
            this.log("... COND_FALSE  AND 1=0  found computing 2 variable filter intra MCSR");
            uArowNatSelectInfo.selListEndpos = -1;
            this.log("RETURNING: false ");
            return false;
        }
        this.log("going to process GEOMETRY filters at MCSR level");
        object2 = "";
        for (RelExpr relExpr : this.RelExprFilterList_for_BGP) {
            this.log("checking relExpr for GEOMETRY filter: " + relExpr.toString());
            if (relExpr.RelExprFlags != 2L) {
                this.log("buildSQL_for_TpatCSRgroup_Tmap: skipping non-GEOMETRY filter at UAROW level");
                continue;
            }
            if (relExpr.procAtLevel != null && !relExpr.procAtLevel.equals("MCSR_LEVEL")) {
                this.log("buildSQL_for_TpatCSRgroup_Tmap: skipping filter at MCSR level b/c it has already been processed at level: " + relExpr.procAtLevel);
                continue;
            }
            this.log("going to process GEOMETRY filters at MCSR level");
            this.log("current beg of iter value of condExpr_geometry_filter: " + (String)object2);
            string = this.genFilter_v3(mCSR, "MCSR_LEVEL", null, n, null, null, null, relExpr, mCSR.getVarSet(), null, null);
            this.log("condExpr_geo :" + string);
            if (string.equals(" AND 1=0 ")) {
                object2 = " AND 1=0 ";
                break;
            }
            if (string.equals("")) {
                this.log("we did not handle this filter here (probably because some filter vars are NOT in scope (requires outer cond)");
                continue;
            }
            this.log("processed this filter at MCSR level: relExpr.procAtLevel=" + relExpr.procAtLevel);
            object2 = (String)object2 + COND_CONNECTOR + string;
            this.log("end of iter value of condExpr_geometry_filter: " + (String)object2);
        }
        this.log("finally, MCSR level: condExpr_geometry_filter: " + (String)object2);
        for (String string14 : hashMap.keySet()) {
            uArowNatSelectInfo.colList_for_var.put(string14, (List<String>)hashMap.get(string14));
        }
        this.log("colList_for_var for MCSR for UArowNum_for_MCSR: " + n + " : " + uArowNatSelectInfo.colList_for_var);
        uArowNatSelectInfo.sqlSubq_SELECT_str = "SELECT " + stringBuffer.toString().replaceFirst("^ *, *", "");
        this.log("sbSqlSubq_FROM_for_MCSR.toString()=|" + stringBuffer2.toString() + "$$$");
        uArowNatSelectInfo.sqlSubq_FROM_str = "\n  FROM " + stringBuffer2.toString().replaceFirst("^ *, *", "");
        uArowNatSelectInfo.sqlSubq_WHERE_str = "\n WHERE " + stringBuffer3.toString().replaceFirst("^ * AND  *", "") + stringBuffer4.toString() + (String)string13 + string222 + (String)object2;
        if (uArowNatSelectInfo.sqlSubq_WHERE_str.equals("\n WHERE ")) {
            uArowNatSelectInfo.sqlSubq_WHERE_str = "";
        }
        Object object5 = "UNION ALL";
        if ((this.ctx.R2RFlags & 0x4000L) > 0L) {
            object5 = "UNION";
        }
        boolean bl = false;
        if (mCSR.getLastValidUArowNum() >= 0) {
            n2 = ("\n" + (String)object5 + "\n").length();
        }
        this.log(" lastValidUArowNum: " + mCSR.getLastValidUArowNum());
        uArowNatSelectInfo.sqlSubq = (mCSR.getLastValidUArowNum() >= 0 ? "\n" + (String)object5 + "\n" : "") + uArowNatSelectInfo.sqlSubq_SELECT_str + uArowNatSelectInfo.sqlSubq_FROM_str + uArowNatSelectInfo.sqlSubq_WHERE_str;
        uArowNatSelectInfo.selListEndpos = n2 + uArowNatSelectInfo.sqlSubq_SELECT_str.length();
        this.log("FINALLY buildSQL_for_UArow_of_MCSR for MCSR " + mCSR.getMCSRKey());
        this.log("*  sqlSubq_SELECT_str=" + uArowNatSelectInfo.sqlSubq_SELECT_str);
        this.log("*  sqlSubq_FROM_str  =" + uArowNatSelectInfo.sqlSubq_FROM_str);
        this.log("*  sqlSubq_WHERE_str =" + uArowNatSelectInfo.sqlSubq_WHERE_str);
        this.log("*  selListEndpos     =" + uArowNatSelectInfo.selListEndpos);
        this.log("   sqlSubq           =" + uArowNatSelectInfo.sqlSubq);
        this.log("RETURNING: true ");
        return true;
    }

    /*
     * Could not resolve type clashes
     */
    int buildSQL_for_TpatCSRgroup_Tmap(CSRinfo cSRinfo, String string, String string2, int n, int n2, int n3, String string3, int n4, String string4, String string5, boolean bl, NatVarOpt_Info natVarOpt_Info, Set<String> set) throws RDFException, SQLException {
        String string6 = cSRinfo.getCSRAlias();
        Map<String, String> map = cSRinfo.get_FirstOccPos_for_tuple();
        String string7 = cSRinfo.CSR_subj;
        List<List<String>> list = cSRinfo.pExprArrays;
        List<List<String>> list2 = cSRinfo.oExprArrays;
        List<List<String>> list3 = cSRinfo.clobExprArrays;
        List<String> list4 = cSRinfo.fromArray;
        List<String> list5 = cSRinfo.condArray;
        List<String> list6 = cSRinfo.gExprArray;
        List<Set<String>> list7 = cSRinfo.GeesArray;
        List<Map<String, String>> list8 = cSRinfo.TpGEArray;
        List<String> list9 = cSRinfo.RRrLArray;
        Map<String, List<Set<String>>> map2 = cSRinfo.native_oExprSetArray_for_Var;
        List<UArowNatSelectInfo> list10 = cSRinfo.UArowNatSelectInfoArray;
        this.log("sAliasArray: " + cSRinfo.sAliasArray + "   RRrLArray: " + list9);
        String string8 = this.get_MCSRAlias_for_CSRAlias(string6);
        this.log("ENTERING: buildSQL_for_TpatCSRgroup_Tmap: tpCSR_alias=" + string6 + " MCSRAlias=" + string8);
        MCSR mCSR = cSRinfo.mcsrElem;
        StringBuffer stringBuffer = new StringBuffer("");
        int n5 = 0;
        RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(this.SubjRRrowid_for_Tmap.get(string));
        this.log("entered: buildSQL_for_TpatCSRgroup_Tmap: UAstartPos=" + n2 + ", numRows=" + n3 + " FirstOccPos_for_tuple: " + map);
        String string9 = "UNION ALL";
        if ((this.ctx.R2RFlags & 0x4000L) > 0L) {
            string9 = "UNION";
        }
        boolean bl2 = true;
        for (int i = 0; i < n3; ++i) {
            String string10;
            Object object8;
            Object object22;
            Object object3;
            Object object42;
            Object object52;
            Object object6;
            int n6 = n2 + i;
            int n7 = n6 % cSRinfo.getUArowsCount();
            String string11 = list5.get(n7);
            if (string11 == null) {
                this.log("cond is null: using workaround: FIX IT SOMETIME");
                string11 = "";
            }
            this.log("condArray[" + n7 + "]=" + string11);
            if (string11.indexOf(" AND 1=0 ") >= 0) {
                this.log("[Tmap=" + string + " UArowNum_for_MCSR=" + n6 + " UArowNum_for_CSR=" + n7 + "] : SKIPPED sql generation because condArray[" + n7 + "] => " + string11);
                ++n5;
                object6 = list10.get(n7);
                ((UArowNatSelectInfo)object6).sqlSubq = stringBuffer.toString();
                ((UArowNatSelectInfo)object6).selListEndpos = new Integer(-1);
                continue;
            }
            this.log("going to process GEOMETRY filters at UAROW level");
            object6 = "";
            for (Object object52 : this.RelExprFilterList_for_BGP) {
                this.log("checking relExpr for GEOMETRY filter: " + ((RelExpr)object52).toString());
                if (((RelExpr)object52).RelExprFlags != 2L) {
                    this.log("buildSQL_for_TpatCSRgroup_Tmap: skipping non-GEOMETRY filter at UAROW level");
                    continue;
                }
                if (((RelExpr)object52).procAtLevel != null && ((RelExpr)object52).procAtLevel.equals("TPAT_LEVEL")) {
                    this.log("buildSQL_for_TpatCSRgroup_Tmap: skipping filter at UAROW level b/c it has already been processed at level: " + ((RelExpr)object52).procAtLevel);
                    continue;
                }
                this.log("going to process GEOMETRY filters at UAROW level");
                this.log("currentbeg of iter value of condExpr_geometry_filter: " + (String)object6);
                this.log(" RRrLArray[" + n7 + "]: " + list9.get(n7));
                object42 = this.genFilter_v3(mCSR, "UAROW_LEVEL", string6, n7, null, list9.get(n7), null, (RelExpr)object52, cSRinfo.FirstOccPos_for_tuple.keySet(), list2, list3);
                this.log("condExpr_geo :" + (String)object42);
                if (((String)object42).equals(" AND 1=0 ")) {
                    object6 = " AND 1=0 ";
                    break;
                }
                if (((String)object42).equals("")) {
                    this.log("we did not handle this filter here (probably because some filter vars are NOT in scope (reuqires outer cond)");
                    continue;
                }
                this.log("processed this filter at UAROW level: relExpr.procAtLevel=" + ((RelExpr)object52).procAtLevel);
                object6 = (String)object6 + COND_CONNECTOR + (String)object42;
                this.log("end of iter value of condExpr_geometry_filter: " + (String)object6);
            }
            this.log("finally, UAROW level: condExpr_geometry_filter: " + (String)object6);
            string11 = string11 + (String)object6;
            this.log("[COND] 4 " + string11);
            Object object7 = "";
            for (Object object42 : this.TwoVarRelExprFilterList_for_BGP) {
                if (((RelExpr)object42).L_atom.type != 0 || ((RelExpr)object42).R_atom.type != 0) continue;
                this.log("Two-var filter condition: " + ((RelExpr)object42).toString());
                if (!this.varsList_for_CSRAlias.get(string6).contains(((RelExpr)object42).L_atom.name) || !this.varsList_for_CSRAlias.get(string6).contains(((RelExpr)object42).R_atom.name)) continue;
                this.log("Two-var filter condition: BOTH vars appear in CSR=" + string6);
                object3 = natVarOpt_Info.get_NatVarOpt_Structure(((RelExpr)object42).L_atom.name).get_TFTidx_occInfoSet_pairs(n7);
                object22 = natVarOpt_Info.get_NatVarOpt_Structure(((RelExpr)object42).R_atom.name).get_TFTidx_occInfoSet_pairs(n7);
                object8 = this.genFilter2vCond_new_v2(mCSR, n6, (RelExpr)object42);
                object7 = (String)object7 + (String)object8;
                string11 = string11 + (String)object7;
            }
            this.log("[COND] 3 " + string11);
            this.log(natVarOpt_Info.toString());
            object52 = this.varsList_for_CSRAlias.get(string6);
            this.log("varsList_for_CSRAlias for " + string6 + ": " + object52);
            object42 = "";
            object3 = "";
            for (Object object8 : this.varsList_for_CSRAlias.get(string6)) {
                string10 = this.FullOccInfo_for_VarPlusCSRAlias.get((String)object8 + "+" + string6);
                int n8 = string10.length() - string10.replace("+", "").length();
                this.log("processing var=" + (String)object8 + " [occCount=" + n8 + "]: FullOccInfo=> " + string10);
                if (n8 == 1) continue;
                object42 = natVarOpt_Info.noVa_compose_multiOccVar_joinCond_for_UArow((String)object8, string6, n7, string3, n4, list, list2, list6, list9, this.ctx);
                this.log("NATLOCALOPTCOND=" + (String)object42);
                if (((String)object42).indexOf(" AND 1=0 ") >= 0) {
                    object3 = " AND 1=0 ";
                    break;
                }
                object3 = (String)object3 + (String)object42;
            }
            this.log("ALLNATLOCALOPTCOND=" + (String)object3);
            string11 = string11 + (String)object3;
            this.log("[COND] 1 " + string11);
            if (string11.indexOf(" AND 1=0 ") >= 0) {
                this.log("[Tmap=" + string + " UArowNum_for_MCSR=" + n6 + " UArowNum_for_CSR=" + n7 + "] : SKIPPED sql generation because cond (including two-var filters) => " + string11);
                ++n5;
                object52 = list10.get(n7);
                ((UArowNatSelectInfo)object52).sqlSubq = stringBuffer.toString();
                ((UArowNatSelectInfo)object52).selListEndpos = new Integer(-1);
                continue;
            }
            if (bl2) {
                if (n > 0) {
                    stringBuffer.append("\n" + string9);
                }
                stringBuffer.append("\n-- Tmap=" + string + "\n");
                bl2 = false;
            }
            if (i > n5) {
                stringBuffer.append("\n" + string9 + "\n");
            }
            if (i == 0) {
                stringBuffer.append("\n");
            }
            this.log("generating SELECT-list");
            stringBuffer.append("SELECT ");
            object52 = new StringBuffer("");
            boolean bl3 = true;
            this.log("Going to process SELECT-list for vars: " + cSRinfo.getVarsToProject());
            for (Object object22 : cSRinfo.getVarsToProject()) {
                Object object9;
                String string12;
                this.log("SELECT-list:   var=" + (String)object22);
                this.log(" UArowNum_for_MCSR=" + n6);
                this.log("  UArowNum_for_CSR=" + n7);
                this.log("            rowNum=" + i);
                if (this.dummyTBList.size() > 0 && (((String)object22).equals("dummyS") || ((String)object22).equals("dummyP") || ((String)object22).equals("dummyO"))) continue;
                object8 = map.get(object22);
                string10 = this.getExprFromArrays((String)object8, n7, string3, list, list2, list6, null);
                this.log("SELECT-list: var=" + (String)object22 + " occPos=" + (String)object8 + " expr=" + string10);
                if (string10.substring(0, "'_:".length()).equals("'_:") && (this.ctx.R2RFlags & 0x40L) != 64L) {
                    String string13;
                    string12 = "";
                    if (list7 != null && list7.get(n7) != null && list7.get(n7).size() > 0 && (this.ctx.R2RFlags & 0x80L) != 128L && (object9 = list7.get(n7).iterator()).hasNext() && (string13 = (String)object9.next()) != null && !string13.equals("NULL")) {
                        string12 = "g' || utl_raw.cast_to_raw(" + string13 + ") || 'g";
                    }
                    object9 = "'_:m" + this.model_id + string12 + "m";
                    this.log("expr=" + string10 + " | bNode_augm=" + (String)object9);
                    if (string10.indexOf((String)object9) != 0) {
                        string10 = (String)object9 + string10.substring("'_:".length(), string10.length());
                        this.log("SELECT-list (after bNode prefix augmentation): var=" + (String)object22 + " occPos=" + (String)object8 + " expr=" + string10);
                    }
                }
                if (!bl3) {
                    ((StringBuffer)object52).append(", ");
                } else {
                    bl3 = false;
                }
                ((StringBuffer)object52).append(string10 + ALIAS_SEP + (String)object22);
                string12 = this.mcc_for_var.get(object22);
                if (!((String)object8).startsWith("object:") || string12 == null || !string12.equals("object")) continue;
                object9 = (String)object22 + "$RDFCLOB";
                this.log(" handling the CLOB version of var=" + (String)object22 + " clobVar=" + (String)object9);
                int n9 = Integer.valueOf(((String)object8).substring(((String)object8).indexOf(":") + 1));
                this.log("pos=" + n9 + " clobExprArrays [size=" + list3.size() + "]: " + list3);
                String string14 = list3.get(n9).get(n7);
                this.log("CLOB expression found: " + string14);
                this.log("SELECT-list: var=" + (String)object22 + " occPos=" + (String)object8 + " clobExpr=" + string14);
                ((StringBuffer)object52).append(", " + string14 + ALIAS_SEP + (String)object9);
                set.add((String)object22 + "+" + string8);
            }
            if (((StringBuffer)object52).length() == 0) {
                ((StringBuffer)object52).append("NULL");
            }
            this.log("[UArowNum_for_MCSR=" + n6 + " UArowNum_for_CSR=" + n7 + "]: SELECT-cklause=" + ((StringBuffer)object52).toString());
            stringBuffer.append(((StringBuffer)object52).toString());
            Integer n10 = new Integer(stringBuffer.length());
            object3 = string2.equals(cSRinfo.getCSRAlias()) ? string4 : "";
            this.log("[UArowNum_for_MCSR=" + n6 + " UArowNum_for_CSR=" + n7 + "]: FROM-clause=" + (String)object3 + list4.get(n7));
            stringBuffer.append("\n  FROM " + (String)object3 + list4.get(n7));
            this.log("[UArowNum_for_MCSR=" + n6 + " UArowNum_for_CSR=" + n7 + "]: SELECT-FROM clause=" + stringBuffer.toString());
            object22 = "";
            if (this.graph_use_mode > 0) {
                object22 = this.getGraphCondition_for_UnionOperand(this.graph_use_mode, string5, bl, n7, list8, list9, string6);
                this.log("graphCondition: ------------- \n" + (String)object22);
                string11 = string11 + (String)object22;
            }
            this.log("[COND - 2] " + string11);
            if (string11.indexOf(COND_CONNECTOR) == 0) {
                this.log("cond (before removal)=" + string11);
                string11 = string11.substring(COND_CONNECTOR.length(), string11.length());
                this.log("cond (AFTER removal)=" + string11);
            }
            if (!string11.equals("") && !string11.equals("\n")) {
                stringBuffer.append("\n WHERE " + string11 + "\n");
                this.log("[UArowNum_for_MCSR=" + n6 + " UArowNum_for_CSR=" + n7 + "]: WHERE-clause cond (cond.length()=" + string11.length() + "]=" + string11 + "***");
            }
            object8 = list10.get(n7);
            if (string11.indexOf(" AND 1=0 ") >= 0) {
                this.log("[Tmap=" + string + " UArowNum_for_MCSR=" + n6 + " UArowNum_for_CSR=" + n7 + "] : INVALID UArow sub-query because condArray[" + n7 + "] => " + string11);
                ++n5;
                ((UArowNatSelectInfo)object8).sqlSubq_SELECT_str = "";
                ((UArowNatSelectInfo)object8).sqlSubq_FROM_str = "";
                ((UArowNatSelectInfo)object8).sqlSubq_WHERE_str = "";
                ((UArowNatSelectInfo)object8).sqlSubq = stringBuffer.toString();
                ((UArowNatSelectInfo)object8).selListEndpos = new Integer(-1);
            } else {
                this.log("[Tmap=" + string + " UArowNum_for_MCSR=" + n6 + " UArowNum_for_CSR=" + n7 + "] : VALID UArow sub-query because condArray[" + n7 + "] => " + string11);
                ((UArowNatSelectInfo)object8).sqlSubq_SELECT_str = ((StringBuffer)object52).toString();
                ((UArowNatSelectInfo)object8).sqlSubq_FROM_str = (String)object3 + list4.get(n7);
                ((UArowNatSelectInfo)object8).sqlSubq_WHERE_str = string11;
                ((UArowNatSelectInfo)object8).sqlSubq = stringBuffer.toString();
                ((UArowNatSelectInfo)object8).selListEndpos = n10;
            }
            stringBuffer = new StringBuffer("");
        }
        return n3 - n5;
    }

    private boolean isTrueMatchingRRrow_for_Tmap(RRTabRowInfo rRTabRowInfo, String string, String string2, boolean bl, boolean bl2, String string3, boolean bl3, String string4, boolean bl4) throws RDFException, SQLException {
        String string5;
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        this.log("checking ...");
        if (rRTabRowInfo == null) {
            this.log("->SKIPPED deleted RRrowInfo");
            return false;
        }
        if (!rRTabRowInfo.Tmap.equals(string)) {
            this.log("->skipped non-matching Tmap=" + rRTabRowInfo.Tmap);
            return false;
        }
        if (rRTabRowInfo.pogExpr == null && (string2 == null && (this.graph_use_mode & 1) == 1 || string2 != null && !bl2)) {
            this.log("->skipped: unnamed graph not allowed: bgp_graph=" + string2 + " graph_use_mode=" + this.graph_use_mode);
            return false;
        }
        if (!bl3) {
            object4 = this.RelExprFilterList_for_BGP.iterator();
            while (object4.hasNext()) {
                object3 = (RelExpr)object4.next();
                if (((RelExpr)object3).RelExprFlags == 2L) {
                    this.log("skipping GEOMETRY filter");
                    continue;
                }
                n = ((RelExpr)object3).L_atom.type;
                int n2 = ((RelExpr)object3).R_atom.type;
                object2 = null;
                object = null;
                if (n == 0 && ((RelExpr)object3).L_atom.name.equals(string3) && n2 != 0) {
                    object2 = ((RelExpr)object3).L_atom;
                    object = ((RelExpr)object3).R_atom;
                } else {
                    if (n2 != 0 || !((RelExpr)object3).R_atom.name.equals(string3) || n == 0) continue;
                    object2 = ((RelExpr)object3).R_atom;
                    object = ((RelExpr)object3).L_atom;
                }
                string5 = ((RelExpr)object3).compOperator;
                boolean bl5 = true;
                if (((ASTTripleAtom)object).type != 1 && (string5.equals("=") || string5.equals("SAMETERM"))) {
                    bl5 = false;
                } else if (rRTabRowInfo.pExprType == RRTabRowInfo.MapExprType_CONSTANT) {
                    if (string5.equals("=") || string5.equals("SAMETERM")) {
                        if (!rRTabRowInfo.pExpr.equals("<" + ((ASTTripleAtom)object).name + ">")) {
                            bl5 = false;
                        }
                    } else if ((string5.equals("!=") || string5.equals("DIFFTERM")) && rRTabRowInfo.pExpr.equals("<" + ((ASTTripleAtom)object).name + ">")) {
                        bl5 = false;
                    }
                } else if (rRTabRowInfo.pExprType == RRTabRowInfo.MapExprType_TEMPLATE && (string5.equals("=") || string5.equals("SAMETERM")) && !RelationalBGP.matchableSqlTemplatePair(rRTabRowInfo.pExpr, "<" + ((ASTTripleAtom)object).name + ">", this.ctx)) {
                    bl5 = false;
                }
                if (bl5) continue;
                this.log("NO pred filter-satisfiability of RRrowInfo.pExpr: " + rRTabRowInfo.pExpr + " for [" + ((RelExpr)object3).toString() + "]");
                return false;
            }
        }
        if ((object4 = rRTabRowInfo.oTermType) == null) {
            if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_TEMPLATE) {
                object4 = rrIRI;
            } else if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_CONSTANT) {
                object4 = rRTabRowInfo.oExpr.charAt(0) == '<' ? rrIRI : (rRTabRowInfo.oExpr.charAt(0) == '\"' ? rrLiteral : rrBlankNode);
            } else if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_COLUMN) {
                object4 = rrLiteral;
            }
            if (rRTabRowInfo.paTmap != null) {
                object4 = rrIRI;
            }
        }
        this.log("oTermType: implicit=" + rRTabRowInfo.oTermType + " explicit=" + (String)object4);
        if (bl4) {
            this.log("checking matchability of RRrowInfo.oExpr: " + rRTabRowInfo.oExpr + " with: " + string4);
            object3 = new StringBuffer("");
            StringBuffer stringBuffer = new StringBuffer("");
            StringBuffer stringBuffer2 = new StringBuffer("");
            object2 = new StringBuffer("");
            this.findComponents_of_RDFterm(string4, (StringBuffer)object3, stringBuffer, stringBuffer2, (StringBuffer)object2);
            object = ((StringBuffer)object3).toString();
            string5 = stringBuffer.toString();
            String string6 = stringBuffer2.toString();
            String string7 = ((StringBuffer)object2).toString();
            String string8 = this.TYPE_FAMILY(string6);
            this.log("obje: vn=" + (String)object + " vt=" + string5 + " lt=" + string6 + " la=" + string7 + " tyfam=" + string8);
            if (string5.equals("PL@") && rRTabRowInfo.oLanguage == null || !string5.equals("PL@") && rRTabRowInfo.oLanguage != null) {
                this.log("NO object-matchability because of lang tag: RRrowInfo.oLanguage: " + rRTabRowInfo.oLanguage + " obje_lang: " + string7);
                return false;
            }
            if (string5.equals("PL@") && rRTabRowInfo.oLanguage != null && !rRTabRowInfo.oLanguage.equalsIgnoreCase(string7)) {
                this.log("NO object-matchability due to lang tag mismatch: RRrowInfo.oLanguage: " + rRTabRowInfo.oLanguage + " obje_lang: " + string7);
                return false;
            }
            if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_TEMPLATE && (rRTabRowInfo.oTermType == null || rRTabRowInfo.oTermType.equals(rrIRI))) {
                if (string4.charAt(0) != '<') {
                    this.log("NO object-matchability of rr:IRI RRrowInfo.oExpr: " + rRTabRowInfo.oExpr + " against non-IRI: " + string4);
                    return false;
                }
                if (!RelationalBGP.matchableSqlTemplatePair(rRTabRowInfo.oExpr, string4, this.ctx)) {
                    this.log("NO object-matchability of rr:IRI RRrowInfo.oExpr: " + rRTabRowInfo.oExpr + " against IRI obje: " + string4);
                    return false;
                }
            } else if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_CONSTANT) {
                if (!rRTabRowInfo.oExpr.equals(string4)) {
                    this.log("IGNORE (to allow caninical equality): NO object-matchability of constant RRrowInfo.oExpr: " + rRTabRowInfo.oExpr + " against constant obje: " + string4);
                    return true;
                }
            } else if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_COLUMN && (rRTabRowInfo.oTermType == null || rRTabRowInfo.oTermType.equals(rrLiteral))) {
                if (string4.charAt(0) != '\"') {
                    this.log("NO object-matchability of col-valued rr:Literal RRrowInfo.oExpr: " + rRTabRowInfo.oExpr + " against constant non-Literal obje: " + string4);
                    return false;
                }
                if (rRTabRowInfo.oDataType != null) {
                    String string9 = this.TYPE_FAMILY(rRTabRowInfo.oDataType.substring(1, rRTabRowInfo.oDataType.length() - 1));
                    this.log("omap_tyfam=" + string9 + " (RRrowInfo.oDataType=" + rRTabRowInfo.oDataType + ")");
                    if (!string9.equals(string8)) {
                        this.log("Skip: NOT MATCHABLE: omap_tyfam=" + string9 + " obje_tyfam=" + string8);
                        return false;
                    }
                }
            }
        } else if (this.SimpleConstraintList_for_Var.get(string4) != null) {
            object3 = this.SimpleConstraintList_for_Var.get(string4);
            this.log("isTrueMatchingRRrow_for_Tmap: obje is a var=" + string4 + " ... will check for satisfiability of all the simple constraints involving this var");
            this.log(object3.toString());
            for (n = 0; n < object3.size(); ++n) {
                String string10 = (String)object3.get(n);
                if (!(string10.equals("ISLITERAL") && !((String)object4).equals(rrLiteral) || string10.equals("!ISLITERAL") && ((String)object4).equals(rrLiteral) || (string10.equals("ISURI") || string10.equals("ISIRI")) && !((String)object4).equals(rrIRI) || (string10.equals("!ISURI") || string10.equals("!ISIRI")) && ((String)object4).equals(rrIRI) || string10.equals("ISBLANK") && !((String)object4).equals(rrBlankNode)) && (!string10.equals("!ISBLANK") || !((String)object4).equals(rrBlankNode))) continue;
                this.log("NO constraint-satisfiability of RRrowInfo.oTermType: " + rRTabRowInfo.oTermType + "(" + (String)object4 + ") with simple constraint: " + string10);
                return false;
            }
        }
        if (rRTabRowInfo.pogExprType != 3) {
            this.log("checking matchability of RRrowInfo.pogExpr: " + rRTabRowInfo.pogExpr);
            this.log("graph_use_mode=" + this.graph_use_mode + " bgp_graph=" + string2 + " defaultGraphList=" + this.ctx.defaultGraphList + " namedGraphsList=" + this.ctx.namedGraphsList);
            if (string2 == null) {
                if ((this.graph_use_mode & 1) == 1 && !RelationalBGP.matchableSqlTemplate_in_list(rRTabRowInfo.pogExpr, this.ctx.defaultGraphList, this.ctx)) {
                    this.log("NO graph-matchability of RRrowInfo.pogExpr: " + rRTabRowInfo.pogExpr + " against FROM graphs: " + this.ctx.defaultGraphList);
                    return false;
                }
            } else if (bl) {
                this.log("here: bgp_graph=" + string2 + " graph_use_mode=" + this.graph_use_mode);
                if ((this.graph_use_mode & 3) == 0) {
                    if (!RelationalBGP.matchableSqlTemplatePair(rRTabRowInfo.pogExpr, string2, this.ctx)) {
                        this.log("NO graph-matchability of RRrowInfo.pogExpr: " + rRTabRowInfo.pogExpr + " against GRAPH clause graph: " + string2);
                        return false;
                    }
                } else if ((this.graph_use_mode & 2) == 2 && !RelationalBGP.matchableSqlTemplatePair(rRTabRowInfo.pogExpr, string2, this.ctx)) {
                    this.log("NO graph-matchability of RRrowInfo.pogExpr: " + rRTabRowInfo.pogExpr + " against GRAPH clause graph: " + string2);
                }
            } else if (this.is_bgp_graph_a_var) {
                if ((this.graph_use_mode & 2) == 2 && !RelationalBGP.matchableSqlTemplate_in_list(rRTabRowInfo.pogExpr, this.ctx.namedGraphsList, this.ctx)) {
                    this.log("NO graph-matchability of RRrowInfo.pogExpr: " + rRTabRowInfo.pogExpr + " against FROM NAMED graphs: " + this.ctx.namedGraphsList);
                    return false;
                }
            } else {
                throw new RDFException("INTERNAL ERROR: SHOULD NEVER REACH THIS CODE: graph_use_mode=" + this.graph_use_mode + " bgp_graph=" + string2 + " is_bgp_graph_const=" + bl + " is_bgp_graph_a_var=" + this.is_bgp_graph_a_var);
            }
        }
        return true;
    }

    private void buildSQLNew() throws RDFException, SQLException {
        this.log("Entered buildSQLNew");
        this.log("Structures involved here are:");
        this.log("===============================================:");
        this.log("[Use] TpatSet_for_TpatCSRGroup:           Map => <SubjTmapSet_key (CSR key), TpatSet (triple-patterns in this CSR>");
        this.log("[Use] Subj_for_TpatCSRGroup:              Map => <SubjTmapSet_key, Subj>");
        this.log("[Use] TmapSet_for_TpatCSRGroup:           Map => <SubjTmapSet_key, TmapSet (set of Tmaps from matching RR rows)>");
        this.log("[Use] LtabExpr_for_Tmap:                  Map => <Tmap, rowsrc>");
        this.log("[Use] SubjExpr_for_Tmap:                  Map => <Tmap, sTermType+RRrowInfo.sExprType+RRrowInfo.sExpr>");
        this.log("[Use] RRrowSet_for_TriplePattern:         Map => <tp_key, RRrowSet(actually, RRrowidSet)>");
        this.log("-----");
        this.log("[Pop] CSRAlias_for_TpatCSRGroup:          Map => <SubjTmapSet_key (CSR key), CSRAlias (e.g., T0)>");
        this.log("[P/U] FirstOccPos_for_tuple (local: CSR): Map => <Var, FirstOcc (position:idx of pred-obje pair, e.g., object:3)>");
        this.log("[P/U] RRrowList_for_Tmap (local: CSR-Tmap): List => <truly matching RRrowids (matchable based on data)>");
        this.log("[Pop] FullOccInfo_for_VarPlusCSRAlias:    Map => <Var+CSRAlias, formatted string => e.g., S:0+O:3+O:12>");
        this.log("[Pop] occPosSet_for_CSRAlias_for_var:     Map => Var => {CSRAlias => {occPos, occPos,...}, ... }");
        this.log("[Pop] TypeInfoSet_for_VarPlusCSRAlias:    Map => <Var+CSRAlias, Set<TypeInfo (formatted string => objeDataType RDFdatatype_DBColType>>");
        this.log("===============================================:");
        int n = -1;
        for (String string : this.TpatSet_for_TpatCSRGroup.keySet()) {
            Object object;
            Object object22;
            Iterator<Object> iterator;
            Object object3;
            Object object4;
            String string2 = this.Subj_for_TpatCSRGroup.get(string);
            CSRinfo cSRinfo = new CSRinfo(string, string2, this.TmapSet_for_TpatCSRGroup.get(string), this.TpatSet_for_TpatCSRGroup.get(string));
            this.CSRinfo_for_CSRkey.put(cSRinfo.CSR_key, cSRinfo);
            int n2 = -1;
            String string3 = "T" + ++n;
            this.CSRAlias_for_TpatCSRGroup.put(string, string3);
            cSRinfo.setCSRAlias(string3);
            this.CSRinfo_for_CSRAlias.put(cSRinfo.getCSRAlias(), cSRinfo);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            this.predList_for_CSRAlias.put(string3, arrayList);
            this.objeList_for_CSRAlias.put(string3, arrayList2);
            this.varsList_for_CSRAlias.put(string3, arrayList3);
            cSRinfo.set_predList(arrayList);
            cSRinfo.set_objeList(arrayList2);
            cSRinfo.set_varsList(arrayList3);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            boolean bl = false;
            if (string2.charAt(0) == '<' || string2.charAt(0) == '\"' || string2.charAt(0) == '_') {
                bl = true;
            } else {
                hashMap.put(string2, "subject:0");
                this.add_to_FullOccInfo(string2, string3, "subject", 0);
                if (!arrayList3.contains(string2)) {
                    arrayList3.add(string2);
                }
            }
            boolean bl2 = false;
            if (this.graphVar != null) {
                if (hashMap.get(this.graphVar) == null) {
                    hashMap.put(this.graphVar, "graph:0");
                }
                this.add_to_FullOccInfo(this.graphVar, string3, "graph", 0);
                if (!arrayList3.contains(this.graphVar)) {
                    arrayList3.add(this.graphVar);
                }
            }
            this.log("=================================================== TpatCSR=" + string + " common_subj=" + string2);
            int n3 = 0;
            for (String string4 : this.TpatSet_for_TpatCSRGroup.get(string)) {
                object4 = this.TpatInfo_for_TpatKey.get(string4);
                object3 = ((TriplesBlock)object4).getSubject();
                iterator = ((TriplesBlock)object4).getPredicate();
                object22 = ((TriplesBlock)object4).getObject();
                object = this.findTerm_for_Element((TriplesBlock.Element)object3, "subject", true);
                String string5 = this.findTerm_for_Element((TriplesBlock.Element)((Object)iterator), "predicate", true);
                String i = this.findTerm_for_Element((TriplesBlock.Element)object22, "object", true);
                if (!string2.equals(object)) {
                    this.log("Exception: [" + string + "] common_subj=" + string2 + " != [" + string4 + "] subj=" + (String)object);
                }
                arrayList.add(string5);
                arrayList2.add(i);
                if (((TriplesBlock.Element)((Object)iterator)).isVariable()) {
                    if (hashMap.get(string5) == null) {
                        hashMap.put(string5, "predicate:" + n3);
                    }
                    this.add_to_FullOccInfo(string5, string3, "predicate", n3);
                    if (!arrayList3.contains(string5)) {
                        arrayList3.add(string5);
                    }
                }
                if (((TriplesBlock.Element)object22).isVariable()) {
                    if (hashMap.get(i) == null) {
                        hashMap.put(i, "object:" + n3);
                    }
                    this.add_to_FullOccInfo(i, string3, "object", n3);
                    if (!arrayList3.contains(i)) {
                        arrayList3.add(i);
                    }
                }
                if (!bl2) {
                    if (!((TriplesBlock.Element)object3).isVariable()) {
                        bl = true;
                        char string7 = string2.charAt(0);
                        if (string7 == '<') {
                            n2 = 1;
                        } else {
                            throw new RDFException("Exception: only URIs are supported as subject: " + string2);
                        }
                    }
                    bl2 = true;
                }
                ++n3;
            }
            this.log("--> predList=" + arrayList);
            this.log("==> objeList=" + arrayList2);
            this.log("++> FirstOccPos_for_tuple: size()=" + hashMap.size() + " : " + hashMap.entrySet());
            this.log("**> (extended content of) FullOccInfo_for_VarPlusCSRAlias: size()=" + this.FullOccInfo_for_VarPlusCSRAlias.size() + " : " + this.FullOccInfo_for_VarPlusCSRAlias.entrySet());
            this.log("**> (extended content of) occPosSet_for_CSRAlias_for_var: size()=" + this.occPosSet_for_CSRAlias_for_var.size() + " : " + this.occPosSet_for_CSRAlias_for_var.entrySet());
            this.log("**> (extended content (with EMPTY sets) of) TypeInfoSet_for_VarPlusCSRAlias: size()=" + this.TypeInfoSet_for_VarPlusCSRAlias.size() + " : " + this.TypeInfoSet_for_VarPlusCSRAlias.entrySet());
            Set<String> object52 = this.TmapSet_for_TpatCSRGroup.get(string);
            this.log("==> tmapSet=" + object52);
            object4 = new ArrayList();
            object3 = new HashMap();
            cSRinfo.set_RRrLList_for_Tmap((Map<String, List<List<String>>>)object3);
            for (Object object22 : object52) {
                object = new ArrayList();
                this.TrueMatchingRRrowListList_for_CSRAliasPlusTmap.put(string3 + "+" + (String)object22, (List<List<String>>)object);
                object3.put(object22, object);
                boolean bl3 = false;
                this.log("----------------- processing Tmap=" + (String)object22);
                if (bl) {
                    String string6 = this.SubjExpr_for_Tmap.get(object22);
                    char c = string6.charAt(0);
                    int n4 = Integer.parseInt(string6.substring(1, 2));
                    this.log("comparing: common_subj=" + string2 + " SubjExpr=" + string6 + " vtype=" + c + " mapType=" + n4);
                    if (n2 != 1 || c != 'U') {
                        this.log("common_subj and SubjExpr: termType mismatch");
                        bl3 = true;
                    } else if (n4 == RRTabRowInfo.MapExprType_TEMPLATE && !RelationalBGP.matchableSqlTemplatePair(string6.substring(2), string2, this.ctx)) {
                        this.log("NO subject-matchability of SubjExpr.substring(2): " + string6.substring(2) + " against IRI common_subj: " + string2);
                        bl3 = true;
                    }
                    if (bl3) {
                        this.log("common_subj is NOT matchable with SubjExpr for Tmap=" + (String)object22);
                        object4.add(object22);
                        this.log("SKIP Tmap=" + (String)object22 + " tmapExclusionList=" + object4);
                        continue;
                    }
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string7 = (String)arrayList.get(i);
                    String string8 = (String)arrayList2.get(i);
                    ArrayList arrayList4 = new ArrayList();
                    object.add(arrayList4);
                    this.log("  \n");
                    this.log("\n========== BEGIN pred-obje pair: " + string7 + BASE_PREFIX_COLNAME_SEP + string8);
                    this.log("  \n");
                    boolean bl4 = false;
                    if (string7.charAt(0) == '<') {
                        bl4 = true;
                    }
                    boolean bl5 = false;
                    if (string8.charAt(0) == '<' || string8.charAt(0) == '\"' || string8.charAt(0) == '_') {
                        bl5 = true;
                    }
                    String string9 = string2 + "+" + string7 + "+" + string8;
                    Set<String> set = this.RRrowSet_for_TriplePattern.get(string9);
                    this.log("RRrowSet for tp_key=" + string9 + " size=" + set.size() + " : " + set);
                    int n5 = 0;
                    ArrayList<String> arrayList5 = new ArrayList<String>();
                    for (String string10 : set) {
                        RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(string10);
                        this.log("  \n");
                        this.log("checking RRrowid=" + string10);
                        if (!this.isTrueMatchingRRrow_for_Tmap(rRTabRowInfo, (String)object22, this.bgp_graph, this.is_bgp_graph_const, this.graphMatchUnnamed, string7, bl4, string8, bl5)) continue;
                        this.log("buildSQLNew: FOUND TrueMatching RRrowid=" + string10 + " : Tmap=" + rRTabRowInfo.Tmap);
                        arrayList5.add(string10);
                        ++n5;
                        this.add_to_TypeInfoSet(string8, string3, rRTabRowInfo);
                    }
                    if (arrayList5.size() == 0) {
                        this.log("SKIP Tmap=" + (String)object22 + " : because no apparently matching RR rows survived the scrutiny");
                        bl3 = true;
                        break;
                    }
                    this.log("adding RRrowList_for_Tmap (Tmap=" + (String)object22 + ") content to TrueMatchingRRrowList");
                    this.log("before adding: " + arrayList4);
                    arrayList4.addAll(arrayList5);
                    this.log("AFTER  adding: " + arrayList4);
                    this.log("\nEND pred-obje pair: " + string7 + BASE_PREFIX_COLNAME_SEP + string8);
                    this.log("  \n");
                }
                if (bl3) {
                    object4.add(object22);
                    this.log("SKIP Tmap=" + (String)object22 + " tmapExclusionList=" + object4);
                    continue;
                }
                this.log("tpCSR_alias=" + string3 + " Tmap=" + (String)object22);
            }
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                object22 = (String)iterator.next();
                object52.remove(object22);
                cSRinfo.excludeTmapFromTmapSet((String)object22);
            }
            for (Object object22 : object52) {
                this.log("TrueMatchingRRrowListList_for_CSRAliasPlusTmap(" + string3 + "+" + (String)object22 + ") :" + this.TrueMatchingRRrowListList_for_CSRAliasPlusTmap.get(string3 + "+" + (String)object22));
            }
            if (object52.size() == 0) {
                this.log("EMPTY tmapSet: will generate NoRows SQL");
            }
            this.log("**> (extended content of) TypeInfoSet_for_VarPlusCSRAlias: size()=" + this.TypeInfoSet_for_VarPlusCSRAlias.size() + " : " + this.TypeInfoSet_for_VarPlusCSRAlias.entrySet());
        }
        this.log("--> CSRAlias_for_TpatCSRGroup: size()=" + this.CSRAlias_for_TpatCSRGroup.size() + " : " + this.CSRAlias_for_TpatCSRGroup.entrySet());
    }

    private String find_optimized_CondExpr(String string, List<String> list, List<String> list2, String string2, String string3, String string4) throws RDFException {
        int n;
        String string5;
        int n2;
        string = string.substring(1, string.length() - 1);
        String string6 = "";
        this.log("Inside find_optimized_CondExpr ...: constant to match=" + string);
        this.log("strList.size()=" + list2.size() + ": " + list2.toString());
        this.log(list.toString());
        int n3 = list2.get(0).length();
        int n4 = list2.get(list2.size() - 1).length();
        if (n3 + n4 >= string.length()) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n5 = 0;
        for (n2 = 0; n2 < list2.size(); ++n2) {
            int n6;
            string5 = list2.get(n2);
            if (string5.equals("")) {
                if (n2 == 0) continue;
                if (n2 == list2.size() - 1) {
                    arrayList.add(string.length());
                    continue;
                }
                this.log("skip cond-opt: THERE_ARE_EMPTY_STRLIST_ELEMENT_IN_THE_MIDDLE AND IT IS NOT POSSIBLE TO ELIMINATE AMBIGUITY");
                return null;
            }
            if (n2 == list2.size() - 1) {
                int n7 = string.length() - string5.length();
                if (!string5.equals(string.substring(n7))) {
                    return "1=0";
                }
                n = n7 - n5;
                if (n < 0) {
                    return "1=0";
                }
                n6 = string.length();
            } else {
                n = string.substring(n5).indexOf(string5);
                if (n < 0) {
                    return "1=0";
                }
                if (n2 == 0 && n > 0) {
                    return "1=0";
                }
                n6 = n5 + n + string5.length();
            }
            arrayList.add(n5 + n);
            this.log("s=" + n2 + ",search_start=" + n5 + "match_pos=" + n);
            n5 = n6;
        }
        this.log(arrayList.toString());
        for (n2 = list2.size() - 2; n2 > 0; --n2) {
            string5 = list2.get(n2);
            n5 = (Integer)arrayList.get(n2) + 1;
            n = string.substring(n5).indexOf(string5);
            this.log("reverse scan: s=" + n2 + ",search_start=" + n5 + "match_pos=" + n);
            if (n < 0 || n5 + n + string5.length() > (Integer)arrayList.get(n2 + 1)) continue;
            this.log("MyCode: found a second match for strList[" + n2 + "] at position " + (n5 + n));
            return null;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            Object object;
            String string7;
            int n8 = n2;
            n = n2 + 1;
            String string8 = list.get(n2);
            int n9 = (Integer)arrayList.get(n8) + list2.get(n8).length();
            int n10 = (Integer)arrayList.get(n);
            String string9 = string.substring(n9, n10);
            boolean bl = false;
            if (this.LtcRowInfo_for_Tmap_plus_Col != null) {
                string7 = string8.charAt(0) == '\"' && string8.charAt(string8.length() - 1) == '\"' ? string8.substring(1, string8.length() - 1) : string8.toUpperCase();
                this.log("colName=" + string8 + " uColName=" + string7 + " colValue=" + string9);
                object = this.LtcRowInfo_for_Tmap_plus_Col.get(string3 + "+" + string7);
                if (object == null) {
                    this.log("LtcRowInfo absent for: Tmap=" + string3 + " uColName=" + string7 + "***");
                    throw new RDFException("LtcRowInfo absent for: Tmap=" + string3 + " uColName=" + string7 + "***");
                }
                this.log(((LtcTabRowInfo)object).toString());
                if (!((LtcTabRowInfo)object).colTypeName.equals("STRING") && !((LtcTabRowInfo)object).colTypeName.equals(LTC_TYPE_NUMBER)) {
                    this.log("skip-optimization: found column (" + string8 + ") to be of type: " + ((LtcTabRowInfo)object).colTypeName);
                    return null;
                }
                if (((LtcTabRowInfo)object).colTypeName.equals(LTC_TYPE_NUMBER)) {
                    try {
                        double d = Double.parseDouble(string9);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "1=0";
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw new RDFException("Double parsing error while finding optimized condition expressions for constant: " + string + " alias: " + string2 + " Tmap: " + string3);
                    }
                }
            }
            string7 = null;
            if (bl) {
                string7 = string9;
            } else {
                try {
                    string7 = "'" + URLDecoder.decode(string9, "UTF-8") + "'";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new RDFException("java.net.URLDecoder(" + string9 + ",UTF-8) failed: see trace file for details");
                }
            }
            try {
                String string10;
                object = TTL_UNESCAPE_BEG;
                String string11 = string10 = !this.ctx.noTC ? ")" : ", options=>'NO_TC=T')";
                if ((this.ctx.R2RFlags & 0x200L) > 0L || !RelationalBGP.needTTLunescape(string9)) {
                    object = "";
                    string10 = "";
                }
                String string12 = "";
                string12 = !RelationalBGP.needPercentDecode(string9) ? "'" + string9.replace("'", "''") + "'" : ((this.ctx.R2RFlags & 0x10000L) == 65536L ? "sys.utl_url.unescape('" + string9.replace("'", "''") + "'" + ")" : "'" + URLDecoder.decode(string9, "UTF-8").replace("'", "''") + "'");
                string6 = string6 + COND_CONNECTOR + string2 + "." + string8 + "=" + (String)object + string12 + string10;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RDFException("Decoding error while finding optimized condition expressions for constant: " + string + " alias: " + string2 + " Tmap: " + string3);
            }
        }
        this.log("MyCode:OPTIMIZED_CONDEXPR=" + string6.substring(COND_CONNECTOR.length()));
        return string6.substring(COND_CONNECTOR.length());
    }

    private static boolean needTTLunescape(String string) {
        return string.indexOf(delim) >= 0;
    }

    private static boolean needPercentDecode(String string) {
        return string.indexOf("%") >= 0;
    }

    private boolean isCompatibleTFTpair(int n, int n2) {
        String string;
        String string2;
        String string3;
        if (n == n2) {
            this.log("isCompatibleTFTpair: trivially compatible: same TFTidx: TFTidx1=" + n + " TFTidx2=" + n2);
            return true;
        }
        TFTinfo tFTinfo = this.TFTinfoGlobalList.get(n);
        TFTinfo tFTinfo2 = this.TFTinfoGlobalList.get(n2);
        this.log("isCompatibleTFTpair: comparing: TFTidx1=" + n + " TFTidx2=" + n2);
        if (tFTinfo == null || tFTinfo2 == null) {
            this.log("isCompatibleTFTpair: null TFTinfo: TFTinfo1=" + tFTinfo + " TFTinfo2=" + tFTinfo2);
            return true;
        }
        if (!tFTinfo.termType.equals(tFTinfo2.termType)) {
            this.log("isCompatibleTFTpair: termType mismatch: TFTinfo1=" + tFTinfo.termType + " TFTinfo2=" + tFTinfo2.termType);
            return false;
        }
        if (rrLiteral.equals(tFTinfo.termType) && !tFTinfo.datatype_family.equals(tFTinfo2.datatype_family)) {
            this.log("isCompatibleTFTpair: Literals: checking datatype families: TFTinfo1=" + tFTinfo.datatype_family + " TFTinfo2=" + tFTinfo2.datatype_family);
            if (!tFTinfo.datatype_family.equals(TYPE_FAM_NUMERIC) && !tFTinfo.datatype_family.equals(TYPE_FAM_FLOAT) && !tFTinfo.datatype_family.equals(TYPE_FAM_DOUBLE) || !tFTinfo2.datatype_family.equals(TYPE_FAM_NUMERIC) && !tFTinfo2.datatype_family.equals(TYPE_FAM_FLOAT) && !tFTinfo2.datatype_family.equals(TYPE_FAM_DOUBLE)) {
                this.log("isCompatibleTFTpair: Literals: datatype family mismatch: TFTinfo1=" + tFTinfo.datatype_family + " TFTinfo2=" + tFTinfo2.datatype_family);
                return false;
            }
        }
        if ((string3 = tFTinfo.strList.get(0)).indexOf(string2 = tFTinfo2.strList.get(0)) < 0 && string2.indexOf(string3) < 0) {
            this.log("isCompatibleTFTpair: min-pfx mismatch: " + string3 + " mismatches " + string2);
            return false;
        }
        String string4 = tFTinfo.strList.get(tFTinfo.strList.size() - 1);
        if (string4.indexOf(string = tFTinfo2.strList.get(tFTinfo2.strList.size() - 1)) < 0 && string.indexOf(string4) < 0) {
            this.log("isCompatibleTFTpair: min-sfx mismatch: " + string4 + " mismatches " + string);
            return false;
        }
        this.log("isCompatibleTFTpair: all okay: TFTidx1=" + n + " TFTidx2=" + n2);
        return true;
    }

    private int add_TFT(String string, String string2, int n, String string3, String string4, String string5, List<String> list) throws SQLException, RDFException {
        Object object;
        int n2;
        String string6;
        Object object2;
        this.log("add_TFT: INPUT: Tmap=" + string + " | rrExpr=" + string2 + " | exprType=" + n + " | termType=" + string3 + " | datatype=" + string4);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string7 = null;
        if (n == RRTabRowInfo.MapExprType_CONSTANT) {
            object2 = new String[4];
            this.findComponents_of_RDFterm_simple(string2, (String[])object2);
            arrayList.add(object2[0]);
        } else if (n == RRTabRowInfo.MapExprType_COLUMN) {
            object2 = RelationalBGP.get_base_prefix_from_RR_table(string2);
            if (object2 != null) {
                string6 = RelationalBGP.get_col_name_from_RR_table(string2);
                arrayList.add((String)object2);
                list.add(string6);
            } else {
                arrayList.add("");
                list.add(string2);
            }
            arrayList.add("");
        } else if (n == RRTabRowInfo.MapExprType_TEMPLATE) {
            object2 = RelationalBGP.sqlTempl2sqlExpr(string2.substring(1, string2.length() - 1), string3, "xyz.", null, list, arrayList, null, null, this.ctx);
        } else if (n == 0) {
            arrayList.add(null);
            this.log("adding a dummy TFT for NULL");
        } else {
            throw new RDFException("Exception: unknown exprType: " + n);
        }
        if (string3.equals(rrIRI)) {
            string6 = "U";
        } else if (string3.equals(rrBlankNode)) {
            string6 = "B";
        } else if (string3.equals(rrLiteral)) {
            string6 = "L";
        } else {
            throw new RDFException("Exception: unknown termType: " + string3);
        }
        String string8 = string6 = string6 + n;
        if (string3.equals(rrLiteral) && string5 != null) {
            string6 = string6 + "@" + string5.substring(1, string5.length() - 1);
        } else if (string3.equals(rrLiteral)) {
            string7 = string4 == null ? "STRING" : this.TYPE_FAMILY(string4.substring(1, string4.length() - 1));
            if (string7.equals(TYPE_FAM_OTHER)) {
                string7 = string7 + string4;
            }
            string8 = string7.equals(TYPE_FAM_NUMERIC) || string7.equals(TYPE_FAM_FLOAT) || string7.equals(TYPE_FAM_DOUBLE) ? string6 + TYPE_FAM_NUMFLTDBL : string6 + string7;
            string6 = string6 + string7;
        }
        string6 = string6 + BASE_PREFIX_COLNAME_SEP;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            string6 = string6 + (String)arrayList.get(n2);
            string8 = string8 + (String)arrayList.get(n2);
            if (n2 > list.size() - 1) continue;
            object = list.get(n2);
            String string9 = ((String)object).charAt(0) == '\"' ? ((String)object).substring(1, ((String)object).length() - 1) : ((String)object).toUpperCase();
            object2 = string + "+" + string9;
            this.log("add_TFT: Tmap_plus_Col=" + (String)object2);
            LtcTabRowInfo ltcTabRowInfo = this.LtcRowInfo_for_Tmap_plus_Col.get(object2);
            if (ltcTabRowInfo == null) {
                this.log("EXCEPTION-tyfam_template");
                throw new RDFException("add_TFT: returns NULL ltcTablRowInfo for: Tmap_plus_Col=" + (String)object2);
            }
            string6 = string6 + "{" + ltcTabRowInfo.colTypeName + "}";
            string8 = string8 + "{" + GENERIC_TYPE_FAMILY + "}";
            arrayList2.add(ltcTabRowInfo.colTypeName);
        }
        this.log("TYFAM_TEMPL=" + string6 + " (colList: " + list + ") (strList: " + arrayList + ") (colTypeList: " + arrayList2 + ")");
        n2 = this.TFTglobalList.indexOf(string6);
        if (n2 == -1) {
            this.TFTglobalList.add(string6);
            this.noTFTglobalList.add(string8);
            n2 = this.TFTglobalList.size() - 1;
            this.log("add_TFT: ADDED at idx=" + n2 + ": " + string6);
            object = new TFTinfo(n2, string6, string3, n, arrayList, arrayList2, string4, string7, string5);
            this.TFTinfoGlobalList.add((TFTinfo)object);
        } else {
            this.log("add_TFT: already present at idx=" + n2 + ": " + string6);
            arrayList.clear();
            arrayList2.clear();
        }
        this.log("add_TFT: returning idx=" + n2);
        if (n == 0) {
            this.null_TFTidx = n2;
        }
        object = new HashMap();
        for (int i = 0; i < this.TFTinfoGlobalList.size() - 1; ++i) {
            Integer n3 = new Integer(-1);
        }
        return n2;
    }

    private String get_tyfam_Templ(String string, List<String> list, List<String> list2, String string2) throws RDFException {
        String string3 = string2;
        for (int i = 0; i < list2.size(); ++i) {
            string3 = string3 + list2.get(i);
            if (i > list.size() - 1) continue;
            String string4 = list.get(i);
            String string5 = string4.charAt(0) == '\"' ? string4.substring(1, string4.length() - 1) : string4.toUpperCase();
            String string6 = string + "+" + string5;
            this.log("get_tyfam_Templ: Tmap_plus_Col=" + string6);
            LtcTabRowInfo ltcTabRowInfo = this.LtcRowInfo_for_Tmap_plus_Col.get(string6);
            if (ltcTabRowInfo == null) {
                this.log("EXCEPTION-tyfam_template");
                throw new RDFException("get_tyfam_Templ returns NULL ltcTablRowInfo for: Tmap_plus_Col=" + string6);
            }
            string3 = string3 + "{" + ltcTabRowInfo.colTypeName + "}";
        }
        return string3;
    }

    private boolean avoid_CNF(List<String> list) {
        this.log("[avoid_CNF] MAX_UAROW_COUNT_DIFF: 256");
        this.log("[avoid_CNF] MAX_UAROW_FACTOR: 1.32");
        this.log("[avoid_CNF] TpatCSRList: " + list);
        int n = 1;
        int n2 = 0;
        for (String string : list) {
            this.log("[avoid_CNF]    TpatCSR: " + string);
            CSRinfo cSRinfo = this.CSRinfo_for_CSRkey.get(string);
            int n3 = cSRinfo.get_UArow_count();
            this.log("[avoid_CNF]    UArow_count: " + n3);
            this.log("[avoid_CNF]    UArow_count_for_CNF   : " + (n *= n3));
            this.log("[avoid_CNF]    UArow_count_for_nonCNF: " + (n2 += n3));
        }
        this.log("[avoid_CNF] final UArow_count_for_CNF   : " + n);
        this.log("[avoid_CNF] final UArow_count_for_nonCNF: " + n2);
        boolean bl = false;
        this.log("UArow_count_for_CNF / UArow_count_for_nonCNF >? MAX_UAROW_FACTOR    --> " + (double)n + " / " + (double)n2 + " >? " + 1.32);
        this.log("UArow_count_for_CNF - UArow_count_for_nonCNF > MAX_UAROW_COUNT_DIFF --> " + n + " - " + n2 + " >? " + 256);
        if ((double)n / (double)n2 > 1.32 && n - n2 > 256) {
            bl = true;
        }
        this.log("[avoid_CNF] avoid_CNF=" + bl);
        return bl;
    }

    private void prepareForGenerateSQL() {
        this.log("ENTERED: pfgs");
        ArrayList<String> arrayList = new ArrayList<String>(this.Subj_for_TpatCSRGroup.keySet());
        this.log("BEFORE SORT: TpatCSRList: " + arrayList);
        Collections.sort(arrayList);
        this.log("AFTER SORT: TpatCSRList: " + arrayList);
        this.running_in_cnf_mode = false;
        int n = 0;
        if ((this.ctx.R2RFlags & 0x100000L) == 0L && ((this.ctx.R2RFlags & 0x80000L) > 0L || !this.avoid_CNF(arrayList) && (this.ctx.R2RFlags & 0x40000L) > 0L)) {
            this.running_in_cnf_mode = true;
            this.log("CNF-case: one MCSR will have all CSRs");
            this.log("BEGIN <ArbitraryOrdering>");
            this.log("   Checking if there are CSRs that have to be processed at the end...");
            String string = "+<http://www.opengis.net/ont/geosparql#asWKT>+";
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (String string2 : arrayList) {
                this.log("      CSRkey: " + string2);
                this.log("      TpatSet_for_TpatCSRGroup.get(CSRkey): " + this.TpatSet_for_TpatCSRGroup.get(string2));
                boolean bl = true;
                this.log("      Looking for " + string + " in Tpats");
                for (String string3 : this.TpatSet_for_TpatCSRGroup.get(string2)) {
                    this.log("         Tpat: " + string3);
                    if (string3.contains(string)) {
                        bl = false;
                        this.log("         ... has to be processed at the end");
                        break;
                    }
                    this.log("         ... being processed first");
                }
                if (bl) {
                    arrayList2.add(string2);
                    continue;
                }
                arrayList3.add(string2);
            }
            MCSR mCSR = new MCSR(n++);
            this.log("   CSRs to be processed first     : " + arrayList2);
            mCSR.addAllCSRKeys(arrayList2);
            this.log("   CSRs to be processed at the end: " + arrayList3);
            mCSR.addAllCSRKeys(arrayList3);
            this.log("   BEFORE ARBITRARY SORT: TpatCSRList: " + arrayList);
            arrayList.clear();
            arrayList.addAll(arrayList2);
            arrayList.addAll(arrayList3);
            this.log("   AFTER ARBITRARY SORT: TpatCSRList: " + arrayList);
            this.log("END <ArbitraryOrdering>");
            this.MCSR_for_MCSRkey.put(mCSR.getMCSRKey(), mCSR);
            this.MCSR_for_MCSRid.put(mCSR.getMCSRid(), mCSR);
        } else {
            this.log("non-CNF-case: one MCSR for each CSR");
            for (String string : arrayList) {
                MCSR mCSR = new MCSR(n++);
                mCSR.addCSRKey(string);
                this.MCSR_for_MCSRkey.put(mCSR.getMCSRKey(), mCSR);
                this.MCSR_for_MCSRid.put(mCSR.getMCSRid(), mCSR);
            }
        }
        this.log("EXIT: pfgs: MCSR_for_MCSkey.size(): " + this.MCSR_for_MCSRkey.size() + " MCSR_for_MCSRid.keySet()=" + this.MCSR_for_MCSRid.keySet());
    }

    private void populate_sAliasArray(CSRinfo cSRinfo, String string, int n, String string2, int n2, NatVarOpt_Info natVarOpt_Info) throws RDFException {
        this.log("[populate_sAliasArray] ENTERING");
        String string3 = this.SubjExpr_for_Tmap.get(string);
        RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(this.SubjRRrowid_for_Tmap.get(string));
        String string4 = string3.substring(0, 2);
        String string5 = cSRinfo.CSR_subj;
        this.log("[populate_sAliasArray] CSRkey: " + cSRinfo.CSR_key);
        this.log("                          var: " + string5 + "  Tmap: " + string);
        this.log("                rowBlock_size: " + n2 + "  RRrowid: " + string2 + "  rowBlock_size: " + n2);
        boolean bl = cSRinfo.CSR_is_subj_const;
        String string6 = cSRinfo.CSR_alias;
        String string7 = null;
        MCSR mCSR = cSRinfo.mcsrElem;
        this.log("[populate_sAliasArray] is_common_subj_const=" + bl);
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            this.log("[populate_sAliasArray] UArowIdx: " + n3);
            String string8 = mCSR.getTableAliasForVarTmap(cSRinfo.CSR_key, n3, string5, string);
            boolean bl2 = false;
            if (string8 == null) {
                this.log("[populate_sAliasArray]    table alias not found for var: " + string5 + " Tmap: " + string);
                string7 = string6;
                this.log("[populate_sAliasArray]    adding table alias: " + string7 + " for var: " + string5 + " Tmap: " + string);
                mCSR.addTableAliasForVarTmap(cSRinfo.CSR_key, n3, string5, string, string7);
            } else {
                if (string8.equals(string6)) {
                    throw new RDFException("[populate_sAliasArray] Same the table alias seen before for var: " + string5 + " Smap: " + string);
                }
                this.log("[populate_sAliasArray]    Different table aliases for var: " + string5 + " Smap: " + string);
                this.log("[populate_sAliasArray]                             before: " + string8 + " now: " + string6);
                this.log("[populate_sAliasArray]             using the previous one: " + string8);
                string7 = string8;
                bl2 = true;
            }
            this.log("[populate_sAliasArray] BEFORE adding usaAlias " + string7 + ": " + cSRinfo.sAliasArray);
            cSRinfo.sAliasArray.add(string7);
            this.log("[populate_sAliasArray] AFTER adding usaAlias " + string7 + ": " + cSRinfo.sAliasArray);
        }
        this.log("[populate_sAliasArray] FINALLY " + cSRinfo.sAliasArray);
    }

    private String compute_sExpr_and_sCond(CSRinfo cSRinfo, String string, int n, String string2, String string3, NatVarOpt_Info natVarOpt_Info, UArowNatSelectInfo uArowNatSelectInfo) throws RDFException {
        Object object2;
        String string4;
        String string5;
        String string6;
        MCSR mCSR = cSRinfo.mcsrElem;
        String string7 = this.SubjExpr_for_Tmap.get(string);
        RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(this.SubjRRrowid_for_Tmap.get(string));
        String string8 = string7.substring(0, 2);
        String string9 = cSRinfo.CSR_subj;
        Object var13_13 = null;
        String string10 = null;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        bl = cSRinfo.CSR_is_subj_const;
        int n3 = 0;
        if (this.RRrowFlags_for_Tmap.containsKey(string)) {
            n3 = this.RRrowFlags_for_Tmap.get(string);
        }
        this.log("RRrowFlags=" + n3);
        String string11 = null;
        int n4 = 1;
        try {
            this.log("sExprTypeAndTermType_code=" + string8);
            this.log("[MCSR handling]    UArowNum: " + n);
            this.log("[MCSR handling] common_subj: " + string9);
            this.log("[MCSR handling]        Smap: " + string);
            if (string8.equals("U" + RRTabRowInfo.MapExprType_TEMPLATE)) {
                string11 = string7.substring(3, string7.length() - 1);
                string10 = RelationalBGP.sqlTempl2sqlExpr(string11, rrIRI, string2 + ".", stringBuffer, arrayList, arrayList2, rRTabRowInfo.sColTypeList, hashSet, this.ctx);
                string10 = "'<'||" + string10 + "||'>'";
                n2 = RRTabRowInfo.MapExprType_TEMPLATE;
                this.log("notNullColCondExpr: " + stringBuffer);
                this.log("notNullCond_colSet: " + hashSet);
                if (!bl) {
                    this.store_noVa_related_Info(this.sTFT_idx_for_Tmap.get(string), string, arrayList, arrayList2, string9, "subject:0", cSRinfo.getCSRAlias(), null, n, 0, n4, natVarOpt_Info, uArowNatSelectInfo);
                }
            } else if (string8.equals("U" + RRTabRowInfo.MapExprType_CONSTANT)) {
                string11 = string7.substring(2, string7.length());
                arrayList2.add(string11.substring(1, string11.length() - 1));
                string10 = "'" + string11 + "'";
                n2 = RRTabRowInfo.MapExprType_CONSTANT;
                if (!bl) {
                    this.store_noVa_related_Info(this.sTFT_idx_for_Tmap.get(string), string, null, null, string9, "subject:0", cSRinfo.getCSRAlias(), null, n, 0, n4, natVarOpt_Info, uArowNatSelectInfo);
                }
            } else if (string8.equals("U" + RRTabRowInfo.MapExprType_COLUMN)) {
                string6 = TTL_ESCAPE_BEG;
                string5 = ")";
                if ((this.ctx.R2RFlags & 0x200L) > 0L) {
                    string6 = "";
                    string5 = "";
                } else if ((this.ctx.R2RFlags & 0x20000L) > 0L) {
                    string5 = ", options=>' ESC_SBYTE_OPT=F ')";
                    if (this.ctx.noTC) {
                        string5 = string5.substring(0, string5.length() - 2) + " NO_TC=T')";
                    }
                }
                string11 = string7.substring(2, string7.length());
                string4 = RelationalBGP.get_base_prefix_from_RR_table(string11);
                if (string4 != null) {
                    object2 = RelationalBGP.get_col_name_from_RR_table(string11);
                    string10 = "sdo_rdf.criri('" + string4.replace("'", "''") + "'," + string6 + string2 + "." + (String)object2 + string5 + this.criri_network_storage_form_arg + ")";
                    arrayList.add((String)object2);
                    arrayList2.add(string4);
                } else {
                    string10 = "sdo_rdf.criri(NULL," + string6 + string2 + "." + string11 + string5 + this.criri_network_storage_form_arg + ")";
                    arrayList.add(string11);
                    arrayList2.add("");
                }
                n2 = RRTabRowInfo.MapExprType_COLUMN;
                if (!bl) {
                    this.store_noVa_related_Info(this.sTFT_idx_for_Tmap.get(string), string, arrayList, arrayList2, string9, "subject:0", cSRinfo.getCSRAlias(), null, n, 0, n4, natVarOpt_Info, uArowNatSelectInfo);
                }
            } else if (string8.equals("B" + RRTabRowInfo.MapExprType_TEMPLATE)) {
                string11 = string7.substring(3, string7.length() - 1);
                string10 = RelationalBGP.sqlTempl2sqlExpr(string11, rrBlankNode, string2 + ".", stringBuffer, arrayList, arrayList2, null, hashSet, this.ctx);
                if ((n3 & 1) == 1) {
                    string10 = "'_:' || 'BlankNode' || to_char(sys_op_combined_hash(" + string10 + "), 'FMXXXXXXXXXXXXXXXX', " + "'NLS_Numeric_Characters=''.,'''" + ")";
                    this.log("notNullColCondExpr for null-col check in subject is being cleared: " + stringBuffer + " notNullCond_colSet: " + hashSet);
                    stringBuffer.setLength(0);
                    hashSet.clear();
                } else {
                    string10 = "'_:' || sdo_rdf.cbnod(" + string10 + ")";
                }
                n2 = RRTabRowInfo.MapExprType_TEMPLATE;
                if (!bl) {
                    this.store_noVa_related_Info(this.sTFT_idx_for_Tmap.get(string), string, arrayList, arrayList2, string9, "subject:0", cSRinfo.getCSRAlias(), null, n, 0, n4, natVarOpt_Info, uArowNatSelectInfo);
                }
            } else if (string8.equals("B" + RRTabRowInfo.MapExprType_CONSTANT)) {
                string11 = string7.substring(2, string7.length());
                arrayList2.add(string11);
                string10 = "'" + string11 + "'";
                n2 = RRTabRowInfo.MapExprType_CONSTANT;
                if (!bl) {
                    this.store_noVa_related_Info(this.sTFT_idx_for_Tmap.get(string), string, null, null, string9, "subject:0", cSRinfo.getCSRAlias(), null, n, 0, n4, natVarOpt_Info, uArowNatSelectInfo);
                }
            } else if (string8.equals("B" + RRTabRowInfo.MapExprType_COLUMN)) {
                string11 = string7.substring(2, string7.length());
                string10 = "'_:' || sdo_rdf.cbnod(" + string2 + "." + string11 + ")";
                n2 = RRTabRowInfo.MapExprType_COLUMN;
                arrayList.add(string11);
                arrayList2.add("");
                if (!bl) {
                    this.store_noVa_related_Info(this.sTFT_idx_for_Tmap.get(string), string, arrayList, arrayList2, string9, "subject:0", cSRinfo.getCSRAlias(), null, n, 0, n4, natVarOpt_Info, uArowNatSelectInfo);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RDFException("Error generating SQL for Tmap: " + string);
        }
        this.log("compute_sExpr_and_sCond: iUriExpr: " + string10);
        string6 = "";
        string5 = null;
        if (bl) {
            string6 = "'" + string9.replace("'", "''") + "'=" + string10;
            string11 = string7.substring(2, string7.length());
            string4 = RelationalBGP.get_base_prefix_from_RR_table(string11);
            this.log("SubjExpr=" + string7 + " sExpr=" + string11 + " sbase_prefix=" + string4);
            if (string4 == null || !string8.equals("U" + RRTabRowInfo.MapExprType_COLUMN)) {
                string5 = this.find_optimized_CondExpr(string9, arrayList, arrayList2, string2, string, null);
                this.log("[common_subj is constant] sCondExpr: " + string6 + " optimized_sCondExpr: " + string5);
                if (string5 != null) {
                    string6 = string5;
                }
            } else {
                this.log("[common_subj is constant] sCondExpr: " + string6 + " SKIPPED optimized_sCondExpr attempt because: non-null sbase_prefix= " + string4 + " and column-valued subjectMap");
            }
        }
        this.log("[STARTING] commonSubj-var Filter Condition");
        string4 = "";
        if (!bl) {
            this.log("variable in common subject-position: generating condition (if any) based on FILTER: " + string9);
            this.log("toSQL: RelExprFilterList_for_BGP=> " + this.RelExprFilterList_for_BGP.toString());
            this.log("=>");
            for (RelExpr object3 : this.RelExprFilterList_for_BGP) {
                this.log(object3.toString());
                if (object3.RelExprFlags == 2L) {
                    this.log("skipping GEOMETRY filter");
                    continue;
                }
                if ((object3.L_atom.type != 0 || !object3.L_atom.name.equals(string9) || object3.R_atom.type == 0) && (object3.R_atom.type != 0 || !object3.R_atom.name.equals(string9) || object3.L_atom.type == 0)) continue;
                string4 = string4 + this.genFilterCond_new(object3, rRTabRowInfo, 0, string10, string2);
                this.log("condExpr_commonSubj_filter_delta: " + string4);
            }
        }
        this.log("condExpr_commonSubj_filter_delta[AFTER]: " + string4);
        string6 = string6 + string4;
        this.log("[common_subj: added condExpr_commonSubj_filter_delta] sCondExpr: " + string6);
        if (stringBuffer.length() > 0) {
            string6 = string6 + stringBuffer.toString();
            this.log("[common_subj: added notNullColCondExpr] sCondExpr: " + string6);
        }
        object2 = new ACRinfo(string10, string6, arrayList);
        this.log("Putting the new_sACRinfo in to the map of expressions Alias+Component+RRrowid -> new_sACRinfo: ");
        this.log("   " + string2 + "+subject+" + string3 + " -> " + object2);
        ACRinfo aCRinfo = mCSR.putACRinfo_for_AliasComponentRRrowid(string2, "subject", string3, (ACRinfo)object2);
        if (aCRinfo != null && !aCRinfo.isEqual((ACRinfo)object2)) {
            throw new RDFException("Two different subject ACRinfo happened for the same Alias+Component+RRrowid\n    Alias    : " + string2 + "\nComponent    : subject\n  RRrowid    : " + string3 + "\n----------------------------------------\n new_sACRinfo: " + ((ACRinfo)object2).toString() + "\nprev_sACRinfo: " + aCRinfo.toString());
        }
        return string6;
    }

    /*
     * WARNING - void declaration
     */
    private String generateSQL() throws RDFException, SQLException {
        void var24_70;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        List<String> list;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList22;
        Object object10;
        Object object11;
        ArrayList<String> arrayList3;
        Object object12;
        String string2;
        this.log("Entered generateSQL");
        this.log("Structures involved here are:");
        this.log("===============================================:");
        this.log("[Use] FullOccInfo_for_VarPlusCSRAlias:    Map => <Var+CSRAlias, formatted string => e.g., S:0+O:3+O:12>");
        this.log("[Pop] occPosSet_for_CSRAlias_for_var:     Map => Var => {CSRAlias => {occPos, occPos,...}, ... }");
        this.log("[Use] TypeInfoSet_for_VarPlusCSRAlias:    Map => <Var+CSRAlias, Set<TypeInfo (formatted string => objeDataType RDFdatatype_DBColType>>");
        this.log("[Use] Tmaps_with_nonUnique_Smaps:         Map => <Tmaps>");
        this.log("[Use] TpatSet_for_TpatCSRGroup:           Map => <SubjTmapSet_key (CSR key), TpatSet (triple-patterns in this CSR>");
        this.log("[Use] Subj_for_TpatCSRGroup:              Map => <SubjTmapSet_key, Subj>");
        this.log("[Use] TmapSet_for_TpatCSRGroup:           Map => <SubjTmapSet_key, TmapSet (set of Tmaps from matching RR rows)>");
        this.log("[Use] LtabExpr_for_Tmap:                  Map => <Tmap, rowsrc>");
        this.log("[Use] SubjExpr_for_Tmap:                  Map => <Tmap, sTermType+RRrowInfo.sExprType+RRrowInfo.sExpr>");
        this.log("[Use] RRrowSet_for_TriplePattern:         Map => <tp_key, RRrowSet(actually, RRrowidSet)>");
        this.log("-----");
        this.log("[Pop] NativeVarList_for_CSRAlias:         Map => <CSRAlias, list-of-native-vars (allow direct use of DB cols)>");
        this.log("[Pop] CLOBVarPlusMCSRAliasSet_for_BGP:    Map => <Var+MCSRAlias (occurrences of CLOB)>");
        this.log("[P/U] FirstOccPos_for_tuple (local: CSR): Map => <Var, FirstOcc (position:idx of pred-obje pair, e.g., object:3)>");
        this.log("[P/U] RRrowList_for_Tmap (local: CSR-Tmap): List => <truly matching RRrowids (matchable based on data)>");
        this.log("===============================================:");
        this.log("    varsList_for_CSRAlias: " + this.varsList_for_CSRAlias);
        this.log("    predList_for_CSRAlias: " + this.predList_for_CSRAlias);
        this.log("    objeList_for_CSRAlias: " + this.objeList_for_CSRAlias);
        for (MCSR object162 : this.MCSR_for_MCSRkey.values()) {
            this.log("mcsrKey: " + object162.getMCSRKey());
            for (String string2 : object162.getCSRKeyList()) {
                this.log("  CSRKey: " + string2);
                object12 = this.CSRAlias_for_TpatCSRGroup.get(string2);
                List<String> bl = this.varsList_for_CSRAlias.get(object12);
                for (String string3 : bl) {
                    this.log("              var: " + string3);
                    Set<String> set = this.occPosSet_for_CSRAlias_for_var.get(string3).keySet();
                    this.log("      CSRAliasSet: " + set);
                    for (String string4 : set) {
                        Set<String> set2;
                        this.log("        CSRAlias: " + string4);
                        String string5 = string3 + "+" + string4;
                        arrayList3 = this.NativeVarList_for_CSRAlias.get(string4);
                        String string6 = this.FullOccInfo_for_VarPlusCSRAlias.get(string5);
                        boolean bl2 = false;
                        if (string6.indexOf("subject") < 0 && string6.indexOf("predicate") < 0 && string6.indexOf("graph") < 0) {
                            bl2 = true;
                        }
                        if ((set2 = this.TypeInfoSet_for_VarPlusCSRAlias.get(string5)) == null || set2.size() != 1) continue;
                        object11 = set2.toArray(new String[0]);
                        String string7 = object11[0];
                        if (string7.equals(NO_DB_COL_TYPE)) {
                            this.log("SKIP adding var=" + string3 + " to NativeVarList for CSRAlias=" + string4 + " (TypeInfo=" + string7 + ")");
                            continue;
                        }
                        int bl7 = string7.indexOf(BASE_PREFIX_COLNAME_SEP);
                        String string8 = string7.substring(0, bl7);
                        int list7 = string7.indexOf(" DB_TYPE=");
                        String string9 = string7.substring(bl7 + BASE_PREFIX_COLNAME_SEP.length(), list7);
                        this.log("comparing actual and ideal data types: objeDataType=" + string8 + " RDFdatatype=" + string9);
                        if (string8.equals(string9)) {
                            this.log("add var=" + string3 + " to NativeVarList for CSRAlias=" + string4);
                            if (arrayList3 == null) {
                                arrayList3 = new ArrayList<String>();
                                this.NativeVarList_for_CSRAlias.put(string4, arrayList3);
                            }
                            arrayList3.add(string3);
                            continue;
                        }
                        this.log("SKIP adding var=" + string3 + " to NativeVarList for CSRAlias=" + string4 + " (Type mismatch)");
                    }
                }
            }
        }
        this.log("NativeVarList_for_CSRAlias: " + this.NativeVarList_for_CSRAlias);
        this.log("Tmaps_with_nonUnique_Smaps: " + this.Tmaps_with_nonUnique_Smaps);
        ArrayList arrayList4 = new ArrayList();
        NatVarOpt_Info natVarOpt_Info = new NatVarOpt_Info();
        HashMap hashMap = new HashMap();
        string2 = this.buildSQL_NoRows_for_BGP();
        this.log("NoRows_sql_str_BGP (to be used in case we get at least one MCSR that gets UAnumTrueRows=0): " + string2);
        object12 = new ArrayList();
        boolean bl = false;
        this.elapsedTimeInfoHandler.startLoopElapsedTime("MCSR_loop");
        for (MCSR mCSR : this.MCSR_for_MCSRkey.values()) {
            this.log("mcsrKey: " + mCSR.getMCSRKey());
            this.elapsedTimeInfoHandler.startIterationElapsedTime("MCSR=" + mCSR.getMCSRAlias());
            int n = 1;
            for (String string10 : mCSR.getCSRKeyList()) {
                Serializable serializable;
                this.log("ENTER new CSR: rowBlock_size_atEndOfLastCSR: " + n);
                CSRinfo cSRinfo = this.CSRinfo_for_CSRkey.get(string10);
                arrayList3 = cSRinfo.CSR_subj;
                this.log("**taking a snapshot of the current vTaMArray**");
                mCSR.take_vTaMArray_snapshot();
                String string11 = cSRinfo.getCSRAlias();
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                cSRinfo.set_FirstOccPos_for_tuple(hashMap2);
                this.populate_FirstOccPos_for_TpatCSRgroup(hashMap2, string11);
                boolean bl3 = false;
                if (this.graphVar != null) {
                    this.log("graphVar=" + this.graphVar);
                }
                this.log("=================================================== TpatCSR=" + string10 + " common_subj=" + (String)((Object)arrayList3));
                object11 = this.predList_for_CSRAlias.get(string11);
                List<String> list2 = this.objeList_for_CSRAlias.get(string11);
                Set<String> set = this.TmapSet_for_TpatCSRGroup.get(string10);
                this.log("--> predList=" + object11);
                this.log("==> objeList=" + list2);
                this.log("==> tmapSet=" + set);
                ArrayList<String> arrayList5 = null;
                ArrayList<Set<String>> arrayList6 = null;
                object10 = null;
                if (this.graph_use_mode > 0) {
                    arrayList6 = new ArrayList<Set<String>>();
                    cSRinfo.GeesArray = arrayList6;
                    object10 = new ArrayList<Map<String, String>>();
                    cSRinfo.TpGEArray = object10;
                    if (this.is_bgp_graph_a_var) {
                        arrayList5 = new ArrayList<String>();
                        cSRinfo.gExprArray = arrayList5;
                    }
                }
                ArrayList<String> arrayList7 = new ArrayList<String>();
                cSRinfo.RRrLArray = arrayList7;
                ArrayList<String> arrayList8 = new ArrayList<String>();
                cSRinfo.fromArray = arrayList8;
                arrayList22 = new ArrayList<String>();
                cSRinfo.condArray = arrayList22;
                arrayList = new ArrayList<String>();
                cSRinfo.sAliasArray = arrayList;
                object9 = new ArrayList();
                object8 = 0;
                while ((Integer)object8 < list2.size()) {
                    object9.add(new ArrayList());
                    object7 = object8;
                    object6 = object8 = Integer.valueOf((Integer)object8 + 1);
                }
                cSRinfo.oExprArrays = object9;
                object8 = new ArrayList();
                object7 = 0;
                while ((Integer)object7 < list2.size()) {
                    object8.add(new ArrayList());
                    object6 = object7;
                    object7 = (Integer)object7 + 1;
                    serializable = object7;
                }
                cSRinfo.clobExprArrays = object8;
                object7 = new ArrayList();
                for (int i = 0; i < object11.size(); ++i) {
                    object7.add(new ArrayList());
                }
                cSRinfo.pExprArrays = object7;
                object6 = new ArrayList<UArowNatSelectInfo>();
                cSRinfo.UArowNatSelectInfoArray = object6;
                serializable = new HashMap();
                list = this.NativeVarList_for_CSRAlias.get(string11);
                if (list != null) {
                    for (String string12 : list) {
                        serializable.put(string12, new ArrayList());
                    }
                }
                this.log("[CSRAlias=" + string11 + "] => native_oExprSetArray_for_Var: " + serializable);
                cSRinfo.native_oExprSetArray_for_Var = serializable;
                object5 = new HashMap();
                HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>();
                object4 = new HashMap();
                object3 = new HashMap();
                object2 = new HashMap();
                cSRinfo.set_UAstartPos_for_Tmap((Map<String, Integer>)object5);
                cSRinfo.set_UAnumRows_for_Tmap(hashMap3);
                cSRinfo.set_iUriExpr_for_Tmap((Map<String, String>)object4);
                cSRinfo.set_iUriExprType_for_Tmap((Map<String, Integer>)object3);
                cSRinfo.set_fromLtabPlusAlias_for_Tmap((Map<String, String>)object2);
                ArrayList arrayList9 = new ArrayList();
                cSRinfo.CSR_TmapList = arrayList9;
                for (String string13 : set) {
                    int n2;
                    this.log("----------------- processing Tmap=" + string13);
                    arrayList9.add(string13);
                    this.log("UAstartPos for the Tmaps processed so far: " + object5);
                    int n3 = arrayList8.size();
                    ((HashMap)object5).put(string13, n3);
                    int n4 = 0;
                    if (this.RRrowFlags_for_Tmap.containsKey(string13)) {
                        n4 = this.RRrowFlags_for_Tmap.get(string13);
                    }
                    this.log("RRrowFlags=" + n4);
                    List<List<String>> list3 = this.TrueMatchingRRrowListList_for_CSRAliasPlusTmap.get(string11 + "+" + string13);
                    String string14 = this.LtabExpr_for_Tmap.get(string13);
                    this.log("LtabExpr=" + string14);
                    Object var45_115 = null;
                    UArowNatSelectInfo uArowNatSelectInfo = new UArowNatSelectInfo();
                    int n5 = n;
                    int n6 = 0;
                    int n7 = 0;
                    for (n2 = 0; n2 < object11.size(); ++n2) {
                        int n8;
                        Object object13;
                        String string15 = (String)object11.get(n2);
                        String string16 = list2.get(n2);
                        List<String> list4 = list3.get(n2);
                        this.log("  \n");
                        this.log("\n========== BEGIN pred-obje pair: " + string15 + BASE_PREFIX_COLNAME_SEP + string16);
                        this.log("  \n");
                        boolean bl4 = false;
                        if (string15.charAt(0) == '<') {
                            bl4 = true;
                        }
                        boolean bl5 = false;
                        if (string16.charAt(0) == '<' || string16.charAt(0) == '\"' || string16.charAt(0) == '_') {
                            bl5 = true;
                        }
                        String string17 = arrayList3 + "+" + string15 + "+" + string16;
                        this.log("TrueMatchingRRrowList for tp_key=" + string17 + " size=" + list4.size() + " : " + list4);
                        if (list4.size() == 0) {
                            this.log("SKIP Tmap=" + string13 + " (empty TrueMatchingRRrowList): tp_key=" + string17);
                            throw new RDFException("EXCEPTION: $$$TBD$$$ this case should not arise after Tmap eliminatins during analysis: crash");
                        }
                        int n9 = 0;
                        List<String> list5 = list4;
                        for (String string18 : list5) {
                            object13 = this.RRrowInfo_for_MatchingRow.get(string18);
                            this.log("  \n");
                            this.log("checking RRrowid=" + string18);
                            this.log("generateSQL: FOUND RRrowid=" + string18 + " : Tmap=" + ((RRTabRowInfo)object13).Tmap);
                            this.log("if (" + n2 + " > 0 && " + ++n9 + " > 1) {");
                            if (n2 <= 0 || n9 <= 1) continue;
                            this.log("  need to multiply: RRrow_match_count=" + n9 + " po_idx=" + n2);
                            this.multiplyUnionArrays(cSRinfo, n2, n5, n7, this.bgp_graph, this.is_bgp_graph_const, natVarOpt_Info, n3, cSRinfo.UArowNatSelectInfoArray);
                            this.log("  updated multiply_writePos (increased by " + n5 + "): new value=" + (n7 += n5));
                        }
                        if (n2 > 0 && n9 > 1) {
                            this.log("  natVarOptInfo: need to multiply: RRrow_match_count=" + n9 + " po_idx=" + n2);
                            natVarOpt_Info.multiply(n3, n5, n9);
                        }
                        this.log("po_idx=" + n2 + ": multiply (if any) is now done: multiply_writePos=" + n7);
                        this.log("po_idx=" + n2 + ": going to populate phase: RRrowList_for_Tmap.size()=" + list5.size() + " :\n " + list5);
                        n6 = 0;
                        for (n8 = 0; n8 < list5.size(); ++n8) {
                            object13 = list5.get(n8);
                            RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(object13);
                            if (n2 == 0) {
                                this.log("calling populate_vTaMArray: uses content from snapshop-from-before-current-CSR, if any");
                                mCSR.populate_vTaMArray(n3 + n6, n5);
                                this.log("AFTER populate_vTaMArray");
                                this.log("calling populate_sAliasArray");
                                this.populate_sAliasArray(cSRinfo, string13, n3 + n6, (String)object13, n5, natVarOpt_Info);
                                this.log("AFTER populate_sAliasArray");
                            }
                            this.populateUnionArrays(mCSR, cSRinfo, string13, n2, n6, rRTabRowInfo, n5, bl4, bl5, this.bgp_graph, this.is_bgp_graph_const, this.graphMatchUnnamed, n4, natVarOpt_Info, n3, uArowNatSelectInfo);
                            this.log("po_idx=" + n2 + ": populated " + n5 + " (identical) rows starting from rownum=" + n6);
                            this.log("-> pExprArrays.get(" + n2 + ").size()=" + ((List)object7.get(n2)).size());
                            this.log("-> oExprArrays.get(" + n2 + ").size()=" + ((List)object9.get(n2)).size());
                            this.log("-> clobExprArrays.get(" + n2 + ").size()=" + ((List)object8.get(n2)).size());
                            this.log("updated writePos (increased by " + n5 + "): new value=" + (n6 += n5));
                            this.log("===> NATVAROPTINFO=" + natVarOpt_Info);
                            this.log("===> UArowNatSelectInfoArray=");
                            for (int i = 0; i < ((ArrayList)object6).size(); ++i) {
                                this.log("  " + ((ArrayList)object6).get(i));
                            }
                        }
                        this.log("===> UArowNatSelectInfoArray=");
                        for (n8 = 0; n8 < ((ArrayList)object6).size(); ++n8) {
                            this.log("  " + ((ArrayList)object6).get(n8));
                        }
                        if (n2 == 0) {
                            n7 = n6;
                            this.log("initalized multiply_writePos (to same value as writePos=" + n6 + "): new value=" + n7);
                        } else if (n6 != n7) {
                            this.log("EXCEPTION: po_idx=" + n2 + "(>0) BUT: writePos (" + n6 + ") != multiply_writePos (" + n7 + ")");
                        }
                        n5 = n6;
                        this.log("updated rowBlock_size (same as writePos=" + n6 + "): new value=" + n5 + "\n");
                        this.log("\nEND pred-obje pair: " + string15 + BASE_PREFIX_COLNAME_SEP + string16);
                        this.log("  \n");
                    }
                    this.log("===> UArowNatSelectInfoArray=");
                    for (n2 = 0; n2 < ((ArrayList)object6).size(); ++n2) {
                        this.log("  " + ((ArrayList)object6).get(n2));
                    }
                    hashMap3.put(string13, arrayList8.size() - n3);
                    this.log("++++++++++++++++++++++++++++++++++ Tmap=" + string13 + " +++++++++++++++++++++++++++++++++++++++");
                    cSRinfo.dumpUnionArray();
                }
                n = cSRinfo.RRrLArray.size();
                this.log("BEFORE EXITING CSR: rowBlock_size_atEndOfLastCSR: " + n);
            }
            int n10 = mCSR.getUArowsCount();
            this.log("max_UArowCount: " + n10);
            int n11 = 0;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            this.elapsedTimeInfoHandler.startLoopElapsedTime("UArowNum_loop");
            for (int i = 0; i < n10; ++i) {
                this.elapsedTimeInfoHandler.startIterationElapsedTime("UArowNum=" + i);
                l = System.currentTimeMillis();
                boolean bl6 = this.buildSQL_for_UArow_of_MCSR(mCSR, i, natVarOpt_Info, this.CLOBVarPlusMCSRAlias_Set_for_BGP);
                l2 = System.currentTimeMillis();
                l3 = l2 - l;
                object10 = String.format("%s+%d", mCSR.getMCSRAlias(), i);
                this.log("MCSR+UArowNum=" + (String)object10 + " --> time_delta_buildSQL_for_UArow_of_MCSR=" + l3);
                l4 += l3;
                this.time_delta_for_buildSQL_for_UArow_of_MCSR_for_mcsr_plus_UArowNum.put((String)object10, new Long(l3));
                if (bl6) {
                    ++n11;
                    mCSR.setLastValidUArowNum(i);
                } else {
                    this.log("No subquery generated for UArowNum=" + i);
                    mCSR.setLastInvalidUArowNum(i);
                }
                this.elapsedTimeInfoHandler.finishIterationElapsedTime();
            }
            this.elapsedTimeInfoHandler.finishLoopElapsedTime();
            if (n11 == 0) {
                object12.add(mCSR.getMCSRid());
                this.log("added MCSR to NoRows_MCSRid_list: " + object12);
                hashMap.put(mCSR.getMCSRKey(), null);
            } else {
                natVarOpt_Info.resetLocalStructure();
                UArowNatSelectInfo uArowNatSelectInfo = mCSR.getUArowNatSelectInfoArray().get(mCSR.getLastValidUArowNum());
                uArowNatSelectInfo.sqlSubq = uArowNatSelectInfo.sqlSubq + "\n) " + mCSR.getMCSRAlias();
                hashMap.put(mCSR.getMCSRKey(), mCSR.getUArowNatSelectInfoArray());
            }
            this.elapsedTimeInfoHandler.finishIterationElapsedTime();
        }
        this.elapsedTimeInfoHandler.finishLoopElapsedTime();
        if (this.TpatSet_for_TpatCSRGroup.size() == 0) {
            this.log("EMPTY TpatSet_for_TpatCSRGroup: bgp_graph=" + this.bgp_graph + " graphVar=" + this.graphVar);
            if (this.bgp_graph == null || this.is_bgp_graph_const) {
                object = "";
                if (this.ctx.topDownOpt) {
                    object = ", 1 AS BGP$" + this.getId();
                }
                return "SELECT null" + (String)object + " FROM SYS.DUAL";
            }
            throw new RDFException("EXCEPTION: we should not reach here => special case: EMPTY-BGP-with-GRAPH-clause");
        }
        object = new StringBuffer();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        String string19 = "";
        String string20 = "SELECT ";
        if ((this.ctx.R2RFlags & 0x2000L) == 0L) {
            string20 = string20 + " /*+ NO_MERGE */ ";
        }
        arrayList3 = "WHERE ";
        String string21 = "SELECT /*+ NO_MERGE(T) */ ";
        StringBuffer stringBuffer4 = new StringBuffer("");
        StringBuffer stringBuffer5 = new StringBuffer("");
        object11 = "$SRT";
        boolean bl7 = false;
        int n = 0;
        boolean bl8 = true;
        this.log("==>[NEW_CODE]");
        HashSet<String> hashSet = new HashSet<String>();
        for (String string22 : this.occPosSet_for_CSRAlias_for_var.keySet()) {
            this.log("multiocc outer join cond processing: var=" + string22);
            if (this.dummyTBList.size() > 0 && (string22.equals("dummyS") || string22.equals("dummyP") || string22.equals("dummyO"))) continue;
            Set<String> set = this.occPosSet_for_CSRAlias_for_var.get(string22).keySet();
            arrayList22 = this.get_MCSRAliasSet_for_CSRAliasSet(set);
            arrayList = string22 + (String)object11;
            object9 = "";
            this.log("var=" + string22 + " : outer_where_clause_tmp:" + stringBuffer + "***");
            if (natVarOpt_Info.containsVar(string22) && arrayList22.size() > 1) {
                this.log("var=" + string22 + ": multiocc outer join cond required because it occurs in more than one MCSR: " + arrayList22);
                object8 = natVarOpt_Info.get_optOutNatCond_ForVar(string22, (Set<String>)((Object)arrayList22));
                object9 = ((COptNatCondition)object8).notOptChosenExpr;
                stringBuffer.append(((COptNatCondition)object8).optNatCondition);
                this.log("optNatCondition=" + ((COptNatCondition)object8).toString() + "***");
                if (((COptNatCondition)object8).optNatCondition.length() > 0 && this.Geometry_VarSRID.containsKey(string22)) {
                    this.log("This geometry var is needed in the outer condition");
                    hashSet.add(string22);
                }
            } else {
                object7 = "";
                object6 = arrayList22.iterator();
                boolean bl9 = false;
                while (object6.hasNext()) {
                    object8 = object6.next();
                    if (!bl9) {
                        object9 = (String)object8 + "." + string22;
                        bl9 = true;
                        continue;
                    }
                    object7 = (String)object7 + COND_CONNECTOR + (String)object9 + "=" + (String)object8 + "." + string22;
                }
                stringBuffer.append((String)object7);
                this.log("notOptExpr=" + ((String)object7).toString());
            }
            if (object12.size() > 0) {
                stringBuffer.setLength(0);
                object9 = "NULL";
            }
            ++n;
            if (bl8) {
                void var34_98;
                String string23;
                String string24 = "sdo_rdf.";
                if ((this.ctx.R2RFlags & 0x400L) > 0L) {
                    String string25 = "orardf$";
                    string19 = FUNC_DECL + "\n";
                } else if ((this.ctx.R2RFlags & 0x800L) > 0L) {
                    Object var34_97 = null;
                }
                if (object12.size() > 0) {
                    object8 = "NULL";
                    object7 = "NULL";
                    object6 = "NULL";
                    string23 = "NULL";
                    list = "NULL";
                    object5 = "NULL";
                } else if (var34_98 != null) {
                    object8 = (String)var34_98 + "vname(" + (String)object9 + ")";
                    object7 = (String)var34_98 + "vtype(" + (String)object9 + ")";
                    object6 = (String)var34_98 + "vnpfx(" + (String)object9 + ")";
                    string23 = (String)var34_98 + "vnsfx(" + (String)object9 + ")";
                    list = (String)var34_98 + "ltype(" + (String)object9 + ")";
                    object5 = (String)var34_98 + "latag(" + (String)object9 + ")";
                } else {
                    object8 = RelationalBGP.vname((String)object9);
                    object7 = RelationalBGP.vtype((String)object9);
                    object6 = RelationalBGP.vnpfx((String)object9);
                    string23 = RelationalBGP.vnsfx((String)object9);
                    list = RelationalBGP.ltype((String)object9);
                    object5 = RelationalBGP.latag((String)object9);
                }
                this.log("chosen_expr=" + (String)object9);
                object4 = "NULL";
                if (!((String)object9).equals("NULL")) {
                    object3 = ((String)object9).substring(0, ((String)object9).indexOf("."));
                    object2 = string22 + "+" + (String)object3;
                    if (this.CLOBVarPlusMCSRAlias_Set_for_BGP.contains(object2)) {
                        object4 = ((String)object2).substring(0, ((String)object2).indexOf("+")) + "$RDFCLOB";
                        object4 = (String)object3 + "." + (String)object4;
                    }
                }
                this.log("running_in_cnf_mode=" + this.running_in_cnf_mode);
                if (this.running_in_cnf_mode) {
                    stringBuffer3.append("-- CNF mode ON \n");
                }
                stringBuffer3.append(string20 + "\nCAST(NULL AS NUMBER)" + ALIAS_SEP + string22 + "$RDFVID, " + (String)object9 + ALIAS_SEP + string22 + "$RDFTERM, " + (String)object8 + ALIAS_SEP + string22 + ", " + (String)object7 + ALIAS_SEP + string22 + "$RDFVTYP, " + object6 + ALIAS_SEP + string22 + "$_PREFIX, " + string23 + ALIAS_SEP + string22 + "$_SUFFIX, " + (String)((Object)list) + ALIAS_SEP + string22 + "$RDFLTYP, " + (String)object5 + ALIAS_SEP + string22 + "$RDFLANG, TO_CLOB(" + (String)object4 + ")" + ALIAS_SEP + string22 + "$RDFCLOB");
                string20 = ", ";
                continue;
            }
            this.log("running_in_cnf_mode=" + this.running_in_cnf_mode);
            if (this.running_in_cnf_mode) {
                stringBuffer2.append("-- CNF mode ON \n");
            }
            stringBuffer2.append(string20 + "sem_apis.sdo_rdf_term(" + (String)object9 + ") AS " + arrayList);
            string20 = ", ";
            stringBuffer2.append(string20 + (String)object9 + ALIAS_SEP + string22 + "$RDFTERM");
            stringBuffer5.append("\n" + string21 + "CAST(NULL AS NUMBER) AS " + string22 + "$RDFVID, T." + string22 + "$RDFTERM, T." + arrayList + ".value_name AS " + string22 + ", (CASE when T." + arrayList + ".value_type IS NULL then NULL when T." + arrayList + ".value_type IN ('UR','URI') then 'URI' when T." + arrayList + ".value_type IN ('BN','BLN') then 'BLN' else 'LIT' END) AS " + string22 + "$RDFVTYP, T." + arrayList + ".vname_prefix AS " + string22 + "$_PREFIX, T." + arrayList + ".vname_suffix AS " + string22 + "$_SUFFIX, T." + arrayList + ".literal_type AS " + string22 + "$RDFLTYP, T." + arrayList + ".language_type AS " + string22 + "$RDFLANG, T." + arrayList + ".long_value AS " + string22 + "$RDFCLOB");
            string21 = ", ";
        }
        this.log("2: outer_where_clause_tmp:" + stringBuffer + "***");
        if (object12.size() > 0) {
            this.log("NoRows_MCSRid_list =" + object12 + " : SKIP filter2vdco_condExpr generation");
        } else {
            object10 = this.genFilter2vCond_outer(natVarOpt_Info);
            stringBuffer.append((String)object10);
            this.log("after 2vdco: outer_where_clause_tmp :" + stringBuffer.toString());
        }
        if (object12.size() > 0) {
            this.log("SKIP processing of GEOMETRY filters at OUTER level: NoRows_MCSRid_list=" + object12);
        } else {
            this.log("going to process GEOMETRY filters at OUTER level");
            object10 = "";
            for (RelExpr relExpr : this.RelExprFilterList_for_BGP) {
                this.log("checking relExpr for GEOMETRY filter NOT processed in TPAT or UAROW level: " + relExpr.toString());
                if (relExpr.RelExprFlags != 2L) {
                    this.log("buildSQL_for_TpatCSRgroup_Tmap: skipping non-GEOMETRY filter at OUTER level");
                    continue;
                }
                if (relExpr.procAtLevel != null) {
                    this.log("buildSQL_for_TpatCSRgroup_Tmap: skipping filter at OUTER level b/c it has already been processed at level: " + relExpr.procAtLevel);
                    continue;
                }
                this.log("going to process GEOMETRY filters at OUTER level");
                hashSet.addAll(relExpr.filterExprTree.getVars());
                this.log("varsNeededInOuterCond_geo: " + hashSet);
                arrayList22 = this.genFilter_v3(null, "OUTER_LEVEL", null, -1, null, null, natVarOpt_Info, relExpr, hashSet, null, null);
                this.log("condExpr_geo :" + arrayList22);
                if (((String)((Object)arrayList22)).equals(" AND 1=0 ")) {
                    object10 = " AND 1=0 ";
                    break;
                }
                if (((String)((Object)arrayList22)).equals("")) {
                    this.log("ERROR: It MUST be handled in outer condition -- check the code");
                    continue;
                }
                relExpr.procAtLevel = "OUTER_LEVEL";
                this.log("processed this filter at OUTER level: relExpr.procAtLevel=" + relExpr.procAtLevel);
                object10 = (String)object10 + COND_CONNECTOR + arrayList22;
            }
            this.log("finally, OUTER level: condExpr_geometry_filter: " + (String)object10);
            stringBuffer.append((String)object10);
        }
        this.log("[COND] " + stringBuffer.toString());
        this.log("UArowNatSelectInfoArray_for_MCSRKey.size()=" + hashMap.size());
        object10 = BASE_PREFIX_COLNAME_SEP;
        for (ArrayList<String> arrayList22 : hashMap.keySet()) {
            int n12;
            arrayList = this.MCSR_for_MCSRkey.get(arrayList22);
            int n13 = ((MCSR)((Object)arrayList)).getMCSRid();
            int n14 = ((MCSR)((Object)arrayList)).getCSRKeyList().size();
            this.log("processing MCSRid=" + n13 + " MCSRkey [CSRKey_count=" + n14 + "]: " + arrayList22);
            if (object12.size() != 0) {
                if (!object12.contains(n13)) {
                    arrayList4.add("\n-- Skipped subquery: MCSRid=" + n13 + " MCSRkey=" + arrayList22);
                    continue;
                }
                arrayList4.add("\n-- NoRows: MCSRid=" + n13 + " MCSRkey=" + arrayList22);
                continue;
            }
            arrayList4.add("\n-- BEGIN MCSRid=" + n13 + " MCSRkey [CSRKey_count=" + n14 + "]=" + arrayList22 + "\n" + (String)object10 + "(");
            object10 = ",";
            List list6 = (List)hashMap.get(arrayList22);
            this.log("[HERE] UArowNatSelectInfoArray=" + list6);
            for (n12 = 0; n12 < list6.size(); ++n12) {
                object7 = (UArowNatSelectInfo)list6.get(n12);
                String string26 = ((UArowNatSelectInfo)object7).sqlSubq;
                int n15 = ((UArowNatSelectInfo)object7).selListEndpos;
                this.log("SQLSUBQ=" + string26);
                if (n15 >= 0) {
                    list = string26.substring(0, ((UArowNatSelectInfo)object7).selListEndpos);
                    object5 = string26.substring(((UArowNatSelectInfo)object7).selListEndpos, string26.length());
                    this.log("BEG_SQLSUBQ=" + (String)((Object)list));
                    this.log("END_SQLSUBQ=" + (String)object5);
                    object3 = "";
                    for (String string27 : ((UArowNatSelectInfo)object7).colList_for_var.keySet()) {
                        this.log("var=" + string27 + ": checking if native-cols need to be projected");
                        Set<String> set = this.occPosSet_for_CSRAlias_for_var.get(string27).keySet();
                        if (set.size() == 1 && !this.VarSet_filter2vCond_outer.contains(string27) && !hashSet.contains(string27)) {
                            this.log("--> var=" + string27 + ": not projecting native-cols b/c it appears in 1 CSR and not needed in two-var filter");
                            continue;
                        }
                        object2 = ((UArowNatSelectInfo)object7).colList_for_var.get(string27);
                        object3 = (String)object3 + natVarOpt_Info.get_natVarListStr_ForVar(string27, ((MCSR)((Object)arrayList)).getMCSRAlias(), (List<String>)object2, (Set<String>)hashSet);
                        this.log("NATSELLIST=" + (String)object3);
                    }
                    object6 = (String)((Object)list) + (String)object3 + (String)object5;
                    this.log("SQL_STR=" + (String)object6);
                    arrayList4.add(object6);
                    continue;
                }
                arrayList4.add(string26);
            }
            arrayList4.add("\n-- END MCSRkey=" + arrayList22);
            this.log("SQLARRAY_TMP=");
            for (n12 = 0; n12 < arrayList4.size(); ++n12) {
                this.log((String)arrayList4.get(n12));
            }
        }
        if (object12.size() > 0) {
            arrayList4.add("\n (" + string2 + "\n ) ");
        }
        this.log("no_clob_outer_select_clause_tmp :" + stringBuffer3.toString());
        this.log("outer_where_clause_tmp :" + stringBuffer.toString());
        if (this.occPosSet_for_CSRAlias_for_var.size() == 0 || n == 0) {
            this.log("EMPTY variable-list");
            if (bl8) {
                stringBuffer3.append(string20 + "NULL");
            } else {
                stringBuffer5.append("\n" + string21 + "NULL");
                stringBuffer2.append(string20 + "NULL");
            }
        }
        if (bl8) {
            ((StringBuffer)object).append(string19 + stringBuffer3.toString());
        } else {
            ((StringBuffer)object).append(stringBuffer5 + " FROM (\n");
            ((StringBuffer)object).append(stringBuffer2.toString());
        }
        if (this.ctx.topDownOpt) {
            ((StringBuffer)object).append(", 1 AS BGP$" + this.getId());
        }
        ((StringBuffer)object).append("\n  FROM ");
        boolean bl10 = false;
        while (var24_70 < arrayList4.size()) {
            ((StringBuffer)object).append((String)arrayList4.get((int)var24_70));
            ++var24_70;
        }
        this.log("3: outer_where_clause_tmp:" + stringBuffer + "***");
        stringBuffer.append(" AND EXISTS(" + this.rr_tab_dummy_query + ")");
        this.log("4: outer_where_clause_tmp:" + stringBuffer + "***");
        ((StringBuffer)object).append("\nWHERE " + stringBuffer.substring(COND_CONNECTOR.length()));
        if (!bl8) {
            ((StringBuffer)object).append("\n) T");
        }
        this.log("\n \n FINAL tmp SQL String is [length=" + ((StringBuffer)object).toString().length() + "]: \n");
        this.log(((StringBuffer)object).toString());
        return ((StringBuffer)object).toString();
    }

    public Map<Integer, Set<String>> getOccPosSet_for_TFTidx(String string, String string2, int n) {
        this.log("[getOccPosSet_for_TFTidx] ENTERING: var=" + string + " CSRAlias=" + string2 + " UArowNum=" + n);
        Set<String> set = this.occPosSet_for_CSRAlias_for_var.get(string).get(string2);
        CSRinfo cSRinfo = this.CSRinfo_for_CSRAlias.get(string2);
        int n2 = n % cSRinfo.getUArowsCount();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        LinkedHashMap<Integer, Set<String>> linkedHashMap = new LinkedHashMap<Integer, Set<String>>();
        this.log("Traversing occPosSet: " + set);
        for (String string3 : set) {
            this.log("   occPos=" + string3);
            String[] stringArray = string3.split(":");
            String string4 = stringArray[0];
            int n3 = Integer.valueOf(stringArray[1]);
            RRTabRowInfo rRTabRowInfo = cSRinfo.getRRrowInfo(n2, n3);
            Integer n4 = rRTabRowInfo.getTFTidx(string4);
            LinkedHashSet<String> linkedHashSet2 = (LinkedHashSet<String>)linkedHashMap.get(n4);
            if (linkedHashSet2 == null) {
                linkedHashSet2 = new LinkedHashSet<String>();
                linkedHashMap.put(n4, linkedHashSet2);
            }
            linkedHashSet2.add(string3);
        }
        this.log("[getOccPosSet_for_TFTidx] RETURNING: occPosSet_for_TFTidx [keySet().size()=" + linkedHashMap.keySet().size() + "]: " + linkedHashMap);
        return linkedHashMap;
    }

    @Override
    public SPMComponents extractSPMComponents() {
        SPMComponents sPMComponents = new SPMComponents();
        return sPMComponents;
    }

    private static void printMapSet(HashMap<String, Set<String>> hashMap, SQLGenContext sQLGenContext) {
        for (String string : hashMap.keySet()) {
            RelationalBGP.log_static("Set defined for " + string, sQLGenContext.R2RFlags);
            Set<String> set = hashMap.get(string);
            RelationalBGP.log_static(" corresponding set values : ", sQLGenContext.R2RFlags);
            for (String string2 : set) {
                RelationalBGP.log_static(" : " + string2, sQLGenContext.R2RFlags);
            }
        }
        RelationalBGP.log_static("\n", sQLGenContext.R2RFlags);
    }

    private static void printMapList(HashMap<String, List<String>> hashMap, SQLGenContext sQLGenContext) {
        for (String string : hashMap.keySet()) {
            RelationalBGP.log_static("Predicate Set defined for Subject Variable " + string, sQLGenContext.R2RFlags);
            List<String> list = hashMap.get(string);
            RelationalBGP.log_static(" corresponding predicate list : ", sQLGenContext.R2RFlags);
            for (String string2 : list) {
                RelationalBGP.log_static(" : " + string2, sQLGenContext.R2RFlags);
            }
        }
        RelationalBGP.log_static("\n", sQLGenContext.R2RFlags);
    }

    private static void printMap(HashMap<String, String> hashMap, SQLGenContext sQLGenContext) {
        for (String string : hashMap.keySet()) {
            String string2 = hashMap.get(string);
            RelationalBGP.log_static("Entry in set = : " + string + "  " + string2, sQLGenContext.R2RFlags);
        }
        RelationalBGP.log_static("\n", sQLGenContext.R2RFlags);
    }

    @Override
    public String toString(String string) {
        return this.bgp.toString(string);
    }

    static {
        geo_functionArgsMap.put("!", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.w3.org/2001/XMLSchema#boolean")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/relate", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", XSD_STRING_NO_ENCLOSING)));
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/relate", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", XSD_STRING_NO_ENCLOSING)));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfEquals", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfContains", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfDisjoint", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfCrosses", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfIntersects", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfOverlaps", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfTouches", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfWithin", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/withinDistance", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", XSD_DECIMAL_NO_ENCLOSING, XSD_STRING_NO_ENCLOSING)));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/convexHull", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/convexHull", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/buffer", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", XSD_DECIMAL_NO_ENCLOSING, XSD_STRING_NO_ENCLOSING)));
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/buffer", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", XSD_DECIMAL_NO_ENCLOSING, XSD_STRING_NO_ENCLOSING)));
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/centroid", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/mbr", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_funtionRequiringSridTransformationSet.add("http://xmlns.oracle.com/rdf/geo/difference");
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/difference", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_funtionRequiringSridTransformationSet.add("http://xmlns.oracle.com/rdf/geo/intersection");
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/intersection", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_funtionRequiringSridTransformationSet.add("http://xmlns.oracle.com/rdf/geo/union");
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/union", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_funtionRequiringSridTransformationSet.add("http://xmlns.oracle.com/rdf/geo/xor");
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/xor", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        FUNC_DECL = "\nWITH\n\nFUNCTION orardf$vname (term varchar2) RETURN varchar2 deterministic AS\nBEGIN\nRETURN\n" + RelationalBGP.vname("term") + ";\nEND;\nFUNCTION orardf$vtype (term varchar2) RETURN varchar2 deterministic AS\nBEGIN\nRETURN\n" + RelationalBGP.vtype("term") + ";\nEND;\nFUNCTION orardf$vnpfx (term varchar2) RETURN varchar2 deterministic AS\nBEGIN\nRETURN\n" + RelationalBGP.vnpfx("term") + ";\nEND;\nFUNCTION orardf$vnsfx (term varchar2) RETURN varchar2 deterministic AS\nBEGIN\nRETURN\n" + RelationalBGP.vnsfx("term") + ";\nEND;\nFUNCTION orardf$ltype (term varchar2) RETURN varchar2 deterministic AS\nBEGIN\nRETURN\n" + RelationalBGP.ltype("term") + ";\nEND;\nFUNCTION orardf$latag (term varchar2) RETURN varchar2 deterministic AS\nBEGIN\nRETURN\n" + RelationalBGP.latag("term") + ";\nEND;";
        sqlcompOper_clobCompare_map = RelationalBGP.create_map_of_strings(new String[]{"=", "!=", ">", "<", ">=", "<="}, new String[]{" = 0 ", " != 0 ", " = 1 ", " = -1 ", " >= 0 ", " <= 0 "});
    }

    public class SpatialArgTypeException
    extends SpatialFilterHandler.SpatialArgException {
        SpatialArgTypeException(String string) {
            super(string);
        }
    }

    private static class R2R2MatSPARQLFilterMap {
        public static final String ATOM_TYPE_URI = "ATOM_TYPE_URI";
        public static final Integer _ATOM_TYPE_URI = 196607;
        private static HashMap<String, Integer> R2R_to_MatSPARQL_type_map = new HashMap();
        private Integer filter_type;
        private String r2r_type;
        private String sql;
        private Long srid;
        private String value_name_0;
        private String value_type_1;
        private String vname_prefix_2;
        private String vname_suffix_3;
        private String literal_type_4;
        private String language_type_5;
        private String long_value_6;
        private String argument_type_7;
        private String arg_8;
        private String geoDimension;
        private String varName;

        R2R2MatSPARQLFilterMap(Integer n, String string) {
            this(n, string, null);
        }

        R2R2MatSPARQLFilterMap(Integer n, String string, Long l) {
            this(new String(), string, l);
            this.filter_type = n;
            this.r2r_type = null;
        }

        R2R2MatSPARQLFilterMap(String string, String string2) {
            this(string, string2, null);
        }

        R2R2MatSPARQLFilterMap(String string, String string2, Long l) {
            this.sql = string2;
            this.r2r_type = string;
            this.filter_type = R2R_to_MatSPARQL_type_map.get(string);
            this.srid = l;
            this.value_name_0 = "''";
            this.value_type_1 = "'LIT'";
            this.vname_prefix_2 = null;
            this.vname_suffix_3 = "''";
            this.literal_type_4 = "''";
            this.language_type_5 = "''";
            this.long_value_6 = "TO_CLOB(NULL)";
            this.argument_type_7 = null;
            this.arg_8 = "LOCAL_VAR";
            this.geoDimension = null;
            this.varName = null;
        }

        public static int getNodeFilterType(String string) {
            return R2R_to_MatSPARQL_type_map.get(string);
        }

        public String getNodeFilterSQL() {
            return this.sql;
        }

        public Integer getNodeFilterType() {
            return this.filter_type;
        }

        public void setVarName(String string) {
            this.varName = string;
        }

        public String getVarName() {
            return this.varName;
        }

        public void setValue_name_0(String string) {
            this.value_name_0 = string;
        }

        public String getValue_name_0() {
            return this.value_name_0;
        }

        public void setValue_type_1(String string) {
            this.value_type_1 = string;
        }

        public String getValue_type_1() {
            return this.value_type_1;
        }

        public void setVname_prefix_2(String string) {
            this.vname_prefix_2 = string;
        }

        public String getVname_prefix_2() {
            return this.vname_prefix_2;
        }

        public void setVname_suffix_3(String string) {
            this.vname_suffix_3 = string;
        }

        public String getVname_suffix_3() {
            return this.vname_suffix_3;
        }

        public void setLiteral_type_4(String string) {
            this.literal_type_4 = string;
        }

        public String getLiteral_type_4() {
            return this.literal_type_4;
        }

        public void setLanguage_type_5(String string) {
            this.language_type_5 = string;
        }

        public String getLanguage_type_5() {
            return this.language_type_5;
        }

        public void setLong_value_6(String string) {
            this.long_value_6 = string;
        }

        public String getLong_value_6() {
            return this.long_value_6;
        }

        public void setArgument_type_7(String string) {
            this.argument_type_7 = string;
        }

        public String getArgument_type_7() {
            return this.argument_type_7;
        }

        public void setArg_8(String string) {
            this.arg_8 = string;
        }

        public String getArg_8() {
            return this.arg_8;
        }

        public void setGeoDimension(String string) {
            this.geoDimension = string;
        }

        public String getGeoDimension() {
            return this.geoDimension;
        }

        public void setFilter_type(Integer n) {
            this.filter_type = n;
        }

        public Integer getFilter_type() {
            return this.filter_type;
        }

        public void setR2r_type(String string) {
            this.r2r_type = string;
        }

        public String getR2r_type() {
            return this.r2r_type;
        }

        public void setSql(String string) {
            this.sql = string;
        }

        public String getSql() {
            return this.sql;
        }

        public void setSrid(Long l) {
            this.srid = l;
        }

        public Long getSrid() {
            return this.srid;
        }

        public String toString() {
            return String.format("         r2r_type: %s \n\t      filter_type: %d \n\t             srid: %s \n\t              sql: %s \n\t     value_name_0: %s \n\t     value_type_1: %s \n\t   vname_prefix_2: %s \n\t   vname_suffix_3: %s \n\t   literal_type_4: %s \n\t  language_type_5: %s \n\t     long_value_6: %s \n\t  argument_type_7: %s \n\t            arg_8: %s \n\t     geoDimension: %s \n\t          varName: %s \n\t", this.r2r_type == null ? "null" : this.r2r_type, this.filter_type, this.srid, this.sql, this.value_name_0, this.value_type_1, this.vname_prefix_2, this.vname_suffix_3, this.literal_type_4, this.language_type_5, this.long_value_6, this.argument_type_7, this.arg_8, this.geoDimension, this.varName);
        }

        static {
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.XSD_DECIMAL_NO_ENCLOSING, 12);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.XSD_DOUBLE_NO_ENCLOSING, 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#integer", 12);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.XSD_FLOAT_NO_ENCLOSING, 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#int", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#negativeInteger", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#long", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#short", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#unsignedLong", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#unsignedInt", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#unsignedShort", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#unsignedByte", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#positiveInteger", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#byte", 6);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#boolean", 5);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.XSD_STRING_NO_ENCLOSING, 11);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.XSD_DATE_NO_ENCLOSING, 15);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#time", 16);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.XSD_DATETIME_NO_ENCLOSING, 14);
            R2R_to_MatSPARQL_type_map.put("URI", 5);
            R2R_to_MatSPARQL_type_map.put("http://www.opengis.net/ont/geosparql#wktLiteral", 24);
            R2R_to_MatSPARQL_type_map.put("http://www.opengis.net/ont/geosparql#gmlLiteral", 22);
            R2R_to_MatSPARQL_type_map.put("http://xmlns.oracle.com/rdf/geo/GML31Literal", 22);
            R2R_to_MatSPARQL_type_map.put("STRING", 11);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_NUMERIC, 12);
            R2R_to_MatSPARQL_type_map.put("SDO_GEOMETRY", 25);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_FLOAT, 4);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_DOUBLE, 4);
            R2R_to_MatSPARQL_type_map.put("DATE", 4);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_TIME, 4);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_DATETIME, 4);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_BOOLEAN, 4);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_RAW, 4);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_OTHER, 4);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_NUMFLTDBL, 4);
        }
    }

    private class ElapsedTimeInfo {
        private String label;
        private String type;
        private Long startTime = 0L;
        private Long finishTime = 0L;
        private Long total = 0L;
        private Map<String, ElapsedTimeInfo> children;
        private ElapsedTimeInfo parent;
        private String state = null;
        public final String STARTED = "started";
        public final String FINISHED = "finished";
        public final String ROOT = "root";
        public final String METHOD = "method";
        public final String LOOP = "loop";
        public final String ITERATION = "iteration";

        ElapsedTimeInfo(String string) {
            this.label = string;
            this.children = new LinkedHashMap<String, ElapsedTimeInfo>();
            this.parent = null;
        }

        ElapsedTimeInfo(String string, ElapsedTimeInfo elapsedTimeInfo) {
            this(string);
            this.parent = elapsedTimeInfo;
        }

        public ElapsedTimeInfo addChild(String string) throws RDFException {
            if (this.children.containsKey(string)) {
                throw new RDFException("Exception trying to add a duplicate level");
            }
            ElapsedTimeInfo elapsedTimeInfo = new ElapsedTimeInfo(string, this);
            this.children.put(string, elapsedTimeInfo);
            return elapsedTimeInfo;
        }

        protected void setTotal(Long l) {
            this.total = l;
        }

        public Long getTotal() {
            return this.total;
        }

        protected void setState(String string) {
            this.state = string;
        }

        public String getState() {
            return this.state;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }

        protected void start() {
            this.state = "started";
            this.startTime = System.currentTimeMillis();
        }

        protected void finish() {
            this.state = "finished";
            this.finishTime = System.currentTimeMillis();
            if (this.children.size() == 0) {
                ElapsedTimeInfo elapsedTimeInfo = this.parent;
                while (elapsedTimeInfo != null) {
                    Long l = this.finishTime - this.startTime;
                    elapsedTimeInfo.setTotal(elapsedTimeInfo.total + l);
                    elapsedTimeInfo = elapsedTimeInfo.parent;
                }
                this.total = this.finishTime - this.startTime;
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : this.children.keySet()) {
                ElapsedTimeInfo elapsedTimeInfo = this.children.get(string);
                stringBuffer.append(elapsedTimeInfo.toString() + "\n");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, "\n");
            }
            return String.format("[%15s] %15s -> %10d [%10d] %s ", this.parent != null ? this.parent.label : "null", this.label, this.finishTime - this.startTime, this.total, stringBuffer.toString());
        }
    }

    private class ElapsedTimeInfoHandler {
        public final String INITIATED = "initiated";
        public final String STARTED = "started";
        public final String FINISHED = "finished";
        public final String CLOSED = "closed";
        public final String ROOT = "root";
        public final String METHOD = "method";
        public final String LOOP = "loop";
        public final String ITERATION = "iteration";
        private Stack<ElapsedTimeInfo> stack = new Stack();
        private ElapsedTimeInfo current = null;
        private ElapsedTimeInfo root = null;
        private boolean elapsed_time_logging_on = false;

        ElapsedTimeInfoHandler() {
            long l = ((RelationalBGP)RelationalBGP.this).ctx.R2RFlags & 7L;
            if (l > 0L) {
                this.elapsed_time_logging_on = true;
            }
            if (this.elapsed_time_logging_on) {
                this.root = new ElapsedTimeInfo("root");
                this.root.setType("root");
                this.root.start();
                this.stack.push(this.root);
                this.current = this.root;
            }
        }

        public void finishElapsedTime() throws RDFException {
            if (this.elapsed_time_logging_on) {
                if (this.current == null || !this.current.getState().equals("started")) {
                    throw new RDFException("Exception trying to finish an un-started ElapsedTimeInfo");
                }
                this.current.finish();
                this.stack.pop();
                this.current = this.stack.empty() ? null : this.stack.peek();
            }
        }

        public void startMethodElapsedTime(String string) throws RDFException {
            if (this.elapsed_time_logging_on) {
                ElapsedTimeInfo elapsedTimeInfo;
                this.current = elapsedTimeInfo = this.current.addChild(string);
                this.current.setType("method");
                this.stack.push(this.current);
                this.current.start();
            }
        }

        public void startLoopElapsedTime(String string) throws RDFException {
            if (this.elapsed_time_logging_on) {
                ElapsedTimeInfo elapsedTimeInfo;
                this.current = elapsedTimeInfo = this.current.addChild(string);
                this.current.setType("loop");
                this.stack.push(this.current);
                this.current.start();
            }
        }

        public void finishLoopElapsedTime() throws RDFException {
            if (this.elapsed_time_logging_on) {
                this.finishElapsedTime();
            }
        }

        public void startIterationElapsedTime(String string) throws RDFException {
            if (this.elapsed_time_logging_on) {
                ElapsedTimeInfo elapsedTimeInfo;
                ElapsedTimeInfo elapsedTimeInfo2 = null;
                if (!this.current.getType().equals("loop")) {
                    if (this.current.getType().equals("iteration")) {
                        throw new RDFException("Exception trying to start iteration inside another iteration");
                    }
                    throw new RDFException("Exception trying to start iteration inside other than a loop");
                }
                elapsedTimeInfo2 = this.current;
                this.current = elapsedTimeInfo = elapsedTimeInfo2.addChild(string);
                this.current.setType("iteration");
                this.stack.push(this.current);
                this.current.start();
            }
        }

        public void finishIterationElapsedTime() throws RDFException {
            if (this.elapsed_time_logging_on) {
                this.finishElapsedTime();
            }
        }

        public String toString() {
            if (this.elapsed_time_logging_on) {
                return String.format("[%15s] %15s -> %10s [%10s] \n%s ", "PARENT", "LABEL", "DELTA", "TOTAL", this.root.toString());
            }
            return "";
        }
    }

    private class UnionRow {
        public List<String> RRrowList;
        public String fromCommon;
        public ArrayList<Pair_IntString> oFromList;
        public HashMap<String, ArrayList<Integer>> TpCE_colNotNull;
        public HashMap<String, ArrayList<Integer>> TpCE_colEqConst;
        public HashMap<String, ArrayList<Integer>> TpCE_colPairEq;
        public HashMap<String, ArrayList<Pair_IntInt>> TpPairCE;
        public HashMap<String, ArrayList<Integer>> TpGE;
        public List<String> pExprList;
        public List<String> oExprList;

        private UnionRow() {
        }

        public String toString() {
            return "UnionRow.toString(): not implemented yet";
        }
    }

    private class LtcTabRowInfo {
        public String Tmap;
        public String colName;
        public int colType;
        public String colTypeName;
        public Integer colMaxLen;
        public Integer colPrecision;
        public Integer colScale;
        private String srid;
        private ColDimInfoMetadata colDimInfoMetadata;

        public LtcTabRowInfo(String string, String string2, Integer n, String string3, Integer n2, Integer n3, Integer n4) {
            this.Tmap = string;
            this.colName = string2;
            this.colType = n;
            this.colTypeName = string3;
            this.colPrecision = n3;
            this.colScale = n4;
            this.colDimInfoMetadata = null;
        }

        public void setGeomMetadata(String string, String string2, String string3, String string4, String string5) {
            if ("SDO_GEOMETRY".equals(this.colTypeName)) {
                if (this.colDimInfoMetadata == null) {
                    this.colDimInfoMetadata = new ColDimInfoMetadata(string);
                }
                this.colDimInfoMetadata.addDimInfo(string2, string3, string4, string5);
            }
        }

        public String getSRID() {
            if ("SDO_GEOMETRY".equals(this.colTypeName) && this.colDimInfoMetadata != null) {
                return this.colDimInfoMetadata.srid;
            }
            return null;
        }

        public String getDimArrayConstructor() {
            if ("SDO_GEOMETRY".equals(this.colTypeName) && this.colDimInfoMetadata != null) {
                return this.colDimInfoMetadata.getDimArrayConstructor();
            }
            return null;
        }

        public String getDimArrayConstructor(String string) {
            if ("SDO_GEOMETRY".equals(this.colTypeName) && this.colDimInfoMetadata != null) {
                return this.colDimInfoMetadata.getDimArrayConstructor();
            }
            return string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n  *[Tmap=" + this.Tmap + " colName=" + this.colName + "]");
            stringBuffer.append("\n  colType=" + this.colType + " colTypeName=" + this.colTypeName);
            stringBuffer.append("\n  colPrecision=" + this.colPrecision + " colScale=" + this.colScale);
            if ("SDO_GEOMETRY".equals(this.colTypeName)) {
                stringBuffer.append("\n  SDO_GEOMETRY metadata: " + (this.colDimInfoMetadata == null ? "NO SDO_GEOMETRY metadata" : this.colDimInfoMetadata.toString()));
            }
            return stringBuffer.toString();
        }

        public class ColDimInfoMetadata {
            private String srid;
            private List<String> sdo_dimnames;
            private List<String> sdo_lbs;
            private List<String> sdo_ubs;
            private List<String> sdo_tolerances;

            ColDimInfoMetadata(String string) {
                this.srid = string != null ? string : RelationalBGP.DEFAULT_GEOMETRY_SRID_STR;
                this.sdo_dimnames = new ArrayList<String>();
                this.sdo_lbs = new ArrayList<String>();
                this.sdo_ubs = new ArrayList<String>();
                this.sdo_tolerances = new ArrayList<String>();
            }

            public boolean addDimInfo(String string, String string2, String string3, String string4) {
                this.sdo_dimnames.add(string);
                this.sdo_lbs.add(string2);
                this.sdo_ubs.add(string3);
                this.sdo_tolerances.add(string4);
                return true;
            }

            public String getDimArrayConstructor() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("sdo_dim_array(");
                for (int i = 0; i < this.sdo_dimnames.size(); ++i) {
                    stringBuffer.append(String.format("sdo_dim_element('%s','%s','%s','%s')", this.sdo_dimnames.get(i), this.sdo_lbs.get(i), this.sdo_ubs.get(i), this.sdo_tolerances.get(i)));
                    if (i >= this.sdo_dimnames.size() - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
                return stringBuffer.toString();
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer("DIMINFO: ");
                stringBuffer.append(String.format("SRID: %s\n", this.srid));
                for (int i = 0; i < this.sdo_dimnames.size(); ++i) {
                    stringBuffer.append(String.format("\t[%2d] SDO_DIMNAME: %s, SDO_LB: %s, SDO_UB: %s, SDO_TOLERANCE: %s\n", i, this.sdo_dimnames.get(i), this.sdo_lbs.get(i), this.sdo_ubs.get(i), this.sdo_tolerances.get(i)));
                }
                return stringBuffer.toString();
            }
        }
    }

    private class NatVarOpt_Info {
        private HashMap<String, NatVarOpt_Structure> natVarOptInfo_for_var = new HashMap();

        public NatVarOpt_Structure get_NatVarOpt_Structure(String string) {
            return this.natVarOptInfo_for_var.get(string);
        }

        public String noVa_compose_multiOccVar_joinCond_for_UArow(String string, String string2, int n, String string3, int n2, List<List<String>> list, List<List<String>> list2, List<String> list3, List<String> list4, SQLGenContext sQLGenContext) throws RDFException, SQLException {
            RelationalBGP.this.log("Entering: noVa_compose_multiOccVar_joinCond_for_UArow: var=" + string + " UArowAbsNum=" + n + " CSRAlias=" + string2);
            String string4 = "";
            if (this.natVarOptInfo_for_var.containsKey(string)) {
                NatVarOpt_Structure natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                string4 = natVarOpt_Structure.noVa_compose_multiOccVar_joinCond_for_UArow(string2, n, string3, n2, list, list2, list3, list4, sQLGenContext);
            } else {
                RelationalBGP.this.log("natVarOptInfo_for_var does NOT contain var=" + string);
            }
            RelationalBGP.this.log("Exiting: noVa_compose_multiOccVar_joinCond_for_UArow: optOutNatCond=" + string4);
            return string4;
        }

        public String noVa_compose_multiOccVar_joinCond_for_UArow_across_CSRs(MCSR mCSR, int n, SQLGenContext sQLGenContext) throws RDFException, SQLException {
            RelationalBGP.this.log("[NatVarOpt_Info noVa_compose_multiOccVar_joinCond_for_UArow_across_CSRs]  ENTERING UArowNum_for_MCSR=" + n);
            StringBuffer stringBuffer = new StringBuffer();
            RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs]  mcsr.CSRAliasSet_for_var:" + mCSR.CSRAliasSet_for_var);
            for (String string : mCSR.getMCSRvarsList()) {
                String string2 = "";
                String string3 = "";
                Set<String> set = mCSR.getCSRAliasSet_for_var(string);
                RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs]  var=" + string + " CSRAliasSet:" + set);
                if (set.size() < 2) {
                    RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs]  JOIN not required for var:" + string);
                    continue;
                }
                String[] stringArray = set.toArray(new String[set.size()]);
                String string4 = stringArray[0];
                RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs]  CSRAlias1=" + string4);
                CSRinfo cSRinfo = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRAlias.get(string4);
                int n2 = n % cSRinfo.getUArowsCount();
                int n3 = cSRinfo.getFirstTFTIdx(n2, string);
                String string5 = cSRinfo.sAliasArray.get(n2);
                String string6 = cSRinfo.getFirstOccPos(string);
                String string7 = cSRinfo.get_Tmap_for_UArowNum(n2);
                String string8 = (String)RelationalBGP.this.SubjRRrowid_for_Tmap.get(string7);
                String string9 = mCSR.getACRinfo_for_AliasComponentRRrowid(string5, "subject", string8).get_ACRexpr();
                String string10 = RelationalBGP.this.getExprFromArrays(string6, n2, string9, cSRinfo.pExprArrays, cSRinfo.oExprArrays, cSRinfo.gExprArray, null);
                for (int i = 1; i < stringArray.length; ++i) {
                    String string11;
                    String string12;
                    TFTinfo tFTinfo;
                    String string13 = stringArray[i];
                    CSRinfo cSRinfo2 = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRAlias.get(string13);
                    int n4 = n % cSRinfo2.getUArowsCount();
                    int n5 = cSRinfo2.getFirstTFTIdx(n4, string);
                    String string14 = cSRinfo2.sAliasArray.get(n4);
                    String string15 = cSRinfo2.getFirstOccPos(string);
                    RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs]  CSRAlias2=" + string13);
                    RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs]  sAlias1:" + string5);
                    RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs]  sAlias2:" + string14);
                    if (mCSR.isPairOfCSRsAlreadyJoined(string5, string14)) {
                        RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs]  ... CSRs already joined!");
                        RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs] ");
                        continue;
                    }
                    if (!RelationalBGP.this.isCompatibleTFTpair(n3, n5)) {
                        RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs] The TFTs " + n3 + " and " + n5 + " are not compatible");
                        RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs] RETURNING  AND 1=0 ");
                        return " AND 1=0 ";
                    }
                    String string16 = "UNKNOWN";
                    TFTinfo tFTinfo2 = (TFTinfo)RelationalBGP.this.TFTinfoGlobalList.get(n3);
                    if (n3 == n5) {
                        string16 = "YES";
                        tFTinfo = tFTinfo2;
                    } else {
                        tFTinfo = (TFTinfo)RelationalBGP.this.TFTinfoGlobalList.get(n5);
                        string16 = !tFTinfo2.strList.equals(tFTinfo.strList) ? "NO" : "YES_AFTER_TYPE_CASTING";
                    }
                    if (string16.equals("NO")) {
                        string12 = cSRinfo2.get_Tmap_for_UArowNum(n4);
                        string11 = (String)RelationalBGP.this.SubjRRrowid_for_Tmap.get(string12);
                        String string17 = mCSR.getACRinfo_for_AliasComponentRRrowid(string5, "subject", string11).get_ACRexpr();
                        String string18 = RelationalBGP.this.getExprFromArrays(string15, n4, string17, cSRinfo2.pExprArrays, cSRinfo2.oExprArrays, cSRinfo2.gExprArray, null);
                        string3 = string3 + RelationalBGP.COND_CONNECTOR + string10 + " = " + string18;
                        continue;
                    }
                    string12 = string6.split(":")[0];
                    string11 = string15.split(":")[0];
                    int n6 = Integer.valueOf(string6.split(":")[1]);
                    int n7 = Integer.valueOf(string15.split(":")[1]);
                    RRTabRowInfo rRTabRowInfo = cSRinfo.getRRrowInfo(n2, n6);
                    RRTabRowInfo rRTabRowInfo2 = cSRinfo2.getRRrowInfo(n4, n7);
                    List<String> list = null;
                    List<String> list2 = null;
                    if (string12.equals("subject") && rRTabRowInfo.sExpr != null) {
                        list = rRTabRowInfo.colLists.get(0);
                    } else if (string12.equals("predicate") && rRTabRowInfo.pExpr != null) {
                        list = rRTabRowInfo.colLists.get(1);
                    } else if (string12.equals("object") && rRTabRowInfo.oExpr != null) {
                        list = rRTabRowInfo.colLists.get(2);
                    } else if (string12.equals("object") && rRTabRowInfo.psExpr != null) {
                        list = rRTabRowInfo.colLists.get(4);
                    } else if (string12.equals("graph") && rRTabRowInfo.pogExpr != null) {
                        list = rRTabRowInfo.colLists.get(3);
                    }
                    if (string11.equals("subject") && rRTabRowInfo2.sExpr != null) {
                        list2 = rRTabRowInfo2.colLists.get(0);
                    } else if (string11.equals("predicate") && rRTabRowInfo2.pExpr != null) {
                        list2 = rRTabRowInfo2.colLists.get(1);
                    } else if (string11.equals("object") && rRTabRowInfo2.oExpr != null) {
                        list2 = rRTabRowInfo2.colLists.get(2);
                    } else if (string11.equals("object") && rRTabRowInfo2.psExpr != null) {
                        list2 = rRTabRowInfo2.colLists.get(4);
                    } else if (string11.equals("graph") && rRTabRowInfo2.pogExpr != null) {
                        list2 = rRTabRowInfo2.colLists.get(3);
                    }
                    RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs]  colList1:" + list);
                    RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs]  colList2:" + list2);
                    boolean bl = false;
                    if ("SDO_GEOMETRY".equals(tFTinfo2.datatype_family) || "SDO_GEOMETRY".equals(tFTinfo2.datatype_family)) {
                        if ("SDO_GEOMETRY".equals(tFTinfo2.datatype_family) && "SDO_GEOMETRY".equals(tFTinfo2.datatype_family)) {
                            bl = true;
                            RelationalBGP.this.log("multiOcc join cond for geometry var");
                        } else {
                            throw new RDFException("LH and RH vars should be both of type SDO_GEOMETRY");
                        }
                    }
                    for (int j = 0; j < list.size(); ++j) {
                        String string19 = list.get(j);
                        String string20 = list2.get(j);
                        String string21 = null;
                        string21 = bl ? "( sdo_equal(" + string5 + "." + string19 + ", " + string14 + "." + string20 + RelationalBGP.SDO_EQUAL_END + " )" : "(" + string5 + "." + string19 + "=" + string14 + "." + string20 + ")";
                        if (!string5.equals(string14) || !string19.equals(string20)) {
                            string2 = string2 + RelationalBGP.COND_CONNECTOR + string21;
                            continue;
                        }
                        RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs]  unnecesary expression optOutNatCond:" + string21);
                    }
                    RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs]  optOutNatCond:" + string2);
                }
                stringBuffer.append(string2 + string3);
            }
            Object object = "";
            if (stringBuffer.length() > 0) {
                object = " AND (/**/" + stringBuffer.toString().replaceFirst(RelationalBGP.COND_CONNECTOR, "") + ")";
            } else {
                RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs] Empty JOIN condition!");
            }
            RelationalBGP.this.log("[NatVarOpt_Info noVa_c...Var_join..._UArow_across_CSRs] RETURNING:" + (String)object);
            return object;
        }

        public boolean containsVar(String string) {
            return this.natVarOptInfo_for_var.containsKey(string);
        }

        public COptNatCondition get_optOutNatCond_ForVar(String string, Set<String> set) throws RDFException, SQLException {
            COptNatCondition cOptNatCondition = null;
            if (set.size() > 1 && this.natVarOptInfo_for_var.containsKey(string)) {
                NatVarOpt_Structure natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                cOptNatCondition = natVarOpt_Structure.get_optOutNatCond_ForVar(string, set);
            }
            return cOptNatCondition;
        }

        public String get_optOutNatCond_For_Filter2v(String string, String string2, String string3) {
            RelationalBGP.this.log("==>get_optOutNatCond_For_Filter2v");
            String string4 = "";
            String string5 = "";
            if (this.natVarOptInfo_for_var.containsKey(string) && this.natVarOptInfo_for_var.containsKey(string2)) {
                Serializable serializable;
                Iterator iterator;
                NatVarOpt_Structure natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                NatVarOpt_Structure natVarOpt_Structure2 = this.natVarOptInfo_for_var.get(string2);
                Integer n = new Integer(-1);
                Iterator iterator2 = natVarOpt_Structure.natVarCountForAlias_for_TFTidx.keySet().iterator();
                if (iterator2.hasNext()) {
                    iterator = (Integer)iterator2.next();
                    n = iterator;
                }
                iterator2 = new Integer(-1);
                iterator = natVarOpt_Structure2.natVarCountForAlias_for_TFTidx.keySet().iterator();
                if (iterator.hasNext()) {
                    serializable = (Integer)iterator.next();
                    iterator2 = serializable;
                }
                if (n == iterator2) {
                    HashMap hashMap;
                    Object object;
                    iterator = "";
                    serializable = new ArrayList();
                    String string6 = RelationalBGP.COND_CONNECTOR;
                    if (string3.equals("!=")) {
                        string6 = "  OR ";
                    }
                    if ((object = (hashMap = (HashMap)natVarOpt_Structure.natVarCountForAlias_for_TFTidx.get(n)).keySet().iterator()).hasNext()) {
                        String string7 = (String)object.next();
                        for (int i = 0; i < (Integer)hashMap.get(string7); ++i) {
                            serializable.add(string7 + "." + string + RelationalBGP.NATIVE_SUFFIX + i);
                        }
                        RelationalBGP.this.log("optChosenExpr: " + serializable);
                    }
                    object = (TFTinfo)RelationalBGP.this.TFTinfoGlobalList.get((Integer)((Object)iterator2));
                    int n2 = 0;
                    hashMap = (HashMap)natVarOpt_Structure2.natVarCountForAlias_for_TFTidx.get(iterator2);
                    RelationalBGP.this.log("natVarNo_for_Alias=" + hashMap);
                    Iterator iterator3 = hashMap.keySet().iterator();
                    if (iterator3.hasNext()) {
                        String string8 = (String)iterator3.next();
                        for (int i = 0; i < (Integer)hashMap.get(string8); ++i) {
                            if (((TFTinfo)object).strIsolList.get(i) == null || ((TFTinfo)object).strIsolList.get(i + 1) == null) continue;
                            ++n2;
                            iterator = (String)((Object)iterator) + string6 + (String)serializable.get(i) + string3 + string8 + "." + string2 + RelationalBGP.NATIVE_SUFFIX + i;
                        }
                    }
                    string5 = string5 + (String)((Object)iterator);
                    RelationalBGP.this.log("allOptExpr=" + string5);
                    if (n2 > 0) {
                        string5 = " AND (" + string5.substring(5) + ")";
                        RelationalBGP.this.log("allOptExpr=" + string5);
                    }
                    string4 = string5;
                    if (((TFTinfo)object).numIsolStrs < ((TFTinfo)object).numCols + 1) {
                        RelationalBGP.this.log("partial opt native cond (this will be discarded for now): " + string4);
                        string4 = "";
                    }
                }
            }
            RelationalBGP.this.log("<==get_optOutNatCond_For_Filter2v");
            return string4;
        }

        public String get_natVarListStr_ForVar(String string, String string2, List<String> list, Set<String> set) throws RDFException {
            RelationalBGP.this.log(this.toString());
            RelationalBGP.this.log("=>get_natVarListStr_ForVar: var=" + string + " : CSRAlias=" + string2 + " : colList=" + list);
            String string3 = "";
            RelationalBGP.this.log("NATVAROPTINFO_FOR_VAR.CONTAINSKEY(" + string + ")=" + this.natVarOptInfo_for_var.containsKey(string));
            if (this.natVarOptInfo_for_var.containsKey(string)) {
                NatVarOpt_Structure natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                string3 = natVarOpt_Structure.get_natVarListStr_ForVar(string, string2, list, set);
            }
            return string3;
        }

        public HashSet<String> get_occInfoSet_inUArow(String string, Integer n) {
            NatVarOpt_Structure natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
            HashSet<String> hashSet = null;
            if (natVarOpt_Structure != null) {
                hashSet = natVarOpt_Structure.get_optOccInfoSet_inUArow(n);
            }
            return hashSet;
        }

        public void set(String string, NatVarOpt_Structure natVarOpt_Structure) {
            this.natVarOptInfo_for_var.put(string, natVarOpt_Structure);
        }

        public void set(String string, int n, String string2, String string3, int n2) {
            NatVarOpt_Structure natVarOpt_Structure;
            RelationalBGP.this.log("var=" + string + ": adding info for inter-CSR join optimization ...");
            if (!this.natVarOptInfo_for_var.containsKey(string)) {
                natVarOpt_Structure = new NatVarOpt_Structure(string);
                this.natVarOptInfo_for_var.put(string, natVarOpt_Structure);
                RelationalBGP.this.log("var=" + string + ": CREATED NEW NatVarOpt structure");
            } else {
                natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                RelationalBGP.this.log("var=" + string + ": ADDING to existing NatVarOpt structure");
            }
            natVarOpt_Structure.set(n, string2, string3, n2);
            RelationalBGP.this.log("var=" + string + ": adding info for inter-CSR join optimization ... DONE");
        }

        public void set(String string, Integer n, int n2, String string2) {
            NatVarOpt_Structure natVarOpt_Structure;
            RelationalBGP.this.log("var=" + string + ": adding info for LOCAL JOIN optimization ...");
            if (!this.natVarOptInfo_for_var.containsKey(string)) {
                natVarOpt_Structure = new NatVarOpt_Structure(string);
                this.natVarOptInfo_for_var.put(string, natVarOpt_Structure);
                RelationalBGP.this.log("var=" + string + ": CREATED NEW NatVarOpt structure");
            } else {
                natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                RelationalBGP.this.log("var=" + string + ": ADDING to existing NatVarOpt structure");
            }
            natVarOpt_Structure.set(n, n2, string2);
            RelationalBGP.this.log("var=" + string + ": adding info for LOCAL JOIN optimization ... DONE");
        }

        public void multiply(int n, int n2, int n3) {
            for (String string : this.natVarOptInfo_for_var.keySet()) {
                NatVarOpt_Structure natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                natVarOpt_Structure.multiply(n, n2, n3);
            }
        }

        public void resetLocalStructure() {
            for (String string : this.natVarOptInfo_for_var.keySet()) {
                NatVarOpt_Structure natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                natVarOpt_Structure.resetLocalStructure();
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : this.natVarOptInfo_for_var.keySet()) {
                stringBuffer.append("\n NatVarOpt_Structure for variable name=" + string + "-----------------------");
                stringBuffer.append(this.natVarOptInfo_for_var.get(string).toString());
            }
            return stringBuffer.toString();
        }
    }

    private class NatVarOpt_Structure {
        private String var;
        private int TEMPLATE = RRTabRowInfo.MapExprType_TEMPLATE;
        private int CONSTANT = RRTabRowInfo.MapExprType_CONSTANT;
        private int COLUMN = RRTabRowInfo.MapExprType_COLUMN;
        private String subjectPos;
        private Integer sTFT_idx;
        private HashMap<String, HashSet<Integer>> TFTidxSet_for_CSRAlias;
        private HashMap<Integer, HashMap<String, Integer>> natVarCountForAlias_for_TFTidx;
        private HashMap<Integer, HashMap<Integer, HashSet<String>>> TFTidx_occInfoSet_pairs_for_pos;

        public NatVarOpt_Structure(String string) {
            this.var = string;
            this.subjectPos = "";
            this.sTFT_idx = new Integer(-1);
            this.TFTidxSet_for_CSRAlias = new HashMap();
            this.natVarCountForAlias_for_TFTidx = new HashMap();
            this.TFTidx_occInfoSet_pairs_for_pos = new HashMap();
        }

        String getVar() {
            return this.var;
        }

        public boolean isValidForGeometryVar(int n) {
            TFTinfo tFTinfo = (TFTinfo)RelationalBGP.this.TFTinfoGlobalList.get(n);
            return tFTinfo.termType != null && tFTinfo.termType.equals(RelationalBGP.rrLiteral) && tFTinfo.datatype_family.equals("SDO_GEOMETRY");
        }

        public Set<Integer> getInvalidTFTsForGeometryVar() {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int n : this.natVarCountForAlias_for_TFTidx.keySet()) {
                if (this.isValidForGeometryVar(n)) continue;
                hashSet.add(n);
            }
            return hashSet;
        }

        public void removeInvalidTFTsForGeometryVar() {
            Set<Integer> set = this.getInvalidTFTsForGeometryVar();
            for (int n : set) {
                Object object;
                for (String string : this.TFTidxSet_for_CSRAlias.keySet()) {
                    object = this.TFTidxSet_for_CSRAlias.get(string);
                    object.remove(n);
                }
                this.natVarCountForAlias_for_TFTidx.remove(n);
                Iterator<Object> iterator = this.TFTidx_occInfoSet_pairs_for_pos.keySet().iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    object = this.TFTidx_occInfoSet_pairs_for_pos.get(n2);
                    object.remove(n);
                }
            }
        }

        public int getColCount() {
            int n = this.natVarCountForAlias_for_TFTidx.keySet().iterator().next();
            RelationalBGP.this.log("getColCount: top keySet()=" + this.natVarCountForAlias_for_TFTidx.keySet());
            RelationalBGP.this.log("getColCount: TFTidx=" + n);
            RelationalBGP.this.log("getColCount: .get(TFTidx).values()=" + this.natVarCountForAlias_for_TFTidx.get(n).values());
            int n2 = this.natVarCountForAlias_for_TFTidx.get(n).values().iterator().next();
            return n2;
        }

        public int getColCount_for_SDO_GEOMETRY(String string) {
            int n = -1;
            int n2 = -1;
            for (int n3 : this.natVarCountForAlias_for_TFTidx.keySet()) {
                String string2 = (String)RelationalBGP.this.TFTglobalList.get(n3);
                if (!string2.startsWith("L" + RRTabRowInfo.MapExprType_COLUMN + "SDO_GEOMETRY")) continue;
                n = n3;
            }
            if (n >= 0) {
                n2 = this.natVarCountForAlias_for_TFTidx.get(n).get(string);
            } else {
                RelationalBGP.this.log("INTERNAL ERROR in getColCount_for_SDO_GEOMETRY: could not find an SDO_GEOMETRY TFTidx");
            }
            return n2;
        }

        public String getCSRAlias() {
            return this.TFTidxSet_for_CSRAlias.keySet().iterator().next();
        }

        public HashMap<Integer, HashSet<String>> get_TFTidx_occInfoSet_pairs(int n) {
            return this.TFTidx_occInfoSet_pairs_for_pos.get(n);
        }

        /*
         * WARNING - void declaration
         */
        public String noVa_compose_multiOccVar_joinCond_for_UArow(String string, int n, String string2, int n2, List<List<String>> list, List<List<String>> list2, List<String> list3, List<String> list4, SQLGenContext sQLGenContext) throws RDFException, SQLException {
            RelationalBGP.this.log("==>ENTER: noVa_compose_multiOccVar_joinCond_for_UArow(): UArowAbsNum=" + n);
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            int n3 = this.TEMPLATE;
            boolean bl = true;
            Map<Integer, Set<String>> map = RelationalBGP.this.getOccPosSet_for_TFTidx(this.var, string, n);
            RelationalBGP.this.log("occPosSet_for_TFTidx [keySet().size()=" + map.keySet().size() + "]: " + map);
            if (map == null) {
                throw new RDFException("could not find any TFTidx_occInfoSet_pairs_for_pos entry for pos=" + n + "\nhere is the keySet(): " + this.TFTidx_occInfoSet_pairs_for_pos.keySet());
            }
            boolean bl2 = false;
            if (map.keySet().size() == 1) {
                int n4 = map.keySet().iterator().next();
                TFTinfo object = (TFTinfo)RelationalBGP.this.TFTinfoGlobalList.get(n4);
                if ("SDO_GEOMETRY".equals(object.datatype_family)) {
                    bl2 = true;
                    RelationalBGP.this.log("multiOcc join cond for geometry var");
                }
            }
            for (Integer n4 : map.keySet()) {
                for (Integer n5 : map.keySet()) {
                    if (n4 >= n5 || RelationalBGP.this.isCompatibleTFTpair(n4, n5)) continue;
                    return " AND 1=0 ";
                }
            }
            for (Integer n6 : map.keySet()) {
                void var21_30;
                RelationalBGP.this.log("-------------------------------------------------------");
                RelationalBGP.this.log("TFTidx=" + n6 + " [TYFAM_TEMPL=" + (String)RelationalBGP.this.TFTglobalList.get(n6) + "]");
                boolean bl3 = true;
                String string7 = "";
                String string8 = "";
                int n7 = this.TEMPLATE;
                ArrayList<String> arrayList = new ArrayList<String>();
                Set<String> set = map.get(n6);
                for (String string9 : set) {
                    String string10;
                    String string11;
                    RelationalBGP.this.log("        ------------------------------------------------");
                    RelationalBGP.this.log("OCCINFO=" + string9);
                    String string12 = string9.substring(0, string9.indexOf(58));
                    int n8 = Integer.parseInt(string9.substring(string9.indexOf(58) + 1, string9.length()));
                    String string13 = RelationalBGP.this.getExprFromArrays(string9, n, string2, list, list2, list3, null);
                    RelationalBGP.this.log("EXPR=" + string13);
                    String string14 = list4.get(n);
                    String[] stringArray = string14.substring(1, string14.length()).split(":");
                    ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(stringArray));
                    RelationalBGP.this.log(((Object)arrayList2).toString());
                    RRTabRowInfo rRTabRowInfo = (RRTabRowInfo)RelationalBGP.this.RRrowInfo_for_MatchingRow.get(arrayList2.get(n8));
                    String string15 = "";
                    int n9 = this.TEMPLATE;
                    List<String> list5 = null;
                    String string16 = string;
                    RelationalBGP.this.log("pos_in_tp=" + string12 + " RRrowInfo.psExpr=" + rRTabRowInfo.psExpr);
                    if (string12.equals("subject") && rRTabRowInfo.sExpr != null) {
                        string15 = rRTabRowInfo.sExpr;
                        n9 = rRTabRowInfo.sExprType;
                        list5 = rRTabRowInfo.sColTypeList;
                    } else if (string12.equals("predicate") && rRTabRowInfo.pExpr != null) {
                        string15 = rRTabRowInfo.pExpr;
                        n9 = rRTabRowInfo.pExprType;
                        list5 = rRTabRowInfo.pColTypeList;
                    } else if (string12.equals("object") && rRTabRowInfo.oExpr != null) {
                        string15 = rRTabRowInfo.oExpr;
                        n9 = rRTabRowInfo.oExprType;
                        list5 = rRTabRowInfo.oColTypeList;
                    } else if (string12.equals("object") && rRTabRowInfo.psExpr != null) {
                        string15 = rRTabRowInfo.psExpr;
                        n9 = rRTabRowInfo.psExprType;
                        list5 = rRTabRowInfo.psColTypeList;
                        string16 = string13.split("\\|\\|")[2].split("\\.")[0].trim();
                        RelationalBGP.this.log("Processing CSR parent Alias: " + string16);
                    } else if (string12.equals("graph") && rRTabRowInfo.pogExpr != null) {
                        string15 = rRTabRowInfo.pogExpr;
                        n9 = rRTabRowInfo.pogExprType;
                        list5 = rRTabRowInfo.pogColTypeList;
                    }
                    RelationalBGP.this.log("TEMPL=" + string15);
                    RelationalBGP.this.log("EXPRTYPE=" + n9);
                    RelationalBGP.this.log("COLTYPELIST=" + list5);
                    StringBuffer stringBuffer = new StringBuffer("");
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    ArrayList<String> arrayList4 = new ArrayList<String>();
                    if (n9 == this.TEMPLATE) {
                        string15 = string15.substring(1, string15.length() - 1);
                        string11 = RelationalBGP.sqlTempl2sqlExpr(string15, RelationalBGP.rrIRI, string16 + ".", stringBuffer, arrayList3, arrayList4, list5, null, sQLGenContext);
                    }
                    RelationalBGP.this.log("COLLIST=" + arrayList3);
                    RelationalBGP.this.log("STRLIST=" + arrayList4);
                    if (n9 == this.COLUMN) {
                        string11 = RelationalBGP.get_base_prefix_from_RR_table(string15);
                        if (string11 != null) {
                            string10 = RelationalBGP.get_col_name_from_RR_table(string15);
                            arrayList3.add(string10);
                            arrayList4.add(string11);
                        } else {
                            arrayList3.add(string15);
                            arrayList4.add("");
                        }
                    }
                    RelationalBGP.this.log("COLLIST=" + arrayList3);
                    RelationalBGP.this.log("STRLIST=" + arrayList4);
                    if (bl3) {
                        if (!bl && !string13.equals(string6)) {
                            string5 = n3 == this.CONSTANT && n9 == this.CONSTANT ? string5 + " AND 1=0" : string5 + RelationalBGP.COND_CONNECTOR + string6 + "=" + string13;
                            RelationalBGP.this.log("NOTOPTEXPRCOND=" + string5);
                        }
                        if (n9 == this.TEMPLATE || n9 == this.COLUMN) {
                            for (int i = 0; i < arrayList3.size(); ++i) {
                                arrayList.add(string16 + "." + (String)arrayList3.get(i));
                                string8 = string13;
                                n7 = n9;
                            }
                        } else if (n9 == this.CONSTANT) {
                            string8 = string13;
                            n7 = n9;
                        } else {
                            RelationalBGP.this.log("ERROR: It is not possible to assign optChosenExpr because Expr is not any of TEMPLATE, CONSTANT or COLUMN");
                        }
                        RelationalBGP.this.log("OPTCHOSENEXPR=" + string8 + "  OPTCHOSENEXPRTYPE=" + n7);
                        bl3 = false;
                    } else {
                        RelationalBGP.this.log("EXPR=" + string13 + "  OPTCHOSENEXP=" + string8);
                        if (!string13.equals(string8)) {
                            if (n7 == this.TEMPLATE && n9 == this.TEMPLATE || n7 == this.COLUMN && n9 == this.COLUMN) {
                                for (int i = 0; i < arrayList.size(); ++i) {
                                    string10 = (String)arrayList.get(i);
                                    String string17 = string16 + "." + (String)arrayList3.get(i);
                                    if (bl2) {
                                        String string18 = (String)var21_30 + RelationalBGP.COND_CONNECTOR + RelationalBGP.SDO_EQUAL_BEG + string10 + "," + string17 + RelationalBGP.SDO_EQUAL_END;
                                        continue;
                                    }
                                    String string19 = (String)var21_30 + RelationalBGP.COND_CONNECTOR + string10 + "=" + string17;
                                }
                            } else if (n7 == this.CONSTANT && n9 == this.CONSTANT) {
                                String string20 = (String)var21_30 + " AND 1=0";
                            } else {
                                RelationalBGP.this.log("ERROR: There is not any of TEMPLATE-TEMPLATE, CONSTANT-CONSTANT or COLUMN-COLUMN");
                                RelationalBGP.this.log("ERROR: ");
                            }
                            RelationalBGP.this.log("OPTEXPRCOND=" + (String)var21_30);
                        }
                    }
                    if (!bl) continue;
                    string6 = string13;
                    n3 = n9;
                    bl = false;
                    RelationalBGP.this.log("NOTOPTCHOSENEXPR=" + string6 + "  NOTOPTCHOSENEXPRTYPE=" + n3);
                }
                string4 = string4 + (String)var21_30;
                if (!var21_30.equals("")) {
                    string4 = string4 + "\n";
                }
                RelationalBGP.this.log("ALLOPTEXPR=" + string4);
            }
            string3 = string4 + string5;
            if (!string3.equals("")) {
                string3 = string3 + "\n";
            }
            RelationalBGP.this.log("[ENTER_HERE]=4");
            RelationalBGP.this.log("OPTOUTNATCOND=" + string3);
            RelationalBGP.this.log("<==ENTER: noVa_compose_multiOccVar_joinCond_for_UArow()");
            return string3;
        }

        public COptNatCondition get_optOutNatCond_ForVar(String string, Set<String> set) throws RDFException, SQLException {
            boolean bl;
            COptNatCondition cOptNatCondition = new COptNatCondition();
            String string2 = "";
            String string3 = "";
            String string4 = "";
            boolean bl2 = true;
            HashSet<String> hashSet = new HashSet<String>();
            RelationalBGP.this.log("[get_optOutNatCond_ForVar] var=" + string + "  MCSRAliasSet:" + set);
            if (set.size() < 2) {
                throw new RDFException("Attempt to compute join conditions having only one MCSR");
            }
            if (RelationalBGP.this.Geometry_VarSRID.containsKey(string)) {
                RelationalBGP.this.log("BEFORE CLEANUP: structure for this var=" + string + " is:" + this.toString());
                this.removeInvalidTFTsForGeometryVar();
                RelationalBGP.this.log("AFTER CLEANUP: structure for this var=" + string + " is:" + this.toString());
            }
            Object object = this.natVarCountForAlias_for_TFTidx.keySet().iterator();
            while (object.hasNext()) {
                int n = object.next();
                RelationalBGP.this.log("[get_optOutNatCond_ForVar] TFTidx=" + n);
                bl = true;
                String string5 = "";
                ArrayList<String> arrayList = new ArrayList<String>();
                Map map = this.natVarCountForAlias_for_TFTidx.get(n);
                for (String string6 : map.keySet()) {
                    int n2;
                    RelationalBGP.this.log("[get_optOutNatCond_ForVar]     CSRAlias=" + string6);
                    String string7 = RelationalBGP.this.get_MCSRAlias_for_CSRAlias(string6);
                    RelationalBGP.this.log("[get_optOutNatCond_ForVar]    MCSRAlias=" + string7);
                    int n3 = (Integer)map.get(string6);
                    Set set2 = this.TFTidxSet_for_CSRAlias.get(string6);
                    RelationalBGP.this.log("TFTIDXSET.SIZE()=" + set2.size() + " : It has to be 1: TFTidxSet=" + set2);
                    if (set2.size() != 1 && !RelationalBGP.this.Geometry_VarSRID.containsKey(string)) continue;
                    hashSet.add(string6);
                    if (bl) {
                        if (!bl2) {
                            string3 = string3 + RelationalBGP.COND_CONNECTOR + string4 + "=" + string7 + "." + string;
                        }
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(string7 + "." + string + RelationalBGP.NATIVE_SUFFIX + n2);
                        }
                        bl = false;
                        RelationalBGP.this.log("optChosenExpr: " + arrayList);
                    } else {
                        for (n2 = 0; n2 < n3; ++n2) {
                            RelationalBGP.this.log("[get_optOutNatCond_ForVar]          count=" + n2);
                            String string8 = (String)arrayList.get(n2);
                            RelationalBGP.this.log("[get_optOutNatCond_ForVar]          optChosenExpr_elem=" + string8);
                            String string9 = string7 + "." + string + RelationalBGP.NATIVE_SUFFIX + n2;
                            if (RelationalBGP.this.Geometry_VarSRID.containsKey(string)) {
                                int n4 = 131072;
                                int n5 = n4 + 1;
                                if (n5 == n4) {
                                    RelExpr relExpr = RelationalBGP.this.buildUnindexedEqualityGeomExpression(string, string);
                                    boolean bl3 = ((RelationalBGP)RelationalBGP.this).ctx.strictOGC;
                                    ((RelationalBGP)RelationalBGP.this).ctx.strictOGC = false;
                                    NatVarOpt_Info natVarOpt_Info = new NatVarOpt_Info();
                                    natVarOpt_Info.set(string, this);
                                    String string10 = RelationalBGP.this.genFilter_v3(null, "OUTER_LEVEL", null, -1, null, null, natVarOpt_Info, relExpr, null, null, null);
                                    ((RelationalBGP)RelationalBGP.this).ctx.strictOGC = bl3;
                                    continue;
                                }
                                string5 = string5 + " AND SDO_RELATE(" + string8 + "," + string9 + ", 'mask=100010001') = 'TRUE'";
                                continue;
                            }
                            string5 = string5 + RelationalBGP.COND_CONNECTOR + string8 + "=" + string9;
                        }
                    }
                    if (!bl2) continue;
                    string4 = string7 + "." + string;
                    bl2 = false;
                    RelationalBGP.this.log("notOptChosenExpr: " + string4);
                }
                string2 = string2 + string5;
            }
            if (!RelationalBGP.this.Geometry_VarSRID.containsKey(string)) {
                Iterator<String> iterator = set.iterator();
                bl = false;
                if (string4.equals("")) {
                    bl = true;
                }
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (bl) {
                        string4 = (String)object + "." + string;
                        bl = false;
                        continue;
                    }
                    if (hashSet.contains(object)) continue;
                    string3 = string3 + RelationalBGP.COND_CONNECTOR + string4 + "=" + (String)object + "." + string;
                }
                cOptNatCondition.optNatCondition = string2 + string3;
            } else {
                RelationalBGP.this.log("non-native (outer) condition generation makes NO SENSE for geometry var: " + string);
                cOptNatCondition.optNatCondition = string2;
            }
            cOptNatCondition.notOptChosenExpr = string4;
            RelationalBGP.this.log("get_optOutNatCond_ForVar returning: optOutNatCond.optNatCondition:" + cOptNatCondition.optNatCondition + "***");
            return cOptNatCondition;
        }

        public String get_natVarListStr_ForVar(String string, String string2, List<String> list, Set<String> set) throws RDFException {
            RelationalBGP.this.log("=>get_natVarListStr_ForVar: var=" + string + " : CSRAlias=" + string2 + " : colList=" + list);
            String string3 = "";
            String string4 = null;
            if (this.natVarCountForAlias_for_TFTidx.keySet().size() > 1) {
                if (!set.contains(string)) {
                    return string3;
                }
                string4 = (String)RelationalBGP.this.DatatypeFam_for_var.get(string);
                RelationalBGP.this.log("varsNeededInOuterCond_geo contains var=" + string + ": look for TFT with datatypeFam=" + string4);
            }
            for (int n : this.natVarCountForAlias_for_TFTidx.keySet()) {
                TFTinfo tFTinfo = (TFTinfo)RelationalBGP.this.TFTinfoGlobalList.get(n);
                String string5 = tFTinfo.datatype_family;
                if (!(string4 == null || string5 != null && string5.equals(string4))) {
                    RelationalBGP.this.log("not the right TFT: datatype_family=" + string5 + " - looking for " + string4);
                    continue;
                }
                RelationalBGP.this.log("for: TFTidx=" + n + ": TYFAM_TEMPL=" + (String)RelationalBGP.this.TFTglobalList.get(n));
                HashMap<String, Integer> hashMap = this.natVarCountForAlias_for_TFTidx.get(n);
                RelationalBGP.this.log("NATVARNO_FOR_ALIAS.SIZE()=" + hashMap.size());
                RelationalBGP.this.log("NATVARNO_FOR_ALIAS.CONTAINSKEY(" + string2 + ")=" + hashMap.containsKey(string2));
                if (hashMap.containsKey(string2)) {
                    RelationalBGP.this.log("COLLIST.SIZE()=" + list.size() + "=" + hashMap.get(string2) + "=NATVARNO_FOR_ALIAS.GET(" + string2 + ").INTVALUE()");
                    if (list.size() == hashMap.get(string2).intValue()) {
                        HashSet<Integer> hashSet = this.TFTidxSet_for_CSRAlias.get(string2);
                        RelationalBGP.this.log("TFTIDXSET.SIZE()=" + hashSet.size() + " : It has to be 1 OR var=" + string + " MUST BE IN varsNeededInOuterCond_geo: " + set);
                        if (hashSet.size() == 1 || set.contains(string)) {
                            if (set.contains(string) && hashSet.size() != 1) {
                                RelationalBGP.this.log("ERROR: geometry variable " + string + " has more than one (" + hashSet.size() + ") TFTidx");
                            }
                            for (int i = 0; i < list.size(); ++i) {
                                string3 = string3 + ", " + list.get(i) + RelationalBGP.ALIAS_SEP + string + RelationalBGP.NATIVE_SUFFIX + i;
                            }
                            RelationalBGP.this.log("NATVARLIST=" + string3);
                        }
                    } else {
                        throw new RDFException("ERROR: colList size does NOT coincide with natVarNo_for_alias.get(CSRAlias) : colList=" + list + " : natVarNo_for_alias.get(" + string2 + ")=" + hashMap.get(string2));
                    }
                }
                RelationalBGP.this.log("break from the for loop: we have created the natVarList based on a single TFTidx=" + n);
                break;
            }
            return string3;
        }

        public boolean containsTFTidx(int n) {
            return this.natVarCountForAlias_for_TFTidx.containsKey(n);
        }

        public boolean containsPos(Integer n) {
            return this.TFTidx_occInfoSet_pairs_for_pos.containsKey(n);
        }

        public HashSet<String> get_optOccInfoSet_inUArow(Integer n) {
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<Integer, HashSet<String>> hashMap = this.TFTidx_occInfoSet_pairs_for_pos.get(n);
            if (hashMap.size() == 1) {
                for (int n2 : hashMap.keySet()) {
                    hashSet = hashMap.get(n2);
                }
                return hashSet;
            }
            return null;
        }

        public void set(int n, String string, String string2, int n2) {
            Cloneable cloneable;
            if (string.equals("subject:0")) {
                this.subjectPos = "subject:0";
                this.sTFT_idx = new Integer(n);
                RelationalBGP.this.log("var occurs as subject in this CSR (alias=" + string2 + "): sTFT_idx for this current Tmap is: " + this.sTFT_idx);
            }
            RelationalBGP.this.log("noVa trace: natVarCountForAlias_for_TFTidx data structure: adding (alias=" + string2 + ", dbColCnt=" + n2 + ") to occInfoSet HashMap of TFTidx=" + n + ": corr to TFT=" + (String)RelationalBGP.this.TFTglobalList.get(n));
            if (!this.containsTFTidx(n)) {
                cloneable = new HashMap<String, Integer>();
                ((HashMap)cloneable).put(string2, new Integer(n2));
                this.natVarCountForAlias_for_TFTidx.put(n, (HashMap<String, Integer>)cloneable);
            } else {
                cloneable = this.natVarCountForAlias_for_TFTidx.get(n);
                ((HashMap)cloneable).put(string2, new Integer(n2));
            }
            RelationalBGP.this.log("noVa trace: TFTidxSet_for_CSRAlias data structure: adding (TFTidx=" + n + ") corr to TFT=" + (String)RelationalBGP.this.TFTglobalList.get(n));
            if (!this.TFTidxSet_for_CSRAlias.containsKey(string2)) {
                cloneable = new HashSet();
                ((HashSet)cloneable).add(n);
                this.TFTidxSet_for_CSRAlias.put(string2, (HashSet<Integer>)cloneable);
            } else {
                cloneable = this.TFTidxSet_for_CSRAlias.get(string2);
                ((HashSet)cloneable).add(n);
            }
        }

        public void set(Integer n, int n2, String string) {
            RelationalBGP.this.log("noVa trace: TFTidx_occInfoSet_pairs_for_pos data structure: adding OccInfo=" + string + " to occInfoSet for TFTidx=" + n2 + ": corr to TFT=" + (String)RelationalBGP.this.TFTglobalList.get(n2));
            if (!this.containsPos(n)) {
                HashMap hashMap = new HashMap();
                HashSet<String> hashSet = new HashSet<String>();
                if (!this.subjectPos.equals("")) {
                    if (n2 == this.sTFT_idx) {
                        hashSet.add(this.subjectPos);
                    } else {
                        HashSet<String> hashSet2 = new HashSet<String>();
                        hashSet2.add(this.subjectPos);
                        hashMap.put(this.sTFT_idx, hashSet2);
                    }
                }
                hashSet.add(string);
                hashMap.put(n2, hashSet);
                this.TFTidx_occInfoSet_pairs_for_pos.put(n, hashMap);
            } else {
                HashMap<Integer, HashSet<String>> hashMap = this.TFTidx_occInfoSet_pairs_for_pos.get(n);
                if (!hashMap.containsKey(n2)) {
                    HashSet<String> hashSet = new HashSet<String>();
                    hashSet.add(string);
                    hashMap.put(n2, hashSet);
                } else {
                    HashSet<String> hashSet = hashMap.get(n2);
                    hashSet.add(string);
                }
            }
        }

        private int f(int n, int n2, int n3, int n4) {
            return n - n2 + n2 + n3 * n4;
        }

        private void add(Integer n, int n2, int n3, int n4) {
            HashMap<Integer, HashSet<String>> hashMap = this.TFTidx_occInfoSet_pairs_for_pos.get(n);
            HashMap hashMap2 = new HashMap();
            Object object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                int n5 = object.next();
                HashSet<String> hashSet = hashMap.get(n5);
                HashSet<String> hashSet2 = new HashSet<String>();
                hashSet2.addAll(hashSet);
                hashMap2.put(n5, hashSet2);
            }
            object = new Integer(this.f(n, n2, n3, n4));
            RelationalBGP.this.log("add(): pos2=" + object + "(calculated from: pos=" + n + " UAstartPos=" + n2 + " k=" + n3 + " rowBlock_size=" + n4);
            this.TFTidx_occInfoSet_pairs_for_pos.put((Integer)object, hashMap2);
            RelationalBGP.this.log("add(): added to TFTidx_occInfoSet_pairs_for_pos: key=" + object + " occInfoSet=" + hashMap2);
        }

        public void multiply(int n, int n2, int n3) {
            RelationalBGP.this.log("multiply(): INPUT => UAstartPos=" + n + " rowBlock_size=" + n2 + " RRrow_match_count=" + n3);
            Set<Integer> set = this.TFTidx_occInfoSet_pairs_for_pos.keySet();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(set);
            Collections.sort(arrayList);
            RelationalBGP.this.log("multiply(): posArray: " + arrayList);
            for (int i = 1; i < n3; ++i) {
                for (int j = n + 0; j < arrayList.size(); ++j) {
                    this.add(arrayList.get(j), n, i, n2);
                }
            }
        }

        public void resetLocalStructure() {
            this.subjectPos = "";
            this.sTFT_idx = new Integer(-1);
            this.TFTidx_occInfoSet_pairs_for_pos = new HashMap();
        }

        public String toString() {
            Object object;
            Object object2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n  natVarCountForAlias_for_TFTidx [size=" + this.natVarCountForAlias_for_TFTidx.size() + "]:");
            if (!this.subjectPos.equals("")) {
                stringBuffer.append("\n    " + this.subjectPos + "  sTFT_idx=" + this.sTFT_idx);
            }
            Object object3 = this.natVarCountForAlias_for_TFTidx.keySet().iterator();
            while (object3.hasNext()) {
                int n = object3.next();
                object2 = (String)RelationalBGP.this.TFTglobalList.get(n);
                object = "[" + n + ": " + (String)object2 + "]";
                stringBuffer.append("\n    " + (String)object + "=" + this.natVarCountForAlias_for_TFTidx.get(n).toString());
            }
            stringBuffer.append("\n  TFTidxSet_for_CSRAlias [size=" + this.TFTidxSet_for_CSRAlias.size() + "]:");
            for (String string : this.TFTidxSet_for_CSRAlias.keySet()) {
                stringBuffer.append("\n    " + string + "=" + this.TFTidxSet_for_CSRAlias.get(string).toString());
            }
            stringBuffer.append("\n  TFTidx_occInfoSet_pairs_for_pos [size=" + this.TFTidx_occInfoSet_pairs_for_pos.size() + "]:");
            object3 = new ArrayList<Integer>(this.TFTidx_occInfoSet_pairs_for_pos.keySet());
            Collections.sort(object3);
            Iterator iterator = ((ArrayList)object3).iterator();
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                object = this.TFTidx_occInfoSet_pairs_for_pos.get(object2);
                stringBuffer.append("\n    pos(UArowNUM)=" + object2);
                Iterator iterator2 = ((HashMap)object).keySet().iterator();
                while (iterator2.hasNext()) {
                    int n = (Integer)iterator2.next();
                    String string = (String)RelationalBGP.this.TFTglobalList.get(n);
                    String string2 = "[" + n + ": " + string + "]";
                    stringBuffer.append("\n        " + string2);
                    stringBuffer.append("=" + ((HashSet)((HashMap)object).get(n)).toString());
                }
            }
            return stringBuffer.toString();
        }
    }

    private class COptNatCondition {
        public String notOptChosenExpr = "";
        public String optNatCondition = "";

        public String toString() {
            return "notOptChosenExpr=" + this.notOptChosenExpr + "\n   optNatCondition=" + this.optNatCondition + "\n";
        }
    }

    private class UArowNatSelectInfo {
        public String sqlSubq;
        public String sqlSubq_SELECT_str;
        public String sqlSubq_FROM_str;
        public String sqlSubq_WHERE_str;
        public Integer selListEndpos;
        public Map<String, List<String>> colList_for_var;

        public UArowNatSelectInfo() {
            this.sqlSubq = "";
            this.sqlSubq_SELECT_str = "";
            this.sqlSubq_FROM_str = "";
            this.sqlSubq_WHERE_str = "";
            this.selListEndpos = new Integer(-1);
            this.colList_for_var = new HashMap<String, List<String>>();
        }

        public UArowNatSelectInfo(UArowNatSelectInfo uArowNatSelectInfo) {
            this.sqlSubq = uArowNatSelectInfo.sqlSubq;
            this.sqlSubq_SELECT_str = uArowNatSelectInfo.sqlSubq_SELECT_str;
            this.sqlSubq_FROM_str = uArowNatSelectInfo.sqlSubq_FROM_str;
            this.sqlSubq_WHERE_str = uArowNatSelectInfo.sqlSubq_WHERE_str;
            this.selListEndpos = uArowNatSelectInfo.selListEndpos;
            this.colList_for_var = new HashMap<String, List<String>>();
            for (String string : uArowNatSelectInfo.colList_for_var.keySet()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                List<String> list = uArowNatSelectInfo.colList_for_var.get(string);
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(list.get(i));
                }
                this.colList_for_var.put(string, arrayList);
            }
        }

        public UArowNatSelectInfo(UArowNatSelectInfo uArowNatSelectInfo, String string, String string2, String string3, String string4) {
            this(uArowNatSelectInfo);
            this.colList_for_var = this.getColList_for_var_instance(string, string2, string3, string4);
        }

        public boolean add_ColList_for_var(String string, List<String> list) {
            if (!this.colList_for_var.containsKey(string)) {
                this.colList_for_var.put(string, list);
                return true;
            }
            RelationalBGP.this.log("UArowNatSelectInfo.add_collist_for_var: colList already exists for var=" + string + " : colList=" + this.colList_for_var.get(string) + " | colList param :" + list);
            return false;
        }

        public void addVarInfoFrom(UArowNatSelectInfo uArowNatSelectInfo, String string, String string2, String string3, String string4) {
            for (String string5 : uArowNatSelectInfo.colList_for_var.keySet()) {
                if (this.colList_for_var.containsKey(string5)) continue;
                List<String> list = uArowNatSelectInfo.colList_for_var.get(string5);
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                for (String string6 : list) {
                    String string7 = string6.replaceAll(string, string2).replaceAll(string3, string4);
                    arrayList.add(string7);
                }
                this.colList_for_var.put(string5, arrayList);
            }
        }

        public HashMap<String, List<String>> getColList_for_var_instance(String string, String string2, String string3, String string4) {
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            for (String string5 : this.colList_for_var.keySet()) {
                List<String> list = this.colList_for_var.get(string5);
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                hashMap.put(string5, arrayList);
                for (String string6 : list) {
                    String string7 = string6.replaceAll(string, string2).replaceAll(string3, string4);
                    arrayList.add(string7);
                }
            }
            return hashMap;
        }

        public String toString() {
            return "sqlSubq=" + this.sqlSubq + " : selListEndpos=" + this.selListEndpos + " : colList_for_var=" + this.colList_for_var + "\nsqlSubq_SELECT_str=" + this.sqlSubq_SELECT_str + "\nsqlSubq_FROM_str=" + this.sqlSubq_FROM_str + "\nsqlSubq_WHERE_str=" + this.sqlSubq_WHERE_str + "\ncolList_for_var: " + this.colList_for_var;
        }
    }

    private class RelExpr {
        public ASTTripleAtom L_atom;
        public String compOperator;
        public ASTTripleAtom R_atom;
        public ASTTripleAtom[] R_atoms;
        public Filter filterExprTree;
        public boolean eqBasedComp;
        public long RelExprFlags = 0L;
        public static final long RExF_NATIVE = 1L;
        public static final long RExF_GEOMETRY = 2L;
        public String procAtLevel;
        public static final String RExL_TPAT = "TPAT_LEVEL";
        public static final String RExL_UAROW = "UAROW_LEVEL";
        public static final String RExL_MCSR = "MCSR_LEVEL";
        public static final String RExL_OUTER = "OUTER_LEVEL";
        public ASTTripleAtom MASK_atom;
        private int notNegatedFilterLevel;

        public void InvertRelExpr() {
            ASTTripleAtom aSTTripleAtom = this.L_atom;
            this.L_atom = this.R_atoms[0];
            this.R_atoms[0] = aSTTripleAtom;
            this.R_atom = this.R_atoms[0];
            if (this.compOperator.equals("<")) {
                this.compOperator = ">";
            } else if (this.compOperator.equals(">")) {
                this.compOperator = "<";
            } else if (this.compOperator.equals("<=")) {
                this.compOperator = ">=";
            } else if (this.compOperator.equals(">=")) {
                this.compOperator = "<=";
            }
        }

        public RelExpr(ASTTripleAtom aSTTripleAtom, String string, ASTTripleAtom[] aSTTripleAtomArray, Filter filter, long l) {
            this.L_atom = aSTTripleAtom;
            this.compOperator = string;
            this.R_atom = aSTTripleAtomArray != null ? aSTTripleAtomArray[0] : null;
            this.R_atoms = aSTTripleAtomArray;
            this.filterExprTree = filter;
            this.eqBasedComp = string.equals("=") || string.equals("!=") || string.equals("SAMETERM") || string.equals("DIFFTERM") ? true : (string.equals(">") || string.equals(">=") || string.equals("<") || string.equals("<=") ? false : false);
            this.RelExprFlags = l;
            this.procAtLevel = null;
            this.MASK_atom = null;
            this.notNegatedFilterLevel = 0;
        }

        public RelExpr(ASTTripleAtom aSTTripleAtom, String string, ASTTripleAtom[] aSTTripleAtomArray, Filter filter, long l, ASTTripleAtom aSTTripleAtom2) {
            this(aSTTripleAtom, string, aSTTripleAtomArray, filter, l);
            this.procAtLevel = null;
            this.MASK_atom = aSTTripleAtom2;
        }

        public String getMask() {
            return this.MASK_atom == null ? "" : this.MASK_atom.name;
        }

        public boolean isNegated() {
            return this.notNegatedFilterLevel % 2 == 1;
        }

        public void setNotNegatedFilterLevel(int n) {
            this.notNegatedFilterLevel = n;
        }

        public int getNotNegatedFilterLevel() {
            return this.notNegatedFilterLevel;
        }

        public String toString() {
            String string = "RelExpr [RelExprFlags=" + this.RelExprFlags + "]: filterExprTree =>\n" + this.filterExprTree.toString() + (this.isNegated() ? "\n negation is ON" : "\n negation is OFF") + (this.compOperator != null ? "\n " + this.compOperator : "") + (this.L_atom != null ? "\n  " + this.L_atom.toString() : "") + (this.R_atom != null ? "\n  " + this.R_atom.toString() : "") + "\n  procAtLevel=" + this.procAtLevel + (this.MASK_atom != null ? "\n  " + this.MASK_atom.toString() : "");
            string = string + "\nR_atoms array: ";
            if (this.R_atoms != null) {
                string = string + "length=" + this.R_atoms.length;
                for (int i = 0; i < this.R_atoms.length; ++i) {
                    string = string + "\n{" + (this.R_atoms[i] != null ? this.R_atoms[i].toString() : "NULL") + "}";
                }
            }
            return string;
        }

        public String getRelExprString() {
            return this.L_atom.name + RelationalBGP.BASE_PREFIX_COLNAME_SEP + this.compOperator + RelationalBGP.BASE_PREFIX_COLNAME_SEP + this.R_atom.name;
        }
    }

    private class MCSR {
        private int id;
        private List<String> CSRKeyList;
        private String mcsrKey;
        public int po_count;
        private Map<String, Integer> CSRIdx_map;
        private ArrayList<Map<String, String>> vTaMArray;
        private List<Map<String, String>> vTaMArray_snapshot = null;
        private Map<String, String> expr_for_acr;
        private Map<String, ACRinfo> ACRinfo_for_acr;
        private Set<String> alreadyJoindedCSRs = null;
        private List<List<String>> consolidatedPExprArrays = null;
        private List<List<String>> consolidatedOExprArrays = null;
        private List<List<String>> consolidatedClobExprArrays = null;
        private List<UArowNatSelectInfo> UArowNatSelectInfoArray = null;
        private int lastInvalidUArowNum = -1;
        private int lastValidUArowNum = -1;
        private static final String MCSR_ALIAS_PREFIX = "M";
        private Set<String> varsToProject = null;
        private Map<String, Set<String>> CSRAliasSet_for_var = null;

        MCSR(int n) {
            this.id = n;
            this.CSRKeyList = new ArrayList<String>();
            this.mcsrKey = null;
            this.po_count = 0;
            this.CSRIdx_map = new HashMap<String, Integer>();
            this.vTaMArray = new ArrayList();
            this.expr_for_acr = new HashMap<String, String>();
            this.ACRinfo_for_acr = new HashMap<String, ACRinfo>();
            this.varsToProject = new LinkedHashSet<String>();
            this.CSRAliasSet_for_var = new HashMap<String, Set<String>>();
            this.alreadyJoindedCSRs = new HashSet<String>();
        }

        MCSR(int n, Collection<String> collection) {
            this(n);
            for (String string : collection) {
                this.addCSRKey(string);
            }
        }

        public boolean addCSRKey(String string) {
            RelationalBGP.this.log("[MCSR addCSRKey] csrKey: " + string);
            this.mcsrKey = null;
            boolean bl = this.CSRKeyList.add(string);
            if (bl) {
                RelationalBGP.this.log("[MCSR addCSRKey] csrKey added: " + string);
                CSRinfo cSRinfo = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(string);
                cSRinfo.po_idx_base = this.po_count;
                this.po_count += cSRinfo.getPOCount();
                this.CSRIdx_map.put(string, this.CSRKeyList.size() - 1);
                cSRinfo.mcsrElem = this;
                cSRinfo.computeVarsToProject(this.varsToProject);
                RelationalBGP.this.log("[MCSR addCSRKey] BEFORE adding CSRs set. varsToProject: " + this.varsToProject);
                this.varsToProject.addAll(cSRinfo.getVarsToProject());
                RelationalBGP.this.log("[MCSR addCSRKey]  AFTER adding CSRs set. varsToProject: " + this.varsToProject);
                RelationalBGP.this.log("[MCSR addCSRKey] BEFORE extending the CSRAliasSet_for_var: " + this.CSRAliasSet_for_var);
                this.extendCSRSAliaset_for_var(cSRinfo);
                RelationalBGP.this.log("[MCSR addCSRKey]  AFTER extending the CSRAliasSet_for_var" + this.CSRAliasSet_for_var);
            }
            return bl;
        }

        public void addAllCSRKeys(Collection<String> collection) {
            this.mcsrKey = null;
            for (String string : collection) {
                this.addCSRKey(string);
            }
        }

        public List<String> getCSRKeyList() {
            return this.CSRKeyList;
        }

        public String getMCSRKey() {
            if (this.mcsrKey == null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (String string : this.CSRKeyList) {
                    stringBuffer.append(string + "*");
                }
                this.mcsrKey = stringBuffer.toString();
            }
            return this.mcsrKey;
        }

        public int getMCSRid() {
            return this.id;
        }

        public String getMCSRAlias() {
            if (this.CSRKeyList.size() == 1) {
                return ((CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(this.CSRKeyList.get(0))).getCSRAlias();
            }
            return MCSR_ALIAS_PREFIX + this.id;
        }

        public Set<String> getVarSet() {
            return this.CSRAliasSet_for_var.keySet();
        }

        private List<String> getMCSRvarsList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.CSRKeyList) {
                CSRinfo cSRinfo = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(string);
                String string2 = cSRinfo.getCSRAlias();
                for (String string3 : (List)RelationalBGP.this.varsList_for_CSRAlias.get(string2)) {
                    if (arrayList.contains(string3)) continue;
                    arrayList.add(string3);
                }
            }
            return arrayList;
        }

        public void extendCSRSAliaset_for_var(CSRinfo cSRinfo) {
            RelationalBGP.this.log("[MCSR extendCSRSet_for_var] CSRalias=" + cSRinfo.getCSRAlias());
            for (String string : cSRinfo.get_varsList()) {
                if (!this.CSRAliasSet_for_var.containsKey(string)) {
                    this.CSRAliasSet_for_var.put(string, new LinkedHashSet());
                }
                Set<String> set = this.CSRAliasSet_for_var.get(string);
                set.add(cSRinfo.getCSRAlias());
            }
        }

        public Set<String> getCSRAliasSet_for_var(String string) {
            return this.CSRAliasSet_for_var.get(string);
        }

        public void setPairOfCSRsAlreadyJoined(String string, String string2) {
            this.alreadyJoindedCSRs.add(string + "+" + string2);
        }

        public boolean isPairOfCSRsAlreadyJoined(String string, String string2) {
            String string3 = string + "+" + string2;
            if (this.alreadyJoindedCSRs.contains(string3)) {
                return true;
            }
            string3 = string2 + "+" + string;
            return this.alreadyJoindedCSRs.contains(string3);
        }

        public Set<Integer> getFirstTFTIdxSet(int n, String string) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            RelationalBGP.this.log("[MCSR getFirstTFTIdxSet] ENTERING UArowNum_for_MCSR=" + n + " var=" + string);
            Set set = ((Map)RelationalBGP.this.occPosSet_for_CSRAlias_for_var.get(string)).keySet();
            for (String string2 : set) {
                RelationalBGP.this.log("[MCSR getFirstTFTIdxSet]    CSRAlias=" + string2);
                CSRinfo cSRinfo = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRAlias.get(string2);
                int n2 = n % cSRinfo.getUArowsCount();
                RelationalBGP.this.log("[MCSR getFirstTFTIdxSet]    UArowNum_for_CSR=" + n2);
                Integer n3 = cSRinfo.getFirstTFTIdx(n2, string);
                RelationalBGP.this.log("[MCSR getFirstTFTIdxSet]    TFTIdx=" + n3);
                hashSet.add(n3);
            }
            RelationalBGP.this.log("[MCSR getFirstTFTIdxSet] RETURNING TFTIdxSet=" + hashSet);
            return hashSet;
        }

        public void consolidateCSRs() {
            RelationalBGP.this.log("[MCSR consolidateCSRs] ENTERING");
            int n = this.getUArowsCount();
            this.consolidatedPExprArrays = new ArrayList<List<String>>();
            this.consolidatedOExprArrays = new ArrayList<List<String>>();
            this.consolidatedClobExprArrays = new ArrayList<List<String>>();
            String string = "";
            for (String string2 : this.CSRKeyList) {
                RelationalBGP.this.log("[MCSR consolidateCSRs] csrKey: " + string2);
                CSRinfo cSRinfo = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(string2);
                int n2 = cSRinfo.getPOCount();
                RelationalBGP.this.log("[MCSR consolidateCSRs] poCount: " + n2);
                for (int i = 0; i < n2; ++i) {
                    RelationalBGP.this.log("[MCSR consolidateCSRs]     po_idx: " + i);
                    if (i > this.consolidatedPExprArrays.size() - 1) {
                        this.consolidatedPExprArrays.add(i, new ArrayList(n));
                        this.consolidatedOExprArrays.add(i, new ArrayList(n));
                        this.consolidatedClobExprArrays.add(i, new ArrayList(n));
                    }
                    for (int j = 0; j < n; ++j) {
                        int n3 = j % cSRinfo.getUArowsCount();
                        RelationalBGP.this.log("[MCSR consolidateCSRs]         UArowIdx: " + j + (n3 < j ? "  UArowIdx_for_CSR" + n3 : ""));
                        String string3 = string = n3 < j ? "/**/" : "";
                        if (j > this.consolidatedPExprArrays.get(i).size() - 1) {
                            this.consolidatedPExprArrays.get(i).add(j, "");
                            this.consolidatedOExprArrays.get(i).add(j, "");
                            this.consolidatedClobExprArrays.get(i).add(j, "");
                        }
                        String string4 = this.consolidatedPExprArrays.get(i).get(j);
                        String string5 = this.consolidatedOExprArrays.get(i).get(j);
                        String string6 = this.consolidatedClobExprArrays.get(i).get(j);
                        RelationalBGP.this.log("[MCSR consolidateCSRs]         prevPExprExpr: " + string4);
                        RelationalBGP.this.log("[MCSR consolidateCSRs]         prevOExprExpr: " + string5);
                        RelationalBGP.this.log("[MCSR consolidateCSRs]      prevClobExprExpr: " + string6);
                        String string7 = string + cSRinfo.pExprArrays.get(i).get(n3);
                        String string8 = string4 + ", " + string7;
                        this.consolidatedPExprArrays.get(i).set(j, string8);
                        RelationalBGP.this.log("[MCSR consolidateCSRs]          newPExprExpr: " + string8);
                        String string9 = string + cSRinfo.oExprArrays.get(i).get(n3);
                        String string10 = string5 + ", " + string9;
                        this.consolidatedOExprArrays.get(i).set(j, string10);
                        RelationalBGP.this.log("[MCSR consolidateCSRs]          newOExprExpr: " + string10);
                        String string11 = string + cSRinfo.clobExprArrays.get(i).get(n3);
                        String string12 = string6 + ", " + string11;
                        this.consolidatedClobExprArrays.get(i).set(j, string12);
                        RelationalBGP.this.log("[MCSR consolidateCSRs]       newClobExprExpr: " + string12);
                    }
                }
            }
        }

        public List<List<String>> getPExprArrays() {
            return this.consolidatedPExprArrays;
        }

        public List<List<String>> getOExprArrays() {
            return this.consolidatedOExprArrays;
        }

        public List<List<String>> getClobExprArrays() {
            return this.consolidatedClobExprArrays;
        }

        public List<String> getFromArray() {
            int n = this.getUArowsCount();
            RelationalBGP.this.log("[MCSR getFromArray] ENTERING: UArowsCount=" + n);
            RelationalBGP.this.log("[MCSR getFromArray] computing the common from clause for CSRs");
            ArrayList<String> arrayList = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(i, "");
            }
            for (String string : this.CSRKeyList) {
                RelationalBGP.this.log("[MCSR getFromArray]  CSRkey: " + string);
                CSRinfo cSRinfo = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(string);
                RelationalBGP.this.log("fromArray for this CSR [size=" + cSRinfo.fromArray.size() + "]: " + cSRinfo.fromArray);
                RelationalBGP.this.log("[MCSR getFromArray]  CSRelem.CSR_TmapSet.size(): " + cSRinfo.CSR_TmapSet.size());
                Iterator<String> iterator = cSRinfo.CSR_TmapSet.iterator();
                if (!iterator.hasNext()) continue;
                for (int i = 0; i < n; ++i) {
                    int n2 = i % cSRinfo.fromArray.size();
                    RelationalBGP.this.log("[MCSR getFromArray]     -     UArowIdx_for_MCSR: " + i + " \t  UArowIdx_for_MCSR%CSRelem.fromArray.size() = " + i + "%" + cSRinfo.fromArray.size() + " = " + n2);
                    if (!iterator.hasNext()) {
                        iterator = cSRinfo.CSR_TmapSet.iterator();
                        RelationalBGP.this.log("[MCSR getFromArray]     -  ... restarting the TmapSet iterator");
                    }
                    String string2 = iterator.next();
                    RelationalBGP.this.log("[MCSR getFromArray]        -         Tmap: " + string2);
                    String string3 = ", " + cSRinfo.get_fromLtabPlusAlias_for_Tmap().get(string2);
                    RelationalBGP.this.log("[MCSR getFromArray]        -     fromExpr: " + string3);
                    String string4 = cSRinfo.sAliasArray.get(n2);
                    String string5 = cSRinfo.getCSRAlias();
                    if (!string4.equals(string5)) {
                        string3 = "";
                    }
                    String string6 = (String)arrayList.get(i);
                    RelationalBGP.this.log("[MCSR getFromArray]        - prevFromExpr: " + string6);
                    String string7 = string6.equals("") ? string3 : string6 + string3;
                    RelationalBGP.this.log("[MCSR getFromArray]        -  newFromExpr: " + string7);
                    arrayList.set(i, string7);
                }
            }
            return arrayList;
        }

        public List<String> getCondArray() {
            int n = this.getUArowsCount();
            ArrayList<String> arrayList = new ArrayList<String>(n);
            for (String string : this.CSRKeyList) {
                for (int i = 0; i < n; ++i) {
                    if (arrayList.size() == i) {
                        arrayList.add(i, "");
                    }
                    CSRinfo cSRinfo = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(string);
                    int n2 = i % cSRinfo.getUArowsCount();
                    String string2 = (String)arrayList.get(i);
                    String string3 = "";
                    if (n2 < i) {
                        string3 = "/**/";
                    }
                    string3 = string3 + cSRinfo.condArray.get(n2);
                    String string4 = string2 + string3;
                    arrayList.set(i, string4);
                }
            }
            return arrayList;
        }

        public void multiplyVTaM(int n, int n2) {
            RelationalBGP.this.log("in multiplyVTaM(): INPUT => UAstartPos=" + n + " rowBlock_size=" + n2);
            RelationalBGP.this.log("BEFORE MULTIPLYING: vTaMArray [size=" + this.vTaMArray.size() + "]: " + this.vTaMArray);
            for (int i = 0; i < n2; ++i) {
                HashMap<String, String> hashMap = new HashMap<String, String>(this.vTaMArray.get(n + i));
                this.vTaMArray.add(hashMap);
            }
            RelationalBGP.this.log("AFTER MULTIPLYING: vTaMArray [size=" + this.vTaMArray.size() + "]: " + this.vTaMArray);
        }

        public void populate_vTaMArray(int n, int n2) throws RDFException {
            RelationalBGP.this.log("ENTER: populate_vTaMArray: vTaMArray.size()=" + this.vTaMArray.size() + ": " + this.vTaMArray);
            for (int i = 0; i < n2; ++i) {
                int n3 = n + i;
                if (n3 < this.vTaMArray.size()) {
                    RelationalBGP.this.log("vTam element already exists at UArowIdx=" + n3);
                    continue;
                }
                if (n3 == this.vTaMArray.size()) {
                    RelationalBGP.this.log("[populate_vTaMArray] UArowIdx: " + n3);
                    List<Map<String, String>> list = this.get_vTaMArray_snapshot();
                    Map<Object, Object> map = list.size() > 0 ? list.get(i) : new LinkedHashMap();
                    RelationalBGP.this.log("[populate_vTaMArray] vTaM_snapshot: " + map);
                    LinkedHashMap linkedHashMap = new LinkedHashMap(map);
                    this.vTaMArray.add(linkedHashMap);
                    continue;
                }
                throw new RDFException("UArowIdx=" + n3 + " is beyond vTaMArray.size()=" + this.vTaMArray.size());
            }
            RelationalBGP.this.log("EXIT: populate_vTaMArray: vTaMArray.size()=" + this.vTaMArray.size() + ": " + this.vTaMArray);
        }

        public boolean addTableAliasForVarTmap(String string, int n, String string2, String string3, String string4) throws RDFException {
            RelationalBGP.this.log("[MCSR addTableAliasForVarTmap] in addTableAliasForVarTmap(): csrKey=" + string + " UArowIdx=" + n + " var=" + string2 + " Tmap=" + string3 + " tableAlias=" + string4);
            CSRinfo cSRinfo = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(string);
            if (cSRinfo == null) {
                throw new RDFException("[MCSR vTaM] Error attempting to access an invalid CSR: " + string);
            }
            int n2 = cSRinfo.getUArowsCount() > 0 ? n % cSRinfo.getUArowsCount() : n;
            RelationalBGP.this.log("[MCSR addTableAliasForVarTmap] UArowIdx: " + n + "   UArowIdx_for_CSR: " + n2);
            boolean bl = false;
            RelationalBGP.this.log("[MCSR addTableAliasForVarTmap] wasAdded=" + bl);
            String string5 = string2 + string3;
            RelationalBGP.this.log("[MCSR addTableAliasForVarTmap] varTmap=" + string5);
            Map<String, String> map = null;
            RelationalBGP.this.log("[MCSR addTableAliasForVarTmap] BEFORE: this.vTaMArray.size()=" + this.vTaMArray.size());
            if (n < this.vTaMArray.size()) {
                RelationalBGP.this.log("[MCSR addTableAliasForVarTmap] UArowIdx " + n + " already has its varTmapTableAlias map memory allocation");
                map = this.vTaMArray.get(n);
            } else {
                RelationalBGP.this.log("[MCSR addTableAliasForVarTmap] UArowIdx " + n + " requires its varTmapTableAlias map memory allocation");
                RelationalBGP.this.log("[MCSR addTableAliasForVarTmap] instantiation of a new vTaM element using the vTaMArray_snapshot");
                List<Map<String, String>> list = this.get_vTaMArray_snapshot();
                Map<Object, Object> map2 = list.size() > 0 ? list.get(n2) : new LinkedHashMap();
                RelationalBGP.this.log("[MCSR addTableAliasForVarTmap] vTaM_snapshot: " + map2);
                map = new LinkedHashMap<String, String>(map2);
                this.vTaMArray.add(n, map);
            }
            RelationalBGP.this.log("[MCSR addTableAliasForVarTmap] AFTER: this.vTaMArray.size()=" + this.vTaMArray.size());
            if (!map.containsKey(string5)) {
                RelationalBGP.this.log("[MCSR addTableAliasForVarTmap] BEFORE varTmapTableAlias for UArowIdx " + n + ": " + map);
                RelationalBGP.this.log("[MCSR addTableAliasForVarTmap] Adding new varTmap -> tableAlias:" + string5 + " -> " + string4);
                map.put(string5, string4);
                bl = true;
                RelationalBGP.this.log("[MCSR addTableAliasForVarTmap] AFTER varTmapTableAlias for UArowIdx " + n + ": " + map);
            } else {
                RelationalBGP.this.log("[MCSR addTableAliasForVarTmap] varTmapTableAlias for UArowIdx " + n + " already contains varTmap -> tableAlias:" + string5 + " -> " + string4);
            }
            return bl;
        }

        public String getTableAliasForVarTmap(String string, int n, String string2, String string3) throws RDFException {
            RelationalBGP.this.log("[MCSR getTableAliasForVarTmap] in getTableAliasForVarTmap(): csrKey=" + string + " UArowIdx=" + n + " var=" + string2 + " Tmap=" + string3);
            if (this.vTaMArray.size() <= n) {
                RelationalBGP.this.log("[MCSR getTableAliasForVarTmap] vTaM element does NOT exist for UArowIdx=" + n + ": vTaMArray.size()=" + this.vTaMArray.size() + ": " + this.vTaMArray);
                return null;
            }
            RelationalBGP.this.log("[MCSR getTableAliasForVarTmap] vTaM for UArowIdx=" + n + ": " + this.vTaMArray.get(n));
            String string4 = string2 + string3;
            String string5 = this.vTaMArray.get(n).get(string4);
            if (RelationalBGP.this.Tmaps_with_nonUnique_Smaps.contains(string3) && string5 != null) {
                RelationalBGP.this.log("varTmap=" + string4 + " is in Tmaps_with_nonUnique_Smaps... then we do not reuse the previously seen Alias=" + string5);
                string5 = null;
            }
            RelationalBGP.this.log("getTableAliasForVarTmap: RETURN tableAlias=" + string5);
            return string5;
        }

        public void take_vTaMArray_snapshot() {
            this.vTaMArray_snapshot = new ArrayList<Map<String, String>>();
            for (Map<String, String> map : this.vTaMArray) {
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(map);
                this.vTaMArray_snapshot.add(linkedHashMap);
            }
            RelationalBGP.this.log("[MCSR take_vTaMArray_snapshot]: " + this.vTaMArray_snapshot);
        }

        public List<Map<String, String>> get_vTaMArray_snapshot() {
            RelationalBGP.this.log("[MCSR get_vTaMArray_snapshot]: " + this.vTaMArray_snapshot);
            return this.vTaMArray_snapshot;
        }

        public ACRinfo putACRinfo_for_AliasComponentRRrowid(String string, String string2, String string3, ACRinfo aCRinfo) {
            String string4 = string + "+" + string2 + "+" + string3;
            ACRinfo aCRinfo2 = this.ACRinfo_for_acr.put(string4, aCRinfo);
            RelationalBGP.this.log("ADDED acr: " + string4 + " --> " + aCRinfo.toString());
            return aCRinfo2;
        }

        public ACRinfo getACRinfo_for_AliasComponentRRrowid(String string, String string2, String string3) {
            String string4 = string + "+" + string2 + "+" + string3;
            ACRinfo aCRinfo = this.ACRinfo_for_acr.get(string4);
            return aCRinfo;
        }

        public int getUArowsCount() {
            return this.vTaMArray.size();
        }

        public List<UArowNatSelectInfo> getUArowNatSelectInfoArray() {
            if (this.UArowNatSelectInfoArray == null) {
                this.UArowNatSelectInfoArray = new ArrayList<UArowNatSelectInfo>(this.getUArowsCount());
                for (int i = 0; i < this.getUArowsCount(); ++i) {
                    UArowNatSelectInfo uArowNatSelectInfo = new UArowNatSelectInfo();
                    this.UArowNatSelectInfoArray.add(i, new UArowNatSelectInfo());
                }
            }
            return this.UArowNatSelectInfoArray;
        }

        public void setLastInvalidUArowNum(int n) {
            this.lastInvalidUArowNum = n;
        }

        public int getLastInvalidUArowNum() {
            return this.lastInvalidUArowNum;
        }

        public void setLastValidUArowNum(int n) {
            this.lastValidUArowNum = n;
        }

        public int getLastValidUArowNum() {
            return this.lastValidUArowNum;
        }

        private boolean printCellAtLine(StringBuffer stringBuffer, int n, String string, int n2) {
            String string2 = "\t%-" + n + "s";
            if (n2 == 0 && string.trim().length() == 0) {
                string = "----";
            }
            int n3 = n * n2;
            int n4 = Math.min(n3 + n, string.length());
            if (n3 < string.length() && n4 > 0) {
                stringBuffer.append(String.format(string2, string.substring(n3, n4)));
            }
            return n4 + 1 < string.length();
        }

        public String dumpMCSR() throws Exception {
            int n = 35;
            int n2 = 20;
            String string = "\t%-" + n + "s";
            String string2 = "\t%-" + n2 + "s";
            String string3 = "[%6d] %" + (n - 9) + "s";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(String.format("---------- MCSR: %s\n", this.getMCSRKey()));
            stringBuffer.append(String.format(" # of UArows: %d\n", this.getUArowsCount()));
            RelationalBGP.this.log(String.format(" # of UArows: %d\n", this.getUArowsCount()));
            try {
                String string4;
                CharSequence charSequence;
                String string5;
                Object object;
                String string6;
                for (int i = 0; i < this.getUArowsCount(); ++i) {
                    int n3;
                    boolean bl;
                    stringBuffer.append(String.format("[UArowIdx %4d]", i));
                    string6 = String.format(string2, "csrKey");
                    int n4 = -1;
                    do {
                        stringBuffer.append("\n" + string6);
                        bl = false;
                        ++n4;
                        for (String string7 : this.CSRKeyList) {
                            object = string7;
                            if (!this.printCellAtLine(stringBuffer, n, (String)object, n4)) continue;
                            bl = true;
                        }
                        string6 = String.format(string2, ".");
                    } while (bl);
                    stringBuffer.append("\n\n");
                    string6 = String.format(string2, "Ltab");
                    n4 = -1;
                    do {
                        stringBuffer.append("\n" + string6);
                        bl = false;
                        ++n4;
                        for (String string7 : this.CSRKeyList) {
                            object = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(string7);
                            n3 = i % ((CSRinfo)object).getUArowsCount();
                            string5 = ((CSRinfo)object).get_fromLtabPlusAlias_for_Tmap().toString();
                            if (!this.printCellAtLine(stringBuffer, n, string5, n4)) continue;
                            bl = true;
                        }
                        string6 = String.format(string2, ".");
                    } while (bl);
                    stringBuffer.append("\n\n");
                    string6 = String.format(string2, "fromArray");
                    n4 = -1;
                    do {
                        stringBuffer.append("\n" + string6);
                        bl = false;
                        ++n4;
                        for (String string7 : this.CSRKeyList) {
                            object = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(string7);
                            n3 = i % ((CSRinfo)object).getUArowsCount();
                            string5 = "";
                            if (n3 < i) {
                                string5 = "/**/";
                            }
                            if (!this.printCellAtLine(stringBuffer, n, string5 = string5 + ((CSRinfo)object).fromArray.get(n3), n4)) continue;
                            bl = true;
                        }
                        string6 = String.format(string2, ".");
                    } while (bl);
                    stringBuffer.append("\n\n");
                    string6 = String.format(string2, "condArray");
                    n4 = -1;
                    do {
                        stringBuffer.append("\n" + string6);
                        bl = false;
                        ++n4;
                        for (String string7 : this.CSRKeyList) {
                            object = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(string7);
                            n3 = i % ((CSRinfo)object).getUArowsCount();
                            string5 = "";
                            if (n3 < i) {
                                string5 = "/**/";
                            }
                            if (!this.printCellAtLine(stringBuffer, n, string5 = string5 + ((CSRinfo)object).condArray.get(n3), n4)) continue;
                            bl = true;
                        }
                        string6 = String.format(string2, ".");
                    } while (bl);
                    stringBuffer.append("\n\n");
                    string6 = String.format(string2, "sAliasArray");
                    n4 = -1;
                    do {
                        stringBuffer.append("\n" + string6);
                        bl = false;
                        ++n4;
                        for (String string7 : this.CSRKeyList) {
                            object = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(string7);
                            n3 = i % ((CSRinfo)object).getUArowsCount();
                            string5 = "";
                            if (n3 < i) {
                                string5 = "/**/";
                            }
                            if (!this.printCellAtLine(stringBuffer, n, string5 = string5 + ((CSRinfo)object).sAliasArray.get(n3), n4)) continue;
                            bl = true;
                        }
                        string6 = String.format(string2, ".");
                    } while (bl);
                    stringBuffer.append("\n\n");
                    string6 = String.format(string2, "pExprArrays");
                    n4 = -1;
                    do {
                        stringBuffer.append("\n" + string6);
                        bl = false;
                        ++n4;
                        for (String string7 : this.CSRKeyList) {
                            object = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(string7);
                            n3 = i % ((CSRinfo)object).getUArowsCount();
                            string5 = "";
                            if (n3 < i) {
                                string5 = "/**/";
                            }
                            charSequence = new StringBuffer();
                            for (int j = 0; j < ((CSRinfo)object).CSR_predList.size(); ++j) {
                                ((StringBuffer)charSequence).append(string5 + String.format(string3, j, ((CSRinfo)object).pExprArrays.get(j).get(n3)));
                            }
                            string4 = ((StringBuffer)charSequence).toString();
                            if (!this.printCellAtLine(stringBuffer, n, string4, n4)) continue;
                            bl = true;
                        }
                        stringBuffer.append("\n");
                        string6 = String.format(string2, ".");
                    } while (bl);
                    stringBuffer.append("\n\n");
                    string6 = String.format(string2, "oExprArrays");
                    n4 = -1;
                    do {
                        stringBuffer.append("\n" + string6);
                        bl = false;
                        ++n4;
                        for (String string7 : this.CSRKeyList) {
                            object = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(string7);
                            n3 = i % ((CSRinfo)object).getUArowsCount();
                            string5 = "";
                            if (n3 < i) {
                                string5 = "/**/";
                            }
                            charSequence = new StringBuffer();
                            for (int j = 0; j < ((CSRinfo)object).CSR_predList.size(); ++j) {
                                ((StringBuffer)charSequence).append(string5 + String.format(string3, j, ((CSRinfo)object).oExprArrays.get(j).get(n3)));
                            }
                            string4 = ((StringBuffer)charSequence).toString();
                            if (!this.printCellAtLine(stringBuffer, n, string4, n4)) continue;
                            bl = true;
                        }
                        stringBuffer.append("\n");
                        string6 = String.format(string2, ".");
                    } while (bl);
                    stringBuffer.append("\n\n");
                    string6 = String.format(string2, "clobExprArrays");
                    n4 = -1;
                    do {
                        stringBuffer.append("\n" + string6);
                        bl = false;
                        ++n4;
                        for (String string7 : this.CSRKeyList) {
                            object = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(string7);
                            n3 = i % ((CSRinfo)object).getUArowsCount();
                            string5 = "";
                            if (n3 < i) {
                                string5 = "/**/";
                            }
                            charSequence = new StringBuffer();
                            for (int j = 0; j < ((CSRinfo)object).CSR_predList.size(); ++j) {
                                ((StringBuffer)charSequence).append(string5 + String.format(string3, j, ((CSRinfo)object).clobExprArrays.get(j).get(n3)));
                            }
                            string4 = ((StringBuffer)charSequence).toString();
                            if (!this.printCellAtLine(stringBuffer, n, string4, n4)) continue;
                            bl = true;
                        }
                        stringBuffer.append("\n");
                        string6 = String.format(string2, ".");
                    } while (bl);
                    stringBuffer.append("\n\n");
                    string6 = String.format(string2, "FirstOccPos_for_tuple");
                    n4 = -1;
                    do {
                        stringBuffer.append("\n" + string6);
                        bl = false;
                        ++n4;
                        for (String string7 : this.CSRKeyList) {
                            object = (CSRinfo)RelationalBGP.this.CSRinfo_for_CSRkey.get(string7);
                            n3 = i % ((CSRinfo)object).getUArowsCount();
                            string5 = "";
                            if (n3 < i) {
                                string5 = "/**/";
                            }
                            charSequence = new StringBuffer();
                            for (int j = 0; j < ((CSRinfo)object).CSR_predList.size(); ++j) {
                                ((StringBuffer)charSequence).append(string5 + String.format(string3, j, ((CSRinfo)object).get_FirstOccPos_for_tuple().get(n3)));
                            }
                            string4 = ((StringBuffer)charSequence).toString();
                            if (!this.printCellAtLine(stringBuffer, n, string4, n4)) continue;
                            bl = true;
                        }
                        stringBuffer.append("\n");
                        string6 = String.format(string2, ".");
                    } while (bl);
                    stringBuffer.append("\n\n");
                    string6 = String.format(string2, "vTaMArray");
                    for (String string7 : this.vTaMArray.get(i).keySet()) {
                        stringBuffer.append("\n" + string6);
                        string6 = String.format(string2, ".");
                        object = this.vTaMArray.get(i).get(string7);
                        String string8 = string7 + " -> " + (String)object;
                        stringBuffer.append(String.format("\t%s", string8));
                    }
                    stringBuffer.append("\n\n");
                }
                stringBuffer.append("---------------------------------------------------------------------------------------\n");
                string6 = String.format(string2, "expr_for_acr");
                for (String string9 : this.expr_for_acr.keySet()) {
                    String string7;
                    stringBuffer.append("\n" + string6);
                    string6 = String.format(string2, ".");
                    string7 = this.expr_for_acr.get(string9);
                    object = string9 + " -> " + string7;
                    stringBuffer.append(String.format("\t%s", object));
                }
                stringBuffer.append("\n\n");
                stringBuffer.append("---------------------------------------------------------------------------------------\n\n");
                List<List<String>> list = this.getPExprArrays();
                if (list == null) {
                    this.consolidateCSRs();
                    list = this.getPExprArrays();
                }
                int n4 = list.size();
                stringBuffer.append("getPExprArrays(): \n");
                RelationalBGP.this.log("              poCount: " + n4);
                RelationalBGP.this.log("this.getUArowsCount(): " + this.getUArowsCount());
                for (int i = 0; i < this.getUArowsCount(); ++i) {
                    RelationalBGP.this.log("              UArowIdx: " + i);
                    for (int j = 0; j < n4; ++j) {
                        RelationalBGP.this.log("                 po_idx: " + j);
                        String string10 = list.get(j).get(i);
                        stringBuffer.append(String.format("\t[UArowIdx %4d][po_idx %4d] %s\n", i, j, string10));
                    }
                }
                List<List<String>> list2 = this.getOExprArrays();
                int n5 = list2.size();
                stringBuffer.append("getOExprArrays(): \n");
                RelationalBGP.this.log("              poCount: " + n5);
                RelationalBGP.this.log("this.getUArowsCount(): " + this.getUArowsCount());
                for (int i = 0; i < this.getUArowsCount(); ++i) {
                    RelationalBGP.this.log("              UArowIdx: " + i);
                    for (int j = 0; j < n5; ++j) {
                        RelationalBGP.this.log("                 po_idx: " + j);
                        string5 = list2.get(j).get(i);
                        stringBuffer.append(String.format("\t[UArowIdx %4d][po_idx %4d] %s\n", i, j, string5));
                    }
                }
                List<List<String>> list3 = this.getClobExprArrays();
                int n6 = list3.size();
                stringBuffer.append("getClobExprArrays(): \n");
                RelationalBGP.this.log("              poCount: " + n6);
                RelationalBGP.this.log("this.getUArowsCount(): " + this.getUArowsCount());
                for (int i = 0; i < this.getUArowsCount(); ++i) {
                    RelationalBGP.this.log("              UArowIdx: " + i);
                    for (int j = 0; j < n6; ++j) {
                        RelationalBGP.this.log("                 po_idx: " + j);
                        charSequence = list3.get(j).get(i);
                        stringBuffer.append(String.format("\t[UArowIdx %4d][po_idx %4d] %s\n", i, j, charSequence));
                    }
                }
                List<String> list4 = this.getFromArray();
                stringBuffer.append("getFromArray(): \n");
                for (int i = 0; i < this.getUArowsCount(); ++i) {
                    charSequence = list4.get(i);
                    stringBuffer.append(String.format("\t[UArowIdx %4d] %s\n", i, charSequence));
                }
                List<String> list5 = this.getCondArray();
                stringBuffer.append("getCondArray(): \n");
                for (int i = 0; i < this.getUArowsCount(); ++i) {
                    string4 = list5.get(i);
                    stringBuffer.append(String.format("\t[UArowIdx %4d] %s\n", i, string4));
                }
            }
            catch (Exception exception) {
                RelationalBGP.this.log(stringBuffer.toString());
                exception.printStackTrace();
                throw new Exception(exception.getMessage());
            }
            stringBuffer.append("\n\n");
            stringBuffer.append("---------------------------------------------------------------------------------------\n\n");
            return stringBuffer.toString();
        }
    }

    private class CSRinfo {
        public String CSR_key;
        public MCSR mcsrElem;
        public String CSR_subj;
        public boolean CSR_is_subj_const;
        public Set<String> CSR_TmapSet;
        public Set<String> CSR_TpatSet;
        private String CSR_alias;
        private List<String> CSR_TmapList;
        private List<String> CSR_predList;
        private List<String> CSR_objeList;
        private List<String> CSR_varsList;
        private Set<String> varsToProject;
        private Map<String, List<List<String>>> RRrLList_for_Tmap;
        private Map<String, Integer> RRrowFlags_for_Tmap;
        public List<String> gExprArray;
        public List<Set<String>> GeesArray;
        public List<Map<String, String>> TpGEArray;
        public List<String> RRrLArray;
        public List<String> fromArray;
        public List<String> condArray;
        public List<String> sAliasArray;
        public List<List<String>> oExprArrays;
        public List<List<String>> clobExprArrays;
        public List<List<String>> pExprArrays;
        public Map<String, List<Set<String>>> native_oExprSetArray_for_Var;
        public List<UArowNatSelectInfo> UArowNatSelectInfoArray;
        private Map<String, Integer> UAstartPos_for_Tmap;
        private Map<String, Integer> UAnumRows_for_Tmap;
        private Map<String, String> iUriExpr_for_Tmap;
        private Map<String, Integer> iUriExprType_for_Tmap;
        private Map<String, String> fromLtabPlusAlias_for_Tmap;
        private Map<String, String> FirstOccPos_for_tuple;
        public int po_idx_base;

        CSRinfo(String string, String string2, Set<String> set, Set<String> set2) {
            this.CSR_key = string;
            this.CSR_subj = string2;
            this.CSR_is_subj_const = string2.charAt(0) == '<' || string2.charAt(0) == '\"' || string2.charAt(0) == '_';
            this.CSR_TmapSet = set;
            this.CSR_TpatSet = set2;
        }

        public void excludeTmapFromTmapSet(String string) {
            this.CSR_TmapSet.remove(string);
            this.RRrLList_for_Tmap.remove(string);
        }

        public CSRinfo setCSRAlias(String string) {
            this.CSR_alias = string;
            return this;
        }

        public CSRinfo set_predList(List<String> list) {
            this.CSR_predList = list;
            return this;
        }

        public CSRinfo set_objeList(List<String> list) {
            this.CSR_objeList = list;
            return this;
        }

        public CSRinfo set_varsList(List<String> list) {
            this.CSR_varsList = list;
            return this;
        }

        public CSRinfo set_RRrLList_for_Tmap(Map<String, List<List<String>>> map) {
            this.RRrLList_for_Tmap = map;
            return this;
        }

        public CSRinfo put_RRrLList_for_Tmap(String string, List<List<String>> list) {
            if (this.CSR_TmapSet.contains(string) && !this.RRrLList_for_Tmap.containsKey(string)) {
                this.RRrLList_for_Tmap.put(string, list);
            }
            return this;
        }

        public CSRinfo set_UAstartPos_for_Tmap(Map<String, Integer> map) {
            this.UAstartPos_for_Tmap = map;
            return this;
        }

        public CSRinfo set_UAnumRows_for_Tmap(Map<String, Integer> map) {
            this.UAnumRows_for_Tmap = map;
            return this;
        }

        public CSRinfo set_iUriExpr_for_Tmap(Map<String, String> map) {
            this.iUriExpr_for_Tmap = map;
            return this;
        }

        public String put_iUriExpr(String string, String string2) {
            return this.iUriExpr_for_Tmap.put(string, string2);
        }

        public String get_iUriExpr(String string) {
            return this.iUriExpr_for_Tmap.get(string);
        }

        public CSRinfo set_iUriExprType_for_Tmap(Map<String, Integer> map) {
            this.iUriExprType_for_Tmap = map;
            return this;
        }

        public Integer put_iUriExprType(String string, Integer n) {
            return this.iUriExprType_for_Tmap.put(string, n);
        }

        public Integer get_iUriExprType(String string) {
            return this.iUriExprType_for_Tmap.get(string);
        }

        public CSRinfo set_fromLtabPlusAlias_for_Tmap(Map<String, String> map) {
            this.fromLtabPlusAlias_for_Tmap = map;
            return this;
        }

        public CSRinfo set_FirstOccPos_for_tuple(Map<String, String> map) {
            this.FirstOccPos_for_tuple = map;
            return this;
        }

        public void multiplyVTaL(int n, int n2) {
            RelationalBGP.this.log("in multiplyVTaL(): INPUT => UAstartPos=" + n + " rowBlock_size=" + n2);
            this.mcsrElem.multiplyVTaM(n, n2);
        }

        public String getCSRAlias() {
            return this.CSR_alias;
        }

        public List<String> get_predList() {
            return this.CSR_predList;
        }

        public List<String> get_objeList() {
            return this.CSR_objeList;
        }

        public List<String> get_varsList() {
            return this.CSR_varsList;
        }

        public void computeVarsToProject(Set<String> set) {
            RelationalBGP.this.log("[CSR computeVarsToProject] ENTERING");
            RelationalBGP.this.log("[CSR computeVarsToProject]                varsList: " + this.CSR_varsList);
            this.varsToProject = new LinkedHashSet<String>(this.CSR_varsList);
            RelationalBGP.this.log("[CSR computeVarsToProject]           varsToExclude: " + set);
            this.varsToProject.removeAll(set);
            RelationalBGP.this.log("[CSR computeVarsToProject] RESULTING varsToProject: " + this.varsToProject);
        }

        public Set<String> getVarsToProject() {
            return this.varsToProject;
        }

        public String getFirstOccPos(String string) {
            return this.FirstOccPos_for_tuple.get(string);
        }

        public RRTabRowInfo getRRrowInfo(int n, int n2) {
            String string = this.RRrLArray.get(n);
            String[] stringArray = string.substring(1, string.length()).split(":");
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            String string2 = (String)arrayList.get(n2);
            return (RRTabRowInfo)RelationalBGP.this.RRrowInfo_for_MatchingRow.get(string2);
        }

        public int getFirstTFTIdx(int n, String string) {
            RelationalBGP.this.log("[CSR getFirstTFTIdx] ENTERING UArowNum= " + n + " var=" + string);
            int n2 = -2;
            String string2 = this.getFirstOccPos(string);
            if (string2 != null) {
                String[] stringArray = string2.split(":");
                String string3 = stringArray[0];
                int n3 = Integer.valueOf(stringArray[1]);
                RelationalBGP.this.log("[CSR getFirstTFTIdx] var=" + string + " occurrence=" + string3 + " po_idx=" + n3);
                RRTabRowInfo rRTabRowInfo = this.getRRrowInfo(n, n3);
                RelationalBGP.this.log("[CSR getFirstTFTIdx] rowid=" + rRTabRowInfo.rowid);
                switch (string3) {
                    case "subject": {
                        n2 = rRTabRowInfo.TFT_idxs.get(0);
                        break;
                    }
                    case "predicate": {
                        n2 = rRTabRowInfo.TFT_idxs.get(1);
                        break;
                    }
                    case "object": {
                        if (rRTabRowInfo.psExpr != null) {
                            n2 = rRTabRowInfo.TFT_idxs.get(4);
                            break;
                        }
                        n2 = rRTabRowInfo.TFT_idxs.get(2);
                        break;
                    }
                    case "graph": {
                        n2 = rRTabRowInfo.TFT_idxs.get(3);
                        break;
                    }
                    default: {
                        n2 = -3;
                        break;
                    }
                }
            } else {
                RelationalBGP.this.log("[CSR getFirstTFTIdx] No FirstOccPos_for_tuple entry found for var=" + string);
                return -1;
            }
            RelationalBGP.this.log("[CSR getFirstTFTIdx] RETURNING TFTidx=" + n2);
            return n2;
        }

        public Map<String, List<List<String>>> get_RRrLList_for_Tmap() {
            return this.RRrLList_for_Tmap;
        }

        public List<List<String>> get_RRrLList_for_Tmap(String string) {
            return this.RRrLList_for_Tmap.get(string);
        }

        public int get_UArow_count_for_Tmap(String string) {
            List<List<String>> list = this.RRrLList_for_Tmap.get(string);
            if (list == null || list.size() == 0) {
                return 0;
            }
            int n = 1;
            for (List<String> list2 : list) {
                n *= list2.size();
            }
            return n;
        }

        public int get_UArow_count() {
            if (this.RRrLList_for_Tmap == null) {
                return 0;
            }
            int n = 0;
            for (String string : this.RRrLList_for_Tmap.keySet()) {
                n += this.get_UArow_count_for_Tmap(string);
            }
            return n;
        }

        public String get_Tmap_for_UArowNum(int n) throws RDFException {
            for (String string : this.CSR_TmapList) {
                int n2 = this.UAstartPos_for_Tmap.get(string);
                int n3 = this.UAnumRows_for_Tmap.get(string);
                if (n < n2 || n >= n2 + n3) continue;
                return string;
            }
            throw new RDFException("In CSR " + this.CSR_key + ", no Tmap is found for the specified UArowNum=" + n);
        }

        public Map<String, Integer> get_UAstartPos_for_Tmap() {
            return this.UAstartPos_for_Tmap;
        }

        public Map<String, Integer> get_UAnumRows_for_Tmap() {
            return this.UAnumRows_for_Tmap;
        }

        public Map<String, String> get_iUriExpr_for_Tmap() {
            return this.iUriExpr_for_Tmap;
        }

        public Map<String, Integer> get_iUriExprType_for_Tmap() {
            return this.iUriExprType_for_Tmap;
        }

        public Map<String, String> get_fromLtabPlusAlias_for_Tmap() {
            return this.fromLtabPlusAlias_for_Tmap;
        }

        public Map<String, String> get_FirstOccPos_for_tuple() {
            return this.FirstOccPos_for_tuple;
        }

        public int getPOCount() {
            return this.CSR_predList != null ? this.CSR_predList.size() : 0;
        }

        public int getUArowsCount() {
            return this.sAliasArray.size();
        }

        private void dumpUnionArray() {
            RelationalBGP.this.log("in dumpUnionArray:");
            for (int i = 0; i < this.fromArray.size(); ++i) {
                RelationalBGP.this.log("  rowNum: " + i);
                this.dumpUnionArrayRow(i);
            }
        }

        private void dumpUnionArrayRow(int n) {
            RelationalBGP.this.log("    RRrLArray[" + n + "]: " + this.RRrLArray.get(n));
            RelationalBGP.this.log("    fromArray[" + n + "]: " + this.fromArray.get(n));
            RelationalBGP.this.log("    condArray[" + n + "]: \n" + this.condArray.get(n));
            RelationalBGP.this.log("  sAliasArray[" + n + "]: \n" + this.sAliasArray.get(n));
            RelationalBGP.this.log(RelationalBGP.this.prettyPrintCond(this.condArray.get(n)));
            for (int i = 0; i < this.CSR_predList.size(); ++i) {
                RelationalBGP.this.log("     po_idx: " + i);
                RelationalBGP.this.log("      pred-obje[" + i + "]=[ " + this.CSR_predList.get(i) + RelationalBGP.BASE_PREFIX_COLNAME_SEP + this.CSR_objeList.get(i) + " ]");
                RelationalBGP.this.log("         pExpr: " + this.pExprArrays.get(i).get(n));
                RelationalBGP.this.log("        -oExpr: " + this.oExprArrays.get(i).get(n));
            }
        }

        public String getShortCSRKey() {
            return this.CSR_key.substring(0, this.CSR_key.indexOf(43)) + this.CSR_key.substring(this.CSR_key.lastIndexOf(116), this.CSR_key.length() - 1);
        }
    }

    public class TFTinfo {
        public int TFTidx;
        public String TFTsig;
        public String termType;
        public int exprType;
        public int numCols;
        public List<String> strList;
        public List<String> colTypeList;
        public String datatype;
        public String datatype_family;
        public String language;
        public List<String> strIsolList;
        public int numIsolStrs;
        public boolean ieq_optimizable;

        public TFTinfo(int n, String string, String string2, int n2, List<String> list, List<String> list2, String string3, String string4, String string5) throws RDFException {
            String string62;
            this.TFTidx = n;
            this.TFTsig = string;
            this.termType = string2;
            this.exprType = n2;
            this.strList = list;
            this.colTypeList = list2;
            if (list.size() != list2.size() + 1) {
                throw new RDFException("internal error in TFTinfo constructor: strList.size()=" + list.size() + " colTypeList.size()=" + list2.size());
            }
            this.numCols = list2.size();
            this.datatype = string3;
            this.datatype_family = string4;
            this.language = string5;
            this.numIsolStrs = 0;
            this.strIsolList = new ArrayList<String>(list.size());
            if (list.size() > 1) {
                this.strIsolList.add("leftmost");
            } else {
                this.strIsolList.add("leftmost-and-rightmost");
            }
            for (int i = 1; i < list.size() - 1; ++i) {
                this.strIsolList.add(null);
                string62 = list.get(i);
                String string7 = list2.get(i - 1);
                String string8 = list2.get(i);
                if (string7.equals("STRING") && string8.equals("STRING")) continue;
                if (string7.equals("DATE") || string7.indexOf(RelationalBGP.LTC_TYPE_TIMESTAMP) == 0) {
                    this.strIsolList.set(i, "(" + string7 + ",*)");
                    continue;
                }
                if (string8.equals("DATE") || string8.indexOf(RelationalBGP.LTC_TYPE_TIMESTAMP) == 0) {
                    this.strIsolList.set(i, "(*," + string8 + ")");
                    continue;
                }
                if (!(!string7.equals(RelationalBGP.LTC_TYPE_BFLOAT) && string7.indexOf(RelationalBGP.LTC_TYPE_BDOUBLE) != 0 || string8.equals(RelationalBGP.LTC_TYPE_NUMBER) || string8.equals("STRING"))) {
                    this.strIsolList.set(i, "(" + string7 + ",not-NUMBER-not-STRING)");
                    continue;
                }
                if (string8.equals(RelationalBGP.LTC_TYPE_BFLOAT) || string8.indexOf(RelationalBGP.LTC_TYPE_BDOUBLE) == 0) {
                    this.strIsolList.set(i, "(*," + string8 + ")");
                    continue;
                }
                boolean bl = true;
                boolean bl2 = true;
                if (string62.charAt(0) == '+') {
                    bl = false;
                    bl2 = false;
                } else {
                    if (string62.charAt(0) == '-') {
                        bl = false;
                    } else if (string62.charAt(0) == '0') {
                        bl2 = false;
                    }
                    if (string62.indexOf(46) == -1) {
                        try {
                            int n3 = Integer.parseInt(string62);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                            bl2 = false;
                        }
                    } else if (string62.indexOf(46) == string62.lastIndexOf(46)) {
                        if (string62.charAt(string62.length() - 1) == '0') {
                            bl = false;
                        }
                        try {
                            int n4 = Integer.parseInt(string62.substring(0, string62.indexOf(46)));
                            int n5 = Integer.parseInt(string62.substring(string62.indexOf(46) + 1, string62.length()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                            bl2 = false;
                        }
                    } else {
                        bl = false;
                        bl2 = false;
                    }
                }
                if ((string7.equals(RelationalBGP.LTC_TYPE_NUMBER) && bl || string7.equals("STRING")) && (string8.equals(RelationalBGP.LTC_TYPE_NUMBER) && bl2 || string8.equals("STRING"))) continue;
                this.strIsolList.set(i, "(" + string7 + "[db_form_num_suffix=" + bl + "]," + string8 + "[db_form_num_prefix=" + bl2 + "])");
            }
            if (list.size() > 1) {
                this.strIsolList.add("rightmost");
            }
            for (String string62 : this.strIsolList) {
                if (string62 == null) continue;
                ++this.numIsolStrs;
            }
            boolean bl = false;
            if (string2.equals(RelationalBGP.rrLiteral)) {
                if (list2.size() == 0) {
                    bl = true;
                } else if (list2.size() == 1) {
                    string62 = list2.get(0);
                    if (string62.equals(RelationalBGP.LTC_TYPE_NUMBER)) {
                        string62 = RelationalBGP.TYPE_FAM_NUMERIC;
                    } else if (string62.equals(RelationalBGP.LTC_TYPE_TIMESTAMP) || string62.equals(RelationalBGP.LTC_TYPE_TIMESTAMP_TZ) || string62.equals(RelationalBGP.LTC_TYPE_TIMESTAMP_LTZ)) {
                        string62 = RelationalBGP.TYPE_FAM_DATETIME;
                    } else if (string62.equals(RelationalBGP.LTC_TYPE_BFLOAT)) {
                        string62 = RelationalBGP.TYPE_FAM_FLOAT;
                    } else if (string62.equals(RelationalBGP.LTC_TYPE_BDOUBLE)) {
                        string62 = RelationalBGP.TYPE_FAM_DOUBLE;
                    }
                    if (string4 != null && (string4.equals(string62) || (string4.equals(RelationalBGP.TYPE_FAM_FLOAT) || string4.equals(RelationalBGP.TYPE_FAM_DOUBLE) || string4.equals(RelationalBGP.TYPE_FAM_NUMERIC)) && (string62.equals(RelationalBGP.TYPE_FAM_FLOAT) || string62.equals(RelationalBGP.TYPE_FAM_DOUBLE) || string62.equals(RelationalBGP.TYPE_FAM_NUMERIC)))) {
                        this.ieq_optimizable = true;
                    }
                }
            }
        }

        public String toString() {
            return "\nTFTinfo [TFTidx=" + this.TFTidx + ": TFTsig=" + this.TFTsig + "]:\n  termType=" + this.termType + " exprType=" + this.exprType + "\n  datatype=" + this.datatype + " datatype_family=" + this.datatype_family + " language=" + this.language + "\n  numCols=" + this.numCols + "\n  strList (size=" + this.strList.size() + ")=" + this.strList + "\n  colTypeList (size=" + this.colTypeList.size() + ")=" + this.colTypeList + "\n  numIsolStrs=" + this.numIsolStrs + "\n  strIsolList (size=" + this.strIsolList.size() + ")=" + this.strIsolList + "\n  ieq_optimizable=" + this.ieq_optimizable;
        }
    }

    private class ACRinfo {
        String ACRexpr;
        String ACRcondExpr;
        List<String> ACRcolList;

        public ACRinfo(String string, String string2, List<String> list) {
            this.ACRexpr = string;
            this.ACRcondExpr = string2;
            this.ACRcolList = list;
        }

        public String get_ACRexpr() {
            return this.ACRexpr;
        }

        public String get_ACRcondExpr() {
            return this.ACRcondExpr;
        }

        public List<String> get_ACRcolList() {
            return this.ACRcolList;
        }

        public boolean isEqual(ACRinfo aCRinfo) {
            return this.ACRexpr.equals(aCRinfo.get_ACRexpr()) && this.ACRcondExpr.equals(aCRinfo.get_ACRcondExpr()) && this.ACRcondExpr.equals(aCRinfo.get_ACRcolList());
        }

        public String toString() {
            return "ACRinfo: \nACRexpr     :" + this.ACRexpr + "\nACRcondExpr :" + this.ACRcondExpr + "\nACRcolList  :" + this.ACRcolList + "\n";
        }
    }

    private class TmapInfo {
        public String Tmap;
        public String LtabExpr;
        public String SubjExpr;
        public int sTFT_idx;
        public String SubjRRrowid;
        public int RRrowFlags;
        public String sRRexpr;
        public List<String> sColList;

        TmapInfo(String string, int n, String string2, List<String> list, int n2) {
            this.Tmap = this.Tmap;
            this.RRrowFlags = n;
            this.sRRexpr = string2;
            this.sColList = list;
            this.sTFT_idx = n2;
        }

        public String toString() {
            return "TmapInfo: Tmap=" + this.Tmap + ": RRrowFlags=" + this.RRrowFlags + " sRRexpr=" + this.sRRexpr + " sColList=" + this.sColList + " sTFT_idx=" + this.sTFT_idx;
        }
    }

    private class String3 {
        public String str1;
        public String str2;
        public String str3;

        public String3(String string, String string2, String string3) {
            this.str1 = string;
            this.str2 = string2;
            this.str3 = string3;
        }

        public String toString() {
            return "[" + this.str1 + "]<" + this.str2 + ">[" + this.str3 + "]";
        }
    }

    private class String2 {
        public String str1;
        public String str2;

        private String2() {
        }
    }

    private class Pair_IntString {
        public int num;
        public String str;

        private Pair_IntString() {
        }
    }

    private class Pair_IntInt {
        public int num1;
        public int num2;

        private Pair_IntInt() {
        }
    }
}

