/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SelectExpression;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTAggregate;
import oracle.spatial.rdf.server.parser.sparql.ASTBuiltInCall;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupClause;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupCondition;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectClause;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTSolutionModifier;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class DistGroupConcatRewriteOptimizer
implements SparqlQueryOptimizer {
    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        int n;
        if (((SimpleNode)node).id == 7) {
            ASTSelectQuery aSTSelectQuery = (ASTSelectQuery)node;
            n = 0;
            int n2 = 0;
            for (SelectExpression selectExpression : aSTSelectQuery.getselDesc().getSelectExpressions()) {
                if (selectExpression.getExprTree() == null) continue;
                if (DistGroupConcatRewriteOptimizer.isDistinctGroupConcat(selectExpression.getExprTree())) {
                    ++n;
                    continue;
                }
                if (((SimpleNode)selectExpression.getExprTree()).id != 89) continue;
                ++n2;
            }
            if (n == 1 && n2 == 0) {
                this.rewriteSelQuery(aSTSelectQuery);
            }
        }
        int n3 = ((SimpleNode)node).jjtGetNumChildren();
        for (n = 0; n < n3; ++n) {
            this.optimizeQuery((SimpleNode)node.jjtGetChild(n));
        }
        return node;
    }

    private void rewriteSelQuery(ASTSelectQuery aSTSelectQuery) throws RDFException, ParseException {
        ASTGroupGraphPattern aSTGroupGraphPattern = new ASTGroupGraphPattern(48);
        ASTSelectQuery aSTSelectQuery2 = new ASTSelectQuery(7);
        aSTGroupGraphPattern.jjtAddChild(aSTSelectQuery2, 0);
        aSTSelectQuery2.jjtSetParent(aSTGroupGraphPattern);
        ASTSelectClause aSTSelectClause = new ASTSelectClause(8);
        aSTSelectQuery2.jjtAddChild(aSTSelectClause, 0);
        aSTSelectClause.jjtSetParent(aSTSelectQuery2);
        int n = 0;
        ASTSolutionModifier aSTSolutionModifier = new ASTSolutionModifier(13);
        aSTSelectQuery2.jjtAddChild(aSTSolutionModifier, 2);
        aSTSolutionModifier.jjtSetParent(aSTSelectQuery2);
        ASTGroupClause aSTGroupClause = new ASTGroupClause(14);
        aSTSolutionModifier.jjtAddChild(aSTGroupClause, 0);
        aSTGroupClause.jjtSetParent(aSTSolutionModifier);
        boolean bl = false;
        int n2 = aSTSelectQuery.getsolnMod().getGroupByConds().size();
        aSTGroupClause.jjtSetInitCapacity(n2 + 1);
        for (int i = 0; i < aSTSelectQuery.jjtGetNumChildren(); ++i) {
            Node node;
            SimpleNode simpleNode;
            int n3;
            SimpleNode simpleNode2;
            if (((SimpleNode)aSTSelectQuery.jjtGetChild((int)i)).id == 8) {
                simpleNode2 = (ASTSelectClause)aSTSelectQuery.jjtGetChild(i);
                for (n3 = 0; n3 < simpleNode2.jjtGetNumChildren(); ++n3) {
                    SimpleNode simpleNode3;
                    simpleNode = (SimpleNode)simpleNode2.jjtGetChild(n3);
                    if (simpleNode.id == 9 && DistGroupConcatRewriteOptimizer.isDistinctGroupConcat(simpleNode.jjtGetChild(0))) {
                        simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(0);
                        node = (SimpleNode)simpleNode3.jjtGetChild(0);
                        Node node2 = null;
                        Node node3 = null;
                        ASTGroupCondition aSTGroupCondition = new ASTGroupCondition(15);
                        aSTGroupClause.jjtAddChild(aSTGroupCondition, n2);
                        if (((SimpleNode)node).id == 73 && ((ASTTripleAtom)node).type == 0) {
                            node3 = ((SimpleNode)node).cloneSubTree();
                            node2 = node3.cloneSubTree();
                        } else {
                            Node node4;
                            node3 = ((SimpleNode)node).cloneSubTree();
                            ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
                            aSTTripleAtom.type = 0;
                            aSTTripleAtom.name = "GC$1";
                            aSTGroupCondition.jjtAddChild(aSTTripleAtom, 1);
                            aSTTripleAtom.jjtSetParent(aSTGroupCondition);
                            node2 = aSTTripleAtom.cloneSubTree();
                            Node node5 = aSTTripleAtom.cloneSubTree();
                            if (((SimpleNode)node).id == 88 && ((ASTBuiltInCall)node).name.equals("STR") && ((SimpleNode)node).jjtGetNumChildren() == 1 && ((SimpleNode)((SimpleNode)node).jjtGetChild((int)0)).id == 73 && ((ASTTripleAtom)((SimpleNode)node).jjtGetChild((int)0)).type == 0) {
                                node4 = ((SimpleNode)node).cloneSubTree();
                                node4.jjtAddChild(node5, 0);
                                node5.jjtSetParent(node4);
                            } else {
                                node4 = node5;
                            }
                            simpleNode3.jjtAddChild(node4, 0);
                            node4.jjtSetParent(simpleNode3);
                            for (SelectExpression selectExpression : aSTSelectQuery.getselDesc().getSelectExpressions()) {
                                if (selectExpression.getExprTree() == null || !DistGroupConcatRewriteOptimizer.isDistinctGroupConcat(selectExpression.getExprTree())) continue;
                                ASTAggregate aSTAggregate = (ASTAggregate)selectExpression.getExprTree();
                                Node node6 = node4.cloneSubTree();
                                aSTAggregate.jjtAddChild(node6, 0);
                                node6.jjtSetParent(aSTAggregate);
                            }
                        }
                        aSTGroupCondition.jjtAddChild(node3, 0);
                        node3.jjtSetParent(aSTGroupCondition);
                        aSTSelectClause.jjtAddChild(node2, n++);
                        node2.jjtSetParent(aSTSelectClause);
                        continue;
                    }
                    simpleNode3 = (SimpleNode)simpleNode.cloneSubTree();
                    aSTSelectClause.jjtAddChild(simpleNode3, n++);
                    simpleNode3.jjtSetParent(aSTSelectClause);
                }
                continue;
            }
            if (((SimpleNode)aSTSelectQuery.jjtGetChild((int)i)).id == 48) {
                simpleNode2 = (ASTGroupGraphPattern)aSTSelectQuery.jjtGetChild(i);
                aSTSelectQuery2.jjtAddChild(simpleNode2, 1);
                simpleNode2.jjtSetParent(aSTSelectQuery2);
                aSTSelectQuery.jjtAddChild(aSTGroupGraphPattern, i);
                aSTGroupGraphPattern.jjtSetParent(aSTSelectQuery);
                continue;
            }
            if (((SimpleNode)aSTSelectQuery.jjtGetChild((int)i)).id != 13) continue;
            simpleNode2 = (ASTSolutionModifier)aSTSelectQuery.jjtGetChild(i);
            for (n3 = simpleNode2.jjtGetNumChildren() - 1; n3 >= 0; --n3) {
                if (((SimpleNode)simpleNode2.jjtGetChild((int)n3)).id != 14) continue;
                simpleNode = (ASTGroupClause)simpleNode2.jjtGetChild(n3);
                for (int j = 0; j < simpleNode.jjtGetNumChildren(); ++j) {
                    node = simpleNode.jjtGetChild(j).cloneSubTree();
                    aSTGroupClause.jjtAddChild(node, j);
                    node.jjtSetParent(aSTGroupClause);
                }
            }
        }
        DistGroupConcatRewriteOptimizer.removeDistinctGCFromSelect(aSTSelectQuery);
        aSTSelectQuery2.getselDesc().populateSelDesc(aSTSelectQuery2, false);
        aSTSelectQuery2.getsolnMod().populateSolnMod(aSTSelectQuery2);
        aSTSelectQuery2.getsolnMod().setSolnModExists(true);
    }

    private static boolean isDistinctGroupConcat(Node node) {
        boolean bl = false;
        if (((SimpleNode)node).id == 89 && ((ASTAggregate)node).name.equals("GROUP_CONCAT") && !((ASTAggregate)node).distinct.equals("")) {
            bl = true;
        }
        return bl;
    }

    private static void removeDistinctGC(Node node) {
        if (DistGroupConcatRewriteOptimizer.isDistinctGroupConcat(node)) {
            ((ASTAggregate)node).distinct = "";
        }
    }

    private static void removeDistinctGCFromSelect(ASTSelectQuery aSTSelectQuery) {
        for (SelectExpression selectExpression : aSTSelectQuery.getselDesc().getSelectExpressions()) {
            if (selectExpression.getExprTree() == null) continue;
            DistGroupConcatRewriteOptimizer.removeDistinctGC(selectExpression.getExprTree());
        }
        int n = aSTSelectQuery.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            if (((SimpleNode)aSTSelectQuery.jjtGetChild((int)i)).id != 8) continue;
            Node node = aSTSelectQuery.jjtGetChild(i);
            for (int j = 0; j < node.jjtGetNumChildren(); ++j) {
                SimpleNode simpleNode = (SimpleNode)node.jjtGetChild(j);
                if (simpleNode.id != 9) continue;
                DistGroupConcatRewriteOptimizer.removeDistinctGC(simpleNode.jjtGetChild(0));
            }
        }
    }
}

