/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SelectExpression;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectClause;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectExpression;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.parser.sparql.SparqlSelectDescriptor;

public class ConstBindRewriteOptimizer
implements SparqlQueryOptimizer {
    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.offer(node);
        while (!linkedList.isEmpty()) {
            int n;
            SimpleNode simpleNode = (SimpleNode)linkedList.remove();
            int n2 = simpleNode.jjtGetNumChildren();
            if (simpleNode.id == 48) {
                for (n = 0; n < n2; ++n) {
                    Node node2 = simpleNode.jjtGetChild(n);
                    Map<String, ASTTripleAtom> map = this.getConstBindValues(node2);
                    if (map.size() <= 0) continue;
                    HashSet<String> hashSet = new HashSet<String>();
                    for (int i = n + 1; i < n2; ++i) {
                        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
                        HashSet<String> hashSet2 = new HashSet<String>();
                        this.getNonReplaceableVars(hashSet2, simpleNode2);
                        this.getBoundVars(hashSet, simpleNode2, null);
                        for (String string : map.keySet()) {
                            if (hashSet2.contains(string)) break;
                            if (!hashSet.contains(string) || this.isNWFOvar(string, simpleNode2, false)) continue;
                            this.replaceVar(string, map.get(string), simpleNode2, simpleNode, i);
                        }
                    }
                }
            }
            for (n = 0; n < n2; ++n) {
                linkedList.offer(simpleNode.jjtGetChild(n));
            }
        }
        return node;
    }

    private Map<String, ASTTripleAtom> getConstBindValues(Node node) {
        HashMap<String, ASTTripleAtom> hashMap = new HashMap<String, ASTTripleAtom>();
        ASTSelectQuery aSTSelectQuery = null;
        if (((SimpleNode)node).id == 49) {
            SimpleNode simpleNode = (SimpleNode)node.jjtGetChild(0);
            if (simpleNode.id == 7) {
                aSTSelectQuery = (ASTSelectQuery)node.jjtGetChild(0);
            } else if (simpleNode.id == 48 && simpleNode.jjtGetNumChildren() == 1 && ((SimpleNode)simpleNode.jjtGetChild((int)0)).id == 7) {
                aSTSelectQuery = (ASTSelectQuery)simpleNode.jjtGetChild(0);
            }
            if (aSTSelectQuery != null) {
                for (SelectExpression selectExpression : aSTSelectQuery.getselDesc().getSelectExpressions()) {
                    if (!selectExpression.isConstant()) continue;
                    hashMap.put(selectExpression.getVar().name.toUpperCase(), (ASTTripleAtom)selectExpression.getExprTree());
                }
            }
        }
        return hashMap;
    }

    private boolean replaceVar(String string, ASTTripleAtom aSTTripleAtom, Node node, Node node2, int n) {
        SimpleNode simpleNode = (SimpleNode)node;
        int n2 = simpleNode.jjtGetNumChildren();
        if (simpleNode.id == 73) {
            ASTTripleAtom aSTTripleAtom2 = (ASTTripleAtom)simpleNode;
            if (aSTTripleAtom2.type == 0 && string.equals(aSTTripleAtom2.name.toUpperCase())) {
                ASTTripleAtom aSTTripleAtom3 = (ASTTripleAtom)aSTTripleAtom.cloneNode();
                aSTTripleAtom3.jjtSetParent(node2);
                node2.jjtAddChild(aSTTripleAtom3, n);
                return true;
            }
        } else if (simpleNode.id == 7) {
            Set<String> set = OptimizerUtils.collectVisibleVarNames(simpleNode);
            if (set.contains(string)) {
                int n3;
                int n4;
                int n5 = -1;
                int n6 = -1;
                for (n4 = 0; n4 < n2; n4 += 1) {
                    if (((SimpleNode)simpleNode.jjtGetChild((int)n4)).id == 8) {
                        n5 = n4;
                        continue;
                    }
                    if (((SimpleNode)simpleNode.jjtGetChild((int)n4)).id != 48) continue;
                    n6 = n4;
                }
                n4 = this.replaceVar(string, aSTTripleAtom, simpleNode.jjtGetChild(n6), simpleNode, n6) ? 1 : 0;
                ASTSelectClause aSTSelectClause = (ASTSelectClause)simpleNode.jjtGetChild(n5);
                ASTSelectQuery aSTSelectQuery = (ASTSelectQuery)simpleNode;
                if (n4) {
                    if (aSTSelectQuery.getselDesc().getSelectAll()) {
                        List<String> list = aSTSelectQuery.getselDesc().getSelectList();
                        aSTSelectClause.jjtSetInitCapacity(list.size());
                        int n7 = 0;
                        for (String object : list) {
                            ASTTripleAtom aSTTripleAtom2 = new ASTTripleAtom(73);
                            aSTTripleAtom2.type = 0;
                            aSTTripleAtom2.name = object;
                            aSTSelectClause.jjtAddChild(aSTTripleAtom2, n7);
                            aSTTripleAtom2.jjtSetParent(aSTSelectClause);
                            ++n7;
                        }
                        aSTSelectQuery.getselDesc().setSelectAll(false);
                    }
                    for (n3 = 0; n3 < aSTSelectClause.jjtGetNumChildren(); ++n3) {
                        SimpleNode simpleNode2 = (SimpleNode)aSTSelectClause.jjtGetChild(n3);
                        if (simpleNode2.id != 73 || ((ASTTripleAtom)simpleNode2).type != 0 || !string.equals(((ASTTripleAtom)simpleNode2).name.toUpperCase())) continue;
                        ASTSelectExpression aSTSelectExpression = new ASTSelectExpression(9);
                        ASTTripleAtom aSTTripleAtom3 = (ASTTripleAtom)aSTTripleAtom.cloneNode();
                        aSTTripleAtom3.jjtSetParent(aSTSelectExpression);
                        aSTSelectExpression.jjtAddChild(aSTTripleAtom3, 0);
                        simpleNode2.jjtSetParent(aSTSelectExpression);
                        aSTSelectExpression.jjtAddChild(simpleNode2, 1);
                        aSTSelectClause.jjtAddChild(aSTSelectExpression, n3);
                        aSTSelectExpression.jjtSetParent(aSTSelectClause);
                    }
                }
                for (n3 = 0; n3 < aSTSelectClause.jjtGetNumChildren(); ++n3) {
                    SimpleNode simpleNode3 = (SimpleNode)aSTSelectClause.jjtGetChild(n3);
                    if (simpleNode3.id != 9 || !this.replaceVar(string, aSTTripleAtom, simpleNode3.jjtGetChild(0), simpleNode3, 0)) continue;
                    n4 = 1;
                }
                if (n4) {
                    SparqlSelectDescriptor sparqlSelectDescriptor = new SparqlSelectDescriptor();
                    SparqlSelectDescriptor sparqlSelectDescriptor2 = aSTSelectQuery.getselDesc();
                    sparqlSelectDescriptor.setIsTopSelect(sparqlSelectDescriptor2.getIsTopSelect());
                    sparqlSelectDescriptor.setSelectModifier(sparqlSelectDescriptor2.getSelectModifier());
                    sparqlSelectDescriptor.setSelectAll(sparqlSelectDescriptor2.getSelectAll());
                    sparqlSelectDescriptor.setFromConstruct(sparqlSelectDescriptor2.isFromConstruct());
                    sparqlSelectDescriptor.setDescribeAll(sparqlSelectDescriptor2.isDescribeAll());
                    sparqlSelectDescriptor.setHasExpression();
                    sparqlSelectDescriptor.populateSelDesc(aSTSelectQuery, false);
                    aSTSelectQuery.setselDesc(sparqlSelectDescriptor);
                }
                return n4 != 0;
            }
        } else if (!OptimizerUtils.isExistsNode(simpleNode) && simpleNode.id != 54 && simpleNode.id != 55 && simpleNode.id != 13 && simpleNode.id != 24) {
            boolean bl = false;
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                if (!this.replaceVar(string, aSTTripleAtom, simpleNode.jjtGetChild(i), simpleNode, i)) continue;
                bl = true;
            }
            return bl;
        }
        return false;
    }

    private void getNonReplaceableVars(Set<String> set, Node node) {
        SimpleNode simpleNode = (SimpleNode)node;
        if (OptimizerUtils.isExistsNode(simpleNode) || this.isProblematicSelect(simpleNode) || simpleNode.id == 54 || simpleNode.id == 55 || simpleNode.id == 13 || simpleNode.id == 24) {
            HashSet<String> hashSet = new HashSet<String>();
            this.getAllVars(node, hashSet);
            set.addAll(hashSet);
        } else {
            int n = simpleNode.jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                this.getNonReplaceableVars(set, simpleNode.jjtGetChild(i));
            }
        }
    }

    private boolean isProblematicSelect(SimpleNode simpleNode) {
        boolean bl = false;
        if (simpleNode.id == 7) {
            ASTSelectQuery aSTSelectQuery = (ASTSelectQuery)simpleNode;
            if (aSTSelectQuery.getselDesc().containsAggregate()) {
                bl = true;
            } else if (aSTSelectQuery.getsolnMod().hasLimit() || aSTSelectQuery.getsolnMod().hasOffset() || aSTSelectQuery.getsolnMod().hasHaving()) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean isNWFOvar(String string, Node node, boolean bl) {
        SimpleNode simpleNode = (SimpleNode)node;
        boolean bl2 = bl || simpleNode.id == 50;
        boolean bl3 = false;
        if (bl2) {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < simpleNode.jjtGetNumChildren() && !bl3; ++i) {
                Node node2 = simpleNode.jjtGetChild(i);
                if (this.isGpntOpt(node2)) {
                    HashSet<String> hashSet2 = new HashSet<String>();
                    this.getAllVars(node2, hashSet2);
                    if (!hashSet2.contains(string) || hashSet.contains(string)) continue;
                    bl3 = true;
                    continue;
                }
                this.getBoundVars(hashSet, node2, null);
                if (!this.isNWFOvar(string, simpleNode.jjtGetChild(i), true)) continue;
                bl3 = true;
            }
        } else {
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                bl3 = bl3 || this.isNWFOvar(string, simpleNode.jjtGetChild(i), false);
            }
        }
        return bl3;
    }

    private void getAllVars(Node node, Set<String> set) {
        if (((SimpleNode)node).id == 73 && ((ASTTripleAtom)node).type == 0) {
            set.add(((ASTTripleAtom)node).name.toUpperCase());
        } else {
            int n = node.jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                this.getAllVars(node.jjtGetChild(i), set);
            }
        }
    }

    private void getBoundVars(Set<String> set, Node node, Set<String> set2) {
        block9: {
            int n;
            SimpleNode simpleNode;
            block8: {
                simpleNode = (SimpleNode)node;
                n = simpleNode.jjtGetNumChildren();
                if (simpleNode.id != 73 || ((ASTTripleAtom)simpleNode).type != 0) break block8;
                String string = ((ASTTripleAtom)simpleNode).name.toUpperCase();
                if (set2 != null && !set2.contains(string)) break block9;
                set.add(string);
                break block9;
            }
            if (simpleNode.id == 7) {
                if (set2 == null) {
                    set2 = new HashSet<String>();
                    set2.addAll(OptimizerUtils.collectVisibleVarNames(simpleNode));
                } else {
                    set2.retainAll(OptimizerUtils.collectVisibleVarNames(simpleNode));
                }
                for (int i = 0; i < n; ++i) {
                    if (((SimpleNode)simpleNode.jjtGetChild((int)i)).id != 48) continue;
                    this.getBoundVars(set, simpleNode.jjtGetChild(i), set2);
                }
            } else if (simpleNode.id != 50 && !OptimizerUtils.isExistsNode(simpleNode) && simpleNode.id != 54 && simpleNode.id != 55 && simpleNode.id != 13 && simpleNode.id != 24 && simpleNode.id != 56) {
                for (int i = 0; i < n; ++i) {
                    HashSet<String> hashSet = null;
                    if (set2 != null) {
                        hashSet = new HashSet<String>();
                        hashSet.addAll(set2);
                    }
                    this.getBoundVars(set, simpleNode.jjtGetChild(i), hashSet);
                }
            }
        }
    }

    private boolean isGpntOpt(Node node) {
        boolean bl = false;
        if (((SimpleNode)node).id == 49 && node.jjtGetNumChildren() == 1 && ((SimpleNode)node.jjtGetChild((int)0)).id == 50) {
            bl = true;
        }
        return bl;
    }
}

