/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SelectExpression;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTAggregate;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphPatternNotTriples;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupClause;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupCondition;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTHavingClause;
import oracle.spatial.rdf.server.parser.sparql.ASTHavingCondition;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectClause;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTSolutionModifier;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class CntDistStarRewriteOptimizer
implements SparqlQueryOptimizer {
    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        int n;
        if (((SimpleNode)node).id == 7) {
            Object object;
            ASTSelectQuery aSTSelectQuery = (ASTSelectQuery)node;
            n = 0;
            if (aSTSelectQuery.getsolnMod().hasHaving() && (object = aSTSelectQuery.getsolnMod().getHavingTree()) != null && CntDistStarRewriteOptimizer.containsDistinctStarAgg((Node)object)) {
                n = 1;
            }
            if (n == 0) {
                for (SelectExpression selectExpression : aSTSelectQuery.getselDesc().getSelectExpressions()) {
                    if (selectExpression.getExprTree() == null || !CntDistStarRewriteOptimizer.containsDistinctStarAgg(selectExpression.getExprTree())) continue;
                    n = 1;
                }
            }
            if (n != 0) {
                this.rewriteSelQuery(aSTSelectQuery);
            }
        } else if (CntDistStarRewriteOptimizer.isDistinctStarAgg(node)) {
            throw new RDFException("Aggregate COUNT(DISTINCT *) not supported in this position");
        }
        int n2 = ((SimpleNode)node).jjtGetNumChildren();
        for (n = 0; n < n2; ++n) {
            this.optimizeQuery((SimpleNode)node.jjtGetChild(n));
        }
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rewriteSelQuery(ASTSelectQuery aSTSelectQuery) throws RDFException, ParseException {
        Object object;
        boolean bl = false;
        if (aSTSelectQuery.getsolnMod().hasHaving() && (object = aSTSelectQuery.getsolnMod().getHavingTree()) != null && !CntDistStarRewriteOptimizer.isDistinctStarCompatible((Node)object)) {
            bl = true;
        }
        if (!bl) {
            for (SelectExpression selectExpression : aSTSelectQuery.getselDesc().getSelectExpressions()) {
                if (selectExpression.getExprTree() == null || CntDistStarRewriteOptimizer.isDistinctStarCompatible(selectExpression.getExprTree())) continue;
                bl = true;
            }
        }
        if (bl) {
            object = new ASTGraphPatternNotTriples(49);
            ASTGroupGraphPattern aSTGroupGraphPattern = new ASTGroupGraphPattern(48);
            ASTSelectQuery aSTSelectQuery2 = new ASTSelectQuery(7);
            aSTGroupGraphPattern.jjtAddChild(aSTSelectQuery2, 0);
            aSTSelectQuery2.jjtSetParent(aSTGroupGraphPattern);
            ((SimpleNode)object).jjtAddChild(aSTGroupGraphPattern, 0);
            aSTGroupGraphPattern.jjtSetParent((Node)object);
            int n = 0;
            ASTSelectClause aSTSelectClause = new ASTSelectClause(8);
            aSTSelectQuery2.jjtAddChild(aSTSelectClause, n++);
            aSTSelectClause.jjtSetParent(aSTSelectQuery2);
            int n2 = 0;
            ASTSolutionModifier aSTSolutionModifier = new ASTSolutionModifier(13);
            int n3 = 0;
            ASTGraphPatternNotTriples aSTGraphPatternNotTriples = new ASTGraphPatternNotTriples(49);
            ASTGroupGraphPattern aSTGroupGraphPattern2 = new ASTGroupGraphPattern(48);
            ASTSelectQuery aSTSelectQuery3 = new ASTSelectQuery(7);
            aSTGroupGraphPattern2.jjtAddChild(aSTSelectQuery3, 0);
            aSTSelectQuery3.jjtSetParent(aSTGroupGraphPattern2);
            aSTGraphPatternNotTriples.jjtAddChild(aSTGroupGraphPattern2, 0);
            aSTGroupGraphPattern2.jjtSetParent(aSTGraphPatternNotTriples);
            int n4 = 0;
            ASTSelectClause aSTSelectClause2 = new ASTSelectClause(8);
            aSTSelectQuery3.jjtAddChild(aSTSelectClause2, n4++);
            aSTSelectClause2.jjtSetParent(aSTSelectQuery3);
            int n5 = 0;
            ASTSolutionModifier aSTSolutionModifier2 = new ASTSolutionModifier(13);
            int n6 = 0;
            ASTGroupGraphPattern aSTGroupGraphPattern3 = new ASTGroupGraphPattern(48);
            aSTGroupGraphPattern3.jjtAddChild((Node)object, 0);
            ((SimpleNode)object).jjtSetParent(aSTGroupGraphPattern3);
            aSTGroupGraphPattern3.jjtAddChild(aSTGraphPatternNotTriples, 1);
            aSTGraphPatternNotTriples.jjtSetParent(aSTGroupGraphPattern3);
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            for (int i = 0; i < aSTSelectQuery.jjtGetNumChildren(); ++i) {
                Object object2;
                SimpleNode simpleNode;
                if (((SimpleNode)aSTSelectQuery.jjtGetChild((int)i)).id == 8) {
                    simpleNode = (ASTSelectClause)aSTSelectQuery.jjtGetChild(i);
                    for (int j = 0; j < simpleNode.jjtGetNumChildren(); ++j) {
                        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(j);
                        object2 = null;
                        boolean bl2 = false;
                        if (simpleNode2.id == 9) {
                            SimpleNode simpleNode3 = (SimpleNode)simpleNode2.jjtGetChild(0);
                            object2 = (ASTTripleAtom)simpleNode2.jjtGetChild(1);
                            if (CntDistStarRewriteOptimizer.containsDistinctStarAgg(simpleNode3)) {
                                if (!CntDistStarRewriteOptimizer.isDistinctStarCompatible(simpleNode3)) throw new RDFException("COUNT(DISTINCT *) not supported together with specified aggregate, please rewrite your query");
                                CntDistStarRewriteOptimizer.removeDistinctStar(simpleNode3);
                                aSTSelectQuery3.getselDesc().setHasExpression();
                                bl2 = true;
                            } else {
                                aSTSelectQuery2.getselDesc().setHasExpression();
                            }
                        } else {
                            object2 = (ASTTripleAtom)simpleNode2;
                        }
                        if (bl2) {
                            aSTSelectClause2.jjtAddChild(simpleNode2, n5++);
                            simpleNode2.jjtSetParent(aSTSelectClause2);
                            hashSet.add(((ASTTripleAtom)object2).name);
                        } else {
                            aSTSelectClause.jjtAddChild(simpleNode2, n2++);
                            simpleNode2.jjtSetParent(aSTSelectClause);
                            hashSet2.add(((ASTTripleAtom)object2).name);
                        }
                        simpleNode.jjtAddChild(((SimpleNode)object2).cloneSubTree(), j);
                    }
                    for (SelectExpression selectExpression : aSTSelectQuery.getselDesc().getSelectExpressions()) {
                        if (selectExpression.getExprTree() == null) continue;
                        selectExpression.setExprTree(null);
                    }
                    continue;
                }
                if (((SimpleNode)aSTSelectQuery.jjtGetChild((int)i)).id == 48) {
                    simpleNode = (ASTGroupGraphPattern)aSTSelectQuery.jjtGetChild(i);
                    aSTSelectQuery.jjtAddChild(aSTGroupGraphPattern3, i);
                    aSTGroupGraphPattern3.jjtSetParent(aSTSelectQuery);
                    aSTSelectQuery2.jjtAddChild(simpleNode, n++);
                    simpleNode.jjtSetParent(aSTSelectQuery2);
                    ASTGroupGraphPattern aSTGroupGraphPattern4 = (ASTGroupGraphPattern)simpleNode.cloneSubTree();
                    ASTSelectQuery aSTSelectQuery4 = new ASTSelectQuery(7);
                    aSTSelectQuery4.jjtAddChild(aSTGroupGraphPattern4, 1);
                    aSTGroupGraphPattern4.jjtSetParent(aSTSelectQuery4);
                    CntDistStarRewriteOptimizer.populateSelectDistinctStar(aSTSelectQuery4);
                    object2 = new ASTGroupGraphPattern(48);
                    ((SimpleNode)object2).jjtAddChild(aSTSelectQuery4, 0);
                    aSTSelectQuery4.jjtSetParent((Node)object2);
                    aSTSelectQuery3.jjtAddChild((Node)object2, n4++);
                    ((SimpleNode)object2).jjtSetParent(aSTSelectQuery3);
                    continue;
                }
                if (((SimpleNode)aSTSelectQuery.jjtGetChild((int)i)).id != 13) continue;
                simpleNode = (ASTSolutionModifier)aSTSelectQuery.jjtGetChild(i);
                for (int j = simpleNode.jjtGetNumChildren() - 1; j >= 0; --j) {
                    Object object3;
                    Object object4;
                    int n7;
                    if (((SimpleNode)simpleNode.jjtGetChild((int)j)).id == 14) {
                        if (!aSTSelectQuery2.getsolnMod().solnModExists()) {
                            aSTSelectQuery2.jjtAddChild(aSTSolutionModifier, n++);
                            aSTSolutionModifier.jjtSetParent(aSTSelectQuery2);
                            aSTSelectQuery2.getsolnMod().setSolnModExists(true);
                        }
                        ASTGroupClause aSTGroupClause = new ASTGroupClause(14);
                        aSTSolutionModifier.jjtAddChild(aSTGroupClause, n3++);
                        aSTGroupClause.jjtSetParent(aSTSolutionModifier);
                        if (!aSTSelectQuery3.getsolnMod().solnModExists()) {
                            aSTSelectQuery3.jjtAddChild(aSTSolutionModifier2, n4++);
                            aSTSolutionModifier2.jjtSetParent(aSTSelectQuery3);
                            aSTSelectQuery3.getsolnMod().setSolnModExists(true);
                        }
                        object2 = new ASTGroupClause(14);
                        aSTSolutionModifier2.jjtAddChild((Node)object2, n6);
                        ((SimpleNode)object2).jjtSetParent(aSTSolutionModifier2);
                        int n8 = 1;
                        Node node = simpleNode.jjtGetChild(j);
                        int n9 = node.jjtGetNumChildren();
                        for (n7 = 0; n7 < n9; ++n7) {
                            ASTTripleAtom aSTTripleAtom;
                            SimpleNode simpleNode4;
                            object4 = (ASTGroupCondition)node.jjtGetChild(n7);
                            object3 = "";
                            if (((SimpleNode)object4).jjtGetNumChildren() == 1) {
                                if (((SimpleNode)((SimpleNode)object4).jjtGetChild((int)0)).id != 73) {
                                    simpleNode4 = new ASTTripleAtom(73);
                                    ((ASTTripleAtom)simpleNode4).type = 0;
                                    ((ASTTripleAtom)simpleNode4).name = "G$" + n8++;
                                    object3 = ((ASTTripleAtom)simpleNode4).name;
                                    ((SimpleNode)object4).jjtAddChild(simpleNode4, 1);
                                } else {
                                    object3 = ((ASTTripleAtom)((SimpleNode)object4).jjtGetChild((int)0)).name;
                                }
                            } else {
                                object3 = ((ASTTripleAtom)((SimpleNode)object4).jjtGetChild((int)1)).name;
                            }
                            aSTGroupClause.jjtAddChild((Node)object4, n7);
                            ((SimpleNode)object4).jjtSetParent(aSTGroupClause);
                            simpleNode4 = (ASTGroupCondition)((SimpleNode)object4).cloneSubTree();
                            ((SimpleNode)object2).jjtAddChild(simpleNode4, n7);
                            simpleNode4.jjtSetParent((Node)object2);
                            if (!hashSet2.contains(object3)) {
                                aSTTripleAtom = new ASTTripleAtom(73);
                                aSTTripleAtom.type = 0;
                                aSTTripleAtom.name = object3;
                                aSTSelectClause.jjtAddChild(aSTTripleAtom, n2++);
                            }
                            if (hashSet.contains(object3)) continue;
                            aSTTripleAtom = new ASTTripleAtom(73);
                            aSTTripleAtom.type = 0;
                            aSTTripleAtom.name = object3;
                            aSTSelectClause2.jjtAddChild(aSTTripleAtom, n5++);
                        }
                        simpleNode.jjtRemoveChild(j);
                        aSTSelectQuery.getsolnMod().setGroupByConds(new ArrayList<SelectExpression>());
                        if (simpleNode.jjtGetNumChildren() != 0) continue;
                        aSTSelectQuery.jjtRemoveChild(i);
                        aSTSelectQuery.getsolnMod().setSolnModExists(false);
                        continue;
                    }
                    if (((SimpleNode)simpleNode.jjtGetChild((int)j)).id != 16) continue;
                    ASTHavingClause aSTHavingClause = (ASTHavingClause)simpleNode.jjtGetChild(j);
                    object2 = new ArrayList();
                    for (int k = 0; k < aSTHavingClause.jjtGetNumChildren(); ++k) {
                        SimpleNode simpleNode5 = (SimpleNode)aSTHavingClause.jjtGetChild(k);
                        if (((SimpleNode)simpleNode5.jjtGetChild((int)0)).id == 79) {
                            SimpleNode simpleNode6 = (SimpleNode)simpleNode5.jjtGetChild(0);
                            for (n7 = simpleNode6.jjtGetNumChildren() - 1; n7 >= 0; --n7) {
                                object4 = new ASTHavingCondition(17);
                                ((SimpleNode)object4).jjtAddChild(simpleNode6.jjtGetChild(n7), 0);
                                simpleNode6.jjtGetChild(n7).jjtSetParent((Node)object4);
                                object2.add(object4);
                            }
                            continue;
                        }
                        object2.add(simpleNode5);
                    }
                    ASTHavingClause aSTHavingClause2 = null;
                    int n10 = 0;
                    ASTHavingClause aSTHavingClause3 = null;
                    n7 = 0;
                    object4 = object2.iterator();
                    while (object4.hasNext()) {
                        object3 = (Node)object4.next();
                        if (CntDistStarRewriteOptimizer.containsDistinctStarAgg((Node)object3)) {
                            if (!CntDistStarRewriteOptimizer.isDistinctStarCompatible((Node)object3)) throw new RDFException("COUNT(DISTINCT *) not supported together with specified aggregate, please rewrite your query");
                            if (!aSTSelectQuery3.getsolnMod().solnModExists()) {
                                aSTSelectQuery3.jjtAddChild(aSTSolutionModifier2, n4++);
                                aSTSelectQuery3.getsolnMod().setSolnModExists(true);
                            }
                            if (n7 == 0) {
                                aSTHavingClause3 = new ASTHavingClause(16);
                                aSTSolutionModifier2.jjtAddChild(aSTHavingClause3, n6++);
                                aSTHavingClause3.jjtSetParent(aSTSolutionModifier2);
                            }
                            aSTHavingClause3.jjtAddChild((Node)object3, n7++);
                            object3.jjtSetParent(aSTHavingClause3);
                            CntDistStarRewriteOptimizer.removeDistinctStar((Node)object3);
                            continue;
                        }
                        if (!aSTSelectQuery2.getsolnMod().solnModExists()) {
                            aSTSelectQuery2.jjtAddChild(aSTSolutionModifier, n++);
                            aSTSelectQuery2.getsolnMod().setSolnModExists(true);
                        }
                        if (n10 == 0) {
                            aSTHavingClause2 = new ASTHavingClause(16);
                            aSTSolutionModifier.jjtAddChild(aSTHavingClause2, n3++);
                            aSTHavingClause2.jjtSetParent(aSTSolutionModifier);
                        }
                        aSTHavingClause2.jjtAddChild((Node)object3, n10++);
                        object3.jjtSetParent(aSTHavingClause2);
                    }
                    simpleNode.jjtRemoveChild(j);
                    aSTSelectQuery.getsolnMod().setHavingCond(null, false);
                    aSTSelectQuery.getsolnMod().setHavingTree(null);
                    if (simpleNode.jjtGetNumChildren() != 0) continue;
                    aSTSelectQuery.jjtRemoveChild(i);
                    aSTSelectQuery.getsolnMod().setSolnModExists(false);
                }
            }
            aSTSelectQuery2.getselDesc().populateSelDesc(aSTSelectQuery2, false);
            aSTSelectQuery3.getselDesc().populateSelDesc(aSTSelectQuery3, false);
            aSTSelectQuery2.getsolnMod().populateSolnMod(aSTSelectQuery2);
            aSTSelectQuery3.getsolnMod().populateSolnMod(aSTSelectQuery3);
            aSTSelectQuery.getselDesc().setHasAggregate(false);
            return;
        }
        CntDistStarRewriteOptimizer.removeDistinctStarFromSelect(aSTSelectQuery);
        object = new ASTSelectQuery(7);
        ASTGroupGraphPattern aSTGroupGraphPattern = new ASTGroupGraphPattern(48);
        aSTGroupGraphPattern.jjtAddChild((Node)object, 0);
        ((SimpleNode)object).jjtSetParent(aSTGroupGraphPattern);
        int n = aSTSelectQuery.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            if (((SimpleNode)aSTSelectQuery.jjtGetChild((int)i)).id != 48) continue;
            ASTGroupGraphPattern aSTGroupGraphPattern5 = (ASTGroupGraphPattern)aSTSelectQuery.jjtGetChild(i);
            ((SimpleNode)object).jjtAddChild(aSTGroupGraphPattern5, 1);
            aSTGroupGraphPattern5.jjtSetParent((Node)object);
            aSTSelectQuery.jjtAddChild(aSTGroupGraphPattern, i);
            aSTGroupGraphPattern.jjtSetParent(aSTSelectQuery);
        }
        CntDistStarRewriteOptimizer.populateSelectDistinctStar((ASTSelectQuery)object);
    }

    private static boolean isDistinctStarAgg(Node node) {
        boolean bl = false;
        if (((SimpleNode)node).id == 89 && !((ASTAggregate)node).distinct.equals("") && ((ASTAggregate)node).modifier.equals("*")) {
            bl = true;
        }
        return bl;
    }

    private static boolean containsDistinctStarAgg(Node node) {
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        boolean bl = false;
        while (!bl && !stack.isEmpty()) {
            Node node2 = (Node)stack.pop();
            if (CntDistStarRewriteOptimizer.isDistinctStarAgg(node2)) {
                bl = true;
            }
            for (int i = node2.jjtGetNumChildren() - 1; i >= 0; --i) {
                stack.push(node2.jjtGetChild(i));
            }
        }
        return bl;
    }

    private static boolean isDistStarCompatibleAgg(Node node) {
        boolean bl = true;
        if (((SimpleNode)node).id == 89) {
            ASTAggregate aSTAggregate = (ASTAggregate)node;
            if (!(!aSTAggregate.distinct.equals("") && aSTAggregate.modifier.equals("*") || aSTAggregate.name.equals("MAX") || aSTAggregate.name.equals("MIN"))) {
                bl = false;
            }
        }
        return bl;
    }

    private static boolean isDistinctStarCompatible(Node node) {
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        boolean bl = true;
        while (bl && !stack.isEmpty()) {
            Node node2 = (Node)stack.pop();
            if (!CntDistStarRewriteOptimizer.isDistStarCompatibleAgg(node2)) {
                bl = false;
            }
            for (int i = node2.jjtGetNumChildren() - 1; i >= 0; --i) {
                stack.push(node2.jjtGetChild(i));
            }
        }
        return bl;
    }

    private static void populateSelectDistinctStar(ASTSelectQuery aSTSelectQuery) {
        aSTSelectQuery.getselDesc().setSelectModifier(1);
        aSTSelectQuery.getselDesc().setSelectAll(true);
        HashSet<ASTTripleAtom> hashSet = new HashSet<ASTTripleAtom>();
        hashSet.addAll(OptimizerUtils.collectVisibleVars(aSTSelectQuery.jjtGetChild(1)));
        ASTSelectClause aSTSelectClause = OptimizerUtils.genSelectClause(hashSet, null);
        aSTSelectQuery.jjtAddChild(aSTSelectClause, 0);
        aSTSelectClause.jjtSetParent(aSTSelectQuery);
        aSTSelectQuery.getselDesc().populateSelDesc(aSTSelectQuery, false);
    }

    private static void removeDistinctStar(Node node) {
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        while (!stack.isEmpty()) {
            Node node2 = (Node)stack.pop();
            if (CntDistStarRewriteOptimizer.isDistinctStarAgg(node2)) {
                ((ASTAggregate)node2).distinct = "";
            }
            for (int i = node2.jjtGetNumChildren() - 1; i >= 0; --i) {
                stack.push(node2.jjtGetChild(i));
            }
        }
    }

    private static void removeDistinctStarFromSelect(ASTSelectQuery aSTSelectQuery) {
        for (SelectExpression selectExpression : aSTSelectQuery.getselDesc().getSelectExpressions()) {
            if (selectExpression.getExprTree() == null) continue;
            CntDistStarRewriteOptimizer.removeDistinctStar(selectExpression.getExprTree());
        }
        if (aSTSelectQuery.getsolnMod().hasHaving() && aSTSelectQuery.getsolnMod().getHavingTree() != null) {
            CntDistStarRewriteOptimizer.removeDistinctStar(aSTSelectQuery.getsolnMod().getHavingTree());
        }
        int n = aSTSelectQuery.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            if (((SimpleNode)aSTSelectQuery.jjtGetChild((int)i)).id == 8) {
                CntDistStarRewriteOptimizer.removeDistinctStar(aSTSelectQuery.jjtGetChild(i));
                continue;
            }
            if (((SimpleNode)aSTSelectQuery.jjtGetChild((int)i)).id != 13) continue;
            Node node = aSTSelectQuery.jjtGetChild(i);
            for (int j = 0; j < node.jjtGetNumChildren(); ++j) {
                if (((SimpleNode)node.jjtGetChild((int)j)).id != 16) continue;
                CntDistStarRewriteOptimizer.removeDistinctStar(node.jjtGetChild(j));
            }
        }
    }
}

