/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.spatial.rdf.server.PPNode;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public abstract class AbstractPPNode
implements PPNode {
    protected PPNode parent = null;
    protected List<PPNode> children = new ArrayList<PPNode>();
    protected int direction = 0;
    protected Set<ASTTripleAtom> sNodes = null;
    protected Set<ASTTripleAtom> tNodes = null;

    @Override
    public void addChild(PPNode pPNode) {
        this.children.add(pPNode);
    }

    @Override
    public int getNumChildren() {
        return this.children.size();
    }

    @Override
    public PPNode getChild(int n) {
        return this.children.get(n);
    }

    @Override
    public void setParent(PPNode pPNode) {
        this.parent = pPNode;
    }

    @Override
    public PPNode getParent() {
        return this.parent;
    }

    @Override
    public void setDirection(int n) {
        this.direction = n;
    }

    @Override
    public int getDirection() {
        return this.direction;
    }

    @Override
    public void setStartNodes(Set<ASTTripleAtom> set) {
        this.sNodes = set;
        for (int i = 0; i < this.getNumChildren(); ++i) {
            if (this.getDirection() == 0) {
                this.getChild(i).setStartNodes(set);
                continue;
            }
            this.getChild(i).setEndNodes(set);
        }
    }

    @Override
    public boolean hasConstrainedStart() {
        return this.sNodes != null;
    }

    @Override
    public Set<ASTTripleAtom> getStartNodes() {
        return this.sNodes;
    }

    @Override
    public void setEndNodes(Set<ASTTripleAtom> set) {
        this.tNodes = set;
        for (int i = 0; i < this.getNumChildren(); ++i) {
            if (this.getDirection() == 0) {
                this.getChild(i).setEndNodes(set);
                continue;
            }
            this.getChild(i).setStartNodes(set);
        }
    }

    @Override
    public boolean hasConstrainedEnd() {
        return this.tNodes != null;
    }

    @Override
    public Set<ASTTripleAtom> getEndNodes() {
        return this.tNodes;
    }

    @Override
    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + this.getClass().getName() + ": Direction [" + this.direction + "]\n";
        if (this.hasConstrainedStart()) {
            string2 = string2 + string + "START [" + this.getStartNodes().toString() + "]\n";
        }
        if (this.hasConstrainedEnd()) {
            string2 = string2 + string + "End [" + this.getEndNodes().toString() + "]\n";
        }
        for (int i = 0; i < this.getNumChildren(); ++i) {
            string2 = string2 + this.getChild(i).toString(string + "  ") + "\n";
        }
        return string2;
    }
}

