/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.managers;

import java.util.Date;
import java.util.Vector;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.ViewStyleHandle;
import oracle.dss.dataView.managers.RuleManager;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewDatabodyStyleManager;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.ResolutionService;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.RuleContext;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.QDR;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.WaitData;
import oracle.dss.util.xml.ObjectNode;

public class GridViewDatabodyRuleStyles
extends RuleManager
implements Cloneable,
GridViewDatabodyStyleManager {
    public static final String DATABODY_STYLE_MANAGER_NAME = "DatabodyStyleManager";
    protected transient DataComponentInfo dinfo = new DataComponentInfo(0, 0);
    private static final String m_method_getDataStyle = "ViewStyle getDataStyle(GridViewCommon view, Object data, ViewStyle initStyle, int row, int column, int[] pageHPos)";

    public void dataSourceChanged() {
        this.dataStyleChanged();
    }

    @Override
    public void dataStyleChanged() {
    }

    @Override
    public ViewStyle getDataStyle(GridViewCommon view, Object data, ViewStyle initStyle, int row, int column, int[] pageHPos) {
        if (view.getWaitDataForRow(row) != null) {
            return null;
        }
        if (view.isDataViewStyleSupported()) {
            Object obj = null;
            try {
                obj = view.getModel().getDataAccess().getValue(row, column, "dataViewStyle");
            }
            catch (ColumnOutOfRangeException coore) {
                view.getErrorHandler().log("column out of range", this.getClass().getName(), m_method_getDataStyle);
            }
            catch (RowOutOfRangeException roore) {
                view.getErrorHandler().log("row out of range", this.getClass().getName(), m_method_getDataStyle);
            }
            ViewStyleHandle vsHandle = null;
            if (obj != null) {
                if (obj instanceof ViewStyleHandle) {
                    vsHandle = (ViewStyleHandle)obj;
                } else {
                    if (obj instanceof WaitData) {
                        view.setWaitDataForRow(row, (WaitData)obj);
                        return null;
                    }
                    view.getErrorHandler().log("object not ViewStyleHandle type", this.getClass().getName(), m_method_getDataStyle);
                }
            }
            if (vsHandle != null) {
                if (vsHandle.getViewStyle() != null) {
                    initStyle = (ViewStyle)initStyle.clone();
                    initStyle.merge((Mergeable)vsHandle.getViewStyle());
                }
                if (vsHandle.getRunRulesForViewStyle() == 0) {
                    return initStyle;
                }
            }
        }
        this.dinfo.setRowCol(row, column);
        RuleContext location = new RuleContext();
        String type = data instanceof Number ? "NUMBER_VALUE" : (data instanceof Date ? "DATE_VALUE" : "STRING_VALUE");
        location.put((Object)"POSITION", (Object)this.dinfo);
        location.put((Object)"COMPONENT_TYPE", (Object)9);
        if (data != null) {
            location.put((Object)type, data);
        }
        if (view.getModel().getDataAccess() != null) {
            QDR valueQDR = this.dinfo.getQDR(view.getModel().getDataAccess(), 1);
            if (valueQDR != null) {
                location.put((Object)"QDR", (Object)valueQDR);
            }
            location.put((Object)"DATA_ACCESS", (Object)view.getModel().getDataAccess());
            if (view.isDataIsTotalSupported()) {
                try {
                    Object isTotalObj = view.getModel().getDataAccess().getValue(row, column, "dataIsTotal");
                    if (isTotalObj != null && isTotalObj instanceof Boolean) {
                        boolean bIsTotal = (Boolean)isTotalObj;
                        if (bIsTotal) {
                            location.put((Object)"TOTALS_RELATION", (Object)1);
                        } else {
                            location.put((Object)"TOTALS_RELATION", (Object)0);
                        }
                    }
                }
                catch (ColumnOutOfRangeException coore) {
                    view.getErrorHandler().log("column out of range: could not get ISTOTAL", this.getClass().getName(), m_method_getDataStyle);
                }
                catch (RowOutOfRangeException roore) {
                    view.getErrorHandler().log("row out of range: could not get ISTOTAL", this.getClass().getName(), m_method_getDataStyle);
                }
            }
        }
        if (initStyle == null) {
            return null;
        }
        Vector bundles = this.m_bundles;
        ViewStyle style = initStyle;
        try {
            if (bundles != null) {
                initStyle = style = (ViewStyle)ResolutionService.resolveRules((RuleContext)location, (Mergeable)initStyle, (Vector)bundles);
            }
            if (this.m_uiBundle != null && initStyle != null) {
                style = (ViewStyle)ResolutionService.resolveRules((RuleContext)location, (Mergeable)initStyle, (RuleBundle)this.m_uiBundle);
            }
        }
        catch (ClassCastException e) {
            return null;
        }
        if (style == null) {
            return null;
        }
        return style;
    }

    @Override
    public void setBundles(DataviewCommon view, Vector bundles) {
        super.setBundles(view, bundles);
        this.dataStyleChanged();
        if (view != null) {
            view.dataStyleChanged();
        }
    }

    public void setUIBundle(DataviewCommon view, RuleBundle UIBundle2) {
        super.setUIBundle(view, UIBundle2);
        this.dataStyleChanged();
        if (view != null) {
            view.dataStyleChanged();
        }
    }

    public ObjectNode getXML(boolean allProperties, DataviewCommon dataview) {
        return this.getXML(allProperties, DATABODY_STYLE_MANAGER_NAME, dataview);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        GridViewDatabodyRuleStyles newMgr = new GridViewDatabodyRuleStyles();
        newMgr.setBundles(null, this.m_bundles);
        if (this.getUIBundle() != null) {
            newMgr.setUIBundle(null, (RuleBundle)this.getUIBundle().clone());
        } else {
            newMgr.setUIBundle(null, null);
        }
        return newMgr;
    }
}

