/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.TextFieldInputHandler;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.dss.gridView.GridView;
import oracle.dss.gridView.GridViewAppearanceMgr;
import oracle.dss.util.DataException;
import oracle.dss.util.WaitData;

public class GridViewEdit
extends TextFieldInputHandler
implements TableEditListener,
Serializable {
    protected GridView gridView = null;
    private Cursor gridCursor = null;
    private static final String m_method_startedit = "startEdit(Grid grid, int column, int row, Object data)";
    private static final String m_method_canceledit = "cancelEdit(Grid grid, int column, int row)";
    private static final String m_method_mouseclicked = "mouseClicked(MouseEvent mouseEvent, Grid grid, int column, int row) ";
    private static final String m_method_keytyped = "keyTyped(KeyEvent e, Grid grid, int column, int row)";
    private static final String m_method_mousepressed = "mousePressed(MouseEvent mouseEvent, Grid grid, int column, int row)";
    private static final String m_method_mousemoved = "mouseMoved(MouseEvent e, Grid grid, int column, int row)";
    private static final String m_method_commitedit = "commitEdit(Grid grid, int column, int row)";

    protected GridViewEdit(GridView gv) {
        this.gridView = gv;
    }

    public void startEdit(Grid grid, int column, int row, Object data) {
        if (column < 0) {
            this.gridView.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_startedit);
            return;
        }
        if (row < 0) {
            this.gridView.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_startedit);
            return;
        }
        if (this.gridView.getWaitDataForRow(row) != null) {
            data = this.gridView.getWaitDataForRow(row).getCellMessage();
        } else if (this.gridView.isDataUnformattedSupported()) {
            try {
                data = this.gridView.getGridViewModel().getDataAccess().getValue(this.gridView.getGridViewModel().getDataFromTableRow(row), this.gridView.getGridViewModel().getDataFromTableCol(column), "dataValue");
                if (data != null) {
                    data = GridView.formatRawValue(this.gridView, data, this.gridView.getLocale());
                }
            }
            catch (DataException e) {
                this.gridView.getErrorHandler().error((Throwable)e, this.getClass().getName(), "startEdit");
            }
            if (data instanceof WaitData) {
                WaitData wd = (WaitData)data;
                this.gridView.setWaitDataForRow(row, wd);
                data = wd.getCellMessage();
            }
        }
        super.startEdit(grid, column, row, data);
    }

    public void cancelEdit(Grid grid, int column, int row) {
        if (column < 0) {
            this.gridView.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_canceledit);
            return;
        }
        if (row < 0) {
            this.gridView.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_canceledit);
            return;
        }
        super.cancelEdit(grid, column, row);
    }

    public void mouseClicked(MouseEvent mouseEvent, Grid grid, int column, int row) {
        if (column < 0) {
            this.gridView.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_mouseclicked);
            return;
        }
        if (row < 0) {
            this.gridView.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_mouseclicked);
            return;
        }
        if (mouseEvent.getClickCount() > 1) {
            grid.startCellEdit(column, row);
        }
        super.mouseClicked(mouseEvent, grid, column, row);
    }

    public void keyTyped(KeyEvent e, Grid grid, int column, int row) {
        if (column < 0) {
            this.gridView.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_keytyped);
            return;
        }
        if (row < 0) {
            this.gridView.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_keytyped);
            return;
        }
        if (e.getKeyChar() == '\t' || e.getKeyChar() == '\u001b' || e.getKeyChar() == '\n' || e.getKeyChar() == '\r') {
            super.keyTyped(e, grid, column, row);
        }
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int column, int row) {
        boolean requestAccepted;
        TwoDSelection selection;
        if (column < 0) {
            this.gridView.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_mousepressed);
            return;
        }
        if (row < 0) {
            this.gridView.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_mousepressed);
            return;
        }
        boolean consumed = false;
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.gridView.getDatabody().isDrillOut(column, row, mouseEvent.getX(), mouseEvent.getY())) {
                type = 1;
                imageIndex = ((GridViewAppearanceMgr)grid.getAppearanceManager()).getCellAppearance(column, row).getGraphicImageIndex();
                this.gridView.getGridViewModel().getGridViewControllerActions().databodyDrillOutGestureHappened(this.gridView, column, row, type, imageIndex);
                consumed = true;
            } else if (this.gridView.getDatabody().isAnnotation(column, row, mouseEvent.getX(), mouseEvent.getY())) {
                type = 2;
                imageIndex = -1;
                this.gridView.getGridViewModel().getGridViewControllerActions().databodyDrillOutGestureHappened(this.gridView, column, row, type, imageIndex);
                consumed = true;
            }
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent) && !(selection = grid.getSelection()).containsCell(column, row)) {
            grid.requestFocus();
            try {
                grid.deselectAll();
                TwoDSelection sel = new TwoDSelection(column, row);
                grid.setSelection(sel);
                grid.setFocusCell(new Cell(column, row));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (!consumed && SwingUtilities.isLeftMouseButton(mouseEvent) && !(requestAccepted = grid.requestFocus(column, row, (AWTEvent)mouseEvent))) {
            mouseEvent.consume();
        }
    }

    public void focusGained(AWTEvent why, Grid grid, int column, int row) {
    }

    public void mouseMoved(MouseEvent e, Grid grid, int column, int row) {
        if (column < 0) {
            this.gridView.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_mousemoved);
            return;
        }
        if (row < 0) {
            this.gridView.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_mousemoved);
            return;
        }
        Cursor drillCursor = this.gridView.getGridViewController().getCursorType(13);
        Cursor defaultCursor = this.gridView.getGridViewController().getCursorType(0);
        if (this.gridView.getDatabody().isDrillOut(column, row, e.getX(), e.getY()) || this.gridView.getDatabody().isAnnotation(column, row, e.getX(), e.getY())) {
            if (grid.getCursor() != drillCursor) {
                this.gridCursor = grid.getCursor();
                grid.setCursor(drillCursor);
            }
        } else if (grid.getCursor() == drillCursor) {
            if (this.gridCursor != null) {
                grid.setCursor(this.gridCursor);
            } else {
                grid.setCursor(defaultCursor);
            }
        }
        super.mouseMoved(e, grid, column, row);
    }

    public void cellEdited(TableEvent e) {
    }

    public void cellEditing(TableEvent e) {
        if (!this.gridView.getGridViewController().getGridViewSelectionManager().canEditCell(this.gridView.getGridViewModel().getDataFromTableRow(e.getCell().row), this.gridView.getGridViewModel().getDataFromTableCol(e.getCell().column))) {
            ((Cancelable)e).cancel();
        }
    }

    public Object commitEdit(Grid grid, int column, int row) {
        if (column < 0) {
            this.gridView.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_commitedit);
            return null;
        }
        if (row < 0) {
            this.gridView.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_commitedit);
            return null;
        }
        if (this.isDirty(grid, column, row)) {
            this.gridView.getDatabody().clearCache();
        }
        Object data = super.commitEdit(grid, column, row);
        try {
            if (this.gridView.isDataTypeSupported() && data instanceof String) {
                Object type = this.gridView.getGridViewModel().getDataAccess().getValue(row, column, "dataType");
                return GridView.parseFormattedValue(this.gridView, type, data.toString(), this.gridView.getLocale());
            }
        }
        catch (Exception e) {
            this.gridView.getErrorHandler().error((Throwable)e, this.getClass().getName(), m_method_commitedit);
        }
        return data;
    }
}

