/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.awt.Color;
import java.sql.Date;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.DimensionMetadata;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.ConditionElement;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.UIFormat;
import oracle.dss.rules.DiscriminatorRule;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.Rule;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.DateValueDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.NumberValueDiscriminator;
import oracle.dss.rules.discriminator.StringValueDiscriminator;
import oracle.dss.rules.discriminator.TotalsDiscriminator;
import oracle.dss.rules.discriminator.ValueDiscriminator;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;

public abstract class FormatModel {
    public static final int HEADER_TOOLBAR_FORMATS = 1;
    public static final int HEADER_EXCEPTION_FORMATS = 2;
    public static final int ALL_HEADER_FORMATS = 3;
    public static final int DATABODY_TOOLBAR_FORMATS = 4;
    public static final int CONDITIONAL_FORMATS = 8;
    public static final int STOPLIGHT_FORMATS = 16;
    public static final int ALL_DATABODY_FORMATS = 28;
    protected String m_defaultDateFormat = "dd-MMM-yyyy";
    protected ResourceBundle m_localStrings;
    protected ResourceBundle m_utilLocalStrings;
    protected GridViewCommon m_gridView;
    protected DateFormat m_dateFormat = null;
    protected NumberFormat m_numberFormat = null;
    protected List m_dimensionList = null;

    public abstract List getFormatList(int var1);

    public abstract List getFormatListByGroup(int var1);

    public abstract void setFormat(List var1, int var2, UIFormat var3);

    public abstract void addFormat(List var1, UIFormat var2);

    public abstract void addFormat(UIFormat var1);

    public abstract void applyFormat(UIFormat var1);

    public abstract UIFormat getLastFormat(int var1);

    public abstract void removeFormat(List var1, int var2);

    public abstract boolean hasPrevious(List var1, int var2, boolean var3);

    public abstract boolean hasNext(List var1, int var2, boolean var3);

    public abstract void moveUp(List var1, int var2, boolean var3);

    public abstract void moveDown(List var1, int var2, boolean var3);

    public abstract boolean apply();

    protected abstract void initFormats(GridViewCommon var1);

    public abstract void setUIFormats(boolean var1);

    public abstract void clearAllFormats();

    public FormatModel(GridViewCommon gridView) {
        this.setGridView(gridView);
    }

    public void setGridView(GridViewCommon gridView) {
        this.m_gridView = gridView;
        this.m_dateFormat = null;
        this.m_numberFormat = null;
        this.m_localStrings = null;
        this.m_utilLocalStrings = null;
        if (this.m_gridView != null) {
            this.setLocale(gridView.getLocale());
            this.initFormats(gridView);
        }
        this.establishBaseState();
        this.establishCheckpointState();
    }

    public GridViewCommon getGridView() {
        return this.m_gridView;
    }

    protected String getStoplightFormatName() {
        int count = this.m_gridView.getUIFormatCount() + 1;
        this.m_gridView.setUIFormatCount(count);
        return MessageFormat.format(this.getResourceString("StoplightFormat"), String.valueOf(count));
    }

    protected String getConditionalFormatName() {
        int count = this.m_gridView.getUIFormatCount() + 1;
        this.m_gridView.setUIFormatCount(count);
        return MessageFormat.format(this.getResourceString("ConditionalFormat"), String.valueOf(count));
    }

    protected String getHeaderFormatName() {
        int count = this.m_gridView.getUIFormatCount() + 1;
        this.m_gridView.setUIFormatCount(count);
        return MessageFormat.format(this.getResourceString("HeaderFormat"), String.valueOf(count));
    }

    protected String getSelectionFormatName() {
        int count = this.m_gridView.getToolbarUIFormatCount() + 1;
        this.m_gridView.setToolbarUIFormatCount(count);
        return MessageFormat.format(this.getResourceString("SelectionFormat"), String.valueOf(count));
    }

    public UIFormat createSelectionFormat() {
        UIFormat format = UIFormat.createDefaultDataSelection();
        format.setName(this.getSelectionFormatName());
        if (format.getViewFormat() != null) {
            format.getViewFormat().setLocale(this.getGridView().getLocale());
        }
        return format;
    }

    public UIFormat createHeaderSelectionFormat() {
        UIFormat format = UIFormat.createDefaultHeaderSelection();
        format.setName(this.getSelectionFormatName());
        if (format.getViewFormat() != null) {
            format.getViewFormat().setLocale(this.getGridView().getLocale());
        }
        return format;
    }

    public UIFormat createStoplightFormat() {
        UIFormat format = UIFormat.createStoplightFormat();
        format.setName(this.getStoplightFormatName());
        if (format.getViewFormat() != null) {
            format.getViewFormat().setLocale(this.getGridView().getLocale());
        }
        return format;
    }

    public UIFormat createSelectionStoplightFormat(String dataType) {
        UIFormat format = UIFormat.createToolbarStoplightFormat(dataType);
        format.setName(this.getStoplightFormatName());
        if (format.getViewFormat() != null) {
            format.getViewFormat().setLocale(this.getGridView().getLocale());
        }
        return format;
    }

    public UIFormat createHeaderExceptionFormat() {
        UIFormat format = UIFormat.createDefaultHeaderFormat();
        format.setName(this.getHeaderFormatName());
        if (format.getViewFormat() != null) {
            format.getViewFormat().setLocale(this.getGridView().getLocale());
        }
        return format;
    }

    public UIFormat createConditionalFormat() {
        UIFormat format = UIFormat.createDefaultConditionalFormat();
        format.setName(this.getConditionalFormatName());
        if (format.getViewFormat() != null) {
            format.getViewFormat().setLocale(this.getGridView().getLocale());
        }
        return format;
    }

    protected boolean addViewStyle(ArrayList list, RuleBundle bundle, UIFormat uiFormat) {
        if (bundle != null) {
            long id = uiFormat.getID();
            int count = bundle.getCount();
            for (int j = 0; j < count; ++j) {
                if (bundle.getRule(j).getID() != id) continue;
                DiscriminatorRule styleRule = (DiscriminatorRule)bundle.getRule(j);
                uiFormat.setViewStyle((ViewStyle)styleRule.getFixedMergeable());
                uiFormat.setDiscriminator(styleRule.getDiscriminator());
                if (uiFormat.getViewFormat() == null) {
                    ViewFormat vf = new ViewFormat();
                    vf.setLocale(this.getGridView().getLocale());
                    uiFormat.setViewFormat(vf);
                }
                list.add(uiFormat);
                return true;
            }
        }
        return false;
    }

    protected boolean addStoplight(ArrayList list, RuleBundle bundle, UIFormat uiFormat) {
        if (bundle != null) {
            long id = uiFormat.getID();
            int count = bundle.getCount();
            for (int j = 0; j < count; ++j) {
                if (bundle.getRule(j).getID() != id) continue;
                DiscriminatorRule styleRule = (DiscriminatorRule)bundle.getRule(j);
                uiFormat.setDiscriminator(UIFormat.getDiscriminatorStripTotals(styleRule.getDiscriminator()));
                list.add(uiFormat);
                return true;
            }
        }
        return false;
    }

    protected boolean addViewFormat(ArrayList list, RuleBundle bundle, UIFormat uiFormat) {
        if (bundle != null) {
            long id = uiFormat.getID();
            int count = bundle.getCount();
            for (int j = 0; j < count; ++j) {
                if (bundle.getRule(j).getID() != id) continue;
                DiscriminatorRule styleRule = (DiscriminatorRule)bundle.getRule(j);
                uiFormat.setViewFormat((ViewFormat)styleRule.getFixedMergeable());
                uiFormat.setDiscriminator(styleRule.getDiscriminator());
                if (uiFormat.getViewFormat() == null) {
                    ViewFormat vf = new ViewFormat();
                    vf.setLocale(this.getGridView().getLocale());
                    uiFormat.setViewFormat(vf);
                }
                list.add(uiFormat);
                return true;
            }
        }
        return false;
    }

    public void addStoplightRules(RuleBundle databodyRules, UIFormat uiFormat) {
        ValueDiscriminator[] valueDiscriminators;
        boolean isHideData;
        String[] colors;
        block15: {
            ConditionElement condition = uiFormat.getValueCondition();
            if (condition.getType() != 4) {
                return;
            }
            colors = new String[3];
            colors[1] = this.getGridView().getWarningColor();
            String badColor = this.getGridView().getBadColor();
            String goodColor = this.getGridView().getGoodColor();
            isHideData = this.getGridView().isHideData();
            valueDiscriminators = null;
            if (condition.getValueType().equals("Double")) {
                double bad = 0.0;
                double good = 0.0;
                try {
                    bad = (Double)condition.getBadThreshold();
                    good = (Double)condition.getGoodThreshold();
                    if (bad < good || bad == good && uiFormat.isDesirableGreaterThanThreshold()) {
                        valueDiscriminators = this.createStoplightValueDiscriminators(bad, good);
                        colors[0] = badColor;
                        colors[2] = goodColor;
                        break block15;
                    }
                    valueDiscriminators = this.createStoplightValueDiscriminators(good, bad);
                    colors[0] = goodColor;
                    colors[2] = badColor;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (condition.getValueType().equals("Date")) {
                Date bad = (Date)condition.getBadThreshold();
                good = (Date)condition.getGoodThreshold();
                if (bad != null && good != null) {
                    int compare = bad.compareTo((java.util.Date)good);
                    if (compare < 0 || compare == 0 && uiFormat.isDesirableGreaterThanThreshold()) {
                        valueDiscriminators = this.createStoplightValueDiscriminators(bad, (Date)good);
                        colors[0] = badColor;
                        colors[2] = goodColor;
                    } else {
                        valueDiscriminators = this.createStoplightValueDiscriminators((Date)good, bad);
                        colors[0] = goodColor;
                        colors[2] = badColor;
                    }
                }
            } else if (condition.getValueType().equals("String")) {
                String bad = (String)condition.getBadThreshold();
                good = (String)condition.getGoodThreshold();
                if (bad != null && good != null) {
                    int compare = bad.compareTo((String)good);
                    if (compare < 0 || compare == 0 && uiFormat.isDesirableGreaterThanThreshold()) {
                        valueDiscriminators = this.createStoplightValueDiscriminators(bad, (String)good);
                        colors[0] = badColor;
                        colors[2] = goodColor;
                    } else {
                        valueDiscriminators = this.createStoplightValueDiscriminators((String)good, bad);
                        colors[0] = goodColor;
                        colors[2] = badColor;
                    }
                }
            }
        }
        ViewStyle viewStyle = this.createViewStyle(colors[2], isHideData);
        CompositeDiscriminator qdrComposite = new CompositeDiscriminator(uiFormat.getDiscriminator(), (Discriminator)valueDiscriminators[0], 0);
        CompositeDiscriminator totalsComposite = new CompositeDiscriminator((Discriminator)new TotalsDiscriminator(), (Discriminator)qdrComposite, 0);
        DiscriminatorRule highRule = new DiscriminatorRule((Discriminator)totalsComposite, (Mergeable)viewStyle);
        highRule.setID(uiFormat.getID());
        viewStyle = this.createViewStyle(colors[1], isHideData);
        CompositeDiscriminator middleDisc = new CompositeDiscriminator((Discriminator)valueDiscriminators[1], (Discriminator)valueDiscriminators[2], 0);
        qdrComposite = new CompositeDiscriminator(uiFormat.getDiscriminator(), (Discriminator)middleDisc, 0);
        totalsComposite = new CompositeDiscriminator((Discriminator)new TotalsDiscriminator(), (Discriminator)qdrComposite, 0);
        DiscriminatorRule middleRule = new DiscriminatorRule((Discriminator)totalsComposite, (Mergeable)viewStyle);
        middleRule.setID(uiFormat.getID());
        viewStyle = this.createViewStyle(colors[0], isHideData);
        qdrComposite = new CompositeDiscriminator(uiFormat.getDiscriminator(), (Discriminator)valueDiscriminators[3], 0);
        totalsComposite = new CompositeDiscriminator((Discriminator)new TotalsDiscriminator(), (Discriminator)qdrComposite, 0);
        DiscriminatorRule lowRule = new DiscriminatorRule((Discriminator)totalsComposite, (Mergeable)viewStyle);
        lowRule.setID(uiFormat.getID());
        databodyRules.addRule((Rule)highRule);
        databodyRules.addRule((Rule)middleRule);
        databodyRules.addRule((Rule)lowRule);
    }

    protected ValueDiscriminator[] createStoplightValueDiscriminators(double low, double high) {
        NumberValueDiscriminator[] discriminators = new NumberValueDiscriminator[]{new NumberValueDiscriminator(high, 4), new NumberValueDiscriminator(high, 1), new NumberValueDiscriminator(low, 3), new NumberValueDiscriminator(low, 2)};
        return discriminators;
    }

    protected ValueDiscriminator[] createStoplightValueDiscriminators(String low, String high) {
        StringValueDiscriminator[] discriminators = new StringValueDiscriminator[]{new StringValueDiscriminator(high, 4), new StringValueDiscriminator(high, 1), new StringValueDiscriminator(low, 3), new StringValueDiscriminator(low, 2)};
        return discriminators;
    }

    protected ValueDiscriminator[] createStoplightValueDiscriminators(Date low, Date high) {
        DateValueDiscriminator[] discriminators = new DateValueDiscriminator[]{new DateValueDiscriminator(high, 4), new DateValueDiscriminator(high, 1), new DateValueDiscriminator(low, 3), new DateValueDiscriminator(low, 2)};
        return discriminators;
    }

    private ViewStyle createViewStyle(String colorString, boolean isHideData) {
        ViewStyle viewStyle = new ViewStyle();
        Color color = new Color(this.hexStringToInt(colorString));
        viewStyle.setBackground(color);
        if (isHideData) {
            viewStyle.setForeground(color);
        }
        return viewStyle;
    }

    public boolean isValidNumber(String value) {
        return this.toDouble(value) != null;
    }

    public boolean isValidDate(String value) {
        return this.toDate(value) != null;
    }

    public Object[] validateValue(String datatype, String value) {
        if (datatype == null) {
            return null;
        }
        Object[] retVals = new Object[2];
        if (datatype.equals("String") || datatype.equals("Boolean")) {
            retVals[0] = value;
        } else if (datatype.equals("Date")) {
            retVals[0] = this.toDate(value);
            if (retVals[0] == null) {
                retVals[1] = this.getResourceString("fm_InvalidDate");
            }
        } else {
            retVals[0] = this.toDouble(value);
            if (retVals[0] == null) {
                retVals[1] = this.getResourceString("fm_InvalidNumber");
            }
        }
        return retVals;
    }

    public Object[] validateValue(String[] datatypes, String value) {
        if (datatypes == null) {
            return null;
        }
        int typeCount = datatypes.length;
        Object[] retVals = null;
        for (int i = 0; i < typeCount && ((retVals = this.validateValue(datatypes[i], value)) == null || retVals[0] == null || retVals[1] != null); ++i) {
        }
        return retVals;
    }

    public String[] validateValues(String[] datatypes, String[] sources, Object[] values) {
        if (datatypes == null) {
            return null;
        }
        int sourceSize = sources.length;
        if (values == null || values.length < sourceSize) {
            values = new Object[2];
        }
        String[] errors = new String[sourceSize];
        boolean hasError = false;
        for (int i = 0; i < sourceSize; ++i) {
            Object[] retVals = this.validateValue(datatypes, sources[i]);
            if (retVals == null) {
                values[i] = sources[i];
                continue;
            }
            if (retVals[0] != null && retVals[1] == null) {
                values[i] = retVals[0];
                continue;
            }
            errors[i] = (String)retVals[1];
            hasError = true;
        }
        if (sourceSize > 1 && !hasError) {
            errors[1] = this.isCompatibleType(values);
            hasError = errors[1] != null;
        }
        return hasError ? errors : null;
    }

    private String isCompatibleType(Object[] values) {
        String error = null;
        if (values[0] instanceof Number) {
            if (!(values[1] instanceof Number)) {
                error = this.getResourceString("fm_InvalidNumber");
                values[1] = null;
            }
        } else if (values[0] instanceof Date) {
            if (!(values[1] instanceof Date)) {
                error = this.getResourceString("fm_InvalidDate");
                values[1] = null;
            }
        } else if (values[0] instanceof String) {
            if (!(values[1] instanceof String)) {
                error = this.getResourceString("fm_InvalidString");
                values[1] = null;
            }
        } else if (values[0] instanceof Boolean && !(values[1] instanceof Boolean)) {
            error = MessageFormat.format(this.getResourceString("fm_InvalidBoolean"), this.getBooleanTrue(), this.getBooleanFalse());
            values[1] = null;
        }
        return error;
    }

    public Double toDouble(String value) {
        return DataviewUtils.toDouble((String)value, (Locale)this.getGridView().getLocale(), (NumberFormat)this.getNumberFormat());
    }

    public Date toDate(String value) {
        try {
            return new Date(this.getDateInstance().parse(value).getTime());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Boolean toBoolean(String value) {
        if (value != null) {
            if (value.equalsIgnoreCase(this.getBooleanTrue())) {
                return Boolean.TRUE;
            }
            if (value.equalsIgnoreCase(this.getBooleanFalse())) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public String formatData(Object value) {
        if (value instanceof Number) {
            return this.getNumberFormat().format(value);
        }
        if (value instanceof Date) {
            return this.getDateInstance().format((Date)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? this.getBooleanTrue() : this.getBooleanFalse();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    private String getBooleanTrue() {
        return this.getUtilResourceString("true");
    }

    private String getBooleanFalse() {
        return this.getUtilResourceString("false");
    }

    public void setDefaultDateFormat(String format) {
        this.m_defaultDateFormat = format;
        this.m_dateFormat = null;
    }

    private DateFormat getDateInstance() {
        if (this.m_dateFormat == null) {
            Locale locale = this.getGridView().getLocale();
            this.m_dateFormat = locale == null ? new SimpleDateFormat(this.m_defaultDateFormat) : new SimpleDateFormat(this.m_defaultDateFormat, locale);
            String language = null;
            String country = null;
            if (locale != null) {
                language = locale.getLanguage();
                country = locale.getCountry();
            } else {
                language = Locale.getDefault().getLanguage();
                country = Locale.getDefault().getCountry();
            }
            if (language.compareTo("th") == 0 && country.compareTo("TH") == 0) {
                if (locale != null) {
                    this.m_dateFormat.setCalendar(new GregorianCalendar(locale));
                } else {
                    this.m_dateFormat.setCalendar(new GregorianCalendar());
                }
            }
        }
        return this.m_dateFormat;
    }

    public NumberFormat getNumberFormat() {
        if (this.m_numberFormat == null) {
            Locale locale = this.getGridView().getLocale();
            this.m_numberFormat = locale == null ? NumberFormat.getInstance() : NumberFormat.getInstance(locale);
        }
        return this.m_numberFormat;
    }

    public String getResourceString(String key) {
        String strTemp;
        if (this.m_localStrings == null) {
            return key;
        }
        try {
            strTemp = this.m_localStrings.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        return strTemp;
    }

    public String getUtilResourceString(String key) {
        String strTemp;
        if (this.m_utilLocalStrings == null) {
            return key;
        }
        try {
            strTemp = this.m_utilLocalStrings.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        return strTemp;
    }

    public void setLocale(Locale loc) {
        try {
            if (loc != null) {
                this.m_localStrings = ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle", loc);
                this.m_utilLocalStrings = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle", loc);
            } else {
                this.m_localStrings = ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle");
                this.m_utilLocalStrings = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle");
            }
        }
        catch (MissingResourceException e) {
            this.m_localStrings = null;
            this.m_utilLocalStrings = null;
        }
        this.m_dateFormat = null;
        this.m_numberFormat = null;
    }

    protected int hexStringToInt(String str) throws NumberFormatException {
        if (str != null) {
            String noPound = str.substring(1);
            return Integer.parseInt(noPound, 16);
        }
        return -1;
    }

    public void dataChanged() {
        this.m_dimensionList = null;
    }

    protected void clearMetadataLabels(List list) {
        for (int i = 0; i < list.size(); ++i) {
            UIFormat uiFormat = (UIFormat)list.get(i);
            uiFormat.setDimensionList(null);
        }
    }

    public void setDimensionList(List dimList) {
        this.m_dimensionList = dimList;
    }

    public List getDimensionList() {
        if (this.m_dimensionList == null) {
            this.m_dimensionList = DimensionMetadata.createDimensionMemberList((DataviewCommon)this.getGridView());
        }
        return this.m_dimensionList;
    }

    public DimensionMetadata getMeasureMetadata() {
        List dimList = this.getDimensionList();
        if (dimList != null) {
            for (int i = 0; i < dimList.size(); ++i) {
                DimensionMetadata dimData;
                if (!(dimList.get(i) instanceof DimensionMetadata) || !(dimData = (DimensionMetadata)dimList.get(i)).isMeasure()) continue;
                return dimData;
            }
        }
        return null;
    }

    public String[] getMeasureDatatypes() {
        DimensionMetadata metadata = this.getMeasureMetadata();
        if (metadata == null) {
            return null;
        }
        int count = metadata.getMemberCount();
        String[] datatypes = new String[count];
        String[] typeForAll = new String[1];
        datatypes[0] = metadata.getMemberDatatype(0);
        typeForAll[0] = datatypes[0];
        for (int i = 1; i < count; ++i) {
            datatypes[i] = metadata.getMemberDatatype(i);
            if (typeForAll[0] == null || datatypes[i].equals(typeForAll[0])) continue;
            typeForAll[0] = null;
        }
        return typeForAll[0] == null ? datatypes : typeForAll;
    }

    public String getMeasureID() {
        return null;
    }

    public abstract boolean isDirty();

    public abstract void setDirty(boolean var1);

    public abstract void establishBaseState();

    public abstract void establishCheckpointState();

    public abstract void setStateAsObjectNode(List var1, ObjectNode var2, boolean var3);

    public abstract ContainerNode getStateAsObjectNode(List var1, boolean var2);
}

