/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.SeparatorBorderPainter;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirector;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public abstract class PageSelectionPanel
extends JPanel
implements ItemListener,
ActionListener,
HelpContext {
    private ResourceBundle rBundle = null;
    public static final int PRINT = 0;
    public static final int EXPORT = 1;
    protected int m_pageDimComboOffset = 0;
    protected int m_oldPageDimComboOffset = 0;
    protected JPanel m_DeselectAllPanel;
    protected JScrollPane m_scrollPane;
    protected JComboBox m_pageDimCombo;
    protected String m_translatedText;
    protected JLabel m_pageDimLabel;
    protected ButtonGroup m_buttonGroup;
    protected JPanel m_rightPanel;
    protected String[] m_strListArray;
    private Vector m_pageDimListVector = new Vector();
    private Vector[] m_pageDimListVectorArray;
    private Vector[] m_exportVectorArray;
    protected MultiLineLabel m_exportFormatComboLabel;
    protected String[] m_strLayerNamesArray;
    protected JLabel m_whatToExportLabel;
    protected JRadioButton m_CurrentSelectionsButton;
    protected JRadioButton m_All28Button;
    protected JRadioButton m_SelectedCombinationsButton;
    protected JButton m_SelectAllButton;
    protected JPanel m_PageDimPanel;
    protected JPanel m_PageDimListPanel;
    protected JList m_PageDimList;
    protected JButton m_DeselectAllButton;
    protected DataAccess m_dataAccess;
    protected DataDirector m_dataDirector;
    protected String m_applicationName;
    protected Locale m_locale = null;
    protected int m_selectionsOffset;
    protected long m_pageCount;
    protected int m_layerCount;
    protected int m_maxButtonWidth = 0;
    protected JPanel m_mainPanel;
    private int[] m_pageEdgeCurrentHPos;

    protected void constructPanel(int type) {
        int iPageDimPanelWidth = this.getToolkit().getScreenSize().width;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.m_pageCount = -1L;
        try {
            this.m_pageCount = this.m_dataAccess.getEdgeExtent(2);
            this.m_layerCount = this.m_dataAccess.getLayerCount(2);
            this.m_pageEdgeCurrentHPos = this.m_dataAccess.getEdgeCurrentHPos(2);
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
        Object dimensionStr1 = "";
        String dimensionStr2 = "";
        try {
            if (this.m_layerCount > 1) {
                for (int i = 0; i < this.m_layerCount; ++i) {
                    Object obj = this.m_dataAccess.getLayerMetadata(2, i, "dimShortName");
                    String layer = null;
                    if (obj != null) {
                        layer = obj.toString();
                    }
                    if (layer == null) continue;
                    if (i < this.m_layerCount - 2) {
                        dimensionStr1 = (String)dimensionStr1 + layer + ", ";
                        continue;
                    }
                    if (i == this.m_layerCount - 2) {
                        dimensionStr1 = (String)dimensionStr1 + layer;
                        continue;
                    }
                    dimensionStr2 = layer;
                }
            } else {
                dimensionStr1 = this.m_dataAccess.getLayerMetadata(2, 0, "dimShortName").toString();
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        this.m_translatedText = type == 0 ? (this.m_layerCount == 1 ? MessageFormat.format(this.rBundle.getString("WhatToPrint"), dimensionStr1) : MessageFormat.format(this.rBundle.getString("WhatToPrint2"), dimensionStr1, dimensionStr2)) : (this.m_layerCount == 1 ? MessageFormat.format(this.rBundle.getString("WhatToExport"), dimensionStr1) : MessageFormat.format(this.rBundle.getString("WhatToExport2"), dimensionStr1, dimensionStr2));
        this.m_exportFormatComboLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), this.m_translatedText);
        this.m_exportFormatComboLabel.setAlignmentX(0.0f);
        this.add((Component)this.m_exportFormatComboLabel);
        this.add(Box.createVerticalStrut(6));
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setAlignmentX(0.0f);
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 0));
        this.m_translatedText = type == 0 ? this.rBundle.getString("PrintSelection") : this.rBundle.getString("ExportSelection");
        JLabel m_leftLabel = new JLabel(this.m_translatedText);
        m_leftLabel.setAlignmentX(0.0f);
        JPanel m_leftPanel = new JPanel();
        m_leftPanel.setAlignmentX(0.0f);
        m_leftPanel.setLayout(new BoxLayout(m_leftPanel, 1));
        m_leftPanel.add(m_leftLabel);
        m_leftPanel.add(Box.createVerticalGlue());
        this.m_buttonGroup = new ButtonGroup();
        this.m_translatedText = this.rBundle.getString("CurrentSelections");
        this.m_CurrentSelectionsButton = new JRadioButton(StringUtils.stripMnemonic((String)this.m_translatedText), true);
        this.m_CurrentSelectionsButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_CurrentSelectionsButton.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.m_CurrentSelectionsButton.addItemListener(this);
        this.m_CurrentSelectionsButton.setAlignmentX(0.0f);
        this.m_translatedText = this.rBundle.getString("All28");
        Object[] formatArgs = new String[]{Long.toString(this.m_pageCount)};
        this.m_All28Button = new JRadioButton(MessageFormat.format(StringUtils.stripMnemonic((String)this.m_translatedText), formatArgs), false);
        this.m_All28Button.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_All28Button.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.m_All28Button.addItemListener(this);
        this.m_All28Button.setAlignmentX(0.0f);
        this.m_translatedText = this.rBundle.getString("SelectedCombinations");
        this.m_SelectedCombinationsButton = new JRadioButton(StringUtils.stripMnemonic((String)this.m_translatedText), false);
        this.m_SelectedCombinationsButton.setName("SpecifiedCombinations");
        this.m_SelectedCombinationsButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_SelectedCombinationsButton.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.m_SelectedCombinationsButton.addItemListener(this);
        this.m_SelectedCombinationsButton.setAlignmentX(0.0f);
        this.m_buttonGroup.add(this.m_CurrentSelectionsButton);
        this.m_buttonGroup.add(this.m_All28Button);
        this.m_buttonGroup.add(this.m_SelectedCombinationsButton);
        this.m_PageDimPanel = new JPanel();
        this.m_PageDimPanel.setLayout(new BoxLayout(this.m_PageDimPanel, 0));
        this.m_translatedText = this.rBundle.getString("PageDimension");
        this.m_pageDimLabel = new JLabel(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.m_pageDimLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_pageDimCombo = new JComboBox();
        this.m_pageDimLabel.setLabelFor(this.m_pageDimCombo);
        this.m_pageDimCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PageSelectionPanel.this.m_pageDimComboOffset = PageSelectionPanel.this.m_pageDimCombo.getSelectedIndex();
                    if (PageSelectionPanel.this.m_pageDimComboOffset != PageSelectionPanel.this.m_oldPageDimComboOffset) {
                        PageSelectionPanel.this.savePageDimList(PageSelectionPanel.this.m_oldPageDimComboOffset);
                        PageSelectionPanel.this.m_oldPageDimComboOffset = PageSelectionPanel.this.m_pageDimComboOffset;
                        PageSelectionPanel.this.refreshPageDimList();
                    }
                }
            }
        });
        this.m_PageDimPanel.add(Box.createHorizontalStrut(25));
        this.m_PageDimPanel.add(this.m_pageDimLabel);
        this.m_PageDimPanel.add(Box.createHorizontalStrut(3));
        this.m_PageDimPanel.add(this.m_pageDimCombo);
        this.m_PageDimPanel.setAlignmentX(0.0f);
        this.m_PageDimListPanel = new JPanel();
        this.m_PageDimListPanel.setLayout(new BoxLayout(this.m_PageDimListPanel, 0));
        this.m_PageDimList = new JList();
        this.m_PageDimList.setCellRenderer(new CheckListRenderer());
        this.m_PageDimList.setSelectionMode(0);
        this.m_PageDimList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (PageSelectionPanel.this.m_PageDimList.getSelectedIndex() < 0) {
                    PageSelectionPanel.this.m_PageDimList.setSelectedIndex(0);
                }
            }
        });
        this.m_PageDimList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = PageSelectionPanel.this.m_PageDimList.locationToIndex(e.getPoint());
                if (index >= 0 && PageSelectionPanel.this.m_SelectedCombinationsButton.isSelected()) {
                    CheckableItem item;
                    item.setSelected(!(item = (CheckableItem)PageSelectionPanel.this.m_PageDimList.getModel().getElementAt(index)).isSelected());
                    Rectangle rect = PageSelectionPanel.this.m_PageDimList.getCellBounds(index, index);
                    PageSelectionPanel.this.m_PageDimList.repaint(rect);
                }
            }
        });
        this.m_PageDimList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int index = PageSelectionPanel.this.m_PageDimList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                if (e.getKeyCode() == 32) {
                    CheckableItem item;
                    item.setSelected(!(item = (CheckableItem)PageSelectionPanel.this.m_PageDimList.getModel().getElementAt(index)).isSelected());
                    Rectangle rect = PageSelectionPanel.this.m_PageDimList.getCellBounds(index, index);
                    PageSelectionPanel.this.m_PageDimList.repaint(rect);
                }
            }
        });
        this.m_scrollPane = new JScrollPane(this.m_PageDimList);
        this.m_scrollPane.setPreferredSize(new Dimension(232, 75));
        this.m_scrollPane.setVerticalScrollBarPolicy(20);
        this.m_scrollPane.setHorizontalScrollBarPolicy(30);
        this.m_translatedText = this.rBundle.getString("SelectAll");
        this.m_SelectAllButton = new JButton(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.m_SelectAllButton.setName("Select All");
        this.m_SelectAllButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_translatedText = this.rBundle.getString("DeselectAll");
        this.m_DeselectAllButton = new JButton(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.m_DeselectAllButton.setName("Deselect All");
        int buttonWidth = Math.max(this.m_SelectAllButton.getPreferredSize().width, this.m_DeselectAllButton.getPreferredSize().width);
        this.m_DeselectAllButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_DeselectAllButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_SelectAllButton.setPreferredSize(new Dimension(buttonWidth, this.m_SelectAllButton.getPreferredSize().height));
        this.m_SelectAllButton.setMinimumSize(this.m_SelectAllButton.getPreferredSize());
        this.m_SelectAllButton.setMaximumSize(this.m_SelectAllButton.getPreferredSize());
        this.m_SelectAllButton.addActionListener(this);
        this.m_DeselectAllButton.setPreferredSize(new Dimension(buttonWidth, this.m_DeselectAllButton.getPreferredSize().height));
        this.m_DeselectAllButton.setMinimumSize(this.m_DeselectAllButton.getPreferredSize());
        this.m_DeselectAllButton.setMaximumSize(this.m_DeselectAllButton.getPreferredSize());
        this.m_DeselectAllButton.addActionListener(this);
        this.m_DeselectAllPanel = new JPanel();
        this.m_DeselectAllPanel.setLayout(new BoxLayout(this.m_DeselectAllPanel, 1));
        JPanel m_buttonPanel = new JPanel();
        m_buttonPanel.setLayout(new BoxLayout(m_buttonPanel, 1));
        m_buttonPanel.add(this.m_SelectAllButton);
        m_buttonPanel.add(Box.createVerticalStrut(6));
        m_buttonPanel.add(this.m_DeselectAllButton);
        this.m_DeselectAllPanel.add(m_buttonPanel);
        this.m_DeselectAllPanel.add(Box.createVerticalGlue());
        m_buttonPanel.setMinimumSize(m_buttonPanel.getPreferredSize());
        m_buttonPanel.setMaximumSize(m_buttonPanel.getPreferredSize());
        this.m_PageDimListPanel.add(Box.createHorizontalStrut(25));
        this.m_PageDimListPanel.add(this.m_scrollPane);
        this.m_PageDimListPanel.add(Box.createHorizontalStrut(10));
        this.m_PageDimListPanel.add(this.m_DeselectAllPanel);
        this.m_PageDimListPanel.setAlignmentX(0.0f);
        this.m_rightPanel = new JPanel();
        this.m_rightPanel.setLayout(new BoxLayout(this.m_rightPanel, 1));
        this.m_rightPanel.setAlignmentX(0.0f);
        this.m_rightPanel.add(this.m_CurrentSelectionsButton);
        this.m_rightPanel.add(this.m_All28Button);
        this.m_rightPanel.add(this.m_SelectedCombinationsButton);
        this.m_rightPanel.add(Box.createVerticalStrut(5));
        this.m_rightPanel.add(this.m_PageDimPanel);
        this.m_rightPanel.add(Box.createVerticalStrut(5));
        this.m_rightPanel.add(this.m_PageDimListPanel);
        this.m_mainPanel.add(m_leftPanel);
        this.m_mainPanel.add(Box.createHorizontalStrut(5));
        this.m_mainPanel.add(this.m_rightPanel);
        double textwidth = this.getToolkit().getFontMetrics(this.m_exportFormatComboLabel.getFont()).stringWidth(this.m_exportFormatComboLabel.getText());
        int rows = (int)Math.ceil(textwidth / (double)this.m_rightPanel.getPreferredSize().width);
        this.m_exportFormatComboLabel.setPreferredRows(rows);
        this.m_exportFormatComboLabel.setMinimumRows(rows);
        this.m_exportFormatComboLabel.setMaximumRows(rows);
        this.add(this.m_mainPanel);
        if (this.m_layerCount == 0 || this.m_pageCount == 1L) {
            this.disableUpperPanel();
        }
    }

    protected void _init() {
        this.m_pageDimLabel.setEnabled(false);
        this.m_pageDimCombo.setEnabled(false);
        this.m_PageDimList.setEnabled(false);
        this.m_SelectAllButton.setEnabled(false);
        this.m_DeselectAllButton.setEnabled(false);
        this.initPageDimCombo();
        this.initPageDimList();
    }

    public void setApplicationName(String name) {
        this.m_applicationName = name;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    public LWComponent createSeparator() {
        LWComponent c = new LWComponent();
        BorderAdapter b = new BorderAdapter((BorderPainter)new SeparatorBorderPainter(1, false, 0));
        c.setBorder((Border)b);
        c.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 2));
        c.setMinimumSize(c.getPreferredSize());
        c.setMaximumSize(c.getPreferredSize());
        c.setAlignmentX(0.0f);
        return c;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.m_CurrentSelectionsButton) {
                this.m_pageDimLabel.setEnabled(false);
                this.m_pageDimCombo.setEnabled(false);
                this.m_PageDimList.setEnabled(false);
                this.m_SelectAllButton.setEnabled(false);
                this.m_DeselectAllButton.setEnabled(false);
                this.m_selectionsOffset = 0;
            } else if (e.getSource() == this.m_All28Button) {
                this.m_pageDimLabel.setEnabled(false);
                this.m_pageDimCombo.setEnabled(false);
                this.m_PageDimList.setEnabled(false);
                this.m_SelectAllButton.setEnabled(false);
                this.m_DeselectAllButton.setEnabled(false);
                this.m_selectionsOffset = 1;
            } else if (e.getSource() == this.m_SelectedCombinationsButton) {
                this.m_pageDimLabel.setEnabled(true);
                this.m_pageDimCombo.setEnabled(true);
                this.m_PageDimList.setEnabled(true);
                this.m_SelectAllButton.setEnabled(true);
                this.m_DeselectAllButton.setEnabled(true);
                this.m_selectionsOffset = 2;
            }
        }
    }

    protected void disableUpperPanel() {
        this.m_CurrentSelectionsButton.setEnabled(true);
        this.m_All28Button.setEnabled(false);
        this.m_SelectedCombinationsButton.setEnabled(false);
        this.m_pageDimLabel.setEnabled(false);
        this.m_pageDimCombo.setEnabled(false);
        this.m_PageDimList.setEnabled(false);
        this.m_SelectAllButton.setEnabled(false);
        this.m_DeselectAllButton.setEnabled(false);
        this.m_selectionsOffset = 0;
    }

    protected boolean buildExportVectorArray() {
        boolean bReturn = true;
        int i = 0;
        int layerCount = this.m_layerCount;
        this.m_exportVectorArray = new Vector[layerCount];
        for (i = 0; i < layerCount; ++i) {
            this.m_exportVectorArray[i] = new Vector();
        }
        Vector walkingVector = new Vector();
        Vector offsetVector = new Vector();
        for (i = 0; i < layerCount; ++i) {
            walkingVector = this._getPageDimListVector(i);
            offsetVector = this.m_exportVectorArray[i];
            int iSizeTemp = 0;
            if (walkingVector != null) {
                iSizeTemp = walkingVector.size();
            }
            for (int j = 0; j < iSizeTemp; ++j) {
                CheckableItem item = (CheckableItem)walkingVector.elementAt(j);
                if (!item.isSelected()) continue;
                int[] iOffset = new int[]{j};
                offsetVector.addElement(iOffset);
            }
            if (offsetVector.size() == 0) {
                return false;
            }
            this.m_exportVectorArray[i] = offsetVector;
        }
        return true;
    }

    protected Vector buildListExportHPos() {
        int i;
        Vector<int[]> listExportHPos = new Vector<int[]>();
        int intRows = 1;
        for (int i2 = 0; i2 < this.m_exportVectorArray.length; ++i2) {
            intRows *= this.m_exportVectorArray[i2].size();
        }
        int[][] positions = new int[intRows][];
        int[] current = new int[this.m_exportVectorArray.length];
        for (i = 0; i < current.length - 1; ++i) {
            current[i] = 0;
        }
        current[current.length - 1] = -1;
        for (i = 0; i < intRows; ++i) {
            this.updateCurrent(this.m_exportVectorArray, current);
            int[] newArray = new int[current.length];
            for (int j = 0; j < current.length; ++j) {
                int[] iOffset = (int[])this.m_exportVectorArray[j].elementAt(current[j]);
                newArray[j] = iOffset[0];
            }
            positions[i] = newArray;
        }
        for (int j = 0; j < positions.length; ++j) {
            listExportHPos.addElement(positions[j]);
        }
        return listExportHPos;
    }

    protected boolean isAllLayersSelected() {
        if (this.m_CurrentSelectionsButton.isSelected() || this.m_All28Button.isSelected()) {
            return true;
        }
        String strSingleQuote = "'";
        CheckableItem item = null;
        boolean bItemChecked = false;
        Vector walkingVector = new Vector();
        int layerCount = this.m_layerCount;
        for (int i = 0; i < layerCount; ++i) {
            walkingVector = this._getPageDimListVector(i);
            int iCurrentVectorSize = 0;
            if (walkingVector != null) {
                iCurrentVectorSize = walkingVector.size();
            }
            for (int j = 0; j < iCurrentVectorSize; ++j) {
                item = (CheckableItem)walkingVector.elementAt(j);
                if (!item.isSelected()) continue;
                bItemChecked = true;
            }
            if (!bItemChecked) {
                this.m_pageDimCombo.setSelectedIndex(i);
                String strTemp = this.m_strLayerNamesArray[i];
                String strInsert = strSingleQuote + strTemp + strSingleQuote;
                String translatedText = MessageFormat.format(this.rBundle.getString("DimListWarning"), strInsert);
                JOptionPane jpane = new JOptionPane(translatedText, 0, -1, new ImageIcon(ImageUtils.getImageResource(PageSelectionPanel.class, (String)"images/stop.gif")));
                jpane.getAccessibleContext().setAccessibleName(translatedText);
                JDialog tmpDialog = jpane.createDialog(this, this.m_applicationName);
                tmpDialog.show();
                return false;
            }
            bItemChecked = false;
        }
        return true;
    }

    protected void updateCurrent(Vector[] A, int[] current) {
        for (int i = current.length - 1; i >= 0; --i) {
            if (current[i] < A[i].size() - 1) {
                int n = i;
                current[n] = current[n] + 1;
                return;
            }
            current[i] = 0;
        }
    }

    protected void initPageDimCombo() {
        try {
            int layerCount = this.m_layerCount;
            if (layerCount == 0) {
                return;
            }
            this.m_strLayerNamesArray = new String[layerCount];
            for (int i = 0; i < layerCount; ++i) {
                Object obj = this.m_dataAccess.getLayerMetadata(2, i, "dimShortName");
                String layer = null;
                if (obj != null) {
                    layer = obj.toString();
                }
                this.m_pageDimCombo.addItem(layer);
                this.m_strLayerNamesArray[i] = layer;
            }
            this.m_pageDimListVectorArray = new Vector[layerCount];
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
    }

    private void initPageDimList() {
        int layerCount = this.m_layerCount;
        if (layerCount == 0) {
            return;
        }
        this.refreshPageDimList();
        this.m_pageDimCombo.setMinimumSize(this.m_pageDimCombo.getPreferredSize());
        this.m_pageDimCombo.setMaximumSize(this.m_pageDimCombo.getPreferredSize());
    }

    private void savePageDimList(int iOffset) {
        this.m_pageDimListVectorArray[iOffset] = this.m_pageDimListVector;
    }

    private Vector _getPageDimListVector(int layer) {
        if (this.m_pageDimListVectorArray[layer] == null) {
            this.m_pageDimListVectorArray[layer] = this._createPageDimListVector(layer);
        }
        return this.m_pageDimListVectorArray[layer];
    }

    private Vector _createPageDimListVector(int layer) {
        Vector<CheckableItem> tempVector = new Vector<CheckableItem>();
        try {
            int layerCount = this.m_layerCount;
            if (layerCount == 0) {
                return tempVector;
            }
            int[] hpos = this.m_pageEdgeCurrentHPos;
            int selectedOffset = hpos[layer];
            int memberCount = this.m_dataAccess.getMemberSiblingCount(2, hpos, layer);
            for (int i = 0; i < memberCount; ++i) {
                Object obj = this.m_dataAccess.getMemberMetadata(2, hpos, layer, i, "shortName");
                String member = null;
                if (obj != null) {
                    member = obj.toString();
                }
                CheckableItem item = new CheckableItem(member);
                if (i == selectedOffset) {
                    item.setSelected(true);
                }
                tempVector.addElement(item);
            }
        }
        catch (SliceOutOfRangeException e1) {
            e1.printStackTrace();
        }
        catch (LayerOutOfRangeException e2) {
            e2.printStackTrace();
        }
        catch (EdgeOutOfRangeException e3) {
            e3.printStackTrace();
        }
        return tempVector;
    }

    private void refreshPageDimList() {
        this.m_pageDimListVector = this._getPageDimListVector(this.m_pageDimComboOffset);
        this.m_PageDimList.setListData(this.m_pageDimListVector);
        this.m_PageDimList.repaint();
    }

    protected void deselectAllMembers() {
        int memberCount = this.m_pageDimListVector.size();
        for (int i = 0; i < memberCount; ++i) {
            CheckableItem item = (CheckableItem)this.m_pageDimListVector.elementAt(i);
            item.setSelected(false);
        }
        this.m_PageDimList.setListData(this.m_pageDimListVector);
        this.m_PageDimList.repaint();
    }

    protected void selectAllMembers() {
        int memberCount = this.m_pageDimListVector.size();
        for (int i = 0; i < memberCount; ++i) {
            CheckableItem item = (CheckableItem)this.m_pageDimListVector.elementAt(i);
            item.setSelected(true);
        }
        this.m_PageDimList.setListData(this.m_pageDimListVector);
        this.m_PageDimList.repaint();
    }

    protected void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    class CheckListRenderer
    extends JPanel
    implements ListCellRenderer {
        private JCheckBox checkbox;
        private JLabel label;

        public CheckListRenderer() {
            this.setOpaque(true);
            this.checkbox = new JCheckBox();
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.checkbox);
            this.label = new JLabel();
            this.add(this.label);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.checkbox.setEnabled(list.isEnabled());
            this.label.setEnabled(list.isEnabled());
            this.checkbox.setSelected(((CheckableItem)PageSelectionPanel.this.m_PageDimList.getModel().getElementAt(index)).isSelected());
            this.label.setFont(list.getFont());
            this.label.setText(value.toString());
            this.getAccessibleContext().setAccessibleName(value.toString());
            if (isSelected && list.isEnabled()) {
                this.checkbox.setBackground(list.getSelectionBackground());
                this.label.setForeground(Color.white);
                this.setBackground(list.getSelectionBackground());
            } else {
                this.checkbox.setBackground(list.getBackground());
                this.label.setForeground(Color.black);
                this.setBackground(list.getBackground());
            }
            return this;
        }
    }

    class CheckableItem {
        private String str;
        private boolean isSelected;

        public CheckableItem(String str) {
            this.str = str;
            this.isSelected = false;
        }

        public void setSelected(boolean b) {
            this.isSelected = b;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public String toString() {
            return this.str;
        }
    }
}

