/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PrinterGraphics;
import java.beans.PropertyVetoException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFrame;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.pivot.PivotTableSelection;
import oracle.bali.ewt.print.PrinterGraphics2DProxy;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabPivotTable;
import oracle.dss.dataView.DataSubsetRecord;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.PaginationRecord;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.GridViewAppearanceMgr;
import oracle.dss.gridView.GridViewPrinter;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.Range;

public class CrosstabPrinter
extends GridViewPrinter {
    private int index = 0;
    private int currX = 0;
    private int currY = 0;
    private int currentOuter = 0;
    private int currentInner = 0;
    private int outerLoop = 0;
    private int innerLoop = 0;
    private int pageNum = 0;
    private int pivotTableHeight = 0;
    private int firstColOnScreen;
    private int firstRowOnScreen;
    private int zoomFactor = 100;
    private int totalColWidth;
    private int totalRowHeight;
    private int m_iDefaultColumnWidth;
    private boolean m_insuffSapce = false;
    private boolean crosstabRemoved = false;
    private boolean selectionRemoved = false;
    private boolean line3D = false;
    private boolean pagingSp = false;
    private boolean titleSp = false;
    private boolean subtitleSp = false;
    private boolean textPaneSp = false;
    private boolean footnoteSp = false;
    private boolean newLogPageIsNext = false;
    private boolean turnedOffHGrid = false;
    private boolean turnedOffVGrid = false;
    private boolean m_resetZoomFactor = false;
    private int m_selectedIndex = 0;
    private JFrame m_frame = null;
    private Dimension oldSize = null;
    private Dimension documentSize = null;
    private Rectangle newPageBounds;
    private Hashtable printProperties;
    private PrintJob job;
    private Crosstab crosstab = null;
    private CrosstabPivotTable pivot = null;
    private Component cornerComp = null;
    private PivotTableSelection selection = null;
    private Vector v = null;
    private ResourceBundle rBundle = null;
    private static final String m_method_calcpagebounds = "calcPageBounds(DataSubsetRecord record)";
    private static final String m_method_resizerowheights = "resizeRowHeights(int firstCol, int lastCol, int firstRow, int lastRow)";
    private static final String m_method_resizeColumnWidths = "protected boolean resizeColumnWidths(int firstCol, int lastCol, int firstRow, int lastRow)";
    private static final String m_method_endPrint = "endPrint()";
    private static final String m_method_saveCellSelection = "saveCellSelection()";
    private static final String m_method_printPage = "public boolean printPage(Graphics g, DataSubsetRecord record)";

    public CrosstabPrinter(Crosstab c) {
        super(c);
        this.crosstab = c;
        this.updateResourceBundle(this.crosstab.getLocale());
        this.pivot = this.crosstab.getPivotTable();
    }

    public int getViewPrinterType() {
        return 0;
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.crosstab.resource.CrosstabBundle", loc) : ResourceBundle.getBundle("oracle.dss.crosstab.resource.CrosstabBundle");
    }

    public boolean startPrint() {
        return this.startPrint(false);
    }

    public boolean startPrint(boolean bPreviewMode) {
        if (this.crosstab.isDataUnavailable()) {
            this.crosstab.getErrorHandler().log("data is unavailable to print", ((Object)((Object)this)).getClass().getName(), "startPrint");
            return false;
        }
        if (this.crosstab.getParent() == null) {
            this.crosstab.setSize(400, 400);
            this.m_frame = new JFrame();
            this.m_frame.getContentPane().add((Component)((Object)this.crosstab));
            this.m_frame.pack();
        }
        if (this.paperHeight - (this.topMargin + this.bottomMargin) < 20 || this.paperWidth - (this.leftMargin + this.rightMargin) < 20) {
            this.logInsuffMsg("startPrint");
            return false;
        }
        this.m_insuffSapce = false;
        this.crosstab.firePrintBegin(this.crosstab);
        try {
            this.currLogPage.setHPos(this.crosstab.getCrosstabModel().getDataAccess().getEdgeCurrentHPos(2));
        }
        catch (DataException e) {
            this.crosstab.getErrorHandler().error((Throwable)e, ((Object)((Object)this)).getClass().getName(), "startPrint");
        }
        this.crosstab.setPrintOrPreviewMode(true);
        this.line3D = this.crosstab.isGrid3D();
        if (this.line3D) {
            this.crosstab.setGrid3D(false);
            this.pivot.validate();
        }
        this.m_iDefaultColumnWidth = this.crosstab.getCrosstabSizingManager().getDefaultColumnWidth();
        this.pagingControlBounds = new Rectangle(0, 0, 0, 0);
        this.saveTitlesFocus();
        this.saveCellSelection();
        this.firstRowOnScreen = this.pivot.getFirstRowOnScreen();
        this.firstColOnScreen = this.pivot.getFirstColumnOnScreen();
        this.crosstab.autoFit();
        this.crosstab.updatePivotHandleSize();
        if (!this.m_gridlinesVisible) {
            if (this.crosstab.isHGridVisible()) {
                this.turnedOffHGrid = true;
                this.crosstab.setHGridVisible(false);
            }
            if (this.crosstab.isVGridVisible()) {
                this.turnedOffVGrid = true;
                this.crosstab.setVGridVisible(false);
            }
        }
        this.m_resetZoomFactor = false;
        if (this.m_gridViewPrintScaleType == 2) {
            this.zoomFactor = this.crosstab.getZoomFactor();
            this.crosstab.setZoomFactor(100);
            int scaledZoomFactor = this.calcZoomFactor();
            if (scaledZoomFactor == -1) {
                return false;
            }
            if (scaledZoomFactor > this.zoomFactor) {
                this.crosstab.setZoomFactor(100);
            } else {
                this.crosstab.setZoomFactor(scaledZoomFactor);
            }
            this.m_resetZoomFactor = true;
        } else if (this.m_gridViewPrintScaleType == 1) {
            this.zoomFactor = this.crosstab.getZoomFactor();
            this.crosstab.setZoomFactor(this.printZoomFactor);
            this.m_resetZoomFactor = true;
        } else if (this.crosstab.getZoomFactor() != 100) {
            this.zoomFactor = this.crosstab.getZoomFactor();
            this.crosstab.setZoomFactor(100);
            this.m_resetZoomFactor = true;
        }
        this.resize = true;
        this.printProperties = new Hashtable();
        this.printProperties.put(PivotTable.PRINT_RAISED, Boolean.FALSE);
        this.printProperties.put(Grid.DISPLAY_FOCUS_CELL, Boolean.FALSE);
        this.printProperties.put(Header.DISPLAY_FOCUS_ITEM, Boolean.FALSE);
        if (this.crosstab.isPivotLabelVisible()) {
            this.printProperties.put(PivotTable.DISPLAY_COLUMN_SELECTORS, Boolean.TRUE);
            this.printProperties.put(PivotTable.DISPLAY_ROW_SELECTORS, Boolean.TRUE);
        } else {
            this.printProperties.put(PivotTable.DISPLAY_COLUMN_SELECTORS, Boolean.FALSE);
            this.printProperties.put(PivotTable.DISPLAY_ROW_SELECTORS, Boolean.FALSE);
        }
        if (this.isRepeatComponent(1)) {
            this.printProperties.put(PivotTable.DUPLICATE_COLUMN_PIVOT_HEADER, Boolean.TRUE);
            this.printProperties.put(PivotTable.DUPLICATE_COLUMN_HEADER_DATA, Boolean.TRUE);
        } else {
            this.printProperties.put(PivotTable.DUPLICATE_COLUMN_PIVOT_HEADER, Boolean.FALSE);
            this.printProperties.put(PivotTable.DUPLICATE_COLUMN_HEADER_DATA, Boolean.FALSE);
        }
        if (this.isRepeatComponent(2)) {
            this.printProperties.put(PivotTable.DUPLICATE_ROW_PIVOT_HEADER, Boolean.TRUE);
            this.printProperties.put(PivotTable.DUPLICATE_ROW_HEADER_DATA, Boolean.TRUE);
        } else {
            this.printProperties.put(PivotTable.DUPLICATE_ROW_PIVOT_HEADER, Boolean.FALSE);
            this.printProperties.put(PivotTable.DUPLICATE_ROW_HEADER_DATA, Boolean.FALSE);
        }
        this.m_selectedIndex = 0;
        this.m_seqPageNumber = 0;
        this.m_bPreviewMode = bPreviewMode;
        this.pIndex = -1;
        return true;
    }

    public void endPrint() {
        try {
            int maxLayerSpecified = -1;
            if (this.currLogPage.getHPos() != null) {
                maxLayerSpecified = this.currLogPage.getHPos().length - 1;
            }
            this.changePageEdgeCurrentHPos(this.currLogPage.getHPos(), maxLayerSpecified);
        }
        catch (DataException e) {
            this.crosstab.getErrorHandler().error((Throwable)e, ((Object)((Object)this)).getClass().getName(), "endPrint");
        }
        this.m_insuffSapce = false;
        if (this.m_resetZoomFactor) {
            this.crosstab.setZoomFactor(this.zoomFactor);
        }
        if (!this.m_gridlinesVisible) {
            if (this.turnedOffHGrid) {
                this.turnedOffHGrid = false;
                this.crosstab.setHGridVisible(true);
            }
            if (this.turnedOffVGrid) {
                this.turnedOffVGrid = false;
                this.crosstab.setVGridVisible(true);
            }
        }
        if (this.line3D) {
            this.crosstab.setGrid3D(true);
        }
        if (this.tempFrame != null) {
            this.tempFrame.dispose();
            this.tempFrame = null;
        }
        this.restoreTitlesFocus();
        if (this.selectionRemoved) {
            try {
                this.pivot.setSelection(this.selection);
            }
            catch (PropertyVetoException e) {
                this.crosstab.getErrorHandler().error((Throwable)e, ((Object)((Object)this)).getClass().getName(), m_method_endPrint);
            }
            this.selectionRemoved = false;
        }
        if (this.m_rowHeightsCache != null) {
            this.m_rowHeightsCache.clear();
            this.m_rowHeightsCache = null;
        }
        if (this.m_colWidthsCache != null) {
            this.m_colWidthsCache.clear();
            this.m_colWidthsCache = null;
        }
        this.m_rowHeights = null;
        this.m_colWidths = null;
        this.m_dirtyRowHeights = null;
        this.m_dirtyColWidths = null;
        this.logicalPage = null;
        this.m_bUpdateRowHeightsCache = false;
        this.m_bUpdateColWidthsCache = false;
        this.m_bPreviewMode = false;
        this.pIndex = -1;
        this.crosstab.setPrintOrPreviewMode(false);
        this.crosstab.autoFit();
        this.crosstab.updatePivotHandleSize();
        if (this.firstRowOnScreen >= 0 && this.firstRowOnScreen < this.pivot.getGridModel().getRowCount()) {
            this.pivot.setFirstRowOnScreen(this.firstRowOnScreen);
        }
        if (this.firstColOnScreen >= 0 && this.firstColOnScreen < this.pivot.getGridModel().getColumnCount()) {
            this.pivot.setFirstColumnOnScreen(this.firstColOnScreen);
        }
        this.crosstab.validate();
        this.crosstab.repaint();
        this.crosstab.firePrintEnd(this.crosstab);
        if (this.m_frame != null) {
            this.m_frame.remove((Component)((Object)this.crosstab));
        }
        this.m_frame = null;
    }

    public boolean isFirstPhysicalPage() {
        return this.index == 0;
    }

    public boolean isLastPhysicalPage() {
        if (this.v != null) {
            if (this.index < this.v.size() - 1) {
                return false;
            }
            if (this.hashTable.get(this.viewLogPageNum + 1) != null) {
                return true;
            }
            return this.currentOuter > this.outerLoop;
        }
        return false;
    }

    public Crosstab getCrosstab() {
        return this.crosstab;
    }

    public void setCrosstab(Crosstab crosstab) {
        this.crosstab = crosstab;
        this.gridView = crosstab;
        this.setDataview(crosstab);
    }

    public boolean calcPageBounds(DataSubsetRecord record) {
        if (this.crosstab.isDataUnavailable()) {
            this.crosstab.getErrorHandler().log("data is unavailable to print", ((Object)((Object)this)).getClass().getName(), "calcPageBounds");
            return false;
        }
        if (record == null) {
            this.crosstab.getErrorHandler().log("invalid data subset record", ((Object)((Object)this)).getClass().getName(), m_method_calcpagebounds);
            return false;
        }
        if (this.resize) {
            this.resizeGridView();
            this.crosstab.validate();
            this.resize = false;
        }
        this.subSetRecord = record;
        int yVal = this.pivot.getPivotGrid().getGrid().getRowPosition(this.subSetRecord.firstRow);
        int xVal = this.subSetRecord.x1 >= 0 ? this.subSetRecord.x1 : this.pivot.getPivotGrid().getGrid().getColumnPosition(this.subSetRecord.firstColumn);
        int height = this.viewDim.height;
        this.calcAdornmentsDimension(this.viewDim.width);
        if (this.isRepeatHeaders()) {
            height -= this.totalAdornHeight;
        }
        if (!this.isRepeatHeaders() && yVal == 0) {
            height -= this.totalAdornHeight;
        } else if (!this.isRepeatHeaders() && yVal != 0) {
            height -= this.repeatAdornHeight;
        }
        if (height < 20 || this.viewDim.width < 20) {
            this.logInsuffMsg("calcPageBounds");
            return false;
        }
        Rectangle pageBounds = this.getPageBounds(xVal, yVal, this.viewDim.width, height);
        this.documentSize = this.pivot.getDocumentSize(this.pivot.getPaintContext(), this.printProperties);
        this.adjustForPageBreak(yVal, (PaginationRecord)this.subSetRecord, pageBounds);
        this.subSetRecord.lastRow = this.pivot.getPivotGrid().getGrid().getRowAt(pageBounds.y + yVal);
        if (this.subSetRecord.lastRow != this.subSetRecord.firstRow) {
            --this.subSetRecord.lastRow;
        }
        if (this.subSetRecord.lastRow < 0) {
            this.subSetRecord.lastRow = this.pivot.getPivotGrid().getGrid().getRowCount() - 1;
        }
        this.subSetRecord.lastColumn = this.pivot.getPivotGrid().getGrid().getColumnAt(pageBounds.x + xVal);
        if (this.subSetRecord.lastColumn == this.subSetRecord.firstColumn) {
            this.subSetRecord.x1 = xVal;
            this.subSetRecord.x2 = pageBounds.x + xVal;
        } else {
            --this.subSetRecord.lastColumn;
            this.subSetRecord.x1 = -1;
            this.subSetRecord.x2 = -1;
        }
        if (this.subSetRecord.lastColumn < 0) {
            this.subSetRecord.lastColumn = this.pivot.getPivotGrid().getGrid().getColumnCount() - 1;
        }
        this.subSetRecord.x = xVal;
        this.subSetRecord.y = yVal;
        this.subSetRecord.width = pageBounds.width;
        this.subSetRecord.height = pageBounds.height;
        this.subSetRecord.needsRecalc = false;
        return true;
    }

    public boolean printPage(Graphics g) {
        if (this.crosstab.isDataUnavailable()) {
            this.crosstab.getErrorHandler().log("data is unavailable to print", ((Object)((Object)this)).getClass().getName(), "printPage");
            return false;
        }
        int oldLeftM = this.leftMargin;
        int oldTopM = this.topMargin;
        this.leftMargin = 0;
        this.topMargin = 0;
        this.printableWidth = this.viewDim.width;
        this.printableHeight = this.viewDim.height;
        this.printToGraphics(g, (PaginationRecord)this.subSetRecord);
        this.leftMargin = oldLeftM;
        this.topMargin = oldTopM;
        return true;
    }

    public boolean printPage(Graphics g, DataSubsetRecord record) {
        if (this.crosstab.isDataUnavailable()) {
            this.crosstab.getErrorHandler().log("data is unavailable to print", ((Object)((Object)this)).getClass().getName(), "printPage");
            return false;
        }
        try {
            if (record.needsRecalc) {
                int rowPivotHeaderWidth;
                int columnPivotHeaderHeight;
                if (this.logicalPage == null) {
                    this.setLogicalPage(this.crosstab.getCrosstabModel().getDataAccess().getEdgeCurrentHPos(2));
                }
                this.fetchRowBlock(record.firstRow, record.lastRow);
                this.resizeColumnWidths(record.firstColumn, record.lastColumn, -1, -1);
                int startCol = -1;
                int endCol = -1;
                if ((this.crosstab.getAutoFitScope() & 1) > 0) {
                    Range colRange = this.crosstab.getAutoFitColumnRange(record.firstColumn);
                    startCol = colRange.begin;
                    endCol = colRange.end;
                }
                if (endCol < startCol) {
                    this.crosstab.getErrorHandler().log("invalid column range", ((Object)((Object)this)).getClass().getName(), m_method_printPage);
                }
                this.resizeRowHeights(startCol, endCol, record.firstRow, record.lastRow);
                if ((this.crosstab.getAutoFitScope() & 1) > 0 && this.crosstab.getAutoFitColumnRangeCallback() != null) {
                    this.crosstab.getAutoFitColumnRangeCallback().endAutoFit();
                }
                this.crosstab.validate();
                record.x = record.x1 == -1 ? this.pivot.getPivotGrid().getGrid().getColumnPosition(record.firstColumn) : record.x1;
                record.y = this.pivot.getPivotGrid().getGrid().getRowPosition(record.firstRow);
                int lastRowEndPos = 0;
                if (record.lastRow < this.pivot.getPivotGrid().getGrid().getRowCount() - 1) {
                    lastRowEndPos = this.pivot.getPivotGrid().getGrid().getRowPosition(record.lastRow + 1);
                } else {
                    this.documentSize = this.pivot.getDocumentSize(this.pivot.getPaintContext(), this.printProperties);
                    lastRowEndPos = this.documentSize.height - this.pivot.getPivotGrid().getColumnHeader().getHeight();
                }
                record.height = lastRowEndPos - record.y;
                int height = this.viewDim.height;
                this.calcAdornmentsDimension(this.viewDim.width);
                if (this.isRepeatHeaders()) {
                    height -= this.totalAdornHeight;
                }
                if (!this.isRepeatHeaders() && record.y == 0) {
                    height -= this.totalAdornHeight;
                } else if (!this.isRepeatHeaders() && record.y != 0) {
                    height -= this.repeatAdornHeight;
                }
                if (height < 20 || this.viewDim.width < 20) {
                    this.logInsuffMsg("printPage");
                    return false;
                }
                int columnHandle = 0;
                if (this.crosstab.isPivotLabelVisible() && this.pivot.getPivotGrid().isColumnHeaderVisible()) {
                    columnHandle = this.pivot.getPivotGrid().getColumnHeaderHeight();
                }
                if (columnHandle >= height) {
                    int temp = height / 8;
                    columnHandle = height - temp;
                }
                record.height += columnHandle;
                boolean showColHeader = record.y == 0 || this.isRepeatComponent(1);
                int n = columnPivotHeaderHeight = showColHeader && this.pivot.isColumnPivotHeaderVisible() ? this.pivot.getColumnPivotHeader().getSize().height : 0;
                if (columnPivotHeaderHeight >= height) {
                    int temp = height / 8;
                    columnPivotHeaderHeight = height - temp;
                }
                record.height += columnPivotHeaderHeight;
                int lastColumnEndPos = 0;
                lastColumnEndPos = record.x2 != -1 ? record.x2 : (record.lastColumn < this.pivot.getPivotGrid().getGrid().getColumnCount() - 1 ? this.pivot.getPivotGrid().getGrid().getColumnPosition(record.lastColumn + 1) : this.documentSize.width - this.pivot.getPivotGrid().getRowHeader().getWidth());
                record.width = lastColumnEndPos - record.x;
                int rowHandle = 0;
                if (this.crosstab.isPivotLabelVisible() && this.pivot.getPivotGrid().isRowHeaderVisible()) {
                    rowHandle = this.pivot.getPivotGrid().getRowHeaderWidth();
                }
                if (rowHandle >= this.viewDim.width) {
                    int temp = this.viewDim.width / 8;
                    rowHandle = this.viewDim.width - temp;
                }
                record.width += rowHandle;
                boolean showRowHeader = record.x == 0 || this.isRepeatComponent(2);
                int n2 = rowPivotHeaderWidth = showRowHeader && this.pivot.isRowPivotHeaderVisible() ? this.pivot.getRowPivotHeader().getSize().width : 0;
                if (rowPivotHeaderWidth >= this.viewDim.width) {
                    int temp = this.viewDim.width / 8;
                    rowPivotHeaderWidth = this.viewDim.width - temp;
                }
                record.width += rowPivotHeaderWidth;
            }
            this.subSetRecord = record;
            this.printPage(g);
            return true;
        }
        catch (DataException exception) {
            this.crosstab.getErrorHandler().error((Throwable)exception, ((Object)((Object)this)).getClass().getName(), "printPage");
            return false;
        }
    }

    protected void printPages(PrintJob pjob, boolean currentLogPage) {
        try {
            int pageNum = 1;
            this.printableWidth = this.dimension.width - (this.leftMargin + this.rightMargin);
            if (this.printableWidth < 20) {
                this.logInsuffMsg("printPages");
                return;
            }
            boolean first = true;
            this.currentLogicalPage = currentLogPage;
            int[] hPos = null;
            if (currentLogPage) {
                hPos = this.currLogPage.getHPos();
            } else if (this.rangeType == 1) {
                hPos = this.crosstab.getCrosstabModel().getDataAccess().getFirstHPos(2);
            } else if (this.m_selectedHPos != null && this.m_selectedHPos.size() > 0) {
                hPos = (int[])this.m_selectedHPos.elementAt(0);
            }
            if (hPos == null) {
                hPos = new int[]{};
            }
            while (hPos != null) {
                DataAccess access = this.crosstab.getCrosstabModel().getDataAccess();
                if (!currentLogPage) {
                    this.changePageEdgeCurrentHPos(hPos, hPos.length - 1);
                }
                this.initCache();
                if (access.getEdgeExtent(1) != 0 && access.getEdgeExtent(0) != 0) {
                    this.resizeGridView();
                    this.crosstab.validate();
                    first = true;
                    this.calcAdornmentsDimension(this.printableWidth);
                    this.documentSize = this.pivot.getDocumentSize(this.pivot.getPaintContext(), this.printProperties);
                    int outerLoopEnd = this.documentSize.height;
                    int innerLoopEnd = this.documentSize.width;
                    if (!this.printByColumns) {
                        outerLoopEnd = this.documentSize.width;
                        innerLoopEnd = this.documentSize.height;
                    }
                    int curX = 0;
                    int curY = 0;
                    int currOuter = 0;
                    while (currOuter <= outerLoopEnd) {
                        int currInner = 0;
                        Rectangle newPageBounds = null;
                        while (currInner <= innerLoopEnd) {
                            Graphics g = pjob.getGraphics();
                            this.record = new PaginationRecord();
                            this.record.pageNum = pageNum++;
                            ++this.m_seqPageNumber;
                            this.viewLogPage.setHPos(hPos);
                            this.calcMargins(g);
                            this.printableHeight = this.dimension.height - (this.topMargin + this.bottomMargin);
                            if (first) {
                                if (this.isRepeatHeaders()) {
                                    this.pivotTableHeight = this.printableHeight - this.totalAdornHeight;
                                }
                                first = false;
                            }
                            if (!this.isRepeatHeaders() && curY == 0) {
                                this.pivotTableHeight = this.printableHeight - this.totalAdornHeight;
                            } else if (!this.isRepeatHeaders() && curY != 0) {
                                this.pivotTableHeight = this.printableHeight - this.repeatAdornHeight;
                            }
                            if (this.pivotTableHeight < 20) {
                                this.logInsuffMsg("printPages");
                                break;
                            }
                            newPageBounds = this.getPageBounds(curX, curY, this.printableWidth, this.pivotTableHeight);
                            this.documentSize = this.pivot.getDocumentSize(this.pivot.getPaintContext(), this.printProperties);
                            if (this.printByColumns) {
                                outerLoopEnd = this.documentSize.height;
                                innerLoopEnd = this.documentSize.width;
                            } else {
                                outerLoopEnd = this.documentSize.width;
                                innerLoopEnd = this.documentSize.height;
                            }
                            this.record.y = curY;
                            this.record.x = curX;
                            this.record.height = newPageBounds.height;
                            this.record.width = newPageBounds.width;
                            this.record.firstRow = this.pivot.getPivotGrid().getGrid().getRowAt(curY);
                            this.record.lastRow = this.pivot.getPivotGrid().getGrid().getRowAt(curY + newPageBounds.y - 1);
                            this.record.firstColumn = this.pivot.getPivotGrid().getGrid().getColumnAt(curX);
                            this.record.lastColumn = this.pivot.getPivotGrid().getGrid().getColumnAt(curX + newPageBounds.x - 1);
                            if (this.record.lastRow < 0) {
                                this.record.lastRow = this.pivot.getPivotGrid().getGrid().getRowCount() - 1;
                            }
                            if (this.record.lastColumn < 0) {
                                this.record.lastColumn = this.pivot.getPivotGrid().getGrid().getColumnCount() - 1;
                            }
                            this.adjustForPageBreak(curY, this.record, newPageBounds);
                            this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
                            this.printToGraphics(g, this.record);
                            this.printHeaderAndFooter(g);
                            g.dispose();
                            if (this.printByColumns) {
                                currInner = curX += newPageBounds.x;
                                continue;
                            }
                            currInner = curY += newPageBounds.y;
                        }
                        if (this.printByColumns) {
                            curX = 0;
                            currOuter = curY += newPageBounds.y;
                            continue;
                        }
                        curY = 0;
                        currOuter = curX += newPageBounds.x;
                    }
                }
                if (!currentLogPage) {
                    if (this.rangeType == 1) {
                        hPos = this.crosstab.getCrosstabModel().getDataAccess().getNextHPos(2, hPos);
                        continue;
                    }
                    ++this.m_selectedIndex;
                    if (this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex) {
                        hPos = (int[])this.m_selectedHPos.elementAt(this.m_selectedIndex);
                        continue;
                    }
                    hPos = null;
                    continue;
                }
                hPos = null;
            }
            if (this.tempFrame != null) {
                this.tempFrame.dispose();
                this.tempFrame = null;
            }
        }
        catch (DataException exception) {
            this.crosstab.getErrorHandler().error((Throwable)exception, ((Object)((Object)this)).getClass().getName(), "printPages");
        }
    }

    protected void printToGraphics(Graphics g2, PaginationRecord record) {
        int x;
        PaintContext printContext;
        Graphics g = g2 instanceof PrinterGraphics2DProxy || !(g2 instanceof PrinterGraphics) ? g2 : PrinterUtils.getIntegerPrintGraphics((PrinterGraphics)((PrinterGraphics)((Object)g2)));
        Shape savedBounds = g.getClip();
        this.pagingSp = false;
        this.titleSp = false;
        this.subtitleSp = false;
        this.textPaneSp = false;
        this.footnoteSp = false;
        int pageDims = 0;
        try {
            pageDims = this.gridView.getGridViewModel().getDataAccess().getLayerCount(2);
        }
        catch (EdgeOutOfRangeException e) {
            this.crosstab.getErrorHandler().error((Throwable)e, ((Object)((Object)this)).getClass().getName(), "printToGraphics");
        }
        this.saveAdornmentsSize();
        int prefWidth = 0;
        int prefHeight = 0;
        int translatedWidth = this.leftMargin;
        int translatedHeight = this.topMargin;
        g.translate(this.leftMargin, this.topMargin);
        if (this.m_topFormattedText != null && (this.isRepeatComponent(64) || record.x == 0 && record.y == 0)) {
            g.setClip(0, 0, this.printableWidth, this.topFTAHeight);
            this.m_topFormattedText.print(new Dimension(this.printableWidth, this.topFTAHeight), g);
            g.translate(0, this.topFTAHeight);
            translatedHeight += this.topFTAHeight;
            this.textPaneSp = true;
        } else if (this.m_topFormattedText != null && (this.isRepeatComponent(64) || record.y == 0)) {
            g.translate(0, this.topFTAHeight);
            translatedHeight += this.topFTAHeight;
            this.textPaneSp = true;
        }
        if (this.crosstab.isPagingControlVisible() && pageDims > 0 && this.crosstab.getPagingControlPosition() == 0 && (this.isRepeatComponent(4) || record.x == 0 && record.y == 0)) {
            g.setClip(0, 0, this.pagingControlBounds.width, this.pagingControlBounds.height);
            this.crosstab.getPagingControl().getPagingComponent().validate();
            printContext = this.crosstab.getPagingControl().getPagingComponent().getPrintPaintContext(g);
            this.crosstab.getPagingControl().getPagingComponent().printPage(printContext, null, g);
            g.translate(0, this.pagingControlBounds.height);
            translatedHeight += this.pagingControlBounds.height;
            this.pagingSp = true;
        } else if (this.crosstab.isPagingControlVisible() && pageDims > 0 && this.crosstab.getPagingControlPosition() == 0 && !this.isRepeatComponent(4) && record.y == 0) {
            g.translate(0, this.pagingControlBounds.height);
            translatedHeight += this.pagingControlBounds.height;
            this.pagingSp = true;
        }
        if (this.title.isVisible()) {
            this.title.setSize(this.printableWidth, this.title.getPreferredSize().height);
            prefHeight = this.title.getPreferredSize().height;
            prefWidth = this.title.getPreferredSize().width;
            if (prefWidth > this.printableWidth) {
                prefWidth = this.printableWidth;
            }
            this.title.setSize(prefWidth, prefHeight);
        }
        if (this.title.isVisible() && (this.isRepeatComponent(8) || record.x == 0 && record.y == 0)) {
            this.titleHeight = prefHeight;
            g.setClip(0, 0, this.printableWidth, this.titleHeight);
            x = 0;
            if (this.title.getHorizontalAlignment() == 0) {
                if (this.printableWidth > prefWidth) {
                    x += (this.printableWidth - prefWidth) / 2;
                }
            } else if (this.title.getHorizontalAlignment() == 4) {
                x += this.printableWidth - prefWidth;
            }
            g.translate(x, 0);
            this.title.print(g);
            g.translate(-x, this.titleHeight);
            translatedHeight += this.titleHeight;
            this.titleSp = true;
        } else if (this.title.isVisible() && (this.isRepeatComponent(8) || record.y == 0)) {
            this.titleHeight = prefHeight;
            g.translate(0, this.titleHeight);
            translatedHeight += this.titleHeight;
            this.titleSp = true;
        }
        if (this.title.isVisible()) {
            this.title.setSize(this.oldTitleSize);
        }
        if (this.subtitle.isVisible()) {
            this.subtitle.setSize(this.printableWidth, this.subtitle.getPreferredSize().height);
            prefHeight = this.subtitle.getPreferredSize().height;
            prefWidth = this.subtitle.getPreferredSize().width;
            if (prefWidth > this.printableWidth) {
                prefWidth = this.printableWidth;
            }
            this.subtitle.setSize(prefWidth, prefHeight);
        }
        if (this.subtitle.isVisible() && (this.isRepeatComponent(16) || record.x == 0 && record.y == 0)) {
            this.subtitleHeight = prefHeight;
            g.setClip(0, 0, this.printableWidth, this.subtitleHeight);
            x = 0;
            if (this.subtitle.getHorizontalAlignment() == 0) {
                if (this.printableWidth > prefWidth) {
                    x += (this.printableWidth - prefWidth) / 2;
                }
            } else if (this.subtitle.getHorizontalAlignment() == 4) {
                x += this.printableWidth - prefWidth;
            }
            g.translate(x, 0);
            this.subtitle.print(g);
            g.translate(-x, this.subtitleHeight);
            translatedHeight += this.subtitleHeight;
            this.subtitleSp = true;
        } else if (this.subtitle.isVisible() && (this.isRepeatComponent(16) || record.y == 0)) {
            this.subtitleHeight = prefHeight;
            g.translate(0, this.subtitleHeight);
            translatedHeight += this.subtitleHeight;
            this.subtitleSp = true;
        }
        if (this.subtitle.isVisible()) {
            this.subtitle.setSize(this.oldSubtitleSize);
        }
        if (this.crosstab.isPagingControlVisible() && pageDims > 0 && this.crosstab.getPagingControlPosition() == 1 && (this.isRepeatComponent(4) || record.x == 0 && record.y == 0)) {
            g.setClip(0, 0, this.pagingControlBounds.width, this.pagingControlBounds.height);
            this.crosstab.getPagingControl().getPagingComponent().validate();
            printContext = this.crosstab.getPagingControl().getPagingComponent().getPrintPaintContext(g);
            this.crosstab.getPagingControl().getPagingComponent().printPage(printContext, null, g);
            g.translate(0, this.pagingControlBounds.height);
            translatedHeight += this.pagingControlBounds.height;
            this.pagingSp = true;
        } else if (this.crosstab.isPagingControlVisible() && pageDims > 0 && this.crosstab.getPagingControlPosition() == 1 && !this.isRepeatComponent(4) && record.y == 0) {
            g.translate(0, this.pagingControlBounds.height);
            translatedHeight += this.pagingControlBounds.height;
            this.pagingSp = true;
        }
        printContext = this.pivot.getPrintPaintContext(g);
        g.setClip(0, 0, record.width, record.height);
        g.translate(-record.x, -record.y);
        this.pivot.printPage(printContext, this.printProperties, g);
        g.translate(record.x, record.y);
        g.setClip(null);
        if (this.footnote.isVisible()) {
            this.footnote.setSize(this.printableWidth, this.footnote.getPreferredSize().height);
            prefHeight = this.footnote.getPreferredSize().height;
            prefWidth = this.footnote.getPreferredSize().width;
            if (prefWidth > this.printableWidth) {
                prefWidth = this.printableWidth;
            }
            this.footnote.setSize(prefWidth, prefHeight);
        }
        if (this.footnote.isVisible() && (this.isRepeatComponent(32) || record.y + record.height >= this.documentSize.height && record.x + record.width >= this.documentSize.width)) {
            int footnoteStart = this.printableHeight - this.footnote.getPreferredSize().height;
            if (this.pagingSp) {
                footnoteStart -= this.pagingControlBounds.height;
            }
            if (this.titleSp) {
                footnoteStart -= this.titleHeight;
            }
            if (this.subtitleSp) {
                footnoteStart -= this.subtitleHeight;
            }
            if (this.textPaneSp) {
                footnoteStart -= this.topFTAHeight;
            }
            if (this.m_bottomFormattedText != null) {
                footnoteStart -= this.bottomFTAHeight;
            }
            g.translate(0, footnoteStart);
            translatedHeight += footnoteStart;
            g.setClip(0, 0, this.printableWidth, this.footnote.getPreferredSize().height);
            this.footnoteSp = true;
            int x2 = 0;
            if (this.footnote.getHorizontalAlignment() == 0) {
                if (this.printableWidth > prefWidth) {
                    x2 += (this.printableWidth - prefWidth) / 2;
                }
            } else if (this.footnote.getHorizontalAlignment() == 4) {
                x2 += this.printableWidth - prefWidth;
            }
            g.translate(x2, 0);
            this.footnote.print(g);
            g.translate(-x2, 0);
            g.translate(0, this.footnote.getPreferredSize().height);
            translatedHeight += this.footnote.getPreferredSize().height;
        }
        if (this.footnote.isVisible()) {
            this.footnote.setSize(this.oldFootnoteSize);
        }
        if (this.m_bottomFormattedText != null && (this.isRepeatComponent(128) || record.y + record.height >= this.documentSize.height && record.x + record.width >= this.documentSize.width)) {
            if (!this.footnoteSp) {
                int bottomFTAStart = this.printableHeight - this.bottomFTAHeight;
                if (this.pagingSp) {
                    bottomFTAStart -= this.pagingControlBounds.height;
                }
                if (this.titleSp) {
                    bottomFTAStart -= this.titleHeight;
                }
                if (this.subtitleSp) {
                    bottomFTAStart -= this.subtitleHeight;
                }
                if (this.textPaneSp) {
                    bottomFTAStart -= this.topFTAHeight;
                }
                g.translate(0, bottomFTAStart);
                translatedHeight += bottomFTAStart;
            }
            g.setClip(0, 0, this.printableWidth, this.bottomFTAHeight);
            this.m_bottomFormattedText.print(new Dimension(this.printableWidth, this.bottomFTAHeight), g);
            g.translate(0, this.bottomFTAHeight);
            translatedHeight += this.bottomFTAHeight;
        }
        g.translate(-translatedWidth, -translatedHeight);
        g.setClip(savedBounds);
        this.crosstab.repaint();
    }

    public boolean goToFirstPage() {
        return this.prepareFirstPage(null);
    }

    public boolean prepareFirstPage(Graphics g) {
        if (this.crosstab.isDataUnavailable()) {
            this.crosstab.getErrorHandler().log("data is unavailable to print", ((Object)((Object)this)).getClass().getName(), "prepareFirstPage");
            return false;
        }
        this.hashTable = new Hashtable();
        this.pageNum = 0;
        this.m_seqPageNumber = 0;
        this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
        if (this.rangeType == 1) {
            try {
                this.viewLogPage.setHPos(this.crosstab.getCrosstabModel().getDataAccess().getFirstHPos(2));
                this.viewLogPageNum = 0;
            }
            catch (DataException e) {
                this.crosstab.getErrorHandler().error((Throwable)e, ((Object)((Object)this)).getClass().getName(), "prepareFirstPage");
            }
        } else if (this.rangeType == 0) {
            this.viewLogPage.setHPos(this.currLogPage.getHPos());
            this.viewLogPageNum = 0;
        } else if (this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex) {
            this.viewLogPage.setHPos((int[])this.m_selectedHPos.elementAt(this.m_selectedIndex));
            this.viewLogPageNum = 0;
        } else {
            return false;
        }
        this.checkDataSourceLogPage();
        this.initCache();
        this.resizeGridView();
        this.crosstab.validate();
        this.printableWidth = this.paperWidth - (this.leftMargin + this.rightMargin);
        this.calcAdornmentsDimension(this.printableWidth);
        this.currX = 0;
        this.currY = 0;
        this.currentOuter = 0;
        this.currentInner = 0;
        if (this.isRepeatHeaders()) {
            this.pivotTableHeight = this.printableHeight - this.totalAdornHeight;
        }
        if (!this.isRepeatHeaders() && this.currY == 0) {
            this.pivotTableHeight = this.printableHeight - this.totalAdornHeight;
        } else if (!this.isRepeatHeaders() && this.currY != 0) {
            this.pivotTableHeight = this.printableHeight - this.repeatAdornHeight;
        }
        if (this.pivotTableHeight < 20 || this.printableWidth < 20) {
            this.logInsuffMsg("prepareFirstPage");
            this.m_insuffSapce = true;
            return false;
        }
        this.newPageBounds = this.getPageBounds(this.currX, this.currY, this.printableWidth, this.pivotTableHeight);
        this.documentSize = this.pivot.getDocumentSize(this.pivot.getPaintContext(), this.printProperties);
        if (this.printByColumns) {
            this.outerLoop = this.documentSize.height;
            this.innerLoop = this.documentSize.width;
        } else {
            this.outerLoop = this.documentSize.width;
            this.innerLoop = this.documentSize.height;
        }
        this.record = new PaginationRecord();
        this.record.y = this.currY;
        this.record.x = this.currX;
        this.record.height = this.newPageBounds.height;
        this.record.width = this.newPageBounds.width;
        this.record.pageNum = ++this.pageNum;
        ++this.m_seqPageNumber;
        this.record.firstRow = this.pivot.getPivotGrid().getGrid().getRowAt(this.currY);
        this.record.lastRow = this.pivot.getPivotGrid().getGrid().getRowAt(this.currY + this.newPageBounds.y - 1);
        this.record.firstColumn = this.pivot.getPivotGrid().getGrid().getColumnAt(this.currX);
        this.record.lastColumn = this.pivot.getPivotGrid().getGrid().getColumnAt(this.currX + this.newPageBounds.x - 1);
        if (this.record.lastRow < 0) {
            this.record.lastRow = this.pivot.getPivotGrid().getGrid().getRowCount() - 1;
        }
        if (this.record.lastColumn < 0) {
            this.record.lastColumn = this.pivot.getPivotGrid().getGrid().getColumnCount() - 1;
        }
        this.calcMargins(g);
        this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
        this.adjustForPageBreak(this.currY, this.record, this.newPageBounds);
        this.v = new Vector();
        Vector firstVector = this.v;
        this.v.addElement(this.record);
        this.index = 0;
        this.hashTable.put(this.viewLogPageNum, firstVector);
        if (this.printByColumns) {
            this.currX += this.newPageBounds.x;
            this.currentInner = this.currX;
        } else {
            this.currY += this.newPageBounds.y;
            this.currentInner = this.currY;
        }
        if (this.currentInner >= this.innerLoop) {
            if (this.printByColumns) {
                this.currX = 0;
                this.currY += this.newPageBounds.y;
                this.currentOuter = this.currY;
            } else {
                this.currY = 0;
                this.currX += this.newPageBounds.x;
                this.currentOuter = this.currX;
            }
        }
        return true;
    }

    public boolean hasNextPage() {
        if (this.m_insuffSapce) {
            return false;
        }
        if (this.crosstab.isDataUnavailable()) {
            this.crosstab.getErrorHandler().log("data is unavailable to print", ((Object)((Object)this)).getClass().getName(), "hasNextPage");
            return false;
        }
        if (this.record != null && this.record.pageNum < this.pageNum) {
            return true;
        }
        if (this.currentInner < this.innerLoop && this.currentInner != 0) {
            return true;
        }
        if (this.currentOuter < this.outerLoop && this.currentOuter != 0) {
            return true;
        }
        try {
            if (this.rangeType == 1 && this.crosstab.getCrosstabModel().getDataAccess().getNextHPos(2, this.viewLogPage.getHPos()) != null) {
                this.newLogPageIsNext = true;
                return true;
            }
            if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex + 1) {
                this.newLogPageIsNext = true;
                return true;
            }
        }
        catch (DataException e) {
            this.crosstab.getErrorHandler().error((Throwable)e, ((Object)((Object)this)).getClass().getName(), "hasNextPage");
        }
        return false;
    }

    public boolean goToNextPage() {
        return this.prepareNextPage(null);
    }

    public boolean prepareNextPage(Graphics g) {
        if (this.crosstab.isDataUnavailable()) {
            this.crosstab.getErrorHandler().log("data is unavailable to print", ((Object)((Object)this)).getClass().getName(), "prepareNextPage");
            return false;
        }
        if (this.record != null && this.record.pageNum < this.pageNum) {
            if (this.index < this.v.size() - 1) {
                ++this.index;
                this.record = (PaginationRecord)this.v.elementAt(this.index);
                ++this.m_seqPageNumber;
                this.calcMargins(g);
                this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
                if (this.checkDataSourceLogPage()) {
                    this.fetchRowBlock(this.record.firstRow, this.record.lastRow);
                    this.resizeColumnWidths(this.record.firstColumn, this.record.lastColumn, -1, -1);
                    this.resizeRowHeights(-1, -1, this.record.firstRow, this.record.lastRow);
                } else {
                    this.resetCurrentLogicalPage();
                }
            } else {
                int[] nextHPos = null;
                try {
                    if (this.rangeType == 1) {
                        nextHPos = this.crosstab.getCrosstabModel().getDataAccess().getNextHPos(2, this.viewLogPage.getHPos());
                    } else if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex + 1) {
                        nextHPos = (int[])this.m_selectedHPos.elementAt(++this.m_selectedIndex);
                    }
                }
                catch (DataException e) {
                    this.crosstab.getErrorHandler().error((Throwable)e, ((Object)((Object)this)).getClass().getName(), "prepareNextPage");
                }
                if (nextHPos != null) {
                    this.updateCache();
                    this.viewLogPage.setHPos(nextHPos);
                    ++this.viewLogPageNum;
                    try {
                        this.changePageEdgeCurrentHPos(this.viewLogPage.getHPos(), this.viewLogPage.getHPos().length - 1);
                    }
                    catch (DataException e) {
                        this.crosstab.getErrorHandler().error((Throwable)e, ((Object)((Object)this)).getClass().getName(), "prepareNextPage");
                    }
                    this.initCache();
                    if (this.checkForNoData()) {
                        return false;
                    }
                    this.v = (Vector)this.hashTable.get(this.viewLogPageNum);
                    this.index = 0;
                    this.resizeGridView();
                    this.crosstab.validate();
                    this.calcAdornmentsDimension(this.printableWidth);
                }
                this.record = (PaginationRecord)this.v.elementAt(this.index);
                ++this.m_seqPageNumber;
                this.calcMargins(g);
                this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
                this.fetchRowBlock(this.record.firstRow, this.record.lastRow);
                this.resizeColumnWidths(this.record.firstColumn, this.record.lastColumn, -1, -1);
                this.resizeRowHeights(-1, -1, this.record.firstRow, this.record.lastRow);
            }
        } else {
            if (this.currentOuter > this.outerLoop || this.newLogPageIsNext) {
                this.newLogPageIsNext = false;
                this.index = -1;
                this.currX = 0;
                this.currY = 0;
                this.currentOuter = 0;
                this.currentInner = 0;
                int[] nextHPos = null;
                try {
                    if (this.rangeType == 1) {
                        nextHPos = this.crosstab.getCrosstabModel().getDataAccess().getNextHPos(2, this.viewLogPage.getHPos());
                    } else if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex + 1) {
                        nextHPos = (int[])this.m_selectedHPos.elementAt(++this.m_selectedIndex);
                    }
                }
                catch (DataException e) {
                    this.crosstab.getErrorHandler().error((Throwable)e, ((Object)((Object)this)).getClass().getName(), "prepareNextPage");
                }
                if (nextHPos != null) {
                    this.updateCache();
                    try {
                        this.viewLogPage.setHPos(nextHPos);
                        ++this.viewLogPageNum;
                        this.changePageEdgeCurrentHPos(this.viewLogPage.getHPos(), this.viewLogPage.getHPos().length - 1);
                    }
                    catch (DataException e) {
                        this.crosstab.getErrorHandler().error((Throwable)e, ((Object)((Object)this)).getClass().getName(), "prepareNextPage");
                    }
                    this.initCache();
                }
                if (this.checkForNoData()) {
                    return false;
                }
                this.resizeGridView();
                this.crosstab.validate();
                this.calcAdornmentsDimension(this.printableWidth);
                this.record = new PaginationRecord();
                this.record.pageNum = ++this.pageNum;
                ++this.m_seqPageNumber;
                this.calcMargins(g);
                this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
                this.documentSize = this.pivot.getDocumentSize(this.pivot.getPaintContext(), this.printProperties);
                this.outerLoop = this.documentSize.height;
                this.innerLoop = this.documentSize.width;
                if (!this.printByColumns) {
                    this.outerLoop = this.documentSize.width;
                    this.innerLoop = this.documentSize.height;
                }
                this.v = new Vector();
                Vector nexVector = this.v;
                this.hashTable.put(this.viewLogPageNum, nexVector);
            } else {
                this.record = new PaginationRecord();
                this.record.pageNum = ++this.pageNum;
                ++this.m_seqPageNumber;
                this.calcMargins(g);
                this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
            }
            if (this.isRepeatHeaders()) {
                this.pivotTableHeight = this.printableHeight - this.totalAdornHeight;
            }
            if (!this.isRepeatHeaders() && this.currY == 0) {
                this.pivotTableHeight = this.printableHeight - this.totalAdornHeight;
            } else if (!this.isRepeatHeaders() && this.currY != 0) {
                this.pivotTableHeight = this.printableHeight - this.repeatAdornHeight;
            }
            this.printableWidth = this.paperWidth - (this.leftMargin + this.rightMargin);
            if (this.pivotTableHeight < 20 || this.printableWidth < 20) {
                this.logInsuffMsg("prepareNextPage");
                this.m_insuffSapce = true;
                return false;
            }
            this.newPageBounds = this.getPageBounds(this.currX, this.currY, this.printableWidth, this.pivotTableHeight);
            this.documentSize = this.pivot.getDocumentSize(this.pivot.getPaintContext(), this.printProperties);
            if (this.printByColumns) {
                this.outerLoop = this.documentSize.height;
                this.innerLoop = this.documentSize.width;
            } else {
                this.outerLoop = this.documentSize.width;
                this.innerLoop = this.documentSize.height;
            }
            this.record.y = this.currY;
            this.record.x = this.currX;
            this.record.height = this.newPageBounds.height;
            this.record.width = this.newPageBounds.width;
            this.record.firstRow = this.pivot.getPivotGrid().getGrid().getRowAt(this.currY);
            this.record.lastRow = this.pivot.getPivotGrid().getGrid().getRowAt(this.currY + this.newPageBounds.y - 1);
            this.record.firstColumn = this.pivot.getPivotGrid().getGrid().getColumnAt(this.currX);
            this.record.lastColumn = this.pivot.getPivotGrid().getGrid().getColumnAt(this.currX + this.newPageBounds.x - 1);
            if (this.record.lastRow < 0) {
                this.record.lastRow = this.pivot.getPivotGrid().getGrid().getRowCount() - 1;
            }
            if (this.record.lastColumn < 0) {
                this.record.lastColumn = this.pivot.getPivotGrid().getGrid().getColumnCount() - 1;
            }
            this.adjustForPageBreak(this.currY, this.record, this.newPageBounds);
            ++this.index;
            if (this.v == null) {
                this.v = new Vector();
            }
            this.v.addElement(this.record);
            if (this.printByColumns) {
                this.currX += this.newPageBounds.x;
                this.currentInner = this.currX;
            } else {
                this.currY += this.newPageBounds.y;
                this.currentInner = this.currY;
            }
            if (this.currentInner >= this.innerLoop) {
                if (this.printByColumns) {
                    this.currX = 0;
                    this.currY += this.newPageBounds.y;
                    this.currentOuter = this.currY;
                } else {
                    this.currY = 0;
                    this.currX += this.newPageBounds.x;
                    this.currentOuter = this.currX;
                }
            }
        }
        return true;
    }

    public boolean hasPrevPage() {
        if (this.crosstab.isDataUnavailable()) {
            this.crosstab.getErrorHandler().log("data is unavailable to print", ((Object)((Object)this)).getClass().getName(), "hasPrevPage");
            return false;
        }
        if (this.index > 0) {
            return true;
        }
        try {
            if (this.rangeType == 1 && this.crosstab.getCrosstabModel().getDataAccess().getPrevHPos(2, this.viewLogPage.getHPos()) != null) {
                return true;
            }
            if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedIndex > 0) {
                this.newLogPageIsNext = true;
                return true;
            }
        }
        catch (DataException e) {
            this.crosstab.getErrorHandler().error((Throwable)e, ((Object)((Object)this)).getClass().getName(), "hasPrevPage");
        }
        return false;
    }

    public boolean goToPrevPage() {
        return this.preparePrevPage(null);
    }

    public boolean preparePrevPage(Graphics g) {
        if (this.crosstab.isDataUnavailable()) {
            this.crosstab.getErrorHandler().log("data is unavailable to print", ((Object)((Object)this)).getClass().getName(), "preparePrevPage");
            return false;
        }
        if (this.index > 0) {
            --this.index;
            this.record = (PaginationRecord)this.v.elementAt(this.index);
            --this.m_seqPageNumber;
            if (this.checkDataSourceLogPage()) {
                this.fetchRowBlock(this.record.firstRow, this.record.lastRow);
                this.resizeColumnWidths(this.record.firstColumn, this.record.lastColumn, -1, -1);
                this.resizeRowHeights(-1, -1, this.record.firstRow, this.record.lastRow);
            } else {
                this.resetCurrentLogicalPage();
            }
        } else {
            int[] previous = null;
            try {
                if (this.rangeType == 1) {
                    previous = this.crosstab.getCrosstabModel().getDataAccess().getPrevHPos(2, this.viewLogPage.getHPos());
                } else if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedIndex > 0) {
                    previous = (int[])this.m_selectedHPos.elementAt(--this.m_selectedIndex);
                }
            }
            catch (DataException e) {
                this.crosstab.getErrorHandler().error((Throwable)e, ((Object)((Object)this)).getClass().getName(), "preparePrevPage");
            }
            if (previous != null) {
                this.updateCache();
                try {
                    this.viewLogPage.setHPos(previous);
                    --this.viewLogPageNum;
                    this.changePageEdgeCurrentHPos(this.viewLogPage.getHPos(), this.viewLogPage.getHPos().length - 1);
                }
                catch (DataException e) {
                    this.crosstab.getErrorHandler().error((Throwable)e, ((Object)((Object)this)).getClass().getName(), "preparePrevPage");
                }
                this.initCache();
                if (this.checkForNoData()) {
                    return false;
                }
                this.v = (Vector)this.hashTable.get(this.viewLogPageNum);
                this.index = this.v.size() - 1;
                --this.m_seqPageNumber;
                this.resizeGridView();
                this.crosstab.validate();
                this.calcAdornmentsDimension(this.printableWidth);
                this.record = (PaginationRecord)this.v.elementAt(this.index);
                this.fetchRowBlock(this.record.firstRow, this.record.lastRow);
                this.resizeColumnWidths(0, this.record.lastColumn, -1, -1);
                this.resizeRowHeights(-1, -1, 0, this.record.lastRow);
            }
        }
        this.calcMargins(g);
        this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
        return true;
    }

    @Override
    protected void resizeGridView() {
        this.crosstab.sizeRowHeaderColumnWidths();
        this.crosstab.updateColumnHeaderRowHeights();
        this.crosstab.updatePivotHandleSize();
    }

    @Override
    protected boolean resizeRowHeights(int firstCol, int lastCol, int firstRow, int lastRow) {
        if (firstRow < 0 || lastRow < 0) {
            this.crosstab.getErrorHandler().log("invalid row index", ((Object)((Object)this)).getClass().getName(), m_method_resizerowheights);
            return false;
        }
        boolean returnVal = false;
        int rowHeight = 0;
        for (int row = firstRow; row <= lastRow; ++row) {
            if (!this.m_dirtyRowHeights[row]) continue;
            rowHeight = this.m_rowHeights[row];
            if (rowHeight < 0) {
                if ((this.crosstab.getAutoFitScope() & 1) > 0) {
                    rowHeight = this.crosstab.calcAutoFitRowHeights(firstCol, lastCol, row, row)[0];
                    this.crosstab.getCrosstabSizingManager().setCalculatedRowHeight(row, rowHeight);
                }
                this.crosstab.sizeRowHeights(row, row);
                this.m_rowHeights[row] = this.crosstab.getPivotTable().getRowHeight(row);
                if (this.m_bPreviewMode) {
                    this.m_bUpdateRowHeightsCache = true;
                }
            } else {
                this.crosstab.getPivotTable().setRowHeight(row, rowHeight);
            }
            this.m_dirtyRowHeights[row] = false;
            returnVal = true;
        }
        return returnVal;
    }

    @Override
    protected boolean resizeColumnWidths(int firstCol, int lastCol, int firstRow, int lastRow) {
        if (firstCol < 0 || lastCol < 0) {
            this.crosstab.getErrorHandler().log("invalid column index", ((Object)((Object)this)).getClass().getName(), m_method_resizeColumnWidths);
            return false;
        }
        boolean returnVal = false;
        int colWidth = 0;
        for (int col = firstCol; col <= lastCol; ++col) {
            if (!this.m_dirtyColWidths[col]) continue;
            colWidth = this.m_colWidths[col];
            if (colWidth < 0) {
                this.crosstab.sizeColumnWidths(col, col);
                this.m_colWidths[col] = this.crosstab.getPivotTable().getColumnWidth(col);
                if (this.m_bPreviewMode) {
                    this.m_bUpdateColWidthsCache = true;
                }
            } else {
                this.crosstab.getPivotTable().setColumnWidth(col, colWidth);
            }
            this.m_dirtyColWidths[col] = false;
            returnVal = true;
        }
        return returnVal;
    }

    protected Rectangle getPageBounds(int curX, int curY, int printableWidth, int pivotHeight) {
        Rectangle newPageBounds = this.pivot.getPageBounds(null, this.printProperties, curX, curY, printableWidth, pivotHeight);
        int firstRowOnPage = this.pivot.getPivotGrid().getGrid().getRowAt(curY);
        int firstColOnPage = this.pivot.getPivotGrid().getGrid().getColumnAt(curX);
        boolean bPageFilled = false;
        int nextRowToBeResized = firstRowOnPage;
        int lastRow = -1;
        int lastCol = -1;
        int startCol = -1;
        int endCol = -1;
        if ((this.crosstab.getAutoFitScope() & 1) > 0) {
            Range colRange = this.crosstab.getAutoFitColumnRange(firstColOnPage);
            startCol = colRange.begin;
            endCol = colRange.end;
        }
        if (endCol < startCol) {
            this.crosstab.getErrorHandler().log("invalid column range", ((Object)((Object)this)).getClass().getName(), "getPageBounds");
        }
        while (!bPageFilled) {
            int lastRowOnPage = this.pivot.getPivotGrid().getGrid().getRowAt(curY + newPageBounds.y - 1);
            try {
                lastRow = this.crosstab.getCrosstabModel().getDataAccess().getEdgeExtent(1) - 1;
            }
            catch (DataException de) {
                this.crosstab.getErrorHandler().error((Throwable)de, ((Object)((Object)this)).getClass().getName(), "getPageBounds");
                lastRow = firstRowOnPage;
            }
            if (lastRowOnPage < 0 || lastRowOnPage > lastRow) {
                lastRowOnPage = lastRow;
            }
            int lastFetchedRow = this.fetchRowBlock(firstRowOnPage, this.getLastRowToFetch(firstRowOnPage, lastRowOnPage));
            for (int row = nextRowToBeResized; row <= lastFetchedRow; ++row) {
                if (this.resizeRowHeights(startCol, endCol, row, row)) {
                    newPageBounds = this.pivot.getPageBounds(null, this.printProperties, curX, curY, printableWidth, pivotHeight);
                }
                if ((lastRowOnPage = this.pivot.getPivotGrid().getGrid().getRowAt(curY + newPageBounds.y - 1)) < 0 || lastRowOnPage > lastRow) {
                    lastRowOnPage = lastRow;
                }
                if ((lastRowOnPage <= -1 || lastRowOnPage >= row) && row != lastRow) continue;
                bPageFilled = true;
                break;
            }
            if (bPageFilled) continue;
            nextRowToBeResized = lastFetchedRow + 1;
        }
        if ((this.crosstab.getAutoFitScope() & 1) > 0 && this.crosstab.getAutoFitColumnRangeCallback() != null) {
            this.crosstab.getAutoFitColumnRangeCallback().endAutoFit();
        }
        int lastColOnPage = this.pivot.getPivotGrid().getGrid().getColumnAt(curX + newPageBounds.x - 1);
        try {
            lastCol = this.crosstab.getCrosstabModel().getDataAccess().getEdgeExtent(0) - 1;
        }
        catch (DataException de) {
            this.crosstab.getErrorHandler().error((Throwable)de, ((Object)((Object)this)).getClass().getName(), "getPageBounds");
            lastCol = firstColOnPage;
        }
        if (lastColOnPage < 0 || lastColOnPage > lastCol) {
            lastColOnPage = lastCol;
        }
        for (int col = firstColOnPage; col <= lastColOnPage + 1 && col <= lastCol; ++col) {
            if (this.resizeColumnWidths(col, col, -1, -1)) {
                newPageBounds = this.pivot.getPageBounds(null, this.printProperties, curX, curY, printableWidth, pivotHeight);
            }
            if ((lastColOnPage = this.pivot.getPivotGrid().getGrid().getColumnAt(curX + newPageBounds.x - 1)) < 0 || lastColOnPage > lastCol) {
                lastColOnPage = lastCol;
            }
            if (lastColOnPage > -1 && lastColOnPage < col || col == lastCol) break;
        }
        return newPageBounds;
    }

    private int calcZoomFactor() {
        int zoomFactorDown;
        int zoomFactorAcross;
        block10: {
            int columnHeaderHeight;
            int singlePageHeight;
            block9: {
                int tmpZoomFactor;
                int singlePageWidth = this.dimension.width - (this.leftMargin + this.rightMargin);
                int allPagesWidth = singlePageWidth * this.fitToNumPagesWide;
                singlePageHeight = this.dimension.height - (this.topMargin + this.bottomMargin);
                int allPagesHeight = singlePageHeight * this.fitToNumPagesTall;
                this.calcAdornmentsDimension(singlePageWidth);
                int tableWidth = this.pivot.getPivotGrid().getGrid().getColumnGeometryManager().getTotalSize();
                int rowHeaderWidth = 0;
                if (this.pivot.getRowPivotHeader().isVisible()) {
                    rowHeaderWidth = this.pivot.getRowPivotHeader().getCanvasWidth();
                    tableWidth = this.isRepeatComponent(2) ? (tableWidth += rowHeaderWidth * this.fitToNumPagesWide) : (tableWidth += rowHeaderWidth);
                }
                int tableHeight = this.pivot.getPivotGrid().getGrid().getRowGeometryManager().getTotalSize();
                columnHeaderHeight = 0;
                if (this.pivot.getColumnPivotHeader().isVisible()) {
                    columnHeaderHeight = this.pivot.getColumnPivotHeader().getCanvasHeight();
                    tableHeight = this.isRepeatComponent(1) ? (tableHeight += columnHeaderHeight * this.fitToNumPagesTall) : (tableHeight += columnHeaderHeight);
                }
                tableHeight = this.isRepeatComponent(64) ? (tableHeight += this.topFTAHeight * this.fitToNumPagesTall) : (tableHeight += this.topFTAHeight);
                tableHeight = this.isRepeatComponent(8) ? (tableHeight += this.titleHeight * this.fitToNumPagesTall) : (tableHeight += this.titleHeight);
                tableHeight = this.isRepeatComponent(16) ? (tableHeight += this.subtitleHeight * this.fitToNumPagesTall) : (tableHeight += this.subtitleHeight);
                tableHeight = this.isRepeatComponent(4) ? (tableHeight += this.pagingControlBounds.height * this.fitToNumPagesTall) : (tableHeight += this.pagingControlBounds.height);
                tableHeight += (this.bottomFTAHeight + this.footnoteHeight) * this.fitToNumPagesTall;
                if (this.crosstab.isPivotLabelVisible() && this.crosstab.isRowHighlighterVisible()) {
                    tableWidth += this.pivot.getColumnSelectorWidth() * this.fitToNumPagesWide;
                }
                if (this.crosstab.isPivotLabelVisible() && this.crosstab.isColumnHighlighterVisible()) {
                    tableHeight += this.pivot.getRowSelectorHeight() * this.fitToNumPagesTall;
                }
                if (singlePageHeight - DataviewUtils.scaleByZoom((int)this.totalAdornHeight, (int)(tmpZoomFactor = Math.min(zoomFactorAcross = 100 * allPagesWidth / tableWidth, zoomFactorDown = 100 * allPagesHeight / tableHeight))) < DataviewUtils.scaleByZoom((int)columnHeaderHeight, (int)tmpZoomFactor) || singlePageWidth < DataviewUtils.scaleByZoom((int)rowHeaderWidth, (int)tmpZoomFactor)) {
                    this.logInsuffMsg("calcZoomFactor");
                    return -1;
                }
                if (zoomFactorAcross > zoomFactorDown) break block9;
                int pages = this.fitToNumPagesWide + 1;
                while (pages > this.fitToNumPagesWide && (pages = this.getTotalPagesAcross(rowHeaderWidth, zoomFactorAcross)) > this.fitToNumPagesWide) {
                    int diff = pages - this.fitToNumPagesWide;
                    int extraSpace = (diff - 1) * singlePageWidth + this.totalColWidth;
                    int additionalPerc = (int)((float)extraSpace / (float)(pages * singlePageWidth) * 100.0f);
                    if (additionalPerc == 0) {
                        additionalPerc = 1;
                    }
                    zoomFactorAcross -= additionalPerc;
                }
                break block10;
            }
            if (zoomFactorDown >= zoomFactorAcross) break block10;
            int pages = this.fitToNumPagesTall + 1;
            while (pages > this.fitToNumPagesTall && (pages = this.getTotalPagesDown(columnHeaderHeight, zoomFactorDown)) > this.fitToNumPagesTall) {
                int diff = pages - this.fitToNumPagesTall;
                int extraSpace = (diff - 1) * singlePageHeight + this.totalRowHeight;
                int additionalPerc = (int)((float)extraSpace / (float)(pages * singlePageHeight) * 100.0f);
                if (additionalPerc == 0) {
                    additionalPerc = 1;
                }
                zoomFactorDown -= additionalPerc;
            }
        }
        return Math.min(zoomFactorAcross, zoomFactorDown);
    }

    private int getTotalPagesDown(int columnHeaderHeight, int zoomFactorDown) {
        boolean adornHeight = false;
        int scaledColumnHeaderHeight = DataviewUtils.scaleByZoom((int)columnHeaderHeight, (int)zoomFactorDown);
        int gridHt = 0;
        int rowCount = this.pivot.getGridModel().getRowCount();
        int currRow = 0;
        int sepHeight = 0;
        if (this.pivot.getPivotGrid().getHorizontalSeparatorsVisible()) {
            sepHeight = this.crosstab.isGrid3D() ? 2 : 1;
        }
        int downPages = 0;
        block0: while (currRow < rowCount) {
            if (this.isRepeatHeaders()) {
                gridHt = this.dimension.height - (this.topMargin + this.bottomMargin) - scaledColumnHeaderHeight - (this.topFTAHeight + DataviewUtils.scaleByZoom((int)this.titleHeight, (int)zoomFactorDown) + DataviewUtils.scaleByZoom((int)this.subtitleHeight, (int)zoomFactorDown) + DataviewUtils.scaleByZoom((int)this.footnoteHeight, (int)zoomFactorDown) + DataviewUtils.scaleByZoom((int)this.pagingControlBounds.height, (int)zoomFactorDown) + this.bottomFTAHeight);
            } else if (currRow == 0) {
                gridHt = this.dimension.height - (this.topMargin + this.bottomMargin) - scaledColumnHeaderHeight - (this.topFTAHeight + DataviewUtils.scaleByZoom((int)this.titleHeight, (int)zoomFactorDown) + DataviewUtils.scaleByZoom((int)this.subtitleHeight, (int)zoomFactorDown) + DataviewUtils.scaleByZoom((int)this.footnoteHeight, (int)zoomFactorDown) + DataviewUtils.scaleByZoom((int)this.pagingControlBounds.height, (int)zoomFactorDown) + this.bottomFTAHeight);
            } else {
                gridHt = this.dimension.height - (this.topMargin + this.bottomMargin) - (DataviewUtils.scaleByZoom((int)this.footnoteHeight, (int)zoomFactorDown) + this.bottomFTAHeight);
                if (this.isRepeatComponent(8)) {
                    gridHt -= DataviewUtils.scaleByZoom((int)this.titleHeight, (int)zoomFactorDown);
                }
                if (this.isRepeatComponent(16)) {
                    gridHt -= DataviewUtils.scaleByZoom((int)this.subtitleHeight, (int)zoomFactorDown);
                }
                if (this.isRepeatComponent(4)) {
                    gridHt -= DataviewUtils.scaleByZoom((int)this.pagingControlBounds.height, (int)zoomFactorDown);
                }
            }
            int rowHeight = 0;
            boolean done = false;
            this.totalRowHeight = 0;
            while (this.totalRowHeight <= gridHt && !done) {
                if (rowHeight > gridHt) {
                    this.totalRowHeight = gridHt;
                    rowHeight -= gridHt;
                    done = true;
                    ++downPages;
                    continue block0;
                }
                int currRowHeight = DataviewUtils.scaleByZoom((int)this.pivot.getRowHeight(currRow++), (int)zoomFactorDown);
                if (rowHeight > 0 && rowHeight + (currRowHeight += sepHeight) > gridHt) {
                    done = true;
                    --currRow;
                    this.totalRowHeight = rowHeight;
                    rowHeight = 0;
                    ++downPages;
                    continue block0;
                }
                if (rowHeight == 0 && currRowHeight > gridHt) {
                    this.totalRowHeight = gridHt;
                    rowHeight = currRowHeight - gridHt;
                    ++downPages;
                    done = true;
                    continue block0;
                }
                this.totalRowHeight += rowHeight + currRowHeight;
                rowHeight = 0;
                if (this.totalRowHeight > gridHt) {
                    ++downPages;
                    --currRow;
                }
                if (currRow < rowCount) continue;
                ++downPages;
                done = true;
            }
        }
        return downPages;
    }

    private int getTotalPagesAcross(int rowHeaderWidth, int zoomFactorAcross) {
        boolean adornHeight = false;
        int scaledRowHeaderWidth = DataviewUtils.scaleByZoom((int)rowHeaderWidth, (int)zoomFactorAcross);
        int gridWd = 0;
        int colCount = this.pivot.getGridModel().getColumnCount();
        int currCol = 0;
        int sepWidth = 0;
        if (this.pivot.getPivotGrid().getVerticalSeparatorsVisible()) {
            sepWidth = this.crosstab.isGrid3D() ? 2 : 1;
        }
        int acrossPages = 0;
        block0: while (currCol < colCount) {
            gridWd = this.isRepeatComponent(2) ? this.dimension.width - (this.leftMargin + this.rightMargin) - scaledRowHeaderWidth : (currCol == 0 ? this.dimension.width - (this.leftMargin + this.rightMargin) - scaledRowHeaderWidth : this.dimension.width - (this.leftMargin + this.rightMargin));
            int columnWidth = 0;
            boolean done = false;
            this.totalColWidth = 0;
            while (this.totalColWidth <= gridWd && !done) {
                if (columnWidth > gridWd) {
                    this.totalColWidth = gridWd;
                    columnWidth -= gridWd;
                    done = true;
                    ++acrossPages;
                    continue block0;
                }
                int currColWidth = DataviewUtils.scaleByZoom((int)this.pivot.getColumnWidth(currCol++), (int)zoomFactorAcross);
                if (columnWidth > 0 && columnWidth + (currColWidth += sepWidth) > gridWd) {
                    done = true;
                    --currCol;
                    this.totalColWidth = columnWidth;
                    columnWidth = 0;
                    ++acrossPages;
                    continue block0;
                }
                if (columnWidth == 0 && currColWidth > gridWd) {
                    this.totalColWidth = gridWd;
                    columnWidth = currColWidth - gridWd;
                    ++acrossPages;
                    done = true;
                    continue block0;
                }
                this.totalColWidth += columnWidth + currColWidth;
                columnWidth = 0;
                if (this.totalColWidth > gridWd) {
                    ++acrossPages;
                    --currCol;
                }
                if (currCol < colCount) continue;
                ++acrossPages;
                done = true;
            }
        }
        return acrossPages;
    }

    private void adjustForPageBreak(int curY, PaginationRecord record, Rectangle newPageBounds) {
        GridViewAppearanceMgr appMgr = (GridViewAppearanceMgr)this.crosstab.getCrosstabDatabody().getAppearanceManager();
        int startRow = this.pivot.getPivotGrid().getGrid().getRowAt(curY);
        int lastRow = this.pivot.getPivotGrid().getGrid().getRowAt(newPageBounds.y + curY - 1);
        if (lastRow == -1) {
            lastRow = this.pivot.getPivotGrid().getGrid().getRowCount() - 1;
        }
        int pageBreakRow = -1;
        for (int row = startRow; row < lastRow; ++row) {
            ViewStyle style = appMgr.getCellAppearance(0, row);
            if (!style.isHPageBreak()) continue;
            pageBreakRow = row;
            break;
        }
        if (pageBreakRow != -1) {
            int columnPivotHeaderHeight;
            newPageBounds.y = record.height = this.pivot.getPivotGrid().getGrid().getRowPosition(pageBreakRow + 1) - this.pivot.getPivotGrid().getGrid().getRowPosition(startRow);
            int columnHandle = 0;
            if (this.crosstab.isPivotLabelVisible() && this.pivot.getPivotGrid().isColumnHeaderVisible()) {
                columnHandle = this.pivot.getPivotGrid().getColumnHeaderHeight();
            }
            if (columnHandle >= this.pivotTableHeight) {
                int temp = this.pivotTableHeight / 8;
                columnHandle = this.pivotTableHeight - temp;
            }
            record.height += columnHandle;
            boolean showColHeader = curY == 0 || this.isRepeatComponent(1);
            int n = columnPivotHeaderHeight = showColHeader && this.pivot.isColumnPivotHeaderVisible() ? this.pivot.getColumnPivotHeader().getSize().height : 0;
            if (columnPivotHeaderHeight >= this.pivotTableHeight) {
                int temp = this.pivotTableHeight / 8;
                columnPivotHeaderHeight = this.pivotTableHeight - temp;
            }
            record.height += columnPivotHeaderHeight;
        }
    }

    private void saveCellSelection() {
        this.selection = this.pivot.getSelection();
        TwoDSelection rsel = new TwoDSelection();
        TwoDSelection csel = new TwoDSelection();
        TwoDSelection gsel = new TwoDSelection();
        PivotTableSelection psel = new PivotTableSelection(csel, rsel, gsel);
        try {
            this.pivot.setSelection(psel);
        }
        catch (PropertyVetoException e) {
            this.crosstab.getErrorHandler().error((Throwable)e, ((Object)((Object)this)).getClass().getName(), m_method_saveCellSelection);
        }
        this.selectionRemoved = true;
    }

    private void logInsuffMsg(String method) {
        this.crosstab.getErrorHandler().log("Insufficient space to print the View", ((Object)((Object)this)).getClass().getName(), method);
    }
}

