/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import oracle.bali.ewt.elaf.basic.PivotGrippyPainter;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.FixedImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterTiler;
import oracle.bali.ewt.pivot.PivotHeaderPainter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.text.WrappedText;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dss.crosstab.ColHeaderData;
import oracle.dss.crosstab.ColPivotHeader;
import oracle.dss.crosstab.CrosstabAttributes;
import oracle.dss.crosstab.CrosstabCommon;
import oracle.dss.crosstab.CrosstabController;
import oracle.dss.crosstab.CrosstabControllerAdapter;
import oracle.dss.crosstab.CrosstabDatabody;
import oracle.dss.crosstab.CrosstabDefaultValues;
import oracle.dss.crosstab.CrosstabExcelHTMLExport;
import oracle.dss.crosstab.CrosstabFormatUtil;
import oracle.dss.crosstab.CrosstabHeaderCell;
import oracle.dss.crosstab.CrosstabModel;
import oracle.dss.crosstab.CrosstabModelAdapter;
import oracle.dss.crosstab.CrosstabPivotHeader;
import oracle.dss.crosstab.CrosstabPivotTable;
import oracle.dss.crosstab.CrosstabSizingManager;
import oracle.dss.crosstab.CrosstabUtils;
import oracle.dss.crosstab.CrosstabXML;
import oracle.dss.crosstab.PivotHandleCell;
import oracle.dss.crosstab.RowHeaderCell;
import oracle.dss.crosstab.RowHeaderData;
import oracle.dss.crosstab.RowHeaderPivotHandleData;
import oracle.dss.crosstab.RowPivotHeader;
import oracle.dss.crosstab.Total;
import oracle.dss.crosstab.UICrosstab;
import oracle.dss.crosstab.managers.CrosstabRuleSizing;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataRangeComponentHandle;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.DataviewViewStyleUtils;
import oracle.dss.dataView.DataviewXML;
import oracle.dss.dataView.EdgeComponentHandle;
import oracle.dss.dataView.EdgeRangeComponentHandle;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.LocalDataSource;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.RolloverTextManager;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.UIBundle;
import oracle.dss.dataView.managers.Styleable;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.CustomAnnotationCallback;
import oracle.dss.gridView.GridView;
import oracle.dss.gridView.GridViewAppearanceMgr;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewDatabody;
import oracle.dss.gridView.GridViewDatabodyInputHandler;
import oracle.dss.gridView.GridViewDatabodyStyleManager;
import oracle.dss.gridView.GridViewExcelHTMLExport;
import oracle.dss.gridView.GridViewFormatManager;
import oracle.dss.gridView.GridViewFormatUtils;
import oracle.dss.gridView.GridViewHeader;
import oracle.dss.gridView.GridViewHeaderStyleManager;
import oracle.dss.gridView.GridViewSelectionManager;
import oracle.dss.gridView.GridViewTable;
import oracle.dss.gridView.GridViewTextPainter;
import oracle.dss.gridView.UIFormat;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.rules.DiscriminatorRule;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.Rule;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataException;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeComponentInfo;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.Range;
import oracle.dss.util.RowComponentInfo;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.WaitData;
import oracle.dss.util.WaitDataAvailableEvent;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.BIPersistenceException;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.XMLObjectReader;

public class Crosstab
extends GridView
implements GridViewAttribute,
UICrosstab,
CrosstabAttributes,
CrosstabCommon {
    public static final int CROSSTAB = 21;
    public static final int ROW_HIGHLIGHTER = 22;
    public static final int COL_HIGHLIGHTER = 23;
    public static final int ROW_GRABBER = 24;
    public static final int COL_GRABBER = 25;
    public static final int ROW_GRABBER_RANGE = 26;
    public static final int COL_GRABBER_RANGE = 27;
    private static final boolean DEBUG = false;
    public static final String CROSSTAB_NAME = "Crosstab";
    public static final String COL_HIGHLIGHTER_NAME = "ColumnHighlighter";
    public static final String ROW_HIGHLIGHTER_NAME = "RowHighlighter";
    public static final String COL_GRABBER_NAME = "ColumnGrabber";
    public static final String ROW_GRABBER_NAME = "RowGrabber";
    public static final String COL_GRABBER_RANGE_NAME = "ColumnGrabberRange";
    public static final String ROW_GRABBER_RANGE_NAME = "RowGrabberRange";
    public static final int NO_REORDER = 0;
    public static final int REORDER_MEASURE_DIMENSION = 1;
    public static final int REORDER_ALL_DIMENSIONS = 2;
    protected CrosstabModel crosstabModel = null;
    protected CrosstabController crosstabController = null;
    protected transient CrosstabPivotTable pivotTable = null;
    protected int highlighterSize = CrosstabDefaultValues.getHighlighterSize();
    protected int highlighterWidth = CrosstabDefaultValues.getHighlighterSize();
    protected int highlighterHeight = CrosstabDefaultValues.getHighlighterSize();
    protected boolean m_highlighterSizeSet = false;
    private ResourceBundle localStrings = null;
    protected boolean canResizeHeights = true;
    protected boolean canResizeWidths = true;
    protected boolean m_bAutoFitting = false;
    protected boolean m_bSwapMembers = CrosstabDefaultValues.isSwapMembersAllowed();
    protected int reorderType = CrosstabDefaultValues.getReorderType();
    protected boolean m_colHeaderVisible = CrosstabDefaultValues.isColumnHeaderVisible();
    protected boolean m_rowHeaderVisible = CrosstabDefaultValues.isRowHeaderVisible();
    protected boolean m_metaIndentSupported = false;
    protected boolean m_metaRelIndentSupported = false;
    protected boolean m_metaIsTotalSupported = false;
    private boolean m_bLayerMetaDrillStateSupported = false;
    private boolean m_bLayerMetaMeasureSupported = false;
    protected boolean m_bManualColumnHeaderRowSizingEnabled = CrosstabDefaultValues.isManualColumnHeaderRowSizingEnabled();
    protected boolean m_bManualRowHeaderColumnSizingEnabled = CrosstabDefaultValues.isManualRowHeaderColumnSizingEnabled();
    protected Total m_rowTotal = null;
    protected Total m_tmpRowTotal = null;
    protected Total m_columnTotal = null;
    protected Total m_tmpColumnTotal = null;
    private boolean m_bPivotLabelVisible = CrosstabDefaultValues.isPivotLabelVisible();
    private boolean m_bMeasurePivotLabelTextDisplayed = CrosstabDefaultValues.isMeasurePivotLabelTextDisplayed();
    private static final String m_method_selectobject = "selectObject (ComponentHandle id)";
    private static final String m_method_setstartrow = "setStartRow (int r)";
    private static final String m_method_setstartcolumn = "setStartColumn (int c)";
    private static final String m_method_setautoindent = "setAutoIndent (int i)";
    private static final String m_method_sethighlightersize = "setHighlighterSize (int s)";
    private static final String m_method_setzoomfactor = "setZoomFactor (int f)";
    private static final String m_method_setcornercomponentcolor = "setCornerComponentColor (Color c)";
    private static final String m_method_setcolumnwidth = "setColumnWidth (int index, int width)";
    private static final String m_method_setrowheadercolumnwidth = "setRowHeaderColumnWidth (int index, int width)";
    private static final String m_method_getrowheadercolumnwidth = "getRowHeaderColumnWidth (int index)";
    private static final String m_method_setrowheight = "setRowHeight (int index, int height)";
    private static final String m_method_setcolumnheaderrowheight = "setColumnHeaderRowHeight (int index, int height)";
    private static final String m_method_getcolumnheaderrowheight = "getColumnHeaderRowHeight (int index)";
    private static final String m_method_sizerowheights = "sizeRowHeights(int firstRow, int lastRow)";
    private static final String m_method_sizecolumnwidths = "protected void sizeColumnWidths(int firstCol, int lastCol)";
    private static final String m_method_resizerowheight = "protected int resizeRowHeight(int row, int startCol, int endCol)";
    private static final String m_method_setcolumnvisible = "setColumnVisible (int column, boolean visible)";
    private static final String m_method_setrowvisible = "setRowVisible (int row, boolean visible)";
    private static final String m_method_isrowvisible = "isRowVisible (int row)";
    private static final String m_method_iscolumnvisible = "isColumnVisible (int col)";
    private static final String m_method_setreordertype = "setReorderType (int type)";
    private static final String m_method_autoFit = "autoFit()";
    private static final String m_method_updateResourceBundle = "updateResourceBundle()";
    private static final String m_method_cloneForPrint = "cloneForPrint()";
    private static final String m_method_updateRowHeaderWidths = "void updateRowHeaderWidths()";
    private static final String m_method_updateColumnWidth = "public void updateColumnWidth()";
    private static final String m_method_updateColumnHeaderRowHeights = "public void updateColumnHeaderRowHeights()";
    private static final String m_method_setTotal = "public void setTotal(int edge, Total total)";
    private static final String m_method_getTotal = "public Total getTotal(int edge)";
    private static final String m_method_setColumnHeaderGridVisible = "public void setColumnHeaderGridVisible(boolean bVisible)";
    private static final String m_method_setRowHeaderGridVisible = "public void setRowHeaderGridVisible(boolean bVisible)";
    private static final String m_method_isColumnHeaderGridVisible = "public boolean isColumnHeaderGridVisible()";
    private static final String m_method_isRowHeaderGridVisible = "public boolean isRowHeaderGridVisible()";
    private CrosstabXML _crosstabXML;

    public Crosstab() {
        this.updateResourceBundle();
        this.setCrosstabModel(new CrosstabModelAdapter(this));
        this.setDataSource(null);
        this.pivotTable = new CrosstabPivotTable(new CrosstabDatabody(this), new ColPivotHeader(this), new RowPivotHeader(this), this);
        this.pivotTable.setAlwaysDrawFocusCellHighlite(true);
        this.addSubcomponent(this.pivotTable.getCrosstabDatabody());
        this.addSubcomponent(this.pivotTable.getCrosstabColumnHeader());
        this.addSubcomponent(this.pivotTable.getCrosstabRowHeader());
        this.setSwapAllowed(CrosstabDefaultValues.isSwapAllowed());
        this.scrollBox = new JScrollPane((Component)((Object)this.pivotTable), 20, 30){

            @Override
            public JScrollBar createHorizontalScrollBar() {
                JScrollBar scrollBar = super.createHorizontalScrollBar();
                scrollBar.setModel(new ScrollBarModel());
                return scrollBar;
            }

            @Override
            public JScrollBar createVerticalScrollBar() {
                JScrollBar scrollBar = super.createVerticalScrollBar();
                scrollBar.setModel(new ScrollBarModel());
                return scrollBar;
            }

            class ScrollBarModel
            extends DefaultBoundedRangeModel {
                ScrollBarModel() {
                    super(0, 10, 0, 100);
                }

                @Override
                protected void fireStateChanged() {
                    if (Crosstab.this != null) {
                        Crosstab.this.setDuringScroll(true);
                    }
                    super.fireStateChanged();
                    if (Crosstab.this != null) {
                        Crosstab.this.setDuringScroll(false);
                    }
                }
            }
        };
        this.scrollBox.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                Crosstab.this.pivotTable.getCrosstabColumnHeader().repaint();
            }
        });
        this.scrollBox.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                Crosstab.this.pivotTable.getCrosstabRowHeader().repaint();
            }
        });
        this.m_bResizeForDrillImages = false;
        this._setDrillImage(2, this.getCrosstabColumnHeader().getDrilledImage());
        this._setDrillImage(1, this.getCrosstabColumnHeader().getDrillImage());
        this.m_bResizeForDrillImages = true;
        this.setCrosstabController(new CrosstabControllerAdapter(this));
        this.setColumnHeaderGridVisible(CrosstabDefaultValues.isColumnHeaderGridVisible());
        this.setRowHeaderGridVisible(CrosstabDefaultValues.isRowHeaderGridVisible());
        this.setManualColumnSizingEnabled(CrosstabDefaultValues.isManualColumnSizingEnabled());
        this.setManualRowSizingEnabled(CrosstabDefaultValues.isManualRowSizingEnabled());
        this.setManualColumnHeaderRowSizingEnabled(CrosstabDefaultValues.isManualColumnHeaderRowSizingEnabled());
        this.setManualRowHeaderColumnSizingEnabled(CrosstabDefaultValues.isManualRowHeaderColumnSizingEnabled());
        this.pivotTable.getCrosstabColumnHeader().refreshPivotHandleStyle();
        this.pivotTable.getCrosstabRowHeader().refreshPivotHandleStyle();
        this.pivotTable.setFirstRowOnScreen(CrosstabDefaultValues.getStartRow());
        this.pivotTable.setFirstColumnOnScreen(CrosstabDefaultValues.getStartColumn());
        if (this.isAnythingAutoFit()) {
            this.autoFit();
        } else {
            this.doSizing();
        }
        this.add(this.scrollBox, "Center");
        this._crosstabXML = new CrosstabXML(this);
        this.setUserOverrideMode(true);
        this.setStyleOverrideMode(true);
    }

    protected void updateResourceBundle() {
        try {
            this.localStrings = this.getLocale() != null ? ResourceBundle.getBundle("oracle.dss.crosstab.resource.CrosstabBundle", this.getLocale()) : ResourceBundle.getBundle("oracle.dss.crosstab.resource.CrosstabBundle");
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), m_method_updateResourceBundle);
            this.localStrings = null;
        }
    }

    @Override
    public void modelDataAvailable(DataAvailableEvent e) {
        if (e.getType() == 1) {
            this.m_stopRepaints = true;
            return;
        }
        this.m_stopRepaints = false;
        this.freezeRepaints();
        super.modelDataAvailable(e);
        DataDirector dd = this.getDataDirector();
        if (this.isOutline() != dd.isOutline()) {
            try {
                dd.setOutline(this.isOutline());
            }
            catch (DataDirectorException dde) {
                this.getErrorHandler().error((Throwable)dde, this.getClass().getName(), "modelDataAvailable");
            }
        }
        this.unfreezeRepaints();
    }

    public void setCrosstabModel(CrosstabModel m) {
        super.setGridViewModel(m);
        CrosstabModel oldModel = this.crosstabModel;
        this.crosstabModel = m;
        this.firePropertyChange(this, "CrosstabModel", oldModel, this.crosstabModel);
    }

    public CrosstabModel getCrosstabModel() {
        return this.crosstabModel;
    }

    public void setCrosstabController(CrosstabController c) {
        super.setGridViewController(c);
        CrosstabController oldController = this.crosstabController;
        if (oldController != null) {
            oldController.cleanUp();
        }
        this.crosstabController = c;
        this.firePropertyChange(this, "CrosstabController", oldController, this.crosstabController);
    }

    public CrosstabController getCrosstabController() {
        return this.crosstabController;
    }

    public void setGridViewSelectionManager(GridViewSelectionManager m) {
        if (this.crosstabController != null) {
            GridViewSelectionManager oldSel = this.crosstabController.getGridViewSelectionManager();
            this.crosstabController.setGridViewSelectionManager(m);
            this.firePropertyChange(this, "GridViewSelectionManager", oldSel, m);
        }
    }

    @Override
    public GridViewSelectionManager getGridViewSelectionManager() {
        if (this.crosstabController != null) {
            return this.crosstabController.getGridViewSelectionManager();
        }
        return null;
    }

    @Override
    public void setCrosstabSizingManager(CrosstabSizingManager m) {
        if (this.crosstabController != null) {
            CrosstabSizingManager oldSel = this.crosstabController.getCrosstabSizingManager();
            this.crosstabController.setCrosstabSizingManager(m);
            this.firePropertyChange(this, "CrosstabSizingManager", oldSel, m);
        }
    }

    @Override
    public CrosstabSizingManager getCrosstabSizingManager() {
        if (this.crosstabController != null) {
            return this.crosstabController.getCrosstabSizingManager();
        }
        return null;
    }

    @Override
    public void setLocale(Locale loc) {
        GridViewFormatManager rf;
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle();
        if (this.getViewFormat() != null) {
            this.getViewFormat().setLocale(loc);
        }
        if (this.getCrosstabModel() != null && this.getCrosstabModel().getViewFormat() != null) {
            this.getCrosstabModel().getViewFormat().setLocale(loc);
        }
        if ((rf = this.getGridViewFormatManager()) != null) {
            rf.valueFormatChanged();
        }
        this.dataFormatChanged();
        this.repaint();
    }

    public boolean selectObject(ComponentHandle id) {
        if (id == null) {
            return this.crosstabController.setSelectedObject(null, true);
        }
        int ID = id.getID();
        RowComponentInfo[] rowRangeInfo = null;
        RowRangeComponentHandle rrID = null;
        ColumnComponentInfo[] columnRangeInfo = null;
        ColumnRangeComponentHandle crID = null;
        switch (ID) {
            case 20: {
                try {
                    rrID = (RowRangeComponentHandle)id;
                }
                catch (ClassCastException e) {
                    return false;
                }
                rowRangeInfo = rrID.getLocationList();
                CrosstabUtils.selectRows(rowRangeInfo, this.getCrosstabDatabody().getGrid(), this);
                return this.crosstabController.setSelectedObject((ComponentHandle)new RowRangeComponentHandle(ID, this.getNameFromID(ID), (Object)this.getCrosstabDatabody(), rowRangeInfo), true);
            }
            case 19: {
                try {
                    crID = (ColumnRangeComponentHandle)id;
                }
                catch (ClassCastException e) {
                    return false;
                }
                columnRangeInfo = crID.getLocationList();
                CrosstabUtils.selectColumns(columnRangeInfo, this.getCrosstabDatabody().getGrid(), this);
                return this.crosstabController.setSelectedObject((ComponentHandle)new ColumnRangeComponentHandle(ID, this.getNameFromID(ID), (Object)this.getCrosstabDatabody(), columnRangeInfo), true);
            }
            case 15: 
            case 22: 
            case 25: {
                RowComponentHandle rowID;
                try {
                    rowID = (RowComponentHandle)id;
                }
                catch (ClassCastException e) {
                    return false;
                }
                RowComponentInfo rowinfo = new RowComponentInfo(rowID.getRow());
                if (ID == 25) {
                    CrosstabUtils.selectRow(rowinfo, this.getCrosstabColumnHeader().getGrid(), this);
                } else {
                    CrosstabUtils.selectRow(rowinfo, this.getCrosstabDatabody().getGrid(), this);
                }
                this.crosstabController.setSelectedObject((ComponentHandle)new RowComponentHandle(ID, this.getNameFromID(ID), this.getComponentFromID(ID), rowinfo.getRow()), true);
                return true;
            }
            case 14: 
            case 23: 
            case 24: {
                ColumnComponentHandle colID;
                try {
                    colID = (ColumnComponentHandle)id;
                }
                catch (ClassCastException e) {
                    return false;
                }
                ColumnComponentInfo columninfo = new ColumnComponentInfo(colID.getColumn());
                if (ID == 24) {
                    CrosstabUtils.selectColumn(columninfo, this.getCrosstabRowHeader().getGrid(), this);
                } else {
                    CrosstabUtils.selectColumn(columninfo, this.getCrosstabDatabody().getGrid(), this);
                }
                return this.crosstabController.setSelectedObject((ComponentHandle)new ColumnComponentHandle(ID, this.getNameFromID(ID), this.getComponentFromID(ID), columninfo.getColumn()), true);
            }
            case 27: {
                try {
                    rrID = (RowRangeComponentHandle)id;
                }
                catch (ClassCastException e) {
                    return false;
                }
                rowRangeInfo = rrID.getLocationList();
                CrosstabUtils.selectRows(rowRangeInfo, this.getCrosstabColumnHeader().getGrid(), this);
                return this.crosstabController.setSelectedObject((ComponentHandle)new RowRangeComponentHandle(ID, this.getNameFromID(ID), (Object)this.getCrosstabColumnHeader(), rowRangeInfo), true);
            }
            case 26: {
                try {
                    crID = (ColumnRangeComponentHandle)id;
                }
                catch (ClassCastException e) {
                    return false;
                }
                columnRangeInfo = crID.getLocationList();
                CrosstabUtils.selectColumns(columnRangeInfo, this.getCrosstabRowHeader().getGrid(), this);
                return this.crosstabController.setSelectedObject((ComponentHandle)new ColumnRangeComponentHandle(ID, this.getNameFromID(ID), (Object)this.getCrosstabRowHeader(), columnRangeInfo), true);
            }
            case 16: {
                DataRangeComponentHandle drID;
                try {
                    drID = (DataRangeComponentHandle)id;
                }
                catch (ClassCastException e) {
                    return false;
                }
                DataComponentInfo[] dataRangeInfo = drID.getLocationList();
                CrosstabUtils.selectCells(dataRangeInfo, this.getCrosstabDatabody().getGrid(), this);
                return this.crosstabController.setSelectedObject((ComponentHandle)new DataRangeComponentHandle(ID, this.getNameFromID(ID), (Object)this.getCrosstabDatabody(), dataRangeInfo), true);
            }
            case 12: {
                DataComponentHandle dataID;
                try {
                    dataID = (DataComponentHandle)id;
                }
                catch (ClassCastException e) {
                    return false;
                }
                DataComponentInfo datainfo = new DataComponentInfo(dataID.getRow(), dataID.getColumn());
                Cell cell = new Cell(datainfo.getColumn(), datainfo.getRow());
                DataComponentInfo[] cellinfo = new DataComponentInfo[]{datainfo};
                CrosstabUtils.selectCells(cellinfo, this.getCrosstabDatabody().getGrid(), this);
                return this.crosstabController.setSelectedObject((ComponentHandle)new DataComponentHandle(ID, this.getNameFromID(ID), (Object)cell, datainfo), true);
            }
            case 10: 
            case 11: {
                EdgeComponentHandle edgeID;
                try {
                    edgeID = (EdgeComponentHandle)id;
                }
                catch (ClassCastException e) {
                    return false;
                }
                EdgeComponentInfo edgeinfo = new EdgeComponentInfo(edgeID.getEdge(), edgeID.getDepth(), edgeID.getIndex());
                CrosstabPivotHeader ph = ID == 10 ? this.getCrosstabColumnHeader() : this.getCrosstabRowHeader();
                CrosstabUtils.selectCell(edgeinfo, ph.getEdge(), ph.getGrid(), this);
                return this.crosstabController.setSelectedObject((ComponentHandle)new EdgeComponentHandle(ID, this.getNameFromID(ID), this.getComponentFromID(ID), edgeinfo), true);
            }
            case 17: 
            case 18: {
                EdgeRangeComponentHandle edgeRangeID;
                try {
                    edgeRangeID = (EdgeRangeComponentHandle)id;
                }
                catch (ClassCastException e) {
                    return false;
                }
                EdgeComponentInfo[] edgeRangeInfo = edgeRangeID.getLocationList();
                CrosstabPivotHeader ph = ID == 17 ? this.getCrosstabColumnHeader() : this.getCrosstabRowHeader();
                CrosstabUtils.selectCells(edgeRangeInfo, ph.getEdge(), ph.getGrid(), this);
                return this.crosstabController.setSelectedObject((ComponentHandle)new EdgeRangeComponentHandle(ID, this.getNameFromID(ID), this.getComponentFromID(ID), edgeRangeInfo), true);
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 21: {
                if (ID == 13) {
                    CrosstabUtils.selectAllCells(true, this.getCrosstabDatabody().getGrid(), this);
                }
                return this.crosstabController.setSelectedObject((ComponentHandle)new NonDataComponentHandle(ID, this.getNameFromID(ID), this.getComponentFromID(ID)), false);
            }
            case 4: {
                PageItemComponentHandle pageItemID;
                try {
                    pageItemID = (PageItemComponentHandle)id;
                }
                catch (ClassCastException e) {
                    return false;
                }
                int pageItem = pageItemID.getPageItem();
                return this.crosstabController.setSelectedObject((ComponentHandle)new PageItemComponentHandle(ID, this.getNameFromID(ID), this.getComponentFromID(ID), pageItem), false);
            }
        }
        this.getErrorHandler().log("invalid component ID", this.getClass().getName(), m_method_selectobject);
        return false;
    }

    @Override
    public void setStartRow(int r) {
        if (this.isLoadingViewFromPersistence()) {
            this.m_tmpStartRow = r;
        }
        if (r < 0 || r >= this.pivotTable.getGridModel().getRowCount()) {
            this.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_setstartrow);
            return;
        }
        int oldRow = this.getStartRow();
        this.setDesiredStartRow(r);
        if (oldRow != r) {
            this.pivotTable.setFirstRowOnScreen(r);
            this.firePropertyChange(this, "StartRow", oldRow, r);
        }
    }

    @Override
    public int getStartRow() {
        return this.pivotTable.getPivotGrid().getFirstRowOnScreen();
    }

    @Override
    public void setStartColumn(int c) {
        if (this.isLoadingViewFromPersistence()) {
            this.m_tmpStartColumn = c;
        }
        if (c < 0 || c >= this.pivotTable.getGridModel().getColumnCount()) {
            this.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_setstartcolumn);
            return;
        }
        int oldCol = this.getStartColumn();
        this.setDesiredStartColumn(c);
        if (oldCol != c) {
            this.pivotTable.setFirstColumnOnScreen(c);
            this.firePropertyChange(this, "StartColumn", oldCol, c);
        }
    }

    @Override
    public int getStartColumn() {
        return this.pivotTable.getPivotGrid().getFirstColumnOnScreen();
    }

    @Override
    public void setHGridVisible(boolean b) {
        boolean oldValue = this.isHGridVisible();
        this.pivotTable.getPivotGrid().setHorizontalSeparatorsVisible(b);
        if (this.updateHeights) {
            this.updateRowHeights();
        }
        this.firePropertyChange(this, "HGridVisible", oldValue, b);
    }

    @Override
    public boolean isHGridVisible() {
        return this.pivotTable.getPivotGrid().getHorizontalSeparatorsVisible();
    }

    @Override
    public void setVGridVisible(boolean b) {
        boolean oldValue = this.isVGridVisible();
        this.pivotTable.getPivotGrid().setVerticalSeparatorsVisible(b);
        this.firePropertyChange(this, "VGridVisible", oldValue, b);
    }

    @Override
    public boolean isVGridVisible() {
        return this.pivotTable.getPivotGrid().getVerticalSeparatorsVisible();
    }

    @Override
    public void setColumnHeaderGridVisible(boolean bVisible) {
        if (this.getCrosstabColumnHeader().getDefaultPainter() instanceof PivotHeaderPainter) {
            ((PivotHeaderPainter)this.getCrosstabColumnHeader().getDefaultPainter()).setCellBorderVisible(bVisible);
            this.getCrosstabColumnHeader().repaint();
        } else {
            this.getErrorHandler().log("column pivot header painter not type PivotHeaderPainter", this.getClass().getName(), m_method_setColumnHeaderGridVisible);
        }
    }

    @Override
    public boolean isColumnHeaderGridVisible() {
        if (this.getCrosstabColumnHeader().getDefaultPainter() instanceof PivotHeaderPainter) {
            return ((PivotHeaderPainter)this.getCrosstabColumnHeader().getDefaultPainter()).isCellBorderVisible();
        }
        this.getErrorHandler().log("column pivot header painter not type PivotHeaderPainter", this.getClass().getName(), m_method_isColumnHeaderGridVisible);
        return false;
    }

    @Override
    public void setRowHeaderGridVisible(boolean bVisible) {
        if (this.getCrosstabRowHeader().getDefaultPainter() instanceof PivotHeaderPainter) {
            ((PivotHeaderPainter)this.getCrosstabRowHeader().getDefaultPainter()).setCellBorderVisible(bVisible);
            this.getCrosstabRowHeader().repaint();
        } else {
            this.getErrorHandler().log("row pivot header painter not type PivotHeaderPainter", this.getClass().getName(), m_method_setRowHeaderGridVisible);
        }
    }

    @Override
    public boolean isRowHeaderGridVisible() {
        if (this.getCrosstabRowHeader().getDefaultPainter() instanceof PivotHeaderPainter) {
            return ((PivotHeaderPainter)this.getCrosstabRowHeader().getDefaultPainter()).isCellBorderVisible();
        }
        this.getErrorHandler().log("row pivot header painter not type PivotHeaderPainter", this.getClass().getName(), m_method_isRowHeaderGridVisible);
        return false;
    }

    public void setHeader3D(boolean b) {
        this.getCrosstabColumnHeader().getViewStyle().setBorderApplied(!b);
        this.getCrosstabRowHeader().getViewStyle().setBorderApplied(!b);
        if (b) {
            this.getCrosstabColumnHeader().getViewStyle().setBorderPainter(this.getCrosstabColumnHeader().getDefaultAppearance().getBorderPainter());
            this.getCrosstabRowHeader().getViewStyle().setBorderPainter(this.getCrosstabRowHeader().getDefaultAppearance().getBorderPainter());
        }
        this.getCrosstabColumnHeader().clearCache();
        this.getCrosstabRowHeader().clearCache();
        this.getPivotTable().setDrawRaised(b);
        if (this.isAnythingAutoFit()) {
            this.autoFit();
        }
        this.repaint();
    }

    public boolean isHeader3D() {
        return this.getPivotTable().getDrawRaised();
    }

    @Override
    public void setCellEditingAllowed(boolean b) {
        Grid grid = this.pivotTable.getPivotGrid().getGrid();
        boolean oldValue = this.isCellEditingAllowed();
        this.cellEditingAllowed = b;
        if (b != oldValue) {
            if (b) {
                this.pivotTable.addEditListener(this.editListener);
                grid.setDefaultInputHandler((CellInputHandler)this.editListener);
            } else {
                this.pivotTable.removeEditListener(this.editListener);
                grid.setDefaultInputHandler((CellInputHandler)new GridViewDatabodyInputHandler(this));
            }
            this.getCrosstabDatabody().setCellEditingAllowed(b);
            this.firePropertyChange(this, "CellEditingAllowed", oldValue, b);
        }
    }

    @Override
    public void updateColumnWidth() {
        if ((this.getAutoFitScope() & 2) == 0) {
            return;
        }
        CrosstabSizingManager csm = this.getCrosstabSizingManager();
        if (csm == null) {
            return;
        }
        Range range = this.getAutoFitColumnRange();
        int endCol = range.end;
        int startCol = range.begin;
        if (endCol < startCol) {
            this.getErrorHandler().log("invalid column range", this.getClass().getName(), m_method_updateColumnWidth);
            return;
        }
        range = this.getAutoFitRowRange();
        int endRow = range.end;
        int startRow = range.begin;
        if (endRow < startRow) {
            this.getErrorHandler().log("invalid row range", this.getClass().getName(), m_method_updateColumnWidth);
            return;
        }
        int colCount = endCol - startCol + 1;
        int rowCount = endRow - startRow + 1;
        int[] widthsDatabody = this.calcAutoFitColumnWidths(startCol, endCol, startRow, endRow);
        int max = -1;
        for (int i = 0; i < widthsDatabody.length; ++i) {
            if (max >= widthsDatabody[i]) continue;
            max = widthsDatabody[i];
        }
        if (max > 0) {
            this.getCrosstabSizingManager().setDefaultColumnWidth(max);
        }
        if (this.getAutoFitRowRangeCallback() != null) {
            this.getAutoFitRowRangeCallback().endAutoFit();
        }
        this.sizeColumnWidths();
        this.crosstabController.fireComponentSized(this, (ComponentHandle)new NonDataComponentHandle(21, CROSSTAB_NAME, (Object)this));
    }

    @Override
    public void updateRowHeights() {
        if (this.pivotTable == null || this.xmlMode || this.m_bAutoFitting) {
            return;
        }
        this.pivotTable.clearRowHeightsCache();
        this.pivotTable.checkResizeRowHeights();
    }

    protected void refreshData() {
        this.freezeRepaints();
        this.clearWaitDataForAllRows();
        this.crosstabModel.newDataSource();
        this.crosstabModel.newRowDataSource();
        this.crosstabModel.newColDataSource();
        this.crosstabModel.newRowPivotHandleDataSource();
        this.crosstabModel.newColumnPivotHandleDataSource();
        if (this.pivotTable != null) {
            ColHeaderData columnDataSource = this.crosstabModel.getColumnDataSource();
            RowHeaderData rowDataSource = this.crosstabModel.getRowDataSource();
            if (rowDataSource == null) {
                try {
                    int rows;
                    if (this.crosstabModel.getDataAccess().getLayerCount(1) == 0 && (rows = this.crosstabModel.getDataAccess().getEdgeExtent(1)) > 0) {
                        rowDataSource = new ArrayTwoDModel(0, rows);
                    }
                }
                catch (EdgeOutOfRangeException e) {
                    this.getErrorHandler().error((Throwable)e, this.getClass().getName(), "refreshData");
                }
            }
            if (columnDataSource == null) {
                try {
                    int columns;
                    if (this.crosstabModel.getDataAccess().getLayerCount(0) == 0 && (columns = this.crosstabModel.getDataAccess().getEdgeExtent(0)) > 0) {
                        columnDataSource = new ArrayTwoDModel(columns, 0);
                    }
                }
                catch (EdgeOutOfRangeException e) {
                    this.getErrorHandler().error((Throwable)e, this.getClass().getName(), "refreshData");
                }
            }
            this.pivotTable.setModels(this.crosstabModel.getCrosstabDataSource(), (TwoDModel)columnDataSource, (TwoDModel)rowDataSource);
            this.pivotTable.getCrosstabRowHeader().setAxisLabelModel((OneDModel)this.crosstabModel.getRowHeaderHandleDataSource());
            this.pivotTable.getCrosstabColumnHeader().setAxisLabelModel((OneDModel)this.crosstabModel.getColumnHeaderHandleDataSource());
            if (this.isColumnHeaderVisible()) {
                this.getPivotTable().setColumnPivotHeaderVisible(this.getCrosstabModel().isColumnHeaderVisible());
            }
            if (this.isRowHeaderVisible()) {
                this.getPivotTable().setRowPivotHeaderVisible(this.getCrosstabModel().isRowHeaderVisible());
            }
            this.pivotTable.clearRowHeightsCache();
        }
        this.checkAxisLabelVisibility();
        CrosstabDatabody db = this.getCrosstabDatabody();
        if (db != null) {
            db.setRowHighlighterVisible(this.isRowHighlighterVisible());
            db.setColumnHighlighterVisible(this.isColumnHighlighterVisible());
        }
        if (this.getCrosstabDatabody() != null) {
            this.getCrosstabDatabody().clearCache();
        }
        if (this.getCrosstabRowHeader() != null) {
            this.getCrosstabRowHeader().clearCache();
        }
        if (this.getCrosstabColumnHeader() != null) {
            this.getCrosstabColumnHeader().clearCache();
        }
        this.getGridViewDatabodyStyleManager().dataStyleChanged();
        this.getGridViewHeaderStyleManager().metadataStyleChanged();
        this.updatePagingControlStyles();
        this.getGridViewFormatManager().valueFormatChanged();
        this.getGridViewFormatManager().metadataFormatChanged();
        if (this.getCrosstabSizingManager() != null) {
            this.getCrosstabSizingManager().dataChanged();
        }
        this.dataFormatChanged();
        if (this.getCrosstabController() != null) {
            this.getCrosstabController().setSelectedObject(null, false);
        }
        if (this.isAnythingAutoFit()) {
            this.autoFit();
        } else {
            this.doSizing();
        }
        if (this.isLoadingViewFromPersistence() && this.isLoadingDataSourceFromPersistence()) {
            if (this.m_tmpStartColumn > -1 && this.m_tmpStartColumn < this.getGridViewModel().getGridViewDataSource().getColumnCount()) {
                this.setDesiredStartColumn(this.m_tmpStartColumn);
                this.setMustReScroll(true);
            }
            if (this.m_tmpStartRow > -1 && this.m_tmpStartRow < this.getGridViewModel().getGridViewDataSource().getRowCount()) {
                this.setDesiredStartRow(this.m_tmpStartRow);
                this.setMustReScroll(true);
            }
        }
        this.setLoadingViewFromPersistence(false);
        this.setLoadingDataSourceFromPersistence(false);
        this.m_tmpStartColumn = -1;
        this.m_tmpStartRow = -1;
        this.unfreezeRepaints();
        this.repaint();
        int pageIndex = this.getPagingControl().getPreviousPageItemIndex();
        if (pageIndex != -1 && this.getPagingControl().getPagingComponent().isPageItemSelected()) {
            this.getPagingControl().getPagingComponent().getItem(pageIndex).requestFocus();
            this.getPagingControl().getPagingComponent().setPageItemSelected(false);
        }
    }

    protected CrosstabDatabody getCrosstabDatabody() {
        return this.pivotTable != null ? this.pivotTable.getCrosstabDatabody() : null;
    }

    @Override
    public GridViewDatabody getDatabody() {
        return this.pivotTable != null ? this.pivotTable.getCrosstabDatabody() : null;
    }

    @Override
    public GridViewTable getGridViewTable() {
        return this.pivotTable;
    }

    protected CrosstabPivotHeader getCrosstabColumnHeader() {
        return this.pivotTable != null ? this.pivotTable.getCrosstabColumnHeader() : null;
    }

    protected CrosstabPivotHeader getCrosstabRowHeader() {
        return this.pivotTable != null ? this.pivotTable.getCrosstabRowHeader() : null;
    }

    @Override
    public GridViewHeader getColumnHeader() {
        return this.pivotTable != null ? this.pivotTable.getCrosstabColumnHeader() : null;
    }

    @Override
    public GridViewHeader getRowHeader() {
        return this.pivotTable != null ? this.pivotTable.getCrosstabRowHeader() : null;
    }

    @Override
    public void setColumnHeaderVisible(boolean visible) {
        boolean oldVisible = this.m_colHeaderVisible;
        this.m_colHeaderVisible = visible;
        this.getPivotTable().setColumnPivotHeaderVisible(visible);
        if (visible && !oldVisible) {
            this.updateColumnWidth();
            this.updateColumnHeaderRowHeights();
            this.updateRowHeights();
        }
    }

    @Override
    public boolean isColumnHeaderVisible() {
        return this.m_colHeaderVisible;
    }

    @Override
    public void setRowHeaderVisible(boolean visible) {
        boolean oldVisible = this.m_rowHeaderVisible;
        this.m_rowHeaderVisible = visible;
        this.getPivotTable().setRowPivotHeaderVisible(visible);
        if (visible && !oldVisible) {
            this.updateRowHeaderWidths();
            this.updateRowHeights();
        }
    }

    @Override
    public boolean isRowHeaderVisible() {
        return this.m_rowHeaderVisible;
    }

    @Override
    public void setIndentEnabled(boolean b) {
        if (this.crosstabModel != null) {
            boolean oldValue = this.isIndentEnabled();
            this.crosstabModel.setIndentEnabled(b);
            this.firePropertyChange(this, "IndentEnabled", oldValue, b);
        }
    }

    @Override
    public boolean isIndentEnabled() {
        if (this.crosstabModel != null) {
            return this.crosstabModel.isIndentEnabled();
        }
        return false;
    }

    @Override
    public void setAutoIndent(int i) {
        if (i < 0) {
            this.getErrorHandler().log("invalid number of spaces", this.getClass().getName(), m_method_setautoindent);
        } else if (this.crosstabModel != null) {
            int oldValue = this.getAutoIndent();
            this.crosstabModel.setAutoIndent(i);
            this.firePropertyChange(this, "AutoIndent", oldValue, i);
        }
    }

    @Override
    public int getAutoIndent() {
        if (this.crosstabModel != null) {
            return this.crosstabModel.getAutoIndent();
        }
        return 1;
    }

    public CrosstabPivotTable getPivotTable() {
        return this.pivotTable;
    }

    @Override
    public void setBodyHighlighterVisible(boolean b) {
        boolean oldValue = this.isBodyHighlighterVisible();
        if (oldValue != b) {
            this.getCrosstabDatabody().setBodyHighlighterVisible(b);
            this.firePropertyChange(this, "BodyHighlighterVisible", oldValue, b);
        }
    }

    @Override
    public boolean isBodyHighlighterVisible() {
        return this.getCrosstabDatabody().isBodyHighlighterVisible();
    }

    @Override
    public void setColumnHighlighterVisible(boolean b) {
        boolean oldValue = this.isColumnHighlighterVisible();
        if (oldValue != b) {
            this.getCrosstabDatabody().setColumnHighlighterVisible(b);
            this.firePropertyChange(this, "ColumnHighlighterVisible", oldValue, b);
        }
    }

    @Override
    public boolean isColumnHighlighterVisible() {
        return this.getCrosstabDatabody().isColumnHighlighterVisible();
    }

    @Override
    public void setRowHighlighterVisible(boolean b) {
        boolean oldValue = this.isRowHighlighterVisible();
        if (oldValue != b) {
            this.getCrosstabDatabody().setRowHighlighterVisible(b);
            this.firePropertyChange(this, "RowHighlighterVisible", oldValue, b);
        }
    }

    @Override
    public boolean isRowHighlighterVisible() {
        return this.getCrosstabDatabody().isRowHighlighterVisible();
    }

    @Override
    public void setHighlighterSize(int s) {
        if (s < 0) {
            this.getErrorHandler().log("invalid highlighter size", this.getClass().getName(), m_method_sethighlightersize);
            return;
        }
        int oldValue = this.getHighlighterSize();
        if (oldValue != s) {
            this.highlighterSize = s;
            this.m_highlighterSizeSet = true;
            this.getPivotTable().redoHighlighters(this.highlighterSize);
            this.updateColumnHeaderRowHeights();
            this.firePropertyChange(this, "HighlighterSize", oldValue, s);
        }
    }

    @Override
    public int getHighlighterSize() {
        return this.highlighterSize;
    }

    @Override
    public void setZoomFactor(int f) {
        if (f <= 0) {
            this.getErrorHandler().log("invalid zoom factor", this.getClass().getName(), m_method_setzoomfactor);
            return;
        }
        int oldValue = this.getZoomFactor();
        if (oldValue != f) {
            this.zoomFactor = f;
            this.scaleImages();
            ((Title)this.getDataviewTitle()).setZoomFactor(f);
            ((Subtitle)this.getDataviewSubtitle()).setZoomFactor(f);
            ((Footnote)this.getDataviewFootnote()).setZoomFactor(f);
            this.getPagingControl().setZoomFactor(f);
            this.pivotTable.getCrosstabRowHeader().refreshPivotHandleStyle();
            this.pivotTable.getCrosstabColumnHeader().refreshPivotHandleStyle();
            if (this.m_highlighterSizeSet) {
                this.getPivotTable().setColumnSelectorWidth(DataviewUtils.scaleByZoom((int)this.highlighterSize, (int)this.zoomFactor));
                this.getPivotTable().setRowSelectorHeight(DataviewUtils.scaleByZoom((int)this.highlighterSize, (int)this.zoomFactor));
            }
            this.getCrosstabRowHeader().setZoomFactor(f);
            this.getCrosstabColumnHeader().setZoomFactor(f);
            this.updateRowHeaderWidths();
            this.updateColumnHeaderRowHeights();
            this.doSizing();
            this.invalidate();
            this.repaint();
            this.firePropertyChange(this, "ZoomFactor", oldValue, f);
        }
    }

    public void setCornerComponent(Component c) {
        this.getPivotTable().setCornerComponent(c);
    }

    public Component getCornerComponent() {
        return this.getPivotTable().getCornerComponent();
    }

    @Override
    public void setBackgroundImage(Image image) {
        this.setBackgroundImage(image, false);
    }

    @Override
    protected void setBackgroundImage(Image image, boolean bSetFromPath) {
        super.setBackgroundImage(image, bSetFromPath);
        if (this.getBackgroundImage() != null) {
            this.getCrosstabDatabody().getGrid().setFill((Painter)new PainterTiler((Painter)new FixedImagePainter(this.getBackgroundImage(), 0)));
        } else {
            this.getCrosstabDatabody().getGrid().setFill(null);
        }
    }

    @Override
    protected Image getDefaultDrillImage() {
        return this.getCrosstabColumnHeader().getDrillImage();
    }

    @Override
    protected Image getDefaultDrilledImage() {
        return this.getCrosstabColumnHeader().getDrilledImage();
    }

    @Override
    protected void drillImageChanged() {
        this.getCrosstabColumnHeader().clearUnscaledBlankImage();
        this.getCrosstabColumnHeader().clearScaledBlankImage();
        this.getCrosstabRowHeader().clearUnscaledBlankImage();
        this.getCrosstabRowHeader().clearScaledBlankImage();
        super.drillImageChanged();
    }

    @Override
    public void setCornerComponentColor(Color c) {
        if (c == null) {
            this.getErrorHandler().log("invalid color", this.getClass().getName(), m_method_setcornercomponentcolor);
            return;
        }
        Color oldColor = this.getCornerComponentColor();
        this.getPivotTable().getCornerComponent().setBackground(c);
        this.setCornerComponentColorUsed(true);
        this.firePropertyChange(this, "CornerComponentColor", oldColor, c);
    }

    @Override
    public Color getCornerComponentColor() {
        return this.getPivotTable().getCornerComponent().getBackground();
    }

    @Override
    public void setDefaultCornerComponentColor(Color c) {
        if (c == null) {
            this.getErrorHandler().log("invalid color", this.getClass().getName(), "public void setDefaultCornerComponentColor(Color c)");
            return;
        }
        this._crosstabXML.setDefaultCornerComponentColor(c);
        if (!this.isCornerComponentColorUsed()) {
            this.setCornerComponentColor(c);
            this.setCornerComponentColorUsed(false);
        }
    }

    @Override
    public void setColumnWidth(int index, int width) {
        if (index < 0 || index > this.pivotTable.getGridModel().getColumnCount()) {
            this.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_setcolumnwidth);
        } else if (width < 0) {
            this.getErrorHandler().log("invalid column width", this.getClass().getName(), m_method_setcolumnwidth);
        } else {
            int old = this.getColumnWidth(index);
            this.getCrosstabSizingManager().setPreferredColumnWidth(index, width);
            this.firePropertyChange(this, "ColumnWidth", old, width);
        }
    }

    public void setRowHeaderColumnWidth(int index, int width) {
        if (index < 0 || index >= this.getCrosstabRowHeader().getModel().getColumnCount()) {
            this.getErrorHandler().log("invalid row header column index", this.getClass().getName(), m_method_setrowheadercolumnwidth);
        } else if (width < 0) {
            this.getErrorHandler().log("invalid row header column width", this.getClass().getName(), m_method_setrowheadercolumnwidth);
        } else {
            int old = this.getRowHeaderColumnWidth(index);
            this.getCrosstabSizingManager().setPreferredRowHeaderColumnWidth(index, width);
            this.firePropertyChange(this, "RowHeaderColumnWidth", old, width);
        }
    }

    public int getRowHeaderColumnWidth(int index) {
        if (index < 0 || index >= this.getCrosstabRowHeader().getModel().getColumnCount()) {
            this.getErrorHandler().log("invalid row header column index", this.getClass().getName(), m_method_getrowheadercolumnwidth);
            return 0;
        }
        return this.getCrosstabSizingManager().getRowHeaderColumnWidth(index);
    }

    @Override
    public void setRowHeight(int index, int height) {
        if (index < 0 || index >= this.pivotTable.getGridModel().getRowCount()) {
            this.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_setrowheight);
        } else if (height < 0) {
            this.getErrorHandler().log("invalid row height", this.getClass().getName(), m_method_setrowheight);
        } else {
            int old = this.getRowHeight(index);
            this.getCrosstabSizingManager().setPreferredRowHeight(index, height);
            this.firePropertyChange(this, "RowHeight", old, height);
        }
    }

    public void setColumnHeaderRowHeight(int index, int height) {
        if (index < 0 || index >= this.getCrosstabColumnHeader().getModel().getRowCount()) {
            this.getErrorHandler().log("invalid column header row index", this.getClass().getName(), m_method_setcolumnheaderrowheight);
        } else if (height < 0) {
            this.getErrorHandler().log("invalid column header row height", this.getClass().getName(), m_method_setcolumnheaderrowheight);
        } else {
            int old = this.getColumnHeaderRowHeight(index);
            this.getCrosstabSizingManager().setPreferredColumnHeaderRowHeight(index, height);
            this.firePropertyChange(this, "ColumnHeaderRowHeight", old, height);
        }
    }

    public int getColumnHeaderRowHeight(int index) {
        if (index < 0 || index >= this.getCrosstabColumnHeader().getModel().getRowCount()) {
            this.getErrorHandler().log("invalid column header row index", this.getClass().getName(), m_method_getcolumnheaderrowheight);
            return 0;
        }
        return this.getCrosstabSizingManager().getColumnHeaderRowHeight(index);
    }

    @Override
    public void autoFit() {
        int[] heights;
        int[] widths;
        boolean calcRowHeaderColWidths;
        CrosstabSizingManager csm = this.getCrosstabSizingManager();
        if (csm == null) {
            return;
        }
        boolean calcRowHeights = (this.getAutoFitScope() & 1) > 0;
        boolean calcColWidths = (this.getAutoFitScope() & 2) > 0;
        boolean calcColHeaderRowHeights = (this.getAutoFitScope() & 4) > 0;
        boolean bl = calcRowHeaderColWidths = (this.getAutoFitScope() & 8) > 0;
        if (!(calcRowHeights || calcColWidths || calcColHeaderRowHeights || calcRowHeaderColWidths)) {
            return;
        }
        boolean bValidColRange = true;
        boolean bValidRowRange = true;
        int startCol = 0;
        int endCol = 0;
        if (calcRowHeights || calcColWidths || calcColHeaderRowHeights) {
            Range range = this.getAutoFitColumnRange();
            endCol = range.end;
            startCol = range.begin;
            if (endCol < startCol) {
                this.getErrorHandler().log("invalid column range", this.getClass().getName(), m_method_autoFit);
                bValidColRange = false;
            }
        }
        int startRow = 0;
        int endRow = 0;
        if (calcRowHeights || calcColWidths || calcRowHeaderColWidths) {
            Range range = this.getAutoFitRowRange();
            endRow = range.end;
            startRow = range.begin;
            if (endRow < startRow) {
                this.getErrorHandler().log("invalid row range", this.getClass().getName(), m_method_autoFit);
                bValidRowRange = false;
            }
        }
        this.canResizeHeights = false;
        this.canResizeWidths = false;
        this.m_bAutoFitting = true;
        int colCount = endCol - startCol + 1;
        int rowCount = endRow - startRow + 1;
        if (calcRowHeaderColWidths && this.pivotTable.isRowPivotHeaderVisible() && this.getCrosstabModel().isRowHeaderVisible() && bValidRowRange) {
            widths = this.isOutline() ? this.calcAutoFitOutlineRowHeaderWidths(startRow, endRow) : this.calcAutoFitInlineRowHeaderWidths(startRow, endRow);
            for (int col = 0; col < widths.length; ++col) {
                this.getCrosstabSizingManager().setCalculatedRowHeaderColumnWidth(col, widths[col]);
            }
        }
        if (calcColWidths && bValidColRange) {
            widths = this.calcAutoFitColumnWidths(startCol, endCol, startRow, endRow);
            int maxWidth = 0;
            for (int i = 0; i < widths.length; ++i) {
                if (widths[i] <= maxWidth) continue;
                maxWidth = widths[i];
            }
            this.getCrosstabSizingManager().setDefaultColumnWidth(maxWidth);
        }
        if (calcColHeaderRowHeights && this.pivotTable.isColumnPivotHeaderVisible() && this.getCrosstabModel().isColumnHeaderVisible() && bValidColRange) {
            heights = this.calcAutoFitColHeaderHeights(startCol, endCol);
            for (int row = 0; row < heights.length; ++row) {
                this.getCrosstabSizingManager().setCalculatedColumnHeaderRowHeight(row, heights[row]);
            }
        }
        if (calcRowHeights && bValidRowRange) {
            heights = this.calcAutoFitRowHeights(startCol, endCol, startRow, endRow);
            int totalHeight = 0;
            int height = 0;
            for (int row = startRow; row <= endRow; ++row) {
                height = heights[row - startRow];
                totalHeight += height;
                this.getCrosstabSizingManager().setCalculatedRowHeight(row, height);
            }
            if (rowCount > 0) {
                int defHeight = totalHeight / rowCount;
                this.getPivotTable().m_calculatedRowCount += rowCount;
                this.getPivotTable().m_accumulatedCalculatedRowHeight += totalHeight;
                this.getCrosstabSizingManager().setDefaultRowHeight(defHeight);
            }
        }
        if ((calcRowHeights || calcColWidths || calcColHeaderRowHeights) && this.getAutoFitColumnRangeCallback() != null) {
            this.getAutoFitColumnRangeCallback().endAutoFit();
        }
        if ((calcRowHeights || calcColWidths || calcRowHeaderColWidths) && this.getAutoFitRowRangeCallback() != null) {
            this.getAutoFitRowRangeCallback().endAutoFit();
        }
        this.canResizeHeights = true;
        this.canResizeWidths = true;
        this.m_bAutoFitting = false;
        this.doSizing();
        this.crosstabController.fireComponentSized(this, (ComponentHandle)new NonDataComponentHandle(21, CROSSTAB_NAME, (Object)this));
    }

    public Crosstab cloneForPrint() {
        Crosstab ct = new Crosstab();
        ct.setVisible(this.isVisible());
        ct.setEnabled(this.isEnabled());
        try {
            ct.setCrosstabModel((CrosstabModel)this.getCrosstabModel().clone());
            ct.setCrosstabController((CrosstabController)this.getCrosstabController().cloneForNewView(ct));
            ct.setDataSource(this.getDataSource());
            ct.setGridViewFormatManager((GridViewFormatManager)this.getGridViewFormatManager().clone());
            ct.setGridViewDatabodyStyleManager((GridViewDatabodyStyleManager)this.getGridViewDatabodyStyleManager().clone());
            ct.setGridViewHeaderStyleManager((GridViewHeaderStyleManager)this.getGridViewHeaderStyleManager().clone());
            ct.setCrosstabSizingManager((CrosstabSizingManager)this.getCrosstabSizingManager().clone());
            ct.setGridViewSelectionManager((GridViewSelectionManager)this.getGridViewSelectionManager().clone());
            ct.setRolloverTextManager((RolloverTextManager)this.getRolloverTextManager().clone());
        }
        catch (CloneNotSupportedException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), m_method_cloneForPrint);
        }
        ct.setHGridVisible(this.isHGridVisible());
        ct.setVGridVisible(this.isVGridVisible());
        ct.setCellMaxHeight(this.getCellMaxHeight());
        ct.setCellMinHeight(this.getCellMinHeight());
        ct.setCellMaxWidth(this.getCellMaxWidth());
        ct.setCellMinWidth(this.getCellMinWidth());
        for (int index = 1; index < this.getDrillImageCount(); ++index) {
            ct.setDrillImage(index, this.getDrillImage(index));
        }
        ct.getDatabody().getViewStyle().setEditBackground(this.getDatabody().getViewStyle().getEditBackground());
        ct.getDatabody().getViewStyle().setEditForeground(this.getDatabody().getViewStyle().getEditForeground());
        ct.setBodyHighlighterVisible(this.isBodyHighlighterVisible());
        ct.setRowHighlighterVisible(this.isRowHighlighterVisible());
        ct.setColumnHighlighterVisible(this.isColumnHighlighterVisible());
        ct.setHighlighterSize(this.getHighlighterSize());
        ct.setZoomFactor(this.getZoomFactor());
        this.copyCrosstabPivotTable(ct.getPivotTable(), this.getPivotTable());
        return ct;
    }

    @Override
    public void sizeColumnHeaderRowHeights() {
        if (this.m_bAutoFitting) {
            return;
        }
        CrosstabSizingManager csm = this.getCrosstabSizingManager();
        if (csm == null) {
            return;
        }
        CrosstabPivotHeader ch = this.getCrosstabColumnHeader();
        int minCellHeight = DataviewUtils.scaleByZoom((int)this.cellMinHeight, (int)this.zoomFactor);
        int maxCellHeight = DataviewUtils.scaleByZoom((int)this.cellMaxHeight, (int)this.zoomFactor);
        int size = 0;
        int rows = ch.getModel().getRowCount();
        for (int row = 0; row < rows; ++row) {
            size = csm.getColumnHeaderRowHeight(row);
            if (size == -1) continue;
            int scaledSize = DataviewUtils.scaleByZoom((int)size, (int)this.zoomFactor);
            if (scaledSize < minCellHeight) {
                scaledSize = minCellHeight;
            }
            if (scaledSize > maxCellHeight) {
                scaledSize = maxCellHeight;
            }
            ch.setRowHeight(row, scaledSize);
        }
    }

    @Override
    public void sizeRowHeaderColumnWidths() {
        if (this.m_bAutoFitting) {
            return;
        }
        CrosstabSizingManager csm = this.getCrosstabSizingManager();
        if (csm == null) {
            return;
        }
        CrosstabPivotHeader rh = this.getCrosstabRowHeader();
        int minCellWidth = DataviewUtils.scaleByZoom((int)this.cellMinWidth, (int)this.zoomFactor);
        int maxCellWidth = DataviewUtils.scaleByZoom((int)this.cellMaxWidth, (int)this.zoomFactor);
        int size = 0;
        int columns = rh.getModel().getColumnCount();
        for (int column = 0; column < columns; ++column) {
            size = csm.getRowHeaderColumnWidth(column);
            if (size == -1) continue;
            int scaledSize = DataviewUtils.scaleByZoom((int)size, (int)this.zoomFactor);
            if (scaledSize < minCellWidth) {
                scaledSize = minCellWidth;
            }
            if (scaledSize > maxCellWidth) {
                scaledSize = maxCellWidth;
            }
            rh.setColumnWidth(column, scaledSize);
        }
        this.updateRowPivotHandleSize();
    }

    @Override
    public void sizeRowHeights() {
        if (this.m_bAutoFitting) {
            return;
        }
        CrosstabSizingManager csm = this.getCrosstabSizingManager();
        if (csm == null) {
            return;
        }
        if (this.getCrosstabModel().getCrosstabDataSource().getRowCount() < 1) {
            return;
        }
        int minCellHeight = DataviewUtils.scaleByZoom((int)this.cellMinHeight, (int)this.zoomFactor);
        int maxCellHeight = DataviewUtils.scaleByZoom((int)this.cellMaxHeight, (int)this.zoomFactor);
        int size = csm.getDefaultRowHeight();
        if (size != -1) {
            int scaledSize = DataviewUtils.scaleByZoom((int)size, (int)this.zoomFactor);
            if (scaledSize < minCellHeight) {
                scaledSize = minCellHeight;
            }
            if (scaledSize > maxCellHeight) {
                scaledSize = maxCellHeight;
            }
            if (this.getCrosstabDatabody().getDefaultRowHeight() != scaledSize) {
                this.getPivotTable().setDefaultRowHeight(scaledSize);
            }
        }
        if (!this.getPivotTable().m_bCheckingRowHeights) {
            int endRow;
            this.getPivotTable().clearSizedRowFlags();
            int startRow = this.getPivotTable().getFirstRowOnScreen();
            if (startRow < 0) {
                startRow = 0;
            }
            if ((endRow = this.getCrosstabDatabody().getOnScreenRowCount() + startRow - 1) < startRow) {
                endRow = startRow;
            }
            this.sizeRowHeights(startRow, endRow);
            boolean done = false;
            while (!done) {
                boolean bNewEndRow;
                int oldStartRow = startRow;
                int oldEndRow = endRow;
                startRow = this.getCrosstabDatabody().getFirstRowOnScreen();
                if (startRow < 0) {
                    startRow = 0;
                }
                if ((endRow = this.getCrosstabDatabody().getOnScreenRowCount() + startRow - 1) < startRow) {
                    endRow = startRow;
                }
                boolean bNewStartRow = startRow < oldStartRow;
                boolean bl = bNewEndRow = endRow > oldEndRow;
                if (!bNewStartRow && !bNewEndRow) {
                    done = true;
                    continue;
                }
                if (bNewStartRow) {
                    this.sizeRowHeights(startRow, oldStartRow - 1);
                }
                if (!bNewEndRow) continue;
                this.sizeRowHeights(oldEndRow + 1, endRow);
            }
        }
    }

    protected void sizeRowHeights(int firstRow, int lastRow) {
        if (this.m_bAutoFitting) {
            return;
        }
        if (firstRow < 0 || lastRow < 0) {
            this.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_sizerowheights);
            return;
        }
        CrosstabSizingManager csm = this.getCrosstabSizingManager();
        if (csm == null) {
            return;
        }
        int minCellHeight = DataviewUtils.scaleByZoom((int)this.cellMinHeight, (int)this.zoomFactor);
        int maxCellHeight = DataviewUtils.scaleByZoom((int)this.cellMaxHeight, (int)this.zoomFactor);
        int size = 0;
        for (int row = firstRow; row <= lastRow; ++row) {
            size = csm.getRowHeight(row);
            if (size == -1) continue;
            int scaledSize = DataviewUtils.scaleByZoom((int)size, (int)this.zoomFactor);
            if (scaledSize < minCellHeight) {
                scaledSize = minCellHeight;
            }
            if (scaledSize > maxCellHeight) {
                scaledSize = maxCellHeight;
            }
            this.getPivotTable().m_sizedRowFlags[row] = true;
            this.getPivotTable().setRowHeight(row, scaledSize);
        }
    }

    @Override
    public void sizeColumnWidths() {
        int endCol;
        if (this.m_bAutoFitting) {
            return;
        }
        CrosstabSizingManager csm = this.getCrosstabSizingManager();
        if (csm == null) {
            return;
        }
        if (this.getCrosstabModel().getCrosstabDataSource().getColumnCount() < 1) {
            return;
        }
        int minCellWidth = DataviewUtils.scaleByZoom((int)this.cellMinWidth, (int)this.zoomFactor);
        int maxCellWidth = DataviewUtils.scaleByZoom((int)this.cellMaxWidth, (int)this.zoomFactor);
        int size = csm.getDefaultColumnWidth();
        if (size != -1) {
            int scaledSize = DataviewUtils.scaleByZoom((int)size, (int)this.zoomFactor);
            if (scaledSize < minCellWidth) {
                scaledSize = minCellWidth;
            }
            if (scaledSize > maxCellWidth) {
                scaledSize = maxCellWidth;
            }
            if (this.getCrosstabDatabody().getDefaultColumnWidth() != scaledSize) {
                this.getPivotTable().setDefaultColumnWidth(scaledSize);
            }
        }
        this.getPivotTable().clearSizedColumnFlags();
        int startCol = this.getPivotTable().getFirstColumnOnScreen();
        if (startCol < 0) {
            startCol = 0;
        }
        if ((endCol = this.getCrosstabDatabody().getOnScreenColumnCount() + startCol - 1) < startCol) {
            endCol = startCol;
        }
        this.sizeColumnWidths(startCol, endCol);
        boolean done = false;
        while (!done) {
            boolean bNewEndCol;
            int oldStartCol = startCol;
            int oldEndCol = endCol;
            startCol = this.getCrosstabDatabody().getFirstColumnOnScreen();
            if (startCol < 0) {
                startCol = 0;
            }
            if ((endCol = this.getCrosstabDatabody().getOnScreenColumnCount() + startCol - 1) < startCol) {
                endCol = startCol;
            }
            boolean bNewStartCol = startCol < oldStartCol;
            boolean bl = bNewEndCol = endCol > oldEndCol;
            if (!bNewStartCol && !bNewEndCol) {
                done = true;
                continue;
            }
            if (bNewStartCol) {
                this.sizeColumnWidths(startCol, oldStartCol - 1);
            }
            if (!bNewEndCol) continue;
            this.sizeColumnWidths(oldEndCol + 1, endCol);
        }
    }

    protected void sizeColumnWidths(int firstCol, int lastCol) {
        if (this.m_bAutoFitting) {
            return;
        }
        if (firstCol < 0 || lastCol < 0) {
            this.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_sizecolumnwidths);
            return;
        }
        CrosstabSizingManager csm = this.getCrosstabSizingManager();
        if (csm == null) {
            return;
        }
        int minCellWidth = DataviewUtils.scaleByZoom((int)this.cellMinWidth, (int)this.zoomFactor);
        int maxCellWidth = DataviewUtils.scaleByZoom((int)this.cellMaxWidth, (int)this.zoomFactor);
        int size = 0;
        for (int col = firstCol; col <= lastCol; ++col) {
            size = csm.getColumnWidth(col);
            if (size == -1) continue;
            int scaledSize = DataviewUtils.scaleByZoom((int)size, (int)this.zoomFactor);
            if (scaledSize < minCellWidth) {
                scaledSize = minCellWidth;
            }
            if (scaledSize > maxCellWidth) {
                scaledSize = maxCellWidth;
            }
            this.getPivotTable().m_sizedColFlags[col] = true;
            this.getPivotTable().setColumnWidth(col, scaledSize);
        }
    }

    @Override
    public void doSizing() {
        if (this.xmlMode) {
            return;
        }
        if (!this.canResizeHeights || !this.canResizeWidths) {
            return;
        }
        if (this.m_bAutoFitting) {
            return;
        }
        if (this.getCrosstabSizingManager() == null) {
            return;
        }
        this.canResizeHeights = false;
        this.canResizeWidths = false;
        this.sizeColumnHeaderRowHeights();
        this.sizeRowHeaderColumnWidths();
        this.sizeRowHeights();
        this.sizeColumnWidths();
        this.canResizeHeights = true;
        this.canResizeWidths = true;
    }

    @Override
    protected int[] calcAutoFitColumnWidths(int startCol, int endCol, int startRow, int endRow) {
        ImmInsets emptyInsets;
        int currZoomf = this.zoomFactor;
        this.zoomFactor = 100;
        CrosstabPivotHeader header = this.getCrosstabColumnHeader();
        int minCellWidth = this.cellMinWidth;
        int maxCellWidth = this.cellMaxWidth;
        int colCount = endCol - startCol + 1;
        ImmInsets insets = emptyInsets = new ImmInsets(0, 0, 0, 0);
        Grid g = header.getGrid();
        TwoDModel ds = header.getModel();
        int colHeaderRows = ds.getRowCount();
        int depth = colHeaderRows - 1;
        int offset = 0;
        Grid dataGrid = this.getCrosstabDatabody().getGrid();
        TwoDModel gridModel = this.pivotTable.getGridModel();
        GridViewAppearanceMgr appMgr = (GridViewAppearanceMgr)this.getCrosstabDatabody().getAppearanceManager();
        int defaultWidth = 0;
        int[] widths = new int[colCount];
        for (int column = startCol; column <= endCol; ++column) {
            Image img;
            ImmInsets appInsets;
            FontMetrics fm;
            PaintContext pc;
            int width = 0;
            if (this.pivotTable.isColumnPivotHeaderVisible() && this.getCrosstabModel().isColumnHeaderVisible() && colHeaderRows > 0) {
                ViewStyle headerStyle;
                pc = g.getCellPaintContext(column, depth);
                fm = pc.getFontMetrics(header.getStyle(column, depth).getFont());
                String data = (String)((CrosstabHeaderCell)ds.getData(column, depth)).getData();
                if (data == null) {
                    data = "";
                }
                insets = (headerStyle = header.getStyle(column, depth)).getBorderPainter() != null ? headerStyle.getBorderPainter().getInsets(pc) : emptyInsets;
                appInsets = header.getStyle(column, depth).getInsets();
                offset = insets.left + insets.right + appInsets.left + appInsets.right;
                offset += 2;
                ++offset;
                int drillImageWidth = 0;
                if (this.isDrillingEnabled() && !this.isPrintOrPreviewMode() && header.isDrilledOrDrillable(column, depth)) {
                    drillImageWidth = header.getBlankImage().getWidth(null);
                }
                int graphicImageWidth = 0;
                img = header.getGraphicImage(column, depth, false);
                if (img != null && !this.isPrintOrPreviewMode()) {
                    graphicImageWidth = img.getWidth(pc.getImageObserver());
                    ++graphicImageWidth;
                }
                width = fm.stringWidth(data) + drillImageWidth + graphicImageWidth + offset;
            }
            int cellWidth = 0;
            for (int row = startRow; row <= endRow; ++row) {
                ViewStyle style = appMgr.getCellAppearance(column, row);
                pc = dataGrid.getCellPaintContext(column, row);
                fm = pc.getFontMetrics(style.getFont());
                insets = style.getBorderPainter() != null ? style.getBorderPainter().getInsets(pc) : emptyInsets;
                appInsets = style.getInsets();
                img = ((CrosstabDatabody)this.getDatabody()).getGraphicImage(column, row, false);
                int stringWidth = fm.stringWidth(gridModel.getData(column, row).toString());
                int graphicImageWidth = 0;
                if (img != null && !this.isPrintOrPreviewMode()) {
                    graphicImageWidth = img.getWidth(pc.getImageObserver());
                    ++graphicImageWidth;
                }
                int annotationWidth = 0;
                if (this.isAnnotationIconVisible() && (!this.isPrintOrPreviewMode() || this.isAnnotationIconPrinted()) && this.getGridViewModel().getGridViewDataSource().getAnnotation(column, row) != null) {
                    annotationWidth = this.getAnnotationImage().getWidth(pc.getImageObserver());
                    ++annotationWidth;
                }
                int dataWidth = graphicImageWidth + stringWidth + annotationWidth + insets.left + insets.right + appInsets.left + appInsets.right;
                cellWidth = Math.max(dataWidth, cellWidth);
            }
            if (width < cellWidth) {
                width = cellWidth;
            }
            if (width < minCellWidth) {
                width = minCellWidth;
            }
            if (width > maxCellWidth) {
                width = maxCellWidth;
            }
            widths[column - startCol] = width;
            if (width <= defaultWidth) continue;
            defaultWidth = width;
        }
        this.zoomFactor = currZoomf;
        return widths;
    }

    @Override
    protected int[] calcAutoFitRowHeights(int startCol, int endCol, int startRow, int endRow) {
        ImmInsets emptyInsets;
        int currZoomf = this.zoomFactor;
        this.zoomFactor = 100;
        int minCellHeight = this.cellMinHeight;
        int maxCellHeight = this.cellMaxHeight;
        int rowCount = endRow - startRow + 1;
        GridViewTextPainter painter = new GridViewTextPainter(this);
        boolean sepWidth = false;
        boolean sepHeight = false;
        boolean fontHeight = false;
        int enhFontHeight = 0;
        int offset = 0;
        int height = 0;
        int horzOffset = 0;
        boolean resized = false;
        int rowHeaderCols = this.getCrosstabRowHeader().getModel().getColumnCount();
        Grid g = this.getCrosstabDatabody().getGrid();
        GridViewAppearanceMgr appMgr = (GridViewAppearanceMgr)this.getCrosstabDatabody().getAppearanceManager();
        Grid rowGrid = this.getCrosstabRowHeader().getGrid();
        CrosstabPivotHeader rowHeader = this.getCrosstabRowHeader();
        ImmInsets insets = emptyInsets = new ImmInsets(0, 0, 0, 0);
        TwoDModel rds = this.getCrosstabRowHeader().getModel();
        int[] heights = new int[rowCount];
        for (int row = startRow; row <= endRow; ++row) {
            FontMetrics fm;
            int col;
            int oldHeight = 0;
            int currRowHeight = this.getRowHeight(row);
            for (col = startCol; col <= endCol; ++col) {
                int annotationHeight;
                int imageHt;
                int graphicImageWidth = 0;
                PaintContext context = g.getCellPaintContext(col, row);
                ViewStyle style = appMgr.getCellAppearance(col, row);
                ImmInsets appInsets = style.getInsets();
                insets = style.getBorderPainter() != null ? style.getBorderPainter().getInsets(context) : emptyInsets;
                enhFontHeight = DataviewUtils.adjustForEnhancedFont((int)0, (boolean)style.isUnderline(), (boolean)style.isDoubleUnderline());
                offset = insets.top + insets.bottom + appInsets.top + appInsets.bottom + enhFontHeight;
                Image img = ((CrosstabDatabody)this.getDatabody()).getGraphicImage(col, row, false);
                if (img != null && !this.isPrintOrPreviewMode()) {
                    graphicImageWidth = img.getWidth(context.getImageObserver());
                    ++graphicImageWidth;
                }
                boolean bAnnotation = this.isAnnotationIconVisible() && (!this.isPrintOrPreviewMode() || this.isAnnotationIconPrinted()) && this.getGridViewModel().getGridViewDataSource().getAnnotation(col, row) != null;
                int annotationWidth = 0;
                if (bAnnotation) {
                    annotationWidth = this.getAnnotationImage().getWidth(context.getImageObserver());
                    ++annotationWidth;
                }
                horzOffset = insets.left + insets.right + graphicImageWidth + appInsets.left + appInsets.right + annotationWidth;
                if (style.isWordWrapEnabled()) {
                    final PaintContext fContext = context;
                    final Font fFont = style.getFont();
                    Dimension d = painter.getSize((PaintContext)new PaintContextProxy(){

                        protected PaintContext getPaintContext() {
                            return fContext;
                        }

                        public Font getPaintFont() {
                            return fFont;
                        }
                    }, this.getColumnWidth(col) - horzOffset, currRowHeight);
                    height = d.height;
                } else {
                    fm = context.getFontMetrics(style.getFont());
                    height = fm.getHeight();
                }
                if (img != null && (imageHt = img.getHeight(context.getImageObserver())) > height) {
                    height = imageHt;
                }
                if (bAnnotation && (annotationHeight = this.getAnnotationImage().getHeight(context.getImageObserver())) > height) {
                    height = annotationHeight;
                }
                if ((height += offset) <= oldHeight) continue;
                oldHeight = height;
            }
            if (this.pivotTable.isRowPivotHeaderVisible() && this.getCrosstabModel().isRowHeaderVisible() && rowHeaderCols > 0) {
                int imageHt;
                col = rowHeaderCols - 1;
                PaintContext context = rowGrid.getCellPaintContext(col, row);
                ViewStyle rowStyle = rowHeader.getStyle(col, row);
                insets = rowStyle.getBorderPainter() != null ? rowStyle.getBorderPainter().getInsets(context) : emptyInsets;
                ImmInsets appInsets = rowStyle.getInsets();
                enhFontHeight = DataviewUtils.adjustForEnhancedFont((int)0, (boolean)rowStyle.isUnderline(), (boolean)rowStyle.isDoubleUnderline());
                offset = insets.top + insets.bottom + appInsets.top + appInsets.bottom + enhFontHeight;
                ++offset;
                int drillImageWidth = rowHeader.getBlankImage().getWidth(null);
                int drillImageHeight = rowHeader.getBlankImage().getHeight(null);
                int graphicImageWidth = 0;
                Image img = rowHeader.getGraphicImage(col, row, false);
                if (img != null && !this.isPrintOrPreviewMode()) {
                    graphicImageWidth = img.getWidth(context.getImageObserver());
                    ++graphicImageWidth;
                }
                horzOffset = insets.left + insets.right + appInsets.left + appInsets.right + drillImageWidth + graphicImageWidth;
                horzOffset += 2;
                ++horzOffset;
                if (rowStyle.isWordWrapEnabled()) {
                    Font font = rowStyle.getFont();
                    FontMetrics metrics = context.getFontMetrics(font);
                    String text = (String)((CrosstabHeaderCell)rds.getData(col, row)).getData();
                    WrappedText wrappedText = new WrappedText(text, WordWrapper.getTextWrapper(), this.getRowHeaderColumnWidth(col) - horzOffset, metrics, context.getPaintLocale(), false);
                    int numLines = wrappedText.getLineCount();
                    height = numLines * metrics.getHeight() - metrics.getLeading();
                } else {
                    fm = context.getFontMetrics(rowStyle.getFont());
                    height = fm.getHeight();
                }
                if (img != null && (imageHt = img.getHeight(context.getImageObserver())) > height) {
                    height = imageHt;
                }
                if (drillImageHeight > height) {
                    height = drillImageHeight;
                }
                if ((height += offset) > oldHeight) {
                    oldHeight = height;
                }
            }
            if (oldHeight < minCellHeight) {
                oldHeight = minCellHeight;
            }
            if (oldHeight > maxCellHeight) {
                oldHeight = maxCellHeight;
            }
            this.pivotTable.m_calculatedRowHeights[row] = oldHeight;
            heights[row - startRow] = oldHeight;
        }
        this.zoomFactor = currZoomf;
        return heights;
    }

    protected int resizeRowHeight(int row, int startCol, int endCol) {
        if (row < 0 || row > this.pivotTable.getGridModel().getRowCount() - 1) {
            this.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_resizerowheight);
            return -1;
        }
        if (this.pivotTable.m_calculatedRowHeights[row] != -1) {
            return this.pivotTable.m_calculatedRowHeights[row];
        }
        int[] heights = this.calcAutoFitRowHeights(startCol, endCol, row, row);
        return heights[0];
    }

    @Override
    protected Range getAutoFitColumnRange() {
        return super.getAutoFitColumnRange();
    }

    @Override
    protected Range getAutoFitColumnRange(int firstCol) {
        return super.getAutoFitColumnRange(firstCol);
    }

    @Override
    protected void metadataLabelTypeChanged() {
        this.getCrosstabModel().getColumnHeaderHandleDataSource().clearCache();
        this.getCrosstabModel().getRowHeaderHandleDataSource().clearCache();
        super.metadataLabelTypeChanged();
        this.updatePivotHandleSize();
        this.repaint();
    }

    protected void updateRowPivotHandleSize() {
        ViewStyle style = null;
        if (this.pivotTable == null || this.xmlMode || this.m_highlighterSizeSet) {
            return;
        }
        int currZoomf = this.zoomFactor;
        this.zoomFactor = 100;
        Header rowHeaderHandle = this.pivotTable.getCrosstabRowHeader().getColumnHeader();
        int rowHandles = 0;
        try {
            rowHandles = this.crosstabModel.getDataAccess().getLayerCount(1);
        }
        catch (EdgeOutOfRangeException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), "updateRowPivotHandleSize");
        }
        int width = CrosstabDefaultValues.getHighlighterSize();
        PaintContext pc = null;
        FontMetrics fm = null;
        ImmInsets insets = null;
        String data = null;
        boolean bRowHeaderPivotHandleDrillIconsVisible = this.isPivotHandleDrillIconVisible(1);
        int height = CrosstabDefaultValues.getHighlighterSize();
        int enhFontHeight = 0;
        if ((this.isPivotLabelVisible() || bRowHeaderPivotHandleDrillIconsVisible) && this.pivotTable.isRowPivotHeaderVisible()) {
            CrosstabPivotHeader rowPivotHeader = this.pivotTable.getCrosstabRowHeader();
            for (int i = 0; i < rowHandles; ++i) {
                style = rowPivotHeader.getPivotHandleViewStyle(i);
                int tmpHeight = 0;
                pc = rowHeaderHandle.getItemPaintContext(i);
                ImmInsets borderInsets = rowHeaderHandle.getHeaderItemBorderPainter().getInsets(pc);
                if (style != null) {
                    insets = style.getInsets();
                    fm = pc.getFontMetrics(style.getFont());
                    enhFontHeight = DataviewUtils.adjustForEnhancedFont((int)0, (boolean)style.isUnderline(), (boolean)style.isDoubleUnderline());
                    int dataHeight = 0;
                    int grippyHeight = 0;
                    if (this.isPivotLabelVisible()) {
                        data = (String)((PivotHandleCell)((Object)rowHeaderHandle.getModel().getData(i))).getData();
                        grippyHeight = PivotGrippyPainter.getPainter((boolean)false).getMinimumSize((PaintContext)pc).height;
                    }
                    if (data != null) {
                        dataHeight = fm.getHeight() + enhFontHeight;
                    }
                    if (height > (tmpHeight = Math.max(dataHeight + insets.top + insets.bottom + borderInsets.top + borderInsets.bottom, grippyHeight))) {
                        tmpHeight = height;
                    }
                }
                int drillImageHeight = 0;
                if (bRowHeaderPivotHandleDrillIconsVisible) {
                    drillImageHeight = this.getCrosstabRowHeader().getBlankImage().getHeight(null);
                }
                if (style != null) {
                    insets = style.getInsets();
                    drillImageHeight += insets.top + insets.bottom + borderInsets.top + borderInsets.bottom;
                }
                tmpHeight = Math.max(drillImageHeight, tmpHeight);
                Painter p = rowPivotHeader.getPivotHeaderUI().getDefaultHeaderItemPainter((JComponent)((Object)rowPivotHeader), false);
                tmpHeight = Math.max(p.getMinimumSize(null).height, tmpHeight);
                if (style != null && this.isPivotLabelVisible() && style.isWordWrapEnabled()) {
                    int wrapHeight = this.getRowHeaderWrapHeight(style, pc, currZoomf, data, i, fm, enhFontHeight);
                    tmpHeight = Math.max(wrapHeight, tmpHeight);
                }
                height = Math.max(tmpHeight, height);
            }
        }
        this.highlighterHeight = height;
        this.zoomFactor = currZoomf;
        if (this.zoomFactor == 100) {
            this.getPivotTable().setRowSelectorHeight(height);
        } else {
            height = DataviewUtils.scaleByZoom((int)height, (int)this.zoomFactor);
            this.getPivotTable().setRowSelectorHeight(height);
        }
    }

    protected void updateColPivotHandleSize() {
        ViewStyle style = null;
        if (this.pivotTable == null || this.xmlMode || this.m_highlighterSizeSet) {
            return;
        }
        int currZoomf = this.zoomFactor;
        this.zoomFactor = 100;
        Header columnHeaderHandle = this.pivotTable.getCrosstabColumnHeader().getRowHeader();
        int columnHandles = 0;
        try {
            columnHandles = this.crosstabModel.getDataAccess().getLayerCount(0);
        }
        catch (EdgeOutOfRangeException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), "updateColPivotHandleSize");
        }
        int width = CrosstabDefaultValues.getHighlighterSize();
        PaintContext pc = null;
        FontMetrics fm = null;
        ImmInsets insets = null;
        String data = null;
        boolean bColHeaderPivotHandleDrillIconsVisible = this.isPivotHandleDrillIconVisible(0);
        if ((this.isPivotLabelVisible() || bColHeaderPivotHandleDrillIconsVisible) && this.pivotTable.isColumnPivotHeaderVisible()) {
            for (int i = 0; i < columnHandles; ++i) {
                style = this.pivotTable.getCrosstabColumnHeader().getPivotHandleViewStyle(i);
                int tmpWidth = 0;
                pc = columnHeaderHandle.getItemPaintContext(i);
                ImmInsets borderInsets = columnHeaderHandle.getHeaderItemBorderPainter().getInsets(pc);
                if (style != null) {
                    insets = style.getInsets();
                    fm = pc.getFontMetrics(style.getFont());
                    if (this.isPivotLabelVisible()) {
                        data = (String)((PivotHandleCell)((Object)columnHeaderHandle.getModel().getData(i))).getData();
                    }
                    tmpWidth += 2;
                    if (data != null) {
                        tmpWidth += insets.right + fm.stringWidth(data) + insets.left + borderInsets.left + borderInsets.right;
                        tmpWidth += 3;
                    }
                }
                int drillImageWidth = 0;
                if (bColHeaderPivotHandleDrillIconsVisible) {
                    drillImageWidth = this.getCrosstabColumnHeader().getBlankImage().getWidth(null);
                }
                width = Math.max(tmpWidth += this.getHighlighterSize() + drillImageWidth, width);
            }
        }
        this.highlighterWidth = width;
        this.zoomFactor = currZoomf;
        if (this.zoomFactor == 100 || this.isPivotLabelVisible()) {
            this.getPivotTable().setColumnSelectorWidth(width);
        } else {
            width = DataviewUtils.scaleByZoom((int)width, (int)this.zoomFactor);
            this.getPivotTable().setColumnSelectorWidth(width);
        }
    }

    protected void updatePivotHandleSize() {
        this.updateRowPivotHandleSize();
        this.updateColPivotHandleSize();
    }

    @Override
    public void updateColumnHeaderRowHeights() {
        if (this.pivotTable == null || this.xmlMode || this.m_bAutoFitting || !this.pivotTable.isColumnPivotHeaderVisible()) {
            return;
        }
        if ((this.getAutoFitScope() & 4) < 1) {
            return;
        }
        Range range = this.getAutoFitColumnRange();
        int endCol = range.end;
        int startCol = range.begin;
        if (endCol < startCol) {
            this.getErrorHandler().log("invalid column range", this.getClass().getName(), m_method_updateColumnHeaderRowHeights);
            return;
        }
        int[] heights = this.calcAutoFitColHeaderHeights(startCol, endCol);
        if (this.getAutoFitColumnRangeCallback() != null) {
            this.getAutoFitColumnRangeCallback().endAutoFit();
        }
        if (heights == null) {
            return;
        }
        for (int row = 0; row < heights.length; ++row) {
            this.getCrosstabSizingManager().setCalculatedColumnHeaderRowHeight(row, heights[row]);
        }
        this.sizeColumnHeaderRowHeights();
    }

    @Override
    public void setColumnVisible(int column, boolean visible) {
        if (column < 0 || column > this.pivotTable.getGridModel().getColumnCount()) {
            this.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_setcolumnvisible);
        } else {
            int j;
            int i = this.invisibleColumn.size();
            boolean nodeExit = false;
            boolean search = true;
            for (j = 0; j < i && !nodeExit && search; ++j) {
                if ((Integer)this.invisibleColumn.elementAt(j) == column) {
                    nodeExit = true;
                }
                if ((Integer)this.invisibleColumn.elementAt(j) <= column) continue;
                search = false;
                --j;
            }
            if (!nodeExit && !visible) {
                this.invisibleColumn.insertElementAt(column, j);
            }
            if (nodeExit && visible) {
                this.invisibleColumn.removeElementAt(j - 1);
            }
            this.getCrosstabColumnHeader().setColumnVisible(column, visible);
            this.getCrosstabDatabody().setColumnVisible(column, visible);
        }
    }

    @Override
    public void setRowVisible(int row, boolean visible) {
        if (row < 0 || row >= this.pivotTable.getGridModel().getRowCount()) {
            this.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_setrowvisible);
        } else {
            int j;
            int i = this.invisibleRow.size();
            boolean nodeExit = false;
            boolean search = true;
            for (j = 0; j < i && !nodeExit && search; ++j) {
                if ((Integer)this.invisibleRow.elementAt(j) == row) {
                    nodeExit = true;
                }
                if ((Integer)this.invisibleRow.elementAt(j) <= row) continue;
                search = false;
                --j;
            }
            if (!nodeExit && !visible) {
                this.invisibleRow.insertElementAt(row, j);
            }
            if (nodeExit && visible) {
                this.invisibleRow.removeElementAt(j - 1);
            }
            this.getCrosstabRowHeader().setRowVisible(row, visible);
            this.getCrosstabDatabody().setRowVisible(row, visible);
        }
    }

    @Override
    public boolean isRowVisible(int row) {
        if (row < 0 || row >= this.pivotTable.getGridModel().getRowCount()) {
            this.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_isrowvisible);
            return false;
        }
        return this.getCrosstabDatabody().isRowVisible(row);
    }

    @Override
    public boolean isColumnVisible(int col) {
        if (col < 0 || col > this.pivotTable.getGridModel().getColumnCount()) {
            this.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_iscolumnvisible);
            return false;
        }
        return this.getCrosstabDatabody().isColumnVisible(col);
    }

    @Override
    public void setPivotLabelVisible(boolean visible) {
        boolean old = this.isPivotLabelVisible();
        this.m_bPivotLabelVisible = visible;
        this.checkAxisLabelVisibility();
        this.updatePivotHandleSize();
        this.updateRowHeaderWidths();
        this.firePropertyChange(this, "PivotLabelVisible", old, visible);
    }

    @Override
    public boolean isPivotLabelVisible() {
        return this.m_bPivotLabelVisible;
    }

    @Override
    public void setReorderType(int type) {
        if (type < 0 || type > 2) {
            this.getErrorHandler().log("invalid reorder type", this.getClass().getName(), m_method_setreordertype);
            return;
        }
        int oldValue = this.getReorderType();
        this.reorderType = type;
        this.firePropertyChange(this, "ReorderType", oldValue, type);
    }

    @Override
    public int getReorderType() {
        return this.reorderType;
    }

    @Override
    public void setSwapMembersAllowed(boolean swap) {
        boolean old = this.isSwapMembersAllowed();
        this.m_bSwapMembers = swap;
        this.firePropertyChange(this, "SwapMembersAllowed", old, swap);
    }

    @Override
    public boolean isSwapMembersAllowed() {
        return this.m_bSwapMembers;
    }

    protected String getIntlCrosstabString(String key) {
        return this.getIntlString(key, this.localStrings);
    }

    @Override
    public void setTotal(int edge, Total total) {
        if (this.isLoadingViewFromPersistence()) {
            if (edge == 1) {
                this.m_tmpRowTotal = total;
            } else {
                this.m_tmpColumnTotal = total;
            }
            return;
        }
        boolean bRet = Crosstab.setTotal(this.getClass().getName(), this.getDataDirector(), this.getErrorHandler(), edge, total, this.m_rowTotal, this.m_columnTotal);
        if (bRet) {
            if (edge == 1) {
                this.m_rowTotal = total;
            } else {
                this.m_columnTotal = total;
            }
        }
    }

    public static boolean setTotal(String classname, DataDirector dd, ErrorHandler eh, int edge, Total total, Total rowTotal, Total columnTotal) {
        if (edge != 1 && edge != 0) {
            eh.log("invalid edge", classname, m_method_setTotal);
            return false;
        }
        if (total == null) {
            eh.log("invalid total", classname, m_method_setTotal);
            return false;
        }
        int layer = total.getLayer();
        boolean insertHappened = false;
        boolean deleteHappened = false;
        Total currentTotal = edge == 1 ? rowTotal : columnTotal;
        try {
            switch (layer) {
                case -1: 
                case 0: {
                    dd.setManualUpdate();
                    if (currentTotal != null && currentTotal.getLayer() != layer && currentTotal.getLayer() != -2 && !(deleteHappened = dd.deleteMemberCalc(edge, currentTotal.getLayer(), -1))) {
                        eh.log("invalid operation", classname, m_method_setTotal);
                        return false;
                    }
                    insertHappened = dd.insertMemberCalc(edge, layer, -1, total.getType(), (Object)total.getLabel());
                    if (!insertHappened) {
                        eh.log("invalid operation", classname, m_method_setTotal);
                        return false;
                    }
                    dd.update();
                    break;
                }
                case -2: {
                    if (currentTotal == null || currentTotal.getLayer() == -2 || (deleteHappened = dd.deleteMemberCalc(edge, currentTotal.getLayer(), -1))) break;
                    eh.log("invalid operation", classname, m_method_setTotal);
                    return false;
                }
            }
            return true;
        }
        catch (EdgeOutOfRangeException ee) {
            eh.error((Throwable)ee, classname, m_method_setTotal);
        }
        catch (LayerOutOfRangeException le) {
            eh.error((Throwable)le, classname, m_method_setTotal);
        }
        catch (SliceOutOfRangeException se) {
            eh.error((Throwable)se, classname, m_method_setTotal);
        }
        catch (DataDirectorException de) {
            eh.error((Throwable)de, classname, m_method_setTotal);
        }
        return false;
    }

    @Override
    public Total getTotal(int edge) {
        return Crosstab.getTotal(this.getClass().getName(), this.getErrorHandler(), edge, this.m_rowTotal, this.m_columnTotal);
    }

    public static Total getTotal(String classname, ErrorHandler eh, int edge, Total rowTotal, Total columnTotal) {
        Total total = null;
        if (edge != 1 && edge != 0) {
            eh.log("invalid edge", classname, m_method_getTotal);
            return null;
        }
        total = edge == 1 ? (rowTotal == null ? new Total() : new Total(rowTotal.getLayer(), rowTotal.getType(), rowTotal.getLabel())) : (columnTotal == null ? new Total() : new Total(columnTotal.getLayer(), columnTotal.getType(), columnTotal.getLabel()));
        return total;
    }

    @Override
    public void setOutline(boolean b) {
        boolean old = this.isOutline();
        if (old != b) {
            this.crosstabModel.setOutline(b);
            this.freezeRepaints();
            this.getCrosstabRowHeader().setOutline(b);
            try {
                this.getDataDirector().setOutline(b);
            }
            catch (DataDirectorException e) {
                this.getErrorHandler().error((Throwable)e, this.getClass().getName(), "setOutline");
            }
            this.pivotTable.getCrosstabRowHeader().refreshPivotHandleStyle();
            this.pivotTable.getCrosstabColumnHeader().refreshPivotHandleStyle();
            this.unfreezeRepaints();
            this.firePropertyChange(this, "Outline", old, b);
        }
    }

    @Override
    public boolean isOutline() {
        return this.getCrosstabRowHeader() == null ? false : this.getCrosstabRowHeader().isOutline();
    }

    @Override
    public void setManualRowSizingEnabled(boolean bEnabled) {
        boolean oldVal = this.m_bManualRowSizingEnabled;
        this.m_bManualRowSizingEnabled = bEnabled;
        ((CrosstabDatabody)this.getDatabody()).getRowHeader().setCanResizeItems(bEnabled);
        this.firePropertyChange(this, "ManualRowSizingEnabled", oldVal, bEnabled);
    }

    @Override
    public void setManualColumnSizingEnabled(boolean bEnabled) {
        boolean oldVal = this.m_bManualColumnSizingEnabled;
        this.m_bManualColumnSizingEnabled = bEnabled;
        ((CrosstabDatabody)this.getDatabody()).getColumnHeader().setCanResizeItems(bEnabled);
        this.firePropertyChange(this, "ManualColumnSizingEnabled", oldVal, bEnabled);
    }

    @Override
    public void setManualRowHeaderColumnSizingEnabled(boolean bEnabled) {
        boolean oldVal = this.m_bManualRowHeaderColumnSizingEnabled;
        this.m_bManualRowHeaderColumnSizingEnabled = bEnabled;
        ((CrosstabPivotHeader)this.getRowHeader()).getColumnHeader().setCanResizeItems(bEnabled);
        this.firePropertyChange(this, "ManualRowHeaderColumnSizingEnabled", oldVal, bEnabled);
    }

    @Override
    public boolean isManualRowHeaderColumnSizingEnabled() {
        return this.m_bManualRowHeaderColumnSizingEnabled;
    }

    @Override
    public void setManualColumnHeaderRowSizingEnabled(boolean bEnabled) {
        boolean oldVal = this.m_bManualColumnHeaderRowSizingEnabled;
        this.m_bManualColumnHeaderRowSizingEnabled = bEnabled;
        ((CrosstabPivotHeader)this.getColumnHeader()).getRowHeader().setCanResizeItems(bEnabled);
        this.firePropertyChange(this, "ManualColumnHeaderRowSizingEnabled", oldVal, bEnabled);
    }

    @Override
    public boolean isManualColumnHeaderRowSizingEnabled() {
        return this.m_bManualColumnHeaderRowSizingEnabled;
    }

    @Override
    public void setCustomAnnotationCallback(CustomAnnotationCallback callback) {
        this.getCrosstabDatabody().getCrosstabData().clearAnnotationCache();
        super.setCustomAnnotationCallback(callback);
    }

    private int getRowHeaderWrapHeight(ViewStyle style, PaintContext pc, int currZoomf, String text, int rowHandle, FontMetrics fm, int enhFontHeight) {
        int height = 0;
        ImmInsets insets = null;
        int drillImageWidth = 0;
        int offset = 0;
        insets = style.getBorderPainter() != null ? style.getBorderPainter().getInsets(pc) : new ImmInsets(0, 0, 0, 0);
        ImmInsets appInsets = style.getInsets();
        offset = insets.left + insets.right + appInsets.left + appInsets.right;
        offset += 2;
        ++offset;
        offset += 3;
        offset = Math.round((float)offset * (100.0f / (float)currZoomf));
        int grippyWidth = PivotGrippyPainter.getPainter((boolean)false).getMinimumSize((PaintContext)pc).width;
        grippyWidth = Math.round((float)grippyWidth * (100.0f / (float)currZoomf));
        if (this.isPivotHandleDrillIconVisible(1)) {
            drillImageWidth = this.getCrosstabRowHeader().getBlankImage().getWidth(null);
        }
        int horzOffset = offset + drillImageWidth + grippyWidth;
        WrappedText wrappedText = new WrappedText(text, WordWrapper.getTextWrapper(), this.getCrosstabRowHeader().getColumnWidth(rowHandle) - horzOffset, fm, pc.getPaintLocale(), false);
        int numLines = wrappedText.getLineCount();
        height = numLines * (fm.getHeight() + enhFontHeight) - fm.getLeading();
        return height;
    }

    private int getColHeaderWrapHeight(ViewStyle style, int currZoomf, int hdrRow) {
        ImmInsets insets = null;
        int wrapHeight = 0;
        int availableWidth = 0;
        int offset = 0;
        int tmpWidth = 0;
        PaintContext pc = null;
        FontMetrics fm = null;
        String data = null;
        ImmInsets appInsets = style.getInsets();
        Header columnHeaderHandle = this.pivotTable.getCrosstabColumnHeader().getRowHeader();
        pc = columnHeaderHandle.getItemPaintContext(hdrRow);
        fm = pc.getFontMetrics(style.getFont());
        data = (String)((PivotHandleCell)((Object)columnHeaderHandle.getModel().getData(hdrRow))).getData();
        if (data != null) {
            tmpWidth += appInsets.right + fm.stringWidth(data) + appInsets.left + 2;
        }
        int drillImageWidth = 0;
        if (this.isPivotHandleDrillIconVisible(0)) {
            drillImageWidth = this.getCrosstabColumnHeader().getBlankImage().getWidth(null) + 2;
        }
        tmpWidth = this.m_highlighterSizeSet ? this.getHighlighterSize() : (tmpWidth += this.getHighlighterSize() + drillImageWidth);
        CrosstabPivotHeader colPivotHeader = this.pivotTable.getCrosstabColumnHeader();
        int enhFontHeight = DataviewUtils.adjustForEnhancedFont((int)0, (boolean)style.isUnderline(), (boolean)style.isDoubleUnderline());
        int grippyWidth = PivotGrippyPainter.getPainter((boolean)false).getMinimumSize((PaintContext)pc).width;
        grippyWidth = Math.round((float)grippyWidth * (100.0f / (float)currZoomf));
        insets = style.getBorderPainter() != null ? style.getBorderPainter().getInsets(pc) : new ImmInsets(0, 0, 0, 0);
        offset = insets.left + insets.right + appInsets.left + appInsets.right;
        offset += 2;
        ++offset;
        offset += 3;
        offset = Math.round((float)offset * (100.0f / (float)currZoomf));
        int horzOffset = offset + drillImageWidth + grippyWidth;
        availableWidth = this.m_highlighterSizeSet ? this.getHighlighterSize() - horzOffset : Math.max(tmpWidth, this.getHighlighterSize()) - horzOffset;
        WrappedText wrappedText = new WrappedText(data, WordWrapper.getTextWrapper(), availableWidth, fm, pc.getPaintLocale(), false);
        int numLines = wrappedText.getLineCount();
        wrapHeight = numLines * (fm.getHeight() + enhFontHeight) - fm.getLeading();
        int vOffset = insets.top + insets.bottom + appInsets.top + appInsets.bottom;
        vOffset += 2;
        wrapHeight += ++vOffset;
        int drillImageHeight = 0;
        if (this.isPivotHandleDrillIconVisible(0)) {
            drillImageHeight = this.getCrosstabColumnHeader().getBlankImage().getHeight(null) + 2;
        }
        wrapHeight = Math.max(drillImageHeight += appInsets.top + appInsets.bottom, wrapHeight);
        Painter p = colPivotHeader.getPivotHeaderUI().getDefaultHeaderItemPainter((JComponent)((Object)colPivotHeader), false);
        wrapHeight = Math.max(p.getMinimumSize(null).height, wrapHeight);
        return wrapHeight;
    }

    private void copyCrosstabPivotTable(CrosstabPivotTable to, CrosstabPivotTable from) {
        to.setColumnPivotHeaderVisible(from.isColumnPivotHeaderVisible());
        to.setEqualSizedColumns(from.getEqualSizedColumns());
        for (int column = 0; column < from.getGridModel().getColumnCount(); ++column) {
            to.setColumnWidth(column, from.getColumnWidth(column));
        }
        to.setRowPivotHeaderVisible(from.isRowPivotHeaderVisible());
        to.setEqualSizedRows(from.getEqualSizedRows());
        for (int row = 0; row < from.getGridModel().getRowCount(); ++row) {
            to.setRowHeight(row, from.getRowHeight(row));
        }
        this.copyPivotGrid(to.getCrosstabDatabody(), from.getCrosstabDatabody());
        this.copyPivotHeader(to.getCrosstabColumnHeader(), from.getCrosstabColumnHeader());
        this.copyPivotHeader(to.getCrosstabRowHeader(), from.getCrosstabRowHeader());
    }

    private void copyPivotHeader(CrosstabPivotHeader to, CrosstabPivotHeader from) {
        to.setKeepHeaderCellsVisible(from.getKeepHeaderCellsVisible());
        for (int column = 0; column < from.getModel().getColumnCount(); ++column) {
            to.setColumnWidth(column, from.getColumnWidth(column));
        }
        for (int row = 0; row < from.getModel().getRowCount(); ++row) {
            to.setRowHeight(row, from.getRowHeight(row));
        }
        DataviewViewStyleUtils.copyStyleProperties((Styleable)to, (Styleable)from);
    }

    private void copyPivotGrid(CrosstabDatabody to, CrosstabDatabody from) {
        super.copyGrid(to, from);
    }

    @Override
    protected void freezeRepaints() {
        super.freezeRepaints();
        if (this.getPivotTable() != null) {
            this.getPivotTable().freezePivotTableRepaints();
        }
    }

    @Override
    protected void unfreezeRepaints() {
        super.unfreezeRepaints();
        if (this.getPivotTable() != null) {
            this.getPivotTable().unfreezePivotTableRepaints();
        }
    }

    @Override
    public Object getComponentFromID(int ID) {
        Object comp = super.getComponentFromID(ID);
        if (comp != null) {
            return comp;
        }
        switch (ID) {
            case 21: {
                return this;
            }
            case 22: {
                return this.getCrosstabDatabody().getRowHeader();
            }
            case 23: {
                return this.getCrosstabDatabody().getColumnHeader();
            }
            case 24: {
                return this.getCrosstabRowHeader().getColumnHeader();
            }
            case 25: {
                return this.getCrosstabColumnHeader().getRowHeader();
            }
        }
        return null;
    }

    @Override
    protected String getNameFromID(int ID) {
        String name = super.getNameFromID(ID);
        if (name != null) {
            return name;
        }
        switch (ID) {
            case 21: {
                return CROSSTAB_NAME;
            }
            case 22: {
                return ROW_HIGHLIGHTER_NAME;
            }
            case 23: {
                return COL_HIGHLIGHTER_NAME;
            }
            case 24: {
                return ROW_GRABBER_NAME;
            }
            case 25: {
                return COL_GRABBER_NAME;
            }
            case 26: {
                return ROW_GRABBER_RANGE_NAME;
            }
            case 27: {
                return COL_GRABBER_RANGE_NAME;
            }
        }
        return null;
    }

    @Override
    protected void drillingEnabledToggled() {
        super.drillingEnabledToggled();
        this.updatePivotHandleSize();
    }

    protected int[] calcAutoFitColHeaderHeights(int startCol, int endCol) {
        ImmInsets emptyInsets;
        this.updateColPivotHandleSize();
        int currZoomf = this.zoomFactor;
        this.zoomFactor = 100;
        int minCellHeight = this.cellMinHeight;
        int maxCellHeight = this.cellMaxHeight;
        int colHeaderRows = this.getCrosstabColumnHeader().getModel().getRowCount();
        int enhFontHeight = 0;
        int offset = 0;
        int height = 0;
        Grid colGrid = this.getCrosstabColumnHeader().getGrid();
        Header pivotHandles = this.getCrosstabColumnHeader().getRowHeader();
        CrosstabPivotHeader colHeader = this.getCrosstabColumnHeader();
        TwoDModel cds = this.getCrosstabColumnHeader().getModel();
        ImmInsets insets = emptyInsets = new ImmInsets(0, 0, 0, 0);
        int horzOffset = 0;
        int[] heights = new int[colHeaderRows];
        for (int hdrRow = 0; hdrRow < colHeaderRows; ++hdrRow) {
            int oldRowHeight = 0;
            CrosstabHeaderCell cell = null;
            int columnIncrement = 1;
            for (int col = startCol; col <= endCol; col += columnIncrement) {
                int imageHt;
                cell = (CrosstabHeaderCell)cds.getData(col, hdrRow);
                columnIncrement = cell.getStartSlice() + cell.getExtent() - col;
                if (cell.getStartLayer() != hdrRow) continue;
                PaintContext context = colGrid.getCellPaintContext(col, hdrRow);
                ViewStyle colStyle = colHeader.getStyle(col, hdrRow);
                insets = colStyle.getBorderPainter() != null ? colStyle.getBorderPainter().getInsets(context) : emptyInsets;
                ImmInsets appInsets = colStyle.getInsets();
                enhFontHeight = DataviewUtils.adjustForEnhancedFont((int)0, (boolean)colStyle.isUnderline(), (boolean)colStyle.isDoubleUnderline());
                offset = insets.top + insets.bottom + appInsets.top + appInsets.bottom + enhFontHeight;
                ++offset;
                int drillImageWidth = 0;
                int drillImageHeight = 0;
                if (this.isDrillingEnabled() && !this.isPrintOrPreviewMode() && colHeader.isDrilledOrDrillable(col, hdrRow)) {
                    drillImageWidth = colHeader.getBlankImage().getWidth(null);
                    drillImageHeight = colHeader.getBlankImage().getHeight(null);
                }
                int graphicImageWidth = 0;
                Image img = colHeader.getGraphicImage(col, hdrRow, false);
                if (img != null && !this.isPrintOrPreviewMode()) {
                    graphicImageWidth = img.getWidth(context.getImageObserver());
                    ++graphicImageWidth;
                }
                horzOffset = insets.left + drillImageWidth + graphicImageWidth + insets.right + appInsets.left + appInsets.right;
                horzOffset += 2;
                ++horzOffset;
                if (colStyle.isWordWrapEnabled()) {
                    int cellWidth = 0;
                    int startSlice = cell.getStartSlice();
                    int extent = cell.getExtent();
                    int colsOnScreen = this.getCrosstabDatabody().getOnScreenColumnCount();
                    if (colsOnScreen > 0 && extent > colsOnScreen) {
                        extent = colsOnScreen;
                    }
                    for (int i = 0; i < extent; ++i) {
                        cellWidth += this.getColumnWidth(startSlice + i);
                    }
                    Font font = colStyle.getFont();
                    FontMetrics metrics = context.getFontMetrics(font);
                    String text = (String)((CrosstabHeaderCell)cds.getData(col, hdrRow)).getData();
                    WrappedText wrappedText = new WrappedText(text, WordWrapper.getTextWrapper(), cellWidth - horzOffset, metrics, context.getPaintLocale(), false);
                    int numLines = wrappedText.getLineCount();
                    height = numLines * metrics.getHeight() - metrics.getLeading();
                } else {
                    FontMetrics fm = context.getFontMetrics(colStyle.getFont());
                    height = fm.getHeight();
                }
                if (img != null && (imageHt = img.getHeight(context.getImageObserver())) > height) {
                    height = imageHt;
                }
                if (drillImageHeight > height) {
                    height = drillImageHeight;
                }
                PaintContext pivotHandlePaintContext = pivotHandles.getItemPaintContext(hdrRow);
                int grippyHeight = PivotGrippyPainter.getPainter((boolean)false).getMinimumSize((PaintContext)pivotHandlePaintContext).height;
                if (grippyHeight > height) {
                    height = grippyHeight;
                }
                if ((height += (offset = Math.round((float)offset * (100.0f / (float)currZoomf)))) <= oldRowHeight) continue;
                oldRowHeight = height;
            }
            if (oldRowHeight < minCellHeight) {
                oldRowHeight = minCellHeight;
            }
            if (oldRowHeight > maxCellHeight) {
                oldRowHeight = maxCellHeight;
            }
            int pivotHandleHeight = 0;
            ViewStyle style = this.pivotTable.getCrosstabColumnHeader().getPivotHandleViewStyle(hdrRow);
            if (style != null && this.isPivotLabelVisible() && style.isWordWrapEnabled()) {
                pivotHandleHeight = this.getColHeaderWrapHeight(style, currZoomf, hdrRow);
            }
            if (pivotHandleHeight > oldRowHeight) {
                oldRowHeight = pivotHandleHeight;
            }
            heights[hdrRow] = oldRowHeight;
        }
        this.zoomFactor = currZoomf;
        return heights;
    }

    protected int[] calcAutoFitInlineRowHeaderWidths(int startRow, int endRow) {
        int currZoomf = this.zoomFactor;
        this.zoomFactor = 100;
        CrosstabPivotHeader header = this.getCrosstabRowHeader();
        int minCellWidth = this.cellMinWidth;
        int maxCellWidth = this.cellMaxWidth;
        int depth = header.getModel().getColumnCount();
        ImmInsets emptyInsets = new ImmInsets(0, 0, 0, 0);
        int offset = 0;
        Grid g = header.getGrid();
        TwoDModel ds = header.getModel();
        int[] widths = new int[depth];
        for (int d = 0; d < depth; ++d) {
            ImmInsets appInsets;
            ImmInsets insets;
            FontMetrics fm;
            PaintContext pc;
            String data;
            int width = 0;
            boolean bPivotHandleDrillIconVisible = this.isPivotHandleDrillIconVisible(1);
            if (this.isPivotLabelVisible() || bPivotHandleDrillIconVisible) {
                Header rowHandles = this.getPivotTable().getRowPivotHeader().getColumnHeader();
                RowHeaderPivotHandleData hData = this.getCrosstabModel().getRowHeaderHandleDataSource();
                PivotHandleCell cell = (PivotHandleCell)((Object)hData.getData(d));
                data = this.isPivotLabelVisible() && cell != null && cell.getData() != null ? (String)cell.getData() : "";
                pc = rowHandles.getItemPaintContext(d);
                Appearance appearance = rowHandles.getItemAppearance(d);
                int newSize = (int)((float)appearance.getFont().getSize() * (100.0f / (float)currZoomf));
                Font f1 = this.getFontList().getFont(appearance.getFont().getName(), appearance.getFont().getStyle(), newSize);
                fm = pc.getFontMetrics(f1);
                insets = appearance.getBorderPainter() != null ? appearance.getBorderPainter().getInsets(pc) : emptyInsets;
                appInsets = appearance.getInsets();
                offset = insets.left + insets.right + appInsets.left + appInsets.right;
                offset += 2;
                ++offset;
                offset += 3;
                offset += 3;
                int grippyWidth = PivotGrippyPainter.getPainter((boolean)false).getMinimumSize((PaintContext)pc).width;
                grippyWidth = Math.round((float)grippyWidth * (100.0f / (float)currZoomf));
                offset = Math.round((float)offset * (100.0f / (float)currZoomf));
                int drillImageWidth = 0;
                if (bPivotHandleDrillIconVisible) {
                    drillImageWidth = header.getBlankImage().getWidth(null);
                }
                int tmpWidth = fm.stringWidth(data) + offset + grippyWidth + drillImageWidth;
                width = Math.max(tmpWidth, width);
            }
            CrosstabHeaderCell cell = null;
            int rowIncrement = 1;
            for (int row = startRow; row <= endRow; row += rowIncrement) {
                ViewStyle headerStyle;
                cell = (CrosstabHeaderCell)ds.getData(d, row);
                rowIncrement = cell.getStartSlice() + cell.getExtent() - row;
                if (cell.getStartLayer() != d) continue;
                pc = g.getCellPaintContext(d, row);
                fm = pc.getFontMetrics(header.getStyle(d, row).getFont());
                data = (String)((CrosstabHeaderCell)ds.getData(d, row)).getData();
                if (data == null) {
                    data = "";
                }
                insets = (headerStyle = header.getStyle(d, row)).getBorderPainter() != null ? headerStyle.getBorderPainter().getInsets(pc) : emptyInsets;
                appInsets = headerStyle.getInsets();
                offset = insets.left + insets.right + appInsets.left + appInsets.right;
                offset += 2;
                ++offset;
                int drillImageWidth = 0;
                if (this.isDrillingEnabled() && !this.isPrintOrPreviewMode() && header.isDrilledOrDrillable(d, row)) {
                    drillImageWidth = header.getBlankImage().getWidth(null);
                }
                int graphicImageWidth = 0;
                Image img = header.getGraphicImage(d, row, false);
                if (img != null && !this.isPrintOrPreviewMode()) {
                    graphicImageWidth = img.getWidth(pc.getImageObserver());
                    ++graphicImageWidth;
                }
                width = Math.max(fm.stringWidth(data) + drillImageWidth + graphicImageWidth + offset, width);
            }
            if (width < minCellWidth) {
                width = minCellWidth;
            }
            if (width > maxCellWidth) {
                width = maxCellWidth;
            }
            widths[d] = width;
        }
        this.zoomFactor = currZoomf;
        return widths;
    }

    protected int[] calcAutoFitOutlineRowHeaderWidths(int startRow, int endRow) {
        ImmInsets appInsets;
        ImmInsets insets;
        FontMetrics fm;
        PaintContext pc;
        int i;
        int currZoomf = this.zoomFactor;
        this.zoomFactor = 100;
        CrosstabPivotHeader header = this.getCrosstabRowHeader();
        int minCellWidth = this.cellMinWidth;
        int maxCellWidth = this.cellMaxWidth;
        int depth = header.getModel().getColumnCount();
        String data = null;
        ImmInsets emptyInsets = new ImmInsets(0, 0, 0, 0);
        int offset = 0;
        Grid g = header.getGrid();
        TwoDModel ds = header.getModel();
        CrosstabHeaderCell cell = null;
        int[] widths = new int[depth];
        int indent = this.getAutoIndent();
        StringBuffer indentation = new StringBuffer();
        for (i = 0; i < indent; ++i) {
            indentation.append(RowHeaderCell.INDENT_UNIT);
        }
        for (i = 0; i < depth; ++i) {
            widths[i] = 0;
            Header rowHandles = this.getPivotTable().getRowPivotHeader().getColumnHeader();
            pc = rowHandles.getItemPaintContext(i);
            Appearance appearance = rowHandles.getItemAppearance(i);
            int newSize = (int)((float)appearance.getFont().getSize() * (100.0f / (float)currZoomf));
            Font f1 = this.getFontList().getFont(appearance.getFont().getName(), appearance.getFont().getStyle(), newSize);
            fm = pc.getFontMetrics(f1);
            insets = appearance.getBorderPainter() != null ? appearance.getBorderPainter().getInsets(pc) : emptyInsets;
            appInsets = appearance.getInsets();
            offset = insets.left + insets.right + appInsets.left + appInsets.right;
            offset += 2;
            ++offset;
            offset += 3;
            boolean bPivotHandleDrillIconVisible = this.isPivotHandleDrillIconVisible(1);
            if (this.isPivotLabelVisible() || bPivotHandleDrillIconVisible) {
                offset += 3;
                RowHeaderPivotHandleData hData = this.getCrosstabModel().getRowHeaderHandleDataSource();
                PivotHandleCell label = (PivotHandleCell)((Object)hData.getData(i));
                data = this.isPivotLabelVisible() && label != null && label.getData() != null ? (String)label.getData() : "";
                int drillImageWidth = 0;
                if (bPivotHandleDrillIconVisible) {
                    drillImageWidth = header.getBlankImage().getWidth(null);
                }
                int grippyWidth = PivotGrippyPainter.getPainter((boolean)false).getMinimumSize((PaintContext)pc).width;
                grippyWidth = Math.round((float)grippyWidth * (100.0f / (float)currZoomf));
                offset = Math.round((float)offset * (100.0f / (float)currZoomf));
                widths[i] = fm.stringWidth(data) + offset + drillImageWidth + grippyWidth;
            } else {
                widths[i] = offset + PivotGrippyPainter.getPainter((boolean)true).getMinimumSize((PaintContext)pc).width;
            }
            cell = (CrosstabHeaderCell)ds.getData(i, startRow);
            pc = g.getCellPaintContext(i, startRow);
            ViewStyle headerStyle = header.getStyle(i, startRow);
            insets = headerStyle.getBorderPainter() != null ? headerStyle.getBorderPainter().getInsets(pc) : emptyInsets;
            appInsets = headerStyle.getInsets();
            offset = insets.left + insets.right + appInsets.left + appInsets.right;
            offset += 2;
            fm = pc.getFontMetrics(header.getStyle(i, startRow).getFont());
            widths[i] = Math.max(fm.stringWidth(indentation.toString()) + ++offset, widths[i]);
            int minGrippyWidth = PivotGrippyPainter.getPainter((boolean)false).getMinimumSize((PaintContext)pc).width;
            minGrippyWidth = Math.round((float)minGrippyWidth * (100.0f / (float)currZoomf));
            if (widths[i] >= minGrippyWidth || this.printOrPreviewMode) continue;
            widths[i] = minGrippyWidth;
        }
        int totalWidth = 0;
        int width = 0;
        int d = depth - 1;
        for (int row = startRow; row <= endRow; ++row) {
            cell = (CrosstabHeaderCell)ds.getData(d, row);
            pc = g.getCellPaintContext(d, row);
            ViewStyle headerStyle = header.getStyle(d, row);
            insets = headerStyle.getBorderPainter() != null ? headerStyle.getBorderPainter().getInsets(pc) : emptyInsets;
            appInsets = headerStyle.getInsets();
            offset = insets.left + insets.right + appInsets.left + appInsets.right;
            offset += 2;
            ++offset;
            int drillImageWidth = 0;
            if (this.isDrillingEnabled() && !this.isPrintOrPreviewMode() && header.isDrilledOrDrillable(d, row)) {
                drillImageWidth = header.getBlankImage().getWidth(null);
            }
            int graphicImageWidth = 0;
            Image img = header.getGraphicImage(d, row, false);
            if (img != null && !this.isPrintOrPreviewMode()) {
                graphicImageWidth = img.getWidth(pc.getImageObserver());
                ++graphicImageWidth;
            }
            fm = pc.getFontMetrics(header.getStyle(d, row).getFont());
            data = (String)cell.getData();
            if (data == null) {
                data = "";
            }
            indent = 0;
            for (int i2 = 0; i2 < cell.getIndent(); ++i2) {
                indent += widths[i2];
            }
            width = fm.stringWidth(data) + drillImageWidth + graphicImageWidth + offset + indent;
            totalWidth = Math.max(width, totalWidth);
        }
        int outerLayersWidth = 0;
        for (int i3 = 0; i3 < d; ++i3) {
            outerLayersWidth += widths[i3];
        }
        widths[d] = Math.max(totalWidth - outerLayersWidth, widths[d]);
        for (int layer = 0; layer < depth; ++layer) {
            width = widths[layer];
            if (width < minCellWidth) {
                width = minCellWidth;
            }
            if (width > maxCellWidth) {
                width = maxCellWidth;
            }
            widths[layer] = width;
        }
        this.zoomFactor = currZoomf;
        return widths;
    }

    @Override
    protected void updateRowHeaderWidths() {
        if (!this.pivotTable.isRowPivotHeaderVisible() || (this.getAutoFitScope() & 8) < 1 || this.xmlMode) {
            return;
        }
        Range range = this.getAutoFitRowRange();
        int endRow = range.end;
        int startRow = range.begin;
        if (endRow < startRow) {
            this.getErrorHandler().log("invalid row range", this.getClass().getName(), m_method_updateRowHeaderWidths);
            return;
        }
        int[] widths = this.isOutline() ? this.calcAutoFitOutlineRowHeaderWidths(startRow, endRow) : this.calcAutoFitInlineRowHeaderWidths(startRow, endRow);
        if (this.getAutoFitRowRangeCallback() != null) {
            this.getAutoFitRowRangeCallback().endAutoFit();
        }
        if (widths == null) {
            return;
        }
        for (int col = 0; col < widths.length; ++col) {
            this.getCrosstabSizingManager().setCalculatedRowHeaderColumnWidth(col, widths[col]);
        }
        this.sizeRowHeaderColumnWidths();
    }

    public boolean isTotalSlice(int edge, int slice) {
        DataAccess da;
        if (this.isMetadataIsTotalSupported() && (edge == 0 || edge == 1) && (da = this.getModel().getDataAccess()) != null) {
            int layerCount = 0;
            CrosstabPivotHeader header = null;
            if (edge == 0) {
                header = this.getCrosstabColumnHeader();
                layerCount = header.getModel().getRowCount();
            } else if (edge == 1) {
                header = this.getCrosstabRowHeader();
                layerCount = header.getModel().getColumnCount();
            }
            if (layerCount > 0) {
                int layer = 0;
                while (layer < layerCount) {
                    try {
                        boolean b;
                        Object totalObj = da.getMemberMetadata(edge, layer, slice, "isTotal");
                        if (totalObj != null && totalObj instanceof Boolean && (b = ((Boolean)totalObj).booleanValue())) {
                            return true;
                        }
                    }
                    catch (DataException de) {
                        this.getErrorHandler().log("problem getting ISTOTAL metadata", this.getClass().getName(), "isTotalSlice");
                        return false;
                    }
                    int column = layer;
                    int row = layer;
                    if (edge == 0) {
                        column = slice;
                    } else if (edge == 1) {
                        row = slice;
                    }
                    Object obj = header.getModel().getData(column, row);
                    if (obj instanceof CrosstabHeaderCell) {
                        CrosstabHeaderCell cell = (CrosstabHeaderCell)obj;
                        layer += cell.getDepth();
                        continue;
                    }
                    ++layer;
                }
            }
        }
        return false;
    }

    @Override
    protected void firePropertyChange(Object obj, String propName, Object oldValue, Object newValue) {
        super.firePropertyChange(obj, propName, oldValue, newValue);
    }

    protected void firePrintBegin(Object source) {
        super.firePrintBegin(source);
    }

    protected void firePrintEnd(Object source) {
        super.firePrintEnd(source);
    }

    protected ObjectNode getObjectNode(boolean allProperties) {
        return this._crosstabXML.getObjectNode(allProperties);
    }

    protected void setXML(ObjectNode node, int reset) {
        this.xmlMode = true;
        this._crosstabXML.setXML(node, reset);
        this.xmlMode = false;
        if (this.isAnythingAutoFit()) {
            this.autoFit();
        } else {
            this.doSizing();
        }
        this.updateColumnHeaderRowHeights();
        this.updateRowHeights();
        this.updatePivotHandleSize();
    }

    @Override
    protected void setContext() {
        this._crosstabXML.setContext(this.m_context);
        super.setContext();
        ((CrosstabRuleSizing)this.getCrosstabSizingManager()).setContext(this.m_context);
    }

    protected DataviewXML getViewXML() {
        return this._crosstabXML;
    }

    public boolean setXMLAsString(String xml) throws BIPersistenceException {
        try {
            this.setLoadingViewFromPersistence(true);
            this.m_tmpStartColumn = -1;
            this.m_tmpStartRow = -1;
            return this.setXML(xml, 0);
        }
        catch (Exception e) {
            this.setLoadingViewFromPersistence(false);
            throw new BIPersistenceException(e.getMessage(), e);
        }
    }

    public PersistableAttributes getPersistableAttributes(PersistableAttributes oldAttrs) {
        PersistableAttributes result = null;
        result = this.m_attrs == null ? new PersistableAttributes() : (PersistableAttributes)this.m_attrs.clone();
        if (oldAttrs != null) {
            result.merge(oldAttrs);
        }
        result.setObjectType(CROSSTAB_NAME);
        result.setTitle(((Title)this.getDataviewTitle()).getText());
        result.setObjectTypeVersion(1);
        return result;
    }

    public void setPersistableComponents(AggregateInfo[] persistables) {
        super.setPersistableComponents(persistables);
        if (this.m_tmpRowTotal != null) {
            Crosstab.setTotal(this.getClass().getName(), this.getDataDirector(), this.getErrorHandler(), 1, this.m_tmpRowTotal, this.m_rowTotal, this.m_columnTotal);
        }
        if (this.m_tmpColumnTotal != null) {
            Crosstab.setTotal(this.getClass().getName(), this.getDataDirector(), this.getErrorHandler(), 0, this.m_tmpColumnTotal, this.m_rowTotal, this.m_columnTotal);
        }
        this.m_tmpRowTotal = null;
        this.m_tmpColumnTotal = null;
    }

    public void modelWaitDataAvailable(WaitDataAvailableEvent e) {
        WaitData[] waitDataForRows = this.getWaitData();
        if (waitDataForRows != null) {
            for (int i = 0; i < waitDataForRows.length; ++i) {
                if (waitDataForRows[i] == null) continue;
                this.getPivotTable().m_calculatedRowHeights[i] = -1;
                this.getPivotTable().m_sizedRowFlags[i] = false;
            }
        }
        super.modelWaitDataAvailable(e);
    }

    public int getViewType() {
        return 0;
    }

    public String getVersion() {
        return "3.2.0.21";
    }

    public boolean setXML(String xmlString, boolean reset) throws BIIOException, BISAXException, BIParseException {
        int resetFlag = 0;
        if (reset) {
            resetFlag = 2;
        }
        return this.setXML(xmlString, resetFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setXML(String xmlString, int reset) throws BIIOException, BISAXException, BIParseException {
        XMLObjectReader reader = null;
        try {
            reader = new XMLObjectReader(xmlString);
            if (this.isXMLValidated()) {
                reader.setValidationMode(true);
                try {
                    reader.setDTD("/oracle/dss/crosstab/Crosstab.dtd", CROSSTAB_NAME);
                }
                catch (BIParseException bipe) {
                    System.out.println("Syntax error in DTD in line number " + bipe.getLineNumber());
                }
            }
            ObjectNode node = reader.readObjectNode();
            int newReset = reset;
            if (newReset < 0 || newReset > 5) {
                this.getErrorHandler().log("invalid reset argument", this.getClass().getName(), "setXML(String xmlString, int reset)");
                newReset = 0;
            }
            if (newReset != 0) {
                this.resetToDefault(newReset);
            }
            this.setXML(node, newReset);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                    reader = null;
                }
                catch (IOException ioException) {
                    this.getErrorHandler().log("Applying XML to this Crosstab failed.", this.getClass().getName(), "setXML(String xmlString, int reset)");
                }
            }
        }
        return true;
    }

    public boolean readXML(InputStream stream, boolean reset) throws BIIOException, BISAXException, BIParseException {
        int resetFlag = 0;
        if (reset) {
            resetFlag = 2;
        }
        return this.readXML(stream, resetFlag);
    }

    public boolean readXML(InputStream stream, int reset) throws BIIOException, BISAXException, BIParseException {
        XMLObjectReader reader = new XMLObjectReader(stream);
        if (this.isXMLValidated()) {
            reader.setValidationMode(true);
            try {
                reader.setDTD("/oracle/dss/crosstab/Crosstab.dtd", CROSSTAB_NAME);
            }
            catch (BIParseException bipe) {
                System.out.println("Syntax error in DTD in line number " + bipe.getLineNumber());
            }
        }
        ObjectNode node = reader.readObjectNode();
        int newReset = reset;
        if (newReset < 0 || newReset > 5) {
            this.getErrorHandler().log("invalid reset argument", this.getClass().getName(), "readXML(InputStream stream, int reset)");
            newReset = 0;
        }
        if (newReset != 0) {
            this.resetToDefault(newReset);
        }
        this.setXML(node, newReset);
        return true;
    }

    @Override
    public void resetToDefault(int reset, String version) {
        if (reset < 0 || reset > 5) {
            this.getErrorHandler().log("invalid reset argument", this.getClass().getName(), "resetToDefault(int reset)");
            return;
        }
        if (reset == 0) {
            this.getErrorHandler().log("attempt to reset to default with argument of RESET_NONE", this.getClass().getName(), "resetToDefault(int reset)");
            return;
        }
        this.xmlMode = true;
        this._crosstabXML.resetCrosstabXML(reset);
        super.resetToDefault(reset, version);
        if (reset == 4 || reset == 2) {
            this.setCrosstabModel(new CrosstabModelAdapter(this));
            this.removeErrorHandler();
            this.setDataSource((DataSource)new LocalDataSource());
            this.setCrosstabController(new CrosstabControllerAdapter(this));
        } else if (reset == 3 || reset == 1) {
            this.getCrosstabController().setSelectedObject(null, false);
        }
        this.m_bResizeForDrillImages = false;
        this.setDrillImage(2, this.getCrosstabColumnHeader().getDrilledImage());
        this.setDrillImage(1, this.getCrosstabColumnHeader().getDrillImage());
        this.m_bResizeForDrillImages = true;
        this.getCrosstabDatabody().resetToDefault(reset);
        this.getCrosstabRowHeader().resetToDefault(reset);
        this.getCrosstabColumnHeader().resetToDefault(reset);
        this.pivotTable.getCrosstabColumnHeader().refreshPivotHandleStyle();
        this.pivotTable.getCrosstabRowHeader().refreshPivotHandleStyle();
        this.xmlMode = false;
        if (this.isAnythingAutoFit()) {
            this.autoFit();
        } else {
            this.doSizing();
        }
        this.updatePivotHandleSize();
    }

    public ViewFormat getComponentViewFormat(ComponentHandle componentHandle) {
        return Crosstab._getComponentViewFormat(this, this.getGridViewFormatManager(), componentHandle);
    }

    public static ViewFormat _getComponentViewFormat(GridViewCommon gridView, GridViewFormatManager ruleFormatter, ComponentHandle componentHandle) {
        if (componentHandle == null) {
            return null;
        }
        ViewFormat viewFormat = null;
        if (componentHandle instanceof DataComponentHandle) {
            int row = ((DataComponentHandle)componentHandle).getRow();
            int column = ((DataComponentHandle)componentHandle).getColumn();
            viewFormat = ruleFormatter.getDataCellViewFormat(gridView, row, column);
        } else if (componentHandle instanceof DataRangeComponentHandle) {
            DataComponentInfo[] ci = ((DataRangeComponentHandle)componentHandle).getLocationList();
            int row = ci[0].getRow();
            int column = ci[0].getColumn();
            viewFormat = ruleFormatter.getDataCellViewFormat(gridView, row, column);
        } else if (componentHandle instanceof RowComponentHandle) {
            if (((RowComponentHandle)componentHandle).getID() != 25) {
                int row = ((RowComponentHandle)componentHandle).getRow();
                viewFormat = ruleFormatter.getDataCellViewFormat(gridView, row, 0);
            }
        } else if (componentHandle instanceof RowRangeComponentHandle) {
            RowComponentInfo[] ci = ((RowRangeComponentHandle)componentHandle).getLocationList();
            int row = ci[0].getRow();
            viewFormat = ruleFormatter.getDataCellViewFormat(gridView, row, 0);
        } else if (componentHandle instanceof ColumnComponentHandle) {
            if (((ColumnComponentHandle)componentHandle).getID() != 24) {
                int column = ((ColumnComponentHandle)componentHandle).getColumn();
                viewFormat = ruleFormatter.getDataCellViewFormat(gridView, 0, column);
            }
        } else if (componentHandle instanceof ColumnRangeComponentHandle) {
            ColumnComponentInfo[] ci = ((ColumnRangeComponentHandle)componentHandle).getLocationList();
            int column = ci[0].getColumn();
            viewFormat = ruleFormatter.getDataCellViewFormat(gridView, 0, column);
        } else if (componentHandle.getID() == 13) {
            viewFormat = ruleFormatter.getDataCellViewFormat(gridView, 0, 0);
        }
        return viewFormat;
    }

    public ViewStyle getComponentViewStyle(ComponentHandle componentHandle) {
        if (componentHandle == null) {
            return null;
        }
        ViewStyle viewStyle = null;
        try {
            GridViewDatabodyStyleManager databodyRuleStyles = this.getGridViewDatabodyStyleManager();
            GridViewHeaderStyleManager headerRuleStyles = this.getGridViewHeaderStyleManager();
            if (componentHandle instanceof EdgeComponentHandle) {
                int edge = ((EdgeComponentHandle)componentHandle).getEdge();
                int depth = ((EdgeComponentHandle)componentHandle).getDepth();
                int index = ((EdgeComponentHandle)componentHandle).getIndex();
                ViewStyle _style = null;
                if (edge == 0) {
                    _style = this.getCrosstabColumnHeader().getViewStyle();
                } else if (edge == 1) {
                    _style = this.getCrosstabRowHeader().getViewStyle();
                } else if (edge == 2) {
                    _style = this.getCrosstabDatabody().getViewStyle();
                }
                viewStyle = headerRuleStyles.getMetadataStyle(this, new String(""), _style, edge, depth, index);
            } else if (componentHandle instanceof EdgeRangeComponentHandle) {
                EdgeComponentInfo[] ci = ((EdgeRangeComponentHandle)componentHandle).getLocationList();
                if (ci.length > 0) {
                    int edge = ci[0].getEdge();
                    int depth = ci[0].getDepth();
                    int index = ci[0].getIndex();
                    ViewStyle _style = null;
                    if (edge == 0) {
                        _style = this.getCrosstabColumnHeader().getViewStyle();
                    } else if (edge == 1) {
                        _style = this.getCrosstabRowHeader().getViewStyle();
                    }
                    viewStyle = headerRuleStyles.getMetadataStyle(this, new String(""), _style, edge, depth, index);
                }
            } else if (componentHandle instanceof DataComponentHandle) {
                int row = ((DataComponentHandle)componentHandle).getRow();
                int column = ((DataComponentHandle)componentHandle).getColumn();
                viewStyle = databodyRuleStyles.getDataStyle(this, this.getDatabody().getGridViewData().getRawData(column, row), this.getCrosstabDatabody().getViewStyle(), row, column, this.getCrosstabModel().getDataAccess().getEdgeCurrentHPos(2));
            } else if (componentHandle instanceof DataRangeComponentHandle) {
                DataComponentInfo[] ci = ((DataRangeComponentHandle)componentHandle).getLocationList();
                int row = ci[0].getRow();
                int column = ci[0].getColumn();
                viewStyle = databodyRuleStyles.getDataStyle(this, this.getDatabody().getGridViewData().getRawData(column, row), this.getCrosstabDatabody().getViewStyle(), row, column, this.getCrosstabModel().getDataAccess().getEdgeCurrentHPos(2));
            } else if (componentHandle instanceof RowComponentHandle) {
                if (((RowComponentHandle)componentHandle).getID() != 25) {
                    int row = ((RowComponentHandle)componentHandle).getRow();
                    viewStyle = databodyRuleStyles.getDataStyle(this, this.getDatabody().getGridViewData().getRawData(0, row), this.getCrosstabDatabody().getViewStyle(), row, 0, this.getCrosstabModel().getDataAccess().getEdgeCurrentHPos(2));
                } else {
                    viewStyle = headerRuleStyles.getMetadataStyle(this, null, this.getCrosstabColumnHeader().getViewStyle(), 0, ((RowComponentHandle)componentHandle).getRow(), 0);
                }
            } else if (componentHandle instanceof RowRangeComponentHandle) {
                RowComponentInfo[] ci = ((RowRangeComponentHandle)componentHandle).getLocationList();
                int row = ci[0].getRow();
                viewStyle = ((RowRangeComponentHandle)componentHandle).getID() != 27 ? databodyRuleStyles.getDataStyle(this, this.getDatabody().getGridViewData().getRawData(0, row), this.getCrosstabDatabody().getViewStyle(), row, 0, this.getCrosstabModel().getDataAccess().getEdgeCurrentHPos(2)) : headerRuleStyles.getMetadataStyle(this, null, this.getCrosstabColumnHeader().getViewStyle(), 0, row, 0);
            } else if (componentHandle instanceof ColumnComponentHandle) {
                if (((ColumnComponentHandle)componentHandle).getID() != 24) {
                    int column = ((ColumnComponentHandle)componentHandle).getColumn();
                    viewStyle = databodyRuleStyles.getDataStyle(this, this.getDatabody().getGridViewData().getRawData(column, 0), this.getCrosstabDatabody().getViewStyle(), 0, column, this.getCrosstabModel().getDataAccess().getEdgeCurrentHPos(2));
                } else {
                    viewStyle = headerRuleStyles.getMetadataStyle(this, null, this.getCrosstabRowHeader().getViewStyle(), 1, ((ColumnComponentHandle)componentHandle).getColumn(), 0);
                }
            } else if (componentHandle instanceof ColumnRangeComponentHandle) {
                ColumnComponentInfo[] ci = ((ColumnRangeComponentHandle)componentHandle).getLocationList();
                int column = ci[0].getColumn();
                viewStyle = ((ColumnRangeComponentHandle)componentHandle).getID() != 26 ? databodyRuleStyles.getDataStyle(this, this.getDatabody().getGridViewData().getRawData(column, 0), this.getCrosstabDatabody().getViewStyle(), 0, column, this.getCrosstabModel().getDataAccess().getEdgeCurrentHPos(2)) : headerRuleStyles.getMetadataStyle(this, null, this.getCrosstabRowHeader().getViewStyle(), 1, column, 0);
            } else if (componentHandle instanceof PageItemComponentHandle) {
                viewStyle = headerRuleStyles.getMetadataStyle(this, null, new ViewStyle((DataviewCommon)this, this.getPagingControl().getViewStyle()), 2, ((PageItemComponentHandle)componentHandle).getPageItem(), 0);
            } else if (componentHandle.getID() == 13) {
                viewStyle = databodyRuleStyles.getDataStyle(this, this.getDatabody().getGridViewData().getRawData(0, 0), this.getCrosstabDatabody().getViewStyle(), 0, 0, this.getCrosstabModel().getDataAccess().getEdgeCurrentHPos(2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return viewStyle;
    }

    public boolean compareComponentViewStyle(ComponentHandle componentHandle, ViewStyle viewStyle) {
        int endRow;
        int startRow;
        int endCol;
        if (componentHandle == null) {
            return false;
        }
        int startCol = this.getPivotTable().getFirstColumnOnScreen();
        if (startCol < 0) {
            startCol = 0;
        }
        if ((endCol = this.getCrosstabDatabody().getOnScreenColumnCount() + startCol) < startCol) {
            endCol = startCol;
        }
        if ((startRow = this.getPivotTable().getFirstRowOnScreen()) < 0) {
            startRow = 0;
        }
        if ((endRow = this.getCrosstabDatabody().getOnScreenRowCount() + startRow) < startRow) {
            endRow = startRow;
        }
        if (componentHandle instanceof DataRangeComponentHandle) {
            DataComponentInfo[] ci = ((DataRangeComponentHandle)componentHandle).getLocationList();
            for (int i = 0; i < ci.length; ++i) {
                DataComponentHandle dd = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), ci[i]);
                ViewStyle style = this.getComponentViewStyle((ComponentHandle)dd);
                if (style.contains(viewStyle)) continue;
                return false;
            }
        } else if (componentHandle instanceof RowComponentHandle) {
            int row = ((RowComponentHandle)componentHandle).getRow();
            for (int i = startCol; i < endCol; ++i) {
                DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), row, i);
                ViewStyle style = this.getComponentViewStyle((ComponentHandle)d);
                if (style.contains(viewStyle)) continue;
                return false;
            }
        } else if (componentHandle instanceof RowRangeComponentHandle) {
            RowComponentInfo[] ci = ((RowRangeComponentHandle)componentHandle).getLocationList();
            for (int j = 0; j < ci.length; ++j) {
                for (int i = startCol; i < endCol; ++i) {
                    DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), ci[j].getRow(), i);
                    ViewStyle style = this.getComponentViewStyle((ComponentHandle)d);
                    if (style.contains(viewStyle)) continue;
                    return false;
                }
            }
        } else if (componentHandle instanceof ColumnComponentHandle) {
            int column = ((ColumnComponentHandle)componentHandle).getColumn();
            for (int i = startRow; i < endRow; ++i) {
                DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), i, column);
                ViewStyle style = this.getComponentViewStyle((ComponentHandle)d);
                if (style.contains(viewStyle)) continue;
                return false;
            }
        } else if (componentHandle instanceof ColumnRangeComponentHandle) {
            ColumnComponentInfo[] ci = ((ColumnRangeComponentHandle)componentHandle).getLocationList();
            for (int j = 0; j < ci.length; ++j) {
                for (int i = startRow; i < endRow; ++i) {
                    DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), i, ci[j].getColumn());
                    ViewStyle style = this.getComponentViewStyle((ComponentHandle)d);
                    if (style.contains(viewStyle)) continue;
                    return false;
                }
            }
        } else if (componentHandle.getID() == 13) {
            for (int j = startCol; j < endCol; ++j) {
                for (int i = startRow; i < endRow; ++i) {
                    DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), i, j);
                    ViewStyle style = this.getComponentViewStyle((ComponentHandle)d);
                    if (style.contains(viewStyle)) continue;
                    return false;
                }
            }
        } else {
            ViewStyle style = this.getComponentViewStyle(componentHandle);
            if (!style.contains(viewStyle)) {
                return false;
            }
        }
        return true;
    }

    public boolean compareComponentViewFormat(ComponentHandle componentHandle, ViewFormat viewFormat) {
        int endRow;
        int startRow;
        int endCol;
        if (componentHandle == null) {
            return false;
        }
        int startCol = this.getPivotTable().getFirstColumnOnScreen();
        if (startCol < 0) {
            startCol = 0;
        }
        if ((endCol = this.getCrosstabDatabody().getOnScreenColumnCount() + startCol) < startCol) {
            endCol = startCol;
        }
        if ((startRow = this.getPivotTable().getFirstRowOnScreen()) < 0) {
            startRow = 0;
        }
        if ((endRow = this.getCrosstabDatabody().getOnScreenRowCount() + startRow) < startRow) {
            endRow = startRow;
        }
        if (componentHandle instanceof DataRangeComponentHandle) {
            DataComponentInfo[] ci = ((DataRangeComponentHandle)componentHandle).getLocationList();
            for (int i = 0; i < ci.length; ++i) {
                DataComponentHandle dd = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), ci[i]);
                ViewFormat format = this.getComponentViewFormat((ComponentHandle)dd);
                if (format.contains(viewFormat)) continue;
                return false;
            }
        } else if (componentHandle instanceof RowComponentHandle) {
            int row = ((RowComponentHandle)componentHandle).getRow();
            for (int i = startCol; i < endCol; ++i) {
                DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), row, i);
                ViewFormat format = this.getComponentViewFormat((ComponentHandle)d);
                if (format.contains(viewFormat)) continue;
                return false;
            }
        } else if (componentHandle instanceof RowRangeComponentHandle) {
            RowComponentInfo[] ci = ((RowRangeComponentHandle)componentHandle).getLocationList();
            for (int j = 0; j < ci.length; ++j) {
                for (int i = startCol; i < endCol; ++i) {
                    DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), ci[j].getRow(), i);
                    ViewFormat format = this.getComponentViewFormat((ComponentHandle)d);
                    if (format.contains(viewFormat)) continue;
                    return false;
                }
            }
        } else if (componentHandle instanceof ColumnComponentHandle) {
            int column = ((ColumnComponentHandle)componentHandle).getColumn();
            for (int i = startRow; i < endRow; ++i) {
                DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), i, column);
                ViewFormat format = this.getComponentViewFormat((ComponentHandle)d);
                if (format.contains(viewFormat)) continue;
                return false;
            }
        } else if (componentHandle instanceof ColumnRangeComponentHandle) {
            ColumnComponentInfo[] ci = ((ColumnRangeComponentHandle)componentHandle).getLocationList();
            for (int j = 0; j < ci.length; ++j) {
                for (int i = startRow; i < endRow; ++i) {
                    DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), i, ci[j].getColumn());
                    ViewFormat format = this.getComponentViewFormat((ComponentHandle)d);
                    if (format.contains(viewFormat)) continue;
                    return false;
                }
            }
        } else if (componentHandle.getID() == 13) {
            for (int j = startCol; j < endCol; ++j) {
                for (int i = startRow; i < endRow; ++i) {
                    DataComponentHandle d = new DataComponentHandle(12, "DataCell", componentHandle.getComponent(), i, j);
                    ViewFormat format = this.getComponentViewFormat((ComponentHandle)d);
                    if (format.contains(viewFormat)) continue;
                    return false;
                }
            }
        } else {
            ViewFormat format = this.getComponentViewFormat(componentHandle);
            if (!format.contains(viewFormat)) {
                return false;
            }
        }
        return true;
    }

    public void applyViewFormat(ComponentHandle componentHandle, ViewFormat viewFormat) {
        if (viewFormat != null) {
            if (this.getUIFormats() == null) {
                this.setUIFormats(new Vector());
            }
            Crosstab._applyFormatting(this, (UIBundle)this.getGridViewFormatManager(), componentHandle, (Mergeable)viewFormat, this.getUIFormats());
            this.firePropertyChange(this, "ToolbarFormat", null, (UIFormat)this.getUIFormats().lastElement());
        }
    }

    public void applyViewStyle(ComponentHandle componentHandle, ViewStyle viewStyle) {
        if (viewStyle != null) {
            if (this.getUIFormats() == null) {
                this.setUIFormats(new Vector());
            }
            if (componentHandle instanceof EdgeComponentHandle || componentHandle instanceof EdgeRangeComponentHandle || componentHandle instanceof PageItemComponentHandle || componentHandle instanceof ColumnComponentHandle && ((ColumnComponentHandle)componentHandle).getID() == 24 || componentHandle instanceof ColumnRangeComponentHandle && ((ColumnRangeComponentHandle)componentHandle).getID() == 26 || componentHandle instanceof RowComponentHandle && ((RowComponentHandle)componentHandle).getID() == 25 || componentHandle instanceof RowRangeComponentHandle && ((RowRangeComponentHandle)componentHandle).getID() == 27) {
                Crosstab._applyFormatting(this, this.getGridViewHeaderStyleManager(), componentHandle, (Mergeable)viewStyle, this.getUIFormats());
            } else {
                Crosstab._applyFormatting(this, this.getGridViewDatabodyStyleManager(), componentHandle, (Mergeable)viewStyle, this.getUIFormats());
            }
            this.firePropertyChange(this, "ToolbarFormat", null, (UIFormat)this.getUIFormats().lastElement());
        }
    }

    protected void applyFormatting(UIBundle manager, ComponentHandle componentHandle, Mergeable mergeable) {
        Crosstab._applyFormatting(this, manager, componentHandle, mergeable, this.getUIFormats());
    }

    protected static void _applyFormatting(GridViewCommon gridView, UIBundle manager, ComponentHandle componentHandle, Mergeable mergeable, Vector formats) {
        CrosstabFormatUtil util = new CrosstabFormatUtil(gridView, componentHandle);
        GridViewFormatUtils.applyFormat(gridView, manager, util.getDiscriminator(), mergeable);
    }

    public static void _applyFormatting(GridViewCommon gridView, UIBundle manager, ComponentHandle componentHandle, Mergeable mergeable) {
        Crosstab._applyFormatting(gridView, manager, componentHandle, mergeable, null);
    }

    public static Rule _createQDRRule(QDR qdr, Mergeable mergeable, int type) {
        QDRDiscriminator discriminator = new QDRDiscriminator(qdr, type);
        DiscriminatorRule rule = new DiscriminatorRule((Discriminator)discriminator, mergeable);
        return rule;
    }

    @Override
    protected boolean isDataAnnotationSupported() {
        return super.isDataAnnotationSupported();
    }

    protected void setMetadataIndentSupported(boolean supported) {
        this.m_metaIndentSupported = supported;
    }

    @Override
    public boolean isMetadataIndentSupported() {
        return this.m_metaIndentSupported;
    }

    protected void setMetadataRelIndentSupported(boolean supported) {
        this.m_metaRelIndentSupported = supported;
    }

    @Override
    public boolean isMetadataRelIndentSupported() {
        return this.m_metaRelIndentSupported;
    }

    protected void setMetadataIsTotalSupported(boolean supported) {
        this.m_metaIsTotalSupported = supported;
    }

    protected boolean isMetadataIsTotalSupported() {
        return this.m_metaIsTotalSupported;
    }

    protected void setLayerMetaDrillStateSupported(boolean supported) {
        this.m_bLayerMetaDrillStateSupported = supported;
    }

    protected boolean isLayerMetaDrillStateSupported() {
        return this.m_bLayerMetaDrillStateSupported;
    }

    protected void setLayerMetaMeasureSupported(boolean supported) {
        this.m_bLayerMetaMeasureSupported = supported;
    }

    protected boolean isLayerMetaMeasureSupported() {
        return this.m_bLayerMetaMeasureSupported;
    }

    @Override
    public boolean isMeasurePivotLabelTextDisplayed() {
        return this.m_bMeasurePivotLabelTextDisplayed;
    }

    @Override
    public void setMeasurePivotLabelTextDisplayed(boolean displayed) {
        if (displayed != this.m_bMeasurePivotLabelTextDisplayed) {
            boolean oldValue = this.m_bMeasurePivotLabelTextDisplayed;
            this.m_bMeasurePivotLabelTextDisplayed = displayed;
            this.getCrosstabModel().getColumnHeaderHandleDataSource().clearCache();
            this.getCrosstabModel().getRowHeaderHandleDataSource().clearCache();
            if (this.isPivotLabelVisible()) {
                this.updatePivotHandleSize();
                this.updateRowHeaderWidths();
                this.repaint();
            }
            this.firePropertyChange(this, "MeasurePivotLabelTextDisplayed", oldValue, displayed);
        }
    }

    protected boolean isFocusRequestedForCell() {
        return this.m_bFocusRequestedForCell;
    }

    boolean isPivotHandleDrillIconVisible(int edge) {
        if (this.isPrintOrPreviewMode() || !this.isLayerMetaDrillStateSupported() || !this.isDrillingEnabled()) {
            return false;
        }
        boolean bEdgeDrillable = false;
        ArrayOneDModel pivotHandleData = null;
        pivotHandleData = edge == 0 ? this.getCrosstabModel().getColumnHeaderHandleDataSource() : this.getCrosstabModel().getRowHeaderHandleDataSource();
        if (pivotHandleData != null) {
            for (int i = 0; i < pivotHandleData.getItemCount(); ++i) {
                PivotHandleCell cell = (PivotHandleCell)((Object)pivotHandleData.getData(i));
                if (cell == null || cell.getDrillState() == 0) continue;
                bEdgeDrillable = true;
                break;
            }
        }
        return bEdgeDrillable;
    }

    void checkAxisLabelVisibility() {
        if (this.pivotTable == null) {
            return;
        }
        boolean bVisible = this.isPivotLabelVisible() || this.isPivotHandleDrillIconVisible(0);
        this.pivotTable.getColumnPivotHeader().setAxisLabelsVisible(bVisible);
        bVisible = this.isPivotLabelVisible() || this.isPivotHandleDrillIconVisible(1);
        this.pivotTable.getRowPivotHeader().setAxisLabelsVisible(bVisible);
    }

    @Override
    public GridViewExcelHTMLExport getGridViewExcelHTMLExport() {
        return new CrosstabExcelHTMLExport(this);
    }

    @Override
    protected GridView.GridViewExportState createExportState() {
        return new CrosstabExportState();
    }

    @Override
    protected boolean saveExportState(GridView.GridViewExportState state) {
        boolean bResult = super.saveExportState(state);
        if (state instanceof CrosstabExportState) {
            ((CrosstabExportState)state).setDefaultColumnWidth(this.getCrosstabSizingManager().getDefaultColumnWidth());
        }
        state.setFirstRowOnScreen(this.getPivotTable().getFirstRowOnScreen());
        state.setFirstColOnScreen(this.getPivotTable().getFirstColumnOnScreen());
        return bResult;
    }

    @Override
    protected boolean restoreExportState(GridView.GridViewExportState state) {
        boolean bResult = super.restoreExportState(state);
        if (state instanceof CrosstabExportState && ((CrosstabExportState)state).getDefaultColumnWidth() > -1) {
            this.getCrosstabSizingManager().setDefaultColumnWidth(((CrosstabExportState)state).getDefaultColumnWidth());
        }
        return bResult;
    }

    @Override
    protected void resizeViewAfterExport(int firstColOnScreen, int firstRowOnScreen) {
        this.autoFit();
        this.updatePivotHandleSize();
        if (firstRowOnScreen >= 0 && firstRowOnScreen < this.getPivotTable().getGridModel().getRowCount()) {
            this.getPivotTable().setFirstRowOnScreen(firstRowOnScreen);
        }
        if (firstColOnScreen >= 0 && firstColOnScreen < this.getPivotTable().getGridModel().getColumnCount()) {
            this.getPivotTable().setFirstColumnOnScreen(firstColOnScreen);
        }
    }

    protected class CrosstabExportState
    extends GridView.GridViewExportState {
        int defaultColumnWidth;

        protected CrosstabExportState() {
            super(Crosstab.this);
        }

        void setDefaultColumnWidth(int width) {
            this.defaultColumnWidth = width;
        }

        int getDefaultColumnWidth() {
            return this.defaultColumnWidth;
        }
    }
}

