/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.component.qdr;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.adfdtinternal.model.dvt.util.gui.component.ComponentNode;
import oracle.adfdtinternal.model.dvt.util.gui.component.comboBox.TreeListCombo;
import oracle.adfdtinternal.model.dvt.util.gui.component.qdr.QDRPanelModel;
import oracle.bali.ewt.elaf.oracle.OracleLookAndFeel;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.dss.util.HierarchicalQDR;

public class QDRPanel
extends JPanel {
    private QDRPanelModel m_model;
    private boolean m_collapsed;
    private JButton m_button;
    private JPanel m_mainPanel;
    private JTable m_table;
    private MembersRenderer m_renderer;
    private MembersEditor m_editor;

    public QDRPanel(QDRPanelModel model) {
        this.setModel(model);
        this.m_collapsed = true;
        this.initialize();
    }

    public void setModel(QDRPanelModel model) {
        this.m_model = model;
    }

    public QDRPanelModel getModel() {
        return this.m_model;
    }

    public void initialize() {
        this.initializeQDRTable();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        final JPanel contentPanel = new JPanel();
        contentPanel.add(new JLabel(this.getDescription()));
        Image expand = ImageUtils.getImageResource(OracleLookAndFeel.class, (String)"icons/drillTriangle.gif");
        Image collapse = ImageUtils.getImageResource(OracleLookAndFeel.class, (String)"icons/drilledTriangle.gif");
        final ImageIcon imgExpand = new ImageIcon(expand);
        final ImageIcon imgCollapse = new ImageIcon(collapse);
        this.m_button = new JButton(imgExpand);
        this.m_button.setBorderPainted(false);
        this.m_button.setBackground(this.getBackground());
        this.m_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QDRPanel.this.m_editor.stopCellEditing();
                QDRPanel.this.m_button.setIcon(QDRPanel.this.m_collapsed ? imgCollapse : imgExpand);
                contentPanel.removeAll();
                if (QDRPanel.this.m_collapsed) {
                    contentPanel.add(QDRPanel.this.m_mainPanel);
                } else {
                    contentPanel.add(new JLabel(QDRPanel.this.getDescription()));
                }
                QDRPanel.this.revalidate();
                QDRPanel.this.m_collapsed = !QDRPanel.this.m_collapsed;
            }
        });
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        QDRPanel.addComponent(this, this.m_button, gbl, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        QDRPanel.addComponent(this, contentPanel, gbl, gbc);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension panel = this.m_mainPanel.getPreferredSize();
        Dimension button = this.m_button.getPreferredSize();
        return new Dimension((int)(10.0 + button.getWidth() + panel.getWidth()), (int)(26.0 + panel.getHeight()));
    }

    private void initializeQDRTable() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.m_mainPanel = new JPanel(gbl);
        Vector<String> columns = new Vector<String>();
        columns.add("Item");
        columns.add("Members");
        this.m_table = new JTable(new QDRTableModel(this.m_model.getQDR()));
        this.m_table.setRowHeight(25);
        this.m_renderer = new MembersRenderer(this.m_model);
        this.m_editor = new MembersEditor(this.m_model);
        this.m_table.getColumnModel().getColumn(0).setCellRenderer(new ItemRenderer());
        this.m_table.getColumnModel().getColumn(1).setCellRenderer(this.m_renderer);
        this.m_table.getColumnModel().getColumn(1).setCellEditor(this.m_editor);
        QDRPanel.addComponent(this.m_mainPanel, new JScrollPane(this.m_table), gbl, gbc);
        if (this.getModel().isAddRemoveSupported()) {
            gbc.anchor = 18;
            QDRPanel.addComponent(this.m_mainPanel, this.getAddRemovePanel(), gbl, gbc);
        }
    }

    private JPanel getAddRemovePanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel addRemove = new JPanel(gbl);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        JButton add = new JButton("Add...");
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String item = QDRPanel.this.getModel().getNewItem();
                if (item != null) {
                    ((QDRTableModel)QDRPanel.this.m_table.getModel()).addDimension(item);
                }
            }
        });
        QDRPanel.addComponent(addRemove, add, gbl, gbc);
        final JButton remove = new JButton("Remove");
        remove.setEnabled(false);
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((QDRTableModel)QDRPanel.this.m_table.getModel()).removeRow(QDRPanel.this.m_table.getSelectedRow());
            }
        });
        QDRPanel.addComponent(addRemove, remove, gbl, gbc);
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                remove.setEnabled(QDRPanel.this.m_table.getSelectedRow() != -1);
            }
        });
        return addRemove;
    }

    private static void addComponent(JPanel panel, Component component, GridBagLayout gbl, GridBagConstraints gbc) {
        gbl.setConstraints(component, gbc);
        panel.add(component);
    }

    private String getDescription() {
        StringBuffer sb = new StringBuffer("For");
        for (int i = 0; i < this.m_table.getRowCount(); ++i) {
            sb.append(i > 0 ? ", " : " ");
            this.m_renderer.getTableCellRendererComponent(this.m_table, this.m_table.getValueAt(i, 1), false, false, i, 1);
            ComponentNode cn = (ComponentNode)((Object)this.m_renderer.getValue());
            sb.append(cn.getName());
        }
        return sb.toString();
    }

    private class QDRTableModel
    extends AbstractTableModel {
        HierarchicalQDR m_qdr;
        Vector m_dimensions;

        public QDRTableModel(HierarchicalQDR qdr) {
            this.m_qdr = qdr;
            this.m_dimensions = new Vector();
            Enumeration dims = qdr.getDimensions();
            while (dims.hasMoreElements()) {
                this.m_dimensions.add(dims.nextElement());
            }
        }

        public void addDimension(String dimension) {
            this.m_dimensions.add(dimension);
            this.m_qdr.addDimMemberPair(dimension, null, null, null);
        }

        public void removeRow(int row) {
            this.m_qdr.removeDimMemberPair((String)this.m_dimensions.get(row));
            this.m_dimensions.remove(row);
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Item";
            }
            if (column == 1) {
                return "Members";
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            String dimension = (String)this.m_dimensions.get(row);
            if (column == 0) {
                return dimension;
            }
            if (column == 1) {
                return this.m_qdr.getDimMember(dimension).getData();
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            String dimension = (String)this.m_dimensions.get(row);
            ComponentNode cn = (ComponentNode)((Object)value);
            this.m_qdr.getDimMember(dimension).setData((Object)cn.getID());
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        @Override
        public int getRowCount() {
            return this.m_dimensions.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }
    }

    private class MembersRenderer
    implements TableCellRenderer {
        private QDRPanelModel m_model;
        private TreeListCombo m_combo;

        public MembersRenderer(QDRPanelModel model) {
            this.m_model = model;
            this.m_combo = new TreeListCombo();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String dimension = (String)table.getModel().getValueAt(row, 0);
            this.m_combo.setModel(this.m_model.getMembers(dimension));
            this.m_combo.getModel().setSelectedItem(value);
            return this.m_combo;
        }

        public Object getValue() {
            return this.m_combo.getSelectedItem();
        }
    }

    private class MembersEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private MembersRenderer m_renderer;

        public MembersEditor(QDRPanelModel model) {
            this.m_renderer = new MembersRenderer(model);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox combo = (JComboBox)this.m_renderer.getTableCellRendererComponent(table, value, isSelected, true, row, column);
            return combo;
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_renderer.getValue();
        }
    }

    private class ItemRenderer
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return new JLabel(QDRPanel.this.getModel().getLabel((String)value));
        }
    }
}

