/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui;

import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class LightWeightComboBox
extends JComboBox {
    public static final String SEPARATOR = "|";
    public static String JAVA_VERSION_1_4 = "1.4";
    private int m_nPreviouslySelectedIndex = 0;

    public LightWeightComboBox() {
        this.init();
    }

    public LightWeightComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.init();
    }

    public LightWeightComboBox(Object[] objArrayItems) {
        super(objArrayItems);
        this.init();
    }

    public LightWeightComboBox(Vector vItems) {
        super(vItems);
        this.init();
    }

    @Override
    public void showPopup() {
        this.setPreviouslySelectedIndex(this.getSelectedIndex());
        super.showPopup();
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        boolean bIsPopupVisible = this.isPopupVisible();
        if (bIsPopupVisible) {
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    this.hidePopup();
                    this.setSelectedIndex(this.getPreviouslySelectedIndex());
                    break;
                }
                case 10: 
                case 32: {
                    if (keyEvent.getID() != 402) break;
                    this.hidePopup();
                    this.setSelectedIndex(LightWeightComboBox.getPopupSelectedIndex(this));
                }
            }
        } else if (keyEvent.getID() == 402 && (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 32 && !this.isEditable())) {
            this.showPopup();
        }
        switch (keyEvent.getKeyCode()) {
            case 115: {
                if (!this.isPopupVisible()) {
                    this.setPreviouslySelectedIndex(this.getSelectedIndex());
                }
                if (!LightWeightComboBox.isPriorVersion(JAVA_VERSION_1_4) && this.isEditable()) break;
                super.processKeyEvent(keyEvent);
                break;
            }
            case 27: {
                if (!bIsPopupVisible) {
                    super.processKeyEvent(keyEvent);
                    break;
                }
                keyEvent.consume();
                break;
            }
            case 32: {
                break;
            }
            case 10: {
                if (!LightWeightComboBox.isPriorVersion(JAVA_VERSION_1_4) && !this.isPopupVisible()) {
                    if (this.isEditable()) {
                        keyEvent.consume();
                    }
                    this.putClientProperty("JComboBox.isTableCellEditor", Boolean.FALSE);
                    super.processKeyEvent(keyEvent);
                    this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
                }
            }
            default: {
                super.processKeyEvent(keyEvent);
            }
        }
        if (SEPARATOR.equals(this.getItemAt(LightWeightComboBox.getPopupSelectedIndex(this)))) {
            this.processKeyEvent(new KeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
        }
        if ((!this.isEditable() || bIsPopupVisible) && keyEvent.getKeyCode() != 10 && keyEvent.getKeyCode() != 0) {
            keyEvent.consume();
        }
    }

    @Override
    public void setSelectedIndex(int nIndex) {
        if (nIndex != -1) {
            super.setSelectedIndex(nIndex);
        }
    }

    public static boolean isPriorVersion(String strVersion) {
        boolean bIsPriorVersion = false;
        String strJavaVersion = System.getProperty("java.version");
        if (strJavaVersion != null && strJavaVersion.compareTo(strVersion) < 0) {
            bIsPriorVersion = true;
        }
        return bIsPriorVersion;
    }

    public static JList getList(JComboBox jComboBox) {
        Accessible accessiblePopup;
        JList<Object> jList = null;
        if (jComboBox != null && (accessiblePopup = jComboBox.getUI().getAccessibleChild(jComboBox, 0)) != null && accessiblePopup instanceof ComboPopup) {
            jList = ((ComboPopup)((Object)accessiblePopup)).getList();
        }
        return jList;
    }

    public static int getPopupSelectedIndex(JComboBox jComboBox) {
        int nSelectedIndex = -1;
        JList jList = LightWeightComboBox.getList(jComboBox);
        if (jList != null) {
            nSelectedIndex = jList.getSelectedIndex();
        }
        return nSelectedIndex;
    }

    public static Object getPopupSelectedItem(JComboBox jComboBox) {
        Object objSelected = null;
        JList jList = LightWeightComboBox.getList(jComboBox);
        if (jList != null) {
            objSelected = jList.getSelectedValue();
        }
        return objSelected;
    }

    public int getPreviouslySelectedIndex() {
        return this.m_nPreviouslySelectedIndex;
    }

    public void setPreviouslySelectedIndex(int nPreviouslySelectedIndex) {
        this.m_nPreviouslySelectedIndex = nPreviouslySelectedIndex;
    }

    private void init() {
        if (!LightWeightComboBox.isPriorVersion(JAVA_VERSION_1_4)) {
            this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        } else {
            this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        }
        this.setEditor(new LightWeightComboBoxEditor(this));
    }

    public class LightWeightComboBoxEditor
    extends BasicComboBoxEditor {
        public LightWeightComboBoxEditor(JComboBox jComboBoxParent) {
            this.editor = new BorderlessTextField("", 9, jComboBoxParent);
            this.editor.setBorder(null);
        }
    }

    protected static class BorderlessTextField
    extends JTextField {
        JComboBox m_jComboBoxParent = null;

        public BorderlessTextField(String strValue, int nColumns, JComboBox jComboBoxParent) {
            super(strValue, nColumns);
            this.setComboBoxParent(jComboBoxParent);
        }

        @Override
        public void setText(String strText) {
            if (this.getText().equals(strText)) {
                return;
            }
            super.setText(strText);
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            boolean bKeyProcessed = false;
            boolean bIsPopupVisible = false;
            JComboBox jComboBoxParent = this.getComboBoxParent();
            if (jComboBoxParent != null) {
                bIsPopupVisible = jComboBoxParent.isPopupVisible();
                if (jComboBoxParent.isEditable()) {
                    jComboBoxParent.processKeyEvent(keyEvent);
                    if (keyEvent.getKeyCode() == 10) {
                        keyEvent.consume();
                        bKeyProcessed = true;
                    }
                }
            }
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    if (!bIsPopupVisible || LightWeightComboBox.isPriorVersion(JAVA_VERSION_1_4)) break;
                    keyEvent.consume();
                    bKeyProcessed = true;
                    break;
                }
                case 10: {
                    jComboBoxParent.setSelectedItem(this.getText());
                    if (LightWeightComboBox.isPriorVersion(JAVA_VERSION_1_4) || bIsPopupVisible) break;
                    keyEvent.consume();
                    this.getComboBoxParent().putClientProperty("JComboBox.isTableCellEditor", Boolean.FALSE);
                    super.processKeyEvent(keyEvent);
                    this.getComboBoxParent().putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
                    bKeyProcessed = true;
                }
            }
            if (!bKeyProcessed) {
                super.processKeyEvent(keyEvent);
            }
        }

        public JComboBox getComboBoxParent() {
            return this.m_jComboBoxParent;
        }

        public void setComboBoxParent(JComboBox jComboBoxParent) {
            this.m_jComboBoxParent = jComboBoxParent;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new BorderlessTextAccessibleJTextField();
            }
            return this.accessibleContext;
        }

        protected class BorderlessTextAccessibleJTextField
        extends JTextField.AccessibleJTextField {
            protected BorderlessTextAccessibleJTextField() {
                super(BorderlessTextField.this);
            }

            public Document setAccessibleDocument() {
                Document document = BorderlessTextField.this.getDocument();
                try {
                    JComboBox jComboBoxParent = BorderlessTextField.this.getComboBoxParent();
                    if (jComboBoxParent != null && jComboBoxParent.isEditable()) {
                        String strItem = null;
                        Object objItem = LightWeightComboBox.getPopupSelectedItem(jComboBoxParent);
                        if (objItem != null) {
                            strItem = objItem.toString();
                        }
                        if (strItem != null) {
                            PlainDocument accessibleDocument = new PlainDocument();
                            accessibleDocument.insertString(0, strItem, null);
                            BorderlessTextField.this.setDocument(accessibleDocument);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return document;
            }

            @Override
            public String getAtIndex(int nPart, int nIndex) {
                String strGetAtIndex = null;
                Document document = this.setAccessibleDocument();
                strGetAtIndex = super.getAtIndex(nPart, nIndex);
                if (!document.equals(BorderlessTextField.this.getDocument())) {
                    BorderlessTextField.this.setDocument(document);
                }
                return strGetAtIndex;
            }

            @Override
            public int getCharCount() {
                Document document = this.setAccessibleDocument();
                int nCount = super.getCharCount();
                if (!document.equals(BorderlessTextField.this.getDocument())) {
                    BorderlessTextField.this.setDocument(document);
                }
                return nCount;
            }
        }
    }
}

