/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JWindow;

public class LazyScrollPane
extends JScrollPane {
    private static final int HORIZONTAL_GAP = 10;
    private static final int DEFAULT_THRESHOLD = 1000;
    private MouseDelayListener m_mouseDelayListener = new MouseDelayListener();
    private JComponent m_component = null;
    private JList m_list = null;
    private JScrollBar m_verticalScrollBar = null;
    private int m_intThreshold = 1000;
    private int m_intRowHeight = -1;
    private MouseEvent m_mouseEvent = null;
    private ResourceBundle m_bundle = ResourceBundle.getBundle("oracle.adfdtinternal.model.dvt.util.gui.resource.UtilGUIBundle");
    private JWindow m_window = null;
    private JPanel m_panel = null;
    private boolean m_blnShowTooltip = true;
    private Point m_location = null;
    private JToolTip m_toolTip = null;

    public LazyScrollPane(JComponent component, int intThreshold) {
        super(component);
        this.m_intThreshold = intThreshold;
        this.m_component = component;
        if (component instanceof JList) {
            this.m_list = (JList)component;
        }
        this.setLazyModel();
    }

    public LazyScrollPane(JComponent component) {
        this(component, 1000);
    }

    public boolean isShowTooltip() {
        return this.m_blnShowTooltip;
    }

    public void setShowTooltip(boolean blnShowTooltip) {
        this.m_blnShowTooltip = blnShowTooltip;
    }

    private void setLazyModel() {
        LazyModel lazyModel = new LazyModel();
        this.getVerticalScrollBar().addMouseListener(this.m_mouseDelayListener);
        this.getVerticalScrollBar().setModel(lazyModel);
        this.updateUI();
        this.m_verticalScrollBar = this.getVerticalScrollBar();
    }

    private JWindow getWindow() {
        if (this.m_window == null) {
            this.m_window = new JWindow();
            this.m_window.getContentPane().add(this.getPanel());
        }
        return this.m_window;
    }

    private JPanel getPanel() {
        if (this.m_panel == null) {
            this.m_panel = new JPanel(new BorderLayout());
        }
        return this.m_panel;
    }

    private int getX(JScrollBar scrollBar, JComponent component) {
        if (scrollBar != null) {
            if (scrollBar.getValue() + scrollBar.getVisibleAmount() == scrollBar.getMaximum()) {
                return this.getY(scrollBar, component);
            }
            return scrollBar.getValue() / (this.getRowHeight(component) - 1) + 1;
        }
        return -1;
    }

    private int getY(JScrollBar scrollBar, JComponent component) {
        if (scrollBar != null) {
            return scrollBar.getMaximum() / (this.getRowHeight(component) - 1);
        }
        return -1;
    }

    private int getRowHeight(JComponent component) {
        Rectangle rectangle;
        if (this.m_intRowHeight == -1 && component != null && component instanceof JList && (rectangle = ((JList)component).getCellBounds(0, 0)) != null) {
            this.m_intRowHeight = rectangle.height + 1;
        }
        return this.m_intRowHeight;
    }

    private String getXofY(JScrollBar scrollBar) {
        if (scrollBar != null && this.m_list != null) {
            Object[] formatArgs = new String[]{Integer.toString(this.getX(scrollBar, this.m_component)), Integer.toString(this.getY(scrollBar, this.m_component))};
            return MessageFormat.format(this.m_bundle.getString("XofY"), formatArgs);
        }
        return null;
    }

    private Point getInitialTooltipLocation(JWindow window, JScrollBar scrollBar, MouseEvent e) {
        if (window != null && scrollBar != null && scrollBar.isShowing() && e != null) {
            int x = scrollBar.getLocationOnScreen().x - window.getWidth();
            int y = this.getLocationOnScreen().y + e.getY() - this.getRowHeight(this.m_component) / 2;
            return new Point(x - 10, y);
        }
        return null;
    }

    private Point getTooltipLocation(JWindow window, JScrollBar scrollBar) {
        if (window != null && scrollBar != null && scrollBar.isShowing() && this.m_location != null) {
            int x = scrollBar.getLocationOnScreen().x - window.getWidth();
            int y = this.m_location.y;
            return new Point(x - 10, y);
        }
        return null;
    }

    private void updateXofY() {
        this.m_toolTip = new JToolTip();
        this.m_toolTip.setTipText(this.getXofY(this.m_verticalScrollBar));
        this.getPanel().removeAll();
        this.getPanel().add((Component)this.m_toolTip, "Center");
        this.getWindow().pack();
        this.m_location = this.getTooltipLocation(this.getWindow(), this.m_verticalScrollBar);
        if (this.m_location != null) {
            this.getWindow().setLocation(this.m_location);
        }
    }

    class MouseDelayListener
    extends MouseAdapter {
        MouseDelayListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (LazyScrollPane.this.isShowTooltip() && LazyScrollPane.this.m_list != null) {
                LazyScrollPane.this.m_location = LazyScrollPane.this.getInitialTooltipLocation(LazyScrollPane.this.m_window, LazyScrollPane.this.m_verticalScrollBar, e);
                if (LazyScrollPane.this.m_location != null) {
                    LazyScrollPane.this.getWindow().setLocation(LazyScrollPane.this.m_location);
                }
                LazyScrollPane.this.getWindow().setVisible(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (LazyScrollPane.this.isShowTooltip() && LazyScrollPane.this.m_list != null) {
                LazyScrollPane.this.getWindow().setVisible(false);
            }
        }
    }

    class LazyModel
    extends DefaultBoundedRangeModel {
        public LazyModel() {
            super(0, 10, 0, 100);
        }

        @Override
        protected void fireStateChanged() {
            if (LazyScrollPane.this.isShowTooltip() && LazyScrollPane.this.m_list != null) {
                LazyScrollPane.this.updateXofY();
            }
            if (!this.getValueIsAdjusting() || LazyScrollPane.this.getY(LazyScrollPane.this.m_verticalScrollBar, LazyScrollPane.this.m_component) <= LazyScrollPane.this.m_intThreshold) {
                super.fireStateChanged();
            }
        }
    }
}

