/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml.navigator;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.xml.navigator.NavigatorXmlElements;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Descriptor
implements NavigatorXmlElements {
    private final String id;

    protected Descriptor(XMLNode node) {
        this.id = Descriptor.getAttributeValue("", "id", node);
    }

    protected final String getID() {
        return this.id;
    }

    protected static String getAttributeValue(String elementPath, String attribute, XMLNode node) {
        String value = XMLHelper.getAttributeNode((Node)node, attribute);
        if (value == null && elementPath != null) {
            value = XMLHelper.getAttributeNode(XMLHelper.getChildNode((Node)node, elementPath), attribute);
        }
        return value;
    }

    protected static boolean getBooleanValue(String elementPath, String attribute, XMLNode node) {
        return Boolean.valueOf(Descriptor.getAttributeValue(elementPath, attribute, node));
    }

    protected static XMLNode getSingleElement(String elementPath, XMLNode node) {
        XMLNode element = null;
        try {
            element = (XMLNode)node.selectSingleNode(elementPath);
        }
        catch (XSLException xSLException) {
            // empty catch block
        }
        return element;
    }

    protected static XMLNode[] getElements(String elementPath, XMLNode node) {
        XMLNode[] elements = null;
        try {
            NodeList nl = node.selectNodes(elementPath);
            elements = new XMLNode[nl.getLength()];
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = (XMLNode)nl.item(i);
            }
        }
        catch (XSLException xSLException) {
            // empty catch block
        }
        return elements;
    }

    protected static Set<String> parseSet(XMLNode node, String attr) {
        HashSet result = null;
        String reqs = Descriptor.getAttributeValue("", attr, node);
        if (reqs != null) {
            result = new HashSet();
            Collections.addAll(result, reqs.split(","));
        }
        return result;
    }

    protected static Version getVersion(String elementPath, String attribute, XMLNode node) {
        String versionString = Descriptor.getAttributeValue(elementPath, attribute, node);
        return ModelUtil.hasLength(versionString) ? new Version(versionString) : null;
    }

    protected static final <T> List<T> wrapList(List<T> list) {
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    protected static final <K, V> Map<K, V> wrapMap(Map<K, V> map) {
        if (map != null) {
            return Collections.unmodifiableMap(map);
        }
        return Collections.emptyMap();
    }

    protected static final <T> Set<T> wrapSet(Set<T> set) {
        if (set != null) {
            return Collections.unmodifiableSet(set);
        }
        return Collections.emptySet();
    }
}

