/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.xml.actions.ActionsXmlElements;
import oracle.dbtools.xml.actions.ConfirmationElement;
import oracle.dbtools.xml.actions.PromptElement;
import oracle.dbtools.xml.actions.TypedElement;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public class ItemElement
implements ActionsXmlElements,
TypedElement {
    private final String className;
    private final ConfirmationElement confirmation;
    private final String help;
    private final String iconName;
    private final List<PromptElement> prompts = new ArrayList<PromptElement>();
    private final String requiredFeature;
    private final Boolean reload;
    private final Boolean reloadParent;
    private final Boolean removeFromParent;
    private final String script;
    private final String sql;
    private final String title;
    private final String type;
    private final String globalResource;

    public ItemElement(XMLNode node, String globalResource) {
        XMLNode[] promptElements = XMLHelper.getChildNodes((Node)node, "prompt");
        if (promptElements != null) {
            for (XMLNode promptElement : promptElements) {
                this.prompts.add(new PromptElement(promptElement));
            }
        }
        String reloadStr = XMLHelper.getAttributeNode((Node)node, "reload");
        this.reload = Boolean.valueOf(reloadStr);
        String reloadParentStr = XMLHelper.getAttributeNode((Node)node, "reloadparent");
        this.reloadParent = Boolean.valueOf(reloadParentStr);
        String reloadFromParentStr = XMLHelper.getAttributeNode((Node)node, "reloadparent");
        this.removeFromParent = Boolean.valueOf(reloadFromParentStr);
        this.requiredFeature = XMLHelper.getAttributeNode((Node)node, "requiredFeatures");
        this.className = XMLHelper.getAttributeNode((Node)node, "className");
        this.type = XMLHelper.getAttributeNode((Node)node, "type");
        XMLNode sqlElement = (XMLNode)XMLHelper.getChildNode((Node)node, "sql");
        this.sql = sqlElement != null ? sqlElement.getTextContent() : null;
        XMLNode scriptElement = (XMLNode)XMLHelper.getChildNode((Node)node, "script");
        this.script = scriptElement != null ? scriptElement.getTextContent() : null;
        XMLNode titleElement = (XMLNode)XMLHelper.getChildNode((Node)node, "title");
        this.title = titleElement != null ? titleElement.getTextContent() : null;
        XMLNode helpElement = (XMLNode)XMLHelper.getChildNode((Node)node, "help");
        this.help = helpElement != null ? helpElement.getTextContent() : null;
        XMLNode confirmationElement = (XMLNode)XMLHelper.getChildNode((Node)node, "confirmation");
        this.confirmation = confirmationElement != null ? new ConfirmationElement((Node)confirmationElement) : null;
        XMLNode iconElement = (XMLNode)XMLHelper.getChildNode((Node)node, "iconName");
        this.iconName = iconElement != null ? iconElement.getTextContent() : null;
        this.globalResource = globalResource;
    }

    public String getClassName() {
        return this.className;
    }

    public ConfirmationElement getConfirmation() {
        return this.confirmation;
    }

    public String getHelp() {
        return this.help;
    }

    public String getIconName() {
        return this.iconName;
    }

    public List<PromptElement> getPrompts() {
        return Collections.unmodifiableList(this.prompts);
    }

    public String getRequiredFeature() {
        return this.requiredFeature;
    }

    public Boolean getReload() {
        return this.reload;
    }

    public Boolean getReloadParent() {
        return this.reloadParent;
    }

    public Boolean getRemoveFromParent() {
        return this.removeFromParent;
    }

    public String getSql() {
        return this.sql;
    }

    public String getScript() {
        return this.script;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getGlobalResource() {
        return this.globalResource;
    }
}

