/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class KeyboardFocusLogger
implements FocusListener,
PropertyChangeListener {
    private static Border DEBUG_BORDER = BorderFactory.createLineBorder(Color.RED);
    private static KeyboardFocusLogger _keyboardFocusLogger;
    private KeyboardFocusManager keyboardFocusManager;
    private boolean decorateBorder = true;
    private static final String FOCUS_OWNER = "focusOwner";
    private static Logger LOGGER;
    private Map<JComponent, Border> originalBorderMap = new HashMap<JComponent, Border>();

    private KeyboardFocusLogger() {
    }

    public static KeyboardFocusLogger getInstance() {
        if (null == _keyboardFocusLogger) {
            _keyboardFocusLogger = new KeyboardFocusLogger();
        }
        return _keyboardFocusLogger;
    }

    public static void start() {
        KeyboardFocusLogger.start(true);
    }

    public static void start(boolean decorate) {
        KeyboardFocusLogger.getInstance().startImpl(decorate);
    }

    private void startImpl(boolean decorate) {
        this.decorateBorder = decorate;
        this.setKeyboardFocusManager(KeyboardFocusManager.getCurrentKeyboardFocusManager());
    }

    private void setKeyboardFocusManager(KeyboardFocusManager currentKeyboardFocusManager) {
        if (this.keyboardFocusManager != null) {
            this.keyboardFocusManager.removePropertyChangeListener(FOCUS_OWNER, this);
        }
        this.keyboardFocusManager = currentKeyboardFocusManager;
        this.keyboardFocusManager.addPropertyChangeListener(FOCUS_OWNER, this);
    }

    public static void stop() {
        KeyboardFocusLogger.getInstance().stopImpl();
    }

    private void stopImpl() {
        if (this.keyboardFocusManager != null) {
            this.keyboardFocusManager.removePropertyChangeListener(FOCUS_OWNER, _keyboardFocusLogger);
            this.keyboardFocusManager = null;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (null == this.keyboardFocusManager) {
            this.log(e);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (null == this.keyboardFocusManager) {
            this.log(e);
        }
    }

    public boolean setDecorateBorder(boolean decorate) {
        boolean oldVal = this.decorateBorder;
        this.decorateBorder = decorate;
        return oldVal;
    }

    public void watch(JComponent comp) {
        this.ignore(comp);
        comp.addFocusListener(this);
    }

    public void ignore(JComponent comp) {
        comp.removeFocusListener(this);
    }

    public void watchAll(JComponent comp) {
        this.watch(comp);
        for (Component scomp : comp.getComponents()) {
            if (!(scomp instanceof JComponent)) continue;
            this.watchAll((JComponent)scomp);
        }
    }

    public void ignoreAll(JComponent comp) {
        this.ignore(comp);
        for (Component scomp : comp.getComponents()) {
            if (!(scomp instanceof JComponent)) continue;
            this.ignoreAll((JComponent)scomp);
        }
    }

    protected void log(FocusEvent e) {
        LOGGER.log(Level.FINER, e.toString());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (FOCUS_OWNER.equals(evt.getPropertyName())) {
            this.log(evt);
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            if (this.decorateBorder) {
                JComponent jcomp;
                if (oldValue instanceof JComponent) {
                    jcomp = (JComponent)oldValue;
                    this.resetBorder(jcomp);
                }
                if (newValue instanceof JComponent) {
                    jcomp = (JComponent)newValue;
                    this.setBorder(jcomp);
                }
            }
        }
    }

    private void resetBorder(JComponent jcomponent) {
        if (DEBUG_BORDER == jcomponent.getBorder()) {
            Border border = this.originalBorderMap.remove(jcomponent);
            jcomponent.setBorder(border);
        }
    }

    private void setBorder(JComponent jcomponent) {
        Border currentBorder = jcomponent.getBorder();
        if (currentBorder != DEBUG_BORDER) {
            this.originalBorderMap.put(jcomponent, currentBorder);
            jcomponent.setBorder(DEBUG_BORDER);
        }
    }

    protected void log(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        String msg = String.format("%1$10s: %2$s\n%3$10s: %4$s", name, newValue, "old", oldValue);
        System.out.println("FocusLogger: " + msg);
    }

    static {
        LOGGER = Logger.getLogger(KeyboardFocusLogger.class.getName());
    }
}

