/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class QueryXMLSupport {
    private static final ThreadLocal<HashMap<String, QueryXMLSupport>> s_sql = new ThreadLocal<HashMap<String, QueryXMLSupport>>(){

        @Override
        protected HashMap<String, QueryXMLSupport> initialValue() {
            return new HashMap<String, QueryXMLSupport>();
        }
    };
    private static final ThreadLocal<HashMap<String, Map<String, String>>> s_typeAtts = new ThreadLocal<HashMap<String, Map<String, String>>>(){

        @Override
        protected HashMap<String, Map<String, String>> initialValue() {
            return new HashMap<String, Map<String, String>>();
        }
    };
    private Map<String, ObjectQueries> m_queryMap;

    public static QueryXMLSupport getQueryXMLSupport(String path) {
        return QueryXMLSupport.getQueryXMLSupport(new MetaResource(QueryXMLSupport.class.getClassLoader(), path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryXMLSupport getQueryXMLSupport(MetaResource path) {
        QueryXMLSupport support;
        if (path.getResourcePath().startsWith("file://")) {
            QueryXMLSupport.getSQL().remove(path.getResourcePath());
        }
        if ((support = QueryXMLSupport.getSQL().get(path.getResourcePath())) == null) {
            URL u = path.toURL();
            if (u == null && path.getResourcePath().startsWith("file://")) {
                try {
                    u = new URL(path.getResourcePath());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (u != null) {
                DOMParser parser = new DOMParser();
                parser.setPreserveWhitespace(false);
                InputStream in = null;
                try {
                    in = u.openStream();
                    parser.parse(in);
                    XMLDocument doc = parser.getDocument();
                    QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport(doc);
                    if (queryXMLSupport != null) {
                        support = queryXMLSupport;
                    }
                    QueryXMLSupport.getSQL().put(path.getResourcePath(), support);
                }
                catch (Exception e) {
                    Logger.getLogger(QueryXMLSupport.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return support;
    }

    public static QueryXMLSupport getQueryXMLSupport(XMLDocument doc) {
        Node srcNode = XMLHelper.getChildNode((Node)doc, "/source");
        if (srcNode != null) {
            HashMap<String, ObjectQueries> queryMap = new HashMap<String, ObjectQueries>();
            for (XMLNode typeNode : XMLHelper.getChildNodes(srcNode, "queryType")) {
                String typeName = XMLHelper.getAttributeNode((Node)typeNode, "id");
                ObjectQueries q = new ObjectQueries((XMLNode)XMLHelper.getChildNode((Node)typeNode, "queries"));
                queryMap.put(typeName, q);
                HashMap<String, String> attrMap = new HashMap<String, String>();
                NamedNodeMap attrs = typeNode.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Attr attribute = (Attr)attrs.item(i);
                    attrMap.put(attribute.getName(), attribute.getValue());
                }
                QueryXMLSupport.getTypeAttr().put(typeName, attrMap);
            }
            return new QueryXMLSupport(queryMap);
        }
        return null;
    }

    private static HashMap<String, Map<String, String>> getTypeAttr() {
        HashMap<String, Map<String, String>> typeAttr = s_typeAtts.get();
        return typeAttr;
    }

    private static HashMap<String, QueryXMLSupport> getSQL() {
        HashMap<String, QueryXMLSupport> sql = s_sql.get();
        return sql;
    }

    private QueryXMLSupport(Map<String, ObjectQueries> queries) {
        this.m_queryMap = queries;
    }

    public String getQueryAttribute(String type, String name) {
        if (QueryXMLSupport.getTypeAttr().get(type) != null && QueryXMLSupport.getTypeAttr().get(type).get(name) != null) {
            return QueryXMLSupport.getTypeAttr().get(type).get(name);
        }
        return null;
    }

    public Query getQuery(String type, ConnectionIdentifier id) {
        ObjectQueries queries = this.m_queryMap.get(type);
        return queries != null ? queries.getQuery(id) : null;
    }

    public Query getQuery(String type, Connection conn) {
        ObjectQueries queries = this.m_queryMap.get(type);
        return queries != null ? queries.getQuery(DefaultConnectionIdentifier.createIdentifier(conn)) : null;
    }
}

