/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.INLSSupplier;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.jdbc.OracleConnection;

public class NLSProvider {
    private static Map<Object, DefaultNLSProvider> providers = new HashMap<Object, DefaultNLSProvider>();
    private static INLSSupplier _supplier;

    public static void setNLSSupplier(INLSSupplier supplier) {
        _supplier = supplier;
    }

    public static DefaultNLSProvider getProvider(String connName) {
        if (_supplier != null && _supplier.getNLSProvider(connName) != null) {
            return NLSProvider.getProvider(_supplier.getNLSProvider(connName).getConnection());
        }
        return null;
    }

    public static DefaultNLSProvider getProvider(Connection conn) {
        DefaultNLSProvider prov = providers.get(conn);
        if (prov != null && prov.getConnection() != conn) {
            prov = null;
        }
        if (prov == null) {
            block6: {
                try {
                    if (_supplier != null) {
                        prov = _supplier.getNLSProvider(conn);
                    }
                }
                catch (Exception e) {
                    if (conn == null) break block6;
                    Logger.getLogger(DefaultNLSProvider.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
            if (prov == null) {
                prov = conn instanceof OracleConnection ? new OracleNLSProvider(conn) : new DefaultNLSProvider(conn);
            }
            providers.put(conn, prov);
        }
        return prov;
    }
}

