/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer.basic;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.Messages;

public class TypedEnum<T>
implements Transformer<String, T> {
    private final Map<T, T> items;
    private final Transformer<String, T> itemTransformer;

    public TypedEnum(Transformer<String, T> itemTransformer, T ... items) {
        this(itemTransformer, null, items);
    }

    public TypedEnum(Transformer<String, T> itemTransformer, Comparator<T> comparator, T ... items) {
        this.items = new TreeMap<T, T>(comparator);
        for (T item : items) {
            if (this.items.containsKey(item)) {
                throw new IllegalArgumentException("duplicate item specified to TypeEnum: " + item);
            }
            this.items.put(item, item);
        }
        this.itemTransformer = itemTransformer;
    }

    @Override
    public T transform(String rawValue, TransformContext context, Environment environment) {
        T value = this.itemTransformer.transform(rawValue, context, environment);
        if (this.items.containsKey(value)) {
            value = this.items.get(value);
            context.addCompletion(value.toString());
            return value;
        }
        if ("".equals(rawValue)) {
            for (T item : this.items.keySet()) {
                context.addCompletion(item.toString());
            }
            context.addError(MessageFormat.format(Messages.getString(Messages.Key.NOT_AN_ENUM_ITEM, environment.getLocale()), rawValue));
            return null;
        }
        for (T item : this.items.keySet()) {
            if (!this.isPartialMatchFor(item, rawValue)) continue;
            context.addCompletion(item.toString());
        }
        context.addError(MessageFormat.format(Messages.getString(Messages.Key.NOT_AN_ENUM_ITEM, environment.getLocale()), rawValue));
        return null;
    }

    protected boolean isPartialMatchFor(T item, String rawValue) {
        return false;
    }

    @Override
    public String getFormat(Locale locale) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (T item : this.items.keySet()) {
            if (!first) {
                buf.append("|");
            }
            buf.append(item);
            first = false;
        }
        return buf.toString();
    }
}

