/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;
import oracle.dbtools.raptor.newscriptrunner.util.parser.AttributeContainer;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ContainerObjectsBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Grammar;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamePropertiesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parameter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Synonyms;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;

public final class TypeBuilder {
    private final NamePropertiesBuilder namePropertiesBuilder = new NamePropertiesBuilder();
    private final ContainerObjectsBuilder containerObjectsBuilder = new ContainerObjectsBuilder();
    private final Id id;
    private boolean base;

    public TypeBuilder name(String name) {
        this.namePropertiesBuilder.setName(name);
        return this;
    }

    public TypeBuilder helpId(String helpId) {
        this.namePropertiesBuilder.setHelpId(helpId);
        return this;
    }

    public TypeBuilder helpId() {
        this.namePropertiesBuilder.setHelpId(null);
        return this;
    }

    public TypeBuilder addHelpContainer(HelpContainer container) {
        this.containerObjectsBuilder.addHelpContainer(container);
        return this;
    }

    public TypeBuilder addHelpContainerFor(Object forObject) {
        this.containerObjectsBuilder.addHelpContainerFor(forObject);
        return this;
    }

    public TypeBuilder addHelpContainerFor(Object forObject, String bundleName) {
        this.containerObjectsBuilder.addHelpContainerFor(forObject, bundleName);
        return this;
    }

    public TypeBuilder abbrevs(String ... abbrevs) {
        this.namePropertiesBuilder.setAbbrevs(abbrevs);
        return this;
    }

    public TypeBuilder with(AttributeContainer container) {
        this.containerObjectsBuilder.addContainer(container);
        return this;
    }

    public TypeBuilder set(Grammar<?> grammar) {
        this.containerObjectsBuilder.setGrammar(grammar);
        return this;
    }

    public TypeBuilder setLiteralGrammar(Id id) {
        this.set(Factory.grammar().dataType(String.class).defaultValue("").add(Factory.rule(id).eq(Factory.seq(this::literalTransformer, Factory.literal(id.getName()).helpId(id.getHelpId()))).helpId()).build());
        return this;
    }

    public TypeBuilder add(Option<?> option) {
        this.containerObjectsBuilder.addOption(option);
        return this;
    }

    public TypeBuilder add(Parameter<?> parameter) {
        this.containerObjectsBuilder.addParameter(parameter);
        return this;
    }

    public TypeBuilder add(Type nestedType) {
        this.containerObjectsBuilder.addNestedType(nestedType);
        return this;
    }

    public TypeBuilder base() {
        this.base = true;
        return this;
    }

    public Type build() {
        TypeImpl type = new TypeImpl(this, this.namePropertiesBuilder.build(this.id, true), this.containerObjectsBuilder.build());
        this.containerObjectsBuilder.validate(type);
        return type;
    }

    protected TypeBuilder(Id id) {
        this.id = id;
    }

    private String literalTransformer(List<Node> childNodes, TransformContext context, Environment environment) {
        return (String)childNodes.get(0).getValue();
    }

    private static class TypeImpl
    implements Type {
        private final Id id;
        private final String name;
        private final Optional<String> helpId;
        private final Synonyms synonyms;
        private final Grammar<?> grammar;
        private final List<Option<?>> options;
        private final List<Parameter<?>> parameters;
        private final List<Type> nestedTypes;
        private final List<HelpContainer> helpContainers;
        private final boolean base;

        private TypeImpl(TypeBuilder builder, NamePropertiesBuilder.NameProperties nameProperties, ContainerObjectsBuilder.ContainerObjects containerObjects) {
            this.id = builder.id;
            this.grammar = containerObjects.getGrammar();
            this.options = containerObjects.getOptions();
            this.parameters = containerObjects.getParameters();
            this.nestedTypes = containerObjects.getNestedTypes();
            this.helpContainers = Collections.unmodifiableList(containerObjects.getHelpContainers());
            this.name = nameProperties.getName();
            this.helpId = nameProperties.getHelpId();
            this.synonyms = nameProperties.getSynonyms();
            this.base = builder.base;
        }

        @Override
        public Id getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Optional<String> getHelpId() {
            return this.helpId;
        }

        @Override
        public Syntax getSyntax() {
            return this.synonyms.getNameSyntax();
        }

        @Override
        public Synonyms getSynonyms() {
            return this.synonyms;
        }

        @Override
        public Grammar<?> getGrammar() {
            return this.grammar;
        }

        @Override
        public List<Option<?>> getOptions() {
            return this.options;
        }

        @Override
        public List<Parameter<?>> getParameters() {
            return this.parameters;
        }

        @Override
        public List<Type> getNestedTypes() {
            return this.nestedTypes;
        }

        @Override
        public List<HelpContainer> getHelpContainers() {
            return this.helpContainers;
        }

        @Override
        public boolean isBase() {
            return this.base;
        }
    }
}

