/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Attribute;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Completion;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Grammar;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Messages;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parameter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.SemanticError;
import oracle.dbtools.raptor.newscriptrunner.util.parser.TransformContextImpl;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.SQLPLUSTokenizer;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.Token;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.Tokenizer;

public class Parser {
    private final TypeContainer rootContainer;
    private final Tokenizer tokenizer;
    private final Environment environment;

    public Parser(Type type, Environment environment) {
        this(type, new SQLPLUSTokenizer(), environment);
    }

    public Parser(Type type, Tokenizer tokenizer, Environment environment) {
        this.tokenizer = tokenizer;
        this.environment = environment;
        StringBuilder errorBuff = new StringBuilder();
        this.rootContainer = new TypeContainer("<root>", Collections.singletonList(type), errorBuff);
        if (errorBuff.length() > 0) {
            throw new IllegalArgumentException(errorBuff.toString());
        }
    }

    public Optional<ParsedCommand> parse(String command, Consumer<String> errorConsumer) {
        ParsedCommandImpl parsedCommand;
        if (command == null) {
            throw new IllegalArgumentException("command may not be null or empty");
        }
        if (errorConsumer == null) {
            throw new IllegalArgumentException("errorConsumer may not be null");
        }
        if (!command.isEmpty() && (parsedCommand = new ParsedCommandImpl(command, errorConsumer, null)).parse()) {
            return Optional.of(parsedCommand);
        }
        return Optional.empty();
    }

    public Collection<Completion> getCompletions(String command) {
        if (command == null) {
            throw new IllegalArgumentException("command may not be null or empty");
        }
        ArrayList<Completion> result = new ArrayList<Completion>();
        ArrayList errors = new ArrayList();
        ArrayList<String> completions = new ArrayList<String>();
        if (!command.isEmpty()) {
            ParsedCommandImpl parsedCommand = new ParsedCommandImpl(command, errors::add, completions);
            String prefix = this.computeCompletionPrefix(parsedCommand.getTokens());
            parsedCommand.parse();
            for (String completion : completions) {
                result.add(new CompletionImpl(completion, prefix + completion));
            }
            StringBuilder buff = new StringBuilder();
            buff.append("\n|").append(command).append("|\n|").append(prefix).append("|\n").append(completions);
        }
        return result;
    }

    private String computeCompletionPrefix(List<Token> tokens) {
        Token token;
        if (tokens.isEmpty()) {
            return "";
        }
        Token lastToken = tokens.get(tokens.size() - 1);
        if (lastToken.getEnd() < lastToken.getLine().length()) {
            return "";
        }
        StringBuilder buff = new StringBuilder();
        Token nextToken = lastToken;
        for (int t = tokens.size() - 2; t >= 0 && (token = tokens.get(t)).getEnd() == nextToken.getStart(); --t) {
            buff.insert(0, token.getRawValue());
            nextToken = token;
        }
        return buff.toString();
    }

    private String idMapToString(Map<String, ?> idMap) {
        TreeMap sortedIdMap = new TreeMap(idMap);
        StringBuilder sb = new StringBuilder();
        sb.append("\n  [\n");
        for (String id : sortedIdMap.keySet()) {
            Object value = sortedIdMap.get(id);
            sb.append("    ").append(id).append(" -> ").append(value != null ? value.toString() : "").append("\n");
        }
        sb.append("  ]");
        return sb.toString();
    }

    private String objectToString(Object object) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n  [\n");
        if (object != null) {
            sb.append("    ").append(object);
        }
        sb.append("\n  ]");
        return sb.toString();
    }

    private void addDefinitionError(StringBuilder errorBuff, String message, Object ... args) {
        errorBuff.append(MessageFormat.format(message, args)).append("\n");
    }

    private class TypeNode
    extends TypeContainer {
        Type type;
        Grammar<?> grammar;
        Map<String, Option> optionMap;
        List<Option> options;
        List<Parameter> parameters;

        TypeNode(Type type, StringBuilder errorBuff) {
            super(type.getName(), type.getNestedTypes(), errorBuff);
            this.optionMap = new HashMap<String, Option>();
            this.options = new ArrayList<Option>();
            this.parameters = new ArrayList<Parameter>();
            this.type = type;
            if (type.isBase()) {
                if (type.getNestedTypes().isEmpty()) {
                    Parser.this.addDefinitionError(errorBuff, "leaf type may not be base: {0}", type.getName());
                }
                if (!type.getOptions().isEmpty() || !type.getParameters().isEmpty()) {
                    Parser.this.addDefinitionError(errorBuff, "base type may not contain either options or attributes: {0}", type.getName());
                }
            }
            HashSet<String> attributeSynonymSet = new HashSet<String>();
            for (Option<?> option : type.getOptions()) {
                if (option.isRequired() && option.getDefaultValue() != null) {
                    Parser.this.addDefinitionError(errorBuff, "required option may not have a default value: {0}", option.getName());
                }
                for (String synonym : option.getSynonyms().get()) {
                    if (!attributeSynonymSet.add(synonym)) {
                        Parser.this.addDefinitionError(errorBuff, "duplicate attribute synonym ''{0}'' in type ''{1}''", synonym, type.getName());
                    }
                    this.optionMap.put(synonym, option);
                }
                this.options.add(option);
            }
            this.grammar = type.getGrammar();
            int paramCount = type.getParameters().size();
            boolean optionalParam = false;
            for (int p = 0; p < paramCount; ++p) {
                String parameterName;
                Parameter<?> parameter = type.getParameters().get(p);
                if (parameter.isRequired() && parameter.getDefaultValue() != null) {
                    Parser.this.addDefinitionError(errorBuff, "required parameter may not have a default value: {0}", parameter.getName());
                }
                if (!attributeSynonymSet.add(parameterName = parameter.getName().toUpperCase())) {
                    Parser.this.addDefinitionError(errorBuff, "duplicate attribute synonym ''{0}'' in type ''{1}''", parameterName, type.getName());
                }
                if (optionalParam) {
                    if (parameter.isRequired()) {
                        Parser.this.addDefinitionError(errorBuff, "parameters following an optional parameter must also be optional: ''{0}'' in type ''{1}''", parameter.getName(), type.getName());
                    }
                } else if (!parameter.isRequired()) {
                    optionalParam = true;
                }
                this.parameters.add(parameter);
            }
            if (optionalParam && this.grammar != null && this.grammar.isRequired()) {
                Parser.this.addDefinitionError(errorBuff, "remainder must be optional is there are optional parameters: in type ''{1}''", type.getName());
            }
        }
    }

    private class TypeContainer {
        String containerName;
        Map<String, TypeNode> typeMap = new HashMap<String, TypeNode>();

        TypeContainer(String containerName, List<Type> types, StringBuilder errorBuff) {
            this.containerName = containerName.toUpperCase();
            for (Type type : types) {
                TypeNode nestedTypeNode = new TypeNode(type, errorBuff);
                for (String synonym : type.getSynonyms().get()) {
                    if (this.typeMap.put(synonym, nestedTypeNode) == null) continue;
                    Parser.this.addDefinitionError(errorBuff, "duplicate type synonym for {0}: {1}", containerName, synonym);
                }
            }
        }
    }

    private class ParsedCommandImpl
    implements ParsedCommand {
        private final String command;
        private final Consumer<String> errorConsumer;
        private final Collection<String> completions;
        private final Set<String> flagsSet = new HashSet<String>();
        private final Map<String, Object> optionValuesMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        private final Map<String, Object> parameterValuesMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        private final List<Token> tokens;
        private Object grammarValue;
        private String path;
        private TypeNode typeNode;
        private boolean hasErrors;

        ParsedCommandImpl(String command, Consumer<String> errorConsumer, Collection<String> completions) {
            this.command = command;
            this.errorConsumer = errorConsumer;
            this.completions = completions;
            this.tokens = Collections.unmodifiableList(Parser.this.tokenizer.tokenize(command, Parser.this.environment.getLocale(), errorConsumer));
        }

        @Override
        public String getCommand() {
            return this.command;
        }

        @Override
        public List<Token> getTokens() {
            return this.tokens;
        }

        @Override
        public Map<String, Object> getOptions() {
            return this.optionValuesMap;
        }

        @Override
        public Map<String, Object> getParameters() {
            return this.parameterValuesMap;
        }

        @Override
        public Type getType() {
            return this.typeNode.type;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public boolean isFlagSet(Id flagId) {
            Option option = this.typeNode.optionMap.get(flagId.getName());
            if (option != null && option.isFlag()) {
                return this.flagsSet.contains(flagId.toString());
            }
            throw new IllegalArgumentException("no such flag: " + flagId);
        }

        @Override
        public <T> T getOptionValue(Id optionId) {
            if (this.optionValuesMap.containsKey(optionId.toString())) {
                return (T)this.optionValuesMap.get(optionId.toString());
            }
            throw new IllegalArgumentException("no such option: " + optionId);
        }

        @Override
        public Boolean clearOptionValue(Id optionId) {
            if (this.optionValuesMap.containsKey(optionId.toString())) {
                this.optionValuesMap.remove(optionId.toString());
                return this.optionValuesMap.containsKey(optionId.toString());
            }
            throw new IllegalArgumentException("no such option: " + optionId);
        }

        @Override
        public <T> T getParameterValue(Id parameterId) {
            if (this.parameterValuesMap.containsKey(parameterId.toString())) {
                return (T)this.parameterValuesMap.get(parameterId.toString());
            }
            throw new IllegalArgumentException("no such parameter: " + parameterId);
        }

        @Override
        public <T> T getGrammarValue() {
            return (T)this.grammarValue;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.path);
            sb.append("\nOptions:").append(Parser.this.idMapToString(this.optionValuesMap));
            sb.append("\nParameters:").append(Parser.this.idMapToString(this.parameterValuesMap));
            sb.append("\nGrammar:").append(Parser.this.objectToString(this.grammarValue));
            return sb.toString();
        }

        /*
         * WARNING - void declaration
         */
        private boolean parse() {
            int tokenNo = 0;
            if (this.tokens.isEmpty()) {
                return false;
            }
            int numTokens = this.tokens.size();
            String line = this.tokens.get(numTokens - 1).getLine();
            int lineLength = line.length();
            boolean hasTrailingWhiteSpace = this.tokens.get(numTokens - 1).getEnd() < lineLength;
            ArrayList<String> pathNames = new ArrayList<String>();
            TypeContainer container = Parser.this.rootContainer;
            boolean foundCommand = false;
            while (!foundCommand) {
                Token token = this.tokens.get(tokenNo);
                if (token.getType() == Token.Type.SYMBOL) {
                    TypeNode nestedTypeNode = container.typeMap.get(token.getValue().toUpperCase());
                    if (nestedTypeNode != null) {
                        pathNames.add(nestedTypeNode.containerName);
                        this.typeNode = nestedTypeNode;
                        container = this.typeNode;
                        foundCommand = ++tokenNo >= this.tokens.size();
                        continue;
                    }
                    foundCommand = true;
                    continue;
                }
                foundCommand = true;
            }
            if (this.typeNode == null) {
                this.reportSyntaxError(tokenNo < this.tokens.size() ? this.tokens.get(tokenNo) : null, Messages.Key.UNRECOGNIZED_COMMAND);
            } else {
                if (this.completions != null) {
                    if (hasTrailingWhiteSpace) {
                        if (tokenNo == numTokens) {
                            for (Type nestedType : this.typeNode.type.getNestedTypes()) {
                                this.completions.add(nestedType.getName().toLowerCase());
                            }
                        }
                    } else if (tokenNo == numTokens) {
                        this.completions.add(this.typeNode.type.getName().toLowerCase());
                    } else if (tokenNo == numTokens - 1) {
                        for (Type nestedType : this.typeNode.type.getNestedTypes()) {
                            if (!nestedType.getSynonyms().startsWith(this.tokens.get(tokenNo).getValue())) continue;
                            this.completions.add(nestedType.getName().toLowerCase());
                        }
                    }
                }
                if (this.typeNode.type.isBase()) {
                    this.reportSyntaxError(tokenNo < this.tokens.size() ? this.tokens.get(tokenNo) : null, MessageFormat.format(Messages.getString(Messages.Key.BASE_COMMAND, Parser.this.environment.getLocale()), String.join((CharSequence)" ", pathNames).toLowerCase()));
                }
            }
            if (!this.hasErrors) {
                String parameterId;
                this.path = String.join((CharSequence)"/", pathNames) + "/";
                HashMap<String, Object> transformedOptionsMap = new HashMap<String, Object>();
                HashMap<String, Object> transformedParametersMap = new HashMap<String, Object>();
                int paramCount = 0;
                List<Token> remainderTokens = null;
                boolean lastTokenIsHyphen = false;
                boolean hasSemanticCompletions = false;
                while (tokenNo < this.tokens.size()) {
                    String rawValue;
                    Token token = this.tokens.get(tokenNo++);
                    String string = token.getValue();
                    if (token.getType() == Token.Type.SYMBOL && string.startsWith("-")) {
                        if (string.length() < 2) {
                            lastTokenIsHyphen = tokenNo == this.tokens.size();
                            continue;
                        }
                        String rawItemName = string.substring(1);
                        Option option = this.typeNode.optionMap.get(rawItemName.toUpperCase());
                        if (option != null) {
                            if (this.completions != null && tokenNo == this.tokens.size() && !this.hasErrors && !hasTrailingWhiteSpace) {
                                this.completions.add("-" + option.getName().toLowerCase());
                            }
                            Object firstOptionValueToken = null;
                            TokenBlob tokenBlob = null;
                            if (option.isFlag()) {
                                rawValue = "true";
                            } else if (tokenNo < this.tokens.size()) {
                                Token trialToken = this.tokens.get(tokenNo);
                                if (("=".equals(trialToken.getValue()) || ":".equals(trialToken.getValue())) && ++tokenNo == this.tokens.size() && this.completions != null && !hasTrailingWhiteSpace) {
                                    this.completions.add(trialToken.getValue());
                                }
                                if (tokenNo < this.tokens.size()) {
                                    tokenBlob = new TokenBlob(this.tokens, tokenNo);
                                    firstOptionValueToken = this.tokens.get(tokenNo);
                                    tokenNo = tokenBlob.getNextTokenNo();
                                }
                                rawValue = !(firstOptionValueToken == null || firstOptionValueToken.getType() != Token.Type.LITERAL && firstOptionValueToken.getValue().startsWith("-")) ? (tokenBlob != null ? tokenBlob.getBlobValue() : null) : "";
                            } else {
                                rawValue = hasTrailingWhiteSpace ? "" : null;
                            }
                            Object transformedValue = null;
                            if (rawValue != null) {
                                transformedValue = this.completions != null && tokenNo == this.tokens.size() && !this.hasErrors && (rawValue.isEmpty() && hasTrailingWhiteSpace || !rawValue.isEmpty() && !hasTrailingWhiteSpace) ? this.transform(option, (Token)firstOptionValueToken, rawValue, true) : this.transform(option, (Token)firstOptionValueToken, rawValue, false);
                            }
                            if (this.completions != null && tokenNo == this.tokens.size() && (!hasTrailingWhiteSpace || rawValue == null || rawValue.isEmpty())) {
                                List<SemanticCompleter> completers = option.getSemanticCompleters();
                                LinkedList<CompletionItem> suggestions = new LinkedList<CompletionItem>();
                                for (SemanticCompleter completer : completers) {
                                    suggestions.addAll(completer.complete(rawValue, Parser.this.environment.getCtx(), transformedOptionsMap));
                                }
                                if (0 < suggestions.size()) {
                                    this.completions.clear();
                                }
                                for (CompletionItem ci : suggestions) {
                                    this.completions.add(ci.entry);
                                    hasSemanticCompletions = true;
                                }
                            }
                            if ((rawValue == null || rawValue.isEmpty()) && !hasSemanticCompletions) {
                                this.reportSyntaxError(token, Messages.Key.MISSING_OPTION_VALUE);
                            }
                            transformedOptionsMap.put(option.getId().toString(), transformedValue);
                            continue;
                        }
                        if (this.completions != null && tokenNo == this.tokens.size() && !this.hasErrors && !hasTrailingWhiteSpace) {
                            String anyOptionName = string.substring(1);
                            for (Option anyOption : this.typeNode.options) {
                                if (!anyOption.getSynonyms().startsWith(anyOptionName)) continue;
                                this.completions.add("-" + anyOption.getName().toLowerCase());
                            }
                        }
                        this.reportSyntaxError(token, Messages.Key.UNRECOGNIZED_OPTION);
                        continue;
                    }
                    if (this.typeNode.parameters.size() > paramCount) {
                        Parameter parameter = this.typeNode.parameters.get(paramCount++);
                        TokenBlob tokenBlob = new TokenBlob(this.tokens, tokenNo - 1);
                        rawValue = tokenBlob.getBlobValue();
                        tokenNo = tokenBlob.getNextTokenNo();
                        Object transformedValue = this.completions != null && tokenNo == this.tokens.size() && !this.hasErrors && !hasTrailingWhiteSpace ? this.transform(parameter, token, rawValue, true) : this.transform(parameter, token, rawValue, false);
                        transformedParametersMap.put(parameter.getId().toString(), transformedValue);
                        continue;
                    }
                    if (this.typeNode.grammar != null) {
                        remainderTokens = this.tokens.subList(tokenNo - 1, this.tokens.size());
                        tokenNo = this.tokens.size();
                        continue;
                    }
                    this.reportSyntaxError(token, Messages.Key.UNEXPECTED_TOKEN);
                }
                for (Option option : this.typeNode.options) {
                    Object value;
                    String optionId = option.getId().toString();
                    if (transformedOptionsMap.containsKey(optionId)) {
                        Object value2 = transformedOptionsMap.get(optionId);
                        if (option.isFlag()) {
                            this.flagsSet.add(optionId);
                        }
                    } else {
                        String optionName = option.getName();
                        if (this.completions != null && !this.hasErrors && !hasSemanticCompletions) {
                            if (hasTrailingWhiteSpace) {
                                if (remainderTokens == null && !lastTokenIsHyphen) {
                                    this.completions.add("-" + optionName.toLowerCase());
                                }
                            } else if (lastTokenIsHyphen) {
                                this.completions.add("-" + optionName.toLowerCase());
                            }
                        }
                        value = option.getDefaultValue();
                    }
                    if (value != null && !option.getDataType().isAssignableFrom(value.getClass())) {
                        throw new IllegalArgumentException("transformed value has type that is inconsistent with the type of option with name " + option.getName());
                    }
                    this.optionValuesMap.put(optionId, value);
                }
                if (lastTokenIsHyphen) {
                    this.reportSyntaxError(this.tokens.get(this.tokens.size() - 1), Messages.Key.ZERO_LENGTH_OPTION);
                }
                Attribute firstUnspecifiedParameter = null;
                for (Parameter parameter : this.typeNode.parameters) {
                    Object value;
                    parameterId = parameter.getId().toString();
                    if (transformedParametersMap.containsKey(parameterId)) {
                        Object value3 = transformedParametersMap.get(parameterId);
                    } else {
                        if (firstUnspecifiedParameter == null) {
                            firstUnspecifiedParameter = parameter;
                        }
                        value = parameter.getDefaultValue();
                    }
                    if (value != null && !parameter.getDataType().isAssignableFrom(value.getClass())) {
                        throw new IllegalArgumentException("transformed value has type that is inconsistent with the type of parameter with name " + parameter.getName());
                    }
                    this.parameterValuesMap.put(parameterId, value);
                }
                if (firstUnspecifiedParameter != null && this.completions != null && !this.hasErrors && remainderTokens == null && hasTrailingWhiteSpace) {
                    firstUnspecifiedParameter.getTransformer().transform("", new TransformContextImpl(null, this.completions::add), Parser.this.environment);
                }
                for (Option option : this.typeNode.options) {
                    String optionId = option.getId().toString();
                    if (!option.isRequired() || transformedOptionsMap.containsKey(optionId)) continue;
                    this.reportSemanticError(Messages.Key.REQUIRED_OPTION, option.getName());
                }
                for (Parameter parameter : this.typeNode.parameters) {
                    parameterId = parameter.getId().toString();
                    if (!parameter.isRequired() || transformedParametersMap.containsKey(parameterId)) continue;
                    this.reportSemanticError(Messages.Key.REQUIRED_PARAMETER, parameter.getName());
                }
                if (this.typeNode.grammar != null) {
                    if (firstUnspecifiedParameter == null) {
                        void var16_25;
                        if (remainderTokens != null) {
                            if (!this.hasErrors) {
                                Object object = this.parseGrammar(this.typeNode.grammar, remainderTokens, this::reportError, this::addCompletion);
                            } else {
                                Object object = this.parseGrammar(this.typeNode.grammar, remainderTokens, this::reportError, completion -> {});
                            }
                        } else {
                            if (hasTrailingWhiteSpace && !this.hasErrors) {
                                this.parseGrammar(this.typeNode.grammar, Collections.EMPTY_LIST, error -> {}, this::addCompletion);
                            }
                            Object obj = this.typeNode.grammar.getDefaultValue();
                            if (this.typeNode.grammar.isRequired()) {
                                this.reportSemanticError(Messages.Key.MISSING_TOKEN, this.typeNode.type.getName());
                            }
                        }
                        if (var16_25 != null && !this.typeNode.grammar.getDataType().isAssignableFrom(var16_25.getClass())) {
                            throw new IllegalArgumentException("transformed value has type '" + var16_25.getClass().getSimpleName() + " ' inconsistent with the grammar type '" + this.typeNode.grammar.getDataType().getSimpleName());
                        }
                        this.grammarValue = var16_25;
                    } else if (this.typeNode.grammar.isRequired()) {
                        this.reportSemanticError(Messages.Key.MISSING_TOKEN, this.typeNode.type.getName());
                    }
                }
            }
            return !this.hasErrors;
        }

        private Object parseGrammar(Grammar grammar, List<Token> tokens, Consumer<String> errorConsumer, Consumer<String> completionConsumer) {
            Object value = null;
            Node node = grammar.parse(tokens, Parser.this.environment);
            if (node.isMatched()) {
                value = node.getFirstChild().getValue();
            } else {
                errorConsumer.accept(node.getParseError().getMessage());
                for (SemanticError semanticError : node.getSemanticErrors()) {
                    errorConsumer.accept(semanticError.getMessage());
                }
            }
            for (String completion : node.getCompletions()) {
                completionConsumer.accept(completion);
            }
            return value;
        }

        private Object transform(Attribute<?> attribute, Token token, String rawValue, boolean keepCompletions) {
            ArrayList errors = new ArrayList();
            Object value = attribute.getTransformer().transform(rawValue, new TransformContextImpl(errors::add, keepCompletions ? this.completions::add : null), Parser.this.environment);
            if (!errors.isEmpty()) {
                String detailMessage = "  " + String.join((CharSequence)"\n  ", errors);
                this.reportError(MessageFormat.format(Messages.getString(Messages.Key.FORMAT_ERROR, Parser.this.environment.getLocale()), rawValue, token != null ? token.getStart() : this.command.length(), attribute.getSyntax().get(), detailMessage));
            }
            return value;
        }

        private void reportSemanticError(Messages.Key cause, Object ... args) {
            this.reportError(MessageFormat.format(Messages.getString(cause, Parser.this.environment.getLocale()), args));
        }

        private void reportSyntaxError(Token token, Messages.Key cause) {
            this.reportSyntaxError(token, Messages.getString(cause, Parser.this.environment.getLocale()));
        }

        private void reportSyntaxError(Token token, String message) {
            this.reportError(MessageFormat.format(Messages.getString(Messages.Key.SYNTAX_ERROR, Parser.this.environment.getLocale()), token != null ? token.getRawValue() : "<eol>", token != null ? token.getStart() : this.command.length(), message));
        }

        private void reportError(String message) {
            this.errorConsumer.accept(message);
            this.hasErrors = true;
        }

        private void addCompletion(String completion) {
            if (this.completions != null) {
                this.completions.add(completion);
            }
        }
    }

    private static class TokenBlob {
        private final int nextTokenNo;
        private final String blobValue;

        TokenBlob(List<Token> tokens, int startTokenNo) {
            if (startTokenNo < tokens.size()) {
                int tokenNo;
                Token token = tokens.get(startTokenNo);
                StringBuilder buff = new StringBuilder(token.getValue());
                for (tokenNo = startTokenNo + 1; tokenNo < tokens.size(); ++tokenNo) {
                    int end = token.getEnd();
                    token = tokens.get(tokenNo);
                    if (token.getStart() != end) break;
                    buff.append(token.getValue());
                }
                this.nextTokenNo = tokenNo;
                this.blobValue = buff.toString();
            } else {
                this.nextTokenNo = startTokenNo;
                this.blobValue = null;
            }
        }

        int getNextTokenNo() {
            return this.nextTokenNo;
        }

        String getBlobValue() {
            return this.blobValue;
        }
    }

    private static class CompletionImpl
    implements Completion {
        private final String displayValue;
        private final String replacementValue;

        CompletionImpl(String displayValue, String replacementValue) {
            this.displayValue = displayValue;
            this.replacementValue = replacementValue;
        }

        @Override
        public String getDisplayValue() {
            return this.displayValue;
        }

        @Override
        public String getReplacementValue() {
            return this.replacementValue;
        }
    }
}

