/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.SetServerOutput;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.NONE)
public class ShowServeroutput
implements IShowCommand {
    private static final String[] SHOWSERVEROUTPUT = new String[]{"serverout", "serveroutp", "serveroutpu", "serveroutput"};

    @Override
    public String[] getShowAliases() {
        return SHOWSERVEROUTPUT;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.doShowServeroutput(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    public boolean doShowServeroutput(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Boolean isServerOutputOn = (Boolean)ctx.getProperty("script.runner.context.serveroutput");
        Integer size = (Integer)ctx.getProperty("script.runner.lastsetserveroutput");
        String addOptimized = "";
        if (ctx.getProperty("sqlcl.serveroutput.optimized") != null) {
            addOptimized = " OPTIMIZED";
        }
        if (isServerOutputOn != null && isServerOutputOn.equals(Boolean.TRUE)) {
            Boolean wasUnlimited = (Boolean)ctx.getProperty("script.runner.serveroutputunlimited");
            if (wasUnlimited != null && wasUnlimited.equals(Boolean.TRUE)) {
                ctx.write("serveroutput ON SIZE UNLIMITED " + SetServerOutput.serverOutputFormatToString(ctx) + addOptimized + "\n");
            } else {
                ctx.write("serveroutput ON SIZE " + size + " " + SetServerOutput.serverOutputFormatToString(ctx) + addOptimized + "\n");
            }
        } else {
            ctx.write("serveroutput OFF" + addOptimized + "\n");
        }
        return true;
    }
}

