/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.SetColInvisble;
import oracle.dbtools.raptor.newscriptrunner.commands.SetLoad;
import oracle.dbtools.raptor.newscriptrunner.commands.SetLoadFormat;
import oracle.dbtools.raptor.newscriptrunner.commands.ShowErrors;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IEndOfShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IParsedShow;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowAllNeither;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowNoRows;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixName;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowAppicmd;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowArraycmd;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowAutocommit;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowAutoprint;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowAutorecovery;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowAutotrace;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowBinds;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowBlockTerminator;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowBtitle;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowBuffer;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowColsep;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowCommandLine;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowConcat;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowConname;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowConnection;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowCopyc;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowDefine;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowDefines;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowDescribe;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowEcho;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowEdition;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowEncodings;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowErrorLogging;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowEscape;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowFeedback;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowHeading;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowHeadsep;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowInstance;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowInternalErrors;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowJava;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowJdbc;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowLNo;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowLinesize;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowLocale;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowLong;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowNewPage;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowNls;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowNull;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowNumformat;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowNumwidth;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowObsolete;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowPDBS;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowPNo;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowPagesize;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowParameter;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowPause;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowPrelim;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowRecyclebin;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowRelease;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowSQLBlankLines;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowScan;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowServeroutput;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowSga;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowShowMode;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowSpace;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowSpool;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowSpparameter;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowSqlcode;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowSqldev;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowSqldev2;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowSqlprompt;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowSuffix;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowSystemOut;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowTermout;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowTimingout;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowTopLevel;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowTrimout;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowTrimspool;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowTtitle;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowUFI;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowURLs;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowUsercmd;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowVerify;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowWrap;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowXMLOptimizationCheck;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowXquery;
import oracle.dbtools.raptor.newscriptrunner.commands.show.Show_Restrict;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.CopyNumberToFloat;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowAutoRecovery;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowCmdSep;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowCopyTypeCheck;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowEndBufT;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowEndBufToken;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowFlagger;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowLobOffSet;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowLongChunkSize;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowRecSep;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowRecSepChar;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowRepfooter;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowRepheader;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowSQLNumber;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowSecuredCol;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowUnderLine;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.ShowXMLOptimization;
import oracle.dbtools.raptor.newscriptrunner.commands.show.unsupported.Show_ShowRowShip;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.newscriptrunner.restricted.RunnerRestrictedLevel;

public class ShowRegistry {
    private static ConcurrentHashMap<String, IShowCommand> s_registry = new ConcurrentHashMap();
    private static boolean _init = true;
    private static HashSet<String> showAll = new HashSet();
    private static HashSet<String> showAllExtended = new HashSet();
    private static HashSet<String> showAllExtendedMultiline = new HashSet();
    private static ConcurrentHashMap<String, String> toFirst = new ConcurrentHashMap();
    private static Set<String> varNames;
    private static boolean showAllDirty;
    private static String showAllPrevious;
    private static String showAllExtendedPrevious;
    private static String showAllExtendedMultilinePrevious;
    private static String first40;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processShowCommand(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ShowRegistry.init();
        String[] parts = null;
        boolean onceTrue = false;
        String all = cmd.getSql();
        all = ScriptUtils.eatOneWord(all);
        if (all != null) {
            parts = all.trim().split("\\s+");
        }
        if (parts[0].toLowerCase().equals("err") || parts[0].toLowerCase().equals("erro") || parts[0].toLowerCase().equals("error") || parts[0].toLowerCase().equals("errors")) {
            return false;
        }
        boolean stopIt = false;
        boolean showAllExtends = false;
        if (all.trim().endsWith("DISPLAYNAME")) {
            showAllExtends = true;
            all = all.substring(0, all.lastIndexOf("DISPLAYNAME"));
        }
        while (!stopIt) {
            boolean alreadyEaten = false;
            if (all != null) {
                parts = all.trim().split("\\s+");
            }
            if (parts == null || parts.length <= 0 || parts[0].equals("")) break;
            IShowCommand show = null;
            if (parts[0].toUpperCase().equals("ALL") || parts[0].toUpperCase().equals("ALL+")) {
                String additional = "";
                HashSet<String> hashSet = showAll;
                synchronized (hashSet) {
                    if (showAllDirty) {
                        StringBuffer showAll = new StringBuffer("");
                        for (String inAll : ShowRegistry.showAllStrings()) {
                            showAll.append(inAll);
                            showAll.append(" ");
                        }
                        showAllPrevious = showAll.toString();
                        StringBuffer showAllExtended = new StringBuffer("");
                        for (String inAll : ShowRegistry.showAllExtendedStrings()) {
                            showAllExtended.append(inAll);
                            showAllExtended.append(" ");
                        }
                        showAllExtendedPrevious = showAllExtended.toString();
                        StringBuffer showAllExtendedMultiline = new StringBuffer("");
                        for (String inAll : ShowRegistry.showAllExtendedMultilineStrings()) {
                            showAllExtendedMultiline.append(inAll);
                            showAllExtendedMultiline.append(" ");
                        }
                        showAllExtendedMultilinePrevious = showAllExtendedMultiline.toString();
                    }
                    showAllDirty = false;
                }
                additional = ScriptUtils.eatOneWord(all);
                if (parts[0].toUpperCase().equals("ALL+")) {
                    ctx.write("Show All:\n" + first40 + "\n");
                }
                cmd.setSql("show " + showAllPrevious);
                if (ShowRegistry.processShowCommand(conn, ctx, cmd)) {
                    onceTrue = true;
                }
                if (parts[0].toUpperCase().equals("ALL+")) {
                    ctx.write("\nShow All+ " + Messages.getString("SINGLE_LINE") + ":\n" + first40 + "\n");
                    cmd.setSql("show " + showAllExtendedPrevious + " DISPLAYNAME");
                    if (ShowRegistry.processShowCommand(conn, ctx, cmd)) {
                        onceTrue = true;
                    }
                    ctx.write("\nShow All+ " + Messages.getString("MULTI_LINE") + ":\n" + first40 + "\n");
                    cmd.setSql("show " + showAllExtendedMultilinePrevious + " DISPLAYNAME");
                    if (ShowRegistry.processShowCommand(conn, ctx, cmd)) {
                        onceTrue = true;
                    }
                    ctx.write("\n");
                }
                all = additional;
                continue;
            }
            String first = toFirst.get(parts[0].toUpperCase());
            if (first != null) {
                try {
                    show = ShowRegistry.getShowCommand(first.toUpperCase(), ctx.getRestrictedLevel());
                }
                catch (RestrictedCommandException rce) {
                    String[] origParts = cmd.getSQLOrig().split("\\s+");
                    if (origParts.length < 2 || !origParts[1].equalsIgnoreCase("ALL")) {
                        ctx.write(ScriptRunnerDbArb.format("RESTRICTED_COMMAND", "SHOW " + first.toUpperCase()));
                    }
                    all = ScriptUtils.eatOneWord(all);
                    continue;
                }
            }
            cmd.setSql("show " + all);
            if (show != null) {
                if (showAllExtends && (show instanceof ShowUFI || show instanceof ShowSqldev || show instanceof ShowErrors || show instanceof ShowSqldev2)) {
                    all = ScriptUtils.eatOneWord(all);
                    continue;
                }
                if (show instanceof IEndOfShowCommand) {
                    if (showAllExtends) {
                        all = ScriptUtils.eatOneWord(all);
                        continue;
                    }
                    stopIt = true;
                }
                if (showAllExtends) {
                    if (show instanceof IShowPrefixName) {
                        ctx.write(parts[0] + " ");
                    } else if (show instanceof IShowPrefixNameNewline) {
                        if (show instanceof ShowSga) {
                            ctx.write("\n" + parts[0] + ":\n" + first40);
                        } else {
                            String header = "\n" + parts[0] + ":\n" + first40 + "\n";
                            if (show instanceof IShowNoRows) {
                                ctx.putProperty("script.runner.optional_show_header", header);
                            } else {
                                ctx.write(header);
                            }
                        }
                    }
                }
                if (show.needsDatabase() && ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
                    ctx.write(ScriptRunnerDbArb.getString("NOT_CONNECTED") + "\n");
                    onceTrue = true;
                    alreadyEaten = false;
                } else if (show instanceof IParsedShow) {
                    String rest = ((IParsedShow)((Object)show)).handleShowRemainder(conn, ctx, cmd);
                    if (rest != null) {
                        all = rest;
                        alreadyEaten = true;
                        onceTrue = true;
                    }
                } else if (show.handleShow(conn, ctx, cmd)) {
                    alreadyEaten = false;
                    onceTrue = true;
                }
            } else if (all.toLowerCase().startsWith("sqlco")) {
                if (ShowObsolete.doObsolete(conn, ctx, cmd)) {
                    onceTrue = true;
                }
            } else {
                Object fail = parts[0];
                if (((String)fail).length() > 10) {
                    fail = ((String)fail).substring(0, 10) + "...";
                    ctx.write(MessageFormat.format(Messages.getString("SHOWUNKNOWNOPTION_BEGINNING"), fail));
                } else {
                    ctx.write(MessageFormat.format(Messages.getString("SHOWUNKNOWNOPTION"), fail));
                }
                cmd.setFail();
                try {
                    ctx.getOutputStream().flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ctx.putProperty("script.runner.optional_show_header", null);
            if (alreadyEaten) continue;
            all = ScriptUtils.eatOneWord(all);
        }
        return onceTrue;
    }

    private static IShowCommand getShowCommand(String showCommandName, RunnerRestrictedLevel.Level runnerRestrictedLevel) throws RestrictedCommandException {
        IShowCommand showCommand = s_registry.get(showCommandName);
        if (runnerRestrictedLevel == RunnerRestrictedLevel.Level.NONE) {
            return showCommand;
        }
        Restricted.Level level = Restricted.Level.R4;
        if (showCommand != null && showCommand.getClass().getAnnotation(Restricted.class) != null) {
            level = showCommand.getClass().getAnnotation(Restricted.class).level();
        }
        if (runnerRestrictedLevel.isRestricted(level)) {
            throw new RestrictedCommandException();
        }
        return showCommand;
    }

    public static Set<String> getShowNames() {
        if (varNames == null) {
            ShowRegistry.init();
        }
        return varNames;
    }

    private static void init() {
        if (_init) {
            ShowRegistry.put(ShowUFI.class);
            varNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            varNames.addAll(toFirst.keySet());
            _init = false;
        }
    }

    private static void put(Class<? extends IShowCommand> clazz) {
        try {
            IShowCommand show = clazz.newInstance();
            ShowRegistry.register(show);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean get(String command) {
        String[] allStrs = ShowRegistry.showAllStrings();
        List<Object> list = new ArrayList();
        list = Arrays.asList(allStrs);
        return list.contains(command.toUpperCase());
    }

    public static void register(Class<? extends IShowCommand> clazz) {
        ShowRegistry.put(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(IShowCommand ishow) {
        for (String show : ishow.getShowAliases()) {
            toFirst.put(show.toUpperCase(), ishow.getShowAliases()[0].toUpperCase());
        }
        HashSet<String> hashSet = showAll;
        synchronized (hashSet) {
            if (ishow.inShowAll()) {
                showAllDirty = true;
                showAll.add(ishow.getShowAliases()[0].toUpperCase());
            } else if (!(ishow instanceof IShowAllNeither)) {
                showAllDirty = true;
                if (!(ishow instanceof IShowPrefixNameNewline)) {
                    showAllExtended.add(ishow.getShowAliases()[0].toUpperCase());
                } else {
                    showAllExtendedMultiline.add(ishow.getShowAliases()[0].toUpperCase());
                }
            }
        }
        s_registry.put(ishow.getShowAliases()[0].toUpperCase(), ishow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] showAllStrings() {
        String[] retVal = null;
        HashSet<String> hashSet = showAll;
        synchronized (hashSet) {
            ArrayList<String> list = new ArrayList<String>(showAll);
            Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
            retVal = list.toArray(new String[list.size()]);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] showAllExtendedStrings() {
        String[] retVal = null;
        HashSet<String> hashSet = showAll;
        synchronized (hashSet) {
            ArrayList<String> list = new ArrayList<String>(showAllExtended);
            list.add("CON_ID");
            Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
            retVal = list.toArray(new String[list.size()]);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] showAllExtendedMultilineStrings() {
        String[] retVal = null;
        HashSet<String> hashSet = showAll;
        synchronized (hashSet) {
            ArrayList<String> list = new ArrayList<String>(showAllExtendedMultiline);
            Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
            retVal = list.toArray(new String[list.size()]);
        }
        return retVal;
    }

    static {
        showAllDirty = true;
        showAllPrevious = "";
        showAllExtendedPrevious = "";
        showAllExtendedMultilinePrevious = "";
        first40 = "================================================================================".substring(0, 40);
        ShowRegistry.put(SetColInvisble.class);
        ShowRegistry.put(SetLoad.class);
        ShowRegistry.put(SetLoadFormat.class);
        ShowRegistry.put(CopyNumberToFloat.class);
        ShowRegistry.put(ShowAppicmd.class);
        ShowRegistry.put(ShowArraycmd.class);
        ShowRegistry.put(ShowAutoRecovery.class);
        ShowRegistry.put(ShowAutocommit.class);
        ShowRegistry.put(ShowAutoprint.class);
        ShowRegistry.put(ShowAutorecovery.class);
        ShowRegistry.put(ShowAutotrace.class);
        ShowRegistry.put(ShowBinds.class);
        ShowRegistry.put(ShowBlockTerminator.class);
        ShowRegistry.put(ShowJava.class);
        ShowRegistry.put(ShowLocale.class);
        ShowRegistry.put(ShowBtitle.class);
        ShowRegistry.put(ShowBuffer.class);
        ShowRegistry.put(ShowCmdSep.class);
        ShowRegistry.put(ShowColsep.class);
        ShowRegistry.put(ShowConnection.class);
        ShowRegistry.put(ShowConname.class);
        ShowRegistry.put(ShowCopyTypeCheck.class);
        ShowRegistry.put(ShowCopyc.class);
        ShowRegistry.put(ShowCommandLine.class);
        ShowRegistry.put(ShowDefine.class);
        ShowRegistry.put(ShowDefines.class);
        ShowRegistry.put(ShowDescribe.class);
        ShowRegistry.put(ShowEcho.class);
        ShowRegistry.put(ShowEdition.class);
        ShowRegistry.put(ShowEncodings.class);
        ShowRegistry.put(ShowEndBufT.class);
        ShowRegistry.put(ShowEndBufToken.class);
        ShowRegistry.put(ShowErrorLogging.class);
        ShowRegistry.put(ShowEscape.class);
        ShowRegistry.put(ShowFeedback.class);
        ShowRegistry.put(ShowFlagger.class);
        ShowRegistry.put(ShowHeading.class);
        ShowRegistry.put(ShowHeadsep.class);
        ShowRegistry.put(ShowInternalErrors.class);
        ShowRegistry.put(ShowInstance.class);
        ShowRegistry.put(ShowJdbc.class);
        ShowRegistry.put(ShowLinesize.class);
        ShowRegistry.put(ShowLobOffSet.class);
        ShowRegistry.put(ShowLong.class);
        ShowRegistry.put(ShowLongChunkSize.class);
        ShowRegistry.put(ShowNewPage.class);
        ShowRegistry.put(ShowNls.class);
        ShowRegistry.put(ShowNull.class);
        ShowRegistry.put(ShowConcat.class);
        ShowRegistry.put(ShowNumformat.class);
        ShowRegistry.put(ShowNumwidth.class);
        ShowRegistry.put(ShowObsolete.class);
        ShowRegistry.put(ShowPDBS.class);
        ShowRegistry.put(ShowPagesize.class);
        ShowRegistry.put(ShowParameter.class);
        ShowRegistry.put(ShowPause.class);
        ShowRegistry.put(ShowPrelim.class);
        ShowRegistry.put(ShowShowMode.class);
        ShowRegistry.put(ShowRecSep.class);
        ShowRegistry.put(ShowRecSepChar.class);
        ShowRegistry.put(ShowRepheader.class);
        ShowRegistry.put(ShowRepfooter.class);
        ShowRegistry.put(ShowRecyclebin.class);
        ShowRegistry.put(ShowRelease.class);
        ShowRegistry.put(ShowSQLBlankLines.class);
        ShowRegistry.put(ShowSQLNumber.class);
        ShowRegistry.put(ShowScan.class);
        ShowRegistry.put(ShowSecuredCol.class);
        ShowRegistry.put(ShowServeroutput.class);
        ShowRegistry.put(ShowSga.class);
        ShowRegistry.put(ShowShowMode.class);
        ShowRegistry.put(ShowSpace.class);
        ShowRegistry.put(ShowSpool.class);
        ShowRegistry.put(ShowSpparameter.class);
        ShowRegistry.put(ShowSqlcode.class);
        ShowRegistry.put(ShowSqldev.class);
        ShowRegistry.put(ShowSqldev2.class);
        ShowRegistry.put(ShowSqlprompt.class);
        ShowRegistry.put(ShowSuffix.class);
        ShowRegistry.put(ShowSystemOut.class);
        ShowRegistry.put(ShowTermout.class);
        ShowRegistry.put(ShowTimingout.class);
        ShowRegistry.put(ShowTrimout.class);
        ShowRegistry.put(ShowTrimspool.class);
        ShowRegistry.put(ShowTtitle.class);
        ShowRegistry.put(ShowURLs.class);
        ShowRegistry.put(ShowUnderLine.class);
        ShowRegistry.put(ShowUsercmd.class);
        ShowRegistry.put(ShowVerify.class);
        ShowRegistry.put(ShowWrap.class);
        ShowRegistry.put(ShowXMLOptimization.class);
        ShowRegistry.put(ShowXMLOptimizationCheck.class);
        ShowRegistry.put(ShowXquery.class);
        ShowRegistry.put(Show_Restrict.class);
        ShowRegistry.put(Show_ShowRowShip.class);
        ShowRegistry.put(ShowLNo.class);
        ShowRegistry.put(ShowPNo.class);
        ShowRegistry.put(ShowBinds.class);
        ShowRegistry.put(ShowTopLevel.class);
    }

    private static class RestrictedCommandException
    extends Exception {
        private RestrictedCommandException() {
        }
    }
}

