/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowAllNeither;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.NONE)
public class ShowObsolete
implements IShowCommand,
IShowAllNeither {
    private static final String[] SHOWOBSOLETE = new String[]{"sqlc", "sqlco", "sqlcon", "sqlcont", "sqlconti", "sqlcontin", "sqlcontinu", "sqlcontinue", "flu", "flus", "flush", "doc", "docu", "docum", "docume", "documen", "document", "maxd", "maxda", "maxdat", "maxdata", "sqlpre", "sqlpref", "sqlprefi", "sqlprefix", "label", "_ociclientversion", "cmds", "cmdse", "cmdsep", "tab", "escchar", "desc", "descr", "describe"};

    @Override
    public String[] getShowAliases() {
        return SHOWOBSOLETE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return ShowObsolete.doObsolete(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    public static boolean doObsolete(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String shoAndShow = cmd.getSql().trim().toLowerCase().replaceAll("^show?\\s+", "");
        StringTokenizer st = new StringTokenizer(shoAndShow);
        String token = "";
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            ctx.write(MessageFormat.format("show {0} is obsolete.\n", token));
        }
        return true;
    }
}

