/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ShowJava
implements IShowCommand {
    @Override
    public String[] getShowAliases() {
        return new String[]{"java"};
    }

    private void print(ScriptRunnerContext ctx, String val) {
        ctx.write(ScriptUtils.wordwrapNotXml(1, (Integer)ctx.getProperty("script.runner.setlinesize"), new StringBuffer(val)).toString());
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] arr;
        String pad = new String(new char[11]).replace('\u0000', '-');
        ctx.write("Java Detail\n" + pad + "\n");
        this.print(ctx, "java.home= " + System.getProperty("java.home") + "\n");
        this.print(ctx, "java.vendor= " + System.getProperty("java.vendor") + "\n");
        this.print(ctx, "java.vendor.url= " + System.getProperty("java.vendor.url") + "\n");
        this.print(ctx, "java.version= " + System.getProperty("java.version") + "\n");
        int ls = (Integer)ctx.getProperty("script.runner.setlinesize");
        pad = new String(new char[ls]).replace('\u0000', '-');
        ctx.write(pad + "\n");
        this.print(ctx, "os.arch= " + System.getProperty("os.arch") + "\n");
        this.print(ctx, "os.name= " + System.getProperty("os.name") + "\n");
        this.print(ctx, "os.version= " + System.getProperty("os.version") + "\n");
        this.print(ctx, "java.library.path= " + System.getProperty("java.library.path") + "\n");
        this.print(ctx, "path.separator= " + System.getProperty("path.separator") + "\n");
        this.print(ctx, "file.separator= " + System.getProperty("file.separator") + "\n");
        this.print(ctx, "line.separator= " + System.getProperty("line.separator") + "\n");
        this.print(ctx, "user.dir= " + System.getProperty("user.dir") + "\n");
        this.print(ctx, "user.home= " + System.getProperty("user.home") + "\n");
        this.print(ctx, "user.name= " + System.getProperty("user.name") + "\n");
        this.print(ctx, "user.language= " + System.getProperty("user.language") + "\n");
        this.print(ctx, "user.region= " + System.getProperty("user.region") + "\n");
        this.print(ctx, "file.encoding= " + System.getProperty("file.encoding") + "\n");
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        double usedMemory = (double)(totalMemory - freeMemory) / 1048576.0;
        long maxMemory = Runtime.getRuntime().maxMemory();
        double memory = (double)maxMemory / 1048576.0;
        DecimalFormat f = new DecimalFormat("###,##0.0");
        this.print(ctx, "Used memory: " + f.format(usedMemory) + "MB\n");
        this.print(ctx, "Max available memory: " + f.format(memory) + "MB\n");
        ctx.write(pad + "\n");
        String sqlhome = System.getenv("SQL_HOME");
        this.print(ctx, "SQL_HOME=" + sqlhome + "\n");
        if (ctx.getProperty("script.runner.hhtp.proxy.host") != null && !ctx.getProperty("script.runner.hhtp.proxy.host").equals("")) {
            ctx.write(pad + "\n");
            this.print(ctx, "proxy host=" + ctx.getProperty("script.runner.hhtp.proxy.host") + "\n");
            this.print(ctx, "proxy port=" + ctx.getProperty("script.runner.hhtp.proxy.port") + "\n");
            ctx.write(pad + "\n");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Classpath\n");
        String cp = System.getProperty("java.class.path");
        for (String s : arr = cp.split(File.pathSeparator)) {
            try {
                FileInputStream fis;
                JarInputStream jis;
                Manifest manifest;
                if (s.contains(System.getProperty("java.version")) || sqlhome == null || (manifest = (jis = new JarInputStream(fis = new FileInputStream(s))).getManifest()) == null) continue;
                for (Map.Entry<String, Attributes> item : manifest.getEntries().entrySet()) {
                    String sa = item.getKey();
                    if (sa == null || !sa.endsWith("\\.jar")) continue;
                    sb.append(item.getKey());
                }
                sb.append(s + "\n");
            }
            catch (IOException | NullPointerException e) {
                if (!(e instanceof NullPointerException)) continue;
                ctx.write(((NullPointerException)e).getMessage() + "NPE");
            }
        }
        this.print(ctx, sb.toString() + "\n");
        ctx.write(pad + "\n");
        ctx.write(System.getenv("SQL_HOME") + "\n");
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

