/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class SealedString {
    private static Encrypter encrypter;
    private final String encrypted;

    public SealedString(String value) {
        this.encrypted = this.getEncrypter().encrypt(value);
    }

    public String toString() {
        return this.getEncrypter().decrypt(this.encrypted);
    }

    private Encrypter getEncrypter() {
        if (encrypter == null) {
            encrypter = new Encrypter();
        }
        return encrypter;
    }

    private static class Encrypter {
        private static final String ALGORITHM = "AES";
        private final SecretKeySpec keySpec;

        private Encrypter() {
            SecureRandom random = new SecureRandom();
            byte[] key = new byte[16];
            random.nextBytes(key);
            this.keySpec = new SecretKeySpec(key, ALGORITHM);
        }

        private String encrypt(String strToEncrypt) {
            try {
                Cipher cipher = Cipher.getInstance(ALGORITHM);
                cipher.init(1, this.keySpec);
                return Base64.getEncoder().encodeToString(cipher.doFinal(strToEncrypt.getBytes("UTF-8")));
            }
            catch (Exception e) {
                Logger.getLogger(SealedString.class.getName()).severe(e.toString());
                return "";
            }
        }

        private String decrypt(String strToDecrypt) {
            try {
                Cipher cipher = Cipher.getInstance(ALGORITHM);
                cipher.init(2, this.keySpec);
                return new String(cipher.doFinal(Base64.getDecoder().decode(strToDecrypt)));
            }
            catch (Exception e) {
                Logger.getLogger(SealedString.class.getName()).severe(e.toString());
                return "";
            }
        }
    }
}

