/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.text.MessageFormat;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectPlugin;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectPluginCategory;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectPluginType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Connector;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.FlagProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ParseConnectionSpecArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.EditionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleStandardFormConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.PasswordProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.RoleProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.StandardFormConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.UserProperty;

public abstract class OracleStandardFormConnectorType
extends StandardFormConnectorType {
    protected OracleStandardFormConnectorType(FlagProperty selector) {
        super(selector);
        this.addProperty(RoleProperty.ROLE);
        this.addProperty(EditionProperty.EDITION);
    }

    @Override
    public boolean supportsConnectPlugin(ConnectPluginType type) {
        return ConnectPluginCategory.ORACLE_AUTHENTICATION.equals((Object)type.getAddinCategory());
    }

    @Override
    public void parseConnectionSpec(ParseConnectionSpecArgs args) {
        String edition;
        String[] roleWords;
        String url;
        TextSecret password;
        String user;
        ConnectionDetails cd;
        String userName;
        super.parseConnectionSpec(args);
        ConnectPluginType authOption = null;
        for (ConnectPluginType plugin : this.plugins) {
            FlagProperty selector = plugin.getSelectorProperty();
            if (args.getPropertyValue(selector) != null) {
                if (authOption != null) {
                    args.addError(MessageFormat.format(Messages.getString(Messages.Key.ERROR_TOO_MANY_AUTHENTICATION_TYPES), authOption.getSelectorProperty().getName(), selector.getName()));
                    break;
                }
                authOption = plugin;
                continue;
            }
            for (Property<?> pluginProp : plugin.getProperties()) {
                if (args.getPropertyValue(pluginProp) == null) continue;
                args.addError(MessageFormat.format(Messages.getString(Messages.Key.ERROR_AUTHENTICATION_TYPE_MISSING), pluginProp.getName(), selector.getName()));
            }
        }
        if ((userName = (cd = OracleStandardFormConnectorType.createConnectDetails(args)).getConnectName()) != null && (userName = userName.trim()).length() > 0 && (userName.charAt(0) != '\"' || userName.charAt(userName.length() - 1) != '\"') && userName.contains(".")) {
            args.addError(MessageFormat.format(Messages.getString(Messages.Key.INVALID_USERNAME), userName));
        }
        if (OracleStandardFormConnectorType.isNotEmpty(user = cd.getConnectName())) {
            args.setPropertyValue(UserProperty.USER, user);
        }
        if (OracleStandardFormConnectorType.isNotEmpty(password = cd.getConnectPassword())) {
            args.setPropertyValue(PasswordProperty.PASSWORD, password);
        }
        if (OracleStandardFormConnectorType.isNotEmpty(url = cd.getConnectDB())) {
            args.setPropertyValue(URLProperty.URL, url);
        } else if (args.getPropertyValue(URLProperty.URL) == null) {
            Class<?> connectorTypeClass;
            ConnectorType currentConnectorType = args.getScriptRunnerContext().getService(ConnectionContext.class).getCurrentConnectorType();
            Class<?> clazz = connectorTypeClass = currentConnectorType != null ? currentConnectorType.getClass() : null;
            if (connectorTypeClass != null && !this.getClass().equals(connectorTypeClass)) {
                args.addError(Messages.getString(Messages.Key.URL_UNAVAILABLE));
            }
        }
        String role = cd.getRole();
        if (OracleStandardFormConnectorType.isNotEmpty(role) && (roleWords = role.split("[ ]+")).length == 2) {
            args.setPropertyValue(RoleProperty.ROLE, roleWords[1]);
        }
        if (OracleStandardFormConnectorType.isNotEmpty(edition = cd.getEdition())) {
            args.setPropertyValue(EditionProperty.EDITION, edition);
        }
    }

    @Override
    public final Connector createConnector(ConnectorArgs args) {
        OracleStandardFormConnector connector = this.createConnectorImpl(args);
        PropertyValues props = args.getPropertyValues();
        for (ConnectPluginType pluginType : this.plugins) {
            if (props.getValueOf(pluginType.getSelectorProperty()) == null) continue;
            ConnectPlugin plugin = pluginType.createConnectAddin(args);
            connector.installPlugin(plugin);
        }
        return connector;
    }

    protected abstract OracleStandardFormConnector createConnectorImpl(ConnectorArgs var1);
}

