/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.RawPropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.SetType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.ProxyProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.WalletValue;

public enum CloudConfigProperty implements Property<WalletValue>
{
    CLOUDCONFIG;


    @Override
    public String getShortName() {
        return "CC";
    }

    @Override
    public SetType getSetType() {
        return SetType.SETTABLE;
    }

    @Override
    public List<Property<?>> getOptions() {
        return Arrays.asList(ProxyProperty.PROXY);
    }

    @Override
    public WalletValue createValue(ScriptRunnerContext ctx, RawPropertyValues rawValues, Consumer<String> errorConsumer) {
        WalletValue walletValue = null;
        String rawCloudConfig = (String)rawValues.get(this.getName());
        if (rawCloudConfig == null || rawCloudConfig.isEmpty()) {
            return null;
        }
        URLConnection fUrl = FileUtils.getFile(ctx, rawCloudConfig);
        try (InputStream contents = fUrl.getInputStream();){
            walletValue = WalletValue.create(ctx, rawCloudConfig, contents, errorConsumer);
        }
        catch (IOException ex) {
            errorConsumer.accept(MessageFormat.format(Messages.getString(Messages.Key.CLOUD_INVALID), rawCloudConfig));
        }
        return walletValue;
    }

    @Override
    public String asString(PropertyValues properties) {
        WalletValue walletValue = properties.getValueOf(this);
        String result = walletValue != null ? walletValue.getLocation() : "";
        return result;
    }
}

