/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.alias;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Alias;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Aliases;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.ParserUtil;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReportsParser {
    protected static Logger LOGGER = Logger.getLogger(ReportsParser.class.getName());
    ArrayList<Alias> aliases = new ArrayList();

    public ArrayList<Alias> processXML(URL u) throws Exception {
        return this.processXML(u.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Alias> processXML(InputStream is) throws Exception {
        try {
            DOMParser parser = new DOMParser();
            this.aliases.clear();
            parser.setPreserveWhitespace(false);
            parser.parse(is);
            XMLDocument document = parser.getDocument();
            NodeList rootNodes = document.getChildNodes();
            for (int i = 0; i < rootNodes.getLength(); ++i) {
                Node rootNode = rootNodes.item(i);
                String rootNodeName = rootNode.getNodeName();
                if (!rootNodeName.equalsIgnoreCase("DISPLAYS")) continue;
                NodeList rootChildren = rootNode.getChildNodes();
                for (int j = 0; j < rootChildren.getLength(); ++j) {
                    Node rootChild = rootChildren.item(j);
                    String rootChildNodeName = rootChild.getNodeName();
                    if (!rootChildNodeName.equalsIgnoreCase("FOLDER")) continue;
                    this.processFolderNode(rootChild, "");
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.aliases;
    }

    private void processFolderNode(Node folderNode, String parentFolderName) {
        NodeList childNodes = folderNode.getChildNodes();
        Object folderName = null;
        ArrayList<Node> displayNodes = new ArrayList<Node>();
        ArrayList<Node> folderNodes = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (nodeName.equalsIgnoreCase("FOLDER")) {
                folderNodes.add(childNode);
                continue;
            }
            if (nodeName.equalsIgnoreCase("DISPLAY")) {
                displayNodes.add(childNode);
                continue;
            }
            if (!nodeName.equalsIgnoreCase("NAME")) continue;
            folderName = ParserUtil.getCdataValue(childNode);
        }
        folderName = folderName == null ? parentFolderName : parentFolderName + "/" + (String)folderName;
        for (Node node : folderNodes) {
            this.processFolderNode(node, (String)folderName);
        }
        for (Node node : displayNodes) {
            this.processDisplayNode(node, (String)folderName);
        }
    }

    private boolean canAdd(String style, String type) {
        if ("Table".equalsIgnoreCase(style) && (type == null || type.isBlank())) {
            return true;
        }
        return "Report".equalsIgnoreCase(type);
    }

    private void processDisplayNode(Node displayNode, String folderName) {
        String type;
        String style = XMLHelper.getAttributeNode(displayNode, "style");
        if (!this.canAdd(style, type = XMLHelper.getAttributeNode(displayNode, "type"))) {
            return;
        }
        NodeList childNodes = displayNode.getChildNodes();
        Object queryName = null;
        Object description = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (nodeName.equalsIgnoreCase("NAME")) {
                queryName = ParserUtil.getCdataValue(childNode);
                continue;
            }
            if (nodeName.equalsIgnoreCase("DESCRIPTION")) {
                description = ParserUtil.getCdataValue(childNode);
                continue;
            }
            if (!nodeName.equalsIgnoreCase("DISPLAY")) continue;
            this.processDisplayNode(childNode, folderName);
        }
        ObjectQueries queries = new ObjectQueries((XMLNode)displayNode);
        if (description == null) {
            description = queryName;
        }
        if (folderName == null) {
            folderName = "";
        } else {
            description = folderName + ": " + description;
        }
        if (queryName == null || ((String)queryName).isBlank()) {
            queryName = "RepNoName";
        } else {
            queryName = ((String)queryName).replace(" ", "");
            queryName = ((String)queryName).substring(0, 1).toUpperCase() + ((String)queryName).substring(1);
            queryName = "Rep" + (String)queryName;
        }
        Alias alias = new Alias((String)queryName, (String)description, queries, "report", true);
        this.aliases.add(alias);
    }

    public static void main(String[] args) {
        ReportsParser mp = new ReportsParser();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        List<Path> paths = FileUtils.getFilesInPackage("META-INF/reports/oracle/", "xml");
        URL u = cl.getResource("META-INF/reports/oracle/report/AboutYourDatabase.xml");
        try {
            for (Path p : paths) {
                ArrayList<Alias> aliases = mp.processXML(p.toUri().toURL());
                Aliases.getInstance().add(aliases);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

