/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetHeadsep
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_HEADINGSEP;
    private static final String HEADSEP_PTRN = "^(?i:set\\s+head)(?i:s|se|sep)\\s+(?i:\\bon\\b|\\boff\\b|\\p{Punct}|['\"]\\p{Punct}['\"])$";

    public SetHeadsep() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("prop_file_string") != null) {
            String str = cmd.getSql();
            if (str.matches(HEADSEP_PTRN)) {
                str = str.trim().replaceAll("^(?i:set\\s+head)(?i:s|se|sep)\\s+", "").trim();
                if ((str = str.replaceAll("['\"]", "")).equalsIgnoreCase("on")) {
                    ctx.putProperty("script.runner.setheadsepchar", "|");
                    ctx.putProperty("script.runner.setheadsep", str);
                } else if (str.equalsIgnoreCase("off")) {
                    ctx.putProperty("script.runner.setheadsep", str);
                } else {
                    if (((String)ctx.getProperty("script.runner.setheadsep")).equalsIgnoreCase("on") && (str.length() <= 0 || str.length() >= 2)) {
                        if (str.length() > 1) {
                            ctx.write(MessageFormat.format(Messages.getString("SetHeadsep.7"), str));
                        } else {
                            ctx.write(MessageFormat.format(Messages.getString("SetHeadsep.8"), str));
                        }
                    }
                    ctx.putProperty("script.runner.setheadsepchar", str);
                }
            } else {
                str = str.trim().replaceAll("^(?i:set\\s+head)(?i:s|se|sep)\\s+", "").trim();
                if ((str = str.replaceAll("['\"]", "")).length() > 1) {
                    ctx.write(MessageFormat.format(Messages.getString("SetHeadsep.7"), str));
                } else {
                    ctx.write(MessageFormat.format(Messages.getString("SetHeadsep.8"), str));
                }
            }
        } else {
            ctx.write(Messages.getString("SetHeadsep.10"));
        }
        return true;
    }
}

