/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class Help
extends CommandListener {
    private final String linesep = System.lineSeparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String in = (cmd.getLoweredTrimmedSQL() + " ").substring((cmd.getLoweredTrimmedSQL() + " ").indexOf(" ")).trim();
        try {
            String[] lines;
            Object command = null;
            CharSequence[] words = in.split("\\s+");
            if (words.length >= 2) {
                command = words[0].toLowerCase().equals("set") ? (String)words[0] + (String)words[1] : words[0];
            } else if (words.length == 1) {
                command = words[0];
            }
            String pagePath = String.join((CharSequence)"/", words).toUpperCase();
            for (String line : lines = this.HelpOnOrIndex((String)command, pagePath, ctx).split("\\R")) {
                ctx.write(line + this.linesep);
            }
            ctx.write(this.linesep);
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage() + "\n");
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    protected String highlightBold(String text) {
        return text;
    }

    private String HelpOnOrIndex(String command, String pagePath, ScriptRunnerContext ctx) throws Exception {
        if (command == null || command.equals("") || command.equalsIgnoreCase("help") || command.equalsIgnoreCase("index") || command.equalsIgnoreCase("all") || command.equalsIgnoreCase("?")) {
            return this.getHelpProperty("", "", ctx);
        }
        Object help = "";
        help = (String)help + this.getHelpProperty(command, pagePath, ctx);
        return help;
    }

    /*
     * WARNING - void declaration
     */
    private String getHelpProperty(String command, String pagePath, ScriptRunnerContext ctx) throws Exception {
        void var11_19;
        void var11_17;
        void var11_15;
        String expandedReqKey;
        TreeMap<String, Supplier<String>> setHelps = new TreeMap<String, Supplier<String>>();
        TreeMap<String, Supplier<String>> showHelps = new TreeMap<String, Supplier<String>>();
        TreeMap<String, Supplier<String>> commandHelps = new TreeMap<String, Supplier<String>>();
        HashSet<String> sqlplusTags = new HashSet<String>();
        Enumeration<String> tagsEnumeration = HelpMessages.getKeys();
        if (tagsEnumeration == null) {
            throw new Exception(Messages.getString("NO_HELP_KEYS"));
        }
        ArrayList<String> tags = Collections.list(tagsEnumeration);
        for (String string : tags) {
            String key = string.toUpperCase();
            if (key.equals("SET")) {
                commandHelps.put(key, () -> this.buildSetHelp(() -> this.buildHelpMessageHelp("SET"), setHelps));
                continue;
            }
            if (key.startsWith("SET")) {
                setHelps.put(key, () -> this.buildHelpMessageHelp(string));
                continue;
            }
            if (key.equals("SHOW")) {
                commandHelps.put(key, () -> this.buildShowHelp(() -> this.buildHelpMessageHelp("SHOW"), showHelps));
                continue;
            }
            if (key.startsWith("SHOW")) {
                showHelps.put(key, () -> this.buildHelpMessageHelp(string));
                continue;
            }
            if (string.trim().length() <= 0) continue;
            commandHelps.put(key, () -> this.buildHelpMessageHelp(string));
        }
        HashMap<String, String> expandedCommands = new HashMap<String, String>();
        for (IHelp help : CommandRegistry.getCommandsWithHelp()) {
            String tag = help.getCommand();
            String key = tag.toUpperCase();
            if (key.equals("SET")) {
                commandHelps.put(key, () -> this.buildSetHelp(this.getHelpSupplier(help, ctx, pagePath), setHelps));
            } else if (key.startsWith("SET")) {
                setHelps.put(key, this.getHelpSupplier(help, ctx, pagePath));
            } else if (key.equals("SHOW")) {
                commandHelps.put(key, () -> this.buildShowHelp(this.getHelpSupplier(help, ctx, pagePath), setHelps));
            } else if (key.startsWith("SHOW")) {
                showHelps.put(key, this.getHelpSupplier(help, ctx, pagePath));
            } else if (tag.trim().length() > 0) {
                if (help instanceof CommandListener) {
                    Type type = ((CommandListener)((Object)help)).getParserType();
                    if (type != null) {
                        for (String synonym : type.getSynonyms().get()) {
                            expandedCommands.put(synonym, type.getName());
                        }
                        commandHelps.put(type.getName(), this.getHelpSupplier(help, type, ctx, pagePath));
                    } else {
                        commandHelps.put(key, this.getHelpSupplier(help, ctx, pagePath));
                    }
                } else {
                    commandHelps.put(key, this.getHelpSupplier(help, ctx, pagePath));
                }
            }
            if (help.isSqlPlus()) continue;
            sqlplusTags.add(key);
        }
        Object var11_13 = null;
        String reqKey = command.toUpperCase();
        Supplier helpSupplier = (Supplier)commandHelps.get(reqKey);
        if (helpSupplier == null && (expandedReqKey = (String)expandedCommands.get(reqKey)) != null) {
            helpSupplier = (Supplier)commandHelps.get(expandedReqKey);
        }
        if (helpSupplier != null) {
            String string = (String)helpSupplier.get();
        }
        if (var11_15 == null && (helpSupplier = (Supplier)setHelps.get(reqKey)) != null) {
            String string = (String)helpSupplier.get();
        }
        if (var11_17 == null) {
            String string = this.buildHelpHelp(ctx, pagePath.replace("/", " "), commandHelps, sqlplusTags);
        }
        return var11_19;
    }

    private Supplier<String> getHelpSupplier(IHelp iHelp, ScriptRunnerContext ctx, String pagePath) {
        return () -> {
            Optional<String> stringOpt = iHelp.getHelp(ctx, pagePath);
            return stringOpt.isPresent() ? stringOpt.get() : null;
        };
    }

    private Supplier<String> getHelpSupplier(IHelp iHelp, Type type, ScriptRunnerContext ctx, String pagePath) {
        return () -> {
            String expandedPagePath = this.expandPagePath(type, pagePath);
            if (expandedPagePath != null) {
                Optional<String> stringOpt = iHelp.getHelp(ctx, expandedPagePath);
                return stringOpt.isPresent() ? stringOpt.get() : null;
            }
            return null;
        };
    }

    private String expandPagePath(Type type, String pagePath) {
        StringBuilder buff = new StringBuilder(type.getName());
        String[] pageComponents = pagePath.split("/");
        for (int c = 1; c < pageComponents.length; ++c) {
            String pageComponent = pageComponents[c];
            buff.append('/');
            boolean foundComponent = false;
            for (Type nestedType : type.getNestedTypes()) {
                if (!nestedType.getSynonyms().get().contains(pageComponent)) continue;
                buff.append(nestedType.getName());
                type = nestedType;
                foundComponent = true;
                break;
            }
            if (foundComponent) continue;
            buff.append(pageComponent);
        }
        return buff.toString();
    }

    private String printColumns(Collection<? extends CharSequence> items, ScriptRunnerContext ctx, Collection<String> sqlplusTags) {
        StringBuilder s = new StringBuilder();
        if (items == null || items.isEmpty()) {
            return "";
        }
        int width = 82;
        if (ctx.isCommandLine() && ctx.getSQLPlusConsoleReader().getWidth() > width) {
            width = ctx.getSQLPlusConsoleReader().getWidth();
        }
        int maxWidth = 0;
        for (CharSequence charSequence : items) {
            maxWidth = Math.max(maxWidth, charSequence.length());
        }
        StringBuilder buff = new StringBuilder();
        int n = width / (maxWidth += 3);
        int col = 0;
        for (CharSequence charSequence : items) {
            int i;
            String name = charSequence.toString();
            if (sqlplusTags.contains(name)) {
                name = this.highlightBold(name);
            }
            if (col < n) {
                buff.append(name);
                for (i = 0; i < maxWidth - charSequence.length(); ++i) {
                    buff.append(' ');
                }
                ++col;
                continue;
            }
            s.append(buff.toString()).append(this.linesep);
            buff.setLength(0);
            col = 0;
            buff.append(name);
            for (i = 0; i < maxWidth - charSequence.length(); ++i) {
                buff.append(' ');
            }
            ++col;
        }
        if (buff.length() > 0) {
            s.append(buff.toString());
        }
        return s.toString();
    }

    private String buildSetHelp(Supplier<String> setHeaderSupplier, SortedMap<String, Supplier<String>> setHelps) {
        StringBuilder retBuff = new StringBuilder();
        retBuff.append(setHeaderSupplier.get());
        for (String mytag : setHelps.keySet()) {
            String name = mytag.replace("_", " ");
            if (!name.startsWith("SET")) continue;
            retBuff.append(" ").append(name.substring(3)).append(this.linesep);
        }
        return retBuff.toString();
    }

    private String buildShowHelp(Supplier<String> showHeaderSupplier, SortedMap<String, Supplier<String>> showHelps) {
        StringBuilder retBuff = new StringBuilder();
        retBuff.append(showHeaderSupplier.get());
        for (String mytag : showHelps.keySet()) {
            String tagHelp = (String)((Supplier)showHelps.get(mytag)).get();
            retBuff.append("     ").append(tagHelp).append(this.linesep);
        }
        return retBuff.toString();
    }

    private String buildHelpHelp(ScriptRunnerContext ctx, String requestedTag, SortedMap<String, Supplier<String>> commandHelps, Collection<String> sqlplusTags) {
        Object retVal = "";
        if (requestedTag != null && requestedTag.length() > 0) {
            retVal = (String)retVal + MessageFormat.format(Messages.getString("Help.ObjectNotFound"), requestedTag);
        }
        retVal = (String)retVal + Messages.getString("LIST_OF_HELP_TOPICS");
        StringBuilder retBuff = new StringBuilder();
        if (ctx.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(ctx.getProperty("sqlplus.classic.mode").toString())) {
            int cols = 120;
            int maxlen = 0;
            for (String item : commandHelps.keySet()) {
                if (item.length() <= maxlen) continue;
                maxlen = item.length();
            }
            int noscols = 120 % (maxlen + 1);
            Object output = "";
            Object line = "";
            int col = 0;
            for (String item : commandHelps.keySet()) {
                if (col >= noscols) {
                    output = (String)output + (String)line + this.linesep;
                    line = "";
                    col = 0;
                }
                String pad = new String(new char[maxlen - item.length()]).replace('\u0000', ' ');
                line = (String)line + item + pad;
                ++col;
            }
            if (((String)line).length() > 0) {
                output = (String)output + (String)line + this.linesep;
            }
            retVal = (String)retVal + (String)output;
        } else {
            retVal = (String)retVal + this.printColumns(commandHelps.keySet(), ctx, sqlplusTags);
            if (ctx.isCommandLine()) {
                retVal = (String)retVal;
            }
        }
        return retVal;
    }

    private String buildHelpMessageHelp(String tag) {
        String help = HelpMessages.getString(tag);
        if (this.wasError(help)) {
            help = null;
        }
        return help;
    }

    private boolean wasError(String retval) {
        return retval == null || retval.startsWith("!") && retval.endsWith("!");
    }
}

