/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.app.BestPractice;
import oracle.dbtools.app.Issue;
import oracle.dbtools.app.PsrChecks;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.util.Directory;
import oracle.dbtools.util.Service;

public class CodeScan
extends CommandListener
implements IHelp {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public String getCommand() {
        return "CODESCAN";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sql = cmd.getSql().trim();
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("codescan")) {
            Object settingsFile;
            String path;
            StringTokenizer st = new StringTokenizer(sql, " ,=", true);
            LinkedList<String> tokens = new LinkedList<String>();
            while (st.hasMoreTokens()) {
                tokens.add(st.nextToken());
            }
            HashMap<Object, Object> option2value = new HashMap<Object, Object>();
            Object option = null;
            for (String tOken : tokens) {
                String token = tOken.toLowerCase();
                String syntax = "Syntax: codescan { -path dir | -format {json|text} \n| -ignore ruleNo [[,] ruleNo]* | -output file | -setting[s] file }* \n";
                if (token.startsWith("-")) {
                    option = token.substring(1);
                    if ("path".equals(option) || "format".equals(option) || "ignore".equals(option) || "output".equals(option)) continue;
                    if ("setting".equals(option)) {
                        option = (String)option + "s";
                        continue;
                    }
                    if ("settings".equals(option) || "cut".equals(option)) continue;
                    this.log_error(ctx, "Syntax: codescan { -path dir | -format {json|text} \n| -ignore ruleNo [[,] ruleNo]* | -output file | -setting[s] file }* \n");
                    return true;
                }
                if (option == null & !"codescan".equals(token) & !" ".equals(token)) {
                    this.log_error(ctx, "Syntax: codescan { -path dir | -format {json|text} \n| -ignore ruleNo [[,] ruleNo]* | -output file | -setting[s] file }* \n");
                    return true;
                }
                if (" ".equals(token) || ",".equals(token) || "=".equals(token)) continue;
                String tmp = (String)option2value.get(option);
                if (tmp == null) {
                    option2value.put(option, tOken);
                    continue;
                }
                option2value.put(option, tmp + " " + tOken);
            }
            BestPractice scanner = BestPractice.getInstance();
            PsrChecks psrScanner = PsrChecks.getInstance();
            String ignore = (String)option2value.get("ignore");
            scanner.ruleExclusions = new HashSet();
            if (ignore != null) {
                StringTokenizer st1 = new StringTokenizer(ignore, " ");
                while (st1.hasMoreTokens()) {
                    int ic;
                    String ignoreRule = st1.nextToken();
                    if (ignoreRule.startsWith("\"")) {
                        ignoreRule = ignoreRule.substring(1);
                    }
                    if (ignoreRule.endsWith("\"")) {
                        ignoreRule = ignoreRule.substring(0, ignoreRule.length() - 1);
                    }
                    if (0 < (ic = ignoreRule.indexOf(58))) {
                        ignoreRule = ignoreRule.substring(0, ic);
                    }
                    scanner.ruleExclusions.add(ignoreRule);
                }
            }
            if ((path = (String)option2value.get("path")) == null) {
                path = ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._PWD.toString());
            }
            if ((settingsFile = (String)option2value.get("settings")) != null) {
                if (((String)settingsFile).startsWith("\"")) {
                    settingsFile = ((String)settingsFile).substring(1);
                }
                if (((String)settingsFile).endsWith("\"")) {
                    settingsFile = ((String)settingsFile).substring(0, ((String)settingsFile).length() - 1);
                }
                if (path != null) {
                    settingsFile = path + "/" + (String)settingsFile;
                }
                try {
                    String settings = Service.readFile((String)settingsFile);
                    Map map = JSON.std.mapFrom((Object)settings);
                    List rules = (List)map.get("ignore");
                    if (rules == null) {
                        rules = (List)map.get("IGNORE");
                    }
                    if (rules == null) {
                        this.log_error(ctx, "Missing attribute \"ignore\"\n");
                        return true;
                    }
                    scanner.ruleExclusions = new HashSet();
                    for (String rule : rules) {
                        scanner.ruleExclusions.add(rule);
                    }
                }
                catch (AssertionError e) {
                    this.log_error(ctx, ((Throwable)((Object)e)).getMessage() + "\n");
                }
                catch (IOException e) {
                    this.log_error(ctx, "File " + (String)settingsFile + " not found \n");
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            boolean isJson = option2value.get("format") != null && "json".equals(((String)option2value.get("format")).toLowerCase());
            String output = (String)option2value.get("output");
            String cut = (String)option2value.get("cut");
            int threshold = 1000000;
            if (cut != null) {
                threshold = Integer.parseInt(cut);
            }
            StringBuilder ret = new StringBuilder(isJson ? "[\n" : "");
            ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
            try {
                List<String> files = Directory.visitor4Directory(path, new String[]{"sql", "pks", "pkb", "pkh", "pls", "plb", "pck", "tps", "tpb"}, sqlcl);
                int i = 0;
                int total = 0;
                for (String file : files) {
                    if (sqlcl.getInterrupted()) {
                        System.out.println("\nCancelled codescan");
                        return true;
                    }
                    String msg = "scanned " + ++i + " files...";
                    System.out.print(msg + "\r");
                    String code = null;
                    code = Service.readFile((String)file);
                    if (threshold < code.length()) {
                        code = code.substring(0, threshold);
                    }
                    Set<Issue> report = scanner.report(code);
                    report.addAll(psrScanner.report(code));
                    report = Issue.filterUnique(report);
                    total += report.size();
                    if (0 >= report.size()) continue;
                    if (isJson) {
                        ret.append("{\"file\": \"" + file + "\", \"issues\": [\n");
                    } else {
                        ret.append("***** " + file + "\n");
                        ret.append("*** " + report.size() + " distinct warnings\n");
                    }
                    int j = 0;
                    for (Issue iss : report) {
                        if (isJson) {
                            ret.append("     " + iss.toJson() + ",\n");
                        } else {
                            ret.append(iss.toString() + "\n");
                        }
                        ++j;
                    }
                    if (!isJson) continue;
                    ret.deleteCharAt(ret.length() - 2);
                    ret.append("]},\n");
                }
                this.log_info(ctx, i + " files, " + total + " total distinct warnings\n");
            }
            catch (NullPointerException e) {
                this.log_error(ctx, "Directory " + path + " does not exist\n");
            }
            catch (Exception e) {
                this.log_error(ctx, e.getMessage());
                return true;
            }
            if (isJson) {
                ret.deleteCharAt(ret.length() - 2);
                ret.append("]\n");
            }
            if (output != null) {
                try {
                    BufferedWriter writer = new BufferedWriter(new FileWriter(output));
                    writer.write(ret.toString());
                    writer.close();
                }
                catch (Exception e) {
                    this.log_error(ctx, e.getMessage());
                }
            } else {
                this.log_info(ctx, ret.toString());
            }
            return true;
        }
        return false;
    }

    private void log_error(ScriptRunnerContext ctx, String msg) {
        try {
            ctx.write(msg);
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, msg);
        }
    }

    private void log_info(ScriptRunnerContext ctx, String msg) {
        try {
            ctx.write(msg);
        }
        catch (Throwable t) {
            this.logger.log(Level.INFO, msg);
        }
    }
}

