/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.logging.LogPaneHandler;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class ChangeLoggerLevel
extends CommandListener {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] parts = cmd.getSQLOrig().split("\\s+");
        Logger l = null;
        if (parts.length == 3) {
            String message = Messages.getString("ChangeLoggerLevel.1");
            Object[] obj = new Object[]{parts[1], parts[2]};
            this.logger.info(MessageFormat.format(message, obj));
            l = Logger.getLogger(parts[1]);
            l.setLevel(Level.parse(parts[2]));
        } else if (parts.length == 2) {
            this.logger.info(MessageFormat.format(Messages.getString("ChangeLoggerLevel.2"), parts[1]));
            l = Logger.getLogger("");
            l.setLevel(Level.parse(parts[1]));
        }
        if (l != null) {
            boolean add = true;
            for (Handler h : l.getHandlers()) {
                if (!(h instanceof LogPaneHandler)) continue;
                add = false;
            }
            if (add) {
                l.addHandler(LogPaneHandler.getInstance());
            }
        }
        return true;
    }
}

