/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.ParsingCancelled;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.newscriptrunner.BufferedReaderStack;
import oracle.dbtools.raptor.newscriptrunner.CoreScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.IScriptParser;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCompoundCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLStatementTypes;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;
import oracle.dbtools.util.Service;

public class ScriptParser
extends CoreScriptParser
implements IScriptParser {
    private static final Logger s_logger = Logger.getLogger(ScriptParser.class.getName());
    public static final String TERMINATOR = "terminator";
    static final String FORWARDSLASH = "/";
    private final List<ISQLCommand> m_sqlArray = new ArrayList<ISQLCommand>();
    private String m_rawSQL;
    private BufferedReaderStack m_reader = null;
    protected int m_readerLineCnt = -1;
    protected int m_readerLineStartCnt = 0;
    private int _numOfEmptyLineAbove = 0;
    public static final String NUMEMPTYLINESABOVE = "NUMEMPTYLIENSABOVE";
    private ScriptRunnerContext _scriptRunnerContext = null;
    private boolean m_isFirstPartOfCompoundSetStmt = false;
    private int m_setSubCommandCount = 0;
    private boolean customParsing = false;
    private List<LexerToken> src = null;
    private List<LexerToken> fullSrc = null;
    private ParseNode root = null;
    private List<ParseNode> stmts = null;
    public Boolean bailOut = null;
    private int[] lineMap = null;
    private int stmtNo = 0;

    public ScriptParser(InputStream stream) {
        this(stream, null);
    }

    public ScriptParser(Reader rdr) {
        this(rdr, null);
    }

    public ScriptParser(InputStream in, Connection conn) {
        this(new InputStreamReader(in), conn);
    }

    public ScriptParser(Reader rdr, Connection conn) {
        this.scriptParserInit(rdr, conn);
    }

    private void scriptParserInit(Reader rdr, Connection c) {
        this.m_reader = new BufferedReaderStack(new BufferedReader(rdr));
        StringBuilder fullCmd = new StringBuilder();
        try {
            String ln = this.m_reader.readLine();
            while (ln != null) {
                fullCmd.append(ln);
                fullCmd.append('\n');
                ln = this.m_reader.readLine();
            }
        }
        catch (IOException e) {
            s_logger.severe(e.getLocalizedMessage());
        }
        this.m_rawSQL = fullCmd.toString();
        this.m_reader = new BufferedReaderStack(new BufferedReader(new StringReader(this.m_rawSQL)));
    }

    public ScriptParser(String s) {
        this(s, null);
    }

    public ScriptParser(String s, Connection conn) {
        this(new StringReader(s), conn);
        this.m_rawSQL = s;
    }

    public void customParsing(boolean customParsing) {
        this.customParsing = customParsing;
    }

    public static void main(String[] args) throws Exception {
        File f = new File(args[0]);
        FileInputStream in = new FileInputStream(f);
        ScriptParser s = new ScriptParser(in);
        s.parse();
        ISQLCommand[] stmts = s.getSqlStatements();
        for (int i = 0; i < stmts.length; ++i) {
            System.out.print("Command " + i + ":" + stmts[i].getStmtType() + ":" + stmts[i].getStmtSubType() + "\n" + stmts[i].getSql() + "\n");
            if (stmts[i].isSqlPlusSetCmd()) {
                System.out.println(" SQLPLUS");
                continue;
            }
            if (stmts[i].isCreateCmd()) {
                System.out.println(" Create");
                continue;
            }
            if (stmts[i].isCreatePLSQLCmd()) {
                System.out.println(" PLSQL");
                continue;
            }
            if (!stmts[i].isCreateSQLCmd()) continue;
            System.out.println(" SQL");
        }
    }

    public void parse() {
        this.setLeftOver(null);
        this.setSetLeftOver(null);
        this.m_readerLineCnt = -1;
        try {
            ISQLCommand cmd = this.next();
            while (cmd != null) {
                this.m_sqlArray.add(cmd);
                cmd = this.next();
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void parseinit() {
        this.setLeftOver(null);
        this.setSetLeftOver(null);
        this.m_readerLineCnt = -1;
    }

    @Override
    public ISQLCommand next() throws IOException {
        SQLCommand incompleteCmd;
        this.m_reader.setContext(this._scriptRunnerContext);
        if (this._scriptRunnerContext != null && this.isInFile() && (incompleteCmd = (SQLCommand)this._scriptRunnerContext.getProperty("incomplete")) != null && incompleteCmd.getOrigSQL() != null) {
            if (this.getLeftOver() == null) {
                this.setLeftOver(incompleteCmd.getOrigSQL());
            } else {
                this.setLeftOver(this.getLeftOver() + " " + incompleteCmd.getOrigSQL());
            }
            this._scriptRunnerContext.removeProperty("incomplete");
        }
        String line = this.getTop(this.getLeftOver());
        this.setLeftOver(null);
        if (line == null) {
            if (this._numOfEmptyLineAbove > 0 && this._scriptRunnerContext != null && this._scriptRunnerContext.isCommandLine()) {
                return this.makeCommentWithEmptyLines(this._numOfEmptyLineAbove);
            }
            return null;
        }
        SQLCommand stmtProperties = this.getPropertiesForParserHint(line);
        if (stmtProperties == null) {
            stmtProperties = this.getPropertiesWhenNoSpaceRequired(line);
        }
        if (stmtProperties == null) {
            stmtProperties = this.getPropertiesWhenTokensKnown(line);
            if (stmtProperties != null && stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_ALIAS) && line.indexOf(61) != -1) {
                stmtProperties.setStmtType(SQLCommand.StmtType.G_C_SQL);
                String[] equalsSplit = line.split("=");
                if (equalsSplit != null && equalsSplit.length > 1 && equalsSplit[1] != null) {
                    for (int i = 0; i < equalsSplit.length - 1; ++i) {
                        String[] prevWhiteSplit = equalsSplit[i].trim().split("\\s");
                        if ("-desc".equalsIgnoreCase(prevWhiteSplit[prevWhiteSplit.length - 1]) || "-group".equalsIgnoreCase(prevWhiteSplit[prevWhiteSplit.length - 1])) continue;
                        String[] whiteSplit = equalsSplit[i + 1].trim().split("\\s");
                        if (whiteSplit == null || whiteSplit.length <= 0 || whiteSplit[0] == null || !whiteSplit[0].equalsIgnoreCase("begin") && !whiteSplit[0].equalsIgnoreCase("declare") && !equalsSplit[i + 1].startsWith("q'") && !equalsSplit[i + 1].startsWith("Q'")) break;
                        stmtProperties.setStmtType(SQLCommand.StmtType.G_C_PLSQL);
                        break;
                    }
                }
            }
            if (stmtProperties != null && stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_NET) && line.indexOf(61) != -1) {
                stmtProperties.setStmtType(SQLCommand.StmtType.G_C_SQL);
            }
        }
        if (stmtProperties == null && (stmtProperties = this.getPropertiesWhenMulitpleTokensKnown(line)) != null && (stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CREATE_UNKNOWN) || stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_WITH) && stmtProperties.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL))) {
            stmtProperties.setProperty("CREATEREFINE", Boolean.TRUE);
        }
        if (stmtProperties == null && (stmtProperties = this.getHalfRecognizedMultiToken(line)) != null && (stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CREATE_UNKNOWN) || stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_WITH) && stmtProperties.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL))) {
            stmtProperties.setProperty("CREATEREFINE", Boolean.TRUE);
        }
        if (stmtProperties == null) {
            stmtProperties = this.createUnknownStatementProperties();
        }
        stmtProperties = this.refineScriptRecognition(stmtProperties, line);
        stmtProperties = this.refineStmtRecognition(stmtProperties, line);
        String processLine = ScriptParser.removeComments(line);
        processLine = processLine.replaceAll("'(.)*'", "");
        processLine = processLine.replaceAll("\\s+", "").toUpperCase();
        String withComments = line.replaceAll("\\s+", "").toUpperCase();
        if (withComments.indexOf("/*+WITH_PLSQL") != -1 || withComments.indexOf("--+WITH_PLSQL") != -1) {
            stmtProperties.setProperty(TERMINATOR, FORWARDSLASH);
        }
        if (processLine.indexOf("WITHFUNCTION") != -1 || processLine.indexOf("WITHPROCEDURE") != -1) {
            stmtProperties.setProperty(TERMINATOR, FORWARDSLASH);
        }
        if ((stmtProperties = this.identifyEndOfStatement(line, this.m_reader, stmtProperties)).getStmtResultType() != null && stmtProperties.getStmtSubType() == SQLCommand.StmtSubType.G_S_WITH) {
            stmtProperties.setStmtType(SQLCommand.StmtType.G_C_SQL);
        }
        stmtProperties = this.refineConnectOnFirstLine(stmtProperties, line);
        stmtProperties.setProperty("ORIG_LINE", line);
        stmtProperties.setProperty(NUMEMPTYLINESABOVE, this._numOfEmptyLineAbove);
        return stmtProperties;
    }

    public static String removeComments(String in) {
        int end;
        String interrim = in.replaceAll("--.*$", "");
        int len = interrim.length();
        StringBuilder interrimSb = new StringBuilder();
        int last = 0;
        int index = 0;
        do {
            if ((index = interrim.indexOf("/*", last)) == -1) {
                if (last != 0) {
                    interrimSb.append(interrim.substring(last));
                }
                break;
            }
            interrimSb.append(interrim.substring(last, index));
            end = -1;
            if (index + 2 != len) {
                end = interrim.indexOf("*/", index + 2);
            }
            if (end == -1) break;
            index = end + 2;
        } while ((last = end + 2) != len);
        if (index == -1 && last == 0) {
            return interrim;
        }
        return interrimSb.toString();
    }

    private ISQLCommand makeCommentWithEmptyLines(int _numOfEmptyLineAbove2) {
        SQLCommand stmtProperties = this.createUnknownStatementProperties();
        stmtProperties.setStmtId(SQLCommand.StmtSubType.G_S_COMMENT_SQL);
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i <= this._numOfEmptyLineAbove; ++i) {
            sb.append("\n");
        }
        stmtProperties.setSQLOrig(sb.toString());
        stmtProperties.setSql(sb.toString());
        stmtProperties.setModifiedSQL(sb.toString());
        stmtProperties.setProperty(NUMEMPTYLINESABOVE, this._numOfEmptyLineAbove);
        this._numOfEmptyLineAbove = 0;
        return stmtProperties;
    }

    private SQLCommand refineConnectOnFirstLine(SQLCommand stmtProperties, String line) {
        if (stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_UNKNOWN) && this.m_readerLineCnt < 1) {
            String patterns = "(\\w+\\/\\w+@\\w+(\\s+as\\s+(sysdba)|(sysoper))?)|\\w+\\/\\w+@\\w+\\s+as\\s+sysdba|\\w+\\/\\w+@\\w+\\s+as\\s+sysoper|\\w+\\/\\w+\\s+as\\s+sysdba|\\w+\\/\\w+\\s+as\\s+sysoper|\\w+\\/\\w+";
            Pattern pattern = Pattern.compile("(\\w+\\/\\w+@\\w+(\\s+as\\s+(sysdba)|(sysoper))?)|\\w+\\/\\w+@\\w+\\s+as\\s+sysdba|\\w+\\/\\w+@\\w+\\s+as\\s+sysoper|\\w+\\/\\w+\\s+as\\s+sysdba|\\w+\\/\\w+\\s+as\\s+sysoper|\\w+\\/\\w+", 2);
            Matcher matcher = pattern.matcher(line.trim());
            if (matcher.matches()) {
                stmtProperties.setRunnable(false);
            }
        }
        return stmtProperties;
    }

    private SQLCommand refineScriptRecognition(SQLCommand stmtProperties, String line) {
        if (stmtProperties.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SCRIPT) && line.split("\\s+").length > 1) {
            stmtProperties.setStmtType(SQLCommand.StmtType.G_C_SQLPLUS);
        }
        return stmtProperties;
    }

    private SQLCommand getPropertiesForParserHint(String line) {
        SQLCommand prop = null;
        if (line.startsWith("/*")) {
            line = line.toLowerCase();
            for (String key : SQLStatementTypes.hintTokens.keySet()) {
                if (!line.startsWith(key)) continue;
                prop = SQLStatementTypes.hintTokens.get(key);
            }
        }
        return prop;
    }

    private SQLCommand getHalfRecognizedMultiToken(String line) {
        line = line.trim();
        Set<String> keys = SQLStatementTypes.halfRecognizedMultiToken.keySet();
        for (String key : keys) {
            if (!line.toLowerCase().startsWith(key)) continue;
            return SQLStatementTypes.halfRecognizedMultiToken.get(key);
        }
        return null;
    }

    private void setError(SQLCommand stmtProperties) {
        stmtProperties.setProperty("prop_error_string", ScriptRunnerDbArb.getString("SQLPLUS_COMMAND_USAGE"));
    }

    private void resolveCompoundSetCommands(SQLCommand stmtProperties, String line) {
        if (this.m_isFirstPartOfCompoundSetStmt) {
            this.m_isFirstPartOfCompoundSetStmt = false;
            stmtProperties.setIsSetCompoundCmd(true);
            stmtProperties.setCompoundSetcmd(line);
            if (this.m_setSubCommandCount > 0) {
                --this.m_setSubCommandCount;
            }
        } else if (this.m_setSubCommandCount > 0) {
            stmtProperties.setIsSetCompoundCmd(true);
            stmtProperties.setCompoundSetcmd(null);
            --this.m_setSubCommandCount;
        } else if (this.m_setSubCommandCount == 0) {
            stmtProperties.setIsSetCompoundCmd(false);
            stmtProperties.setCompoundSetcmd(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private SQLCommand refineStmtRecognition(SQLCommand stmtProperties, String line) {
        String property = null;
        String propertyNotLowered = null;
        if (stmtProperties.getStmtSubType() == SQLCommand.StmtSubType.G_S_SET) {
            String[] tokens = ScriptParser.getTokens(line);
            if (tokens.length < 2) {
                stmtProperties.setStmtSubType(SQLCommand.StmtSubType.G_S_SET_ECHO);
                this.setError(stmtProperties);
                stmtProperties.setStmtClass(SQLCommand.StmtType.G_C_SQLPLUS);
                return stmtProperties;
            }
            if (tokens[1].equalsIgnoreCase("constraint") || tokens[1].equalsIgnoreCase("constraints") || tokens[1].equalsIgnoreCase("role") || tokens[1].equalsIgnoreCase("transaction")) {
                SQLCommand subCmd = this.getSetCommand(tokens[1]);
                subCmd.setOrigSQL(line);
                subCmd.setModifiedSQL(line);
                subCmd.setStartLine(stmtProperties.getStartLine());
                subCmd.setEndLine(stmtProperties.getEndLine());
                subCmd.setLines(stmtProperties.getLines());
                subCmd.setOrigEndLine(stmtProperties.getOrigEndLine());
                subCmd.setOrigStartLine(stmtProperties.getOrigStartLine());
                subCmd.setStmtType(SQLCommand.StmtType.G_C_SQL);
                return subCmd;
            }
            if (tokens[1].equalsIgnoreCase("worksheetname")) {
                SQLCommand subCmd = this.getSetCommand(tokens[1]);
                subCmd.setOrigSQL(line);
                subCmd.setModifiedSQL(line);
                subCmd.setStartLine(stmtProperties.getStartLine());
                subCmd.setEndLine(stmtProperties.getEndLine());
                subCmd.setLines(stmtProperties.getLines());
                subCmd.setOrigEndLine(stmtProperties.getOrigEndLine());
                subCmd.setOrigStartLine(stmtProperties.getOrigStartLine());
                subCmd.setStmtType(SQLCommand.StmtType.G_C_USERDEFINED);
                stmtProperties = subCmd;
                if (tokens.length <= 2) {
                    this.setError(stmtProperties);
                    return stmtProperties;
                }
                propertyNotLowered = tokens[2];
                property = tokens[2].toLowerCase();
                if (property.equals("on")) {
                    stmtProperties.setProperty("prop_status_boolean", new Boolean(true));
                } else if (property.equals("off")) {
                    stmtProperties.setProperty("prop_status_boolean", new Boolean(false));
                }
                if (propertyNotLowered != null && !propertyNotLowered.equals("")) {
                    stmtProperties.setProperty("prop_file_string", propertyNotLowered);
                } else {
                    stmtProperties.setProperty("prop_file_string", property);
                }
                if (stmtProperties.getProperty("prop_status_boolean") != null) return stmtProperties;
                stmtProperties.setProperty("prop_status_boolean", new Boolean(true));
                return stmtProperties;
            }
            if (!(tokens[1].equalsIgnoreCase("history") || tokens[1].toLowerCase().startsWith("highli") || tokens[1].toLowerCase().startsWith("connect") || tokens[1].toLowerCase().startsWith("status"))) {
                stmtProperties.setProperty("SET_TOKENS", tokens);
                stmtProperties.setStmtClass(SQLCommand.StmtType.G_C_SQLPLUS);
                return stmtProperties;
            }
            SQLCommand subCmd = this.getSetCommand(tokens[1]);
            if (subCmd == null) {
                subCmd = new SQLCommand(stmtProperties);
            }
            subCmd.setOrigSQL(line);
            subCmd.setModifiedSQL(line);
            subCmd.setStartLine(stmtProperties.getStartLine());
            subCmd.setEndLine(stmtProperties.getEndLine());
            subCmd.setLines(stmtProperties.getLines());
            subCmd.setOrigEndLine(stmtProperties.getOrigEndLine());
            subCmd.setOrigStartLine(stmtProperties.getOrigStartLine());
            subCmd.setStmtType(SQLCommand.StmtType.G_C_USERDEFINED);
            return subCmd;
        }
        if (stmtProperties.isSqlPlusSetCmd() || stmtProperties.isCreateCmd() || stmtProperties.getStmtSubType() == SQLCommand.StmtSubType.G_S_SET_WORKSHEETNAME) {
            String[] tokens = ScriptParser.getTokens(line);
            if (tokens.length <= 2) {
                this.setError(stmtProperties);
                return stmtProperties;
            }
            propertyNotLowered = tokens[2];
            property = tokens[2].toLowerCase();
            if (property.equals("replace") || property.equals("temporary")) {
                if (tokens.length <= 4) {
                    this.setError(stmtProperties);
                    return stmtProperties;
                }
                propertyNotLowered = tokens[4];
                property = tokens[4];
            }
        } else {
            String[] tokens;
            if (stmtProperties.getStmtSubType() != SQLCommand.StmtSubType.G_S_SPOOL) {
                if (stmtProperties.getStmtSubType() != SQLCommand.StmtSubType.G_S_DEFINE) return stmtProperties;
            }
            if ((tokens = ScriptParser.getTokens(line)).length <= 1) return stmtProperties;
            propertyNotLowered = tokens[1];
            property = tokens[1].toLowerCase();
        }
        if (property.equals("on")) {
            stmtProperties.setProperty("prop_status_boolean", new Boolean(true));
        } else if (property.equals("off")) {
            stmtProperties.setProperty("prop_status_boolean", new Boolean(false));
        }
        if (propertyNotLowered != null && !propertyNotLowered.equals("")) {
            stmtProperties.setProperty("prop_file_string", propertyNotLowered);
        } else {
            stmtProperties.setProperty("prop_file_string", property);
        }
        if (stmtProperties.getProperty("prop_status_boolean") != null) return stmtProperties;
        stmtProperties.setProperty("prop_status_boolean", new Boolean(true));
        return stmtProperties;
    }

    private void lateEvaluateInitCompoundSetCommand(SQLCompoundCommand cmd, boolean newlineRemoved) {
        SQLCompoundCommand compCmd = cmd;
        Boolean parsed = (Boolean)compCmd.getProperty("SET_PARSED");
        if (parsed == null || !parsed.booleanValue()) {
            String[] tokens = null;
            tokens = !newlineRemoved ? ScriptParser.getTokens(SQLPLUSUtil.removeDashNewline(cmd, cmd.getOrigSQL())) : ScriptParser.getTokens(cmd.getOrigSQL());
            cmd.setProperty("SET_PARSED", Boolean.TRUE);
            if (tokens != null) {
                int lastCommandEnd = 0;
                for (int i = 1; i < tokens.length; ++i) {
                    SQLCommand subCmd = null;
                    boolean allTokens = false;
                    if (i != lastCommandEnd + 1) {
                        boolean matchFound;
                        String optionToEat;
                        boolean outerContinue;
                        int internalCount;
                        String[] toeat;
                        String tokenLower = tokens[i].toLowerCase(Locale.US);
                        subCmd = this.getSetCommand(tokenLower);
                        SQLCommand prevTokenCommand = null;
                        if (i == lastCommandEnd + 2) {
                            prevTokenCommand = this.getSetCommand(tokens[i - 1].toLowerCase(Locale.US));
                        }
                        if (prevTokenCommand != null && prevTokenCommand.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_DDL)) {
                            subCmd = null;
                            continue;
                        }
                        if (prevTokenCommand != null && prevTokenCommand.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_ERROR_LOGGING)) break;
                        if (prevTokenCommand != null && prevTokenCommand.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_SERVEROUTPUT)) {
                            toeat = new String[]{"size", "format", "forma", "form", "for", "wrapped", "wrappe", "wrapp", "wrap", "wra", "word_wrapped", "word_wrappe", "word_wrapp", "word_wrap", "word_wra", "word_wr", "word_w", "word_", "word", "wor", "truncated", "truncate", "truncat", "trunca", "trunc", "trun", "tru", "unlimited", "unlimite", "unlimit", "unlimi", "unlim", "unli", "unl"};
                            internalCount = i;
                            outerContinue = false;
                            while (++internalCount < tokens.length) {
                                if (tokens[internalCount].toLowerCase(Locale.US).matches("^fo(?:r|rm|rma|rmat)$")) {
                                    if (++internalCount >= tokens.length) break;
                                    optionToEat = tokens[internalCount].toLowerCase(Locale.US);
                                    matchFound = false;
                                    for (String check : toeat) {
                                        if (!optionToEat.equals(check)) continue;
                                        matchFound = true;
                                        break;
                                    }
                                    if (matchFound) continue;
                                    --internalCount;
                                    continue;
                                }
                                if (tokens[internalCount].toLowerCase(Locale.US).equals("size")) {
                                    ++internalCount;
                                    continue;
                                }
                                optionToEat = tokens[internalCount].toLowerCase(Locale.US);
                                matchFound = false;
                                for (String check : toeat) {
                                    if (!optionToEat.equals(check)) continue;
                                    matchFound = true;
                                    break;
                                }
                                if (matchFound) continue;
                                outerContinue = true;
                                i = internalCount - 1;
                                this.fillSubCmd(cmd, tokens, lastCommandEnd, internalCount - 1);
                                lastCommandEnd = internalCount - 1;
                                break;
                            }
                            if (outerContinue) continue;
                        }
                        if (prevTokenCommand != null && prevTokenCommand.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_AUTOTRACE)) {
                            toeat = new String[]{"exp", "expl", "expla", "explai", "explain", "stat", "stati", "statis", "statist", "statisti", "statistic", "statistics"};
                            internalCount = i;
                            outerContinue = false;
                            while (++internalCount < tokens.length) {
                                if (tokens[internalCount].toLowerCase(Locale.US).matches("^fo(?:r|rm|rma|rmat)$")) {
                                    if (++internalCount >= tokens.length) break;
                                    optionToEat = tokens[internalCount].toLowerCase(Locale.US);
                                    matchFound = false;
                                    for (String check : toeat) {
                                        if (!optionToEat.equals(check)) continue;
                                        matchFound = true;
                                        break;
                                    }
                                    if (matchFound) continue;
                                    --internalCount;
                                    continue;
                                }
                                if (tokens[internalCount].toLowerCase(Locale.US).equals("size")) {
                                    ++internalCount;
                                    continue;
                                }
                                optionToEat = tokens[internalCount].toLowerCase(Locale.US);
                                matchFound = false;
                                for (String check : toeat) {
                                    if (!optionToEat.equals(check)) continue;
                                    matchFound = true;
                                    break;
                                }
                                if (matchFound) continue;
                                outerContinue = true;
                                i = internalCount - 1;
                                this.fillSubCmd(cmd, tokens, lastCommandEnd, internalCount - 1);
                                lastCommandEnd = internalCount - 1;
                                break;
                            }
                            if (outerContinue) continue;
                        }
                        if (subCmd != null && (tokenLower.startsWith("wra") || tokenLower.startsWith("tru"))) {
                            for (int peekBack = lastCommandEnd + 1; peekBack < i; ++peekBack) {
                                if (!tokens[peekBack].toLowerCase(Locale.US).startsWith("serverout")) continue;
                                subCmd = null;
                                break;
                            }
                        }
                        if (subCmd != null && tokenLower.startsWith("tru")) {
                            for (int peekBack = lastCommandEnd + 1; peekBack < i; ++peekBack) {
                                if (!tokens[peekBack].toLowerCase(Locale.US).startsWith("reset")) continue;
                                subCmd = null;
                                break;
                            }
                        }
                        if (subCmd != null && tokenLower.startsWith("linenum")) {
                            subCmd = null;
                            break;
                        }
                        if (subCmd != null && (tokenLower.equals("table") || tokenLower.equals("worksheetname") || tokenLower.equals("spool"))) {
                            subCmd = null;
                        } else if (subCmd == null) {
                            allTokens = this.checkAllTokens(tokenLower);
                            if (allTokens && (tokenLower.startsWith("wra") || tokenLower.startsWith("tru"))) {
                                for (int peekBack = lastCommandEnd + 1; peekBack < i; ++peekBack) {
                                    if (!tokens[peekBack].toLowerCase(Locale.US).startsWith("serverout")) continue;
                                    allTokens = false;
                                    break;
                                }
                            }
                            if (allTokens && (tokenLower.equals("context") || tokenLower.equals("default"))) {
                                allTokens = false;
                            }
                            if (allTokens && (tokenLower.equals("table") || tokenLower.equals("worksheetname") || tokenLower.equals("spool"))) {
                                allTokens = false;
                            }
                        }
                        if (tokenLower.equals("head") && tokens[lastCommandEnd + 1].toLowerCase(Locale.US).startsWith("mark") && i + 1 != tokens.length - 1 && !tokens[i + 1].toLowerCase(Locale.US).equals("on") && !tokens[i + 1].toLowerCase(Locale.US).equals("off")) {
                            subCmd = null;
                            allTokens = false;
                        }
                    }
                    String lastLower = "";
                    String secondLastLower = "";
                    if (subCmd != null || allTokens) {
                        lastLower = tokens[i - 1].toLowerCase(Locale.US);
                        if (i > lastCommandEnd + 1) {
                            secondLastLower = tokens[i - 2].toLowerCase(Locale.US);
                        }
                        if (i > lastCommandEnd + 1 && (tokens[lastCommandEnd + 1].toLowerCase(Locale.US).startsWith("errorl") && (lastLower.equals("table") || lastLower.equals("identifier")) && !secondLastLower.equals("table") && !secondLastLower.equals("identifier") || tokens[lastCommandEnd + 1].toLowerCase(Locale.US).startsWith("mark") && (lastLower.equals("table") || lastLower.equals("body") || lastLower.equals("head")) && !secondLastLower.equals("table") && !secondLastLower.equals("body") && !secondLastLower.equals("head"))) {
                            subCmd = null;
                        } else if (i == lastCommandEnd + 2 && (lastLower.startsWith("appi") || lastLower.startsWith("editf") || lastLower.startsWith("colsep") || lastLower.equals("null") || lastLower.startsWith("pau") || lastLower.startsWith("worksheetname") || lastLower.startsWith("numf") || lastLower.startsWith("sqlco") || lastLower.startsWith("sqlp") || lastLower.equals("instance") || lastLower.equals("logsource") || lastLower.startsWith("suf"))) {
                            subCmd = null;
                        } else if ((i - lastCommandEnd) % 2 == 1 && tokens[lastCommandEnd + 1].toLowerCase().equals("xquery") && (lastLower.equals("context") || lastLower.equals("baseuri"))) {
                            subCmd = null;
                        }
                    }
                    if (subCmd == null && !allTokens) continue;
                    SQLCommand lastAdded = this.fillSubCmd(cmd, tokens, lastCommandEnd, i - 1);
                    lastCommandEnd = i - 1;
                    if (lastAdded != null && lastAdded.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_UNKNOWN)) break;
                }
                if (lastCommandEnd != tokens.length - 1) {
                    this.fillSubCmd(cmd, tokens, lastCommandEnd, tokens.length - 1);
                }
            }
        }
    }

    private void checkIfCompoundSetCommand(SQLCommand stmtProperties, String line) {
        Boolean parsed = (Boolean)stmtProperties.getProperty("SET_PARSED");
        if (!(parsed != null && parsed.booleanValue() || line == null)) {
            String[] tokens = null;
            String theSet = "set";
            if (line.trim().substring(0, 3).equalsIgnoreCase("set") && (tokens = ScriptParser.getTokens(line)).length > 3) {
                this.m_isFirstPartOfCompoundSetStmt = true;
            }
        }
    }

    private SQLCommand fillSubCmd(SQLCompoundCommand compCmd, String[] tokens, int lastEnd, int thisEnd) {
        SQLCommand subCmd = this.getSetCommand(tokens[lastEnd + 1]);
        if (subCmd == null) {
            subCmd = new SQLCommand(SQLCommand.StmtType.G_C_SQLPLUS, SQLCommand.StmtSubType.G_S_SET_UNKNOWN, SQLCommand.StmtResultType.G_R_NONE, false, Restricted.Level.UNKNOWN);
        }
        if (subCmd != null || tokens[lastEnd + 1].equalsIgnoreCase("worksheetname")) {
            int i;
            compCmd.addCommand(subCmd);
            String theSet = "set";
            if (compCmd.getOrigSQL().trim().length() > 3 && compCmd.getOrigSQL().trim().substring(0, 3).equalsIgnoreCase(theSet)) {
                theSet = compCmd.getOrigSQL().trim().substring(0, 3);
            }
            StringBuffer setStringBuffer = new StringBuffer(theSet);
            for (int j = lastEnd + 1; j <= thisEnd && j < tokens.length; ++j) {
                if (tokens[j] == null) continue;
                setStringBuffer.append(" " + tokens[j]);
            }
            subCmd.setOrigStartLine(compCmd.getOrigStartLine());
            subCmd.setOrigEndLine(compCmd.getOrigEndLine());
            subCmd.setStartLine(compCmd.getStartLine());
            subCmd.setEndLine(compCmd.getEndLine());
            subCmd.setOrigSQL(setStringBuffer.toString());
            subCmd.setModifiedSQL(subCmd.getOrigSQL());
            if (this.m_setSubCommandCount > 0 && !this.m_isFirstPartOfCompoundSetStmt) {
                subCmd.setIsSetCompoundCmd(true);
                subCmd.setCompoundSetcmd(null);
            }
            if (thisEnd >= (i = lastEnd + 1) + 1) {
                String propertyNotLowered = tokens[i + 1];
                String property = propertyNotLowered.toLowerCase();
                if (property.equals("on")) {
                    subCmd.setProperty("prop_status_boolean", Boolean.TRUE);
                } else if (property.equals("off")) {
                    subCmd.setProperty("prop_status_boolean", Boolean.FALSE);
                }
                if (propertyNotLowered != null && !propertyNotLowered.equals("")) {
                    subCmd.setProperty("prop_file_string", propertyNotLowered);
                } else {
                    subCmd.setProperty("prop_file_string", property);
                }
                if (subCmd.getProperty("prop_status_boolean") == null) {
                    subCmd.setProperty("prop_status_boolean", Boolean.TRUE);
                }
                if (subCmd.getProperty("prop_status_boolean") == null) {
                    subCmd.setProperty("prop_status_boolean", new Boolean(true));
                }
            } else if (!subCmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_UNKNOWN)) {
                this.setError(subCmd);
            }
        } else {
            compCmd.setStmtSubType(SQLCommand.StmtSubType.G_S_SET_UNKNOWN);
        }
        return subCmd;
    }

    private boolean checkAllTokens(String token) {
        String[] cutOn;
        for (String key : cutOn = new String[]{"appi", "array", "auto", "blo", "cmds", "colsep", "con", "copyc", "copytypecheck", "def", "describe", "echo", "editf", "emb", "errorl", "esc", "exitc", "feed", "flagger", "flu", "hea", "instrance", "lin", "lobof", "logsource", "long", "mark", "newp", "null", "num", "pages", "prompt", "pau", "recsep", "secureliteral", "serverout", "shift", "show", "sqlbl", "sqlc", "sqln", "sqlpluscompat", "sqlpre", "sqlp", "sqlt", "suf", "tab", "term", "ti", "trim", "und", "ver", "wra", "xmlopt", "xquery"}) {
            if (!token.startsWith(key)) continue;
            return true;
        }
        return false;
    }

    private SQLCommand getSetCommand(String token) {
        String tokenLower = token.toLowerCase(Locale.US);
        Set<String> keys = SQLStatementTypes.setCommandsExact.keySet();
        for (String key : keys) {
            if (!tokenLower.equals(key)) continue;
            return SQLStatementTypes.setCommandsExact.get(key);
        }
        keys = SQLStatementTypes.setCommands.keySet();
        for (String key : keys) {
            if (!tokenLower.startsWith(key)) continue;
            return SQLStatementTypes.setCommands.get(key);
        }
        return null;
    }

    public static String[] getTokens(String line) {
        line = line.replaceAll("\r\n|[\r\n\u2028\u2029\u0085]|\t", " ");
        line = line.replace("  ", " ");
        if ((line = line.trim()).endsWith(";")) {
            line = line.substring(0, line.length() - 1);
        }
        State currentState = State.NORM;
        ArrayList<String> myTokens = new ArrayList<String>();
        int lastFlush = 0;
        block5: for (int i = 0; i < line.length(); ++i) {
            switch (currentState) {
                case INQUOTE: {
                    if (line.charAt(i) != '\'') continue block5;
                    if (i == line.length() - 1 || line.charAt(i + 1) != '\'') {
                        currentState = State.NORM;
                        myTokens.add(line.substring(lastFlush, i + 1));
                        while (i + 1 != line.length() && line.charAt(i + 1) == ' ') {
                            ++i;
                        }
                        lastFlush = i + 1;
                        continue block5;
                    }
                    if (i == line.length() - 1 || line.charAt(i + 1) != '\'') continue block5;
                    ++i;
                    continue block5;
                }
                case INDOUBLEQUOTE: {
                    if (line.charAt(i) != '\"') continue block5;
                    if (i == line.length() - 1 || line.charAt(i + 1) != '\"') {
                        currentState = State.NORM;
                        myTokens.add(line.substring(lastFlush, i + 1));
                        while (i + 1 != line.length() && line.charAt(i + 1) == ' ') {
                            ++i;
                        }
                        lastFlush = i + 1;
                        continue block5;
                    }
                    if (i == line.length() - 1 || line.charAt(i + 1) != '\"') continue block5;
                    ++i;
                    continue block5;
                }
                case NORM: {
                    if (line.charAt(i) == '\'') {
                        if (i != 0 && line.charAt(i - 1) != ' ') continue block5;
                        currentState = State.INQUOTE;
                        continue block5;
                    }
                    if (line.charAt(i) == '\"') {
                        if (i != 0 && line.charAt(i - 1) != ' ') continue block5;
                        currentState = State.INDOUBLEQUOTE;
                        continue block5;
                    }
                    if (line.charAt(i) != ' ') continue block5;
                    myTokens.add(line.substring(lastFlush, i));
                    while (i + 1 != line.length() && line.charAt(i + 1) == ' ') {
                        ++i;
                    }
                    lastFlush = i + 1;
                }
            }
        }
        if (lastFlush != line.length()) {
            myTokens.add(line.substring(lastFlush));
        }
        return myTokens.toArray(new String[myTokens.size()]);
    }

    private SQLCommand createUnknownStatementProperties() {
        return new SQLCommand(SQLCommand.StmtType.G_C_SQLPLUS, SQLCommand.StmtSubType.G_S_UNKNOWN, SQLCommand.StmtResultType.G_R_UNKNOWN, true, Restricted.Level.UNKNOWN);
    }

    private SQLCommand getPropertiesWhenNoSpaceRequired(String line) {
        SQLCommand prop = null;
        if (line == null || line.trim().length() == 0) {
            return null;
        }
        String input = null;
        if ((line = line.trim()).length() >= 2) {
            input = line.trim().substring(0, 2);
            if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(input)) {
                prop = SQLStatementTypes.noSpaceRequiredTokens.get(input);
            } else {
                input = line.trim().substring(0, 1);
                if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(input)) {
                    prop = SQLStatementTypes.noSpaceRequiredTokens.get(input);
                }
            }
        } else {
            input = line;
            if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(input)) {
                prop = SQLStatementTypes.noSpaceRequiredTokens.get(input);
            }
        }
        return prop;
    }

    private SQLCommand getPropertiesWhenTokensKnown(String line) {
        String[] tokens = line.trim().split("[ \n\r\t*=\\-]");
        if (tokens.length > 0 && tokens[0] != null) {
            if (tokens[0].length() > 0 && tokens[0].charAt(tokens[0].length() - 1) == ';') {
                tokens[0] = tokens[0].replaceAll(";", "");
            }
            return SQLStatementTypes.spaceRequiredTokens.get(tokens[0].toLowerCase(Locale.ENGLISH));
        }
        return null;
    }

    private boolean isWrapped(String currentStatement, SQLCommand stmtProperties) {
        Boolean declaredWrapped = (Boolean)stmtProperties.getProperty("prop_is_wrapped");
        if (declaredWrapped != null && declaredWrapped.equals(Boolean.TRUE)) {
            return declaredWrapped;
        }
        String lowercaseStmt = currentStatement.toLowerCase();
        if (lowercaseStmt.indexOf("wrapped") == -1) {
            return false;
        }
        boolean result = false;
        String commentLessLowerCase = this.checkInLineComments(lowercaseStmt);
        int wrappedStart = commentLessLowerCase.indexOf("wrapped");
        if (wrappedStart > 2 && commentLessLowerCase.length() > wrappedStart + 8) {
            char charBefore = commentLessLowerCase.charAt(wrappedStart - 1);
            char charAfter = commentLessLowerCase.charAt(wrappedStart + 7);
            if (Character.isWhitespace(charBefore) && Character.isWhitespace(charAfter)) {
                result = true;
                stmtProperties.setProperty("prop_is_wrapped", true);
            }
        }
        return result;
    }

    private StringBuffer findEndOfSQLAndPLSQL(String line, BufferedReaderStack reader, SQLCommand stmtProperties, boolean semiColonTerminatesIn) throws IOException {
        this.createRefine = stmtProperties;
        this.createRefineSemiColonTerminates = semiColonTerminatesIn;
        StringBuffer currentStatement = new StringBuffer();
        boolean searching = true;
        boolean enquote = false;
        int embeddedSemicolon = 0;
        String stmtTerminator = null;
        while (searching) {
            int quotes;
            int initialSemicolon = -1;
            if (line == null) {
                quotes = 0;
            } else {
                boolean returnOnSemiColon = true;
                if (stmtProperties.getStmtType() == SQLCommand.StmtType.G_C_PLSQL || stmtProperties.getProperty(TERMINATOR) != null && stmtProperties.getProperty(TERMINATOR) == FORWARDSLASH) {
                    returnOnSemiColon = false;
                }
                this.createRefineReturnOnSemicolon = returnOnSemiColon;
                if (this.createRefine.getProperty("CREATEREFINE") != null && this.createRefine.getProperty("CREATEREFINE").equals(Boolean.TRUE)) {
                    this.createRefineLineSoFar = new StringBuffer(currentStatement);
                    if (line != null) {
                        this.createRefineLineSoFar.append("\n").append(line);
                    }
                }
                int[] retval = this.numberOfQuotes(line, true, true);
                quotes = retval[0];
                embeddedSemicolon = retval[1];
                initialSemicolon = retval[2];
            }
            if (quotes % 2 != 0) {
                enquote = !enquote;
            }
            Boolean classic = this._scriptRunnerContext != null && this._scriptRunnerContext.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this._scriptRunnerContext.getProperty("sqlplus.classic.mode").toString());
            if (this.createRefineReturnOnSemicolon && line.trim().endsWith(";") && (classic.booleanValue() || !classic.booleanValue() && !enquote && initialSemicolon != -1 && line.lastIndexOf(";") == initialSemicolon)) {
                enquote = false;
                embeddedSemicolon = 0;
            }
            if (line != null && !this.createRefineSemiColonTerminates && enquote && (line.trim().endsWith("\n/") || line.trim().equals(FORWARDSLASH)) && this.isWrapped(currentStatement.toString(), stmtProperties)) {
                quotes = 0;
                enquote = false;
            }
            if (line != null && !enquote) {
                if (initialSemicolon != -1 && this.createRefineSemiColonTerminates) {
                    if (line.length() != initialSemicolon + 1) {
                        this.setLeftOver(line.substring(initialSemicolon + 1));
                        if (this.getLeftOver().trim().equals("")) {
                            this.setLeftOver(null);
                        }
                    } else {
                        this.setLeftOver(null);
                    }
                    line = line.substring(0, initialSemicolon);
                    stmtTerminator = ";";
                    searching = false;
                } else if (line.trim().endsWith(";") && embeddedSemicolon == 0 && this.createRefineSemiColonTerminates && (classic.booleanValue() || !classic.booleanValue() && !enquote && initialSemicolon != -1 && line.lastIndexOf(";") == initialSemicolon)) {
                    searching = false;
                    line = line.substring(0, line.lastIndexOf(";"));
                    stmtTerminator = ";";
                } else if (this.hasForwardSlashOnLastLine(line)) {
                    searching = false;
                    line = line.substring(0, line.lastIndexOf(FORWARDSLASH));
                    stmtTerminator = FORWARDSLASH;
                    if (stmtProperties.getProperty(TERMINATOR) != null && stmtProperties.getProperty(TERMINATOR) == FORWARDSLASH && currentStatement.toString().trim().endsWith(";")) {
                        int i = currentStatement.length() - 1;
                        while (currentStatement.charAt(i) != ';') {
                            currentStatement.deleteCharAt(i);
                            --i;
                        }
                        currentStatement.deleteCharAt(i);
                        stmtTerminator = ";\n/";
                    }
                } else if (line.trim().equals(".") && (!this.inMultilineComment(currentStatement) || classic.booleanValue()) && this._scriptRunnerContext != null && this._scriptRunnerContext.isCommandLine()) {
                    searching = false;
                    line = line.substring(0, line.lastIndexOf("."));
                    stmtTerminator = ".";
                    stmtProperties.setExecutable(false);
                    stmtProperties.setRunnable(false);
                }
                if (!line.trim().equals("")) {
                    currentStatement.append(line);
                }
                if (searching) {
                    line = reader.readline(true, false, null, true, this.stateInitial());
                    if (line != null) {
                        currentStatement.append("\n");
                    }
                    ++this.m_readerLineCnt;
                }
            } else {
                if (!line.trim().equals("")) {
                    currentStatement.append(line);
                }
                if ((line = reader.readLine()) != null) {
                    currentStatement.append("\n");
                }
                ++this.m_readerLineCnt;
            }
            if (searching && (line == null && (stmtProperties.getStmtType() != SQLCommand.StmtType.G_C_SQL || stmtProperties.getStmtType() == SQLCommand.StmtType.G_C_SQL && !this.isSQLBlankLines()) || line != null && line.trim().equals("") && stmtProperties.getStmtType() == SQLCommand.StmtType.G_C_SQL && !this.isSQLBlankLines())) {
                searching = false;
                if (!this.isInFile() || this.isEndOnEOF()) continue;
                stmtProperties.setIsComplete(false);
                stmtProperties.setExecutable(false);
                stmtProperties.setRunnable(false);
                continue;
            }
            if (!searching || line != null) continue;
            searching = false;
        }
        stmtProperties.setOrigStartLine(this.m_readerLineStartCnt);
        stmtProperties.setOrigEndLine(this.m_readerLineCnt);
        stmtProperties.setStatementTerminator(stmtTerminator);
        return currentStatement;
    }

    StringBuffer parseProperly(String line, SQLCommand stmtProperties) {
        if (stmtProperties.getStmtSubType() == SQLCommand.StmtSubType.G_S_COMMENT_PLUS) {
            return null;
        }
        if (this.m_rawSQL == null || 1000000 < this.m_rawSQL.length()) {
            this.bailOut = true;
        }
        if (this.bailOut == Boolean.TRUE) {
            return null;
        }
        if (this.src == null) {
            this.src = new ArrayList<LexerToken>();
            this.fullSrc = new ArrayList<LexerToken>();
            try {
                new Lexer().doParse(this.m_rawSQL, 63, "", (ArrayList)this.src, (ArrayList)this.fullSrc, null);
            }
            catch (ParsingCancelled e) {
                return null;
            }
        }
        if (this.bailOut == null) {
            this.bailOut = this.bailOut();
        }
        if (this.bailOut.booleanValue()) {
            return null;
        }
        if (this.lineMap == null) {
            this.lineMap = Service.lineMap((String)this.m_rawSQL);
        }
        if (this.root == null) {
            this.root = SqlEarley.getInstance().parse(this.src);
        }
        if (this.stmts == null) {
            this.stmts = this.statements(this.root);
        }
        for (ParseNode stmt : this.stmts) {
            if (!stmt.contains("START")) continue;
            return null;
        }
        if (0 < this.src.size() && this.root.topLevel == null && (this.root.contains("sql_statements") || this.root.contains("sql_statement"))) {
            try {
                ParseNode stmt = this.stmts.get(this.stmtNo);
                ParseNode next = null;
                if (this.stmtNo + 1 < this.stmts.size()) {
                    next = this.stmts.get(this.stmtNo + 1);
                }
                return this.recognizedSqlStatement(line, stmtProperties, stmt, next);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    List<ParseNode> statements(ParseNode root) {
        ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
        if (root.contains(SqlEarley.getInstance().sql_statement)) {
            ret.add(root);
        }
        for (ParseNode child : root.children()) {
            ret.addAll(this.statements(child));
        }
        return ret;
    }

    public boolean bailOut() {
        if (this.fullSrc == null) {
            return true;
        }
        for (LexerToken t : this.fullSrc) {
            if (t.type == Token.LINE_COMMENT && t.content.toUpperCase().startsWith("PRO")) {
                return true;
            }
            if (!"TTITLE".equalsIgnoreCase(t.content)) continue;
            return true;
        }
        boolean sawSet = false;
        boolean sawJava = false;
        for (LexerToken t : this.src) {
            if ("MERGE".equalsIgnoreCase(t.content)) {
                return false;
            }
            if (sawSet && "SQLTERMINATOR".equalsIgnoreCase(t.content)) {
                return true;
            }
            if (sawJava && "SOURCE".equalsIgnoreCase(t.content)) {
                return false;
            }
            sawSet = "SET".equalsIgnoreCase(t.content);
            if (!"JAVA".equalsIgnoreCase(t.content)) continue;
            sawJava = true;
        }
        return true;
    }

    private StringBuffer recognizedSqlStatement(String line, SQLCommand stmtProperties, ParseNode stmt, ParseNode next) {
        ParseNode terminator = stmt.leafAtPos(stmt.to - 1);
        stmtProperties.setIsComplete(true);
        stmtProperties.setExecutable(true);
        stmtProperties.setRunnable(true);
        stmtProperties.setOrigStartLine(Service.charPos2LineNo0((int[])this.lineMap, (int)this.src.get((int)stmt.from).begin));
        stmtProperties.setOrigEndLine(Service.charPos2LineNo0((int[])this.lineMap, (int)this.src.get((int)(stmt.to - 1)).begin));
        ++this.stmtNo;
        if (next != null) {
            String leftover = this.m_rawSQL.substring(this.src.get((int)next.from).begin, this.src.get((int)(next.to - 1)).end);
            this.setLeftOver(leftover);
        } else {
            this.setLeftOver(null);
            this.m_reader.clear();
        }
        String sql = this.m_rawSQL.substring(this.src.get((int)stmt.from).begin, this.src.get((int)(stmt.to - 1)).end);
        if (terminator != null && this.src.get((int)terminator.from).type == Token.OPERATION) {
            stmtProperties.setStatementTerminator(this.src.get((int)terminator.from).content);
            if (terminator.contains("'/'")) {
                sql = this.m_rawSQL.substring(this.src.get((int)stmt.from).begin, this.src.get((int)(terminator.from - 1)).end);
            } else {
                if (terminator.from < 1) {
                    return new StringBuffer(sql);
                }
                if (this.src.get((int)(terminator.from - 1)).content.toLowerCase().equals("end")) {
                    return new StringBuffer(sql);
                }
                if (1 < terminator.from && this.src.get((int)(terminator.from - 2)).content.toLowerCase().equals("end")) {
                    return new StringBuffer(sql);
                }
                sql = this.m_rawSQL.substring(this.src.get((int)stmt.from).begin, this.src.get((int)(terminator.from - 1)).end);
            }
        }
        return new StringBuffer(sql);
    }

    private boolean inMultilineComment(StringBuffer currentStatement) {
        String processLine;
        int endOfMultilineComment;
        int startOfMultilineComment = currentStatement.lastIndexOf("/*");
        return startOfMultilineComment > (endOfMultilineComment = currentStatement.lastIndexOf("*/")) && (startOfMultilineComment = (processLine = currentStatement.toString().replaceAll("'(.)*'", "")).lastIndexOf("/*")) > (endOfMultilineComment = processLine.lastIndexOf("*/"));
    }

    private boolean hasForwardSlashOnLastLine(String line) {
        try {
            if (line == null) {
                return false;
            }
            if (line.trim().endsWith(System.getProperty("line.separator") + FORWARDSLASH) || line.trim().equals(FORWARDSLASH)) {
                return true;
            }
            int lastLineIndex = line.lastIndexOf("\n");
            if (lastLineIndex == -1) break block6;
            String lastLine = line.substring(lastLineIndex + 1);
            if (lastLine.trim().equals(FORWARDSLASH)) {
                return true;
            }
        }
        finally {
            return false;
        }
        {
            block6: {
            }
        }
    }

    private boolean isBareConnect(SQLCommand stmtProperties, String soFar) {
        return stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CONNECT) && soFar.trim().indexOf(" ") == -1 && soFar.indexOf("\n") == -1;
    }

    private StringBuffer findEndOfSQLPLUS(String line, BufferedReaderStack reader, SQLCommand stmtProperties) throws IOException {
        StringBuffer currentStatement = new StringBuffer();
        boolean searching = true;
        while (searching) {
            boolean isBareConnect = this.isBareConnect(stmtProperties, currentStatement + line);
            if (isBareConnect || line.trim().endsWith("-") && !line.trim().startsWith("--")) {
                searching = true;
                currentStatement.append(line + "\n");
                line = reader.readline(true, false, null, true, this.stateInitial());
                ++this.m_readerLineCnt;
                if (line != null) continue;
                searching = false;
                continue;
            }
            searching = false;
            currentStatement.append(line + "\n");
        }
        stmtProperties.setOrigStartLine(this.m_readerLineStartCnt);
        stmtProperties.setOrigEndLine(this.m_readerLineCnt);
        if (currentStatement.toString().trim().endsWith(";") && currentStatement.length() > 1) {
            String s = currentStatement.substring(0, currentStatement.lastIndexOf(";"));
            currentStatement = new StringBuffer(s);
            stmtProperties.setStatementTerminator(";");
        }
        return currentStatement;
    }

    @Override
    public StringBuffer customFindEndOfStatement(String line, BufferedReaderStack reader, SQLCommand stmtProperties) throws IOException {
        return this.findEndOfSQLPLUS(line, reader, stmtProperties);
    }

    private StringBuffer findEndOfMultiLineComment(String line, BufferedReaderStack reader, SQLCommand stmtProperties) throws IOException {
        StringBuffer currentStatement = new StringBuffer();
        boolean searching = true;
        while (searching) {
            int nearEndOfComment = line.indexOf("*/");
            if (nearEndOfComment >= 0) {
                searching = false;
                if (nearEndOfComment + 2 == line.length()) {
                    this.setLeftOver(null);
                } else {
                    this.setLeftOver(line.substring(nearEndOfComment + 2));
                    if (this.getLeftOver().trim().equals("")) {
                        this.setLeftOver(null);
                    }
                    line = line.substring(0, nearEndOfComment + 2);
                }
                currentStatement.append(line + "\n");
                continue;
            }
            currentStatement.append(line + "\n");
            line = reader.readLine(false);
            ++this.m_readerLineCnt;
            if (line != null) continue;
            searching = false;
            currentStatement.append("*/");
        }
        stmtProperties.setOrigStartLine(this.m_readerLineStartCnt);
        stmtProperties.setOrigEndLine(this.m_readerLineCnt);
        return currentStatement;
    }

    private StringBuffer findEndOfOldComment(String line, BufferedReaderStack reader, SQLCommand stmtProperties) throws IOException {
        StringBuffer currentStatement = new StringBuffer();
        boolean searching = true;
        while (searching) {
            if (!line.trim().equals("#")) {
                currentStatement.append(line + "\n");
                line = reader.readLine(false);
                ++this.m_readerLineCnt;
                if (line != null) continue;
                searching = false;
                currentStatement.append("\n#\n");
                continue;
            }
            currentStatement.append(line + "\n");
            searching = false;
        }
        stmtProperties.setOrigStartLine(this.m_readerLineStartCnt);
        stmtProperties.setOrigEndLine(this.m_readerLineCnt);
        return currentStatement;
    }

    private SQLCommand identifyEndOfStatement(String line, BufferedReaderStack reader, SQLCommand stmtProperties) {
        StringBuffer currentStatement = new StringBuffer();
        try {
            if (this.customParsing) {
                currentStatement = this.customFindEndOfStatement(line, reader, stmtProperties);
            } else {
                StringBuffer tmp = this.parseProperly(line, stmtProperties);
                if (tmp != null) {
                    currentStatement = tmp;
                } else {
                    switch (stmtProperties.getStmtType()) {
                        case G_C_SQL: {
                            boolean semiColonTerminator = true;
                            if (stmtProperties.getProperty(TERMINATOR) != null && stmtProperties.getProperty(TERMINATOR) == FORWARDSLASH) {
                                semiColonTerminator = false;
                            }
                            currentStatement = this.findEndOfSQLAndPLSQL(line, reader, stmtProperties, semiColonTerminator);
                            break;
                        }
                        case G_C_SCRIPT: 
                        case G_C_PLSQL: {
                            currentStatement = this.findEndOfSQLAndPLSQL(line, reader, stmtProperties, false);
                            break;
                        }
                        case G_C_SQLPLUS: {
                            currentStatement = this.findEndOfSQLPLUS(line, reader, stmtProperties);
                            break;
                        }
                        case G_C_USERDEFINED: 
                        case G_C_COMMENT: {
                            currentStatement = this.findEndOfLine(line, stmtProperties);
                            break;
                        }
                        case G_C_UNKNOWN: {
                            s_logger.severe(ScriptRunnerDbArb.format("UNSUPPORTED_COMMAND_ARG", line));
                        }
                        case G_C_MULTILINECOMMENT: {
                            currentStatement = this.findEndOfMultiLineComment(line, reader, stmtProperties);
                            break;
                        }
                        case G_C_JDBC: {
                            currentStatement = this.findAllLines(line, reader, stmtProperties);
                            break;
                        }
                        case G_C_OLDCOMMENT: {
                            currentStatement = this.findEndOfOldComment(line, reader, stmtProperties);
                            break;
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            s_logger.severe(e.getLocalizedMessage());
        }
        this.initialiseState();
        if (currentStatement.length() > 0) {
            String currstmt = currentStatement.toString();
            if (!(stmtProperties.getStmtResultType() == null || stmtProperties.getStmtResultType() != SQLCommand.StmtResultType.G_R_QUERY && stmtProperties.getStmtResultType() != SQLCommand.StmtResultType.G_R_DML || this.isWrapped(currentStatement.toString(), stmtProperties))) {
                currstmt = this.checkInLineComments(currentStatement.toString());
                stmtProperties.setProperty("STRIPPED_CONTINUATION", Boolean.TRUE);
            }
            if (stmtProperties.getStmtResultType() != null && stmtProperties.getStmtSubType() == SQLCommand.StmtSubType.G_S_WITH && currstmt.trim().endsWith(";")) {
                currstmt = currstmt.trim().substring(0, currstmt.trim().length() - 1);
            }
            stmtProperties.setOrigSQL(currentStatement.toString());
            stmtProperties.setModifiedSQL(currstmt);
        } else {
            stmtProperties.setOrigSQL(currentStatement.toString());
            stmtProperties.setModifiedSQL(currentStatement.toString());
        }
        if (stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET) && stmtProperties instanceof SQLCompoundCommand) {
            SQLCompoundCommand localCompound = (SQLCompoundCommand)stmtProperties;
            String stmt_terminator = null;
            if (stmtProperties.getStatementTerminator() != null) {
                stmt_terminator = stmtProperties.getStatementTerminator();
            }
            if (this.m_setSubCommandCount == 0) {
                this.checkIfCompoundSetCommand(localCompound, line);
            }
            this.lateEvaluateInitCompoundSetCommand(localCompound, this.getSetLeftOver() != null);
            if (!stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_UNKNOWN)) {
                if (this.getSetLeftOver() == null) {
                    if (this.getLeftOver() == null) {
                        this.setSetLeftOver("");
                    } else {
                        this.setSetLeftOver(this.getLeftOver());
                    }
                }
                List<SQLCommand> theCommands = localCompound.getCommands();
                if (this.m_isFirstPartOfCompoundSetStmt) {
                    this.m_setSubCommandCount = theCommands.size();
                }
                Object unusedTokens = "set ";
                boolean setMade = false;
                for (SQLCommand aCommand : theCommands) {
                    if (!setMade) {
                        stmtProperties = aCommand;
                        if (stmt_terminator != null) {
                            stmtProperties.setStatementTerminator(stmt_terminator);
                        }
                        setMade = true;
                        continue;
                    }
                    unusedTokens = (String)unusedTokens + aCommand.getSql().trim().substring(3).trim() + " ";
                }
                if (theCommands.size() == 1) {
                    if (!this.getSetLeftOver().trim().equals("")) {
                        this.setLeftOver(this.getSetLeftOver());
                    }
                    this.setSetLeftOver(null);
                } else {
                    this.setLeftOver((String)unusedTokens);
                }
            }
            this.resolveCompoundSetCommands(stmtProperties, line);
        } else if (this.getSetLeftOver() != null) {
            this.setLeftOver(this.getSetLeftOver());
            this.setSetLeftOver(null);
        }
        return stmtProperties;
    }

    private StringBuffer findAllLines(String line, BufferedReaderStack reader, SQLCommand stmtProperties) throws IOException {
        StringBuffer currentStatement = new StringBuffer();
        while (line != null) {
            currentStatement.append(line + "\n");
            line = reader.readLine(false);
            ++this.m_readerLineCnt;
        }
        stmtProperties.setOrigStartLine(this.m_readerLineStartCnt);
        stmtProperties.setOrigEndLine(this.m_readerLineCnt);
        return currentStatement;
    }

    private StringBuffer findEndOfLine(String line, SQLCommand stmtProperties) {
        StringBuffer currentStatement = new StringBuffer();
        currentStatement.append(line + "\n");
        stmtProperties.setOrigStartLine(this.m_readerLineStartCnt);
        stmtProperties.setOrigEndLine(this.m_readerLineCnt);
        return currentStatement;
    }

    private String checkInLineComments(String currstmt) {
        currstmt = ScriptUtils.checkforContinuationChars(currstmt);
        return currstmt;
    }

    protected String getTop(String inString) {
        Object top = null;
        this._numOfEmptyLineAbove = 0;
        try {
            if (inString == null) {
                top = this.m_reader.readTopLine();
                ++this.m_readerLineCnt;
            } else {
                top = inString;
            }
            if (top == null) {
                return null;
            }
            while (this.isWhitespaceLTrim((String)top).equals("")) {
                ++this._numOfEmptyLineAbove;
                top = this.m_reader.readTopLine();
                ++this.m_readerLineCnt;
                if (top != null) continue;
                return null;
            }
            if (top != null) {
                top = this.isWhitespaceLTrim((String)top);
            }
            this.m_readerLineStartCnt = this.m_readerLineCnt;
            String topTrimLowerCase = ((String)top).trim().toLowerCase();
            if (topTrimLowerCase.startsWith("create") || topTrimLowerCase.startsWith("drop") || topTrimLowerCase.startsWith("alter") || topTrimLowerCase.startsWith("with")) {
                String currLine = top;
                String currLineLowerCase = null;
                while (currLine != null && currLine.indexOf(";") == -1 && currLine.indexOf(FORWARDSLASH) == -1 && (currLineLowerCase = currLine.toLowerCase()).indexOf("begin") == -1 && currLineLowerCase.indexOf("wrapped") == -1) {
                    currLine = this.m_reader.readline(true, true, (String)top, false, false);
                    if (currLine != null) {
                        top = (String)top + "\n" + currLine;
                    }
                    ++this.m_readerLineCnt;
                }
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return top;
    }

    private String isWhitespaceLTrim(String top) {
        if (top == null || top.equals("")) {
            return top;
        }
        int firstNonWhitespace = -1;
        int lastNewLine = -1;
        for (int i = 0; i < top.length(); ++i) {
            if (!Character.isWhitespace(top.charAt(i))) {
                firstNonWhitespace = i;
                break;
            }
            if (top.charAt(i) != '\n') continue;
            lastNewLine = i;
        }
        if (firstNonWhitespace == -1) {
            top = "";
        } else if (firstNonWhitespace != 0) {
            if (0 < lastNewLine + 1 && lastNewLine + 1 <= firstNonWhitespace) {
                top = top.substring(lastNewLine + 1);
            } else if (lastNewLine == -1) {
                // empty if block
            }
        }
        return top;
    }

    public String getRawSQL() {
        return this.m_rawSQL;
    }

    public void setRawSQL(String rawSQL) {
        this.m_rawSQL = rawSQL;
    }

    public ISQLCommand[] getSqlStatements() {
        return this.m_sqlArray.toArray(new SQLCommand[this.m_sqlArray.size()]);
    }

    boolean isQuoteStringValid(String quoteString) {
        boolean retVal = true;
        if (quoteString.equals("\t") || quoteString.equals("\r") || quoteString.equals("\n") || quoteString.equals(" ")) {
            retVal = false;
        }
        return retVal;
    }

    private boolean isEndOnEOF() {
        Boolean endOnEOF = Boolean.FALSE;
        if (this._scriptRunnerContext != null) {
            endOnEOF = (Boolean)this._scriptRunnerContext.getProperty("sqcl.alias.end_statement_on_eof");
        }
        if (endOnEOF == null) {
            endOnEOF = Boolean.FALSE;
        }
        return endOnEOF;
    }

    private boolean isInFile() {
        if (this._scriptRunnerContext == null) {
            return false;
        }
        return this._scriptRunnerContext.getProperty("script.runner.appinfo.arraylist") != null && ((ArrayList)this._scriptRunnerContext.getProperty("script.runner.appinfo.arraylist")).size() > 0;
    }

    private boolean isSQLBlankLines() {
        if (this._scriptRunnerContext == null) {
            return true;
        }
        String sqlbl = (String)this._scriptRunnerContext.getProperty("SQLBLANKLINES");
        boolean on = false;
        on = sqlbl == null ? false : sqlbl.equals("on");
        return on;
    }

    public void setScriptRunnerContext(ScriptRunnerContext runCtx) {
        this._scriptRunnerContext = runCtx;
    }

    static enum State {
        NORM,
        INQUOTE,
        INDOUBLEQUOTE;

    }
}

