/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Stack;
import oracle.dbtools.raptor.newscriptrunner.CoreScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ExecutePathCheckReturn;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

public class BufferedReaderStack
extends Stack<BufferedReader> {
    ScriptRunnerContext _scriptRunnerContext = null;
    Stack<String> _dirs = new Stack();

    public BufferedReaderStack(BufferedReader br) {
        this.push(br);
    }

    @Override
    public synchronized BufferedReader push(BufferedReader br) {
        return super.push(br);
    }

    @Override
    public synchronized BufferedReader pop() {
        return (BufferedReader)super.pop();
    }

    public String readLine() throws IOException {
        return this.readLine(true);
    }

    public String readLine(boolean live) throws IOException {
        return this.readline(live, false, null, false, false);
    }

    public String readline(boolean live, boolean soFar, String soFarString, boolean stateKnown, boolean stateOK) throws IOException {
        String line = null;
        if (super.isEmpty()) {
            line = null;
        } else {
            line = ((BufferedReader)super.peek()).readLine();
            if (line == null) {
                this.popStack();
                line = this.readline(live, soFar, soFarString, stateKnown, stateOK);
            } else if (line.trim().startsWith("@") && live && this._scriptRunnerContext != null && !this._scriptRunnerContext.getRestrictedLevel().isRestricted(Restricted.Level.R3) && (stateKnown && stateOK || !stateKnown && soFar && this.processSoFar(soFarString, line))) {
                super.push(this.getReader(line));
                line = this.readLine(live);
            }
        }
        return line;
    }

    boolean processSoFar(String soFarString, String line) {
        if (soFarString == null || soFarString.equals("")) {
            return true;
        }
        String both = soFarString + "\n" + line;
        return CoreScriptParser.amIInitial(both.substring(0, both.lastIndexOf(line)), true, false);
    }

    private void popStack() {
        if (super.peek() != null) {
            super.pop();
        }
        if (!this._dirs.isEmpty()) {
            this._dirs.pop();
        }
    }

    private BufferedReader getReader(String line) throws FileNotFoundException {
        ExecutePathCheckReturn retVal;
        Reader reader;
        ScriptParser sp = new ScriptParser(line);
        sp.parse();
        ISQLCommand[] commands = sp.getSqlStatements();
        SQLPLUS sqlplus = new SQLPLUS(commands[0], null);
        sqlplus.setScriptRunnerContext(this._scriptRunnerContext);
        if (this._dirs.isEmpty() && this._scriptRunnerContext.getSourceRef().length() > 0) {
            this._dirs.push(this.getDir(this._scriptRunnerContext.getSourceRef()));
        }
        if (this._dirs.size() > 0) {
            sqlplus.setDirectory(this._dirs.peek());
        }
        if ((reader = this.getReader(retVal = sqlplus.checkMultiplePaths(commands[0]))) == null) {
            this.reportIssue(retVal, commands[0]);
        }
        this._dirs.push(this.getDir(this.getFile(retVal)));
        return new BufferedReader(reader);
    }

    private String getFile(ExecutePathCheckReturn retVal) {
        if (retVal.getOutputFile() != null) {
            return retVal.getOutputFile();
        }
        if (retVal.getUrl() != null) {
            return retVal.getUrl().getFile();
        }
        return null;
    }

    private Reader getReader(ExecutePathCheckReturn retVal) {
        if (retVal == null) {
            return null;
        }
        if (retVal.getLiveReader() != null) {
            return retVal.getLiveReader();
        }
        if (retVal.getOutputFile() != null) {
            try {
                return new BufferedReader(new InputStreamReader(new FileInputStream(new File(retVal.getOutputFile()))));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        } else if (retVal.getUrl() != null) {
            try {
                return new BufferedReader(new InputStreamReader(new FileInputStream(new File(retVal.getUrl().getFile()))));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private void reportIssue(ExecutePathCheckReturn retVal, ISQLCommand cmd) throws FileNotFoundException {
        if (retVal == null) {
            if (cmd != null) {
                throw new FileNotFoundException(cmd.getSQLOrig());
            }
            throw new FileNotFoundException();
        }
        if (retVal.getLastException() != null) {
            throw new FileNotFoundException(retVal.getLastException().getLocalizedMessage());
        }
        if (cmd != null) {
            throw new FileNotFoundException(cmd.getSQLOrig());
        }
        throw new FileNotFoundException();
    }

    private String getDir(String sourceRef) {
        File file = new File(sourceRef);
        if (file.isDirectory()) {
            return file.getAbsolutePath();
        }
        return file.getParentFile().getAbsolutePath();
    }

    public void setContext(ScriptRunnerContext src) {
        this._scriptRunnerContext = src;
    }

    public String readTopLine() throws IOException {
        if (this.isEmpty()) {
            return null;
        }
        String line = ((BufferedReader)super.peek()).readLine();
        if (line == null) {
            this.popStack();
            line = this.readTopLine();
        }
        return line;
    }
}

