/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extendedtype;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.extendedtype.AbstractExtendedType;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.sql.OPAQUE;

public class XMLExtendeType
extends AbstractExtendedType {
    protected XMLExtendeType(int sqlType, OPAQUE origValue) {
        super(sqlType, origValue);
    }

    public XMLExtendeType(OPAQUE data) {
        this(2009, data);
    }

    public void setValue(OPAQUE opaque) {
        this.setOrigValue(opaque);
    }

    public OPAQUE getObjectValue() {
        return this.getOrigValue();
    }

    @Override
    public OPAQUE getOrigValue() {
        return (OPAQUE)super.getOrigValue();
    }

    public String toString() {
        try {
            URL _selectedURL = this.getLoadFromURL();
            if (_selectedURL != null) {
                return "[" + _selectedURL != null ? _selectedURL.toString() : "]";
            }
            if (this.getOrigValue() != null) {
                return DataTypesUtil.stringValue(this.getOrigValue(), (Connection)this.getOrigValue().getOracleConnection());
            }
        }
        catch (SQLException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return "";
    }

    @Override
    public void duplicate() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(Boolean orig) throws Exception {
        if (orig == null && this.getLoadFromURL() != null || orig != null && !orig.booleanValue()) {
            return super.getBinaryStream(orig);
        }
        if (this.getOrigValue() != null) {
            return DataTypesUtil.getBinaryStream(this.getOrigValue());
        }
        return null;
    }

    @Override
    public InputStream getCharStream() throws SQLException {
        return null;
    }

    @Override
    public Reader getReader(Boolean orig, String defaultCharset) throws Exception {
        URL loadFrom = this.getLoadFromURL();
        if (orig == null && loadFrom != null || orig != null && !orig.booleanValue()) {
            if (loadFrom != null) {
                return DataTypesUtil.getXMLAsReader(loadFrom, defaultCharset);
            }
        } else {
            return DataTypesUtil.getCharacterStream(this.getOrigValue());
        }
        return null;
    }

    @Override
    public boolean saveToDb(Connection conn, String tableName, String columnName, String rowId, String rowScn, boolean dataIntegrity, List<String> log) throws SQLException, IOException {
        try (Statement prep = null;){
            URL _selectedURL = this.getLoadFromURL();
            SQLXML dbXmlType = null;
            if (_selectedURL != null) {
                dbXmlType = DataTypesUtil.loadSQLXML(conn, _selectedURL);
            } else if (this.getOrigValue() != null) {
                dbXmlType = DataTypesUtil.castToSQLXML(this.getOrigValue());
            }
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("UPDATE ").append(tableName).append(" SET ").append(columnName).append("=:value WHERE ROWID=:sqldevrowid");
            if (dataIntegrity && rowScn != null) {
                sqlBuff.append(" AND ORA_ROWSCN=:sqldevrowscn");
            }
            log.add(sqlBuff.toString());
            prep = conn.prepareStatement(sqlBuff.toString());
            prep.setObject(1, dbXmlType);
            prep.setString(2, rowId);
            if (dataIntegrity && rowScn != null) {
                prep.setString(3, rowScn);
            }
            int updates = prep.executeUpdate();
            _selectedURL = null;
            boolean bl = updates == 1;
            return bl;
        }
    }

    @Override
    public boolean saveToDisk(String tableName, String columnName, String rowId, String rowScn, boolean dataIntegrity) throws SQLException, IOException {
        return false;
    }

    @Override
    public void setToDiskStream(OutputStream out) {
    }
}

