/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask.command;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.db.ConnectionStoreBridge;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public abstract class CommandTask
extends RaptorTask<Void> {
    private Connection conn;
    private String connUrl;
    private String connUser;
    private ScriptRunnerContext ctx;
    private String cmd;
    private ParsedCommand parsedCmd;
    private File log;
    private FileOutputStream ous;
    private ConnectionContext origConnectionContext;

    public CommandTask(String name, boolean isInDeterminate) {
        super(name, isInDeterminate, IRaptorTaskRunMode.NO_GUI);
    }

    public Connection getConn() {
        if (this.conn == null && this.origConnectionContext.getCurrentConnectionSpec() != null) {
            try {
                ConnectionContext clonedConnectionContext = this.ctx.getService(ConnectionContext.class);
                clonedConnectionContext.setCurrentConnectorType(this.origConnectionContext.getCurrentConnectorType());
                clonedConnectionContext.setCurrentConnectionSpec(this.origConnectionContext.getCurrentConnectionSpec());
                clonedConnectionContext.setCurrentPropertyValues(this.origConnectionContext.getCurrentPropertyValues());
                clonedConnectionContext.setCurrentCommand(this.origConnectionContext.getCurrentCommand());
                this.conn = this.ctx.cloneCLIConnection();
                this.ctx.setCurrentConnection(this.conn);
                ConnectionDetails cdFinal = new ConnectionDetails(UUID.randomUUID().toString(), this.conn.getMetaData().getURL());
                cdFinal.setConn(this.conn);
                ConnectionStoreBridge connResolver = ConnectionStoreBridge.getBridge(this.ctx);
                connResolver.addConnection(cdFinal);
                this.ctx.putProperty("cli.conn.name", cdFinal.getUrl());
            }
            catch (SQLException e) {
                this.ctx.writeln(e.getMessage());
            }
        }
        return this.conn;
    }

    public void setConn(Connection conn) {
        try {
            if (conn != null) {
                this.connUrl = conn.getMetaData().getURL();
                this.connUser = conn.getMetaData().getUserName();
            }
        }
        catch (SQLException e) {
            this.ctx.writeln(e.getMessage());
        }
    }

    public String getConnUrl() {
        return this.connUrl;
    }

    public String getConnUser() {
        return this.connUser;
    }

    public ScriptRunnerContext getCtx() {
        return this.ctx;
    }

    public void setCtx(ScriptRunnerContext ctx) {
        if (ctx != null) {
            this.ctx = ctx.clone();
            this.ctx.consumerRuning(true);
            this.ctx.getProperties().remove("output_stream_wrapper");
            try {
                String logPath = CommandTask.getLogPath();
                File logFolder = new File(logPath);
                Files.createDirectories(logFolder.toPath(), new FileAttribute[0]);
                boolean created = false;
                int postfix = 0;
                while (!created && postfix < 10000) {
                    String fname = this.getDescriptor().getName().replaceAll("[^a-zA-Z0-9]+", "") + (Serializable)(postfix == 0 ? "" : Integer.valueOf(postfix)) + ".log";
                    this.log = new File(logPath + File.separator + fname);
                    try {
                        Files.createFile(this.log.toPath(), new FileAttribute[0]);
                        created = true;
                    }
                    catch (IOException e) {
                        ++postfix;
                    }
                }
                this.ous = new FileOutputStream(this.log);
                this.ctx.setOutputStreamWrapper(new BufferedOutputStream(this.ous));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.ctx.setSQLPlusBuffer(ctx.getSQLPlusBuffer());
            this.ctx.setSQLPlusConsoleReader(ctx.getSQLPlusConsoleReader());
            this.origConnectionContext = ctx.getService(ConnectionContext.class);
        }
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public ParsedCommand getParsedCmd() {
        return this.parsedCmd;
    }

    public void setParsedCmd(ParsedCommand parsedCmd) {
        this.parsedCmd = parsedCmd;
    }

    public File getLog() {
        return this.log;
    }

    public static String getLogPath() {
        return System.getProperty("user.home") + File.separator + ".sqlcl" + File.separator + "jobslogs";
    }

    @Override
    protected void tearDown() {
        super.tearDown();
        try {
            this.getCtx().getOutputStream().flush();
            this.ous.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

