/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;

public abstract class RaptorTaskAdapter
implements IRaptorTaskListener {
    public void taskCancelled(RaptorTaskEvent event) {
    }

    public void taskFailed(RaptorTaskEvent event) {
    }

    public void taskFinished(RaptorTaskEvent event) {
    }

    public void taskPaused(RaptorTaskEvent event) {
    }

    public void taskWaiting(RaptorTaskEvent event) {
    }

    public void taskRunning(RaptorTaskEvent event) {
    }

    public void taskScheduled(RaptorTaskEvent event) {
    }

    @Override
    public void messageChanged(RaptorTaskEvent event) {
    }

    @Override
    public void progressChanged(RaptorTaskEvent event) {
    }

    @Override
    public void stateChanged(RaptorTaskEvent event) {
        switch (event.getTaskDescriptor().getStatus()) {
            case PAUSED: {
                this.taskPaused(event);
                break;
            }
            case WAITING: {
                this.taskWaiting(event);
                break;
            }
            case RUNNABLE: {
                this.taskRunning(event);
                break;
            }
            case FINISHED: {
                if (event.getTaskDescriptor().isCancelled()) {
                    this.taskCancelled(event);
                    break;
                }
                this.taskFinished(event);
                break;
            }
            case NEW: {
                this.taskScheduled(event);
                break;
            }
            case FAILED: {
                if (event.getTaskDescriptor().isCancelled()) {
                    this.taskCancelled(event);
                    break;
                }
                this.taskFailed(event);
                break;
            }
            default: {
                throw new IllegalStateException(Messages.getString("RaptorTaskDescriptor.0") + event.getTaskDescriptor().getStatus());
            }
        }
    }
}

