/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.dictionary;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.dictionary.Item;
import oracle.dbtools.lsp.dictionary.OracleDictionary;
import oracle.dbtools.lsp.dictionary.SymbolContext;
import oracle.dbtools.lsp.features.Location;
import oracle.dbtools.lsp.features.Position;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public abstract class Registry {
    protected BackgroundParser parser;
    protected Map<Integer, SymbolContext> symbols = new HashMap<Integer, SymbolContext>();

    public Registry(BackgroundParser parser) {
        this.parser = parser;
    }

    public void recordSymbol(ParseNode symbol, String type, int declaration, BackgroundParser parser) {
        if (this.parser == null) {
            this.parser = parser;
        }
        assert (this.parser == parser);
        this.getSymbols().put(symbol.from, new SymbolContext(symbol.from, parser.src.get((int)symbol.from).content, type, declaration));
    }

    public SymbolContext getSymbol(int from) {
        return this.getSymbols().get(from);
    }

    public void cleanSymbols() {
        this.symbols = new HashMap<Integer, SymbolContext>();
    }

    public void recordSymbol(ParseNode symbol, ParseNode type, BackgroundParser parser) {
        if (this.parser == null) {
            this.parser = parser;
        }
        assert (this.parser == parser);
    }

    public void recordSymbol(ParseNode symbol, String[] types, BackgroundParser parser) {
        if (this.parser == null) {
            this.parser = parser;
        }
        assert (this.parser == parser);
    }

    public abstract String fullConnString();

    public abstract String redactedConnString();

    public abstract String abbreviatedConnString();

    public String redactedConnectCommand() {
        return "connect \"" + this.redactedConnString() + "\"";
    }

    public abstract Object getConnection();

    public abstract void dissociateConnection();

    public abstract void associateConnection(String var1);

    public abstract void liquidate();

    public Item getObject(String schema, String type, String name) throws SQLException {
        return null;
    }

    public Item getObject(SymbolContext symbol) throws SQLException {
        return null;
    }

    public Item getObject(String schema, String[] types, String oName) throws SQLException {
        return null;
    }

    public Map<Integer, SymbolContext> getSymbols() {
        return this.symbols;
    }

    public boolean isEqual(String connection1, String connection2) {
        return connection1.equals(connection2);
    }

    public Object locate(SymbolContext symbol) {
        if (symbol.declaration == -1) {
            try {
                Registry catalog = this;
                Item object = catalog.getObject(symbol);
                if (object == null) {
                    return new ResponseError(-32601, Util.sugarcoatText("Object " + symbol.name + " not found"), "");
                }
                return this.locate(object, true);
            }
            catch (SQLWarning e) {
                return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), e);
            }
            catch (SQLException e) {
                LSP.Log.log(Level.SEVERE, e.getMessage(), e);
                return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), e);
            }
        }
        int offset = this.parser.src.get((int)symbol.declaration).begin;
        int line = this.parser.charPos2LineNo1(offset);
        int character = offset - this.parser.lineNo2CharPos1(line);
        Range range = new Range(new Position(line - 1, character), new Position(line - 1, character + this.parser.src.get((int)symbol.declaration).content.length()));
        return new Location(Util.cleanText(this.parser.languageServer.getLastUrl()), range);
    }

    public Object locate(Item object, boolean initParser) {
        try {
            OracleDictionary catalog = (OracleDictionary)this;
            Object content = catalog.queryObjectDefinition(object);
            if (content == null || ((String)content).length() == 0) {
                return null;
            }
            if (!(((String)(content = ((String)content).trim())).endsWith(";") || ((String)content).endsWith(";\n") || ((String)content).endsWith(";\n\r") || ((String)content).endsWith(";\r\n") || ((String)content).endsWith("/") || ((String)content).endsWith("/\n") || ((String)content).endsWith("/\n\r") || ((String)content).endsWith("/\r\n"))) {
                content = (String)content + ";";
            }
            String typeFolder = (object.secondClassCitizen() ? "Other Datatypes/" : "") + object.pluralType();
            Object otherUsers = "";
            if (object.owner != null && !object.owner.equals(catalog.getSchema())) {
                otherUsers = "/Other Users/" + object.owner;
            }
            String url = this.parser.languageServer.dictionaryUri + "/" + catalog.dirName() + (String)otherUsers + "/" + typeFolder + "/" + object.name + ".sql";
            String uri = "\"" + url + "\"";
            this.parser.languageServer.getLSP().createFile(url, ((String)content).toString());
            return new Location(url, LSP.zeroRange);
        }
        catch (Exception e) {
            LSP.Log.log(Level.SEVERE, e.getMessage(), e);
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), object.toString());
        }
    }
}

