/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.dictionary;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.dictionary.Item;
import oracle.dbtools.lsp.dictionary.Registry;
import oracle.dbtools.lsp.dictionary.SymbolContext;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Substitutions;
import oracle.dbtools.util.Service;

public class OracleDictionary
extends Registry {
    private Connection worksheetConn;
    private Connection dictionaryConn;
    private String connStr;
    public static int limit = 300;
    static final String otherUsersQuery = "SELECT USERNAME object_name, null object_type, null owner from ALL_USERS where USERNAME != USER `filter` order by USERNAME";
    static final String allObjectsQuery = "select `columns` from all_objects \nwhere object_type = `objType` and owner=`schema` `filter`\norder by object_name";
    static final String AT = " ";
    static final String SCHEMAATTR = "?user=";
    static final String PWDATTR = "&password=";
    static final String REDACTEDPWD = "&password=***";
    static final String ORACLE_JDBC_PREFIX = "jdbc:oracle:thin:@";
    static final String MYSQL_JDBC_PREFIX = "jdbc:mysql://";
    public static String dictFolder = "Dictionary";
    public static String fileName = "dbobjects.dict";
    public static String dictionaryScheleton = "\nTables: ... \n\nViews: ... \n\nPackages: ...\n\nPackage Bodies: ...\n\nProcedures: ... \n\nFunctions: ... \n\nTriggers: ... \n\nOther Datatypes: ... \n\nOther Users: ... \n\n";
    public static String nonessentialScheleton = "\nIndexes: ... \n\nMaterialized Views: ...\n\nMaterialized View Logs: ... \n\nOperators: ... \n\nTypes: ... \n\nQueues: ... \n\nQueue Tables: ... \n\nSequences: ... \n\nSynonyms: ... \n\nPublic Synonyms: ... \n\nDatabase Links: ... \n\nDirectories: ... \n\nEditions: ... \n\n";

    public String getSchema() {
        int schemaPos;
        if (this.connStr != null && 0 < (schemaPos = this.connStr.lastIndexOf(SCHEMAATTR))) {
            int pwdPos = this.connStr.lastIndexOf(PWDATTR);
            if (0 < pwdPos) {
                return this.connStr.substring(schemaPos + SCHEMAATTR.length(), pwdPos).toUpperCase();
            }
            return this.connStr.substring(schemaPos + SCHEMAATTR.length()).toUpperCase();
        }
        return "N/A";
    }

    public OracleDictionary(BackgroundParser parser) {
        super(parser);
    }

    @Override
    public void associateConnection(String connStr) {
        this.cleanSymbols();
        this.worksheetConn = null;
        this.dictionaryConn = null;
        this.connStr = null;
        Object conn = this.parser.getLanguageServer().getConnection(connStr);
        if (conn instanceof Connection) {
            try {
                this.worksheetConn = DriverManager.getConnection(connStr);
                this.dictionaryConn = DriverManager.getConnection(connStr);
                this.connStr = connStr;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object getConnection() {
        return this.worksheetConn;
    }

    @Override
    public void dissociateConnection() {
        this.worksheetConn = null;
        this.dictionaryConn = null;
        this.connStr = null;
        this.cleanSymbols();
    }

    @Override
    public String fullConnString() {
        return this.connStr;
    }

    @Override
    public void recordSymbol(ParseNode symbol, String type, int declaration, BackgroundParser parser) {
        if (this.parser == null) {
            this.parser = parser;
        }
        assert (this.parser == parser);
        this.getSymbols().put(symbol.from, new SymbolContext(symbol.from, Service.handleMixedCase((String)parser.src.get((int)symbol.from).content), type, declaration));
    }

    @Override
    public void recordSymbol(ParseNode symbol, ParseNode type, BackgroundParser parser) {
        ParseNode grandParent;
        String schema = this.getSchema();
        List<LexerToken> src = parser.src;
        if (type.parent() != null && type.parent().parent() != null && !(grandParent = type.parent().parent()).contains("other_datatypes_node")) {
            schema = src.get((int)grandParent.from).content;
        }
        String nodeName = type.content(0);
        String typeName = nodeName.toUpperCase();
        typeName = typeName.substring(0, typeName.length() - "_NODE".length());
        typeName = typeName.replace('_', ' ');
        this.getSymbols().put(symbol.from, new SymbolContext(symbol.from, Service.handleMixedCase((String)src.get((int)symbol.from).content), new String[]{typeName}, schema));
    }

    @Override
    public void recordSymbol(ParseNode symbol, String[] types, BackgroundParser parser) {
        String schema = this.getSchema();
        List<LexerToken> src = parser.src;
        SortedSet children = symbol.children();
        if (children.size() == 3) {
            schema = src.get((int)symbol.from).content;
        }
        this.getSymbols().put(symbol.to - 1, new SymbolContext(symbol.to - 1, Service.handleMixedCase((String)src.get((int)(symbol.to - 1)).content), types, schema));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryObjectDefinition(Item obj) throws SQLException, IOException {
        if (this.dictionaryConn == null || !(this.dictionaryConn instanceof Connection)) {
            return null;
        }
        if ("PACKAGE".equals(obj.type) || "PACKAGE BODY".equals(obj.type) || "FUNCTION".equals(obj.type) || "PROCEDURE".equals(obj.type)) {
            Object line;
            String definitionChunk = "select text from all_source where type=? and name=? and owner=?";
            StringBuilder definitionQuery = new StringBuilder("select text from all_source where type=? and name=? and owner=?");
            PreparedStatement stmt = null;
            ResultSet rs = null;
            stmt = this.dictionaryConn.prepareStatement(definitionQuery.toString());
            stmt.setString(1, obj.type);
            stmt.setString(2, obj.name);
            stmt.setString(3, obj.owner == null ? this.getSchema() : obj.owner);
            rs = stmt.executeQuery();
            StringBuilder content = new StringBuilder();
            while (rs.next()) {
                line = rs.getString(1);
                content.append((String)line);
            }
            if (content.length() == 0) {
                line = null;
                return line;
            }
            line = "create or replace " + content.toString();
            return line;
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        String definitionChunk = "select DBMS_METADATA.GET_DDL(?,?,?) FROM dual\n";
        StringBuilder definitionQuery = new StringBuilder("select DBMS_METADATA.GET_DDL(?,?,?) FROM dual\n");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String string;
            stmt = this.dictionaryConn.prepareStatement(definitionQuery.toString());
            stmt.setString(1, obj.type);
            stmt.setString(2, obj.name);
            stmt.setString(3, obj.owner == null ? this.getSchema() : obj.owner);
            rs = stmt.executeQuery();
            StringBuilder content = new StringBuilder();
            if (rs.next()) {
                int i;
                Clob clob = rs.getClob(1);
                Reader r = clob.getCharacterStream();
                while ((i = r.read()) != -1) {
                    content.append((char)i);
                }
            }
            if (content.length() == 0) {
                string = null;
                return string;
            }
            string = content.toString();
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public Item getObject(String schema, String type, String name) throws SQLException {
        return this.getObject(schema, new String[]{type}, name);
    }

    @Override
    public Item getObject(SymbolContext symbol) throws SQLException {
        Item ret = this.getObject(symbol.owner, symbol.types, symbol.name);
        if (ret != null) {
            symbol.types = new String[]{ret.type};
            symbol.owner = ret.owner;
        }
        return ret;
    }

    @Override
    public Item getObject(String schema, String[] types, String oName) throws SQLException {
        if (this.dictionaryConn == null) {
            throw new SQLWarning("Not connected");
        }
        String owner = Service.handleMixedCase((String)schema);
        String name = Service.handleMixedCase((String)oName);
        Object typePredicate = "";
        if (types.length == 1 && types[0] != null) {
            typePredicate = "and object_type ='" + types[0] + "'";
        }
        if (1 < types.length) {
            StringBuilder list = new StringBuilder("'" + types[0] + "'");
            for (int i = 1; i < types.length; ++i) {
                list.append(",'");
                list.append(types[i]);
                list.append("'");
            }
            typePredicate = "and object_type in (" + list.toString() + ")";
        }
        String query = "select owner,object_type, object_name from all_objects \nwhere object_name = '" + name + "' and owner in ('" + owner + "','SYS', 'SYSTEM')\n" + (String)typePredicate;
        LinkedList<Item> ret = this.query(query);
        Collections.sort(ret);
        if (0 < ret.size()) {
            return ret.getFirst();
        }
        return null;
    }

    public LinkedList<Item> query(String query) throws SQLException {
        if (this.dictionaryConn == null || !(this.dictionaryConn instanceof Connection)) {
            return new LinkedList<Item>();
        }
        return OracleDictionary.query(query, this.dictionaryConn, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<Item> query(String query, Connection conn, boolean limited) throws SQLException {
        LinkedList<Item> ret = new LinkedList<Item>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String dbaVersion = query.replace("all_", "Dba_");
            dbaVersion = dbaVersion.replace("ALL_", "Dba_");
            stmt = conn.prepareStatement(dbaVersion);
            rs = stmt.executeQuery();
            int cnt = 0;
            while (rs.next()) {
                if (limited && cnt++ == limit) {
                    ret.add(Item.MORE);
                    break;
                }
                ret.add(new Item(rs.getString("OBJECT_NAME"), rs.getString("OBJECT_TYPE"), rs.getString("OWNER")));
            }
            LinkedList<Item> linkedList = ret;
            return linkedList;
        }
        catch (SQLException e) {
            try {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException cnt) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException cnt) {
                        // empty catch block
                    }
                }
                stmt = conn.prepareStatement(query);
                rs = stmt.executeQuery();
                int cnt = 0;
                while (rs.next()) {
                    if (limited && cnt++ == limit) {
                        ret.add(Item.MORE);
                        break;
                    }
                    ret.add(new Item(rs.getString("OBJECT_NAME"), rs.getString("OBJECT_TYPE"), rs.getString("OWNER")));
                }
                LinkedList<Item> linkedList = ret;
                return linkedList;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                        rs = null;
                    }
                    catch (SQLException sQLException) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                        stmt = null;
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static List<Item> queryItems(ParseNode node, List<LexerToken> src, String schema, String objType, Object conn) throws SQLException {
        String query;
        if (objType.equals("OTHER_USERS")) {
            query = otherUsersQuery;
        } else {
            query = allObjectsQuery;
            query = query.replace("`objType`", "'" + objType + "'");
            query = query.replace("`schema`", schema);
            query = query.replace("`columns`", "object_name, object_type, null owner");
        }
        String filter = OracleDictionary.limitedCondition(node, src);
        query = query.replace("`filter`", filter);
        LinkedList<Item> items = OracleDictionary.query(query, (Connection)conn, "".equals(filter));
        return items;
    }

    private static String limitedCondition(ParseNode node, List<LexerToken> src) {
        Object filter = " and rownum <= " + (limit + 1) + "\n";
        for (ParseNode child : node.children()) {
            if (!child.contains("filter")) continue;
            for (ParseNode grandchild : child.children()) {
                if (!grandchild.contains("condition")) continue;
                String filterContent = grandchild.content(src);
                if (filterContent.toLowerCase().contains("rownum")) {
                    filter = "";
                }
                Substitutions subs = new Substitutions(filterContent);
                for (ParseNode descendant : grandchild.descendants()) {
                    if (!descendant.contains("'NAME'")) continue;
                    int from = src.get((int)descendant.from).begin - src.get((int)grandchild.from).begin;
                    subs.replace(from, from + "NAME".length(), "oBject_nAme");
                }
                filterContent = subs.transformInput();
                filter = " and " + filterContent + (String)filter;
            }
        }
        return filter;
    }

    public static String indent(String input, int level) {
        String pad = Service.padln((String)"", (int)(4 * level));
        return input.replace("\n", "\n" + pad).replace("\r\n", "\r\n" + pad);
    }

    public static String conn2dirName(String input) {
        input = OracleDictionary.redactedConnectString(input);
        input = input.replace(ORACLE_JDBC_PREFIX, "");
        input = input.replace(REDACTEDPWD, "");
        input = input.replace(MYSQL_JDBC_PREFIX, "~");
        input = input.replace(":", "_");
        input = input.replace("/", "_");
        input = input.replace(SCHEMAATTR, "--");
        return input;
    }

    public static String dirName2conn(String input) {
        int i = ((String)(input = ((String)input).charAt(0) == '~' ? MYSQL_JDBC_PREFIX + ((String)input).substring(1) : ORACLE_JDBC_PREFIX + (String)input)).indexOf(95);
        if (i < 0) {
            return null;
        }
        input = ((String)input).substring(0, i) + ":" + ((String)input).substring(i + 1);
        i = ((String)(input = ((String)input).replace("_", "/"))).indexOf("--");
        if (0 < i) {
            input = ((String)input).substring(0, i);
        }
        return "\"" + (String)input + "\"";
    }

    public static String dirName(String connStr) {
        return dictFolder + "/" + OracleDictionary.conn2dirName(connStr);
    }

    public String dirName() {
        return OracleDictionary.dirName(this.connStr);
    }

    public static List<String> allDatatypes() {
        LinkedList<String> ret = new LinkedList<String>();
        List src = LexerToken.parse((String)(dictionaryScheleton + nonessentialScheleton));
        String prior = "";
        for (LexerToken current : src) {
            if (":".equals(current)) {
                ret.add(prior.substring(0, prior.length() - 1).toUpperCase());
            }
            prior = current.content;
        }
        return ret;
    }

    public static String parseConnectCommand(String connect) {
        List fullCommand;
        if (0 == connect.indexOf(34)) {
            connect = connect.substring(1, connect.length() - 1);
        }
        if ((fullCommand = LexerToken.parse((String)connect)).size() == 6) {
            String user = ((LexerToken)fullCommand.get((int)1)).content;
            String pwd = ((LexerToken)fullCommand.get((int)3)).content;
            String conn = ((LexerToken)fullCommand.get((int)5)).content.trim();
            if (0 == conn.indexOf(34)) {
                conn = conn.substring(1, conn.length() - 1);
            }
            return conn + SCHEMAATTR + user + PWDATTR + pwd;
        }
        if (fullCommand.size() == 4) {
            String user = ((LexerToken)fullCommand.get((int)1)).content;
            String conn = ((LexerToken)fullCommand.get((int)3)).content.trim();
            if (0 == conn.indexOf(34)) {
                conn = conn.substring(1, conn.length() - 1);
            }
            return conn + SCHEMAATTR + user + REDACTEDPWD;
        }
        if (fullCommand.size() == 8) {
            String user = ((LexerToken)fullCommand.get((int)1)).content;
            String conn = ((LexerToken)fullCommand.get((int)7)).content.trim();
            if (0 == conn.indexOf(34)) {
                conn = conn.substring(1, conn.length() - 1);
            }
            return conn + SCHEMAATTR + user + REDACTEDPWD;
        }
        if (fullCommand.size() == 2) {
            String ret = ((LexerToken)fullCommand.get((int)1)).content;
            if (0 == ret.indexOf(34)) {
                ret = ret.substring(1, ret.length() - 1);
            }
            return ret;
        }
        throw new AssertionError((Object)("Unexpected JDBC connect command lenghth = " + fullCommand.size()));
    }

    public static String redactedConnectString(String fullConnStr) {
        int pos;
        if (fullConnStr == null) {
            return null;
        }
        if (0 == fullConnStr.indexOf(34)) {
            fullConnStr = fullConnStr.substring(1, fullConnStr.length() - 1);
        }
        if (0 < (pos = fullConnStr.lastIndexOf(PWDATTR))) {
            return fullConnStr.substring(0, pos + PWDATTR.length()) + "***";
        }
        return fullConnStr;
    }

    @Override
    public String redactedConnString() {
        return OracleDictionary.redactedConnectString(this.fullConnString());
    }

    @Override
    public String abbreviatedConnString() {
        return OracleDictionary.conn2dirName(this.fullConnString());
    }

    @Override
    public void liquidate() {
    }

    public void initCache(Connection connection, String conStr) throws IOException, SQLException {
        String content = "/* Oracle database dictionary navigation file. \n   Either associate connection from the available connection pool, \n   or establish new connection with the command below: */\nconnect \"" + OracleDictionary.redactedConnectString(conStr) + "\"\n\n" + dictionaryScheleton;
        LanguageServer languageServer = this.parser.languageServer;
        String folder = languageServer.dictionaryUri + "/" + OracleDictionary.dirName(conStr);
        languageServer.getLSP().createDirectory(folder + "/TABLES");
        languageServer.getLSP().createDirectory(folder + "/VIEWS");
        languageServer.getLSP().createDirectory(folder + "/PACKAGES");
        languageServer.getLSP().createDirectory(folder + "/PACKAGE-BODIES");
        languageServer.getLSP().createDirectory(folder + "/PROCEDURES");
        languageServer.getLSP().createDirectory(folder + "/FUNCTIONS");
        languageServer.getLSP().createDirectory(folder + "/TRIGGERS");
        String uri = folder + "/" + fileName;
        String url = "\"" + uri + "\"";
        languageServer.getLSP().createFile(uri, content, false);
    }
}

