/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.TableRenderer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.features.Position;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public class Query
extends CodeLens {
    static final String normalTitle = "Query:";
    static final String cancelTitle = "Cancel running query:";
    List<LexerToken> full;
    String sql;
    Statement stmt = null;
    private Object conn = null;

    public Query(ParseNode node, BackgroundParser parser) {
        super(node, normalTitle, parser);
    }

    @Override
    public Object executeCommand() {
        return this.executeCommand(Mode.Standalone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCommand(Mode mode) {
        int jsPos;
        if (this.stmt != null) {
            try {
                this.stmt.cancel();
                this.command.title = normalTitle;
                this.parser.documentBump();
                String string = "OK";
                return string;
            }
            catch (SQLException e) {
                if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                    LSP.Log.log(Level.SEVERE, e.getMessage(), e);
                }
                ResponseError responseError = new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), this.stmt);
                return responseError;
            }
            finally {
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                        this.stmt = null;
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        this.parser.waitForLexingFinish();
        this.full = new ArrayList<LexerToken>();
        this.full.addAll(this.parser.src);
        String s = this.parser.text.substring(this.full.get((int)this.node.from).begin, this.full.get((int)(this.node.to - 1)).end);
        s = s.trim();
        if (s.endsWith(";")) {
            s = s.substring(0, s.length() - 1);
        }
        if (0 < (jsPos = s.indexOf("->"))) {
            s = s.substring(0, jsPos);
        }
        this.sql = s;
        this.conn = this.parser.getRegistry().getConnection();
        if (this.conn == null || !(this.conn instanceof Connection)) {
            return new ResponseError(-32603, "Not connected", this.parser.languageServer.getLastUrl());
        }
        try {
            this.stmt = ((Connection)this.conn).createStatement();
            if (mode == Mode.Standalone) {
                this.command.title = cancelTitle;
                this.parser.documentBump();
                this.parser.resetDiagnostics();
                new Thread(){

                    @Override
                    public void run() {
                        Query.this.query(Mode.Script0, Query.this.sql);
                    }
                }.start();
            } else {
                this.query(mode, this.sql);
            }
            return "OK";
        }
        catch (Exception e) {
            if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                LSP.Log.log(Level.SEVERE, e.getMessage(), e);
            }
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void query(Mode mode, String sql) {
        LanguageServer server = this.parser.languageServer;
        ResultSet rs = null;
        try {
            Object fileExt;
            rs = this.stmt.executeQuery(sql);
            boolean oldSilent = this.parser.getRenderer().isSilent;
            TableRenderer oldRenderer = this.parser.getRenderer();
            List src = LexerToken.parse((String)sql, (boolean)true);
            if (1 < src.size()) {
                int i = 1;
                LexerToken one = (LexerToken)src.get(i++);
                while (one.type == Token.WS) {
                    one = (LexerToken)src.get(i++);
                }
                if (one.type == Token.COMMENT || one.type == Token.LINE_COMMENT) {
                    try {
                        Object renderMode = one.content.substring(2).toLowerCase();
                        if (one.type == Token.COMMENT) {
                            renderMode = ((String)renderMode).substring(0, ((String)renderMode).length() - 2);
                        }
                        if ("silent".equalsIgnoreCase((String)(renderMode = ((String)renderMode).trim()))) {
                            this.parser.getRenderer().isSilent = true;
                        } else if ("vocal".equalsIgnoreCase((String)renderMode)) {
                            this.parser.getRenderer().isSilent = false;
                        } else {
                            this.parser.setRenderer(TableRenderer.factory((String)renderMode, this.parser));
                        }
                    }
                    catch (Throwable renderMode) {
                        // empty catch block
                    }
                }
                for (ParseNode desc : this.node.descendants()) {
                    if (!desc.contains("javascript")) continue;
                    String jsCallback = this.parser.text.substring(this.full.get((int)desc.from).begin, this.full.get((int)(desc.to - 1)).end);
                    this.parser.getRenderer().jsCallback = jsCallback.replace("\\\\n", "\\n");
                    this.parser.getRenderer().jsNode = desc;
                    break;
                }
            }
            if (((String)(fileExt = this.parser.getRenderer().getClass().getSimpleName().substring(0, 4))).endsWith("R")) {
                fileExt = ((String)fileExt).substring(0, 3);
            }
            if (((String)fileExt).equalsIgnoreCase("INSE")) {
                fileExt = "sql";
            }
            String content = this.parser.getRenderer().render(rs, (Connection)this.conn);
            fileExt = ".output." + ((String)fileExt).toLowerCase();
            String lastUrl = this.parser.docUrl;
            String uri = lastUrl.substring(1, lastUrl.length() - 1) + (String)fileExt;
            String url = "\"" + uri + "\"";
            if (mode == Mode.Script0) {
                server.getLSP().createFile(uri, content);
            } else {
                Position pos = new Position(999999, 0);
                server.getLSP().documentInsert(new Range(pos, pos), uri, "\n" + content);
            }
            this.parser.getRenderer().isSilent = oldSilent;
            this.parser.setRenderer(oldRenderer);
            this.parser.getRenderer().jsCallback = null;
            server.logStatement(sql);
            LSP.windowShowMessage("Query finished", 3);
        }
        catch (Exception e) {
            if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                LSP.Log.log(Level.SEVERE, e.getMessage(), e);
            }
            if (e instanceof SQLException) {
                this.parser.failedCommand(this.node, e);
            }
        }
        finally {
            if (mode == Mode.Standalone) {
                server.documentsBump();
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                    this.stmt = null;
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    static enum Mode {
        Standalone,
        Script0,
        Script1;

    }
}

