/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.dictionary.OracleDictionary;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public class EstablishConnection
extends CodeLens {
    String connStr;

    public EstablishConnection(ParseNode node, BackgroundParser parser, String connStr) {
        super(node, "Establish Connection", parser);
        this.connStr = connStr;
    }

    @Override
    public Object executeCommand() {
        if (this.connStr.startsWith("\"")) {
            this.connStr = this.connStr.substring(1, this.connStr.length() - 1);
        }
        LanguageServer server = this.parser.languageServer;
        try {
            Connection connection = DriverManager.getConnection(this.connStr);
            server.addConnection(this.connStr, connection);
            ((OracleDictionary)this.parser.getRegistry()).initCache(connection, this.connStr);
            this.parser.resetDiagnostics();
            server.documentsBump();
            LSP.windowShowMessage("Connected to " + OracleDictionary.conn2dirName(this.connStr), 3);
            this.parser.getRegistry().associateConnection(this.connStr);
            return "OK";
        }
        catch (SQLException e) {
            this.parser.resetDiagnostics();
            server.addConnection(this.connStr, e);
            LSP.windowShowMessage("Failed to connect to " + OracleDictionary.conn2dirName(this.connStr), 1);
            LSP.windowShowMessage(e.getMessage(), 1);
            this.parser.failedCommand(this.node, e);
            this.parser.documentBump();
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), this.connStr);
        }
        catch (Exception e) {
            LSP.Log.log(Level.SEVERE, e.getMessage(), e);
            server.addConnection(this.connStr, e);
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), this.connStr);
        }
    }
}

