/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.io.IOException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import oracle.dbtools.app.Completer;
import oracle.dbtools.app.CompletionList;
import oracle.dbtools.app.Format;
import oracle.dbtools.app.SqlCompleter;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.PublishDiagnosticsParams;
import oracle.dbtools.lsp.RemoteProcedure;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.dictionary.ArboriCatalog;
import oracle.dbtools.lsp.dictionary.Item;
import oracle.dbtools.lsp.dictionary.OracleDictionary;
import oracle.dbtools.lsp.dictionary.Registry;
import oracle.dbtools.lsp.dictionary.SymbolContext;
import oracle.dbtools.lsp.features.CodeAction;
import oracle.dbtools.lsp.features.Color;
import oracle.dbtools.lsp.features.ColorInformation;
import oracle.dbtools.lsp.features.ColorPresentation;
import oracle.dbtools.lsp.features.Command;
import oracle.dbtools.lsp.features.Diagnostics;
import oracle.dbtools.lsp.features.DocumentSymbol;
import oracle.dbtools.lsp.features.FoldingRange;
import oracle.dbtools.lsp.features.Location;
import oracle.dbtools.lsp.features.Position;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.lsp.features.SemanticTokens;
import oracle.dbtools.lsp.features.SymbolInformation;
import oracle.dbtools.lsp.features.WorkspaceEdit;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.Jsonable;
import oracle.dbtools.parser.json.NamedValue;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.scripting.Script;
import oracle.dbtools.scripting.ScriptingUtils;
import oracle.dbtools.util.Service;

public class LanguageServer {
    private LSP lsp;
    public HashMap<String, BackgroundParser> parsers = new HashMap();
    HashMap<String, Object> establishedConnections = new HashMap();
    protected String lastUrl = null;
    public String clientName;
    private static boolean skipInitWorkspace = true;
    public String rootUri;
    public String dictionaryUri = null;
    public boolean isPrefixWildcard = true;
    public static final String definitionQuery = "select DBMS_METADATA.GET_DDL(?,?,?) FROM dual\n";
    private static final String ASSOCIATE_CONNECTION = "ASSOCIATE_CONNECTION";
    private static final String DISSOCIATE_CONNECTION = "DISSOCIATE_CONNECTION";
    public Format format = new Format();
    private static HashMap<String, RemoteProcedure> callbackRegistry = new HashMap();
    private String historyUrl = null;
    private final int defaultHistoryLength = 200;
    private int lastHistoryLength = 200;
    private int historyLength = -1;

    public LSP getLSP() {
        return this.lsp;
    }

    public Object getConnection(String connStr) {
        Object ret = this.establishedConnections.get(connStr);
        return ret;
    }

    public String getLastUrl() {
        return this.lastUrl;
    }

    public String associatedFullConnStr(String url) {
        BackgroundParser parser = this.parsers.get(url);
        if (parser == null) {
            return null;
        }
        Registry registry = parser.getRegistry();
        return registry.fullConnString();
    }

    public Registry getAssociatedRegistry(String url) {
        BackgroundParser parser = this.parsers.get(url);
        if (parser == null) {
            return null;
        }
        return parser.getRegistry();
    }

    public void addConnection(String connectionString, Object conn) {
        this.establishedConnections.put(connectionString, conn);
    }

    public void openConnection(String connectionString) {
        try {
            Connection connection = DriverManager.getConnection(connectionString);
            this.addConnection(connectionString, connection);
        }
        catch (SQLException e) {
            this.addConnection(connectionString, e);
        }
    }

    public void closeConnection(String connectionString) {
        this.liquidateConnection(connectionString);
        this.establishedConnections.remove(connectionString);
    }

    public void liquidateConnection(String connstr) {
        for (BackgroundParser parser : this.parsers.values()) {
            Registry registry = parser.getRegistry();
            Object ret = registry.getConnection();
            String candidate = registry.redactedConnString();
            if (candidate == null || !OracleDictionary.redactedConnectString(connstr).equals(candidate)) continue;
            registry.liquidate();
        }
    }

    public BackgroundParser getParser(String url) throws IOException {
        BackgroundParser ret;
        if (((String)url).charAt(0) != '\"') {
            url = "\"" + (String)url + "\"";
        }
        if ((ret = this.parsers.get(url)) == null) {
            return this.parsers.get(((String)url).replace("\\", "/"));
        }
        return ret;
    }

    public LanguageServer(LSP lsp) {
        this.lsp = lsp;
    }

    private String extractDictUri(NamedValue workspaceFolders) {
        String ret = null;
        if (workspaceFolders != null) {
            for (NamedValue el : workspaceFolders.composite) {
                NamedValue name = el.child("\"name\"");
                if (name == null || !name.atomic.equalsIgnoreCase("\"" + OracleDictionary.dictFolder + "\"")) continue;
                NamedValue uri = el.child("\"uri\"");
                String uriStr = URLDecoder.decode(uri.atomic);
                ret = uriStr.substring(1, uriStr.length() - 1);
                String suffix = ret.substring(ret.length() - OracleDictionary.dictFolder.length());
                if (!suffix.equalsIgnoreCase(OracleDictionary.dictFolder)) break;
                ret = ret.substring(0, ret.length() - OracleDictionary.dictFolder.length() - 1);
                break;
            }
        }
        return ret;
    }

    public String initialize(NamedValue param) {
        NamedValue rootUri = param.child("\"rootUri\"");
        if ("null".equals(rootUri.atomic)) {
            rootUri.atomic = "\"inmemory:/\"";
        }
        this.rootUri = rootUri.atomic.substring(1, rootUri.atomic.length() - 1);
        try {
            this.dictionaryUri = this.extractDictUri(param.child("\"workspaceFolders\""));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.dictionaryUri == null) {
            this.dictionaryUri = this.rootUri;
        }
        NamedValue clientInfo = param.child("\"clientInfo\"");
        NamedValue name = clientInfo.child("\"name\"");
        this.clientName = name.atomic.substring(1, name.atomic.length() - 1);
        StringBuilder tokenTypes = new StringBuilder();
        for (int i = 0; i < SemanticTokens.semanticTokenTypes.length; ++i) {
            if (0 < i) {
                tokenTypes.append(',');
            }
            tokenTypes.append('\"');
            tokenTypes.append(SemanticTokens.semanticTokenTypes[i]);
            tokenTypes.append('\"');
        }
        StringBuilder tokenModifiers = new StringBuilder();
        for (int i = 0; i < SemanticTokens.semanticTokenModifiers.length; ++i) {
            if (0 < i) {
                tokenModifiers.append(',');
            }
            tokenModifiers.append('\"');
            tokenModifiers.append(SemanticTokens.semanticTokenModifiers[i]);
            tokenModifiers.append('\"');
        }
        return "{\"capabilities\": { \"completionProvider\": {\"triggerCharacters\":[\".\"],\"hoverProvider\":true} , \"codeLensProvider\": {\"resolveProvider\":true}  ,\"dynamicRegistration\": true  ,\"hoverProvider\" : true  ,\"definitionProvider\" : true  ,\"documentFormattingProvider\": true  ,\"foldingRangeProvider\": true  ,\"hasDiagnosticRelatedInformationCapability\": true , \"hasConfigurationCapability\": true  ,\"colorProvider\": true  ,\"documentSymbolProvider\": true  , \"renameProvider\": true  , \"codeActionProvider\": true  ,  \"textDocumentSync\": {\"openClose\":true, \"change\": 1 }   ,  \"executeCommandProvider\": {\"commands\":[\"workspace/executeCommand\",\"run-command\"]}   ,\"semanticTokensProvider\": {\"full\": true,\"legend\": {\"tokenTypes\":[ " + tokenTypes.toString() + " ],\"tokenModifiers\":[" + tokenModifiers.toString().toString() + "]} } ,\"workspace\": {\"workspaceFolders\": {\"changeNotifications\": true}} } }";
    }

    private void initWorkspace() {
        if (skipInitWorkspace) {
            return;
        }
        this.copyIntoWorkspace("menu/init.js");
        this.runInitJS();
        this.copyIntoWorkspace("menu/autotrace.sql");
        this.copyIntoWorkspace("menu/connections.sql");
    }

    private void copyIntoWorkspace(String filename) {
        try {
            String content = Service.readFile(this.getClass(), (String)("workspace/" + filename));
            this.getLSP().createFile(this.rootUri + "/" + filename, content, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void runInitJS() {
        try {
            String content = null;
            Object filename = "menu/init.js";
            Properties pr = System.getProperties();
            String m = (String)pr.get("dbtools.lsp.init");
            filename = m != null ? (m.endsWith("/") || m.endsWith("\\") ? m + (String)filename : m) : this.rootUri + "/" + (String)filename;
            try {
                content = Service.readFile((String)filename);
            }
            catch (IOException e2) {
                this.getLSP();
                LSP.Log.severe((String)filename + " not found");
            }
            if (content == null) {
                return;
            }
            Script s = new Script();
            s.setExtension("js");
            s.setScript(content);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("lsp", this.getLSP());
            map.put("server", this);
            ScriptingUtils.runScript(s, map);
        }
        catch (AssertionError e) {
            this.getLSP();
            LSP.Log.log(Level.SEVERE, ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLSP();
            LSP.Log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void initialized() {
        new Thread(){

            @Override
            public void run() {
                LanguageServer.this.initWorkspace();
            }
        }.start();
    }

    public void shutdown() {
        throw new RuntimeException("VT: shutdown");
    }

    public void didChangeConfiguration(NamedValue param) {
        throw new AssertionError((Object)"Not implemented");
    }

    public PublishDiagnosticsParams didOpenTextDocument(NamedValue param) {
        NamedValue doc = param.child("\"textDocument\"");
        NamedValue uri = doc.child("\"uri\"");
        this.lastUrl = URLDecoder.decode(uri.atomic);
        NamedValue text = doc.child("\"text\"");
        String input = Util.cleanText(text.atomic);
        BackgroundParser parser = this.parsers.get(this.lastUrl);
        if (parser == null) {
            try {
                parser = BackgroundParser.factory(input, this.lastUrl, this);
                this.parsers.put(this.lastUrl, parser);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        PublishDiagnosticsParams ret = this.checkErrors(this.lastUrl);
        return ret;
    }

    public PublishDiagnosticsParams didChangeTextDocument(NamedValue param) {
        NamedValue doc = param.child("\"textDocument\"");
        NamedValue contentChanges = param.child("\"contentChanges\"");
        NamedValue text = contentChanges.firstChild().child("\"text\"");
        NamedValue uri = doc.child("\"uri\"");
        this.lastUrl = URLDecoder.decode(uri.atomic);
        String input = Util.cleanText(text.atomic);
        BackgroundParser parser = this.parsers.get(this.lastUrl);
        parser.updateText(input);
        return this.checkErrors(this.lastUrl);
    }

    private PublishDiagnosticsParams checkErrors(String url) {
        BackgroundParser parser = this.parsers.get(url);
        boolean done = parser.waitForParsingFinish();
        if (!done) {
            return null;
        }
        return parser.publishDiagnostics();
    }

    public void willSaveTextDocument(NamedValue param) {
        throw new AssertionError((Object)"Not implemented");
    }

    public String willSaveWaitUntilTextDocument(NamedValue param) {
        throw new AssertionError((Object)"Not implemented");
    }

    public void didSaveTextDocument(NamedValue param) {
    }

    public void didCloseTextDocument(NamedValue param) {
        NamedValue doc = param.child("\"textDocument\"");
        NamedValue uri = doc.child("\"uri\"");
        String uriStr = URLDecoder.decode(uri.atomic);
        BackgroundParser parser = this.parsers.get(uriStr);
        if (parser != null) {
            parser.quit = true;
            this.parsers.remove(uriStr);
        }
    }

    public void didChangeWatchedFiles(NamedValue param) {
        throw new AssertionError((Object)"Not implemented");
    }

    public CompletionList completion(NamedValue param) throws SQLException {
        SqlCompleter.maxUsers = 999;
        SqlCompleter.maxObjects = 999;
        NamedValue doc = param.child("\"textDocument\"");
        NamedValue uri = doc.child("\"uri\"");
        this.lastUrl = URLDecoder.decode(uri.atomic);
        BackgroundParser parser = this.parsers.get(this.lastUrl);
        Completer completer = parser.getCompleter();
        if (completer == null) {
            return new CompletionList();
        }
        completer.prefixWildcard = this.isPrefixWildcard ? "%" : "";
        String input = parser.text;
        NamedValue position = param.child("\"position\"");
        int line = Integer.parseInt(position.child((String)"\"line\"").atomic);
        int character = Integer.parseInt(position.child((String)"\"character\"").atomic);
        parser.lastCharPos = parser.lineNo2CharPos1(line + 1) + character;
        System.out.println("completion lastPos=" + parser.lastCharPos);
        return completer.complete(input, parser.lastCharPos);
    }

    public String resolveCompletionItem(NamedValue param) {
        throw new AssertionError((Object)"Not implemented");
    }

    public String hover(int id, NamedValue param) {
        NamedValue doc = param.child("\"textDocument\"");
        NamedValue uri = doc.child("\"uri\"");
        this.lastUrl = URLDecoder.decode(uri.atomic);
        BackgroundParser parser = this.parsers.get(this.lastUrl);
        if (parser.isParsing()) {
            return null;
        }
        NamedValue position = param.child("\"position\"");
        int line = Integer.parseInt(position.child((String)"\"line\"").atomic);
        int character = Integer.parseInt(position.child((String)"\"character\"").atomic);
        Registry catalog = parser.getRegistry();
        if (catalog == null) {
            return null;
        }
        int charPos = parser.lineNo2CharPos1(line + 1) + character;
        int from = LexerToken.char2lex(parser.src, (int)charPos);
        SymbolContext symbol = catalog.getSymbol(from);
        if (symbol == null && (symbol = catalog.getSymbol(from = LexerToken.char2lex(parser.src, (int)(charPos = parser.lineNo2CharPos1(line + 1) + character)))) == null) {
            return null;
        }
        String type = symbol.types[0].toUpperCase();
        StringBuilder ret = new StringBuilder("{\"contents\":");
        ret.append("{ ");
        ret.append(" \"kind\": \"markdown\",");
        ret.append(" \"value\": \"");
        String postfix = "\"} }";
        if (("TABLE".equals(type) || "VIEW".equals(type)) && catalog.getConnection() != null && catalog.getConnection() instanceof Connection) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.getLSP().hasCancelMethod(id) || this.getLSP().hasPendingMethod("textDocument/hover", id)) {
                return "cancelResponce";
            }
            if (catalog instanceof OracleDictionary) {
                try {
                    String query = "select 'N/A' owner, column_name object_name, data_type object_type \n from all_tab_cols \n where table_name = '" + symbol.name + "' and owner in ('" + symbol.owner + "','SYS', 'SYSTEM')";
                    LinkedList<Item> cols = ((OracleDictionary)catalog).query(query);
                    if (0 < cols.size()) {
                        ret.append("#### " + Util.sugarcoatText(symbol.name) + " \\n");
                        ret.append("| Column:       |  Type:         |\\n");
                        ret.append("| :------------ | :------------  |\\n");
                        for (Item col : cols) {
                            ret.append("| " + Util.sugarcoatText(col.name) + " | " + col.type + " |\\n");
                        }
                    } else {
                        ret.append("~~" + symbol.name + "~~\\n\\n");
                        ret.append("*Table doesn't exist*");
                    }
                    ret.append(postfix);
                    return ret.toString();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        ret.append("`");
        ret.append(symbol.name);
        ret.append("    ");
        ret.append(type);
        ret.append(1 < symbol.types.length ? "?" : "");
        ret.append("`\\n\\n");
        if ((catalog.getConnection() == null || !(catalog.getConnection() instanceof Connection)) && OracleDictionary.allDatatypes().contains(type)) {
            ret.append("(Not connected)");
        }
        ret.append(postfix);
        return ret.toString();
    }

    public String signatureHelp(NamedValue param) {
        throw new AssertionError((Object)"Not implemented");
    }

    public Object gotoDefinition(NamedValue param) {
        NamedValue doc = param.child("\"textDocument\"");
        NamedValue uri = doc.child("\"uri\"");
        this.lastUrl = URLDecoder.decode(uri.atomic);
        NamedValue position = param.child("\"position\"");
        int line = Integer.parseInt(position.child((String)"\"line\"").atomic);
        int character = Integer.parseInt(position.child((String)"\"character\"").atomic);
        BackgroundParser parser = this.parsers.get(this.lastUrl);
        Registry catalog = parser.getRegistry();
        boolean done = parser.waitForParsingFinish();
        parser.lastCharPos = parser.lineNo2CharPos1(line + 1) + character;
        int from = LexerToken.char2lex(parser.src, (int)parser.lastCharPos);
        String tokenContent = "N/A";
        try {
            LexerToken token = parser.src.get(from);
            tokenContent = token.content;
        }
        catch (Throwable token) {
            // empty catch block
        }
        SymbolContext symbol = catalog.getSymbol(from);
        if (symbol == null) {
            SyntaxError err = SyntaxError.checkSyntax((String)parser.text, (String[])new String[]{parser.topSymbol}, parser.src, (Earley)parser.earley, (Matrix)parser.matrix);
            String msg = "Didn't find the object " + tokenContent;
            if (err != null) {
                msg = msg + ". " + err.getDetailedMessage();
                LSP.Log.log(Level.WARNING, msg, "");
                return null;
            }
            parser.lastCharPos = parser.lineNo2CharPos1(line + 1) + character;
            from = LexerToken.char2lex(parser.src, (int)parser.lastCharPos);
            symbol = catalog.getSymbol(from);
            if (symbol == null) {
                msg = "Didn't find the object " + tokenContent;
                LSP.Log.log(Level.WARNING, msg, "");
                return null;
            }
            return parser.getRegistry().locate(symbol);
        }
        return parser.getRegistry().locate(symbol);
    }

    public String findReferences(NamedValue param) {
        throw new AssertionError((Object)"Not implemented");
    }

    public DocumentSymbol[] documentSymbol(NamedValue param) {
        NamedValue doc = param.child("\"textDocument\"");
        NamedValue uri = doc.child("\"uri\"");
        this.lastUrl = URLDecoder.decode(uri.atomic);
        BackgroundParser parser = this.parsers.get(this.lastUrl);
        boolean done = parser.waitForParsingFinish();
        if (!done) {
            return new DocumentSymbol[0];
        }
        if (parser.src.size() == 0) {
            return new DocumentSymbol[0];
        }
        DocumentSymbol[] ret = parser.filter(parser.root).toArray(new DocumentSymbol[0]);
        return ret;
    }

    public SymbolInformation[] workspaceSymbols(NamedValue param) {
        NamedValue query = param.child("\"query\"");
        SymbolInformation[] ret = new SymbolInformation[]{new SymbolInformation("a", 1, new Location("file:///Users/VTROPASH/Documents/test.sql", new Range(new Position(1, 1), new Position(1, 2)))), new SymbolInformation("b", 2, new Location("/Users/VTROPASH/Documents/scratch.json", new Range(new Position(1, 1), new Position(1, 2))))};
        return ret;
    }

    public CodeAction[] codeAction(NamedValue param) {
        NamedValue doc = param.child("\"textDocument\"");
        NamedValue uri = doc.child("\"uri\"");
        this.lastUrl = URLDecoder.decode(uri.atomic);
        BackgroundParser parser = this.parsers.get(this.lastUrl);
        boolean done = parser.waitForParsingFinish();
        NamedValue range = param.child("\"range\"");
        NamedValue start = range.child("\"start\"");
        int line = Integer.parseInt(start.child((String)"\"line\"").atomic);
        int character = Integer.parseInt(start.child((String)"\"character\"").atomic);
        if (line != 0 || character != 0) {
            return null;
        }
        LinkedList<CodeAction> ret = new LinkedList<CodeAction>();
        String fullConnSt = parser.associatedFullConnStr();
        if (fullConnSt == null) {
            for (String c : parser.languageServer.establishedConnections.keySet()) {
                if (!(parser.languageServer.establishedConnections.get(c) instanceof Connection)) continue;
                ret.add(new CodeAction("Associate " + OracleDictionary.conn2dirName(c), new Diagnostics[]{new Diagnostics(LSP.oneRange, "xxx")}, new Command("workspace/executeCommand", "arbori.oneLinerCommand", "`ASSOCIATE_CONNECTION` `" + c + "`")));
            }
        } else {
            ret.add(new CodeAction("Dissociate " + parser.getRegistry().abbreviatedConnString(), new Diagnostics[]{new Diagnostics(LSP.oneRange, "xxx")}, new Command("workspace/executeCommand", "arbori.oneLinerCommand", "`DISSOCIATE_CONNECTION` `[0,0)` `" + parser.getRegistry().fullConnString() + "`")));
        }
        return ret.toArray(new CodeAction[ret.size()]);
    }

    public void codeLens(NamedValue param, final int id) {
        NamedValue doc = param.child("\"textDocument\"");
        NamedValue uri = doc.child("\"uri\"");
        this.lastUrl = URLDecoder.decode(uri.atomic);
        new Thread(){

            @Override
            public void run() {
                BackgroundParser parser = LanguageServer.this.parsers.get(LanguageServer.this.lastUrl);
                for (int i = 0; i < 10 && parser == null; ++i) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        LanguageServer.this.getLSP().asyncResponses.put(id, new CodeLens[0]);
                        return;
                    }
                    parser = LanguageServer.this.parsers.get(LanguageServer.this.lastUrl);
                }
                if (parser == null) {
                    LanguageServer.this.getLSP().asyncResponses.put(id, new CodeLens[0]);
                } else {
                    if (!parser.enableCodeLens) {
                        LanguageServer.this.getLSP().asyncResponses.put(id, new CodeLens[0]);
                        return;
                    }
                    boolean done = parser.waitForParsingFinish();
                    if (!done) {
                        LanguageServer.this.getLSP().asyncResponses.put(id, new CodeLens[0]);
                        return;
                    }
                    done = parser.waitForArboriFinish();
                    if (!done) {
                        LanguageServer.this.getLSP().asyncResponses.put(id, new CodeLens[0]);
                        return;
                    }
                    LanguageServer.this.getLSP().asyncResponses.put(id, parser.codeLens);
                }
            }
        }.start();
    }

    public CodeLens resolveCodeLens(NamedValue param) {
        throw new AssertionError((Object)"Not implemented");
    }

    public String prepareRename(NamedValue param) {
        throw new AssertionError((Object)"Not implemented");
    }

    public WorkspaceEdit rename(NamedValue param) {
        NamedValue doc = param.child("\"textDocument\"");
        NamedValue uri = doc.child("\"uri\"");
        this.lastUrl = URLDecoder.decode(uri.atomic);
        BackgroundParser parser = this.parsers.get(this.lastUrl);
        NamedValue position = param.child("\"position\"");
        int line = Integer.parseInt(position.child((String)"\"line\"").atomic);
        int character = Integer.parseInt(position.child((String)"\"character\"").atomic);
        int offset = parser.lineNo2CharPos1(line + 1) + character;
        String newName = param.child((String)"\"newName\"").atomic;
        int from = LexerToken.char2lex(parser.src, (int)offset);
        Registry registry = parser.getRegistry();
        SymbolContext sym = registry.getSymbol(from);
        int decl = -1;
        decl = sym != null && 0 < sym.declaration ? sym.declaration : from;
        HashMap<Range, String> changes = new HashMap<Range, String>();
        Map<Integer, SymbolContext> allSymbols = registry.getSymbols();
        for (SymbolContext s : allSymbols.values()) {
            if (s.declaration != decl) continue;
            LexerToken t = parser.src.get(s.pos);
            int l = parser.charPos2LineNo0(t.begin);
            int cb = t.begin - parser.lineNo2CharPos0(l);
            int ce = t.end - parser.lineNo2CharPos0(l);
            Range range = new Range(new Position(l, cb), new Position(l, ce));
            changes.put(range, newName.substring(1, newName.length() - 1));
        }
        if (changes.size() == 0) {
            return null;
        }
        LexerToken t = parser.src.get(decl);
        int l = parser.charPos2LineNo0(t.begin);
        int cb = t.begin - parser.lineNo2CharPos0(l);
        int ce = t.end - parser.lineNo2CharPos0(l);
        Range range = new Range(new Position(l, cb), new Position(l, ce));
        changes.put(range, newName.substring(1, newName.length() - 1));
        return new WorkspaceEdit(this.lastUrl.substring(1, this.lastUrl.length() - 1), changes);
    }

    public void didChangeWorkspaceFolders(NamedValue param) {
        NamedValue event = param.child("\"event\"");
        NamedValue added = event.child("\"added\"");
        String a = this.extractDictUri(added);
        if (a != null) {
            this.dictionaryUri = a;
        } else {
            NamedValue removed = event.child("\"removed\"");
            String r = this.extractDictUri(removed);
            if (r != null) {
                this.dictionaryUri = this.rootUri;
            }
        }
    }

    public Format getFormat() {
        return this.format;
    }

    public String formatting(NamedValue param) throws IOException {
        NamedValue doc = param.child("\"textDocument\"");
        NamedValue uri = doc.child("\"uri\"");
        this.lastUrl = URLDecoder.decode(uri.atomic);
        BackgroundParser parser = this.parsers.get(this.lastUrl);
        String input = parser.text;
        String formatted = this.format.format(input);
        int lastLine = parser.charPos2LineNo1(formatted.length());
        String result = Util.sugarcoatText(formatted);
        return "[{\"range\":{\"start\":{\"line\":0,\"character\":0},\"end\":{\"line\":" + lastLine + ",\"character\":0}}, \"newText\":\"" + result + "\"}]";
    }

    public void documentColor(NamedValue param, final int id) {
        NamedValue doc = param.child("\"textDocument\"");
        NamedValue uri = doc.child("\"uri\"");
        this.lastUrl = URLDecoder.decode(uri.atomic);
        new Thread(){

            @Override
            public void run() {
                BackgroundParser parser = LanguageServer.this.parsers.get(LanguageServer.this.lastUrl);
                for (int i = 0; i < 10 && parser == null; ++i) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        LanguageServer.this.getLSP().asyncResponses.put(id, new ColorInformation[0]);
                        return;
                    }
                    parser = LanguageServer.this.parsers.get(LanguageServer.this.lastUrl);
                }
                if (parser == null) {
                    LanguageServer.this.getLSP().asyncResponses.put(id, new ColorInformation[0]);
                } else {
                    LanguageServer.this.getLSP().asyncResponses.put(id, LanguageServer.this.colorInfo(parser));
                }
            }
        }.start();
    }

    private ColorInformation[] colorInfo(BackgroundParser parser) {
        boolean done = parser.waitForParsingFinish();
        if (!done) {
            return new ColorInformation[0];
        }
        HashSet<ColorInformation> ret = new HashSet<ColorInformation>();
        Integer connect = (Integer)parser.earley.symbolIndexes.get("connect");
        Integer parse = (Integer)parser.earley.symbolIndexes.get("parse");
        Integer CONNECT = (Integer)parser.earley.symbolIndexes.get("CONNECT");
        for (ParseNode p = parser.root; p != null; p = p.next()) {
            if (p.from == p.to) {
                return ret.toArray(new ColorInformation[0]);
            }
            int pos = parser.src.get((int)p.from).begin;
            int line = parser.charPos2LineNo1(pos);
            int lineStart = parser.lineNo2CharPos1(line);
            Position start = new Position(line - 1, pos - lineStart);
            Position end = new Position(line - 1, pos - lineStart + 1);
            Range range = new Range(start, end);
            if (null != CONNECT && p.contains(CONNECT.intValue())) {
                String connectCmd = parser.text.substring(parser.src.get((int)p.from).begin, parser.src.get((int)(p.to - 1)).end);
                try {
                    Object connection = this.getConnection(OracleDictionary.parseConnectCommand(connectCmd));
                    if (connection == null) {
                        ret.add(new ColorInformation(range, Color.disconnected));
                    } else if (connection instanceof Connection) {
                        ret.add(new ColorInformation(range, Color.connected));
                    } else {
                        ret.add(new ColorInformation(range, Color.error));
                    }
                }
                catch (Throwable e) {
                    ret.add(new ColorInformation(range, Color.error));
                }
            }
            if ((null == connect || !p.contains(connect.intValue())) && (null == parse || !p.contains(parse.intValue()))) continue;
            List<LexerToken> command = parser.src.subList(p.from, p.to);
            String connStr = command.get((int)1).content;
            boolean isConnected = this.getConnection(ArboriCatalog.canonicalFileURL(connStr)) != null;
            ret.add(new ColorInformation(range, isConnected ? Color.connected : Color.disconnected));
        }
        return ret.toArray(new ColorInformation[0]);
    }

    public Jsonable[] colorPresentation(NamedValue params) {
        return new ColorPresentation[]{new ColorPresentation("(+)")};
    }

    public FoldingRange[] foldingRange(NamedValue param) {
        NamedValue doc = param.child("\"textDocument\"");
        NamedValue uri = doc.child("\"uri\"");
        this.lastUrl = URLDecoder.decode(uri.atomic);
        BackgroundParser parser = this.parsers.get(this.lastUrl);
        boolean done = parser.waitForParsingFinish();
        if (!done) {
            return new FoldingRange[0];
        }
        return parser.foldingRanges.toArray(new FoldingRange[0]);
    }

    public SemanticTokens semanticTokensFull(NamedValue param) {
        NamedValue doc = param.child("\"textDocument\"");
        NamedValue uri = doc.child("\"uri\"");
        this.lastUrl = URLDecoder.decode(uri.atomic);
        BackgroundParser parser = this.parsers.get(this.lastUrl);
        boolean done = parser.waitForLexingFinish();
        if (!done) {
            return null;
        }
        return new SemanticTokens(parser);
    }

    public String documentLink(NamedValue param) {
        throw new AssertionError((Object)"Not implemented");
    }

    public void doAsyncWork() {
    }

    public Object executeCommand(NamedValue params) {
        NamedValue args = params.child("\"arguments\"");
        if (args == null) {
            args = params;
        }
        NamedValue cmd = args.firstChild();
        String cmdPlusArg = Util.cleanText(cmd.atomic);
        List src = Lexer.parse((String)cmdPlusArg, (String)"`");
        String classNameOrRPCName = ((LexerToken)src.get((int)0)).content.substring(1, ((LexerToken)src.get((int)0)).content.length() - 1);
        String argument1 = "empty";
        if (1 < src.size()) {
            argument1 = ((LexerToken)src.get((int)1)).content.substring(1, ((LexerToken)src.get((int)1)).content.length() - 1);
        }
        String argument2 = "empty";
        if (2 < src.size()) {
            argument2 = ((LexerToken)src.get((int)2)).content.substring(1, ((LexerToken)src.get((int)2)).content.length() - 1);
        }
        String argument3 = "empty";
        if (3 < src.size()) {
            argument3 = ((LexerToken)src.get((int)3)).content.substring(1, ((LexerToken)src.get((int)3)).content.length() - 1);
        }
        BackgroundParser parser = this.parsers.get(this.getLastUrl());
        boolean done = parser.waitForParsingFinish();
        String ret = this.executeCommand(classNameOrRPCName, argument1, argument2, argument3);
        if (ret != null) {
            return ret;
        }
        try {
            CodeLens codeLens = CodeLens.find(parser.codeLens, classNameOrRPCName, argument1, argument2);
            return codeLens.executeCommand();
        }
        catch (Exception e) {
            String msg = "Didn't find the object " + argument1 + "(" + argument2 + ")";
            LSP.Log.log(Level.SEVERE, msg, "");
            return new ResponseError(-32601, Util.sugarcoatText(msg), "");
        }
    }

    public static void registerCallback(String name, RemoteProcedure proc) {
        callbackRegistry.put(name, proc);
    }

    private String executeCommand(String cmd, String argument1, String argument2, String argument3) {
        RemoteProcedure proc = callbackRegistry.get(cmd);
        if (proc != null) {
            String[] args = new String[]{argument1, argument2, argument3};
            return proc.run(args);
        }
        return null;
    }

    public void documentsBump() {
        for (String u : this.parsers.keySet()) {
            BackgroundParser bp = this.parsers.get(u);
            if (0 >= bp.text.length()) continue;
            this.lsp.documentBump(bp);
        }
    }

    public void setHistory(String mode) {
        if ("ON".equalsIgnoreCase(mode)) {
            this.historyLength = this.lastHistoryLength;
        } else if ("OFF".equalsIgnoreCase(mode)) {
            if (this.historyLength != 1) {
                this.lastHistoryLength = this.historyLength;
            }
            this.historyLength = -1;
        } else {
            int len;
            this.historyLength = len = Integer.parseInt(mode);
        }
    }

    public void logStatement(String sql) {
        if (this.historyLength < 1) {
            return;
        }
        if (this.historyUrl == null) {
            int cut = this.getLastUrl().lastIndexOf(47);
            this.historyUrl = this.getLastUrl().substring(1, cut + 1) + "history.sql";
        }
        String connStr = this.associatedFullConnStr(this.getLastUrl());
        String historyUri = "\"" + this.historyUrl + "\"";
        Object connectCmd = "connect " + connStr;
        Date date = new Date();
        BackgroundParser historyParser = this.parsers.get(historyUri);
        if (historyParser == null) {
            String content = (String)connectCmd + "\n\n/* " + date + " */\n" + sql + ";\n\n";
            BackgroundParser parser = this.parsers.get(this.lastUrl);
            if (parser == null) {
                try {
                    parser = BackgroundParser.factory(content, this.historyUrl, this);
                    this.parsers.put(historyUri, parser);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
            this.getLSP().createFile(this.historyUrl, content);
            return;
        }
        Range delete = LSP.zeroRange;
        boolean done = historyParser.waitForArboriFinish();
        if (!done) {
            System.err.println("**** historyParser.waitForArboriFinish()=false");
            System.err.println("historyParser.text=" + historyParser.text + ".");
            return;
        }
        if (this.historyLength < historyParser.codeLens.length) {
            Position end;
            CodeLens command2 = CodeLens.rangedCommandAt(historyParser.codeLens, 2);
            if (command2.node.contains("CONNECT")) {
                Range r0 = CodeLens.rangedCommandAt(historyParser.codeLens, 0).getRange();
                Range r1 = CodeLens.rangedCommandAt(historyParser.codeLens, 1).getRange();
                end = new Position(r1.end.line + 1, 0);
                delete = new Range(r0.start, end);
            } else {
                Range r1 = CodeLens.rangedCommandAt(historyParser.codeLens, 1).getRange();
                Position start = new Position(r1.start.line - 2, 0);
                end = new Position(r1.end.line + 1, 0);
                delete = new Range(start, end);
            }
        }
        String lastConnect = "";
        for (int i = historyParser.codeLens.length - 1; 0 <= i; --i) {
            CodeLens command = historyParser.codeLens[i];
            if (!command.node.contains("CONNECT")) continue;
            lastConnect = historyParser.text.substring(historyParser.src.get((int)command.node.from).begin, historyParser.src.get((int)(command.node.to - 1)).end);
            break;
        }
        connectCmd = lastConnect.equalsIgnoreCase((String)connectCmd) ? "" : (String)connectCmd + "\n\n";
        this.getLSP().documentInsert(delete, LSP.fullRange, this.historyUrl, "", (String)connectCmd + "/* " + date + " */\n" + sql + ";\n\n");
    }

    public static void main(String[] args) throws Exception {
        skipInitWorkspace = true;
        LSP.main(args);
    }

    static {
        LanguageServer.registerCallback("ToggleCodeLens", new RemoteProcedure(){

            @Override
            public String run(String[] arguments) {
                BackgroundParser parser = LSP.getServer().parsers.get(LSP.getServer().getLastUrl());
                parser.enableCodeLens = !parser.enableCodeLens;
                parser.documentBump();
                return "OK";
            }
        });
        LanguageServer.registerCallback(ASSOCIATE_CONNECTION, new RemoteProcedure(){

            @Override
            public String run(String[] arguments) {
                BackgroundParser parser = LSP.getServer().parsers.get(LSP.getServer().getLastUrl());
                parser.getRegistry().associateConnection(arguments[0]);
                parser.resetDiagnostics();
                parser.documentBump();
                return "OK";
            }
        });
        LanguageServer.registerCallback(DISSOCIATE_CONNECTION, new RemoteProcedure(){

            @Override
            public String run(String[] arguments) {
                BackgroundParser parser = LSP.getServer().parsers.get(LSP.getServer().getLastUrl());
                parser.getRegistry().associateConnection(arguments[0]);
                parser.resetDiagnostics();
                parser.documentBump();
                return "OK";
            }
        });
        LanguageServer.registerCallback("RunStatement", new RemoteProcedure(){

            @Override
            public String run(String[] arguments) {
                BackgroundParser parser = LSP.getServer().parsers.get(LSP.getServer().getLastUrl());
                int charPos = parser.getLastCharPos();
                int line = parser.charPos2LineNo1(charPos);
                for (CodeLens command : parser.codeLens) {
                    if (parser.src.get((int)command.node.from).begin > charPos || charPos > parser.src.get((int)(command.node.to - 1)).end) continue;
                    LSP.Log.log(Level.INFO, "Executing statement at line " + line, "");
                    command.executeCommand();
                    return "OK";
                }
                LSP.windowShowMessage("Didn't find command at line " + line, 1);
                return "Not OK";
            }
        });
        LanguageServer.registerCallback("CURSOR_POS", new RemoteProcedure(){

            @Override
            public String run(String[] arguments) {
                BackgroundParser parser = LSP.getServer().parsers.get(LSP.getServer().getLastUrl());
                int line = Integer.parseInt(arguments[0]);
                int pos = Integer.parseInt(arguments[1]);
                parser.lastCharPos = parser.lineNo2CharPos0(line) + pos;
                System.out.println("onDidChangeTextEditorSelection lastPos=" + parser.lastCharPos);
                return "OK";
            }
        });
        LanguageServer.registerCallback("Query select user,sysdate from dual", new RemoteProcedure(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String run(String[] arguments) {
                String connectionStr = arguments[0];
                String query = "select user,sysdate from dual";
                try (Connection c = DriverManager.getConnection(connectionStr);){
                    PreparedStatement stmt = c.prepareStatement(query);
                    ResultSet rs = stmt.executeQuery();
                    if (!rs.next()) return "OK";
                    String string = "{ \"user\":\"" + rs.getString(1) + "\",\"sysdate\":\"" + rs.getString(2) + "\"}";
                    return string;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return e.getMessage();
                }
            }
        });
    }
}

