/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtilImplFactory;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.db.Messages;
import oracle.dbtools.db.OracleUtil;
import oracle.dbtools.db.PrepareResult;
import oracle.dbtools.db.ThirdPartyUtil;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.MessageLogging;
import oracle.dbtools.util.Service;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.CLOB;

public abstract class DBUtil {
    protected static final String VERSION_10G_STRING = "10.1";
    protected static final String EMPTY_STRING = "";
    private static final String QUOTE_DELIMITER = "\"";
    protected static final Logger LOGGER = Logger.getLogger(DBUtil.class.getName());
    public static final Object NULL_VALUE = new Object();
    public static final String SUBSTITUTION = "substitution";
    public static final String PREFERRED_FETCH_SIZE = "PreferfedFetchSize";
    private static Map<Thread, Statement> s_execThreadMap = new HashMap<Thread, Statement>();
    protected static String s_prodName;
    private Boolean s_escapeProcessing = null;
    private static String m_currentErrorString;
    private static List<DBUtilImplFactory> s_staticFactories;
    private static ServiceLoader<DBUtilImplFactory> s_loader;
    protected final Connection m_conn;
    protected final ConnectionIdentifier mID;
    private final String mName;
    private boolean m_raiseError;
    private ThreadLocal<SQLException> m_lastException = new ThreadLocal();
    private static final String VERSION_PATTERN = "[0-9]+\\.[0-9.]*[0-9]+";
    private static final Pattern s_pattern;
    public static final Version ORACLE8_VERSION;
    public static final Version ORACLE8i_VERSION;
    public static final Version ORACLE9i_VERSION;
    public static final Version ORACLE9iR2_VERSION;
    public static final Version ORACLE10g_VERSION;
    public static final Version ORACLE10gR2_VERSION;
    public static final Version ORACLE11g_VERSION;
    public static final Version ORACLE12c_VERSION;
    static final boolean DEBUG_BUILD;
    private static ThreadLocal<Integer> s_lockCheckCount;
    public static final String SIZE_STANDARD = "STANDARD";
    public static final String SIZE_EXTENDED = "EXTENDED";

    public static void setProductName(String prodName) {
        s_prodName = prodName;
    }

    public void setEscapeProcessing(Boolean escapeProcessing) {
        this.s_escapeProcessing = escapeProcessing;
    }

    public Boolean getEscapeProcessing() {
        return this.s_escapeProcessing;
    }

    public static void registerImplFactory(DBUtilImplFactory factory) {
        s_staticFactories.add(factory);
    }

    public static DBUtil getInstance(Connection conn) {
        return DBUtil.getInstance(null, conn);
    }

    public static DBUtil getInstance(String cName) {
        DBUtil instance = null;
        try {
            Connection conn = ConnectionResolver.getConnection(cName);
            if (conn != null) {
                instance = DBUtil.getInstance(cName, conn);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DBUtil createImpl(ConnectionIdentifier id) {
        String cType = ConnectionResolver.getConnectionType(id.getConnection());
        DBUtil impl = null;
        Object object = s_loader;
        synchronized (object) {
            DBUtilImplFactory factory;
            Iterator<DBUtilImplFactory> iterator = s_loader.iterator();
            while (iterator.hasNext() && (impl = (factory = iterator.next()).createImpl(cType, id)) == null) {
            }
        }
        if (impl == null) {
            DBUtilImplFactory factory;
            object = s_staticFactories.iterator();
            while (object.hasNext() && (impl = (factory = (DBUtilImplFactory)object.next()).createImpl(cType, id)) == null) {
            }
        }
        if (impl == null) {
            impl = new ThirdPartyUtil(id);
        }
        return impl;
    }

    private static DBUtil getInstance(String cName, Connection conn) {
        assert (conn != null);
        ConnectionIdentifier id = DefaultConnectionIdentifier.createIdentifier(cName, conn);
        return DBUtil.getInstance(id);
    }

    public static DBUtil getInstance(ConnectionIdentifier id) {
        return DBUtil.createImpl(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cancelExecution(Thread t) {
        Map<Thread, Statement> map = s_execThreadMap;
        synchronized (map) {
            Statement stmt = s_execThreadMap.get(t);
            if (stmt != null) {
                try {
                    stmt.cancel();
                    return true;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    protected DBUtil(ConnectionIdentifier id) {
        this.m_conn = id.getConnection();
        this.mName = id.toString();
        this.mID = id;
    }

    public final ConnectionIdentifier getConnectionIdentifier() {
        return this.mID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setCurrentStatement(Statement stmt) {
        Map<Thread, Statement> map = s_execThreadMap;
        synchronized (map) {
            s_execThreadMap.put(Thread.currentThread(), stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void clearCurrentStatement() {
        Map<Thread, Statement> map = s_execThreadMap;
        synchronized (map) {
            s_execThreadMap.remove(Thread.currentThread());
        }
    }

    public void setDBAction(String action) {
        throw new UnsupportedOperationException("setDBAction");
    }

    public void setDBModuleAction(String action) {
        throw new UnsupportedOperationException("setDBModuleAction");
    }

    public String executeReturnOneCol(String query, Map<String, ? extends Object> binds) {
        return this.executeNonOracleReturnOneCol(query, binds);
    }

    public String executeReturnOneCol(String query) {
        return this.executeNonOracleReturnOneCol(query, null);
    }

    private PreparedStatement getPrepared(String sqlstm) throws SQLException {
        PreparedStatement stm = this.m_conn.prepareStatement(sqlstm);
        this.setOptionalAttributes(stm);
        return stm;
    }

    private CallableStatement getCallable(String sqlstm) throws SQLException {
        CallableStatement stm = this.m_conn.prepareCall(sqlstm);
        this.setOptionalAttributes(stm);
        return stm;
    }

    private Statement getStatement() throws SQLException {
        Statement stm = this.m_conn.createStatement();
        this.setOptionalAttributes(stm);
        return stm;
    }

    private void setOptionalAttributes(Statement stm) throws SQLException {
        if (this.s_escapeProcessing != null) {
            stm.setEscapeProcessing(this.s_escapeProcessing);
        }
    }

    private String executeNonOracleReturnOneCol(final String query, final Map<String, ?> binds) {
        OperImpl<String> callable = new OperImpl<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws SQLException {
                String string;
                PrepareResult prep = DBUtil.this.prepareNonOracleSql(query, binds);
                String sql = prep.getSQL();
                List<Object> bindList = prep.getBinds();
                sql = sql.replaceAll("\n", " ");
                PreparedStatement stmt = null;
                ResultSet rset = null;
                try {
                    stmt = DBUtil.this.getPrepared(sql);
                    DBUtil.bind(stmt, bindList);
                    rset = stmt.executeQuery();
                    rset.next();
                    string = rset.getString(1);
                }
                catch (Throwable throwable) {
                    DBUtil.cleanup(stmt, rset);
                    throw throwable;
                }
                DBUtil.cleanup(stmt, rset);
                return string;
            }

            @Override
            public String getSQL() {
                return query;
            }
        };
        return this.lockForOperation(callable, null);
    }

    public final String executeOracleReturnOneCol(final String query, final Map<String, ?> binds) {
        OperImpl<String> callable = new OperImpl<String>(){

            @Override
            public String getSQL() {
                return query;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws SQLException {
                ResultSet rset;
                PreparedStatement statement;
                block2: {
                    String string;
                    statement = null;
                    rset = null;
                    try {
                        statement = DBUtil.this.getPrepared(query);
                        DBUtil.bind(query, statement, binds);
                        rset = statement.executeQuery();
                        if (!rset.next()) break block2;
                        string = rset.getString(1);
                    }
                    catch (Throwable throwable) {
                        DBUtil.cleanup(statement, rset);
                        throw throwable;
                    }
                    DBUtil.cleanup(statement, rset);
                    return string;
                }
                DBUtil.cleanup(statement, rset);
                return null;
            }
        };
        return this.lockForOperation(callable, null);
    }

    public final String executeReturnOneCol(final String query, final List<?> binds) {
        OperImpl<String> callable = new OperImpl<String>(){

            @Override
            public String getSQL() {
                return query;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws SQLException {
                ResultSet rset;
                CallableStatement statement;
                block2: {
                    String string;
                    statement = null;
                    rset = null;
                    try {
                        statement = DBUtil.this.getCallable(query);
                        DBUtil.bind((PreparedStatement)statement, binds);
                        rset = statement.executeQuery();
                        if (!rset.next()) break block2;
                        string = rset.getString(1);
                    }
                    catch (Throwable throwable) {
                        DBUtil.cleanup(statement, rset);
                        throw throwable;
                    }
                    DBUtil.cleanup(statement, rset);
                    return string;
                }
                DBUtil.cleanup(statement, rset);
                return null;
            }
        };
        return this.lockForOperation(callable, null);
    }

    public final int executeUpdate(final String query, final List<?> binds) {
        OperImpl<Integer> callable = new OperImpl<Integer>(){

            @Override
            public String getSQL() {
                return query;
            }

            @Override
            public Integer call() throws SQLException {
                Integer n;
                CallableStatement statement = null;
                try {
                    statement = DBUtil.this.getCallable(query);
                    if (binds != null) {
                        DBUtil.bind((PreparedStatement)statement, binds);
                    }
                    n = statement.executeUpdate();
                }
                catch (Throwable throwable) {
                    DBUtil.cleanup(statement);
                    throw throwable;
                }
                DBUtil.cleanup(statement);
                return n;
            }
        };
        return this.lockForOperation(callable, 0);
    }

    public final int executeUpdate(final String query, final Map<String, ?> binds) {
        OperImpl<Integer> callable = new OperImpl<Integer>(){

            @Override
            public String getSQL() {
                return query;
            }

            @Override
            public Integer call() throws SQLException {
                Integer n;
                PreparedStatement statement = null;
                try {
                    statement = DBUtil.this.prepareExecute(query, binds);
                    n = statement.executeUpdate();
                }
                catch (Throwable throwable) {
                    DBUtil.cleanup(statement);
                    throw throwable;
                }
                DBUtil.cleanup(statement);
                return n;
            }
        };
        return this.lockForOperation(callable, 0);
    }

    public final boolean execute(String query) {
        return this.execute(query, null, null);
    }

    public final boolean execute(String query, List<?> binds) {
        return this.execute(query, binds, null);
    }

    public final boolean execute(final String query, final List<?> binds, String msg) {
        OperImpl<Boolean> callable = new OperImpl<Boolean>(){

            @Override
            public String getSQL() {
                return query;
            }

            @Override
            public Boolean call() throws SQLException {
                Boolean bl;
                CallableStatement statement = null;
                try {
                    statement = DBUtil.this.getCallable(query);
                    if (binds != null) {
                        DBUtil.bind((PreparedStatement)statement, binds);
                    }
                    bl = statement.execute();
                }
                catch (Throwable throwable) {
                    DBUtil.cleanup(statement);
                    throw throwable;
                }
                DBUtil.cleanup(statement);
                return bl;
            }
        };
        return this.lockForOperation(callable, Boolean.FALSE);
    }

    public final PreparedStatement prepareExecute(final String sql, final Map<String, ?> binds) {
        PreparedStatement statement = null;
        try {
            statement = DBUtil.assertLock(new OperImpl<PreparedStatement>(){

                @Override
                public String getSQL() {
                    return sql;
                }

                @Override
                public PreparedStatement call() throws Exception {
                    PreparedStatement stmt = DBUtil.this.prepareExecuteImpl(sql, binds);
                    return stmt;
                }
            });
            this.clearLastException();
        }
        catch (SQLException e) {
            DBUtil.cleanup(statement);
            this.handleException(e, sql);
            statement = null;
        }
        catch (Exception e) {
            DBUtil.cleanup(statement);
            this.reportException(e);
            statement = null;
        }
        return statement;
    }

    private void reportException(Exception e) {
        if (this.m_raiseError) {
            String cName = ConnectionResolver.getConnectionName(this.m_conn);
            if (cName != null) {
                ExceptionHandler.handleException(e, cName);
            } else {
                ExceptionHandler.handleException(e);
            }
        } else {
            LOGGER.severe(e.getMessage());
        }
    }

    protected PreparedStatement prepareExecuteImpl(String sql, Map<String, ?> binds) throws SQLException {
        PrepareResult prep = this.prepareNonOracleSql(sql, binds);
        String prepSql = prep.getSQL();
        CallableStatement stmt = this.getCallable(prepSql);
        List<Object> bindList = prep.getBinds();
        if (bindList.size() > 0) {
            DBUtil.bind((PreparedStatement)stmt, bindList);
        }
        return stmt;
    }

    public final boolean execute(final String sql, final Map<String, ?> binds) {
        OperImpl<Boolean> callable = new OperImpl<Boolean>(){

            @Override
            public Boolean call() {
                PreparedStatement statement = DBUtil.this.prepareExecute(sql, binds);
                return DBUtil.this.execute(statement);
            }
        };
        return this.lockForOperation(callable, false);
    }

    private boolean execute(final PreparedStatement statement) {
        boolean result = false;
        OperImpl<Boolean> callable = new OperImpl<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    statement.execute();
                    Boolean bl = true;
                    return bl;
                }
                finally {
                    DBUtil.cleanup(statement);
                }
            }
        };
        try {
            result = DBUtil.assertLock(callable);
            this.clearLastException();
        }
        catch (SQLException e) {
            this.handleException(e, null);
        }
        catch (Exception e) {
            this.reportException(e);
        }
        return result;
    }

    public final ResultSet executeOracleQuery(final String query, final Map<String, ?> binds) {
        ResultSet wrapper = null;
        OperImpl<ResultSet> callable = new OperImpl<ResultSet>(){

            @Override
            public ResultSet call() throws SQLException {
                PreparedStatement statement = null;
                try {
                    ResultSet rs;
                    statement = DBUtil.this.getPrepared(query);
                    if (binds != null) {
                        DBUtil.bind(query, statement, binds);
                    }
                    DBUtil.this.setCurrentStatement(statement);
                    try {
                        rs = statement.executeQuery();
                    }
                    catch (SQLException e) {
                        throw e;
                    }
                    finally {
                        DBUtil.this.clearCurrentStatement();
                    }
                    return rs;
                }
                catch (SQLException e) {
                    DBUtil.cleanup(statement);
                    throw e;
                }
            }
        };
        try {
            wrapper = DBUtil.assertLock(callable);
            this.clearLastException();
        }
        catch (SQLException e) {
            this.handleException(e, query);
        }
        catch (Exception ex) {
            this.reportException(ex);
        }
        return wrapper;
    }

    public ResultSet executeQuery(String query, Map<String, ?> binds) {
        return this.executeNonOracleQuery(query, binds);
    }

    private String getQueryNonOracleQueryUsingMessageFormat(String query, Map<String, ?> binds) {
        PrepareResult pr = this.prepareNonOracleSqlMsgFormat(query, binds);
        String formatSql = pr.getSQL();
        return formatSql;
    }

    private ResultSet executeNonOracleQuery(String query, Map<String, ?> binds) {
        ResultSet wrapper = null;
        if (query.contains("{:")) {
            query = this.getQueryNonOracleQueryUsingMessageFormat(query, binds);
        }
        ArrayList<Bind> parserdBinds = Parser.getInstance().getBinds(query, true);
        final ArrayList bindList = new ArrayList();
        String sql = query;
        for (Bind b : parserdBinds) {
            bindList.add(binds.get(b.getName()));
            sql = sql.replaceFirst(":" + b.getName(), "?");
        }
        final String mungedSql = sql;
        OperImpl<ResultSet> callable = new OperImpl<ResultSet>(){

            @Override
            public ResultSet call() throws SQLException {
                PreparedStatement stmt = null;
                try {
                    stmt = DBUtil.this.getPrepared(mungedSql);
                    DBUtil.bind(stmt, bindList);
                    ResultSet rs = stmt.executeQuery();
                    return rs;
                }
                catch (SQLException e) {
                    DBUtil.cleanup(stmt);
                    throw e;
                }
            }
        };
        try {
            wrapper = DBUtil.assertLock(callable);
            this.clearLastException();
        }
        catch (SQLException e) {
            this.handleException(e, mungedSql);
        }
        catch (Exception e) {
            this.reportException(e);
        }
        return wrapper;
    }

    public final ResultSet executeQuery(final String query, final List<?> binds) {
        ResultSet rs = null;
        OperImpl<ResultSet> callable = new OperImpl<ResultSet>(){

            @Override
            public ResultSet call() throws SQLException {
                PreparedStatement statement = null;
                try {
                    statement = DBUtil.this.prepareQuery(query);
                    if (binds != null) {
                        DBUtil.bind(statement, binds);
                    }
                    ResultSet rs = statement.executeQuery();
                    return rs;
                }
                catch (SQLException e) {
                    DBUtil.cleanup(statement);
                    throw e;
                }
            }
        };
        try {
            rs = DBUtil.assertLock(callable);
            this.clearLastException();
        }
        catch (SQLException e) {
            this.handleException(e, query);
        }
        catch (Exception e) {
            this.reportException(e);
        }
        return rs;
    }

    public final List<List<?>> executeReturnListofList(final String sql, final Map<String, ?> binds) {
        OperImpl callable = new OperImpl<List<List<?>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<List<?>> call() throws SQLException {
                ResultSet rs = DBUtil.this.executeQuery(sql, binds);
                try {
                    int i;
                    ArrayList ret = new ArrayList();
                    ArrayList<Object> row = null;
                    String[] colNames = new String[rs.getMetaData().getColumnCount()];
                    row = new ArrayList<Object>();
                    for (i = 0; i < colNames.length; ++i) {
                        row.add(rs.getMetaData().getColumnName(i + 1));
                    }
                    ret.add(row);
                    while (rs.next()) {
                        row = new ArrayList();
                        for (i = 0; i < colNames.length; ++i) {
                            row.add(rs.getObject(i + 1));
                        }
                        ret.add(row);
                    }
                    ArrayList arrayList = ret;
                    return arrayList;
                }
                finally {
                    try {
                        DBUtil.cleanup(rs);
                    }
                    catch (Exception exception) {}
                }
            }
        };
        return this.lockForOperation(callable, null);
    }

    public final List<Map<String, ?>> executeReturnList(final String sql, final Map<String, ?> binds) {
        OperImpl callable = new OperImpl<List<Map<String, ?>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Map<String, ?>> call() throws SQLException {
                ResultSet rs = DBUtil.this.executeQuery(sql, binds);
                try {
                    int i;
                    ArrayList ret = new ArrayList();
                    HashMap<String, Object> row = null;
                    String[] colNames = new String[rs.getMetaData().getColumnCount()];
                    for (i = 0; i < colNames.length; ++i) {
                        colNames[i] = rs.getMetaData().getColumnName(i + 1);
                    }
                    while (rs.next()) {
                        row = new HashMap<String, Object>();
                        for (i = 0; i < colNames.length; ++i) {
                            row.put(colNames[i], rs.getObject(i + 1));
                        }
                        ret.add(row);
                    }
                    ArrayList arrayList = ret;
                    return arrayList;
                }
                finally {
                    try {
                        DBUtil.cleanup(rs);
                    }
                    catch (Exception exception) {}
                }
            }
        };
        List l = Collections.emptyList();
        return this.lockForOperation(callable, l);
    }

    public final Map<String, ?> executeReturnMap(final String sql, final Map<String, ?> binds) {
        OperImpl callable = new OperImpl<Map<String, ?>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, ?> call() throws SQLException {
                HashMap<CallSite, Object> ret = new HashMap<CallSite, Object>();
                ResultSet rs = DBUtil.this.executeQuery(sql, binds);
                try {
                    String[] colNames = new String[rs.getMetaData().getColumnCount()];
                    for (int i = 0; i < colNames.length; ++i) {
                        colNames[i] = rs.getMetaData().getColumnName(i + 1);
                    }
                    while (rs.next()) {
                        int x = 0;
                        for (int i = 0; i < colNames.length; ++i) {
                            ret.put((CallSite)((Object)(x + "." + colNames[i])), rs.getObject(i + 1));
                        }
                        ++x;
                    }
                    HashMap<CallSite, Object> hashMap = ret;
                    return hashMap;
                }
                finally {
                    DBUtil.cleanup(rs);
                }
            }
        };
        return this.lockForOperation(callable, Collections.EMPTY_MAP);
    }

    public static void bind(final PreparedStatement stmt, final Map<String, ?> map) throws SQLException {
        if (map.size() == 0) {
            return;
        }
        try {
            DBUtil.assertLock(new StatementOperImpl<Void>((Statement)stmt){

                @Override
                public Void call() throws SQLException {
                    if (stmt instanceof OraclePreparedStatement) {
                        OraclePreparedStatement ostmt = (OraclePreparedStatement)stmt;
                        Object bindValue = null;
                        for (String bindName : map.keySet()) {
                            bindValue = map.get(bindName);
                            try {
                                if (bindValue == NULL_VALUE) {
                                    ostmt.setNullAtName(bindName, 12);
                                    continue;
                                }
                                if (bindValue instanceof String) {
                                    ostmt.setStringAtName(bindName, (String)bindValue);
                                    continue;
                                }
                                if (bindValue instanceof BigDecimal) {
                                    ostmt.setBigDecimalAtName(bindName, (BigDecimal)bindValue);
                                    continue;
                                }
                                if (bindValue instanceof CLOB) {
                                    ostmt.setCLOBAtName(bindName, (CLOB)bindValue);
                                    continue;
                                }
                                if (bindValue instanceof InputStream) {
                                    ostmt.setBinaryStreamAtName(bindName, (InputStream)bindValue);
                                    continue;
                                }
                                ostmt.setObjectAtName(bindName, bindValue);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        DBUtil.logStateException(new IllegalStateException("Non Oracle statement with bind names"), "{0} called with a non Oracle statement; {1} called {2}");
                        Iterator iter = map.values().iterator();
                        ArrayList bindList = new ArrayList(16);
                        while (iter.hasNext()) {
                            bindList.add(iter.next());
                        }
                        DBUtil.bind(stmt, bindList);
                    }
                    return null;
                }
            });
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void bind(final PreparedStatement stmt, final List<?> binds) throws SQLException {
        StatementOperImpl<Void> callable = new StatementOperImpl<Void>((Statement)stmt){

            @Override
            public Void call() throws SQLException {
                int bindIdx = 1;
                for (Object bind : binds) {
                    if (bind == NULL_VALUE || bind instanceof String && ((String)bind).equals(DBUtil.EMPTY_STRING)) {
                        stmt.setNull(bindIdx, 12);
                    } else if (bind instanceof String) {
                        stmt.setString(bindIdx, (String)bind);
                    } else if (bind instanceof BigDecimal) {
                        stmt.setBigDecimal(bindIdx, (BigDecimal)bind);
                    } else if (bind instanceof Date) {
                        stmt.setDate(bindIdx, (Date)bind);
                    } else if (bind instanceof Integer) {
                        stmt.setInt(bindIdx, (Integer)bind);
                    } else if (bind instanceof Array) {
                        stmt.setArray(bindIdx, (Array)bind);
                    } else if (bind instanceof Blob) {
                        stmt.setBlob(bindIdx, (Blob)bind);
                    } else if (bind instanceof Boolean) {
                        stmt.setBoolean(bindIdx, (Boolean)bind);
                    } else if (bind instanceof Byte) {
                        stmt.setByte(bindIdx, (Byte)bind);
                    } else if (bind instanceof byte[]) {
                        stmt.setBytes(bindIdx, (byte[])bind);
                    } else if (bind instanceof Clob) {
                        stmt.setClob(bindIdx, (Clob)bind);
                    } else if (bind instanceof Double) {
                        stmt.setDouble(bindIdx, (Double)bind);
                    } else if (bind instanceof Float) {
                        stmt.setFloat(bindIdx, ((Float)bind).floatValue());
                    } else if (bind instanceof Integer) {
                        stmt.setInt(bindIdx, (Integer)bind);
                    } else if (bind instanceof Long) {
                        stmt.setLong(bindIdx, (Long)bind);
                    } else if (bind instanceof NClob) {
                        stmt.setNClob(bindIdx, (NClob)bind);
                    } else if (bind instanceof String) {
                        stmt.setNString(bindIdx, (String)bind);
                    } else if (bind instanceof Ref) {
                        stmt.setRef(bindIdx, (Ref)bind);
                    } else if (bind instanceof RowId) {
                        stmt.setRowId(bindIdx, (RowId)bind);
                    } else if (bind instanceof Short) {
                        stmt.setShort(bindIdx, (Short)bind);
                    } else if (bind instanceof String) {
                        stmt.setString(bindIdx, (String)bind);
                    } else if (bind instanceof SQLXML) {
                        stmt.setSQLXML(bindIdx, (SQLXML)bind);
                    } else if (bind instanceof Time) {
                        stmt.setTime(bindIdx, (Time)bind);
                    } else if (bind instanceof Timestamp) {
                        stmt.setTimestamp(bindIdx, (Timestamp)bind);
                    } else if (bind instanceof URL) {
                        stmt.setURL(bindIdx, (URL)bind);
                    } else {
                        stmt.setObject(bindIdx, bind);
                    }
                    ++bindIdx;
                }
                return null;
            }
        };
        try {
            DBUtil.assertLock(callable);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDBMSOUTPUT() {
        throw new UnsupportedOperationException("getDBMSOUTPUT");
    }

    public void handleException(Exception e) {
        String err = e.getMessage();
        MessageLogging.getInstance().log(err);
    }

    final Version fetchDbVersion() {
        OperImpl<String> oper = new OperImpl<String>(){

            @Override
            public String call() throws Exception {
                return DBUtil.this.fetchDbVersionImpl();
            }
        };
        String vString = this.lockForOperation(oper, VERSION_10G_STRING);
        Matcher matcher = s_pattern.matcher(vString);
        String num = matcher.find() ? matcher.group() : "1.0.0";
        return new Version(num);
    }

    protected String fetchDbVersionImpl() throws SQLException, ThreadDeath {
        Object result;
        DatabaseMetaData dmd = null;
        dmd = this.m_conn.getMetaData();
        try {
            result = dmd.getDatabaseMajorVersion() + "." + dmd.getDatabaseMinorVersion() + ".0";
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            try {
                result = dmd.getDatabaseProductVersion();
            }
            catch (UnsupportedOperationException upe2) {
                result = "1.0.0";
            }
        }
        return result;
    }

    public final String getCurrentError() {
        return m_currentErrorString != null ? m_currentErrorString : EMPTY_STRING;
    }

    public int getErrorOffset(String sql) {
        throw new UnsupportedOperationException("getErrorOffset");
    }

    public static String addDoubleQuote(String s) {
        return DBUtil.quoteIdentifier(s, '\"');
    }

    public void setRaiseError(boolean b) {
        this.m_raiseError = b;
    }

    public static String quoteIdentifier(String identifier, char quoteChar) {
        return OracleUtil.getReservedWords().contains(identifier) ? quoteChar + identifier + quoteChar : Service.quoteIdentifier((String)identifier, (char)quoteChar);
    }

    public String cleanIdentifier(String s, List<String> ids, String type, char quoteChar, Locale locale) {
        CLEAN_TYPE cl = CLEAN_TYPE.TRANSFORM;
        try {
            cl = CLEAN_TYPE.valueOf(type);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.cleanIdentifier(s, ids, cl, quoteChar, locale);
    }

    public String cleanIdentifier(String s, List<String> uniqueIds, CLEAN_TYPE clean, char quoteChar, Locale locale) {
        String cleanStr;
        String string = cleanStr = clean != null ? clean.toString() : CLEAN_TYPE.TRANSFORM.toString();
        if (cleanStr.equals(CLEAN_TYPE.TRANSFORM.toString())) {
            cleanStr = this.getMaxStringSize().equals(SIZE_EXTENDED) ? CLEAN_TYPE.TRANSFORM128.toString() : CLEAN_TYPE.TRANSFORM30.toString();
        } else if (cleanStr.equals(CLEAN_TYPE.QUOTE.toString())) {
            cleanStr = this.getMaxStringSize().equals(SIZE_EXTENDED) ? CLEAN_TYPE.QUOTE128.toString() : CLEAN_TYPE.QUOTE30.toString();
        }
        return Service.cleanIdentifier(s, uniqueIds, cleanStr, quoteChar, locale);
    }

    public static List<String> getBindNames(String in) {
        return Parser.getInstance().getBindNames(in);
    }

    public static List<String> getBindNames(String in, boolean all) {
        return Parser.getInstance().getBindNames(in, all);
    }

    public static List<Bind> getBinds(String in, boolean all) {
        return Parser.getInstance().getBinds(in, all);
    }

    public static void bind(String sql, PreparedStatement stmt, Map bindMap) throws SQLException {
        if (bindMap != null) {
            HashMap binds = new HashMap();
            Iterator iter = bindMap.keySet().iterator();
            String bindName = null;
            Object bindValue = null;
            HashSet<String> bindsUsed = new HashSet<String>(DBUtil.getBindNames(sql));
            while (iter.hasNext()) {
                bindName = (String)iter.next();
                bindValue = bindMap.get(bindName);
                if (!bindsUsed.contains(bindName.intern())) continue;
                binds.put(bindName, bindMap.get(bindName));
            }
            DBUtil.bind(stmt, binds);
        }
    }

    public String scrubObjectName(String s) {
        return s.indexOf(QUOTE_DELIMITER) > -1 ? s.replaceAll(QUOTE_DELIMITER, EMPTY_STRING) : s.toUpperCase();
    }

    public static String[] resolveDBLink(String object) {
        String[] s = object.split("@");
        return s.length == 2 ? s : null;
    }

    public Map<String, String> resolveName(String descr) {
        return this.resolveName(descr, false, false);
    }

    public Map<String, String> resolveName(String descr, boolean withPackageBody, boolean ignoreSynonyms) {
        return null;
    }

    public final String prepareOracleSql(String query) {
        ArrayList<Bind> parsedBinds = Parser.getInstance().getBinds(query, true);
        HashSet<String> cmp = new HashSet<String>();
        for (Bind b : parsedBinds) {
            cmp.add(b.getName());
        }
        if (cmp.size() == parsedBinds.size()) {
            return query;
        }
        Object sql = query;
        int adjust = 0;
        int count = 1;
        for (Bind b : parsedBinds) {
            String newBind = ":ZSqlDevUnIq" + count;
            int begin = b.getBegin();
            int end = b.getEnd();
            sql = ((String)sql).substring(0, begin + adjust) + newBind + ((String)sql).substring(end + adjust);
            adjust += newBind.length() - end + begin;
            ++count;
        }
        return sql;
    }

    public final String prepareNonOracleSql(String query) {
        ArrayList<Bind> parserdBinds = Parser.getInstance().getBinds(query, true);
        int adjust = 0;
        Object sql = query;
        for (Bind b : parserdBinds) {
            String newBind = "?";
            int begin = b.getBegin();
            int end = b.getEnd();
            sql = ((String)sql).substring(0, begin + adjust) + newBind + ((String)sql).substring(end + adjust);
            adjust += newBind.length() - end + begin;
        }
        return sql;
    }

    protected PreparedStatement prepareQuery(String query) throws SQLException {
        String sql = this.prepareNonOracleSql(query);
        return this.getPrepared(sql);
    }

    public final PrepareResult prepareNonOracleSql(String query, Map<String, ?> binds) {
        if (query.indexOf("{:") != -1) {
            query = this.prepareNonOracleSqlMsgFormat(query, binds).getSQL();
        }
        ArrayList<Bind> parserdBinds = Parser.getInstance().getBinds(query, true);
        ArrayList<Object> bindList = new ArrayList<Object>();
        String sql = query;
        for (Bind b : parserdBinds) {
            if (binds != null) {
                bindList.add(binds.get(b.getName()));
            }
            sql = sql.replaceFirst(":" + b.getName(), "?");
        }
        return new PrepareResult(sql, bindList);
    }

    private PrepareResult prepareNonOracleSqlMsgFormat(String query, Map<String, ?> binds) {
        int index = 0;
        String formatSql = query;
        ArrayList<Bind> parserdBinds = Parser.getInstance().getBinds(query, true);
        ArrayList<Object> bindList = new ArrayList<Object>();
        String sql = query;
        for (Bind b : parserdBinds) {
            if (binds == null) continue;
            String bindName = b.getName();
            Object bind = binds.get(bindName);
            if (bind instanceof String) {
                String bindValue = (String)bind;
                String cs = " ";
                bindValue = bindValue.contains(cs) ? this.addDbQuotes(bindValue, true) : this.addDbQuotes(bindValue, false);
                bindList.add(bindValue);
            } else {
                bindList.add(bind);
            }
            sql = sql.replaceFirst("\\{:" + bindName, "{" + Integer.toString(index++));
        }
        sql = sql.replaceAll("'", "''");
        formatSql = MessageFormat.format(sql, bindList.toArray());
        return new PrepareResult(formatSql, bindList);
    }

    public final String addDbQuotes(String value) {
        return this.addDbQuotes(value, true);
    }

    public String addDbQuotes(String value, boolean force) {
        char quoteChar = this.getQuoteCharacter();
        if (force) {
            return value.indexOf(quoteChar) >= 0 ? value : quoteChar + value + quoteChar;
        }
        return DBUtil.quoteIdentifier(value, quoteChar);
    }

    protected char getQuoteCharacter() {
        return '\"';
    }

    public final SQLException getLastException() {
        SQLException ex = this.peekLastException();
        this.clearLastException();
        return ex;
    }

    private void clearLastException() {
        this.m_lastException.set(null);
    }

    private void setLastException(SQLException ex) {
        this.m_lastException.set(ex);
    }

    private SQLException peekLastException() {
        return this.m_lastException.get();
    }

    private void handleException(SQLException ex, String sql) {
        SQLException old = this.getLastException();
        if (old != null) {
            LOGGER.severe(MessageFormat.format(Messages.getString("DBUtil_UNHANDLED_EXCEPTION"), old.getLocalizedMessage()));
        }
        if (this.m_raiseError) {
            ExceptionHandler.handleException(ex, this.mName, sql, -1);
        } else {
            this.setLastException(ex);
        }
    }

    public static void main(String[] dummy) throws Exception {
        String banner = "Oracle Database 11g Enterprise Edition Release 11.2.0.1.0 - 64bit Production";
        String[] first = banner.split(" ");
        String regex = ".*[0-9]\\.+[0-9]\\.+.*";
        String version = null;
        for (String s : first) {
            System.out.println(s);
            if (!Pattern.matches(regex, s)) continue;
            version = s;
            System.out.println("--Matched");
        }
    }

    public static boolean hasTransaction(String connName) {
        return DBUtil.getInstance(connName).hasTransaction();
    }

    public static boolean hasTransaction(Connection conn) {
        return DBUtil.getInstance(conn).hasTransaction();
    }

    protected boolean hasTransaction() {
        throw new UnsupportedOperationException("hasTransaction");
    }

    public static boolean isOracleConnectionAlive(Connection oracleConn) {
        if (oracleConn == null) {
            return false;
        }
        return DBUtil.getInstance(oracleConn).isOracleConnectionAlive();
    }

    protected boolean isOracleConnectionAlive() {
        throw new UnsupportedOperationException("isOracleConnectionAlive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V> V lockForOperation(LockableOperation<V> operation, V defaultValue) {
        V value = defaultValue;
        Connection conn = operation.getConnection();
        if (LockManager.lock(conn)) {
            try {
                SQLException previousException = this.peekLastException();
                value = operation.call();
                if (previousException == this.peekLastException()) {
                    this.clearLastException();
                }
            }
            catch (SQLException e) {
                this.handleException(e, operation.getSQL());
            }
            catch (Exception e) {
                if (this.m_raiseError) {
                    ExceptionHandler.handleException(e);
                } else {
                    m_currentErrorString = e.getMessage();
                    LOGGER.info(e.getMessage());
                }
            }
            finally {
                LockManager.unlock(conn);
            }
        }
        return value;
    }

    private static <V> V assertLock(LockableOperation<V> operation) throws Exception {
        if (DEBUG_BUILD && s_lockCheckCount.get() == 0 && !LockManager.checkLock(operation.getConnection())) {
            IllegalMonitorStateException e = new IllegalMonitorStateException(Messages.getString("DBUtil.112"));
            DBUtil.logStateException(e, "Illegal Lock State: {0} requires connection lock to be held. {1} called {2} without it");
        }
        s_lockCheckCount.set(s_lockCheckCount.get() + 1);
        try {
            Object v = operation.call();
            return v;
        }
        finally {
            s_lockCheckCount.set(s_lockCheckCount.get() - 1);
        }
    }

    private static void logStateException(Exception e, String logMsg) {
        StackTraceElement[] trace = e.getStackTrace();
        int level = 1;
        StackTraceElement top = trace[level++];
        String topClass = top.getClassName();
        StackTraceElement entryPoint = null;
        StackTraceElement caller = null;
        while (level < trace.length) {
            StackTraceElement element = trace[level];
            if (!topClass.equals(element.getClassName())) {
                entryPoint = trace[level - 1];
                caller = element;
                break;
            }
            ++level;
        }
        Object[] fmtArgs = new Object[]{top.getMethodName(), caller.toString(), entryPoint.toString()};
        MessageLogging.getInstance().reportAPIException(MessageFormat.format(logMsg, fmtArgs), e, top.getMethodName());
        LOGGER.log(Level.SEVERE, logMsg, fmtArgs);
    }

    protected static void cleanup(Statement stmt) {
        DBUtil.cleanup(stmt, null);
    }

    protected static void cleanup(ResultSet rs) {
        if (rs != null) {
            Statement stmt = null;
            try {
                stmt = rs.getStatement();
            }
            catch (SQLException ex) {
                LOGGER.warning(ex.getLocalizedMessage());
            }
            DBUtil.cleanup(stmt, rs);
        }
    }

    protected static void cleanup(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception ex) {
                LOGGER.warning(ex.getLocalizedMessage());
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception ex) {
                LOGGER.warning(ex.getLocalizedMessage());
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        DBUtil.cleanup(rs);
    }

    public final boolean checkAccess(String s) {
        return this.checkAccessImpl(s);
    }

    protected boolean checkAccessImpl(String s) {
        boolean hasAccess = false;
        try (Statement stmt = this.getStatement();){
            String sql = "select 1 from " + s + " where 1=2";
            stmt.execute(sql);
            hasAccess = true;
        }
        catch (SQLException e) {
            LOGGER.finest(s + oracle.dbtools.raptor.query.Messages.getString("QueryUtils.31"));
        }
        return hasAccess;
    }

    public final int getMaxNameLength() {
        return this.getMaxNameLengthImpl();
    }

    protected int getMaxNameLengthImpl() {
        return 30;
    }

    public final String getMaxStringSize() {
        return this.getMaxStringSizeImpl();
    }

    protected String getMaxStringSizeImpl() {
        return SIZE_STANDARD;
    }

    public final String getV$Parameter(String name) {
        return this.getV$ParameterImpl(name);
    }

    protected String getV$ParameterImpl(String name) {
        return null;
    }

    static {
        s_staticFactories = new ArrayList<DBUtilImplFactory>();
        s_loader = ServiceLoader.load(DBUtilImplFactory.class);
        s_pattern = Pattern.compile(VERSION_PATTERN);
        ORACLE8_VERSION = new Version("8");
        ORACLE8i_VERSION = new Version("8.1");
        ORACLE9i_VERSION = new Version("9");
        ORACLE9iR2_VERSION = new Version("9.2");
        ORACLE10g_VERSION = new Version(VERSION_10G_STRING);
        ORACLE10gR2_VERSION = new Version("10.2");
        ORACLE11g_VERSION = new Version("11");
        ORACLE12c_VERSION = new Version("12");
        DEBUG_BUILD = Boolean.getBoolean("sqldev.debugbuild");
        s_lockCheckCount = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
    }

    private static abstract class StatementOperImpl<V>
    implements LockableOperation<V> {
        private Connection m_conn;

        private StatementOperImpl(Statement stmt) throws SQLException {
            this.m_conn = stmt.getConnection();
        }

        @Override
        public Connection getConnection() {
            return this.m_conn;
        }

        @Override
        public String getSQL() {
            return null;
        }

        @Override
        public int getOffset() {
            return -1;
        }
    }

    protected abstract class OperImpl<V>
    implements LockableOperation<V> {
        protected OperImpl() {
        }

        @Override
        public Connection getConnection() {
            return DBUtil.this.m_conn;
        }

        @Override
        public String getSQL() {
            return null;
        }

        @Override
        public int getOffset() {
            return -1;
        }
    }

    protected static interface LockableOperation<V>
    extends Callable<V> {
        public Connection getConnection();

        public String getSQL();

        public int getOffset();
    }

    public static enum CLEAN_TYPE {
        OFF,
        TRANSFORM,
        TRANSFORM30,
        TRANSFORM128,
        QUOTE,
        QUOTE30,
        QUOTE128,
        UNIQUE;

    }
}

