/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.security;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.security.SecureReferenceData;
import oracle.dbtools.connections.security.SecureReferencePair;
import oracle.dbtools.core.secrets.BinarySecret;
import oracle.dbtools.core.secrets.Secrets;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.util.Logger;

public abstract class ReferenceWorker<T> {
    public static final String KEY = ReferenceWorker.class.getName();

    public final SecureReferencePair<T> encrypt(String key, TextSecret data, String connectionName) {
        return SecureReferencePair.createSecureReference(key, this.encryptValue(key, data, connectionName));
    }

    protected abstract SecureReferenceData<T> encryptValue(String var1, TextSecret var2, String var3);

    public final TextSecret decrypt(SecureReferencePair<T> ref, String connectionName) {
        return this.decryptValue(ref.getKey(), (SecureReferenceData<T>)ref.getValue(), connectionName);
    }

    protected TextSecret decryptValue(String name, SecureReferenceData<T> value, String connectionName) {
        return null;
    }

    public final void updateExternalReferences(String oldConnName, String newConnName) {
    }

    protected void updateReferences(String oldConnName, String newConnName) {
    }

    public static ReferenceWorker<char[]> createNullWorker() {
        return new ReferenceWorker<char[]>(){

            @Override
            public SecureReferenceData<char[]> encryptValue(String name, TextSecret value, String connectionName) {
                return null;
            }
        };
    }

    public static ReferenceWorker<char[]> createDefaultWorker(TextSecret key) {
        return new AESGCMWorker(key, new AESWorker(key, new PBEWorker(key)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecretKey getSecretKey(TextSecret passPhrase) {
        SecretKeySpec key = null;
        char[] passPhraseChars = (char[])passPhrase.map(p -> Arrays.copyOf(p, p.length));
        try {
            byte[] salt = new byte[]{6, -74, 97, 35, 61, 104, 50, -72};
            int iterationCount = 5000;
            int keysize = 256;
            PBEKeySpec keySpec = new PBEKeySpec(passPhraseChars, salt, 5000, 256);
            SecretKey tmp = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256").generateSecret(keySpec);
            key = new SecretKeySpec(tmp.getEncoded(), "AES");
        }
        catch (Exception e) {
            Logger.severe(ReferenceWorker.class, "setup failure", e);
        }
        finally {
            TextSecret.erase((char[])passPhraseChars);
        }
        return key;
    }

    private static class PBEWorker
    extends ReferenceWorker<char[]> {
        private final AlgorithmParameterSpec m_paramSpec;
        private final SecretKey m_key;
        private Cipher m_encoder;
        private Cipher m_decoder;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PBEWorker(TextSecret passPhrase) {
            PBEParameterSpec paramSpec = null;
            SecretKey key = null;
            char[] passPhraseChars = (char[])passPhrase.map(p -> Arrays.copyOf(p, p.length));
            try {
                byte[] salt = new byte[]{5, 19, -103, 66, -109, 114, -24, -83};
                int iterationCount = 42;
                PBEKeySpec keySpec = new PBEKeySpec(passPhraseChars, salt, 42);
                key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
                paramSpec = new PBEParameterSpec(salt, 42);
            }
            catch (Exception e) {
                Logger.severe(ReferenceWorker.class, "setup failure", e);
            }
            finally {
                TextSecret.erase((char[])passPhraseChars);
            }
            this.m_paramSpec = paramSpec;
            this.m_key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SecureReferenceData<char[]> encryptValue(String name, TextSecret value, String connectionName) {
            String encStr = null;
            if (this.m_key != null) {
                try {
                    if (this.m_encoder == null) {
                        this.m_encoder = Cipher.getInstance(this.m_key.getAlgorithm());
                        this.m_encoder.init(1, (Key)this.m_key, this.m_paramSpec);
                    }
                    BinarySecret binarySecret = value.asSecret();
                    byte[] utf8 = (byte[])binarySecret.map(p -> Arrays.copyOf(p, p.length));
                    try {
                        byte[] enc = this.m_encoder.doFinal(utf8);
                        encStr = Base64.getEncoder().encodeToString(enc);
                    }
                    finally {
                        BinarySecret.erase((byte[])utf8);
                    }
                }
                catch (Exception e) {
                    String msg = "Password encryption failed for connection " + connectionName;
                    Logger.severe(ReferenceWorker.class, msg);
                    Logger.fine(ReferenceWorker.class, msg, e);
                    this.m_encoder = null;
                }
            }
            return SecureReferenceData.buildCredentialReference(encStr.toCharArray());
        }

        @Override
        public TextSecret decryptValue(String name, SecureReferenceData<char[]> value, String connectionName) {
            TextSecret retval = null;
            if (this.m_key != null) {
                try {
                    if (this.m_decoder == null) {
                        this.m_decoder = Cipher.getInstance(this.m_key.getAlgorithm());
                        this.m_decoder.init(2, (Key)this.m_key, this.m_paramSpec);
                    }
                    byte[] dec = Base64.getDecoder().decode(new String(value.getValue()));
                    byte[] utf8 = this.m_decoder.doFinal(dec);
                    retval = TextSecret.of((BinarySecret)Secrets.instance().of(utf8, true));
                }
                catch (Exception e) {
                    String msg = "Password decryption failed for connection " + connectionName;
                    Logger.warn(ReferenceWorker.class, msg);
                    Logger.fine(ReferenceWorker.class, msg, e);
                    this.m_decoder = null;
                }
            }
            if (retval == null) {
                return super.decryptValue(name, value, connectionName);
            }
            return retval;
        }
    }

    private static class AESWorker
    extends ReferenceWorker<char[]> {
        private final SecretKey m_key;
        private final ReferenceWorker<char[]> m_fallback;

        AESWorker(TextSecret passPhrase, ReferenceWorker<char[]> fallback) {
            this.m_key = ReferenceWorker.getSecretKey(passPhrase);
            this.m_fallback = fallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SecureReferenceData<char[]> encryptValue(String name, TextSecret value, String connectionName) {
            String encStr = null;
            if (this.m_key != null) {
                try {
                    Cipher encoder = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    encoder.init(1, this.m_key);
                    AlgorithmParameters params = encoder.getParameters();
                    byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
                    BinarySecret binarySecret = value.asSecret();
                    byte[] utf8 = (byte[])binarySecret.map(p -> Arrays.copyOf(p, p.length));
                    try {
                        byte[] enc = encoder.doFinal(utf8);
                        byte[] data = new byte[iv.length + enc.length];
                        System.arraycopy(iv, 0, data, 0, iv.length);
                        System.arraycopy(enc, 0, data, iv.length, enc.length);
                        encStr = Base64.getEncoder().encodeToString(data);
                    }
                    finally {
                        BinarySecret.erase((byte[])utf8);
                    }
                }
                catch (Exception e) {
                    String msg = "Password encryption failed for connection " + connectionName;
                    Logger.severe(ReferenceWorker.class, msg);
                    Logger.fine(ReferenceWorker.class, msg, e);
                }
            }
            return SecureReferenceData.buildCredentialReference(encStr.toCharArray());
        }

        @Override
        public TextSecret decryptValue(String name, SecureReferenceData<char[]> value, String connectionName) {
            TextSecret retval;
            block9: {
                retval = null;
                if (this.m_key != null) {
                    boolean triedFallback = false;
                    try {
                        byte[] data = Base64.getDecoder().decode(new String(value.getValue()));
                        if (data.length <= 16) {
                            triedFallback = true;
                            retval = this.m_fallback.decryptValue(name, value, connectionName);
                        } else {
                            byte[] iv = new byte[16];
                            byte[] dec = new byte[data.length - 16];
                            System.arraycopy(data, 0, iv, 0, 16);
                            System.arraycopy(data, 16, dec, 0, dec.length);
                            Cipher decoder = Cipher.getInstance("AES/CBC/PKCS5Padding");
                            decoder.init(2, (Key)this.m_key, new IvParameterSpec(iv));
                            byte[] utf8 = decoder.doFinal(dec);
                            if (utf8 == null || utf8.length == 0) {
                                triedFallback = true;
                                retval = this.m_fallback.decryptValue(name, value, connectionName);
                            } else {
                                retval = TextSecret.of((BinarySecret)Secrets.instance().of(utf8, true));
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!triedFallback) {
                            retval = this.m_fallback.decryptValue(name, value, connectionName);
                        }
                        if (retval != null) break block9;
                        String msg = "Password decryption failed for connection " + connectionName;
                        Logger.warn(ReferenceWorker.class, msg);
                        Logger.fine(ReferenceWorker.class, msg, e);
                    }
                }
            }
            if (retval == null) {
                return super.decryptValue(name, value, connectionName);
            }
            return retval;
        }
    }

    private static class AESGCMWorker
    extends ReferenceWorker<char[]> {
        private static final int GCM_IV_LENGTH = 12;
        private final SecureRandom secureRandom = new SecureRandom();
        private final SecretKey secretKey;
        private final ReferenceWorker<char[]> fallbackWorker;

        AESGCMWorker(TextSecret passPhrase, ReferenceWorker<char[]> fallback) {
            this.secretKey = ReferenceWorker.getSecretKey(passPhrase);
            this.fallbackWorker = fallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected SecureReferenceData<char[]> encryptValue(String name, TextSecret value, String connectionName) {
            String encString = null;
            if (this.secretKey != null) {
                try {
                    byte[] iv = new byte[12];
                    this.secureRandom.nextBytes(iv);
                    Cipher encoder = AESGCMWorker.getCipher();
                    GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
                    encoder.init(1, (Key)this.secretKey, parameterSpec);
                    if (ModelUtil.hasLength(name)) {
                        encoder.updateAAD(name.getBytes(StandardCharsets.UTF_8));
                    }
                    byte[] valueBytes = (byte[])value.asSecret().map(p -> Arrays.copyOf(p, p.length));
                    try {
                        byte[] cipherText = encoder.doFinal(valueBytes, 0, valueBytes.length);
                        ByteBuffer byteBuffer = ByteBuffer.allocate(iv.length + cipherText.length);
                        byteBuffer.put(iv);
                        byteBuffer.put(cipherText);
                        encString = Base64.getEncoder().encodeToString(byteBuffer.array());
                    }
                    finally {
                        BinarySecret.erase((byte[])valueBytes);
                    }
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                    String msg = "Password encryption failed for connection " + connectionName;
                    Logger.severe(ReferenceWorker.class, msg);
                    Logger.fine(ReferenceWorker.class, msg, e);
                }
            }
            return SecureReferenceData.buildCredentialReference(encString.toCharArray());
        }

        private static Cipher getCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
            return Cipher.getInstance("AES/GCM/NoPadding");
        }

        @Override
        protected TextSecret decryptValue(String name, SecureReferenceData<char[]> value, String connectionName) {
            TextSecret retval;
            block13: {
                retval = null;
                if (this.secretKey != null) {
                    byte[] data;
                    try {
                        String s = new String(value.getValue());
                        data = Base64.getDecoder().decode(s);
                    }
                    catch (IllegalArgumentException e) {
                        Logger.warn(ReferenceWorker.class, MessageFormat.format("Invalid secure value format for key {0} of {1}", name, connectionName));
                        return null;
                    }
                    if (data.length <= 12) {
                        retval = this.fallbackWorker.decryptValue(name, value, connectionName);
                    } else {
                        GCMParameterSpec ivSpec = new GCMParameterSpec(128, data, 0, 12);
                        try {
                            Cipher decoder = AESGCMWorker.getCipher();
                            decoder.init(2, (Key)this.secretKey, ivSpec);
                            if (ModelUtil.hasLength(name)) {
                                decoder.updateAAD(name.getBytes(StandardCharsets.UTF_8));
                            }
                            try {
                                byte[] utf8 = decoder.doFinal(data, 12, data.length - 12);
                                if (utf8 == null || utf8.length == 0) {
                                    retval = this.fallbackWorker.decryptValue(name, value, connectionName);
                                    break block13;
                                }
                                retval = Secrets.instance().of(utf8, true).asText();
                            }
                            catch (AEADBadTagException e) {
                                Logger.info(ReferenceWorker.class, MessageFormat.format("Invalid key for {0} on {1}", name, connectionName));
                                retval = this.fallbackWorker.decryptValue(name, value, connectionName);
                            }
                            catch (BadPaddingException | IllegalBlockSizeException e) {
                                retval = this.fallbackWorker.decryptValue(name, value, connectionName);
                            }
                        }
                        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                            Logger.warn(ReferenceWorker.class, e);
                            retval = this.fallbackWorker.decryptValue(name, value, connectionName);
                        }
                    }
                }
            }
            if (retval == null) {
                retval = super.decryptValue(name, value, connectionName);
            }
            return retval;
        }
    }
}

