/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.db.ora;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.connections.db.AbstractConnectionCreator;
import oracle.dbtools.connections.db.DBAdapterBundle;
import oracle.dbtools.connections.db.DatabaseProviderHelper;
import oracle.dbtools.connections.db.ora.ConnectionWrapperProvider;
import oracle.dbtools.connections.db.ora.CustomOptionsConfiguration;
import oracle.dbtools.connections.db.ora.OracleConnectionUtils;
import oracle.dbtools.connections.db.ora.OracleSubtypeConfigurator;
import oracle.dbtools.connections.db.ora.PasswordPrompterProvider;
import oracle.dbtools.jdbc.DataSourceBuilder;
import oracle.dbtools.jdbc.DataSourceConfigurator;
import oracle.dbtools.jdbc.OracleDataSources;
import oracle.dbtools.jdbc.configurators.SessionConfiguration;
import oracle.dbtools.jdbc.configurators.SimpleCredentialsConfiguration;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.WindowsUtility;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.datasource.OracleDataSource;

public class OracleConnectionCreator
extends AbstractConnectionCreator {
    public static final String ORACLE_DRIVER_CLASS = "oracle.jdbc.OracleDriver";
    public static final String OLD_ORACLE_DRIVER_CLASS = "oracle.jdbc.driver.OracleDriver";
    public static final String SUBTYPE_ORA_JDBC = "oraJDBC";
    public static final String ORA_DRIVER_TYPE_CLASS_REFTYPE = "oraDriverType";
    public static final String ORA_DRIVER_THIN = "thin";
    public static final String ORA_DRIVER_OCI8 = "oci8";
    public static final String EXPORT_PASSWORD_CHECKSUM = "ExportKeyChecksum";
    private static final Logger LOGGER = Logger.getLogger(OracleConnectionCreator.class.getName());
    private final boolean thickAvailable;
    private final PasswordPrompterProvider support;
    private final ConnectionWrapperProvider wrapperProvider;
    private static final Collection<String> PASSWORD_RESET_OPTIONS = Arrays.asList("oracle.jdbc.newPassword");
    private static final Collection<String> KERBEROS_OPTIONS = Arrays.asList("oracle.net.authentication_services", "oracle.net.kerberos5_cc_name", "oracle.net.authentication_services", "oracle.net.kerberos5_mutual_authentication", "oracle.net.kerberos5_cc_name", "access.alternate.url");

    private static boolean isThick(String url) {
        return url.startsWith("jdbc:oracle:oci");
    }

    public static OracleConnectionCreator newInstance() {
        return OracleConnectionCreator.newInstance(false, PasswordPrompterProvider.DEFAULT, ConnectionWrapperProvider.DEFAULT);
    }

    public static OracleConnectionCreator newInstance(boolean thickAvailable, PasswordPrompterProvider prompterProvider, ConnectionWrapperProvider wrapperProvider) {
        assert (prompterProvider != null);
        assert (wrapperProvider != null);
        return new OracleConnectionCreator(thickAvailable, prompterProvider, wrapperProvider);
    }

    private OracleConnectionCreator(boolean thickAvailable, PasswordPrompterProvider prompterProvider, ConnectionWrapperProvider wrapperProvider) {
        this.thickAvailable = thickAvailable;
        this.support = prompterProvider;
        this.wrapperProvider = wrapperProvider;
    }

    @Override
    public boolean isPath(String propName) {
        return OracleSubtypeConfigurator.isPathProperty(propName);
    }

    @Override
    public boolean shouldPromptForPassword(Properties props) {
        return true;
    }

    @Override
    public final Connection getConnection(Properties props) throws SQLException {
        OracleDataSources.Builder builder = OracleDataSources.instance().builder();
        try {
            this.configure((DataSourceBuilder<?>)builder, props);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        OracleDataSource ds = (OracleDataSource)builder.build();
        String url = ds.getURL();
        Connection conn = !OracleConnectionCreator.isThick(url) && Boolean.parseBoolean(props.getProperty("KERBEROS_AUTHENTICATION")) ? this.connectWithKerberos(ds, props) : this.getConnectionImpl(ds, props);
        if (Boolean.parseBoolean(props.getProperty("IS_PROXY"))) {
            this.openProxySession(conn, props);
        }
        return conn;
    }

    protected void configure(DataSourceBuilder<?> dataSourceBuilder, Properties props) throws SQLException, IOException {
        SessionConfiguration sessionConfig = OracleConnectionCreator.configureSessionProperties(props);
        sessionConfig.configure(dataSourceBuilder);
        String subtype = props.getProperty("OracleConnectionType");
        OracleSubtypeConfigurator<DataSourceConfigurator> subtypeSupport = OracleSubtypeConfigurator.lookupConfiguration(subtype);
        DataSourceConfigurator typeConfig = subtypeSupport.createConfigurator(props);
        typeConfig.configure(dataSourceBuilder);
        CustomOptionsConfiguration opsConfig = OracleConnectionCreator.configureCustomProperties(props);
        opsConfig.configure(dataSourceBuilder);
        DataSourceConfigurator authConfig = OracleConnectionCreator.configureAuthenticationProperties(props);
        authConfig.configure(dataSourceBuilder);
    }

    private static Properties filterProperties(Properties props, Collection<String> keys) {
        Properties result = new Properties();
        for (String key : keys) {
            String value = props.getProperty(key);
            if (value == null) continue;
            result.setProperty(key, value);
        }
        return result;
    }

    private static CustomOptionsConfiguration configureCustomProperties(Properties props) {
        Properties customProps = new Properties();
        String url = props.getProperty("customUrl");
        if (Boolean.parseBoolean(props.getProperty("OS_AUTHENTICATION"))) {
            String driverType = OracleConnectionUtils.scrubOraDriverType(url);
            if (PlatformUtils.isWindows() && ORA_DRIVER_THIN.equalsIgnoreCase(driverType)) {
                customProps.setProperty("v$session.osuser", WindowsUtility.getUserWithDomain());
            }
        }
        customProps.putAll((Map<?, ?>)OracleConnectionCreator.filterProperties(props, PASSWORD_RESET_OPTIONS));
        customProps.putAll((Map<?, ?>)OracleConnectionCreator.filterProperties(props, KERBEROS_OPTIONS));
        props.stringPropertyNames().stream().filter(s -> s.startsWith("sqldev.advanced.")).forEach(s -> customProps.put(s.substring("sqldev.advanced.".length()), props.getProperty((String)s)));
        CustomOptionsConfiguration.Builder builder = CustomOptionsConfiguration.builder();
        builder.connectionProperties(customProps);
        return builder.build();
    }

    private static SessionConfiguration configureSessionProperties(Properties props) {
        String process;
        String program;
        String machine;
        SessionConfiguration.Builder sessionBuilder = SessionConfiguration.builder();
        String terminal = props.getProperty("jdbc.terminal");
        if (terminal != null) {
            sessionBuilder = sessionBuilder.terminal(terminal);
        }
        if ((machine = props.getProperty("jdbc.machine")) != null) {
            if (machine != null && machine.length() > 60) {
                machine = machine.substring(0, 60);
            }
            sessionBuilder = sessionBuilder.machine(machine);
        }
        if ((program = System.getProperty("jdbc.program", null)) == null) {
            program = DatabaseProviderHelper.getProgramName();
        }
        if (program != null) {
            sessionBuilder = sessionBuilder.programName(program);
        }
        if ((process = System.getProperty("jdbc.process", null)) == null) {
            String jvm = System.getProperty("java.vm.name");
            if (!(System.getProperty("disablePIDCheck") != null || jvm != null && jvm.equals("OJVM Client VM"))) {
                try {
                    int at;
                    String beanName;
                    RuntimeMXBean rtbean = ManagementFactory.getRuntimeMXBean();
                    if (rtbean != null && (beanName = rtbean.getName()) != null && (at = beanName.indexOf(64)) >= 0) {
                        process = beanName.substring(0, at);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (process != null) {
            sessionBuilder = sessionBuilder.process(process);
        }
        sessionBuilder = sessionBuilder.timeout(300000);
        return sessionBuilder.build();
    }

    private static DataSourceConfigurator configureAuthenticationProperties(Properties props) {
        return SimpleCredentialsConfiguration.builder((Properties)props).build();
    }

    protected Connection getConnectionImpl(OracleDataSource ds, Properties props) throws SQLException {
        return this.wrapperProvider.wrapConnection(ds.getConnection(), props);
    }

    private Connection connectWithKerberos(OracleDataSource ds, Properties props) throws SQLException {
        return this.getConnectionImpl(ds, props);
    }

    @Override
    protected boolean allowNullPassword() {
        return true;
    }

    private static void updateProperty(Properties origProps, Properties newProps, String key) {
        String value = origProps.getProperty(key);
        if (value != null) {
            newProps.setProperty(key, value);
        }
    }

    @Override
    protected void setCustomProperties(Properties connProps, Properties jdbcProps) {
    }

    private void openProxySession(Connection conn, Properties props) throws SQLException {
        String proxyType = props.getProperty("PROXY_TYPE");
        Properties proxyProps = new Properties();
        if (proxyType.equals("USER NAME")) {
            String proxyUser = props.getProperty("PROXY_USER_NAME");
            String proxyPasswd = props.getProperty("PROXY_USER_PASSWORD");
            proxyProps.put("PROXY_USER_NAME", proxyUser);
            if (proxyPasswd != null && proxyPasswd.length() > 0) {
                proxyProps.put("PROXY_USER_PASSWORD", proxyPasswd);
            }
            ((OracleConnection)conn).openProxySession(1, proxyProps);
        } else if (proxyType.equals("DISTINGUISHED NAME")) {
            proxyProps.put("PROXY_USER_NAME", props.getProperty("PROXY_USER_NAME"));
            proxyProps.put("PROXY_DISTINGUISHED_NAME", props.getProperty("PROXY_DISTINGUISHED_NAME"));
            ((OracleConnection)conn).openProxySession(2, proxyProps);
        }
    }

    String getPassword(Properties props) throws ConnectionCanceledException {
        return this.support.promptForPassword(props);
    }

    @Override
    public boolean shouldEncrypt(String propName) {
        boolean encrypt = false;
        if (EXPORT_PASSWORD_CHECKSUM.equals(propName)) {
            encrypt = true;
        } else if ("PROXY_USER_PASSWORD".equals(propName)) {
            encrypt = true;
        }
        return encrypt || super.shouldEncrypt(propName);
    }

    private static void addPropertyIfSet(Properties jdbcProps, String sysPropName, String propName) {
        String value = System.getProperty(sysPropName, null);
        if (value != null) {
            OracleConnectionCreator.setProperty(jdbcProps, propName, value);
        }
    }

    private static void setProperty(Properties jdbcProps, String propName, String value) {
        if (value != null) {
            jdbcProps.setProperty(propName, value);
        }
    }

    @Override
    public String getConnectionURL(Properties props) throws SQLException {
        String customURL = super.getConnectionURL(props);
        if (this.hasLength(customURL)) {
            return customURL;
        }
        String hostname = this.getPropertyOrThrow(props, "hostname");
        String port = this.getPropertyOrThrow(props, "port");
        String sid = props.getProperty("sid");
        String servicename = props.getProperty("serviceName");
        String oraDriverType = this.getPropertyOrThrow(props, ORA_DRIVER_TYPE_CLASS_REFTYPE);
        if (ORA_DRIVER_THIN.equals(oraDriverType)) {
            if (sid != null) {
                return "jdbc:oracle:thin:@" + hostname + ":" + port + ":" + sid;
            }
            if (servicename != null) {
                return "jdbc:oracle:thin:@//" + hostname + ":" + port + "/" + servicename;
            }
            throw new SQLException(DBAdapterBundle.get("ERROR_SID_SERVICE_NAME"));
        }
        if (ORA_DRIVER_OCI8.equals(oraDriverType)) {
            StringBuilder url = new StringBuilder();
            url.append("jdbc:oracle:oci8:@");
            url.append("(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=");
            url.append(hostname);
            url.append(")(PORT=");
            url.append(port);
            url.append("))(CONNECT_DATA=(");
            if (sid != null) {
                url.append("SID=").append(sid);
            } else if (servicename != null) {
                url.append("SERVICE_NAME=").append(servicename);
            } else {
                throw new SQLException(DBAdapterBundle.get("ERROR_SID_SERVICE_NAME"));
            }
            url.append(")))");
            return url.toString();
        }
        throw new SQLException("Unrecognized Oracle JDBC driver type: " + oraDriverType);
    }

    @Override
    public String getDriverClassName(Properties props) throws SQLException {
        String driverClassName = super.getDriverClassName(props);
        if (this.hasLength(driverClassName) && !driverClassName.equals(OLD_ORACLE_DRIVER_CLASS)) {
            return driverClassName;
        }
        return ORACLE_DRIVER_CLASS;
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> retval1 = super.listAllowedProperties();
        retval1.add("role");
        retval1.add("hostname");
        retval1.add("port");
        retval1.add("sid");
        Collection<String> retval = retval1;
        retval.add("serviceName");
        return retval;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("hostname");
        retval.add("port");
        retval.add(ORA_DRIVER_TYPE_CLASS_REFTYPE);
        return retval;
    }
}

